# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("ncrypt.dll")
prototypes = \
    {
        # 
        'NCryptOpenStorageProvider': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["phProvider", "pszProviderName", "dwFlags"]),
        # 
        'NCryptEnumAlgorithms': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="NCRYPT_OPERATION"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwClass": SimTypeInt(signed=False, label="NCRYPT_ALGORITHM_NAME_CLASS"), "dwAlgOperations": SimTypeInt(signed=False, label="NCRYPT_OPERATION"), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="NCryptAlgorithmName", pack=False, align=None), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProvider", "dwAlgOperations", "pdwAlgCount", "ppAlgList", "dwFlags"]),
        # 
        'NCryptIsAlgSupported': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProvider", "pszAlgId", "dwFlags"]),
        # 
        'NCryptEnumKeys': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszAlgid": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwLegacyKeySpec": SimTypeInt(signed=False, label="CERT_KEY_SPEC"), "dwFlags": SimTypeInt(signed=False, label="UInt32")}, name="NCryptKeyName", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypeInt(signed=False, label="NCRYPT_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProvider", "pszScope", "ppKeyName", "ppEnumState", "dwFlags"]),
        # 
        'NCryptEnumStorageProviders': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"pszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pszComment": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="NCryptProviderName", pack=False, align=None), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pdwProviderCount", "ppProviderList", "dwFlags"]),
        # 
        'NCryptFreeBuffer': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pvInput"]),
        # 
        'NCryptOpenKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="CERT_KEY_SPEC"), SimTypeInt(signed=False, label="NCRYPT_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProvider", "phKey", "pszKeyName", "dwLegacyKeySpec", "dwFlags"]),
        # 
        'NCryptCreatePersistedKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="CERT_KEY_SPEC"), SimTypeInt(signed=False, label="NCRYPT_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProvider", "phKey", "pszAlgId", "pszKeyName", "dwLegacyKeySpec", "dwFlags"]),
        # 
        'NCryptGetProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="OBJECT_SECURITY_INFORMATION")], SimTypeInt(signed=True, label="Int32"), arg_names=["hObject", "pszProperty", "pbOutput", "cbOutput", "pcbResult", "dwFlags"]),
        # 
        'NCryptSetProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="NCRYPT_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hObject", "pszProperty", "pbInput", "cbInput", "dwFlags"]),
        # 
        'NCryptFinalizeKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="NCRYPT_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "dwFlags"]),
        # 
        'NCryptEncrypt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="NCRYPT_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "pbInput", "cbInput", "pPaddingInfo", "pbOutput", "cbOutput", "pcbResult", "dwFlags"]),
        # 
        'NCryptDecrypt': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="NCRYPT_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "pbInput", "cbInput", "pPaddingInfo", "pbOutput", "cbOutput", "pcbResult", "dwFlags"]),
        # 
        'NCryptImportKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="BCryptBuffer", pack=False, align=None), offset=0)}, name="BCryptBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="NCRYPT_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProvider", "hImportKey", "pszBlobType", "pParameterList", "phKey", "pbData", "cbData", "dwFlags"]),
        # 
        'NCryptExportKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="BCryptBuffer", pack=False, align=None), offset=0)}, name="BCryptBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="NCRYPT_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "hExportKey", "pszBlobType", "pParameterList", "pbOutput", "cbOutput", "pcbResult", "dwFlags"]),
        # 
        'NCryptSignHash': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="NCRYPT_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "pPaddingInfo", "pbHashValue", "cbHashValue", "pbSignature", "cbSignature", "pcbResult", "dwFlags"]),
        # 
        'NCryptVerifySignature': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="NCRYPT_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "pPaddingInfo", "pbHashValue", "cbHashValue", "pbSignature", "cbSignature", "dwFlags"]),
        # 
        'NCryptDeleteKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "dwFlags"]),
        # 
        'NCryptFreeObject': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hObject"]),
        # 
        'NCryptIsKeyHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey"]),
        # 
        'NCryptTranslateHandle': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="CERT_KEY_SPEC"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["phProvider", "phKey", "hLegacyProv", "hLegacyKey", "dwLegacyKeySpec", "dwFlags"]),
        # 
        'NCryptNotifyChangeKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="NCRYPT_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hProvider", "phEvent", "dwFlags"]),
        # 
        'NCryptSecretAgreement': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="NCRYPT_FLAGS")], SimTypeInt(signed=True, label="Int32"), arg_names=["hPrivKey", "hPubKey", "phAgreedSecret", "dwFlags"]),
        # 
        'NCryptDeriveKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="BCryptBuffer", pack=False, align=None), offset=0)}, name="BCryptBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hSharedSecret", "pwszKDF", "pParameterList", "pbDerivedKey", "cbDerivedKey", "pcbResult", "dwFlags"]),
        # 
        'NCryptKeyDerivation': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="BCryptBuffer", pack=False, align=None), offset=0)}, name="BCryptBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hKey", "pParameterList", "pbDerivedKey", "cbDerivedKey", "pcbResult", "dwFlags"]),
        # 
        'NCryptCreateClaim': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="BCryptBuffer", pack=False, align=None), offset=0)}, name="BCryptBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hSubjectKey", "hAuthorityKey", "dwClaimType", "pParameterList", "pbClaimBlob", "cbClaimBlob", "pcbResult", "dwFlags"]),
        # 
        'NCryptVerifyClaim': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="BCryptBuffer", pack=False, align=None), offset=0)}, name="BCryptBufferDesc", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ulVersion": SimTypeInt(signed=False, label="UInt32"), "cBuffers": SimTypeInt(signed=False, label="UInt32"), "pBuffers": SimTypePointer(SimStruct({"cbBuffer": SimTypeInt(signed=False, label="UInt32"), "BufferType": SimTypeInt(signed=False, label="UInt32"), "pvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="BCryptBuffer", pack=False, align=None), offset=0)}, name="BCryptBufferDesc", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hSubjectKey", "hAuthorityKey", "dwClaimType", "pParameterList", "pbClaimBlob", "cbClaimBlob", "pOutput", "dwFlags"]),
        # 
        'NCryptRegisterProtectionDescriptorName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pwszName", "pwszDescriptorString", "dwFlags"]),
        # 
        'NCryptQueryProtectionDescriptorName': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pwszName", "pwszDescriptorString", "pcDescriptorString", "dwFlags"]),
        # 
        'NCryptCreateProtectionDescriptor': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwszDescriptorString", "dwFlags", "phDescriptor"]),
        # 
        'NCryptCloseProtectionDescriptor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hDescriptor"]),
        # 
        'NCryptGetProtectionDescriptorInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pfnAlloc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cbSize"]), offset=0), "pfnFree": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]), offset=0)}, name="NCRYPT_ALLOC_PARA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hDescriptor", "pMemPara", "dwInfoType", "ppvInfo"]),
        # 
        'NCryptProtectSecret': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pfnAlloc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cbSize"]), offset=0), "pfnFree": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]), offset=0)}, name="NCRYPT_ALLOC_PARA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hDescriptor", "dwFlags", "pbData", "cbData", "pMemPara", "hWnd", "ppbProtectedBlob", "pcbProtectedBlob"]),
        # 
        'NCryptUnprotectSecret': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="NCRYPT_FLAGS"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pfnAlloc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["cbSize"]), offset=0), "pfnFree": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pv"]), offset=0)}, name="NCRYPT_ALLOC_PARA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["phDescriptor", "dwFlags", "pbProtectedBlob", "cbProtectedBlob", "pMemPara", "hWnd", "ppbData", "pcbData"]),
        # 
        'NCryptStreamOpenToProtect': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"pfnStreamOutput": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackCtxt", "pbData", "cbData", "fFinal"]), offset=0), "pvCallbackCtxt": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NCRYPT_PROTECT_STREAM_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hDescriptor", "dwFlags", "hWnd", "pStreamInfo", "phStream"]),
        # 
        'NCryptStreamOpenToUnprotect': SimTypeFunction([SimTypePointer(SimStruct({"pfnStreamOutput": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackCtxt", "pbData", "cbData", "fFinal"]), offset=0), "pvCallbackCtxt": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NCRYPT_PROTECT_STREAM_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pStreamInfo", "dwFlags", "hWnd", "phStream"]),
        # 
        'NCryptStreamOpenToUnprotectEx': SimTypeFunction([SimTypePointer(SimStruct({"pfnStreamOutput": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeBottom(label="NCRYPT_DESCRIPTOR_HANDLE"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pvCallbackCtxt", "pbData", "cbData", "hDescriptor", "fFinal"]), offset=0), "pvCallbackCtxt": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="NCRYPT_PROTECT_STREAM_INFO_EX", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pStreamInfo", "dwFlags", "hWnd", "phStream"]),
        # 
        'NCryptStreamUpdate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hStream", "pbData", "cbData", "fFinal"]),
        # 
        'NCryptStreamClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hStream"]),
    }

lib.set_prototypes(prototypes)
