# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.add('RtlEncodePointer', P['win32']['EncodePointer'])
lib.add('RtlDecodePointer', P['win32']['EncodePointer'])
lib.add('RtlAllocateHeap', P['win32']['HeapAlloc'])
lib.set_library_names("ntdll.dll")
prototypes = \
    {
        # 
        'RtlNtStatusToDosError': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Status"]),
        # 
        'RtlIpv4AddressToStringA': SimTypeFunction([SimTypePointer(SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["Addr", "S"]),
        # 
        'RtlIpv4AddressToStringExA': SimTypeFunction([SimTypePointer(SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Address", "Port", "AddressString", "AddressStringLength"]),
        # 
        'RtlIpv4AddressToStringW': SimTypeFunction([SimTypePointer(SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["Addr", "S"]),
        # 
        'RtlIpv4AddressToStringExW': SimTypeFunction([SimTypePointer(SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Address", "Port", "AddressString", "AddressStringLength"]),
        # 
        'RtlIpv4StringToAddressA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["S", "Strict", "Terminator", "Addr"]),
        # 
        'RtlIpv4StringToAddressExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AddressString", "Strict", "Address", "Port"]),
        # 
        'RtlIpv4StringToAddressW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["S", "Strict", "Terminator", "Addr"]),
        # 
        'RtlIpv4StringToAddressExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimStruct({"S_un": SimUnion({"S_un_b": SimStruct({"s_b1": SimTypeChar(label="Byte"), "s_b2": SimTypeChar(label="Byte"), "s_b3": SimTypeChar(label="Byte"), "s_b4": SimTypeChar(label="Byte")}, name="_S_un_b_e__Struct", pack=False, align=None), "S_un_w": SimStruct({"s_w1": SimTypeShort(signed=False, label="UInt16"), "s_w2": SimTypeShort(signed=False, label="UInt16")}, name="_S_un_w_e__Struct", pack=False, align=None), "S_addr": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IN_ADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AddressString", "Strict", "Address", "Port"]),
        # 
        'RtlIpv6AddressToStringA': SimTypeFunction([SimTypePointer(SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["Addr", "S"]),
        # 
        'RtlIpv6AddressToStringExA': SimTypeFunction([SimTypePointer(SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Address", "ScopeId", "Port", "AddressString", "AddressStringLength"]),
        # 
        'RtlIpv6AddressToStringW': SimTypeFunction([SimTypePointer(SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["Addr", "S"]),
        # 
        'RtlIpv6AddressToStringExW': SimTypeFunction([SimTypePointer(SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Address", "ScopeId", "Port", "AddressString", "AddressStringLength"]),
        # 
        'RtlIpv6StringToAddressA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["S", "Terminator", "Addr"]),
        # 
        'RtlIpv6StringToAddressExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AddressString", "Address", "ScopeId", "Port"]),
        # 
        'RtlIpv6StringToAddressW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["S", "Terminator", "Addr"]),
        # 
        'RtlIpv6StringToAddressExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"u": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 16), "Word": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 8)}, name="<anon>", label="None")}, name="IN6_ADDR", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["AddressString", "Address", "ScopeId", "Port"]),
        # 
        'RtlEthernetAddressToStringA': SimTypeFunction([SimTypePointer(SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6), "Anonymous": SimStruct({"Oui": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Ei48": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0)], SimTypePointer(SimTypeChar(label="Byte"), offset=0), arg_names=["Addr", "S"]),
        # 
        'RtlEthernetAddressToStringW': SimTypeFunction([SimTypePointer(SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6), "Anonymous": SimStruct({"Oui": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Ei48": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0)], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["Addr", "S"]),
        # 
        'RtlEthernetStringToAddressA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypePointer(SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6), "Anonymous": SimStruct({"Oui": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Ei48": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["S", "Terminator", "Addr"]),
        # 
        'RtlEthernetStringToAddressW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6), "Anonymous": SimStruct({"Oui": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "Anonymous": SimStruct({"_bitfield": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "Ei48": SimUnion({"Byte": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3)}, name="<anon>", label="None")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["S", "Terminator", "Addr"]),
        # 
        'RtlConvertSidToUnicodeString': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=True, label="Int32"), arg_names=["UnicodeString", "Sid", "AllocateDestinationString"]),
        # 
        'RtlAddGrowableFunctionTable': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimStruct({"BeginAddress": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"UnwindData": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="IMAGE_ARM64_RUNTIME_FUNCTION_ENTRY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["DynamicTable", "FunctionTable", "EntryCount", "MaximumEntryCount", "RangeBase", "RangeEnd"]),
        # 
        'RtlGrowFunctionTable': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["DynamicTable", "NewEntryCount"]),
        # 
        'RtlDeleteGrowableFunctionTable': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["DynamicTable"]),
        # 
        'RtlAddGrowableFunctionTable': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimStruct({"BeginAddress": SimTypeInt(signed=False, label="UInt32"), "EndAddress": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"UnwindInfoAddress": SimTypeInt(signed=False, label="UInt32"), "UnwindData": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="IMAGE_RUNTIME_FUNCTION_ENTRY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["DynamicTable", "FunctionTable", "EntryCount", "MaximumEntryCount", "RangeBase", "RangeEnd"]),
        # 
        'RtlGetNonVolatileToken': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["NvBuffer", "Size", "NvToken"]),
        # 
        'RtlFreeNonVolatileToken': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["NvToken"]),
        # 
        'RtlFlushNonVolatileMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["NvToken", "NvBuffer", "Size", "Flags"]),
        # 
        'RtlDrainNonVolatileFlush': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["NvToken"]),
        # 
        'RtlWriteNonVolatileMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["NvToken", "NvDestination", "Source", "Size", "Flags"]),
        # 
        'RtlFillNonVolatileMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["NvToken", "NvDestination", "Size", "Value", "Flags"]),
        # 
        'RtlFlushNonVolatileMemoryRanges': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"BaseAddress": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "Length": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="NV_MEMORY_RANGE", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["NvToken", "NvRanges", "NumRanges", "Flags"]),
        # 
        'RtlInitializeSListHead': SimTypeFunction([SimTypePointer(SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Next": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), "Depth": SimTypeShort(signed=False, label="UInt16"), "CpuId": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["ListHead"]),
        # 
        'RtlFirstEntrySList': SimTypeFunction([SimTypePointer(SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Next": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), "Depth": SimTypeShort(signed=False, label="UInt16"), "CpuId": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), offset=0), arg_names=["ListHead"]),
        # 
        'RtlInterlockedPopEntrySList': SimTypeFunction([SimTypePointer(SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Next": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), "Depth": SimTypeShort(signed=False, label="UInt16"), "CpuId": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), offset=0), arg_names=["ListHead"]),
        # 
        'RtlInterlockedPushEntrySList': SimTypeFunction([SimTypePointer(SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Next": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), "Depth": SimTypeShort(signed=False, label="UInt16"), "CpuId": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), offset=0)], SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), offset=0), arg_names=["ListHead", "ListEntry"]),
        # 
        'RtlInterlockedPushListSListEx': SimTypeFunction([SimTypePointer(SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Next": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), "Depth": SimTypeShort(signed=False, label="UInt16"), "CpuId": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0), SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), offset=0), arg_names=["ListHead", "List", "ListEnd", "Count"]),
        # 
        'RtlInterlockedFlushSList': SimTypeFunction([SimTypePointer(SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Next": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), "Depth": SimTypeShort(signed=False, label="UInt16"), "CpuId": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypePointer(SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), offset=0), arg_names=["ListHead"]),
        # 
        'RtlQueryDepthSList': SimTypeFunction([SimTypePointer(SimUnion({"Alignment": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimStruct({"Next": SimStruct({"Next": SimTypePointer(SimTypeBottom(label="SLIST_ENTRY"), offset=0)}, name="SLIST_ENTRY", pack=False, align=None), "Depth": SimTypeShort(signed=False, label="UInt16"), "CpuId": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeShort(signed=False, label="UInt16"), arg_names=["ListHead"]),
        # 
        'RtlGetReturnAddressHijackTarget': SimTypeFunction([], SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)),
        # 
        'RtlGetProductInfo': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["OSMajorVersion", "OSMinorVersion", "SpMajorVersion", "SpMinorVersion", "ReturnedProductType"]),
        # 
        'RtlCrc32': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["Buffer", "Size", "InitialCrc"]),
        # 
        'RtlCrc64': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeLongLong(signed=False, label="UInt64"), arg_names=["Buffer", "Size", "InitialCrc"]),
        # 
        'RtlOsDeploymentState': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="OS_DEPLOYEMENT_STATE_VALUES"), arg_names=["Flags"]),
        # 
        'RtlInitializeCorrelationVector': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeChar(label="Byte"), "Vector": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 129)}, name="CORRELATION_VECTOR", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["CorrelationVector", "Version", "Guid"]),
        # 
        'RtlIncrementCorrelationVector': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeChar(label="Byte"), "Vector": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 129)}, name="CORRELATION_VECTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["CorrelationVector"]),
        # 
        'RtlExtendCorrelationVector': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeChar(label="Byte"), "Vector": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 129)}, name="CORRELATION_VECTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["CorrelationVector"]),
        # 
        'RtlValidateCorrelationVector': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeChar(label="Byte"), "Vector": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 129)}, name="CORRELATION_VECTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Vector"]),
        # 
        'RtlRaiseCustomSystemEventTrigger': SimTypeFunction([SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "TriggerId": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CUSTOM_SYSTEM_EVENT_TRIGGER_CONFIG", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["TriggerConfig"]),
        # 
        'RtlIsZeroMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeChar(label="Byte"), arg_names=["Buffer", "Length"]),
        # 
        'RtlNormalizeSecurityDescriptor': SimTypeFunction([SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"Revision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "Control": SimTypeShort(signed=False, label="UInt16"), "Owner": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Group": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "Sacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0), "Dacl": SimTypePointer(SimStruct({"AclRevision": SimTypeChar(label="Byte"), "Sbz1": SimTypeChar(label="Byte"), "AclSize": SimTypeShort(signed=False, label="UInt16"), "AceCount": SimTypeShort(signed=False, label="UInt16"), "Sbz2": SimTypeShort(signed=False, label="UInt16")}, name="ACL", pack=False, align=None), offset=0)}, name="SECURITY_DESCRIPTOR", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeChar(label="Byte")], SimTypeChar(label="Byte"), arg_names=["SecurityDescriptor", "SecurityDescriptorLength", "NewSecurityDescriptor", "NewSecurityDescriptorLength", "CheckOnly"]),
        # 
        'RtlGetDeviceFamilyInfoEnum': SimTypeFunction([SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pullUAPInfo", "pulDeviceFamily", "pulDeviceForm"]),
        # 
        'RtlConvertDeviceFamilyInfoToString': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pulDeviceFamilyBufferSize", "pulDeviceFormBufferSize", "DeviceFamily", "DeviceForm"]),
        # 
        'RtlSwitchedVVI': SimTypeFunction([SimTypePointer(SimStruct({"dwOSVersionInfoSize": SimTypeInt(signed=False, label="UInt32"), "dwMajorVersion": SimTypeInt(signed=False, label="UInt32"), "dwMinorVersion": SimTypeInt(signed=False, label="UInt32"), "dwBuildNumber": SimTypeInt(signed=False, label="UInt32"), "dwPlatformId": SimTypeInt(signed=False, label="UInt32"), "szCSDVersion": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "wServicePackMajor": SimTypeShort(signed=False, label="UInt16"), "wServicePackMinor": SimTypeShort(signed=False, label="UInt16"), "wSuiteMask": SimTypeShort(signed=False, label="UInt16"), "wProductType": SimTypeChar(label="Byte"), "wReserved": SimTypeChar(label="Byte")}, name="OSVERSIONINFOEXW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["VersionInfo", "TypeMask", "ConditionMask"]),
        # 
        'NtQueryInformationProcess': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="PROCESSINFOCLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ProcessHandle", "ProcessInformationClass", "ProcessInformation", "ProcessInformationLength", "ReturnLength"]),
        # 
        'NtQueryInformationThread': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="THREADINFOCLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ThreadHandle", "ThreadInformationClass", "ThreadInformation", "ThreadInformationLength", "ReturnLength"]),
        # 
        'NtClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Handle"]),
        # 
        'NtCreateFile': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "RootDirectory": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ObjectName": SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), "Attributes": SimTypeInt(signed=False, label="UInt32"), "SecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SecurityQualityOfService": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="OBJECT_ATTRIBUTES", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Status": SimTypeInt(signed=True, label="Int32"), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "Information": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="IO_STATUS_BLOCK", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="FILE_SHARE_MODE"), SimTypeInt(signed=False, label="NT_CREATE_FILE_DISPOSITION"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FileHandle", "DesiredAccess", "ObjectAttributes", "IoStatusBlock", "AllocationSize", "FileAttributes", "ShareAccess", "CreateDisposition", "CreateOptions", "EaBuffer", "EaLength"]),
        # 
        'NtOpenFile': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "RootDirectory": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ObjectName": SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), "Attributes": SimTypeInt(signed=False, label="UInt32"), "SecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SecurityQualityOfService": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="OBJECT_ATTRIBUTES", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Status": SimTypeInt(signed=True, label="Int32"), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "Information": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="IO_STATUS_BLOCK", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FileHandle", "DesiredAccess", "ObjectAttributes", "IoStatusBlock", "ShareAccess", "OpenOptions"]),
        # 
        'NtRenameKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["KeyHandle", "NewName"]),
        # 
        'NtNotifyChangeMultipleKeys': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Length": SimTypeInt(signed=False, label="UInt32"), "RootDirectory": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "ObjectName": SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), "Attributes": SimTypeInt(signed=False, label="UInt32"), "SecurityDescriptor": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "SecurityQualityOfService": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="OBJECT_ATTRIBUTES", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Status": SimTypeInt(signed=True, label="Int32"), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "Information": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="IO_STATUS_BLOCK", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["ApcContext", "IoStatusBlock", "Reserved"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Status": SimTypeInt(signed=True, label="Int32"), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "Information": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="IO_STATUS_BLOCK", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeChar(label="Byte"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeChar(label="Byte")], SimTypeInt(signed=True, label="Int32"), arg_names=["MasterKeyHandle", "Count", "SubordinateObjects", "Event", "ApcRoutine", "ApcContext", "IoStatusBlock", "CompletionFilter", "WatchTree", "Buffer", "BufferSize", "Asynchronous"]),
        # 
        'NtQueryMultipleValueKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"ValueName": SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), "DataLength": SimTypeInt(signed=False, label="UInt32"), "DataOffset": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="KEY_VALUE_ENTRY", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["KeyHandle", "ValueEntries", "EntryCount", "ValueBuffer", "BufferLength", "RequiredBufferLength"]),
        # 
        'NtSetInformationKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="KEY_SET_INFORMATION_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["KeyHandle", "KeySetInformationClass", "KeySetInformation", "KeySetInformationLength"]),
        # 
        'NtDeviceIoControlFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Status": SimTypeInt(signed=True, label="Int32"), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "Information": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="IO_STATUS_BLOCK", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["ApcContext", "IoStatusBlock", "Reserved"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Status": SimTypeInt(signed=True, label="Int32"), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "Information": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)}, name="IO_STATUS_BLOCK", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["FileHandle", "Event", "ApcRoutine", "ApcContext", "IoStatusBlock", "IoControlCode", "InputBuffer", "InputBufferLength", "OutputBuffer", "OutputBufferLength"]),
        # 
        'NtWaitForSingleObject': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeChar(label="Byte"), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Handle", "Alertable", "Timeout"]),
        # 
        'RtlIsNameLegalDOS8Dot3': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeChar(label="Byte"), arg_names=["Name", "OemName", "NameContainsSpaces"]),
        # 
        'NtQueryObject': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="OBJECT_INFORMATION_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Handle", "ObjectInformationClass", "ObjectInformation", "ObjectInformationLength", "ReturnLength"]),
        # 
        'NtQuerySystemInformation': SimTypeFunction([SimTypeInt(signed=False, label="SYSTEM_INFORMATION_CLASS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SystemInformationClass", "SystemInformation", "SystemInformationLength", "ReturnLength"]),
        # 
        'NtQuerySystemTime': SimTypeFunction([SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["SystemTime"]),
        # 
        'RtlLocalTimeToSystemTime': SimTypeFunction([SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0), SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LocalTime", "SystemTime"]),
        # 
        'RtlTimeToSecondsSince1970': SimTypeFunction([SimTypePointer(SimUnion({"Anonymous": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_Anonymous_e__Struct", pack=False, align=None), "u": SimStruct({"LowPart": SimTypeInt(signed=False, label="UInt32"), "HighPart": SimTypeInt(signed=True, label="Int32")}, name="_u_e__Struct", pack=False, align=None), "QuadPart": SimTypeLongLong(signed=True, label="Int64")}, name="<anon>", label="None"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["Time", "ElapsedSeconds"]),
        # 
        'RtlFreeAnsiString': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="STRING", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["AnsiString"]),
        # 
        'RtlFreeUnicodeString': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["UnicodeString"]),
        # 
        'RtlFreeOemString': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="STRING", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["OemString"]),
        # 
        'RtlInitString': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["DestinationString", "SourceString"]),
        # 
        'RtlInitStringEx': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["DestinationString", "SourceString"]),
        # 
        'RtlInitAnsiString': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeBottom(label="Void"), arg_names=["DestinationString", "SourceString"]),
        # 
        'RtlInitAnsiStringEx': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="SByte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["DestinationString", "SourceString"]),
        # 
        'RtlInitUnicodeString': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["DestinationString", "SourceString"]),
        # 
        'RtlAnsiStringToUnicodeString': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="STRING", pack=False, align=None), offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=True, label="Int32"), arg_names=["DestinationString", "SourceString", "AllocateDestinationString"]),
        # 
        'RtlUnicodeStringToAnsiString': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=True, label="Int32"), arg_names=["DestinationString", "SourceString", "AllocateDestinationString"]),
        # 
        'RtlUnicodeStringToOemString': SimTypeFunction([SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="STRING", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Length": SimTypeShort(signed=False, label="UInt16"), "MaximumLength": SimTypeShort(signed=False, label="UInt16"), "Buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="UNICODE_STRING", pack=False, align=None), offset=0), SimTypeChar(label="Byte")], SimTypeInt(signed=True, label="Int32"), arg_names=["DestinationString", "SourceString", "AllocateDestinationString"]),
        # 
        'RtlUnicodeToMultiByteSize': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["BytesInMultiByteString", "UnicodeString", "BytesInUnicodeString"]),
        # 
        'RtlCharToInteger': SimTypeFunction([SimTypePointer(SimTypeChar(label="SByte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["String", "Base", "Value"]),
        # 
        'RtlUniform': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Seed"]),
    }

lib.set_prototypes(prototypes)
