# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("webauthn.dll")
prototypes = \
    {
        # 
        'WebAuthNGetApiVersionNumber': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'WebAuthNIsUserVerifyingPlatformAuthenticatorAvailable': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pbIsUserVerifyingPlatformAuthenticatorAvailable"]),
        # 
        'WebAuthNAuthenticatorMakeCredential': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "pwszId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszIcon": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WEBAUTHN_RP_ENTITY_INFORMATION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "cbId": SimTypeInt(signed=False, label="UInt32"), "pbId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszIcon": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszDisplayName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WEBAUTHN_USER_ENTITY_INFORMATION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"cCredentialParameters": SimTypeInt(signed=False, label="UInt32"), "pCredentialParameters": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "pwszCredentialType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lAlg": SimTypeInt(signed=True, label="Int32")}, name="WEBAUTHN_COSE_CREDENTIAL_PARAMETER", pack=False, align=None), offset=0)}, name="WEBAUTHN_COSE_CREDENTIAL_PARAMETERS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "cbClientDataJSON": SimTypeInt(signed=False, label="UInt32"), "pbClientDataJSON": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszHashAlgId": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WEBAUTHN_CLIENT_DATA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwTimeoutMilliseconds": SimTypeInt(signed=False, label="UInt32"), "CredentialList": SimStruct({"cCredentials": SimTypeInt(signed=False, label="UInt32"), "pCredentials": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "cbId": SimTypeInt(signed=False, label="UInt32"), "pbId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszCredentialType": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WEBAUTHN_CREDENTIAL", pack=False, align=None), offset=0)}, name="WEBAUTHN_CREDENTIALS", pack=False, align=None), "Extensions": SimStruct({"cExtensions": SimTypeInt(signed=False, label="UInt32"), "pExtensions": SimTypePointer(SimStruct({"pwszExtensionIdentifier": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbExtension": SimTypeInt(signed=False, label="UInt32"), "pvExtension": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WEBAUTHN_EXTENSION", pack=False, align=None), offset=0)}, name="WEBAUTHN_EXTENSIONS", pack=False, align=None), "dwAuthenticatorAttachment": SimTypeInt(signed=False, label="UInt32"), "bRequireResidentKey": SimTypeInt(signed=True, label="Int32"), "dwUserVerificationRequirement": SimTypeInt(signed=False, label="UInt32"), "dwAttestationConveyancePreference": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pCancellationId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "pExcludeCredentialList": SimTypePointer(SimStruct({"cCredentials": SimTypeInt(signed=False, label="UInt32"), "ppCredentials": SimTypePointer(SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "cbId": SimTypeInt(signed=False, label="UInt32"), "pbId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszCredentialType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwTransports": SimTypeInt(signed=False, label="UInt32")}, name="WEBAUTHN_CREDENTIAL_EX", pack=False, align=None), offset=0), offset=0)}, name="WEBAUTHN_CREDENTIAL_LIST", pack=False, align=None), offset=0)}, name="WEBAUTHN_AUTHENTICATOR_MAKE_CREDENTIAL_OPTIONS", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "pwszFormatType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbAuthenticatorData": SimTypeInt(signed=False, label="UInt32"), "pbAuthenticatorData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbAttestation": SimTypeInt(signed=False, label="UInt32"), "pbAttestation": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwAttestationDecodeType": SimTypeInt(signed=False, label="UInt32"), "pvAttestationDecode": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbAttestationObject": SimTypeInt(signed=False, label="UInt32"), "pbAttestationObject": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCredentialId": SimTypeInt(signed=False, label="UInt32"), "pbCredentialId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Extensions": SimStruct({"cExtensions": SimTypeInt(signed=False, label="UInt32"), "pExtensions": SimTypePointer(SimStruct({"pwszExtensionIdentifier": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbExtension": SimTypeInt(signed=False, label="UInt32"), "pvExtension": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WEBAUTHN_EXTENSION", pack=False, align=None), offset=0)}, name="WEBAUTHN_EXTENSIONS", pack=False, align=None), "dwUsedTransport": SimTypeInt(signed=False, label="UInt32")}, name="WEBAUTHN_CREDENTIAL_ATTESTATION", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "pRpInformation", "pUserInformation", "pPubKeyCredParams", "pWebAuthNClientData", "pWebAuthNMakeCredentialOptions", "ppWebAuthNCredentialAttestation"]),
        # 
        'WebAuthNAuthenticatorGetAssertion': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "cbClientDataJSON": SimTypeInt(signed=False, label="UInt32"), "pbClientDataJSON": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszHashAlgId": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WEBAUTHN_CLIENT_DATA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwTimeoutMilliseconds": SimTypeInt(signed=False, label="UInt32"), "CredentialList": SimStruct({"cCredentials": SimTypeInt(signed=False, label="UInt32"), "pCredentials": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "cbId": SimTypeInt(signed=False, label="UInt32"), "pbId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszCredentialType": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WEBAUTHN_CREDENTIAL", pack=False, align=None), offset=0)}, name="WEBAUTHN_CREDENTIALS", pack=False, align=None), "Extensions": SimStruct({"cExtensions": SimTypeInt(signed=False, label="UInt32"), "pExtensions": SimTypePointer(SimStruct({"pwszExtensionIdentifier": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbExtension": SimTypeInt(signed=False, label="UInt32"), "pvExtension": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WEBAUTHN_EXTENSION", pack=False, align=None), offset=0)}, name="WEBAUTHN_EXTENSIONS", pack=False, align=None), "dwAuthenticatorAttachment": SimTypeInt(signed=False, label="UInt32"), "dwUserVerificationRequirement": SimTypeInt(signed=False, label="UInt32"), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "pwszU2fAppId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pbU2fAppId": SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), "pCancellationId": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "pAllowCredentialList": SimTypePointer(SimStruct({"cCredentials": SimTypeInt(signed=False, label="UInt32"), "ppCredentials": SimTypePointer(SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "cbId": SimTypeInt(signed=False, label="UInt32"), "pbId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszCredentialType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwTransports": SimTypeInt(signed=False, label="UInt32")}, name="WEBAUTHN_CREDENTIAL_EX", pack=False, align=None), offset=0), offset=0)}, name="WEBAUTHN_CREDENTIAL_LIST", pack=False, align=None), offset=0)}, name="WEBAUTHN_AUTHENTICATOR_GET_ASSERTION_OPTIONS", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "cbAuthenticatorData": SimTypeInt(signed=False, label="UInt32"), "pbAuthenticatorData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbSignature": SimTypeInt(signed=False, label="UInt32"), "pbSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Credential": SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "cbId": SimTypeInt(signed=False, label="UInt32"), "pbId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszCredentialType": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WEBAUTHN_CREDENTIAL", pack=False, align=None), "cbUserId": SimTypeInt(signed=False, label="UInt32"), "pbUserId": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WEBAUTHN_ASSERTION", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "pwszRpId", "pWebAuthNClientData", "pWebAuthNGetAssertionOptions", "ppWebAuthNAssertion"]),
        # 
        'WebAuthNFreeCredentialAttestation': SimTypeFunction([SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "pwszFormatType": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbAuthenticatorData": SimTypeInt(signed=False, label="UInt32"), "pbAuthenticatorData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbAttestation": SimTypeInt(signed=False, label="UInt32"), "pbAttestation": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwAttestationDecodeType": SimTypeInt(signed=False, label="UInt32"), "pvAttestationDecode": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "cbAttestationObject": SimTypeInt(signed=False, label="UInt32"), "pbAttestationObject": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCredentialId": SimTypeInt(signed=False, label="UInt32"), "pbCredentialId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Extensions": SimStruct({"cExtensions": SimTypeInt(signed=False, label="UInt32"), "pExtensions": SimTypePointer(SimStruct({"pwszExtensionIdentifier": SimTypePointer(SimTypeChar(label="Char"), offset=0), "cbExtension": SimTypeInt(signed=False, label="UInt32"), "pvExtension": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="WEBAUTHN_EXTENSION", pack=False, align=None), offset=0)}, name="WEBAUTHN_EXTENSIONS", pack=False, align=None), "dwUsedTransport": SimTypeInt(signed=False, label="UInt32")}, name="WEBAUTHN_CREDENTIAL_ATTESTATION", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pWebAuthNCredentialAttestation"]),
        # 
        'WebAuthNFreeAssertion': SimTypeFunction([SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "cbAuthenticatorData": SimTypeInt(signed=False, label="UInt32"), "pbAuthenticatorData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbSignature": SimTypeInt(signed=False, label="UInt32"), "pbSignature": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Credential": SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "cbId": SimTypeInt(signed=False, label="UInt32"), "pbId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pwszCredentialType": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WEBAUTHN_CREDENTIAL", pack=False, align=None), "cbUserId": SimTypeInt(signed=False, label="UInt32"), "pbUserId": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WEBAUTHN_ASSERTION", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pWebAuthNAssertion"]),
        # 
        'WebAuthNGetCancellationId': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCancellationId"]),
        # 
        'WebAuthNCancelCurrentOperation': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pCancellationId"]),
        # 
        'WebAuthNGetErrorName': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypePointer(SimTypeChar(label="Char"), offset=0), arg_names=["hr"]),
        # 
        'WebAuthNGetW3CExceptionDOMError': SimTypeFunction([SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hr"]),
    }

lib.set_prototypes(prototypes)
