# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("wer.dll")
prototypes = \
    {
        # 
        'WerReportCreate': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="WER_REPORT_TYPE"), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "hProcess": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "wzConsentKey": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 64), "wzFriendlyEventName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "wzApplicationName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "wzApplicationPath": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "wzDescription": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 512), "hwndParent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="WER_REPORT_INFORMATION", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzEventType", "repType", "pReportInformation", "phReportHandle"]),
        # 
        'WerReportSetParameter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportHandle", "dwparamID", "pwzName", "pwzValue"]),
        # 
        'WerReportAddFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="WER_FILE_TYPE"), SimTypeInt(signed=False, label="WER_FILE")], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportHandle", "pwzPath", "repFileType", "dwFileFlags"]),
        # 
        'WerReportSetUIOption': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WER_REPORT_UI"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportHandle", "repUITypeID", "pwzValue"]),
        # 
        'WerReportSubmit': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WER_CONSENT"), SimTypeInt(signed=False, label="WER_SUBMIT_FLAGS"), SimTypePointer(SimTypeInt(signed=False, label="WER_SUBMIT_RESULT"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportHandle", "consent", "dwFlags", "pSubmitResult"]),
        # 
        'WerReportAddDump': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="WER_DUMP_TYPE"), SimTypePointer(SimStruct({"pExceptionPointers": SimTypePointer(SimStruct({"ExceptionRecord": SimTypePointer(SimStruct({"ExceptionCode": SimTypeInt(signed=True, label="Int32"), "ExceptionFlags": SimTypeInt(signed=False, label="UInt32"), "ExceptionRecord": SimTypePointer(SimTypeBottom(label="EXCEPTION_RECORD"), offset=0), "ExceptionAddress": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "NumberParameters": SimTypeInt(signed=False, label="UInt32"), "ExceptionInformation": SimTypeFixedSizeArray(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), 15)}, name="EXCEPTION_RECORD", pack=False, align=None), offset=0), "ContextRecord": SimTypePointer(SimStruct({"P1Home": SimTypeLongLong(signed=False, label="UInt64"), "P2Home": SimTypeLongLong(signed=False, label="UInt64"), "P3Home": SimTypeLongLong(signed=False, label="UInt64"), "P4Home": SimTypeLongLong(signed=False, label="UInt64"), "P5Home": SimTypeLongLong(signed=False, label="UInt64"), "P6Home": SimTypeLongLong(signed=False, label="UInt64"), "ContextFlags": SimTypeInt(signed=False, label="UInt32"), "MxCsr": SimTypeInt(signed=False, label="UInt32"), "SegCs": SimTypeShort(signed=False, label="UInt16"), "SegDs": SimTypeShort(signed=False, label="UInt16"), "SegEs": SimTypeShort(signed=False, label="UInt16"), "SegFs": SimTypeShort(signed=False, label="UInt16"), "SegGs": SimTypeShort(signed=False, label="UInt16"), "SegSs": SimTypeShort(signed=False, label="UInt16"), "EFlags": SimTypeInt(signed=False, label="UInt32"), "Dr0": SimTypeLongLong(signed=False, label="UInt64"), "Dr1": SimTypeLongLong(signed=False, label="UInt64"), "Dr2": SimTypeLongLong(signed=False, label="UInt64"), "Dr3": SimTypeLongLong(signed=False, label="UInt64"), "Dr6": SimTypeLongLong(signed=False, label="UInt64"), "Dr7": SimTypeLongLong(signed=False, label="UInt64"), "Rax": SimTypeLongLong(signed=False, label="UInt64"), "Rcx": SimTypeLongLong(signed=False, label="UInt64"), "Rdx": SimTypeLongLong(signed=False, label="UInt64"), "Rbx": SimTypeLongLong(signed=False, label="UInt64"), "Rsp": SimTypeLongLong(signed=False, label="UInt64"), "Rbp": SimTypeLongLong(signed=False, label="UInt64"), "Rsi": SimTypeLongLong(signed=False, label="UInt64"), "Rdi": SimTypeLongLong(signed=False, label="UInt64"), "R8": SimTypeLongLong(signed=False, label="UInt64"), "R9": SimTypeLongLong(signed=False, label="UInt64"), "R10": SimTypeLongLong(signed=False, label="UInt64"), "R11": SimTypeLongLong(signed=False, label="UInt64"), "R12": SimTypeLongLong(signed=False, label="UInt64"), "R13": SimTypeLongLong(signed=False, label="UInt64"), "R14": SimTypeLongLong(signed=False, label="UInt64"), "R15": SimTypeLongLong(signed=False, label="UInt64"), "Rip": SimTypeLongLong(signed=False, label="UInt64"), "Anonymous": SimUnion({"FltSave": SimTypeBottom(label="XSAVE_FORMAT"), "Anonymous": SimStruct({"Header": SimTypeFixedSizeArray(SimTypeBottom(label="M128A"), 2), "Legacy": SimTypeFixedSizeArray(SimTypeBottom(label="M128A"), 8), "Xmm0": SimTypeBottom(label="M128A"), "Xmm1": SimTypeBottom(label="M128A"), "Xmm2": SimTypeBottom(label="M128A"), "Xmm3": SimTypeBottom(label="M128A"), "Xmm4": SimTypeBottom(label="M128A"), "Xmm5": SimTypeBottom(label="M128A"), "Xmm6": SimTypeBottom(label="M128A"), "Xmm7": SimTypeBottom(label="M128A"), "Xmm8": SimTypeBottom(label="M128A"), "Xmm9": SimTypeBottom(label="M128A"), "Xmm10": SimTypeBottom(label="M128A"), "Xmm11": SimTypeBottom(label="M128A"), "Xmm12": SimTypeBottom(label="M128A"), "Xmm13": SimTypeBottom(label="M128A"), "Xmm14": SimTypeBottom(label="M128A"), "Xmm15": SimTypeBottom(label="M128A")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "VectorRegister": SimTypeFixedSizeArray(SimTypeBottom(label="M128A"), 26), "VectorControl": SimTypeLongLong(signed=False, label="UInt64"), "DebugControl": SimTypeLongLong(signed=False, label="UInt64"), "LastBranchToRip": SimTypeLongLong(signed=False, label="UInt64"), "LastBranchFromRip": SimTypeLongLong(signed=False, label="UInt64"), "LastExceptionToRip": SimTypeLongLong(signed=False, label="UInt64"), "LastExceptionFromRip": SimTypeLongLong(signed=False, label="UInt64")}, name="CONTEXT", pack=False, align=None), offset=0)}, name="EXCEPTION_POINTERS", pack=False, align=None), offset=0), "bClientPointers": SimTypeInt(signed=True, label="Int32")}, name="WER_EXCEPTION_INFORMATION", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "dwMask": SimTypeInt(signed=False, label="UInt32"), "dwDumpFlags": SimTypeInt(signed=False, label="UInt32"), "bOnlyThisThread": SimTypeInt(signed=True, label="Int32"), "dwExceptionThreadFlags": SimTypeInt(signed=False, label="UInt32"), "dwOtherThreadFlags": SimTypeInt(signed=False, label="UInt32"), "dwExceptionThreadExFlags": SimTypeInt(signed=False, label="UInt32"), "dwOtherThreadExFlags": SimTypeInt(signed=False, label="UInt32"), "dwPreferredModuleFlags": SimTypeInt(signed=False, label="UInt32"), "dwOtherModuleFlags": SimTypeInt(signed=False, label="UInt32"), "wzPreferredModuleList": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 256)}, name="WER_DUMP_CUSTOM_OPTIONS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportHandle", "hProcess", "hThread", "dumpType", "pExceptionParam", "pDumpCustomOptions", "dwFlags"]),
        # 
        'WerReportCloseHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportHandle"]),
        # 
        'WerAddExcludedApplication': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzExeName", "bAllUsers"]),
        # 
        'WerRemoveExcludedApplication': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pwzExeName", "bAllUsers"]),
        # 
        'WerStoreOpen': SimTypeFunction([SimTypeInt(signed=False, label="REPORT_STORE_TYPES"), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["repStoreType", "phReportStore"]),
        # 
        'WerStoreClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hReportStore"]),
        # 
        'WerStoreGetFirstReportKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportStore", "ppszReportKey"]),
        # 
        'WerStoreGetNextReportKey': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportStore", "ppszReportKey"]),
        # 
        'WerStoreQueryReportMetadataV2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Signature": SimStruct({"EventName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 65), "Parameters": SimTypeFixedSizeArray(SimStruct({"Name": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "Value": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260)}, name="WER_REPORT_PARAMETER", pack=False, align=None), 10)}, name="WER_REPORT_SIGNATURE", pack=False, align=None), "BucketId": SimTypeBottom(label="Guid"), "ReportId": SimTypeBottom(label="Guid"), "CreationTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SizeInBytes": SimTypeLongLong(signed=False, label="UInt64"), "CabId": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "ReportStatus": SimTypeInt(signed=False, label="UInt32"), "ReportIntegratorId": SimTypeBottom(label="Guid"), "NumberOfFiles": SimTypeInt(signed=False, label="UInt32"), "SizeOfFileNames": SimTypeInt(signed=False, label="UInt32"), "FileNames": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WER_REPORT_METADATA_V2", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportStore", "pszReportKey", "pReportMetadata"]),
        # 
        'WerStoreQueryReportMetadataV3': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Signature": SimStruct({"EventName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 65), "Parameters": SimTypeFixedSizeArray(SimStruct({"Name": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "Value": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260)}, name="WER_REPORT_PARAMETER", pack=False, align=None), 10)}, name="WER_REPORT_SIGNATURE", pack=False, align=None), "BucketId": SimTypeBottom(label="Guid"), "ReportId": SimTypeBottom(label="Guid"), "CreationTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SizeInBytes": SimTypeLongLong(signed=False, label="UInt64"), "CabId": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "ReportStatus": SimTypeInt(signed=False, label="UInt32"), "ReportIntegratorId": SimTypeBottom(label="Guid"), "NumberOfFiles": SimTypeInt(signed=False, label="UInt32"), "SizeOfFileNames": SimTypeInt(signed=False, label="UInt32"), "FileNames": SimTypePointer(SimTypeChar(label="Char"), offset=0), "FriendlyEventName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "ApplicationName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 128), "ApplicationPath": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "Description": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 512), "BucketIdString": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "LegacyBucketId": SimTypeLongLong(signed=False, label="UInt64")}, name="WER_REPORT_METADATA_V3", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportStore", "pszReportKey", "pReportMetadata"]),
        # 
        'WerFreeString': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeBottom(label="Void"), arg_names=["pwszStr"]),
        # 
        'WerStorePurge': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'WerStoreGetReportCount': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportStore", "pdwReportCount"]),
        # 
        'WerStoreGetSizeOnDisk': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportStore", "pqwSizeInBytes"]),
        # 
        'WerStoreQueryReportMetadataV1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"Signature": SimStruct({"EventName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 65), "Parameters": SimTypeFixedSizeArray(SimStruct({"Name": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "Value": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260)}, name="WER_REPORT_PARAMETER", pack=False, align=None), 10)}, name="WER_REPORT_SIGNATURE", pack=False, align=None), "BucketId": SimTypeBottom(label="Guid"), "ReportId": SimTypeBottom(label="Guid"), "CreationTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SizeInBytes": SimTypeLongLong(signed=False, label="UInt64")}, name="WER_REPORT_METADATA_V1", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportStore", "pszReportKey", "pReportMetadata"]),
        # 
        'WerStoreUploadReport': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="WER_SUBMIT_RESULT"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hReportStore", "pszReportKey", "dwFlags", "pSubmitResult"]),
    }

lib.set_prototypes(prototypes)
