# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("wininet.dll")
prototypes = \
    {
        # 
        'InternetTimeFromSystemTimeA': SimTypeFunction([SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pst", "dwRFC", "lpszTime", "cbTime"]),
        # 
        'InternetTimeFromSystemTimeW': SimTypeFunction([SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pst", "dwRFC", "lpszTime", "cbTime"]),
        # 
        'InternetTimeFromSystemTime': SimTypeFunction([SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pst", "dwRFC", "lpszTime", "cbTime"]),
        # 
        'InternetTimeToSystemTimeA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszTime", "pst", "dwReserved"]),
        # 
        'InternetTimeToSystemTimeW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszTime", "pst", "dwReserved"]),
        # 
        'InternetTimeToSystemTime': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"wYear": SimTypeShort(signed=False, label="UInt16"), "wMonth": SimTypeShort(signed=False, label="UInt16"), "wDayOfWeek": SimTypeShort(signed=False, label="UInt16"), "wDay": SimTypeShort(signed=False, label="UInt16"), "wHour": SimTypeShort(signed=False, label="UInt16"), "wMinute": SimTypeShort(signed=False, label="UInt16"), "wSecond": SimTypeShort(signed=False, label="UInt16"), "wMilliseconds": SimTypeShort(signed=False, label="UInt16")}, name="SYSTEMTIME", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszTime", "pst", "dwReserved"]),
        # 
        'InternetCrackUrlA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WIN_HTTP_CREATE_URL_FLAGS"), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszScheme": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSchemeLength": SimTypeInt(signed=False, label="UInt32"), "nScheme": SimTypeInt(signed=False, label="INTERNET_SCHEME"), "lpszHostName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHostNameLength": SimTypeInt(signed=False, label="UInt32"), "nPort": SimTypeShort(signed=False, label="UInt16"), "lpszUserName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwUserNameLength": SimTypeInt(signed=False, label="UInt32"), "lpszPassword": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwPasswordLength": SimTypeInt(signed=False, label="UInt32"), "lpszUrlPath": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwUrlPathLength": SimTypeInt(signed=False, label="UInt32"), "lpszExtraInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwExtraInfoLength": SimTypeInt(signed=False, label="UInt32")}, name="URL_COMPONENTSA", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "dwUrlLength", "dwFlags", "lpUrlComponents"]),
        # 
        'InternetCrackUrlW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="WIN_HTTP_CREATE_URL_FLAGS"), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszScheme": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwSchemeLength": SimTypeInt(signed=False, label="UInt32"), "nScheme": SimTypeInt(signed=False, label="INTERNET_SCHEME"), "lpszHostName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHostNameLength": SimTypeInt(signed=False, label="UInt32"), "nPort": SimTypeShort(signed=False, label="UInt16"), "lpszUserName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwUserNameLength": SimTypeInt(signed=False, label="UInt32"), "lpszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwPasswordLength": SimTypeInt(signed=False, label="UInt32"), "lpszUrlPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwUrlPathLength": SimTypeInt(signed=False, label="UInt32"), "lpszExtraInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwExtraInfoLength": SimTypeInt(signed=False, label="UInt32")}, name="URL_COMPONENTSW", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "dwUrlLength", "dwFlags", "lpUrlComponents"]),
        # 
        'InternetCreateUrlA': SimTypeFunction([SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszScheme": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwSchemeLength": SimTypeInt(signed=False, label="UInt32"), "nScheme": SimTypeInt(signed=False, label="INTERNET_SCHEME"), "lpszHostName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHostNameLength": SimTypeInt(signed=False, label="UInt32"), "nPort": SimTypeShort(signed=False, label="UInt16"), "lpszUserName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwUserNameLength": SimTypeInt(signed=False, label="UInt32"), "lpszPassword": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwPasswordLength": SimTypeInt(signed=False, label="UInt32"), "lpszUrlPath": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwUrlPathLength": SimTypeInt(signed=False, label="UInt32"), "lpszExtraInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwExtraInfoLength": SimTypeInt(signed=False, label="UInt32")}, name="URL_COMPONENTSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpUrlComponents", "dwFlags", "lpszUrl", "lpdwUrlLength"]),
        # 
        'InternetCreateUrlW': SimTypeFunction([SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszScheme": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwSchemeLength": SimTypeInt(signed=False, label="UInt32"), "nScheme": SimTypeInt(signed=False, label="INTERNET_SCHEME"), "lpszHostName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHostNameLength": SimTypeInt(signed=False, label="UInt32"), "nPort": SimTypeShort(signed=False, label="UInt16"), "lpszUserName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwUserNameLength": SimTypeInt(signed=False, label="UInt32"), "lpszPassword": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwPasswordLength": SimTypeInt(signed=False, label="UInt32"), "lpszUrlPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwUrlPathLength": SimTypeInt(signed=False, label="UInt32"), "lpszExtraInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwExtraInfoLength": SimTypeInt(signed=False, label="UInt32")}, name="URL_COMPONENTSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpUrlComponents", "dwFlags", "lpszUrl", "lpdwUrlLength"]),
        # 
        'InternetCanonicalizeUrlA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "lpszBuffer", "lpdwBufferLength", "dwFlags"]),
        # 
        'InternetCanonicalizeUrlW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "lpszBuffer", "lpdwBufferLength", "dwFlags"]),
        # 
        'InternetCombineUrlA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszBaseUrl", "lpszRelativeUrl", "lpszBuffer", "lpdwBufferLength", "dwFlags"]),
        # 
        'InternetCombineUrlW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszBaseUrl", "lpszRelativeUrl", "lpszBuffer", "lpdwBufferLength", "dwFlags"]),
        # 
        'InternetOpenA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["lpszAgent", "dwAccessType", "lpszProxy", "lpszProxyBypass", "dwFlags"]),
        # 
        'InternetOpenW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["lpszAgent", "dwAccessType", "lpszProxy", "lpszProxyBypass", "dwFlags"]),
        # 
        'InternetCloseHandle': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hInternet"]),
        # 
        'InternetConnectA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hInternet", "lpszServerName", "nServerPort", "lpszUserName", "lpszPassword", "dwService", "dwFlags", "dwContext"]),
        # 
        'InternetConnectW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hInternet", "lpszServerName", "nServerPort", "lpszUserName", "lpszPassword", "dwService", "dwFlags", "dwContext"]),
        # 
        'InternetOpenUrlA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hInternet", "lpszUrl", "lpszHeaders", "dwHeadersLength", "dwFlags", "dwContext"]),
        # 
        'InternetOpenUrlW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hInternet", "lpszUrl", "lpszHeaders", "dwHeadersLength", "dwFlags", "dwContext"]),
        # 
        'InternetReadFile': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFile", "lpBuffer", "dwNumberOfBytesToRead", "lpdwNumberOfBytesRead"]),
        # 
        'InternetReadFileExA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="INTERNET_BUFFERSA"), offset=0), "lpcszHeader": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeadersLength": SimTypeInt(signed=False, label="UInt32"), "dwHeadersTotal": SimTypeInt(signed=False, label="UInt32"), "lpvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBufferTotal": SimTypeInt(signed=False, label="UInt32"), "dwOffsetLow": SimTypeInt(signed=False, label="UInt32"), "dwOffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_BUFFERSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFile", "lpBuffersOut", "dwFlags", "dwContext"]),
        # 
        'InternetReadFileExW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="INTERNET_BUFFERSW"), offset=0), "lpcszHeader": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeadersLength": SimTypeInt(signed=False, label="UInt32"), "dwHeadersTotal": SimTypeInt(signed=False, label="UInt32"), "lpvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBufferTotal": SimTypeInt(signed=False, label="UInt32"), "dwOffsetLow": SimTypeInt(signed=False, label="UInt32"), "dwOffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_BUFFERSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFile", "lpBuffersOut", "dwFlags", "dwContext"]),
        # 
        'InternetSetFilePointer': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hFile", "lDistanceToMove", "lpDistanceToMoveHigh", "dwMoveMethod", "dwContext"]),
        # 
        'InternetWriteFile': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFile", "lpBuffer", "dwNumberOfBytesToWrite", "lpdwNumberOfBytesWritten"]),
        # 
        'InternetQueryDataAvailable': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFile", "lpdwNumberOfBytesAvailable", "dwFlags", "dwContext"]),
        # 
        'InternetFindNextFileA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFind", "lpvFindData"]),
        # 
        'InternetFindNextFileW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFind", "lpvFindData"]),
        # 
        'InternetQueryOptionA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hInternet", "dwOption", "lpBuffer", "lpdwBufferLength"]),
        # 
        'InternetQueryOptionW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hInternet", "dwOption", "lpBuffer", "lpdwBufferLength"]),
        # 
        'InternetSetOptionA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hInternet", "dwOption", "lpBuffer", "dwBufferLength"]),
        # 
        'InternetSetOptionW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hInternet", "dwOption", "lpBuffer", "dwBufferLength"]),
        # 
        'InternetSetOptionExA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hInternet", "dwOption", "lpBuffer", "dwBufferLength", "dwFlags"]),
        # 
        'InternetSetOptionExW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hInternet", "dwOption", "lpBuffer", "dwBufferLength", "dwFlags"]),
        # 
        'InternetLockRequestFile': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hInternet", "lphLockRequestInfo"]),
        # 
        'InternetUnlockRequestFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hLockRequestInfo"]),
        # 
        'InternetGetLastResponseInfoA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpdwError", "lpszBuffer", "lpdwBufferLength"]),
        # 
        'InternetGetLastResponseInfoW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpdwError", "lpszBuffer", "lpdwBufferLength"]),
        # 
        'InternetSetStatusCallbackA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["hInternet", "dwContext", "dwInternetStatus", "lpvStatusInformation", "dwStatusInformationLength"]), offset=0)], SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["hInternet", "dwContext", "dwInternetStatus", "lpvStatusInformation", "dwStatusInformationLength"]), offset=0), arg_names=["hInternet", "lpfnInternetCallback"]),
        # 
        'InternetSetStatusCallbackW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["hInternet", "dwContext", "dwInternetStatus", "lpvStatusInformation", "dwStatusInformationLength"]), offset=0)], SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["hInternet", "dwContext", "dwInternetStatus", "lpvStatusInformation", "dwStatusInformationLength"]), offset=0), arg_names=["hInternet", "lpfnInternetCallback"]),
        # 
        'InternetSetStatusCallback': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["hInternet", "dwContext", "dwInternetStatus", "lpvStatusInformation", "dwStatusInformationLength"]), offset=0)], SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["hInternet", "dwContext", "dwInternetStatus", "lpvStatusInformation", "dwStatusInformationLength"]), offset=0), arg_names=["hInternet", "lpfnInternetCallback"]),
        # 
        'FtpFindFirstFileA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwFileAttributes": SimTypeInt(signed=False, label="UInt32"), "ftCreationTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastWriteTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "nFileSizeHigh": SimTypeInt(signed=False, label="UInt32"), "nFileSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwReserved0": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "cFileName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "cAlternateFileName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="WIN32_FIND_DATAA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hConnect", "lpszSearchFile", "lpFindFileData", "dwFlags", "dwContext"]),
        # 
        'FtpFindFirstFileW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwFileAttributes": SimTypeInt(signed=False, label="UInt32"), "ftCreationTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastWriteTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "nFileSizeHigh": SimTypeInt(signed=False, label="UInt32"), "nFileSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwReserved0": SimTypeInt(signed=False, label="UInt32"), "dwReserved1": SimTypeInt(signed=False, label="UInt32"), "cFileName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "cAlternateFileName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 14)}, name="WIN32_FIND_DATAW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hConnect", "lpszSearchFile", "lpFindFileData", "dwFlags", "dwContext"]),
        # 
        'FtpGetFileA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszRemoteFile", "lpszNewFile", "fFailIfExists", "dwFlagsAndAttributes", "dwFlags", "dwContext"]),
        # 
        'FtpGetFileW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszRemoteFile", "lpszNewFile", "fFailIfExists", "dwFlagsAndAttributes", "dwFlags", "dwContext"]),
        # 
        'FtpPutFileA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="FTP_FLAGS"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszLocalFile", "lpszNewRemoteFile", "dwFlags", "dwContext"]),
        # 
        'FtpPutFileW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="FTP_FLAGS"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszLocalFile", "lpszNewRemoteFile", "dwFlags", "dwContext"]),
        # 
        'FtpGetFileEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFtpSession", "lpszRemoteFile", "lpszNewFile", "fFailIfExists", "dwFlagsAndAttributes", "dwFlags", "dwContext"]),
        # 
        'FtpPutFileEx': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFtpSession", "lpszLocalFile", "lpszNewRemoteFile", "dwFlags", "dwContext"]),
        # 
        'FtpDeleteFileA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszFileName"]),
        # 
        'FtpDeleteFileW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszFileName"]),
        # 
        'FtpRenameFileA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszExisting", "lpszNew"]),
        # 
        'FtpRenameFileW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszExisting", "lpszNew"]),
        # 
        'FtpOpenFileA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="FTP_FLAGS"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hConnect", "lpszFileName", "dwAccess", "dwFlags", "dwContext"]),
        # 
        'FtpOpenFileW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="FTP_FLAGS"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hConnect", "lpszFileName", "dwAccess", "dwFlags", "dwContext"]),
        # 
        'FtpCreateDirectoryA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszDirectory"]),
        # 
        'FtpCreateDirectoryW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszDirectory"]),
        # 
        'FtpRemoveDirectoryA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszDirectory"]),
        # 
        'FtpRemoveDirectoryW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszDirectory"]),
        # 
        'FtpSetCurrentDirectoryA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszDirectory"]),
        # 
        'FtpSetCurrentDirectoryW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszDirectory"]),
        # 
        'FtpGetCurrentDirectoryA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszCurrentDirectory", "lpdwCurrentDirectory"]),
        # 
        'FtpGetCurrentDirectoryW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszCurrentDirectory", "lpdwCurrentDirectory"]),
        # 
        'FtpCommandA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="FTP_FLAGS"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "fExpectResponse", "dwFlags", "lpszCommand", "dwContext", "phFtpCommand"]),
        # 
        'FtpCommandW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="FTP_FLAGS"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "fExpectResponse", "dwFlags", "lpszCommand", "dwContext", "phFtpCommand"]),
        # 
        'FtpGetFileSize': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hFile", "lpdwFileSizeHigh"]),
        # 
        'GopherCreateLocatorA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszHost", "nServerPort", "lpszDisplayString", "lpszSelectorString", "dwGopherType", "lpszLocator", "lpdwBufferLength"]),
        # 
        'GopherCreateLocatorW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszHost", "nServerPort", "lpszDisplayString", "lpszSelectorString", "dwGopherType", "lpszLocator", "lpdwBufferLength"]),
        # 
        'GopherGetLocatorTypeA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszLocator", "lpdwGopherType"]),
        # 
        'GopherGetLocatorTypeW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszLocator", "lpdwGopherType"]),
        # 
        'GopherFindFirstFileA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"DisplayString": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 129), "GopherType": SimTypeInt(signed=False, label="GOPHER_TYPE"), "SizeLow": SimTypeInt(signed=False, label="UInt32"), "SizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModificationTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Locator": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 654)}, name="GOPHER_FIND_DATAA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hConnect", "lpszLocator", "lpszSearchString", "lpFindData", "dwFlags", "dwContext"]),
        # 
        'GopherFindFirstFileW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"DisplayString": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 129), "GopherType": SimTypeInt(signed=False, label="GOPHER_TYPE"), "SizeLow": SimTypeInt(signed=False, label="UInt32"), "SizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModificationTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Locator": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 654)}, name="GOPHER_FIND_DATAW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hConnect", "lpszLocator", "lpszSearchString", "lpFindData", "dwFlags", "dwContext"]),
        # 
        'GopherOpenFileA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hConnect", "lpszLocator", "lpszView", "dwFlags", "dwContext"]),
        # 
        'GopherOpenFileW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hConnect", "lpszLocator", "lpszView", "dwFlags", "dwContext"]),
        # 
        'GopherGetAttributeA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"CategoryId": SimTypeInt(signed=False, label="UInt32"), "AttributeId": SimTypeInt(signed=False, label="UInt32"), "AttributeType": SimUnion({"Admin": SimStruct({"Comment": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "EmailAddress": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_ADMIN_ATTRIBUTE_TYPE", pack=False, align=None), "ModDate": SimStruct({"DateAndTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="GOPHER_MOD_DATE_ATTRIBUTE_TYPE", pack=False, align=None), "Ttl": SimStruct({"Ttl": SimTypeInt(signed=False, label="UInt32")}, name="GOPHER_TTL_ATTRIBUTE_TYPE", pack=False, align=None), "Score": SimStruct({"Score": SimTypeInt(signed=True, label="Int32")}, name="GOPHER_SCORE_ATTRIBUTE_TYPE", pack=False, align=None), "ScoreRange": SimStruct({"LowerBound": SimTypeInt(signed=True, label="Int32"), "UpperBound": SimTypeInt(signed=True, label="Int32")}, name="GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE", pack=False, align=None), "Site": SimStruct({"Site": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_SITE_ATTRIBUTE_TYPE", pack=False, align=None), "Organization": SimStruct({"Organization": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_ORGANIZATION_ATTRIBUTE_TYPE", pack=False, align=None), "Location": SimStruct({"Location": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_LOCATION_ATTRIBUTE_TYPE", pack=False, align=None), "GeographicalLocation": SimStruct({"DegreesNorth": SimTypeInt(signed=True, label="Int32"), "MinutesNorth": SimTypeInt(signed=True, label="Int32"), "SecondsNorth": SimTypeInt(signed=True, label="Int32"), "DegreesEast": SimTypeInt(signed=True, label="Int32"), "MinutesEast": SimTypeInt(signed=True, label="Int32"), "SecondsEast": SimTypeInt(signed=True, label="Int32")}, name="GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE", pack=False, align=None), "TimeZone": SimStruct({"Zone": SimTypeInt(signed=True, label="Int32")}, name="GOPHER_TIMEZONE_ATTRIBUTE_TYPE", pack=False, align=None), "Provider": SimStruct({"Provider": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_PROVIDER_ATTRIBUTE_TYPE", pack=False, align=None), "Version": SimStruct({"Version": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_VERSION_ATTRIBUTE_TYPE", pack=False, align=None), "Abstract": SimStruct({"ShortAbstract": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "AbstractFile": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_ABSTRACT_ATTRIBUTE_TYPE", pack=False, align=None), "View": SimStruct({"ContentType": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Language": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Size": SimTypeInt(signed=False, label="UInt32")}, name="GOPHER_VIEW_ATTRIBUTE_TYPE", pack=False, align=None), "Veronica": SimStruct({"TreeWalk": SimTypeInt(signed=True, label="Int32")}, name="GOPHER_VERONICA_ATTRIBUTE_TYPE", pack=False, align=None), "Ask": SimStruct({"QuestionType": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "QuestionText": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_ASK_ATTRIBUTE_TYPE", pack=False, align=None), "Unknown": SimStruct({"Text": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_UNKNOWN_ATTRIBUTE_TYPE", pack=False, align=None)}, name="<anon>", label="None")}, name="GOPHER_ATTRIBUTE_TYPE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpAttributeInfo", "dwError"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszLocator", "lpszAttributeName", "lpBuffer", "dwBufferLength", "lpdwCharactersReturned", "lpfnEnumerator", "dwContext"]),
        # 
        'GopherGetAttributeW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"CategoryId": SimTypeInt(signed=False, label="UInt32"), "AttributeId": SimTypeInt(signed=False, label="UInt32"), "AttributeType": SimUnion({"Admin": SimStruct({"Comment": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "EmailAddress": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_ADMIN_ATTRIBUTE_TYPE", pack=False, align=None), "ModDate": SimStruct({"DateAndTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)}, name="GOPHER_MOD_DATE_ATTRIBUTE_TYPE", pack=False, align=None), "Ttl": SimStruct({"Ttl": SimTypeInt(signed=False, label="UInt32")}, name="GOPHER_TTL_ATTRIBUTE_TYPE", pack=False, align=None), "Score": SimStruct({"Score": SimTypeInt(signed=True, label="Int32")}, name="GOPHER_SCORE_ATTRIBUTE_TYPE", pack=False, align=None), "ScoreRange": SimStruct({"LowerBound": SimTypeInt(signed=True, label="Int32"), "UpperBound": SimTypeInt(signed=True, label="Int32")}, name="GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE", pack=False, align=None), "Site": SimStruct({"Site": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_SITE_ATTRIBUTE_TYPE", pack=False, align=None), "Organization": SimStruct({"Organization": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_ORGANIZATION_ATTRIBUTE_TYPE", pack=False, align=None), "Location": SimStruct({"Location": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_LOCATION_ATTRIBUTE_TYPE", pack=False, align=None), "GeographicalLocation": SimStruct({"DegreesNorth": SimTypeInt(signed=True, label="Int32"), "MinutesNorth": SimTypeInt(signed=True, label="Int32"), "SecondsNorth": SimTypeInt(signed=True, label="Int32"), "DegreesEast": SimTypeInt(signed=True, label="Int32"), "MinutesEast": SimTypeInt(signed=True, label="Int32"), "SecondsEast": SimTypeInt(signed=True, label="Int32")}, name="GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE", pack=False, align=None), "TimeZone": SimStruct({"Zone": SimTypeInt(signed=True, label="Int32")}, name="GOPHER_TIMEZONE_ATTRIBUTE_TYPE", pack=False, align=None), "Provider": SimStruct({"Provider": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_PROVIDER_ATTRIBUTE_TYPE", pack=False, align=None), "Version": SimStruct({"Version": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_VERSION_ATTRIBUTE_TYPE", pack=False, align=None), "Abstract": SimStruct({"ShortAbstract": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "AbstractFile": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_ABSTRACT_ATTRIBUTE_TYPE", pack=False, align=None), "View": SimStruct({"ContentType": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Language": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "Size": SimTypeInt(signed=False, label="UInt32")}, name="GOPHER_VIEW_ATTRIBUTE_TYPE", pack=False, align=None), "Veronica": SimStruct({"TreeWalk": SimTypeInt(signed=True, label="Int32")}, name="GOPHER_VERONICA_ATTRIBUTE_TYPE", pack=False, align=None), "Ask": SimStruct({"QuestionType": SimTypePointer(SimTypeChar(label="SByte"), offset=0), "QuestionText": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_ASK_ATTRIBUTE_TYPE", pack=False, align=None), "Unknown": SimStruct({"Text": SimTypePointer(SimTypeChar(label="SByte"), offset=0)}, name="GOPHER_UNKNOWN_ATTRIBUTE_TYPE", pack=False, align=None)}, name="<anon>", label="None")}, name="GOPHER_ATTRIBUTE_TYPE", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpAttributeInfo", "dwError"]), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hConnect", "lpszLocator", "lpszAttributeName", "lpBuffer", "dwBufferLength", "lpdwCharactersReturned", "lpfnEnumerator", "dwContext"]),
        # 
        'HttpOpenRequestA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hConnect", "lpszVerb", "lpszObjectName", "lpszVersion", "lpszReferrer", "lplpszAcceptTypes", "dwFlags", "dwContext"]),
        # 
        'HttpOpenRequestW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hConnect", "lpszVerb", "lpszObjectName", "lpszVersion", "lpszReferrer", "lplpszAcceptTypes", "dwFlags", "dwContext"]),
        # 
        'HttpAddRequestHeadersA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="HTTP_ADDREQ_FLAG")], SimTypeInt(signed=True, label="Int32"), arg_names=["hRequest", "lpszHeaders", "dwHeadersLength", "dwModifiers"]),
        # 
        'HttpAddRequestHeadersW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="HTTP_ADDREQ_FLAG")], SimTypeInt(signed=True, label="Int32"), arg_names=["hRequest", "lpszHeaders", "dwHeadersLength", "dwModifiers"]),
        # 
        'HttpSendRequestA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hRequest", "lpszHeaders", "dwHeadersLength", "lpOptional", "dwOptionalLength"]),
        # 
        'HttpSendRequestW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hRequest", "lpszHeaders", "dwHeadersLength", "lpOptional", "dwOptionalLength"]),
        # 
        'HttpSendRequestExA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="INTERNET_BUFFERSA"), offset=0), "lpcszHeader": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeadersLength": SimTypeInt(signed=False, label="UInt32"), "dwHeadersTotal": SimTypeInt(signed=False, label="UInt32"), "lpvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBufferTotal": SimTypeInt(signed=False, label="UInt32"), "dwOffsetLow": SimTypeInt(signed=False, label="UInt32"), "dwOffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_BUFFERSA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="INTERNET_BUFFERSA"), offset=0), "lpcszHeader": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeadersLength": SimTypeInt(signed=False, label="UInt32"), "dwHeadersTotal": SimTypeInt(signed=False, label="UInt32"), "lpvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBufferTotal": SimTypeInt(signed=False, label="UInt32"), "dwOffsetLow": SimTypeInt(signed=False, label="UInt32"), "dwOffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_BUFFERSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRequest", "lpBuffersIn", "lpBuffersOut", "dwFlags", "dwContext"]),
        # 
        'HttpSendRequestExW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="INTERNET_BUFFERSW"), offset=0), "lpcszHeader": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeadersLength": SimTypeInt(signed=False, label="UInt32"), "dwHeadersTotal": SimTypeInt(signed=False, label="UInt32"), "lpvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBufferTotal": SimTypeInt(signed=False, label="UInt32"), "dwOffsetLow": SimTypeInt(signed=False, label="UInt32"), "dwOffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_BUFFERSW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="INTERNET_BUFFERSW"), offset=0), "lpcszHeader": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeadersLength": SimTypeInt(signed=False, label="UInt32"), "dwHeadersTotal": SimTypeInt(signed=False, label="UInt32"), "lpvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBufferTotal": SimTypeInt(signed=False, label="UInt32"), "dwOffsetLow": SimTypeInt(signed=False, label="UInt32"), "dwOffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_BUFFERSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRequest", "lpBuffersIn", "lpBuffersOut", "dwFlags", "dwContext"]),
        # 
        'HttpEndRequestA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="INTERNET_BUFFERSA"), offset=0), "lpcszHeader": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeadersLength": SimTypeInt(signed=False, label="UInt32"), "dwHeadersTotal": SimTypeInt(signed=False, label="UInt32"), "lpvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBufferTotal": SimTypeInt(signed=False, label="UInt32"), "dwOffsetLow": SimTypeInt(signed=False, label="UInt32"), "dwOffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_BUFFERSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRequest", "lpBuffersOut", "dwFlags", "dwContext"]),
        # 
        'HttpEndRequestW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="INTERNET_BUFFERSW"), offset=0), "lpcszHeader": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeadersLength": SimTypeInt(signed=False, label="UInt32"), "dwHeadersTotal": SimTypeInt(signed=False, label="UInt32"), "lpvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBufferTotal": SimTypeInt(signed=False, label="UInt32"), "dwOffsetLow": SimTypeInt(signed=False, label="UInt32"), "dwOffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_BUFFERSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRequest", "lpBuffersOut", "dwFlags", "dwContext"]),
        # 
        'HttpQueryInfoA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRequest", "dwInfoLevel", "lpBuffer", "lpdwBufferLength", "lpdwIndex"]),
        # 
        'HttpQueryInfoW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hRequest", "dwInfoLevel", "lpBuffer", "lpdwBufferLength", "lpdwIndex"]),
        # 
        'InternetSetCookieA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "lpszCookieName", "lpszCookieData"]),
        # 
        'InternetSetCookieW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "lpszCookieName", "lpszCookieData"]),
        # 
        'InternetGetCookieA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "lpszCookieName", "lpszCookieData", "lpdwSize"]),
        # 
        'InternetGetCookieW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "lpszCookieName", "lpszCookieData", "lpdwSize"]),
        # 
        'InternetSetCookieExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszUrl", "lpszCookieName", "lpszCookieData", "dwFlags", "dwReserved"]),
        # 
        'InternetSetCookieExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszUrl", "lpszCookieName", "lpszCookieData", "dwFlags", "dwReserved"]),
        # 
        'InternetGetCookieExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="INTERNET_COOKIE_FLAGS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "lpszCookieName", "lpszCookieData", "lpdwSize", "dwFlags", "lpReserved"]),
        # 
        'InternetGetCookieExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="INTERNET_COOKIE_FLAGS"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "lpszCookieName", "lpszCookieData", "lpdwSize", "dwFlags", "lpReserved"]),
        # 
        'InternetFreeCookies': SimTypeFunction([SimTypePointer(SimStruct({"pwszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszDomain": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "ftExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "fExpiresSet": SimTypeInt(signed=True, label="Int32")}, name="INTERNET_COOKIE2", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="Void"), arg_names=["pCookies", "dwCookieCount"]),
        # 
        'InternetGetCookieEx2': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"pwszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszDomain": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "ftExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "fExpiresSet": SimTypeInt(signed=True, label="Int32")}, name="INTERNET_COOKIE2", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pcwszUrl", "pcwszCookieName", "dwFlags", "ppCookies", "pdwCookieCount"]),
        # 
        'InternetSetCookieEx2': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"pwszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszValue": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszDomain": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszPath": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwFlags": SimTypeInt(signed=False, label="UInt32"), "ftExpires": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "fExpiresSet": SimTypeInt(signed=True, label="Int32")}, name="INTERNET_COOKIE2", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pcwszUrl", "pCookie", "pcwszP3PPolicy", "dwFlags", "pdwCookieState"]),
        # 
        'InternetAttemptConnect': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwReserved"]),
        # 
        'InternetCheckConnectionA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "dwFlags", "dwReserved"]),
        # 
        'InternetCheckConnectionW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "dwFlags", "dwReserved"]),
        # 
        'ResumeSuspendedDownload': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hRequest", "dwResultCode"]),
        # 
        'InternetErrorDlg': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hWnd", "hRequest", "dwError", "dwFlags", "lppvData"]),
        # 
        'InternetConfirmZoneCrossingA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hWnd", "szUrlPrev", "szUrlNew", "bPost"]),
        # 
        'InternetConfirmZoneCrossingW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hWnd", "szUrlPrev", "szUrlNew", "bPost"]),
        # 
        'InternetConfirmZoneCrossing': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hWnd", "szUrlPrev", "szUrlNew", "bPost"]),
        # 
        'CreateUrlCacheEntryA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "dwExpectedFileSize", "lpszFileExtension", "lpszFileName", "dwReserved"]),
        # 
        'CreateUrlCacheEntryW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "dwExpectedFileSize", "lpszFileExtension", "lpszFileName", "dwReserved"]),
        # 
        'CommitUrlCacheEntryA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "lpszLocalFileName", "ExpireTime", "LastModifiedTime", "CacheEntryType", "lpHeaderInfo", "cchHeaderInfo", "lpszFileExtension", "lpszOriginalUrl"]),
        # 
        'CommitUrlCacheEntryW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "lpszLocalFileName", "ExpireTime", "LastModifiedTime", "CacheEntryType", "lpszHeaderInfo", "cchHeaderInfo", "lpszFileExtension", "lpszOriginalUrl"]),
        # 
        'RetrieveUrlCacheEntryFileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "lpCacheEntryInfo", "lpcbCacheEntryInfo", "dwReserved"]),
        # 
        'RetrieveUrlCacheEntryFileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "lpCacheEntryInfo", "lpcbCacheEntryInfo", "dwReserved"]),
        # 
        'UnlockUrlCacheEntryFileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "dwReserved"]),
        # 
        'UnlockUrlCacheEntryFileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "dwReserved"]),
        # 
        'UnlockUrlCacheEntryFile': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "dwReserved"]),
        # 
        'RetrieveUrlCacheEntryStreamA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpszUrlName", "lpCacheEntryInfo", "lpcbCacheEntryInfo", "fRandomRead", "dwReserved"]),
        # 
        'RetrieveUrlCacheEntryStreamW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpszUrlName", "lpCacheEntryInfo", "lpcbCacheEntryInfo", "fRandomRead", "dwReserved"]),
        # 
        'ReadUrlCacheEntryStream': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hUrlCacheStream", "dwLocation", "lpBuffer", "lpdwLen", "Reserved"]),
        # 
        'ReadUrlCacheEntryStreamEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hUrlCacheStream", "qwLocation", "lpBuffer", "lpdwLen"]),
        # 
        'UnlockUrlCacheEntryStream': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hUrlCacheStream", "Reserved"]),
        # 
        'GetUrlCacheEntryInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "lpCacheEntryInfo", "lpcbCacheEntryInfo"]),
        # 
        'GetUrlCacheEntryInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "lpCacheEntryInfo", "lpcbCacheEntryInfo"]),
        # 
        'FindFirstUrlCacheGroup': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["dwFlags", "dwFilter", "lpSearchCondition", "dwSearchCondition", "lpGroupId", "lpReserved"]),
        # 
        'FindNextUrlCacheGroup': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeLongLong(signed=True, label="Int64"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFind", "lpGroupId", "lpReserved"]),
        # 
        'GetUrlCacheGroupAttributeA': SimTypeFunction([SimTypeLongLong(signed=True, label="Int64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwGroupSize": SimTypeInt(signed=False, label="UInt32"), "dwGroupFlags": SimTypeInt(signed=False, label="UInt32"), "dwGroupType": SimTypeInt(signed=False, label="UInt32"), "dwDiskUsage": SimTypeInt(signed=False, label="UInt32"), "dwDiskQuota": SimTypeInt(signed=False, label="UInt32"), "dwOwnerStorage": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "szGroupName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 120)}, name="INTERNET_CACHE_GROUP_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["gid", "dwFlags", "dwAttributes", "lpGroupInfo", "lpcbGroupInfo", "lpReserved"]),
        # 
        'GetUrlCacheGroupAttributeW': SimTypeFunction([SimTypeLongLong(signed=True, label="Int64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwGroupSize": SimTypeInt(signed=False, label="UInt32"), "dwGroupFlags": SimTypeInt(signed=False, label="UInt32"), "dwGroupType": SimTypeInt(signed=False, label="UInt32"), "dwDiskUsage": SimTypeInt(signed=False, label="UInt32"), "dwDiskQuota": SimTypeInt(signed=False, label="UInt32"), "dwOwnerStorage": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "szGroupName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 120)}, name="INTERNET_CACHE_GROUP_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["gid", "dwFlags", "dwAttributes", "lpGroupInfo", "lpcbGroupInfo", "lpReserved"]),
        # 
        'SetUrlCacheGroupAttributeA': SimTypeFunction([SimTypeLongLong(signed=True, label="Int64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwGroupSize": SimTypeInt(signed=False, label="UInt32"), "dwGroupFlags": SimTypeInt(signed=False, label="UInt32"), "dwGroupType": SimTypeInt(signed=False, label="UInt32"), "dwDiskUsage": SimTypeInt(signed=False, label="UInt32"), "dwDiskQuota": SimTypeInt(signed=False, label="UInt32"), "dwOwnerStorage": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "szGroupName": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 120)}, name="INTERNET_CACHE_GROUP_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["gid", "dwFlags", "dwAttributes", "lpGroupInfo", "lpReserved"]),
        # 
        'SetUrlCacheGroupAttributeW': SimTypeFunction([SimTypeLongLong(signed=True, label="Int64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwGroupSize": SimTypeInt(signed=False, label="UInt32"), "dwGroupFlags": SimTypeInt(signed=False, label="UInt32"), "dwGroupType": SimTypeInt(signed=False, label="UInt32"), "dwDiskUsage": SimTypeInt(signed=False, label="UInt32"), "dwDiskQuota": SimTypeInt(signed=False, label="UInt32"), "dwOwnerStorage": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 4), "szGroupName": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 120)}, name="INTERNET_CACHE_GROUP_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["gid", "dwFlags", "dwAttributes", "lpGroupInfo", "lpReserved"]),
        # 
        'GetUrlCacheEntryInfoExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "lpCacheEntryInfo", "lpcbCacheEntryInfo", "lpszRedirectUrl", "lpcbRedirectUrl", "lpReserved", "dwFlags"]),
        # 
        'GetUrlCacheEntryInfoExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "lpCacheEntryInfo", "lpcbCacheEntryInfo", "lpszRedirectUrl", "lpcbRedirectUrl", "lpReserved", "dwFlags"]),
        # 
        'SetUrlCacheEntryInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "lpCacheEntryInfo", "dwFieldControl"]),
        # 
        'SetUrlCacheEntryInfoW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "lpCacheEntryInfo", "dwFieldControl"]),
        # 
        'CreateUrlCacheGroup': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeLongLong(signed=True, label="Int64"), arg_names=["dwFlags", "lpReserved"]),
        # 
        'DeleteUrlCacheGroup': SimTypeFunction([SimTypeLongLong(signed=True, label="Int64"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["GroupId", "dwFlags", "lpReserved"]),
        # 
        'SetUrlCacheEntryGroupA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "dwFlags", "GroupId", "pbGroupAttributes", "cbGroupAttributes", "lpReserved"]),
        # 
        'SetUrlCacheEntryGroupW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "dwFlags", "GroupId", "pbGroupAttributes", "cbGroupAttributes", "lpReserved"]),
        # 
        'SetUrlCacheEntryGroup': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "dwFlags", "GroupId", "pbGroupAttributes", "cbGroupAttributes", "lpReserved"]),
        # 
        'FindFirstUrlCacheEntryExA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpszUrlSearchPattern", "dwFlags", "dwFilter", "GroupId", "lpFirstCacheEntryInfo", "lpcbCacheEntryInfo", "lpGroupAttributes", "lpcbGroupAttributes", "lpReserved"]),
        # 
        'FindFirstUrlCacheEntryExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpszUrlSearchPattern", "dwFlags", "dwFilter", "GroupId", "lpFirstCacheEntryInfo", "lpcbCacheEntryInfo", "lpGroupAttributes", "lpcbGroupAttributes", "lpReserved"]),
        # 
        'FindNextUrlCacheEntryExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEnumHandle", "lpNextCacheEntryInfo", "lpcbCacheEntryInfo", "lpGroupAttributes", "lpcbGroupAttributes", "lpReserved"]),
        # 
        'FindNextUrlCacheEntryExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEnumHandle", "lpNextCacheEntryInfo", "lpcbCacheEntryInfo", "lpGroupAttributes", "lpcbGroupAttributes", "lpReserved"]),
        # 
        'FindFirstUrlCacheEntryA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpszUrlSearchPattern", "lpFirstCacheEntryInfo", "lpcbCacheEntryInfo"]),
        # 
        'FindFirstUrlCacheEntryW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["lpszUrlSearchPattern", "lpFirstCacheEntryInfo", "lpcbCacheEntryInfo"]),
        # 
        'FindNextUrlCacheEntryA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEnumHandle", "lpNextCacheEntryInfo", "lpcbCacheEntryInfo"]),
        # 
        'FindNextUrlCacheEntryW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Char"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEnumHandle", "lpNextCacheEntryInfo", "lpcbCacheEntryInfo"]),
        # 
        'FindCloseUrlCache': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEnumHandle"]),
        # 
        'DeleteUrlCacheEntryA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName"]),
        # 
        'DeleteUrlCacheEntryW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName"]),
        # 
        'DeleteUrlCacheEntry': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName"]),
        # 
        'InternetDialA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwndParent", "lpszConnectoid", "dwFlags", "lpdwConnection", "dwReserved"]),
        # 
        'InternetDialW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwndParent", "lpszConnectoid", "dwFlags", "lpdwConnection", "dwReserved"]),
        # 
        'InternetDial': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwndParent", "lpszConnectoid", "dwFlags", "lpdwConnection", "dwReserved"]),
        # 
        'InternetHangUp': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwConnection", "dwReserved"]),
        # 
        'InternetGoOnlineA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszURL", "hwndParent", "dwFlags"]),
        # 
        'InternetGoOnlineW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszURL", "hwndParent", "dwFlags"]),
        # 
        'InternetGoOnline': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszURL", "hwndParent", "dwFlags"]),
        # 
        'InternetAutodial': SimTypeFunction([SimTypeInt(signed=False, label="INTERNET_AUTODIAL"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwFlags", "hwndParent"]),
        # 
        'InternetAutodialHangup': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwReserved"]),
        # 
        'InternetGetConnectedState': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="INTERNET_CONNECTION"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpdwFlags", "dwReserved"]),
        # 
        'InternetGetConnectedStateExA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="INTERNET_CONNECTION"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpdwFlags", "lpszConnectionName", "cchNameLen", "dwReserved"]),
        # 
        'InternetGetConnectedStateExW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="INTERNET_CONNECTION"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpdwFlags", "lpszConnectionName", "cchNameLen", "dwReserved"]),
        # 
        'DeleteWpadCacheForNetworks': SimTypeFunction([SimTypeInt(signed=False, label="WPAD_CACHE_DELETE")], SimTypeInt(signed=True, label="Int32"), arg_names=["param0"]),
        # 
        'InternetInitializeAutoProxyDll': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwReserved"]),
        # 
        'DetectAutoProxyUrl': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="PROXY_AUTO_DETECT_TYPE")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszAutoProxyUrl", "cchAutoProxyUrl", "dwDetectFlags"]),
        # 
        'CreateMD5SSOHash': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszChallengeInfo", "pwszRealm", "pwszTarget", "pbHexHash"]),
        # 
        'InternetGetConnectedStateEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="INTERNET_CONNECTION"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpdwFlags", "lpszConnectionName", "dwNameLen", "dwReserved"]),
        # 
        'InternetSetDialStateA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszConnectoid", "dwState", "dwReserved"]),
        # 
        'InternetSetDialStateW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszConnectoid", "dwState", "dwReserved"]),
        # 
        'InternetSetDialState': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszConnectoid", "dwState", "dwReserved"]),
        # 
        'InternetSetPerSiteCookieDecisionA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pchHostName", "dwDecision"]),
        # 
        'InternetSetPerSiteCookieDecisionW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pchHostName", "dwDecision"]),
        # 
        'InternetGetPerSiteCookieDecisionA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pchHostName", "pResult"]),
        # 
        'InternetGetPerSiteCookieDecisionW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pchHostName", "pResult"]),
        # 
        'InternetClearAllPerSiteCookieDecisions': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'InternetEnumPerSiteCookieDecisionA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszSiteName", "pcSiteNameSize", "pdwDecision", "dwIndex"]),
        # 
        'InternetEnumPerSiteCookieDecisionW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["pszSiteName", "pcSiteNameSize", "pdwDecision", "dwIndex"]),
        # 
        'PrivacySetZonePreferenceW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwZone", "dwType", "dwTemplate", "pszPreference"]),
        # 
        'PrivacyGetZonePreferenceW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwZone", "dwType", "pdwTemplate", "pszBuffer", "pdwBufferLength"]),
        # 
        'HttpIsHostHstsEnabled': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pcwszUrl", "pfIsHsts"]),
        # 
        'InternetAlgIdToStringA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ai", "lpstr", "lpdwstrLength", "dwReserved"]),
        # 
        'InternetAlgIdToStringW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ai", "lpstr", "lpdwstrLength", "dwReserved"]),
        # 
        'InternetSecurityProtocolToStringA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwProtocol", "lpstr", "lpdwstrLength", "dwReserved"]),
        # 
        'InternetSecurityProtocolToStringW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["dwProtocol", "lpstr", "lpdwstrLength", "dwReserved"]),
        # 
        'InternetGetSecurityInfoByURLA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszURL", "ppCertChain", "pdwSecureFlags"]),
        # 
        'InternetGetSecurityInfoByURLW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszURL", "ppCertChain", "pdwSecureFlags"]),
        # 
        'InternetGetSecurityInfoByURL': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cChain": SimTypeInt(signed=False, label="UInt32"), "rgpChain": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "cElement": SimTypeInt(signed=False, label="UInt32"), "rgpElement": SimTypePointer(SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCertContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCertEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCertEncoded": SimTypeInt(signed=False, label="UInt32"), "pCertInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "NotBefore": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NotAfter": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "Subject": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SubjectPublicKeyInfo": SimStruct({"Algorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "PublicKey": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None)}, name="CERT_PUBLIC_KEY_INFO", pack=False, align=None), "IssuerUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "SubjectUniqueId": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cUnusedBits": SimTypeInt(signed=False, label="UInt32")}, name="CRYPT_BIT_BLOB", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CERT_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CERT_CONTEXT", pack=False, align=None), offset=0), "TrustStatus": SimStruct({"dwErrorStatus": SimTypeInt(signed=False, label="UInt32"), "dwInfoStatus": SimTypeInt(signed=False, label="UInt32")}, name="CERT_TRUST_STATUS", pack=False, align=None), "pRevocationInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "dwRevocationResult": SimTypeInt(signed=False, label="UInt32"), "pszRevocationOid": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "pvOidSpecificInfo": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "fHasFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pBaseCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pDeltaCrlContext": SimTypePointer(SimStruct({"dwCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCrlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCrlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCrlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SignatureAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "Issuer": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cCRLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCRLEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="CRL_CONTEXT", pack=False, align=None), offset=0), "pCrlEntry": SimTypePointer(SimStruct({"SerialNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "RevocationDate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CRL_ENTRY", pack=False, align=None), offset=0), "fDeltaCrlEntry": SimTypeInt(signed=True, label="Int32")}, name="CERT_REVOCATION_CRL_INFO", pack=False, align=None), offset=0)}, name="CERT_REVOCATION_INFO", pack=False, align=None), offset=0), "pIssuanceUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pApplicationUsage": SimTypePointer(SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), offset=0), "pwszExtendedErrorInfo": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="CERT_CHAIN_ELEMENT", pack=False, align=None), offset=0), offset=0), "pTrustListInfo": SimTypePointer(SimStruct({"cbSize": SimTypeInt(signed=False, label="UInt32"), "pCtlEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "pCtlContext": SimTypePointer(SimStruct({"dwMsgAndCertEncodingType": SimTypeInt(signed=False, label="UInt32"), "pbCtlEncoded": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlEncoded": SimTypeInt(signed=False, label="UInt32"), "pCtlInfo": SimTypePointer(SimStruct({"dwVersion": SimTypeInt(signed=False, label="UInt32"), "SubjectUsage": SimStruct({"cUsageIdentifier": SimTypeInt(signed=False, label="UInt32"), "rgpszUsageIdentifier": SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), offset=0)}, name="CTL_USAGE", pack=False, align=None), "ListIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "SequenceNumber": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "ThisUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "NextUpdate": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "SubjectAlgorithm": SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Parameters": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CRYPT_ALGORITHM_IDENTIFIER", pack=False, align=None), "cCTLEntry": SimTypeInt(signed=False, label="UInt32"), "rgCTLEntry": SimTypePointer(SimStruct({"SubjectIdentifier": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), "cAttribute": SimTypeInt(signed=False, label="UInt32"), "rgAttribute": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cValue": SimTypeInt(signed=False, label="UInt32"), "rgValue": SimTypePointer(SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None), offset=0)}, name="CRYPT_ATTRIBUTE", pack=False, align=None), offset=0)}, name="CTL_ENTRY", pack=False, align=None), offset=0), "cExtension": SimTypeInt(signed=False, label="UInt32"), "rgExtension": SimTypePointer(SimStruct({"pszObjId": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "fCritical": SimTypeInt(signed=True, label="Int32"), "Value": SimStruct({"cbData": SimTypeInt(signed=False, label="UInt32"), "pbData": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="CRYPTOAPI_BLOB", pack=False, align=None)}, name="CERT_EXTENSION", pack=False, align=None), offset=0)}, name="CTL_INFO", pack=False, align=None), offset=0), "hCertStore": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "hCryptMsg": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "pbCtlContent": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbCtlContent": SimTypeInt(signed=False, label="UInt32")}, name="CTL_CONTEXT", pack=False, align=None), offset=0)}, name="CERT_TRUST_LIST_INFO", pack=False, align=None), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32")}, name="CERT_SIMPLE_CHAIN", pack=False, align=None), offset=0), offset=0), "cLowerQualityChainContext": SimTypeInt(signed=False, label="UInt32"), "rgpLowerQualityChainContext": SimTypePointer(SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), offset=0), "fHasRevocationFreshnessTime": SimTypeInt(signed=True, label="Int32"), "dwRevocationFreshnessTime": SimTypeInt(signed=False, label="UInt32"), "dwCreateFlags": SimTypeInt(signed=False, label="UInt32"), "ChainId": SimTypeBottom(label="Guid")}, name="CERT_CHAIN_CONTEXT", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszURL", "ppCertChain", "pdwSecureFlags"]),
        # 
        'ShowSecurityInfo': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwSize": SimTypeInt(signed=False, label="UInt32"), "pCertificate": SimTypePointer(SimTypeBottom(label="CERT_CONTEXT"), offset=0), "pcCertChain": SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), "connectionInfo": SimTypeBottom(label="SecPkgContext_ConnectionInfo"), "cipherInfo": SimTypeBottom(label="SecPkgContext_CipherInfo"), "pcUnverifiedCertChain": SimTypePointer(SimTypeBottom(label="CERT_CHAIN_CONTEXT"), offset=0), "channelBindingToken": SimTypeBottom(label="SecPkgContext_Bindings")}, name="INTERNET_SECURITY_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hWndParent", "pSecurityInfo"]),
        # 
        'ShowX509EncodedCertificate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hWndParent", "lpCert", "cbCert"]),
        # 
        'ShowClientAuthCerts': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hWndParent"]),
        # 
        'ParseX509EncodedCertificateForListBoxEntry': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpCert", "cbCert", "lpszListBoxEntry", "lpdwListBoxEntry"]),
        # 
        'InternetShowSecurityInfoByURLA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszURL", "hwndParent"]),
        # 
        'InternetShowSecurityInfoByURLW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszURL", "hwndParent"]),
        # 
        'InternetShowSecurityInfoByURL': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszURL", "hwndParent"]),
        # 
        'InternetFortezzaCommand': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwCommand", "hwnd", "dwReserved"]),
        # 
        'InternetQueryFortezzaStatus': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pdwStatus", "dwReserved"]),
        # 
        'InternetWriteFileExA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="INTERNET_BUFFERSA"), offset=0), "lpcszHeader": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeadersLength": SimTypeInt(signed=False, label="UInt32"), "dwHeadersTotal": SimTypeInt(signed=False, label="UInt32"), "lpvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBufferTotal": SimTypeInt(signed=False, label="UInt32"), "dwOffsetLow": SimTypeInt(signed=False, label="UInt32"), "dwOffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_BUFFERSA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFile", "lpBuffersIn", "dwFlags", "dwContext"]),
        # 
        'InternetWriteFileExW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "Next": SimTypePointer(SimTypeBottom(label="INTERNET_BUFFERSW"), offset=0), "lpcszHeader": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwHeadersLength": SimTypeInt(signed=False, label="UInt32"), "dwHeadersTotal": SimTypeInt(signed=False, label="UInt32"), "lpvBuffer": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "dwBufferLength": SimTypeInt(signed=False, label="UInt32"), "dwBufferTotal": SimTypeInt(signed=False, label="UInt32"), "dwOffsetLow": SimTypeInt(signed=False, label="UInt32"), "dwOffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_BUFFERSW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hFile", "lpBuffersIn", "dwFlags", "dwContext"]),
        # 
        'FindP3PPolicySymbol': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszSymbol"]),
        # 
        'HttpGetServerCredentials': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszUrl", "ppwszUserName", "ppwszPassword"]),
        # 
        'HttpPushEnable': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"TransportSettingId": SimTypeBottom(label="Guid"), "BrokerEventId": SimTypeBottom(label="Guid")}, name="HTTP_PUSH_TRANSPORT_SETTING", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRequest", "pTransportSetting", "phWait"]),
        # 
        'HttpPushWait': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="HTTP_PUSH_WAIT_TYPE"), SimTypePointer(SimStruct({"ChannelStatusValid": SimTypeInt(signed=True, label="Int32"), "ChannelStatus": SimTypeInt(signed=False, label="UInt32")}, name="HTTP_PUSH_NOTIFICATION_STATUS", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hWait", "eType", "pNotificationStatus"]),
        # 
        'HttpPushClose': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["hWait"]),
        # 
        'HttpCheckDavComplianceA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "lpszComplianceToken", "lpfFound", "hWnd", "lpvReserved"]),
        # 
        'HttpCheckDavComplianceW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrl", "lpszComplianceToken", "lpfFound", "hWnd", "lpvReserved"]),
        # 
        'IsUrlCacheEntryExpiredA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "dwFlags", "pftLastModified"]),
        # 
        'IsUrlCacheEntryExpiredW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "dwFlags", "pftLastModified"]),
        # 
        'CreateUrlCacheEntryExW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszUrlName", "dwExpectedFileSize", "lpszFileExtension", "lpszFileName", "dwReserved", "fPreserveIncomingFileName"]),
        # 
        'GetUrlCacheEntryBinaryBlob': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Byte"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszUrlName", "dwType", "pftExpireTime", "pftAccessTime", "pftModifiedTime", "ppbBlob", "pcbBlob"]),
        # 
        'CommitUrlCacheEntryBinaryBlob': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszUrlName", "dwType", "ftExpireTime", "ftModifiedTime", "pbBlob", "cbBlob"]),
        # 
        'CreateUrlCacheContainerA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Name", "lpCachePrefix", "lpszCachePath", "KBCacheLimit", "dwContainerType", "dwOptions", "pvBuffer", "cbBuffer"]),
        # 
        'CreateUrlCacheContainerW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Name", "lpCachePrefix", "lpszCachePath", "KBCacheLimit", "dwContainerType", "dwOptions", "pvBuffer", "cbBuffer"]),
        # 
        'DeleteUrlCacheContainerA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Name", "dwOptions"]),
        # 
        'DeleteUrlCacheContainerW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["Name", "dwOptions"]),
        # 
        'FindFirstUrlCacheContainerA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwCacheVersion": SimTypeInt(signed=False, label="UInt32"), "lpszName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszCachePrefix": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszVolumeLabel": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszVolumeTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="INTERNET_CACHE_CONTAINER_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pdwModified", "lpContainerInfo", "lpcbContainerInfo", "dwOptions"]),
        # 
        'FindFirstUrlCacheContainerW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"dwCacheVersion": SimTypeInt(signed=False, label="UInt32"), "lpszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszCachePrefix": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszVolumeLabel": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszVolumeTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="INTERNET_CACHE_CONTAINER_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), arg_names=["pdwModified", "lpContainerInfo", "lpcbContainerInfo", "dwOptions"]),
        # 
        'FindNextUrlCacheContainerA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwCacheVersion": SimTypeInt(signed=False, label="UInt32"), "lpszName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszCachePrefix": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszVolumeLabel": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszVolumeTitle": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="INTERNET_CACHE_CONTAINER_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEnumHandle", "lpContainerInfo", "lpcbContainerInfo"]),
        # 
        'FindNextUrlCacheContainerW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"dwCacheVersion": SimTypeInt(signed=False, label="UInt32"), "lpszName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszCachePrefix": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszVolumeLabel": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpszVolumeTitle": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="INTERNET_CACHE_CONTAINER_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hEnumHandle", "lpContainerInfo", "lpcbContainerInfo"]),
        # 
        'FreeUrlCacheSpaceA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszCachePath", "dwSize", "dwFilter"]),
        # 
        'FreeUrlCacheSpaceW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpszCachePath", "dwSize", "dwFilter"]),
        # 
        'UrlCacheFreeGlobalSpace': SimTypeFunction([SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["ullTargetSize", "dwFilter"]),
        # 
        'UrlCacheGetGlobalCacheSize': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["dwFilter", "pullSize", "pullLimit"]),
        # 
        'GetUrlCacheConfigInfoA': SimTypeFunction([SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "dwContainer": SimTypeInt(signed=False, label="UInt32"), "dwQuota": SimTypeInt(signed=False, label="UInt32"), "dwReserved4": SimTypeInt(signed=False, label="UInt32"), "fPerUser": SimTypeInt(signed=True, label="Int32"), "dwSyncMode": SimTypeInt(signed=False, label="UInt32"), "dwNumCachePaths": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"Anonymous": SimStruct({"CachePath": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "dwCacheSize": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "CachePaths": SimTypePointer(SimStruct({"CachePath": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "dwCacheSize": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_CACHE_CONFIG_PATH_ENTRYA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "dwNormalUsage": SimTypeInt(signed=False, label="UInt32"), "dwExemptUsage": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_CACHE_CONFIG_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="CACHE_CONFIG")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpCacheConfigInfo", "lpcbCacheConfigInfo", "dwFieldControl"]),
        # 
        'GetUrlCacheConfigInfoW': SimTypeFunction([SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "dwContainer": SimTypeInt(signed=False, label="UInt32"), "dwQuota": SimTypeInt(signed=False, label="UInt32"), "dwReserved4": SimTypeInt(signed=False, label="UInt32"), "fPerUser": SimTypeInt(signed=True, label="Int32"), "dwSyncMode": SimTypeInt(signed=False, label="UInt32"), "dwNumCachePaths": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"Anonymous": SimStruct({"CachePath": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "dwCacheSize": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "CachePaths": SimTypePointer(SimStruct({"CachePath": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "dwCacheSize": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_CACHE_CONFIG_PATH_ENTRYW", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "dwNormalUsage": SimTypeInt(signed=False, label="UInt32"), "dwExemptUsage": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_CACHE_CONFIG_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="CACHE_CONFIG")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpCacheConfigInfo", "lpcbCacheConfigInfo", "dwFieldControl"]),
        # 
        'SetUrlCacheConfigInfoA': SimTypeFunction([SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "dwContainer": SimTypeInt(signed=False, label="UInt32"), "dwQuota": SimTypeInt(signed=False, label="UInt32"), "dwReserved4": SimTypeInt(signed=False, label="UInt32"), "fPerUser": SimTypeInt(signed=True, label="Int32"), "dwSyncMode": SimTypeInt(signed=False, label="UInt32"), "dwNumCachePaths": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"Anonymous": SimStruct({"CachePath": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "dwCacheSize": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "CachePaths": SimTypePointer(SimStruct({"CachePath": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 260), "dwCacheSize": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_CACHE_CONFIG_PATH_ENTRYA", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "dwNormalUsage": SimTypeInt(signed=False, label="UInt32"), "dwExemptUsage": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_CACHE_CONFIG_INFOA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpCacheConfigInfo", "dwFieldControl"]),
        # 
        'SetUrlCacheConfigInfoW': SimTypeFunction([SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "dwContainer": SimTypeInt(signed=False, label="UInt32"), "dwQuota": SimTypeInt(signed=False, label="UInt32"), "dwReserved4": SimTypeInt(signed=False, label="UInt32"), "fPerUser": SimTypeInt(signed=True, label="Int32"), "dwSyncMode": SimTypeInt(signed=False, label="UInt32"), "dwNumCachePaths": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"Anonymous": SimStruct({"CachePath": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "dwCacheSize": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "CachePaths": SimTypePointer(SimStruct({"CachePath": SimTypeFixedSizeArray(SimTypeChar(label="Char"), 260), "dwCacheSize": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_CACHE_CONFIG_PATH_ENTRYW", pack=False, align=None), offset=0)}, name="<anon>", label="None"), "dwNormalUsage": SimTypeInt(signed=False, label="UInt32"), "dwExemptUsage": SimTypeInt(signed=False, label="UInt32")}, name="INTERNET_CACHE_CONFIG_INFOW", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpCacheConfigInfo", "dwFieldControl"]),
        # 
        'RunOnceUrlCache': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "hinst", "lpszCmd", "nCmdShow"]),
        # 
        'DeleteIE3Cache': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hwnd", "hinst", "lpszCmd", "nCmdShow"]),
        # 
        'UpdateUrlCacheContentPath': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szNewPath"]),
        # 
        'RegisterUrlCacheNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=True, label="Int64"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hWnd", "uMsg", "gid", "dwOpsFilter", "dwReserved"]),
        # 
        'GetUrlCacheHeaderData': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["nIdx", "lpdwData"]),
        # 
        'SetUrlCacheHeaderData': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["nIdx", "dwData"]),
        # 
        'IncrementUrlCacheHeaderData': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["nIdx", "lpdwData"]),
        # 
        'LoadUrlCacheContent': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'AppCacheLookup': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszUrl", "dwFlags", "phAppCache"]),
        # 
        'AppCacheCheckManifest': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="APP_CACHE_STATE"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszMasterUrl", "pwszManifestUrl", "pbManifestData", "dwManifestDataSize", "pbManifestResponseHeaders", "dwManifestResponseHeadersSize", "peState", "phNewAppCache"]),
        # 
        'AppCacheGetDownloadList': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"dwEntryCount": SimTypeInt(signed=False, label="UInt32"), "pEntries": SimTypePointer(SimStruct({"pwszUrl": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwEntryType": SimTypeInt(signed=False, label="UInt32")}, name="APP_CACHE_DOWNLOAD_ENTRY", pack=False, align=None), offset=0)}, name="APP_CACHE_DOWNLOAD_LIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hAppCache", "pDownloadList"]),
        # 
        'AppCacheFreeDownloadList': SimTypeFunction([SimTypePointer(SimStruct({"dwEntryCount": SimTypeInt(signed=False, label="UInt32"), "pEntries": SimTypePointer(SimStruct({"pwszUrl": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwEntryType": SimTypeInt(signed=False, label="UInt32")}, name="APP_CACHE_DOWNLOAD_ENTRY", pack=False, align=None), offset=0)}, name="APP_CACHE_DOWNLOAD_LIST", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pDownloadList"]),
        # 
        'AppCacheFinalize': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="APP_CACHE_FINALIZE_STATE"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hAppCache", "pbManifestData", "dwManifestDataSize", "peState"]),
        # 
        'AppCacheGetFallbackUrl': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hAppCache", "pwszUrl", "ppwszFallbackUrl"]),
        # 
        'AppCacheGetManifestUrl': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hAppCache", "ppwszManifestUrl"]),
        # 
        'AppCacheDuplicateHandle': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hAppCache", "phDuplicatedAppCache"]),
        # 
        'AppCacheCloseHandle': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hAppCache"]),
        # 
        'AppCacheFreeGroupList': SimTypeFunction([SimTypePointer(SimStruct({"dwAppCacheGroupCount": SimTypeInt(signed=False, label="UInt32"), "pAppCacheGroups": SimTypePointer(SimStruct({"pwszManifestUrl": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftLastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ullSize": SimTypeLongLong(signed=False, label="UInt64")}, name="APP_CACHE_GROUP_INFO", pack=False, align=None), offset=0)}, name="APP_CACHE_GROUP_LIST", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pAppCacheGroupList"]),
        # 
        'AppCacheGetGroupList': SimTypeFunction([SimTypePointer(SimStruct({"dwAppCacheGroupCount": SimTypeInt(signed=False, label="UInt32"), "pAppCacheGroups": SimTypePointer(SimStruct({"pwszManifestUrl": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftLastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ullSize": SimTypeLongLong(signed=False, label="UInt64")}, name="APP_CACHE_GROUP_INFO", pack=False, align=None), offset=0)}, name="APP_CACHE_GROUP_LIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pAppCacheGroupList"]),
        # 
        'AppCacheGetInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimStruct({"pwszManifestUrl": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftLastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ullSize": SimTypeLongLong(signed=False, label="UInt64")}, name="APP_CACHE_GROUP_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hAppCache", "pAppCacheInfo"]),
        # 
        'AppCacheDeleteGroup': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszManifestUrl"]),
        # 
        'AppCacheFreeSpace': SimTypeFunction([SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ftCutOff"]),
        # 
        'AppCacheGetIEGroupList': SimTypeFunction([SimTypePointer(SimStruct({"dwAppCacheGroupCount": SimTypeInt(signed=False, label="UInt32"), "pAppCacheGroups": SimTypePointer(SimStruct({"pwszManifestUrl": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ftLastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ullSize": SimTypeLongLong(signed=False, label="UInt64")}, name="APP_CACHE_GROUP_INFO", pack=False, align=None), offset=0)}, name="APP_CACHE_GROUP_LIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pAppCacheGroupList"]),
        # 
        'AppCacheDeleteIEGroup': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszManifestUrl"]),
        # 
        'AppCacheFreeIESpace': SimTypeFunction([SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ftCutOff"]),
        # 
        'AppCacheCreateAndCommitFile': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hAppCache", "pwszSourceFilePath", "pwszUrl", "pbResponseHeaders", "dwResponseHeadersSize"]),
        # 
        'HttpOpenDependencyHandle': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hRequestHandle", "fBackground", "phDependencyHandle"]),
        # 
        'HttpCloseDependencyHandle': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hDependencyHandle"]),
        # 
        'HttpDuplicateDependencyHandle': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hDependencyHandle", "phDuplicatedDependencyHandle"]),
        # 
        'HttpIndicatePageLoadComplete': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hDependencyHandle"]),
        # 
        'UrlCacheFreeEntryInfo': SimTypeFunction([SimTypePointer(SimStruct({"pwszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwCacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "ftLastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "pbHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "pbExtraData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbExtraDataSize": SimTypeInt(signed=False, label="UInt32")}, name="URLCACHE_ENTRY_INFO", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pCacheEntryInfo"]),
        # 
        'UrlCacheGetEntryInfo': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"pwszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwCacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "ftLastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "pbHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "pbExtraData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbExtraDataSize": SimTypeInt(signed=False, label="UInt32")}, name="URLCACHE_ENTRY_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hAppCache", "pcwszUrl", "pCacheEntryInfo"]),
        # 
        'UrlCacheCloseEntryHandle': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["hEntryFile"]),
        # 
        'UrlCacheRetrieveEntryFile': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"pwszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwCacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "ftLastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "pbHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "pbExtraData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbExtraDataSize": SimTypeInt(signed=False, label="UInt32")}, name="URLCACHE_ENTRY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hAppCache", "pcwszUrl", "pCacheEntryInfo", "phEntryFile"]),
        # 
        'UrlCacheReadEntryStream': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hUrlCacheStream", "ullLocation", "pBuffer", "dwBufferLen", "pdwBufferLen"]),
        # 
        'UrlCacheRetrieveEntryStream': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"pwszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwCacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "ftLastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "pbHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "pbExtraData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbExtraDataSize": SimTypeInt(signed=False, label="UInt32")}, name="URLCACHE_ENTRY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hAppCache", "pcwszUrl", "fRandomRead", "pCacheEntryInfo", "phEntryStream"]),
        # 
        'UrlCacheUpdateEntryExtraData': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["hAppCache", "pcwszUrl", "pbExtraData", "cbExtraData"]),
        # 
        'UrlCacheCreateContainer': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszName", "pwszPrefix", "pwszDirectory", "ullLimit", "dwOptions"]),
        # 
        'UrlCacheCheckEntriesExist': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), label="LPArray", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["rgpwszUrls", "cEntries", "rgfExist"]),
        # 
        'UrlCacheGetContentPaths': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pppwszDirectories", "pcDirectories"]),
        # 
        'UrlCacheGetGlobalLimit': SimTypeFunction([SimTypeInt(signed=False, label="URL_CACHE_LIMIT_TYPE"), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["limitType", "pullLimit"]),
        # 
        'UrlCacheSetGlobalLimit': SimTypeFunction([SimTypeInt(signed=False, label="URL_CACHE_LIMIT_TYPE"), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=False, label="UInt32"), arg_names=["limitType", "ullLimit"]),
        # 
        'UrlCacheReloadSettings': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'UrlCacheContainerSetEntryMaximumAge': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszPrefix", "dwEntryMaxAge"]),
        # 
        'UrlCacheFindFirstEntry': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimStruct({"pwszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwCacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "ftLastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "pbHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "pbExtraData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbExtraDataSize": SimTypeInt(signed=False, label="UInt32")}, name="URLCACHE_ENTRY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pwszPrefix", "dwFlags", "dwFilter", "GroupId", "pCacheEntryInfo", "phFind"]),
        # 
        'UrlCacheFindNextEntry': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"pwszSourceUrlName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pwszLocalFileName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwCacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "ftLastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ftLastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "pbHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "pbExtraData": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "cbExtraDataSize": SimTypeInt(signed=False, label="UInt32")}, name="URLCACHE_ENTRY_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hFind", "pCacheEntryInfo"]),
        # 
        'UrlCacheServer': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        # 
        'ReadGuidsForConnectedNetworks': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcNetworks", "pppwszNetworkGuids", "pppbstrNetworkNames", "pppwszGWMacs", "pcGatewayMacs", "pdwFlags"]),
        # 
        'IsHostInProxyBypassList': SimTypeFunction([SimTypeInt(signed=False, label="INTERNET_SCHEME"), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["tScheme", "lpszHost", "cchHost"]),
        # 
        'InternetFreeProxyInfoList': SimTypeFunction([SimTypePointer(SimStruct({"dwProxyInfoCount": SimTypeInt(signed=False, label="UInt32"), "pProxyInfo": SimTypePointer(SimStruct({"fProxy": SimTypeInt(signed=True, label="Int32"), "fBypass": SimTypeInt(signed=True, label="Int32"), "ProxyScheme": SimTypeInt(signed=False, label="INTERNET_SCHEME"), "pwszProxy": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ProxyPort": SimTypeShort(signed=False, label="UInt16")}, name="WININET_PROXY_INFO", pack=False, align=None), offset=0)}, name="WININET_PROXY_INFO_LIST", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["pProxyInfoList"]),
        # 
        'InternetGetProxyForUrl': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"dwProxyInfoCount": SimTypeInt(signed=False, label="UInt32"), "pProxyInfo": SimTypePointer(SimStruct({"fProxy": SimTypeInt(signed=True, label="Int32"), "fBypass": SimTypeInt(signed=True, label="Int32"), "ProxyScheme": SimTypeInt(signed=False, label="INTERNET_SCHEME"), "pwszProxy": SimTypePointer(SimTypeChar(label="Char"), offset=0), "ProxyPort": SimTypeShort(signed=False, label="UInt16")}, name="WININET_PROXY_INFO", pack=False, align=None), offset=0)}, name="WININET_PROXY_INFO_LIST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["hInternet", "pcwszUrl", "pProxyInfoList"]),
        # 
        'DoConnectoidsExist': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'GetDiskInfoA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszPath", "pdwClusterSize", "pdlAvail", "pdlTotal"]),
        # 
        'PerformOperationOverUrlCacheA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeLongLong(signed=True, label="Int64"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimStruct({"dwStructSize": SimTypeInt(signed=False, label="UInt32"), "lpszSourceUrlName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpszLocalFileName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "CacheEntryType": SimTypeInt(signed=False, label="UInt32"), "dwUseCount": SimTypeInt(signed=False, label="UInt32"), "dwHitRate": SimTypeInt(signed=False, label="UInt32"), "dwSizeLow": SimTypeInt(signed=False, label="UInt32"), "dwSizeHigh": SimTypeInt(signed=False, label="UInt32"), "LastModifiedTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "ExpireTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastAccessTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "LastSyncTime": SimStruct({"dwLowDateTime": SimTypeInt(signed=False, label="UInt32"), "dwHighDateTime": SimTypeInt(signed=False, label="UInt32")}, name="FILETIME", pack=False, align=None), "lpHeaderInfo": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwHeaderInfoSize": SimTypeInt(signed=False, label="UInt32"), "lpszFileExtension": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "Anonymous": SimUnion({"dwReserved": SimTypeInt(signed=False, label="UInt32"), "dwExemptDelta": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="INTERNET_CACHE_ENTRY_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pcei", "pcbcei", "pOpData"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pszUrlSearchPattern", "dwFlags", "dwFilter", "GroupId", "pReserved1", "pdwReserved2", "pReserved3", "op", "pOperatorData"]),
        # 
        'IsProfilesEnabled': SimTypeFunction([], SimTypeInt(signed=True, label="Int32")),
        # 
        'InternalInternetGetCookie': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["lpszUrl", "lpszCookieData", "lpdwDataSize"]),
        # 
        'ImportCookieFileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szFilename"]),
        # 
        'ImportCookieFileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["szFilename"]),
        # 
        'ExportCookieFileA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["szFilename", "fAppend"]),
        # 
        'ExportCookieFileW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=True, label="Int32"), arg_names=["szFilename", "fAppend"]),
        # 
        'IsDomainLegalCookieDomainA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pchDomain", "pchFullDomain"]),
        # 
        'IsDomainLegalCookieDomainW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["pchDomain", "pchFullDomain"]),
        # 
        'HttpWebSocketCompleteUpgrade': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0)], SimTypePointer(SimTypeBottom(label="Void"), offset=0), arg_names=["hRequest", "dwContext"]),
        # 
        'HttpWebSocketSend': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="HTTP_WEB_SOCKET_BUFFER_TYPE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hWebSocket", "BufferType", "pvBuffer", "dwBufferLength"]),
        # 
        'HttpWebSocketReceive': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="HTTP_WEB_SOCKET_BUFFER_TYPE"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWebSocket", "pvBuffer", "dwBufferLength", "pdwBytesRead", "pBufferType"]),
        # 
        'HttpWebSocketClose': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hWebSocket", "usStatus", "pvReason", "dwReasonLength"]),
        # 
        'HttpWebSocketShutdown': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hWebSocket", "usStatus", "pvReason", "dwReasonLength"]),
        # 
        'HttpWebSocketQueryCloseStatus': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["hWebSocket", "pusStatus", "pvReason", "dwReasonLength", "pdwReasonLengthConsumed"]),
        # 
        'InternetConvertUrlFromWireToWideChar': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pcszUrl", "cchUrl", "pcwszBaseUrl", "dwCodePageHost", "dwCodePagePath", "fEncodePathExtra", "dwCodePageExtra", "ppwszConvertedUrl"]),
    }

lib.set_prototypes(prototypes)
