# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("wsmsvc.dll")
prototypes = \
    {
        # 
        'WSManInitialize': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({}, name="WSMAN_API", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["flags", "apiHandle"]),
        # 
        'WSManDeinitialize': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_API", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["apiHandle", "flags"]),
        # 
        'WSManGetErrorMessage': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_API", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["apiHandle", "flags", "languageCode", "errorCode", "messageLength", "message", "messageLengthUsed"]),
        # 
        'WSManCreateSession': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_API", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"authenticationMechanism": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"userAccount": SimStruct({"username": SimTypePointer(SimTypeChar(label="Char"), offset=0), "password": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_USERNAME_PASSWORD_CREDS", pack=False, align=None), "certificateThumbprint": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="WSMAN_AUTHENTICATION_CREDENTIALS", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"accessType": SimTypeInt(signed=False, label="UInt32"), "authenticationCredentials": SimStruct({"authenticationMechanism": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"userAccount": SimStruct({"username": SimTypePointer(SimTypeChar(label="Char"), offset=0), "password": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_USERNAME_PASSWORD_CREDS", pack=False, align=None), "certificateThumbprint": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="<anon>", label="None")}, name="WSMAN_AUTHENTICATION_CREDENTIALS", pack=False, align=None)}, name="WSMAN_PROXY_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WSMAN_SESSION", pack=False, align=None), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["apiHandle", "connection", "flags", "serverAuthenticationCredentials", "proxyInfo", "session"]),
        # 
        'WSManCloseSession': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SESSION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["session", "flags"]),
        # 
        'WSManSetSessionOption': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SESSION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WSManSessionOption"), SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["session", "option", "data"]),
        # 
        'WSManGetSessionOptionAsDword': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SESSION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WSManSessionOption"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["session", "option", "value"]),
        # 
        'WSManGetSessionOptionAsString': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SESSION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="WSManSessionOption"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["session", "option", "stringLength", "string", "stringLengthUsed"]),
        # 
        'WSManCloseOperation': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["operationHandle", "flags"]),
        # 
        'WSManCreateShell': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SESSION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"__AnonymousBase_wsman_L665_C48": SimStruct({"inputStreamSet": SimTypePointer(SimStruct({"streamIDsCount": SimTypeInt(signed=False, label="UInt32"), "streamIDs": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="WSMAN_STREAM_ID_SET", pack=False, align=None), offset=0), "outputStreamSet": SimTypePointer(SimStruct({"streamIDsCount": SimTypeInt(signed=False, label="UInt32"), "streamIDs": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="WSMAN_STREAM_ID_SET", pack=False, align=None), offset=0), "idleTimeoutMs": SimTypeInt(signed=False, label="UInt32"), "workingDirectory": SimTypePointer(SimTypeChar(label="Char"), offset=0), "variableSet": SimTypePointer(SimStruct({"varsCount": SimTypeInt(signed=False, label="UInt32"), "vars": SimTypePointer(SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ENVIRONMENT_VARIABLE", pack=False, align=None), offset=0)}, name="WSMAN_ENVIRONMENT_VARIABLE_SET", pack=False, align=None), offset=0)}, name="WSMAN_SHELL_STARTUP_INFO_V10", pack=False, align=None), "name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_SHELL_STARTUP_INFO_V11", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"optionsCount": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0), "mustComply": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION", pack=False, align=None), offset=0), "optionsMustUnderstand": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION_SET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["session", "flags", "resourceUri", "startupInfo", "options", "createXml", "async", "shell"]),
        # 
        'WSManRunShellCommand': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"argsCount": SimTypeInt(signed=False, label="UInt32"), "args": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="WSMAN_COMMAND_ARG_SET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"optionsCount": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0), "mustComply": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION", pack=False, align=None), offset=0), "optionsMustUnderstand": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION_SET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["shell", "flags", "commandLine", "args", "options", "async", "command"]),
        # 
        'WSManSignalShell': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["shell", "command", "flags", "code", "async", "signalOperation"]),
        # 
        'WSManReceiveShellOutput': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"streamIDsCount": SimTypeInt(signed=False, label="UInt32"), "streamIDs": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="WSMAN_STREAM_ID_SET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["shell", "command", "flags", "desiredStreamSet", "async", "receiveOperation"]),
        # 
        'WSManSendShellInput': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["shell", "command", "flags", "streamId", "streamData", "endOfStream", "async", "sendOperation"]),
        # 
        'WSManCloseCommand': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["commandHandle", "flags", "async"]),
        # 
        'WSManCloseShell': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["shellHandle", "flags", "async"]),
        # 
        'WSManCreateShellEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SESSION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"__AnonymousBase_wsman_L665_C48": SimStruct({"inputStreamSet": SimTypePointer(SimStruct({"streamIDsCount": SimTypeInt(signed=False, label="UInt32"), "streamIDs": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="WSMAN_STREAM_ID_SET", pack=False, align=None), offset=0), "outputStreamSet": SimTypePointer(SimStruct({"streamIDsCount": SimTypeInt(signed=False, label="UInt32"), "streamIDs": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="WSMAN_STREAM_ID_SET", pack=False, align=None), offset=0), "idleTimeoutMs": SimTypeInt(signed=False, label="UInt32"), "workingDirectory": SimTypePointer(SimTypeChar(label="Char"), offset=0), "variableSet": SimTypePointer(SimStruct({"varsCount": SimTypeInt(signed=False, label="UInt32"), "vars": SimTypePointer(SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ENVIRONMENT_VARIABLE", pack=False, align=None), offset=0)}, name="WSMAN_ENVIRONMENT_VARIABLE_SET", pack=False, align=None), offset=0)}, name="WSMAN_SHELL_STARTUP_INFO_V10", pack=False, align=None), "name": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_SHELL_STARTUP_INFO_V11", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"optionsCount": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0), "mustComply": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION", pack=False, align=None), offset=0), "optionsMustUnderstand": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION_SET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["session", "flags", "resourceUri", "shellId", "startupInfo", "options", "createXml", "async", "shell"]),
        # 
        'WSManRunShellCommandEx': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"argsCount": SimTypeInt(signed=False, label="UInt32"), "args": SimTypePointer(SimTypePointer(SimTypeChar(label="Char"), offset=0), offset=0)}, name="WSMAN_COMMAND_ARG_SET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"optionsCount": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0), "mustComply": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION", pack=False, align=None), offset=0), "optionsMustUnderstand": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION_SET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["shell", "flags", "commandId", "commandLine", "args", "options", "async", "command"]),
        # 
        'WSManDisconnectShell': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"idleTimeoutMs": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_SHELL_DISCONNECT_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["shell", "flags", "disconnectInfo", "async"]),
        # 
        'WSManReconnectShell': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["shell", "flags", "async"]),
        # 
        'WSManReconnectShellCommand': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0)], SimTypeBottom(label="Void"), arg_names=["commandHandle", "flags", "async"]),
        # 
        'WSManConnectShell': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SESSION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"optionsCount": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0), "mustComply": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION", pack=False, align=None), offset=0), "optionsMustUnderstand": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION_SET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["session", "flags", "resourceUri", "shellID", "options", "connectXml", "async", "shell"]),
        # 
        'WSManConnectShellCommand': SimTypeFunction([SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"optionsCount": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0), "mustComply": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION", pack=False, align=None), offset=0), "optionsMustUnderstand": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION_SET", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"operationContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "completionFunction": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"code": SimTypeInt(signed=False, label="UInt32"), "errorDetail": SimTypePointer(SimTypeChar(label="Char"), offset=0), "language": SimTypePointer(SimTypeChar(label="Char"), offset=0), "machineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "pluginName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_ERROR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_SHELL", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), SimTypePointer(SimStruct({}, name="WSMAN_OPERATION", pack=False, align=None), offset=0), SimTypePointer(SimUnion({"receiveData": SimStruct({"streamId": SimTypePointer(SimTypeChar(label="Char"), offset=0), "streamData": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), "commandState": SimTypePointer(SimTypeChar(label="Char"), offset=0), "exitCode": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_RECEIVE_DATA_RESULT", pack=False, align=None), "connectData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CONNECT_DATA", pack=False, align=None), "createData": SimStruct({"data": SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None)}, name="WSMAN_CREATE_SHELL_DATA", pack=False, align=None)}, name="<anon>", label="None"), offset=0)], SimTypeBottom(label="Void"), arg_names=["operationContext", "flags", "error", "shell", "command", "operationHandle", "data"]), offset=0)}, name="WSMAN_SHELL_ASYNC", pack=False, align=None), offset=0), SimTypePointer(SimTypePointer(SimStruct({}, name="WSMAN_COMMAND", pack=False, align=None), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["shell", "flags", "commandID", "options", "connectXml", "async", "command"]),
        # 
        'WSManPluginReportContext': SimTypeFunction([SimTypePointer(SimStruct({"senderDetails": SimTypePointer(SimStruct({"senderName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "authenticationMechanism": SimTypePointer(SimTypeChar(label="Char"), offset=0), "certificateDetails": SimTypePointer(SimStruct({"subject": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerThumbprint": SimTypePointer(SimTypeChar(label="Char"), offset=0), "subjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_CERTIFICATE_DETAILS", pack=False, align=None), offset=0), "clientToken": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "httpURL": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_SENDER_DETAILS", pack=False, align=None), offset=0), "locale": SimTypePointer(SimTypeChar(label="Char"), offset=0), "resourceUri": SimTypePointer(SimTypeChar(label="Char"), offset=0), "operationInfo": SimTypePointer(SimStruct({"fragment": SimStruct({"path": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dialect": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_FRAGMENT", pack=False, align=None), "filter": SimStruct({"filter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dialect": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_FILTER", pack=False, align=None), "selectorSet": SimStruct({"numberKeys": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimStruct({"key": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_KEY", pack=False, align=None), offset=0)}, name="WSMAN_SELECTOR_SET", pack=False, align=None), "optionSet": SimStruct({"optionsCount": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0), "mustComply": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION", pack=False, align=None), offset=0), "optionsMustUnderstand": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION_SET", pack=False, align=None), "reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "version": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_OPERATION_INFO", pack=False, align=None), offset=0), "shutdownNotification": SimTypeInt(signed=True, label="Int32"), "shutdownNotificationHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dataLocale": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_PLUGIN_REQUEST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["requestDetails", "flags", "context"]),
        # 
        'WSManPluginReceiveResult': SimTypeFunction([SimTypePointer(SimStruct({"senderDetails": SimTypePointer(SimStruct({"senderName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "authenticationMechanism": SimTypePointer(SimTypeChar(label="Char"), offset=0), "certificateDetails": SimTypePointer(SimStruct({"subject": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerThumbprint": SimTypePointer(SimTypeChar(label="Char"), offset=0), "subjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_CERTIFICATE_DETAILS", pack=False, align=None), offset=0), "clientToken": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "httpURL": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_SENDER_DETAILS", pack=False, align=None), offset=0), "locale": SimTypePointer(SimTypeChar(label="Char"), offset=0), "resourceUri": SimTypePointer(SimTypeChar(label="Char"), offset=0), "operationInfo": SimTypePointer(SimStruct({"fragment": SimStruct({"path": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dialect": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_FRAGMENT", pack=False, align=None), "filter": SimStruct({"filter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dialect": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_FILTER", pack=False, align=None), "selectorSet": SimStruct({"numberKeys": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimStruct({"key": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_KEY", pack=False, align=None), offset=0)}, name="WSMAN_SELECTOR_SET", pack=False, align=None), "optionSet": SimStruct({"optionsCount": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0), "mustComply": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION", pack=False, align=None), offset=0), "optionsMustUnderstand": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION_SET", pack=False, align=None), "reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "version": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_OPERATION_INFO", pack=False, align=None), offset=0), "shutdownNotification": SimTypeInt(signed=True, label="Int32"), "shutdownNotificationHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dataLocale": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_PLUGIN_REQUEST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["requestDetails", "flags", "stream", "streamResult", "commandState", "exitCode"]),
        # 
        'WSManPluginOperationComplete': SimTypeFunction([SimTypePointer(SimStruct({"senderDetails": SimTypePointer(SimStruct({"senderName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "authenticationMechanism": SimTypePointer(SimTypeChar(label="Char"), offset=0), "certificateDetails": SimTypePointer(SimStruct({"subject": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerThumbprint": SimTypePointer(SimTypeChar(label="Char"), offset=0), "subjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_CERTIFICATE_DETAILS", pack=False, align=None), offset=0), "clientToken": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "httpURL": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_SENDER_DETAILS", pack=False, align=None), offset=0), "locale": SimTypePointer(SimTypeChar(label="Char"), offset=0), "resourceUri": SimTypePointer(SimTypeChar(label="Char"), offset=0), "operationInfo": SimTypePointer(SimStruct({"fragment": SimStruct({"path": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dialect": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_FRAGMENT", pack=False, align=None), "filter": SimStruct({"filter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dialect": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_FILTER", pack=False, align=None), "selectorSet": SimStruct({"numberKeys": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimStruct({"key": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_KEY", pack=False, align=None), offset=0)}, name="WSMAN_SELECTOR_SET", pack=False, align=None), "optionSet": SimStruct({"optionsCount": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0), "mustComply": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION", pack=False, align=None), offset=0), "optionsMustUnderstand": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION_SET", pack=False, align=None), "reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "version": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_OPERATION_INFO", pack=False, align=None), offset=0), "shutdownNotification": SimTypeInt(signed=True, label="Int32"), "shutdownNotificationHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dataLocale": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_PLUGIN_REQUEST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["requestDetails", "flags", "errorCode", "extendedInformation"]),
        # 
        'WSManPluginGetOperationParameters': SimTypeFunction([SimTypePointer(SimStruct({"senderDetails": SimTypePointer(SimStruct({"senderName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "authenticationMechanism": SimTypePointer(SimTypeChar(label="Char"), offset=0), "certificateDetails": SimTypePointer(SimStruct({"subject": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerThumbprint": SimTypePointer(SimTypeChar(label="Char"), offset=0), "subjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_CERTIFICATE_DETAILS", pack=False, align=None), offset=0), "clientToken": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "httpURL": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_SENDER_DETAILS", pack=False, align=None), offset=0), "locale": SimTypePointer(SimTypeChar(label="Char"), offset=0), "resourceUri": SimTypePointer(SimTypeChar(label="Char"), offset=0), "operationInfo": SimTypePointer(SimStruct({"fragment": SimStruct({"path": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dialect": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_FRAGMENT", pack=False, align=None), "filter": SimStruct({"filter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dialect": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_FILTER", pack=False, align=None), "selectorSet": SimStruct({"numberKeys": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimStruct({"key": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_KEY", pack=False, align=None), offset=0)}, name="WSMAN_SELECTOR_SET", pack=False, align=None), "optionSet": SimStruct({"optionsCount": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0), "mustComply": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION", pack=False, align=None), offset=0), "optionsMustUnderstand": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION_SET", pack=False, align=None), "reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "version": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_OPERATION_INFO", pack=False, align=None), offset=0), "shutdownNotification": SimTypeInt(signed=True, label="Int32"), "shutdownNotificationHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dataLocale": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_PLUGIN_REQUEST", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["requestDetails", "flags", "data"]),
        # 
        'WSManPluginGetConfiguration': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"type": SimTypeInt(signed=False, label="WSManDataType"), "Anonymous": SimUnion({"text": SimStruct({"bufferLength": SimTypeInt(signed=False, label="UInt32"), "buffer": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_DATA_TEXT", pack=False, align=None), "binaryData": SimStruct({"dataLength": SimTypeInt(signed=False, label="UInt32"), "data": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="WSMAN_DATA_BINARY", pack=False, align=None), "number": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="WSMAN_DATA", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pluginContext", "flags", "data"]),
        # 
        'WSManPluginReportCompletion': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pluginContext", "flags"]),
        # 
        'WSManPluginFreeRequestDetails': SimTypeFunction([SimTypePointer(SimStruct({"senderDetails": SimTypePointer(SimStruct({"senderName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "authenticationMechanism": SimTypePointer(SimTypeChar(label="Char"), offset=0), "certificateDetails": SimTypePointer(SimStruct({"subject": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerThumbprint": SimTypePointer(SimTypeChar(label="Char"), offset=0), "subjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_CERTIFICATE_DETAILS", pack=False, align=None), offset=0), "clientToken": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "httpURL": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_SENDER_DETAILS", pack=False, align=None), offset=0), "locale": SimTypePointer(SimTypeChar(label="Char"), offset=0), "resourceUri": SimTypePointer(SimTypeChar(label="Char"), offset=0), "operationInfo": SimTypePointer(SimStruct({"fragment": SimStruct({"path": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dialect": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_FRAGMENT", pack=False, align=None), "filter": SimStruct({"filter": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dialect": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_FILTER", pack=False, align=None), "selectorSet": SimStruct({"numberKeys": SimTypeInt(signed=False, label="UInt32"), "keys": SimTypePointer(SimStruct({"key": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_KEY", pack=False, align=None), offset=0)}, name="WSMAN_SELECTOR_SET", pack=False, align=None), "optionSet": SimStruct({"optionsCount": SimTypeInt(signed=False, label="UInt32"), "options": SimTypePointer(SimStruct({"name": SimTypePointer(SimTypeChar(label="Char"), offset=0), "value": SimTypePointer(SimTypeChar(label="Char"), offset=0), "mustComply": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION", pack=False, align=None), offset=0), "optionsMustUnderstand": SimTypeInt(signed=True, label="Int32")}, name="WSMAN_OPTION_SET", pack=False, align=None), "reserved": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "version": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_OPERATION_INFO", pack=False, align=None), offset=0), "shutdownNotification": SimTypeInt(signed=True, label="Int32"), "shutdownNotificationHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "dataLocale": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_PLUGIN_REQUEST", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["requestDetails"]),
        # 
        'WSManPluginAuthzUserComplete': SimTypeFunction([SimTypePointer(SimStruct({"senderName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "authenticationMechanism": SimTypePointer(SimTypeChar(label="Char"), offset=0), "certificateDetails": SimTypePointer(SimStruct({"subject": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerThumbprint": SimTypePointer(SimTypeChar(label="Char"), offset=0), "subjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_CERTIFICATE_DETAILS", pack=False, align=None), offset=0), "clientToken": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "httpURL": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_SENDER_DETAILS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=True, label="Int32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["senderDetails", "flags", "userAuthorizationContext", "impersonationToken", "userIsAdministrator", "errorCode", "extendedErrorInformation"]),
        # 
        'WSManPluginAuthzOperationComplete': SimTypeFunction([SimTypePointer(SimStruct({"senderName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "authenticationMechanism": SimTypePointer(SimTypeChar(label="Char"), offset=0), "certificateDetails": SimTypePointer(SimStruct({"subject": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerThumbprint": SimTypePointer(SimTypeChar(label="Char"), offset=0), "subjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_CERTIFICATE_DETAILS", pack=False, align=None), offset=0), "clientToken": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "httpURL": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_SENDER_DETAILS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["senderDetails", "flags", "userAuthorizationContext", "errorCode", "extendedErrorInformation"]),
        # 
        'WSManPluginAuthzQueryQuotaComplete': SimTypeFunction([SimTypePointer(SimStruct({"senderName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "authenticationMechanism": SimTypePointer(SimTypeChar(label="Char"), offset=0), "certificateDetails": SimTypePointer(SimStruct({"subject": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "issuerThumbprint": SimTypePointer(SimTypeChar(label="Char"), offset=0), "subjectName": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_CERTIFICATE_DETAILS", pack=False, align=None), offset=0), "clientToken": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "httpURL": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="WSMAN_SENDER_DETAILS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"maxAllowedConcurrentShells": SimTypeInt(signed=False, label="UInt32"), "maxAllowedConcurrentOperations": SimTypeInt(signed=False, label="UInt32"), "timeslotSize": SimTypeInt(signed=False, label="UInt32"), "maxAllowedOperationsPerTimeslot": SimTypeInt(signed=False, label="UInt32")}, name="WSMAN_AUTHZ_QUOTA", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["senderDetails", "flags", "quota", "errorCode", "extendedErrorInformation"]),
    }

lib.set_prototypes(prototypes)
