# Copyright 2020 NullConvergence
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""This module is a custom relationship mapper, which translates
the neo4j relationship models to custom data structures, e.g. dictionaries """

from graphrepo.mappers.default import DefaultMapper
from graphrepo.mappers.node import NodeMapper


class RelMapper(DefaultMapper):
    """The miners are currently synchronous, but
    ideally they will be async in the future"""

    def __init__(self, *args, **kwargs):
        """Default Init"""
        super().__init__(*args, **kwargs)

    @classmethod
    def map_default_rel(cls, rel):
        """Maps a rellationship to a dictionary"""
        # Neo4j sometimes returns the labels in reverse order
        # so we concatenate the labels
        if len(rel.labels) < 2:
            label2 = list(rel.labels)[0]
        else:
            label2 = list(rel.labels)[0] + list(rel.labels)[1]

        return {
            'data': {
                'source': NodeMapper.get_id(rel.start_node),
                'target': NodeMapper.get_id(rel.end_node),
                'label': list(rel.labels)[0],
                'label_concat': label2,
                'id': rel.identity
            }
        }
