# Schema Docs

- [1. Property `root > allOf > item 0`](#allOf_i0)
  - [1.1. If (country = "United States of America")](#autogenerated_heading_2)
    - [1.1.1. Property `root > allOf > item 0 > then > postal_code`](#allOf_i0_then_postal_code)
- [2. Property `root > allOf > item 1`](#allOf_i1)
  - [2.1. If (country = "Canada")](#autogenerated_heading_3)
    - [2.1.1. Property `root > allOf > item 1 > then > postal_code`](#allOf_i1_then_postal_code)
- [3. Property `root > allOf > item 2`](#allOf_i2)
  - [3.1. If (country = "Netherlands")](#autogenerated_heading_4)
    - [3.1.1. Property `root > allOf > item 2 > then > postal_code`](#allOf_i2_then_postal_code)
- [4. [Optional] Property `root > street_address`](#street_address)
- [5. [Optional] Property `root > country`](#country)

| Type                      | `combining`                                                               |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

| Property                             | Pattern | Type             | Deprecated | Definition | Title/Description |
| ------------------------------------ | ------- | ---------------- | ---------- | ---------- | ----------------- |
| - [street_address](#street_address ) | No      | string           | No         | -          | -                 |
| - [country](#country )               | No      | enum (of string) | No         | -          | -                 |
|                                      |         |                  |            |            |                   |

| All of(Requirement) |
| ------------------- |
| [item 0](#allOf_i0) |
| [item 1](#allOf_i1) |
| [item 2](#allOf_i2) |
|                     |

## <a name="allOf_i0"></a>1. Property `root > allOf > item 0`

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

### <a name="autogenerated_heading_2"></a>1.1. If (country = "United States of America")

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

| Property                                     | Pattern | Type   | Deprecated | Definition | Title/Description |
| -------------------------------------------- | ------- | ------ | ---------- | ---------- | ----------------- |
| - [postal_code](#allOf_i0_then_postal_code ) | No      | object | No         | -          | -                 |
|                                              |         |        |            |            |                   |

#### <a name="allOf_i0_then_postal_code"></a>1.1.1. Property `root > allOf > item 0 > then > postal_code`

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

| Restrictions                      |                                                                                                           |
| --------------------------------- | --------------------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```[0-9]{5}(-[0-9]{4})?``` [Test](https://regex101.com/?regex=%5B0-9%5D%7B5%7D%28-%5B0-9%5D%7B4%7D%29%3F) |
|                                   |                                                                                                           |

## <a name="allOf_i1"></a>2. Property `root > allOf > item 1`

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

### <a name="autogenerated_heading_3"></a>2.1. If (country = "Canada")

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

| Property                                     | Pattern | Type   | Deprecated | Definition | Title/Description |
| -------------------------------------------- | ------- | ------ | ---------- | ---------- | ----------------- |
| - [postal_code](#allOf_i1_then_postal_code ) | No      | object | No         | -          | -                 |
|                                              |         |        |            |            |                   |

#### <a name="allOf_i1_then_postal_code"></a>2.1.1. Property `root > allOf > item 1 > then > postal_code`

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

| Restrictions                      |                                                                                                                                   |
| --------------------------------- | --------------------------------------------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```[A-Z][0-9][A-Z] [0-9][A-Z][0-9]``` [Test](https://regex101.com/?regex=%5BA-Z%5D%5B0-9%5D%5BA-Z%5D+%5B0-9%5D%5BA-Z%5D%5B0-9%5D) |
|                                   |                                                                                                                                   |

## <a name="allOf_i2"></a>3. Property `root > allOf > item 2`

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

### <a name="autogenerated_heading_4"></a>3.1. If (country = "Netherlands")

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

| Property                                     | Pattern | Type   | Deprecated | Definition | Title/Description |
| -------------------------------------------- | ------- | ------ | ---------- | ---------- | ----------------- |
| - [postal_code](#allOf_i2_then_postal_code ) | No      | object | No         | -          | -                 |
|                                              |         |        |            |            |                   |

#### <a name="allOf_i2_then_postal_code"></a>3.1.1. Property `root > allOf > item 2 > then > postal_code`

| Type                      | `object`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

| Restrictions                      |                                                                                               |
| --------------------------------- | --------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```[0-9]{4} [A-Z]{2}``` [Test](https://regex101.com/?regex=%5B0-9%5D%7B4%7D+%5BA-Z%5D%7B2%7D) |
|                                   |                                                                                               |

## <a name="street_address"></a>4. [Optional] Property `root > street_address`

| Type                      | `string`                                                                  |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

## <a name="country"></a>5. [Optional] Property `root > country`

| Type                      | `enum (of string)`                                                        |
| ------------------------- | ------------------------------------------------------------------------- |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
|                           |                                                                           |

Must be one of:
* "United States of America"
* "Canada"
* "Netherlands"

----------------------------------------------------------------------------------------------------------------------------
Generated using [json-schema-for-humans](https://github.com/coveooss/json-schema-for-humans) on date