# Schema Docs

- [1. If (country = "United States of America")](#autogenerated_heading_2)
  - [1.1. ![badge](https://img.shields.io/badge/Optional-yellow) Property `root > then > postal_code`](#then_postal_code)
- [2. Else (i.e.  country != "United States of America")](#autogenerated_heading_3)
  - [2.1. ![badge](https://img.shields.io/badge/Optional-yellow) Property `root > else > postal_code`](#else_postal_code)
- [3. ![badge](https://img.shields.io/badge/Optional-yellow) Property `root > street_address`](#street_address)
- [4. ![badge](https://img.shields.io/badge/Optional-yellow) Property `root > country`](#country)

| Type                      | `object`                                                                                                            |
| ------------------------- | ------------------------------------------------------------------------------------------------------------------- |
| **Additional properties** | [![badge](https://img.shields.io/badge/Any+type-allowed-green)](# "Additional Properties of any type are allowed.") |
|                           |                                                                                                                     |

| Property                             | Pattern | Type             | Deprecated | Definition | Title/Description |
| ------------------------------------ | ------- | ---------------- | ---------- | ---------- | ----------------- |
| - [street_address](#street_address ) | No      | string           | No         | -          | -                 |
| - [country](#country )               | No      | enum (of string) | No         | -          | -                 |
|                                      |         |                  |            |            |                   |

## <a name="autogenerated_heading_2"></a>1. If (country = "United States of America")

| Type                      | `object`                                                                                                            |
| ------------------------- | ------------------------------------------------------------------------------------------------------------------- |
| **Additional properties** | [![badge](https://img.shields.io/badge/Any+type-allowed-green)](# "Additional Properties of any type are allowed.") |
|                           |                                                                                                                     |

| Property                            | Pattern | Type   | Deprecated | Definition | Title/Description |
| ----------------------------------- | ------- | ------ | ---------- | ---------- | ----------------- |
| - [postal_code](#then_postal_code ) | No      | object | No         | -          | -                 |
|                                     |         |        |            |            |                   |

### <a name="then_postal_code"></a>1.1. ![badge](https://img.shields.io/badge/Optional-yellow) Property `root > then > postal_code`

| Type                      | `object`                                                                                                            |
| ------------------------- | ------------------------------------------------------------------------------------------------------------------- |
| **Additional properties** | [![badge](https://img.shields.io/badge/Any+type-allowed-green)](# "Additional Properties of any type are allowed.") |
|                           |                                                                                                                     |

| Restrictions                      |                                                                                                           |
| --------------------------------- | --------------------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```[0-9]{5}(-[0-9]{4})?``` [Test](https://regex101.com/?regex=%5B0-9%5D%7B5%7D%28-%5B0-9%5D%7B4%7D%29%3F) |
|                                   |                                                                                                           |

## <a name="autogenerated_heading_3"></a>2. Else (i.e.  country != "United States of America")

| Type                      | `object`                                                                                                            |
| ------------------------- | ------------------------------------------------------------------------------------------------------------------- |
| **Additional properties** | [![badge](https://img.shields.io/badge/Any+type-allowed-green)](# "Additional Properties of any type are allowed.") |
|                           |                                                                                                                     |

| Property                            | Pattern | Type   | Deprecated | Definition | Title/Description |
| ----------------------------------- | ------- | ------ | ---------- | ---------- | ----------------- |
| - [postal_code](#else_postal_code ) | No      | object | No         | -          | -                 |
|                                     |         |        |            |            |                   |

### <a name="else_postal_code"></a>2.1. ![badge](https://img.shields.io/badge/Optional-yellow) Property `root > else > postal_code`

| Type                      | `object`                                                                                                            |
| ------------------------- | ------------------------------------------------------------------------------------------------------------------- |
| **Additional properties** | [![badge](https://img.shields.io/badge/Any+type-allowed-green)](# "Additional Properties of any type are allowed.") |
|                           |                                                                                                                     |

| Restrictions                      |                                                                                                                                   |
| --------------------------------- | --------------------------------------------------------------------------------------------------------------------------------- |
| **Must match regular expression** | ```[A-Z][0-9][A-Z] [0-9][A-Z][0-9]``` [Test](https://regex101.com/?regex=%5BA-Z%5D%5B0-9%5D%5BA-Z%5D+%5B0-9%5D%5BA-Z%5D%5B0-9%5D) |
|                                   |                                                                                                                                   |

## <a name="street_address"></a>3. ![badge](https://img.shields.io/badge/Optional-yellow) Property `root > street_address`

| Type                      | `string`                                                                                                            |
| ------------------------- | ------------------------------------------------------------------------------------------------------------------- |
| **Additional properties** | [![badge](https://img.shields.io/badge/Any+type-allowed-green)](# "Additional Properties of any type are allowed.") |
|                           |                                                                                                                     |

## <a name="country"></a>4. ![badge](https://img.shields.io/badge/Optional-yellow) Property `root > country`

| Type                      | `enum (of string)`                                                                                                  |
| ------------------------- | ------------------------------------------------------------------------------------------------------------------- |
| **Additional properties** | [![badge](https://img.shields.io/badge/Any+type-allowed-green)](# "Additional Properties of any type are allowed.") |
|                           |                                                                                                                     |

Must be one of:
* "United States of America"
* "Canada"

----------------------------------------------------------------------------------------------------------------------------
Generated using [json-schema-for-humans](https://github.com/coveooss/json-schema-for-humans) on date