# coding: utf-8

"""
    Yagna Payment API

     Invoicing and Payments is a fundamental area of Yagna Ecosystem functionality. It includes aspects of communication between Requestor, Provider and a selected Payment Platform, which becomes crucial when Activities are executed in the context of negotiated Agreements. Yagna applications must be able to exercise various payment models, and the Invoicing/Payment-related communication is happening in parallel to Activity control communication. To define functional patterns of Requestor/Provider interaction in this area, Payment API is specified.  An important principle of the Yagna Payment API is that the actual payment transactions are hidden behind the Invoice flow. In other words, a Yagna Application on Requestor side isn’t expected to trigger actual payment transactions. Instead it is expected to receive and accept Invoices raised by the Provider - based on Application’s Invoice Accept notifications, the Payment API implementation orchestrates the payment via a configured Payment platform.  **NOTE:** This specification is work-in-progress.   # noqa: E501

    The version of the OpenAPI document: 1.6.3
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

# python 2 and python 3 compatibility library


from ya_payment.api_client import ApiClient
from ya_payment.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class ProviderApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_debit_note(self, debit_note_id, **kwargs):  # noqa: E501
        """Cancel Debit Note.  # noqa: E501

        **WARNING:** Operation not implemented.  This is a blocking operation. It will not return until the Requestor has acknowledged cancelling the Debit Note or timeout has passed. The Requestor may refuse to cancel the Debit Note if they have already accepted it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_debit_note(debit_note_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_note_id: (required)
        :param float timeout: Timeout used in blocking calls waiting for eg. acknowledgement. How many seconds server should wait for response/acknowledgement of an action (0.0 means it should wait for other party's response indefinitely) 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.cancel_debit_note_with_http_info(debit_note_id, **kwargs)  # noqa: E501

    def cancel_debit_note_with_http_info(self, debit_note_id, **kwargs):  # noqa: E501
        """Cancel Debit Note.  # noqa: E501

        **WARNING:** Operation not implemented.  This is a blocking operation. It will not return until the Requestor has acknowledged cancelling the Debit Note or timeout has passed. The Requestor may refuse to cancel the Debit Note if they have already accepted it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_debit_note_with_http_info(debit_note_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_note_id: (required)
        :param float timeout: Timeout used in blocking calls waiting for eg. acknowledgement. How many seconds server should wait for response/acknowledgement of an action (0.0 means it should wait for other party's response indefinitely) 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'debit_note_id',
            'timeout'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_debit_note" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'debit_note_id' is set
        if self.api_client.client_side_validation and ('debit_note_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['debit_note_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `debit_note_id` when calling `cancel_debit_note`")  # noqa: E501

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0.0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `cancel_debit_note`, must be a value greater than or equal to `0.0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'debit_note_id' in local_var_params:
            path_params['debitNoteId'] = local_var_params['debit_note_id']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/debitNotes/{debitNoteId}/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def cancel_invoice(self, invoice_id, **kwargs):  # noqa: E501
        """Cancel Invoice.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged cancelling the Invoice or timeout has passed. The Requestor may refuse to cancel the Invoice if they have already accepted it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_invoice(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param float timeout: Timeout used in blocking calls waiting for eg. acknowledgement. How many seconds server should wait for response/acknowledgement of an action (0.0 means it should wait for other party's response indefinitely) 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.cancel_invoice_with_http_info(invoice_id, **kwargs)  # noqa: E501

    def cancel_invoice_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Cancel Invoice.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged cancelling the Invoice or timeout has passed. The Requestor may refuse to cancel the Invoice if they have already accepted it.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_invoice_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param float timeout: Timeout used in blocking calls waiting for eg. acknowledgement. How many seconds server should wait for response/acknowledgement of an action (0.0 means it should wait for other party's response indefinitely) 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'invoice_id',
            'timeout'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_invoice" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if self.api_client.client_side_validation and ('invoice_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['invoice_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `invoice_id` when calling `cancel_invoice`")  # noqa: E501

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0.0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `cancel_invoice`, must be a value greater than or equal to `0.0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'invoice_id' in local_var_params:
            path_params['invoiceId'] = local_var_params['invoice_id']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/invoices/{invoiceId}/cancel', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_debit_note(self, debit_note_id, **kwargs):  # noqa: E501
        """Get Debit Note.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_debit_note(debit_note_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_note_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DebitNote
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_debit_note_with_http_info(debit_note_id, **kwargs)  # noqa: E501

    def get_debit_note_with_http_info(self, debit_note_id, **kwargs):  # noqa: E501
        """Get Debit Note.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_debit_note_with_http_info(debit_note_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_note_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DebitNote, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'debit_note_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_debit_note" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'debit_note_id' is set
        if self.api_client.client_side_validation and ('debit_note_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['debit_note_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `debit_note_id` when calling `get_debit_note`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'debit_note_id' in local_var_params:
            path_params['debitNoteId'] = local_var_params['debit_note_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/debitNotes/{debitNoteId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DebitNote',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_debit_note_events(self, **kwargs):  # noqa: E501
        """Get Debit Note events.  # noqa: E501

        Listen for Debit Note-related events using long-polling. If there are any events the method will return them immediately. If there are none the method will wait until one appears or timeout passes. `afterTimestamp` parameter can be used in order to get just the 'new' events. Setting the parameter value to the timestamp of the last processed event ensures that no events will go unnoticed.  **NOTE:** The events are persistent, ie. calling the API does not remove the event records from receiving queue.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_debit_note_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_events: Maximum number of events that server should return at once. 
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DebitNoteEvent]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_debit_note_events_with_http_info(**kwargs)  # noqa: E501

    def get_debit_note_events_with_http_info(self, **kwargs):  # noqa: E501
        """Get Debit Note events.  # noqa: E501

        Listen for Debit Note-related events using long-polling. If there are any events the method will return them immediately. If there are none the method will wait until one appears or timeout passes. `afterTimestamp` parameter can be used in order to get just the 'new' events. Setting the parameter value to the timestamp of the last processed event ensures that no events will go unnoticed.  **NOTE:** The events are persistent, ie. calling the API does not remove the event records from receiving queue.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_debit_note_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_events: Maximum number of events that server should return at once. 
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DebitNoteEvent], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'timeout',
            'after_timestamp',
            'max_events',
            'app_session_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_debit_note_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0.0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `get_debit_note_events`, must be a value greater than or equal to `0.0`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `get_debit_note_events`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `get_debit_note_events`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'after_timestamp' in local_var_params and local_var_params['after_timestamp'] is not None:  # noqa: E501
            query_params.append(('afterTimestamp', local_var_params['after_timestamp']))  # noqa: E501
        if 'max_events' in local_var_params and local_var_params['max_events'] is not None:  # noqa: E501
            query_params.append(('maxEvents', local_var_params['max_events']))  # noqa: E501
        if 'app_session_id' in local_var_params and local_var_params['app_session_id'] is not None:  # noqa: E501
            query_params.append(('appSessionId', local_var_params['app_session_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/debitNoteEvents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DebitNoteEvent]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_debit_notes(self, **kwargs):  # noqa: E501
        """Get Debit Notes known by this node (either issued by this Provider or received by this Requestor).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_debit_notes(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_items: Maximum number of items that server should return at once. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DebitNote]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_debit_notes_with_http_info(**kwargs)  # noqa: E501

    def get_debit_notes_with_http_info(self, **kwargs):  # noqa: E501
        """Get Debit Notes known by this node (either issued by this Provider or received by this Requestor).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_debit_notes_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_items: Maximum number of items that server should return at once. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DebitNote], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'after_timestamp',
            'max_items'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_debit_notes" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'max_items' in local_var_params and local_var_params['max_items'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_items` when calling `get_debit_notes`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_items' in local_var_params and local_var_params['max_items'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_items` when calling `get_debit_notes`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'after_timestamp' in local_var_params and local_var_params['after_timestamp'] is not None:  # noqa: E501
            query_params.append(('afterTimestamp', local_var_params['after_timestamp']))  # noqa: E501
        if 'max_items' in local_var_params and local_var_params['max_items'] is not None:  # noqa: E501
            query_params.append(('maxItems', local_var_params['max_items']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/debitNotes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DebitNote]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice(self, invoice_id, **kwargs):  # noqa: E501
        """Get Invoice.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_invoice_with_http_info(invoice_id, **kwargs)  # noqa: E501

    def get_invoice_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Get Invoice.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Invoice, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'invoice_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if self.api_client.client_side_validation and ('invoice_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['invoice_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `invoice_id` when calling `get_invoice`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'invoice_id' in local_var_params:
            path_params['invoiceId'] = local_var_params['invoice_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/invoices/{invoiceId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoice_events(self, **kwargs):  # noqa: E501
        """Get Invoice events.  # noqa: E501

        Listen for Invoice-related events using long-polling. If there are any events the method will return them immediately. If there are none the method will wait until one appears or timeout passes. `afterTimestamp` parameter can be used in order to get just the 'new' events. Setting the parameter value to the timestamp of the last processed event ensures that no events will go unnoticed.  **NOTE:** The events are persistent, ie. calling the API does not remove the event records from receiving queue.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_events(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_events: Maximum number of events that server should return at once. 
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[InvoiceEvent]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_invoice_events_with_http_info(**kwargs)  # noqa: E501

    def get_invoice_events_with_http_info(self, **kwargs):  # noqa: E501
        """Get Invoice events.  # noqa: E501

        Listen for Invoice-related events using long-polling. If there are any events the method will return them immediately. If there are none the method will wait until one appears or timeout passes. `afterTimestamp` parameter can be used in order to get just the 'new' events. Setting the parameter value to the timestamp of the last processed event ensures that no events will go unnoticed.  **NOTE:** The events are persistent, ie. calling the API does not remove the event records from receiving queue.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoice_events_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_events: Maximum number of events that server should return at once. 
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[InvoiceEvent], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'timeout',
            'after_timestamp',
            'max_events',
            'app_session_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoice_events" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0.0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `get_invoice_events`, must be a value greater than or equal to `0.0`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `get_invoice_events`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `get_invoice_events`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'after_timestamp' in local_var_params and local_var_params['after_timestamp'] is not None:  # noqa: E501
            query_params.append(('afterTimestamp', local_var_params['after_timestamp']))  # noqa: E501
        if 'max_events' in local_var_params and local_var_params['max_events'] is not None:  # noqa: E501
            query_params.append(('maxEvents', local_var_params['max_events']))  # noqa: E501
        if 'app_session_id' in local_var_params and local_var_params['app_session_id'] is not None:  # noqa: E501
            query_params.append(('appSessionId', local_var_params['app_session_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/invoiceEvents', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InvoiceEvent]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_invoices(self, **kwargs):  # noqa: E501
        """Get Invoices known to this node (either issued by this Provider or received by this Requestor).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoices(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_items: Maximum number of items that server should return at once. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Invoice]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_invoices_with_http_info(**kwargs)  # noqa: E501

    def get_invoices_with_http_info(self, **kwargs):  # noqa: E501
        """Get Invoices known to this node (either issued by this Provider or received by this Requestor).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_invoices_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_items: Maximum number of items that server should return at once. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Invoice], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'after_timestamp',
            'max_items'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_invoices" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'max_items' in local_var_params and local_var_params['max_items'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_items` when calling `get_invoices`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_items' in local_var_params and local_var_params['max_items'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_items` when calling `get_invoices`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'after_timestamp' in local_var_params and local_var_params['after_timestamp'] is not None:  # noqa: E501
            query_params.append(('afterTimestamp', local_var_params['after_timestamp']))  # noqa: E501
        if 'max_items' in local_var_params and local_var_params['max_items'] is not None:  # noqa: E501
            query_params.append(('maxItems', local_var_params['max_items']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/invoices', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Invoice]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payment(self, payment_id, **kwargs):  # noqa: E501
        """Get Payment.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str payment_id: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Payment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_payment_with_http_info(payment_id, **kwargs)  # noqa: E501

    def get_payment_with_http_info(self, payment_id, **kwargs):  # noqa: E501
        """Get Payment.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payment_with_http_info(payment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str payment_id: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Payment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'payment_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'payment_id' is set
        if self.api_client.client_side_validation and ('payment_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['payment_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `payment_id` when calling `get_payment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'payment_id' in local_var_params:
            path_params['paymentId'] = local_var_params['payment_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/payments/{paymentId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Payment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payments(self, **kwargs):  # noqa: E501
        """Get Payments.  # noqa: E501

        Payments can be treated as events and this method can be used to listen for new payments by long-polling.  If there are any payments the method will return them immediately. If there are none the method will wait until one appears or timeout passes. `afterTimestamp` parameter can be used in order to get just the 'new' payments. Setting the parameter value to the timestamp of the last processed payment ensures that no payments will go unnoticed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_events: Maximum number of events that server should return at once. 
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Payment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_payments_with_http_info(**kwargs)  # noqa: E501

    def get_payments_with_http_info(self, **kwargs):  # noqa: E501
        """Get Payments.  # noqa: E501

        Payments can be treated as events and this method can be used to listen for new payments by long-polling.  If there are any payments the method will return them immediately. If there are none the method will wait until one appears or timeout passes. `afterTimestamp` parameter can be used in order to get just the 'new' payments. Setting the parameter value to the timestamp of the last processed payment ensures that no payments will go unnoticed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float timeout: Timeout used in long-polling calls (in seconds). How many seconds server should wait for response containing new events (`0.0` means it should return immediately if there are no events) 
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_events: Maximum number of events that server should return at once. 
        :param str app_session_id: A correlation/session identifier used for querying events related to an action where this appSessionId has been specified
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Payment], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'timeout',
            'after_timestamp',
            'max_events',
            'app_session_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0.0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `get_payments`, must be a value greater than or equal to `0.0`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `get_payments`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_events' in local_var_params and local_var_params['max_events'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_events` when calling `get_payments`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501
        if 'after_timestamp' in local_var_params and local_var_params['after_timestamp'] is not None:  # noqa: E501
            query_params.append(('afterTimestamp', local_var_params['after_timestamp']))  # noqa: E501
        if 'max_events' in local_var_params and local_var_params['max_events'] is not None:  # noqa: E501
            query_params.append(('maxEvents', local_var_params['max_events']))  # noqa: E501
        if 'app_session_id' in local_var_params and local_var_params['app_session_id'] is not None:  # noqa: E501
            query_params.append(('appSessionId', local_var_params['app_session_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/payments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Payment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payments_for_debit_note(self, debit_note_id, **kwargs):  # noqa: E501
        """Get Payments for Debit Note.  # noqa: E501

        **WARNING:** Operation not implemented.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_for_debit_note(debit_note_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_note_id: (required)
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_items: Maximum number of items that server should return at once. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Payment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_payments_for_debit_note_with_http_info(debit_note_id, **kwargs)  # noqa: E501

    def get_payments_for_debit_note_with_http_info(self, debit_note_id, **kwargs):  # noqa: E501
        """Get Payments for Debit Note.  # noqa: E501

        **WARNING:** Operation not implemented.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_for_debit_note_with_http_info(debit_note_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_note_id: (required)
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_items: Maximum number of items that server should return at once. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Payment], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'debit_note_id',
            'after_timestamp',
            'max_items'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payments_for_debit_note" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'debit_note_id' is set
        if self.api_client.client_side_validation and ('debit_note_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['debit_note_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `debit_note_id` when calling `get_payments_for_debit_note`")  # noqa: E501

        if self.api_client.client_side_validation and 'max_items' in local_var_params and local_var_params['max_items'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_items` when calling `get_payments_for_debit_note`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_items' in local_var_params and local_var_params['max_items'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_items` when calling `get_payments_for_debit_note`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'debit_note_id' in local_var_params:
            path_params['debitNoteId'] = local_var_params['debit_note_id']  # noqa: E501

        query_params = []
        if 'after_timestamp' in local_var_params and local_var_params['after_timestamp'] is not None:  # noqa: E501
            query_params.append(('afterTimestamp', local_var_params['after_timestamp']))  # noqa: E501
        if 'max_items' in local_var_params and local_var_params['max_items'] is not None:  # noqa: E501
            query_params.append(('maxItems', local_var_params['max_items']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/debitNotes/{debitNoteId}/payments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Payment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_payments_for_invoice(self, invoice_id, **kwargs):  # noqa: E501
        """Get Payments for Invoice.  # noqa: E501

        **WARNING:** Operation not implemented.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_for_invoice(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_items: Maximum number of items that server should return at once. 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Payment]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_payments_for_invoice_with_http_info(invoice_id, **kwargs)  # noqa: E501

    def get_payments_for_invoice_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Get Payments for Invoice.  # noqa: E501

        **WARNING:** Operation not implemented.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_payments_for_invoice_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param datetime after_timestamp: Apply only to records created later than the specified timestamp
        :param int max_items: Maximum number of items that server should return at once. 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Payment], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'invoice_id',
            'after_timestamp',
            'max_items'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_payments_for_invoice" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if self.api_client.client_side_validation and ('invoice_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['invoice_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `invoice_id` when calling `get_payments_for_invoice`")  # noqa: E501

        if self.api_client.client_side_validation and 'max_items' in local_var_params and local_var_params['max_items'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_items` when calling `get_payments_for_invoice`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'max_items' in local_var_params and local_var_params['max_items'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `max_items` when calling `get_payments_for_invoice`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'invoice_id' in local_var_params:
            path_params['invoiceId'] = local_var_params['invoice_id']  # noqa: E501

        query_params = []
        if 'after_timestamp' in local_var_params and local_var_params['after_timestamp'] is not None:  # noqa: E501
            query_params.append(('afterTimestamp', local_var_params['after_timestamp']))  # noqa: E501
        if 'max_items' in local_var_params and local_var_params['max_items'] is not None:  # noqa: E501
            query_params.append(('maxItems', local_var_params['max_items']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/invoices/{invoiceId}/payments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Payment]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_provider_accounts(self, **kwargs):  # noqa: E501
        """Get available accounts for receiving payments.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_provider_accounts(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Account]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_provider_accounts_with_http_info(**kwargs)  # noqa: E501

    def get_provider_accounts_with_http_info(self, **kwargs):  # noqa: E501
        """Get available accounts for receiving payments.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_provider_accounts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Account], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_provider_accounts" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/providerAccounts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Account]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def issue_debit_note(self, debit_note, **kwargs):  # noqa: E501
        """Issue a Debit Note.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issue_debit_note(debit_note, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DebitNote debit_note: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DebitNote
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.issue_debit_note_with_http_info(debit_note, **kwargs)  # noqa: E501

    def issue_debit_note_with_http_info(self, debit_note, **kwargs):  # noqa: E501
        """Issue a Debit Note.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issue_debit_note_with_http_info(debit_note, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DebitNote debit_note: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DebitNote, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["debit_note"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method issue_debit_note" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'debit_note' is set
        if self.api_client.client_side_validation and (
            "debit_note" not in local_var_params
            or local_var_params["debit_note"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `debit_note` when calling `issue_debit_note`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'debit_note' in local_var_params:
            body_params = local_var_params['debit_note']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/debitNotes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DebitNote',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def issue_invoice(self, invoice, **kwargs):  # noqa: E501
        """Issue an Invoice.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issue_invoice(invoice, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Invoice invoice: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Invoice
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.issue_invoice_with_http_info(invoice, **kwargs)  # noqa: E501

    def issue_invoice_with_http_info(self, invoice, **kwargs):  # noqa: E501
        """Issue an Invoice.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.issue_invoice_with_http_info(invoice, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param Invoice invoice: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Invoice, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["invoice"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in local_var_params["kwargs"].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method issue_invoice" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'invoice' is set
        if self.api_client.client_side_validation and (
            "invoice" not in local_var_params
            or local_var_params["invoice"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `invoice` when calling `issue_invoice`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'invoice' in local_var_params:
            body_params = local_var_params['invoice']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/invoices', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Invoice',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_debit_note(self, debit_note_id, **kwargs):  # noqa: E501
        """Send Debit Note to Requestor.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged receiving the Debit Note or timeout has passed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_debit_note(debit_note_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_note_id: (required)
        :param float timeout: Timeout used in blocking calls waiting for eg. acknowledgement. How many seconds server should wait for response/acknowledgement of an action (0.0 means it should wait for other party's response indefinitely) 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.send_debit_note_with_http_info(debit_note_id, **kwargs)  # noqa: E501

    def send_debit_note_with_http_info(self, debit_note_id, **kwargs):  # noqa: E501
        """Send Debit Note to Requestor.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged receiving the Debit Note or timeout has passed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_debit_note_with_http_info(debit_note_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str debit_note_id: (required)
        :param float timeout: Timeout used in blocking calls waiting for eg. acknowledgement. How many seconds server should wait for response/acknowledgement of an action (0.0 means it should wait for other party's response indefinitely) 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'debit_note_id',
            'timeout'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_debit_note" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'debit_note_id' is set
        if self.api_client.client_side_validation and ('debit_note_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['debit_note_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `debit_note_id` when calling `send_debit_note`")  # noqa: E501

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0.0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `send_debit_note`, must be a value greater than or equal to `0.0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'debit_note_id' in local_var_params:
            path_params['debitNoteId'] = local_var_params['debit_note_id']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/debitNotes/{debitNoteId}/send', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def send_invoice(self, invoice_id, **kwargs):  # noqa: E501
        """Send Invoice to Requestor.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged receiving the Invoice or timeout has passed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_invoice(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param float timeout: Timeout used in blocking calls waiting for eg. acknowledgement. How many seconds server should wait for response/acknowledgement of an action (0.0 means it should wait for other party's response indefinitely) 
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.send_invoice_with_http_info(invoice_id, **kwargs)  # noqa: E501

    def send_invoice_with_http_info(self, invoice_id, **kwargs):  # noqa: E501
        """Send Invoice to Requestor.  # noqa: E501

        This is a blocking operation. It will not return until the Requestor has acknowledged receiving the Invoice or timeout has passed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.send_invoice_with_http_info(invoice_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str invoice_id: (required)
        :param float timeout: Timeout used in blocking calls waiting for eg. acknowledgement. How many seconds server should wait for response/acknowledgement of an action (0.0 means it should wait for other party's response indefinitely) 
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'invoice_id',
            'timeout'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in local_var_params['kwargs'].items():
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_invoice" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'invoice_id' is set
        if self.api_client.client_side_validation and ('invoice_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['invoice_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `invoice_id` when calling `send_invoice`")  # noqa: E501

        if self.api_client.client_side_validation and 'timeout' in local_var_params and local_var_params['timeout'] < 0.0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `timeout` when calling `send_invoice`, must be a value greater than or equal to `0.0`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'invoice_id' in local_var_params:
            path_params['invoiceId'] = local_var_params['invoice_id']  # noqa: E501

        query_params = []
        if 'timeout' in local_var_params and local_var_params['timeout'] is not None:  # noqa: E501
            query_params.append(('timeout', local_var_params['timeout']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['app_key']  # noqa: E501

        return self.api_client.call_api(
            '/invoices/{invoiceId}/send', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
