"use strict";
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'Hosted Zone': {
        'Hosted Zone constructs the ARN'(test) {
            // GIVEN
            const stack = new cdk.Stack(undefined, 'TestStack', {
                env: { account: '123456789012', region: 'us-east-1' }
            });
            const testZone = new lib_1.HostedZone(stack, 'HostedZone', {
                zoneName: 'testZone'
            });
            test.deepEqual(stack.resolve(testZone.hostedZoneArn), {
                'Fn::Join': [
                    '',
                    [
                        'arn:',
                        { Ref: 'AWS::Partition' },
                        ':route53:::hostedzone/',
                        { Ref: 'HostedZoneDB99F866' }
                    ]
                ]
            });
            test.done();
        }
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC5ob3N0ZWQtem9uZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInRlc3QuaG9zdGVkLXpvbmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLHFDQUFxQztBQUVyQyxnQ0FBb0M7QUFFcEMsaUJBQVM7SUFDUCxhQUFhLEVBQUU7UUFDYixnQ0FBZ0MsQ0FBQyxJQUFVO1lBQ3pDLFFBQVE7WUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLENBQUMsU0FBUyxFQUFFLFdBQVcsRUFBRTtnQkFDbEQsR0FBRyxFQUFFLEVBQUUsT0FBTyxFQUFFLGNBQWMsRUFBRSxNQUFNLEVBQUUsV0FBVyxFQUFFO2FBQ3RELENBQUMsQ0FBQztZQUVILE1BQU0sUUFBUSxHQUFHLElBQUksZ0JBQVUsQ0FBQyxLQUFLLEVBQUUsWUFBWSxFQUFFO2dCQUNuRCxRQUFRLEVBQUUsVUFBVTthQUNyQixDQUFDLENBQUM7WUFFSCxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQyxFQUFFO2dCQUNwRCxVQUFVLEVBQUU7b0JBQ1YsRUFBRTtvQkFDRjt3QkFDRSxNQUFNO3dCQUNOLEVBQUUsR0FBRyxFQUFFLGdCQUFnQixFQUFFO3dCQUN6Qix3QkFBd0I7d0JBQ3hCLEVBQUUsR0FBRyxFQUFFLG9CQUFvQixFQUFFO3FCQUM5QjtpQkFDRjthQUNGLENBQUMsQ0FBQztZQUVILElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztRQUNkLENBQUM7S0FDRjtDQUNGLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBUZXN0IH0gZnJvbSAnbm9kZXVuaXQnO1xuaW1wb3J0IHsgSG9zdGVkWm9uZSB9IGZyb20gJy4uL2xpYic7XG5cbmV4cG9ydCA9IHtcbiAgJ0hvc3RlZCBab25lJzoge1xuICAgICdIb3N0ZWQgWm9uZSBjb25zdHJ1Y3RzIHRoZSBBUk4nKHRlc3Q6IFRlc3QpIHtcbiAgICAgIC8vIEdJVkVOXG4gICAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2sodW5kZWZpbmVkLCAnVGVzdFN0YWNrJywge1xuICAgICAgICBlbnY6IHsgYWNjb3VudDogJzEyMzQ1Njc4OTAxMicsIHJlZ2lvbjogJ3VzLWVhc3QtMScgfVxuICAgICAgfSk7XG5cbiAgICAgIGNvbnN0IHRlc3Rab25lID0gbmV3IEhvc3RlZFpvbmUoc3RhY2ssICdIb3N0ZWRab25lJywge1xuICAgICAgICB6b25lTmFtZTogJ3Rlc3Rab25lJ1xuICAgICAgfSk7XG5cbiAgICAgIHRlc3QuZGVlcEVxdWFsKHN0YWNrLnJlc29sdmUodGVzdFpvbmUuaG9zdGVkWm9uZUFybiksIHtcbiAgICAgICAgJ0ZuOjpKb2luJzogW1xuICAgICAgICAgICcnLFxuICAgICAgICAgIFtcbiAgICAgICAgICAgICdhcm46JyxcbiAgICAgICAgICAgIHsgUmVmOiAnQVdTOjpQYXJ0aXRpb24nIH0sXG4gICAgICAgICAgICAnOnJvdXRlNTM6Ojpob3N0ZWR6b25lLycsXG4gICAgICAgICAgICB7IFJlZjogJ0hvc3RlZFpvbmVEQjk5Rjg2NicgfVxuICAgICAgICAgIF1cbiAgICAgICAgXVxuICAgICAgfSk7XG5cbiAgICAgIHRlc3QuZG9uZSgpO1xuICAgIH1cbiAgfVxufTtcbiJdfQ==