"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Key = exports.KeyProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kms_generated_1 = require("./kms.generated");
Object.defineProperty(exports, "KeyProperty", { enumerable: true, get: function () { return kms_generated_1.RosKey; } });
/**
 * A ROS resource type:  `ALIYUN::KMS::Key`
 */
class Key extends ros.Resource {
    /**
     * Create a new `ALIYUN::KMS::Key`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosKey = new kms_generated_1.RosKey(this, id, {
            protectionLevel: props.protectionLevel,
            description: props.description,
            rotationInterval: props.rotationInterval,
            enableAutomaticRotation: props.enableAutomaticRotation,
            pendingWindowInDays: props.pendingWindowInDays ? props.pendingWindowInDays : 30,
            keySpec: props.keySpec,
            enable: props.enable ? props.enable : true,
            keyUsage: props.keyUsage ? props.keyUsage : 'ENCRYPT/DECRYPT',
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosKey;
        this.attrKeyId = rosKey.attrKeyId;
    }
}
exports.Key = Key;
//# sourceMappingURL=data:application/json;base64,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