"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Secret = exports.SecretProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const kms_generated_1 = require("./kms.generated");
Object.defineProperty(exports, "SecretProperty", { enumerable: true, get: function () { return kms_generated_1.RosSecret; } });
/**
 * A ROS resource type:  `ALIYUN::KMS::Secret`
 */
class Secret extends ros.Resource {
    /**
     * Create a new `ALIYUN::KMS::Secret`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosSecret = new kms_generated_1.RosSecret(this, id, {
            versionId: props.versionId,
            secretName: props.secretName,
            description: props.description,
            secretDataType: props.secretDataType,
            secretData: props.secretData,
            versionStages: props.versionStages,
            encryptionKeyId: props.encryptionKeyId,
            recoveryWindowInDays: props.recoveryWindowInDays ? props.recoveryWindowInDays : 30,
            forceDeleteWithoutRecovery: props.forceDeleteWithoutRecovery ? props.forceDeleteWithoutRecovery : false,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSecret;
        this.attrArn = rosSecret.attrArn;
        this.attrSecretName = rosSecret.attrSecretName;
    }
}
exports.Secret = Secret;
//# sourceMappingURL=data:application/json;base64,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