/*
 * Decompiled with CFR 0.152.
 */
package gate.tools.gatenlpslave;

import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.creole.Plugin;
import gate.gui.ResourceHelper;

public class GatenlpSlave {
    static boolean DEBUG = false;

    public static void main(String[] args) {
        int tmp;
        if (args.length > 4) {
            System.err.println("Need up to four parameters: port number, host address, 0/1 if actions should get logged, 0/1 if slave should be kept running");
            System.exit(1);
        }
        int port = 25333;
        String host = "127.0.0.1";
        boolean logActions = false;
        boolean keep = false;
        if (args.length > 0) {
            port = Integer.parseInt(args[0]);
        }
        if (args.length > 1) {
            host = args[1];
        }
        if (args.length > 2) {
            tmp = Integer.parseInt(args[2]);
            boolean bl = logActions = tmp != 0;
        }
        if (args.length > 3) {
            tmp = Integer.parseInt(args[3]);
            keep = tmp != 0;
        }
        GatenlpSlave runner = new GatenlpSlave();
        System.err.println("Trying to start GATE Slave on port=" + port + " host=" + host + " log=" + logActions + " keep=" + keep);
        try {
            if (DEBUG) {
                System.err.println("Initializing GATE");
            }
            Gate.init();
            if (DEBUG) {
                System.err.println("Loading plugin python");
            }
            Gate.getCreoleRegister().registerPlugin((Plugin)new Plugin.Maven("uk.ac.gate.plugins", "python", "2.4-SNAPSHOT"));
            FeatureMap parms = Factory.newFeatureMap();
            parms.put((Object)"port", (Object)port);
            parms.put((Object)"host", (Object)host);
            if (DEBUG) {
                System.err.println("logActions is " + logActions);
            }
            parms.put((Object)"logActions", (Object)logActions);
            parms.put((Object)"keep", (Object)keep);
            if (DEBUG) {
                System.err.println("Creating slave");
            }
            ResourceHelper slave = (ResourceHelper)Factory.createResource((String)"gate.plugin.python.PythonSlaveRunner", (FeatureMap)parms);
            if (DEBUG) {
                System.err.println("Slave created");
            }
            if (DEBUG) {
                System.err.println("Trying to start slave");
            }
            slave.call("start", null, new Object[0]);
            if (DEBUG) {
                System.err.println("After starting slave");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (DEBUG) {
            System.err.println("Finishing main");
        }
    }
}

