# Documents


```python
from gatenlp import Document

```


```python
# To load a document from a file with the name "file.bdocjs" into gatenlp simply use:
# doc = Document.load("test2a.bdocjs")

# But it is also possible to load from a file that is somewhere on the internet. For this notebook, we use
# an example document that gets loaded from a URL:
doc = Document.load("https://gatenlp.github.io/python-gatenlp/testdocument1.txt")

# We can visualize the document by printing it:
print(doc)
```

    Document(This is a test document.
    
    It contains just a few sentences. 
    Here is a sentence that mentions a few named entities like 
    the persons Barack Obama or Ursula von der Leyen, locations
    like New York City, Vienna or Beijing or companies like 
    Google, UniCredit or Huawei. 
    
    Here we include a URL https://gatenlp.github.io/python-gatenlp/ 
    and a fake email address john.doe@hiscoolserver.com as well 
    as #some #cool #hastags and a bunch of emojis like 😽 (a kissing cat),
    👩‍🏫 (a woman teacher), 🧬 (DNA), 
    🧗 (a person climbing), 
    💩 (a pile of poo). 
    
    Here we test a few different scripts, e.g. Hangul 한글 or 
    simplified Hanzi 汉字 or Farsi فارسی which goes from right to left. 
    
    
    ,features=Features({}),anns=[])


Printing the document shows the document text and indicates that there are no document features and no 
annotations which is to be expected since we just loaded from a plain text file. 

In a Jupyter notebook, a `gatenlp` document can also be visualized graphically by either just using the document 
as the last value of a cell or by using the IPython "display" function:


```python
from IPython.display import display
display(doc)
```


<script type="text/javascript">/*! jQuery v3.5.1 | (c) JS Foundation and other contributors | jquery.org/license */
!function(e,t){"use strict";"object"==typeof module&&"object"==typeof module.exports?module.exports=e.document?t(e,!0):function(e){if(!e.document)throw new Error("jQuery requires a window with a document");return t(e)}:t(e)}("undefined"!=typeof window?window:this,function(C,e){"use strict";var t=[],r=Object.getPrototypeOf,s=t.slice,g=t.flat?function(e){return t.flat.call(e)}:function(e){return t.concat.apply([],e)},u=t.push,i=t.indexOf,n={},o=n.toString,v=n.hasOwnProperty,a=v.toString,l=a.call(Object),y={},m=function(e){return"function"==typeof e&&"number"!=typeof e.nodeType},x=function(e){return null!=e&&e===e.window},E=C.document,c={type:!0,src:!0,nonce:!0,noModule:!0};function b(e,t,n){var r,i,o=(n=n||E).createElement("script");if(o.text=e,t)for(r in c)(i=t[r]||t.getAttribute&&t.getAttribute(r))&&o.setAttribute(r,i);n.head.appendChild(o).parentNode.removeChild(o)}function w(e){return null==e?e+"":"object"==typeof e||"function"==typeof e?n[o.call(e)]||"object":typeof e}var f="3.5.1",S=function(e,t){return new S.fn.init(e,t)};function p(e){var t=!!e&&"length"in e&&e.length,n=w(e);return!m(e)&&!x(e)&&("array"===n||0===t||"number"==typeof t&&0<t&&t-1 in e)}S.fn=S.prototype={jquery:f,constructor:S,length:0,toArray:function(){return s.call(this)},get:function(e){return null==e?s.call(this):e<0?this[e+this.length]:this[e]},pushStack:function(e){var t=S.merge(this.constructor(),e);return t.prevObject=this,t},each:function(e){return S.each(this,e)},map:function(n){return this.pushStack(S.map(this,function(e,t){return n.call(e,t,e)}))},slice:function(){return this.pushStack(s.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},even:function(){return this.pushStack(S.grep(this,function(e,t){return(t+1)%2}))},odd:function(){return this.pushStack(S.grep(this,function(e,t){return t%2}))},eq:function(e){var t=this.length,n=+e+(e<0?t:0);return this.pushStack(0<=n&&n<t?[this[n]]:[])},end:function(){return this.prevObject||this.constructor()},push:u,sort:t.sort,splice:t.splice},S.extend=S.fn.extend=function(){var e,t,n,r,i,o,a=arguments[0]||{},s=1,u=arguments.length,l=!1;for("boolean"==typeof a&&(l=a,a=arguments[s]||{},s++),"object"==typeof a||m(a)||(a={}),s===u&&(a=this,s--);s<u;s++)if(null!=(e=arguments[s]))for(t in e)r=e[t],"__proto__"!==t&&a!==r&&(l&&r&&(S.isPlainObject(r)||(i=Array.isArray(r)))?(n=a[t],o=i&&!Array.isArray(n)?[]:i||S.isPlainObject(n)?n:{},i=!1,a[t]=S.extend(l,o,r)):void 0!==r&&(a[t]=r));return a},S.extend({expando:"jQuery"+(f+Math.random()).replace(/\D/g,""),isReady:!0,error:function(e){throw new Error(e)},noop:function(){},isPlainObject:function(e){var t,n;return!(!e||"[object Object]"!==o.call(e))&&(!(t=r(e))||"function"==typeof(n=v.call(t,"constructor")&&t.constructor)&&a.call(n)===l)},isEmptyObject:function(e){var t;for(t in e)return!1;return!0},globalEval:function(e,t,n){b(e,{nonce:t&&t.nonce},n)},each:function(e,t){var n,r=0;if(p(e)){for(n=e.length;r<n;r++)if(!1===t.call(e[r],r,e[r]))break}else for(r in e)if(!1===t.call(e[r],r,e[r]))break;return e},makeArray:function(e,t){var n=t||[];return null!=e&&(p(Object(e))?S.merge(n,"string"==typeof e?[e]:e):u.call(n,e)),n},inArray:function(e,t,n){return null==t?-1:i.call(t,e,n)},merge:function(e,t){for(var n=+t.length,r=0,i=e.length;r<n;r++)e[i++]=t[r];return e.length=i,e},grep:function(e,t,n){for(var r=[],i=0,o=e.length,a=!n;i<o;i++)!t(e[i],i)!==a&&r.push(e[i]);return r},map:function(e,t,n){var r,i,o=0,a=[];if(p(e))for(r=e.length;o<r;o++)null!=(i=t(e[o],o,n))&&a.push(i);else for(o in e)null!=(i=t(e[o],o,n))&&a.push(i);return g(a)},guid:1,support:y}),"function"==typeof Symbol&&(S.fn[Symbol.iterator]=t[Symbol.iterator]),S.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(e,t){n["[object "+t+"]"]=t.toLowerCase()});var d=function(n){var e,d,b,o,i,h,f,g,w,u,l,T,C,a,E,v,s,c,y,S="sizzle"+1*new Date,p=n.document,k=0,r=0,m=ue(),x=ue(),A=ue(),N=ue(),D=function(e,t){return e===t&&(l=!0),0},j={}.hasOwnProperty,t=[],q=t.pop,L=t.push,H=t.push,O=t.slice,P=function(e,t){for(var n=0,r=e.length;n<r;n++)if(e[n]===t)return n;return-1},R="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped",M="[\\x20\\t\\r\\n\\f]",I="(?:\\\\[\\da-fA-F]{1,6}"+M+"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",W="\\["+M+"*("+I+")(?:"+M+"*([*^$|!~]?=)"+M+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+I+"))|)"+M+"*\\]",F=":("+I+")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|"+W+")*)|.*)\\)|)",B=new RegExp(M+"+","g"),$=new RegExp("^"+M+"+|((?:^|[^\\\\])(?:\\\\.)*)"+M+"+$","g"),_=new RegExp("^"+M+"*,"+M+"*"),z=new RegExp("^"+M+"*([>+~]|"+M+")"+M+"*"),U=new RegExp(M+"|>"),X=new RegExp(F),V=new RegExp("^"+I+"$"),G={ID:new RegExp("^#("+I+")"),CLASS:new RegExp("^\\.("+I+")"),TAG:new RegExp("^("+I+"|[*])"),ATTR:new RegExp("^"+W),PSEUDO:new RegExp("^"+F),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+M+"*(even|odd|(([+-]|)(\\d*)n|)"+M+"*(?:([+-]|)"+M+"*(\\d+)|))"+M+"*\\)|)","i"),bool:new RegExp("^(?:"+R+")$","i"),needsContext:new RegExp("^"+M+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+M+"*((?:-\\d)?\\d*)"+M+"*\\)|)(?=[^-]|$)","i")},Y=/HTML$/i,Q=/^(?:input|select|textarea|button)$/i,J=/^h\d$/i,K=/^[^{]+\{\s*\[native \w/,Z=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,ee=/[+~]/,te=new RegExp("\\\\[\\da-fA-F]{1,6}"+M+"?|\\\\([^\\r\\n\\f])","g"),ne=function(e,t){var n="0x"+e.slice(1)-65536;return t||(n<0?String.fromCharCode(n+65536):String.fromCharCode(n>>10|55296,1023&n|56320))},re=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,ie=function(e,t){return t?"\0"===e?"\ufffd":e.slice(0,-1)+"\\"+e.charCodeAt(e.length-1).toString(16)+" ":"\\"+e},oe=function(){T()},ae=be(function(e){return!0===e.disabled&&"fieldset"===e.nodeName.toLowerCase()},{dir:"parentNode",next:"legend"});try{H.apply(t=O.call(p.childNodes),p.childNodes),t[p.childNodes.length].nodeType}catch(e){H={apply:t.length?function(e,t){L.apply(e,O.call(t))}:function(e,t){var n=e.length,r=0;while(e[n++]=t[r++]);e.length=n-1}}}function se(t,e,n,r){var i,o,a,s,u,l,c,f=e&&e.ownerDocument,p=e?e.nodeType:9;if(n=n||[],"string"!=typeof t||!t||1!==p&&9!==p&&11!==p)return n;if(!r&&(T(e),e=e||C,E)){if(11!==p&&(u=Z.exec(t)))if(i=u[1]){if(9===p){if(!(a=e.getElementById(i)))return n;if(a.id===i)return n.push(a),n}else if(f&&(a=f.getElementById(i))&&y(e,a)&&a.id===i)return n.push(a),n}else{if(u[2])return H.apply(n,e.getElementsByTagName(t)),n;if((i=u[3])&&d.getElementsByClassName&&e.getElementsByClassName)return H.apply(n,e.getElementsByClassName(i)),n}if(d.qsa&&!N[t+" "]&&(!v||!v.test(t))&&(1!==p||"object"!==e.nodeName.toLowerCase())){if(c=t,f=e,1===p&&(U.test(t)||z.test(t))){(f=ee.test(t)&&ye(e.parentNode)||e)===e&&d.scope||((s=e.getAttribute("id"))?s=s.replace(re,ie):e.setAttribute("id",s=S)),o=(l=h(t)).length;while(o--)l[o]=(s?"#"+s:":scope")+" "+xe(l[o]);c=l.join(",")}try{return H.apply(n,f.querySelectorAll(c)),n}catch(e){N(t,!0)}finally{s===S&&e.removeAttribute("id")}}}return g(t.replace($,"$1"),e,n,r)}function ue(){var r=[];return function e(t,n){return r.push(t+" ")>b.cacheLength&&delete e[r.shift()],e[t+" "]=n}}function le(e){return e[S]=!0,e}function ce(e){var t=C.createElement("fieldset");try{return!!e(t)}catch(e){return!1}finally{t.parentNode&&t.parentNode.removeChild(t),t=null}}function fe(e,t){var n=e.split("|"),r=n.length;while(r--)b.attrHandle[n[r]]=t}function pe(e,t){var n=t&&e,r=n&&1===e.nodeType&&1===t.nodeType&&e.sourceIndex-t.sourceIndex;if(r)return r;if(n)while(n=n.nextSibling)if(n===t)return-1;return e?1:-1}function de(t){return function(e){return"input"===e.nodeName.toLowerCase()&&e.type===t}}function he(n){return function(e){var t=e.nodeName.toLowerCase();return("input"===t||"button"===t)&&e.type===n}}function ge(t){return function(e){return"form"in e?e.parentNode&&!1===e.disabled?"label"in e?"label"in e.parentNode?e.parentNode.disabled===t:e.disabled===t:e.isDisabled===t||e.isDisabled!==!t&&ae(e)===t:e.disabled===t:"label"in e&&e.disabled===t}}function ve(a){return le(function(o){return o=+o,le(function(e,t){var n,r=a([],e.length,o),i=r.length;while(i--)e[n=r[i]]&&(e[n]=!(t[n]=e[n]))})})}function ye(e){return e&&"undefined"!=typeof e.getElementsByTagName&&e}for(e in d=se.support={},i=se.isXML=function(e){var t=e.namespaceURI,n=(e.ownerDocument||e).documentElement;return!Y.test(t||n&&n.nodeName||"HTML")},T=se.setDocument=function(e){var t,n,r=e?e.ownerDocument||e:p;return r!=C&&9===r.nodeType&&r.documentElement&&(a=(C=r).documentElement,E=!i(C),p!=C&&(n=C.defaultView)&&n.top!==n&&(n.addEventListener?n.addEventListener("unload",oe,!1):n.attachEvent&&n.attachEvent("onunload",oe)),d.scope=ce(function(e){return a.appendChild(e).appendChild(C.createElement("div")),"undefined"!=typeof e.querySelectorAll&&!e.querySelectorAll(":scope fieldset div").length}),d.attributes=ce(function(e){return e.className="i",!e.getAttribute("className")}),d.getElementsByTagName=ce(function(e){return e.appendChild(C.createComment("")),!e.getElementsByTagName("*").length}),d.getElementsByClassName=K.test(C.getElementsByClassName),d.getById=ce(function(e){return a.appendChild(e).id=S,!C.getElementsByName||!C.getElementsByName(S).length}),d.getById?(b.filter.ID=function(e){var t=e.replace(te,ne);return function(e){return e.getAttribute("id")===t}},b.find.ID=function(e,t){if("undefined"!=typeof t.getElementById&&E){var n=t.getElementById(e);return n?[n]:[]}}):(b.filter.ID=function(e){var n=e.replace(te,ne);return function(e){var t="undefined"!=typeof e.getAttributeNode&&e.getAttributeNode("id");return t&&t.value===n}},b.find.ID=function(e,t){if("undefined"!=typeof t.getElementById&&E){var n,r,i,o=t.getElementById(e);if(o){if((n=o.getAttributeNode("id"))&&n.value===e)return[o];i=t.getElementsByName(e),r=0;while(o=i[r++])if((n=o.getAttributeNode("id"))&&n.value===e)return[o]}return[]}}),b.find.TAG=d.getElementsByTagName?function(e,t){return"undefined"!=typeof t.getElementsByTagName?t.getElementsByTagName(e):d.qsa?t.querySelectorAll(e):void 0}:function(e,t){var n,r=[],i=0,o=t.getElementsByTagName(e);if("*"===e){while(n=o[i++])1===n.nodeType&&r.push(n);return r}return o},b.find.CLASS=d.getElementsByClassName&&function(e,t){if("undefined"!=typeof t.getElementsByClassName&&E)return t.getElementsByClassName(e)},s=[],v=[],(d.qsa=K.test(C.querySelectorAll))&&(ce(function(e){var t;a.appendChild(e).innerHTML="<a id='"+S+"'></a><select id='"+S+"-\r\\' msallowcapture=''><option selected=''></option></select>",e.querySelectorAll("[msallowcapture^='']").length&&v.push("[*^$]="+M+"*(?:''|\"\")"),e.querySelectorAll("[selected]").length||v.push("\\["+M+"*(?:value|"+R+")"),e.querySelectorAll("[id~="+S+"-]").length||v.push("~="),(t=C.createElement("input")).setAttribute("name",""),e.appendChild(t),e.querySelectorAll("[name='']").length||v.push("\\["+M+"*name"+M+"*="+M+"*(?:''|\"\")"),e.querySelectorAll(":checked").length||v.push(":checked"),e.querySelectorAll("a#"+S+"+*").length||v.push(".#.+[+~]"),e.querySelectorAll("\\\f"),v.push("[\\r\\n\\f]")}),ce(function(e){e.innerHTML="<a href='' disabled='disabled'></a><select disabled='disabled'><option/></select>";var t=C.createElement("input");t.setAttribute("type","hidden"),e.appendChild(t).setAttribute("name","D"),e.querySelectorAll("[name=d]").length&&v.push("name"+M+"*[*^$|!~]?="),2!==e.querySelectorAll(":enabled").length&&v.push(":enabled",":disabled"),a.appendChild(e).disabled=!0,2!==e.querySelectorAll(":disabled").length&&v.push(":enabled",":disabled"),e.querySelectorAll("*,:x"),v.push(",.*:")})),(d.matchesSelector=K.test(c=a.matches||a.webkitMatchesSelector||a.mozMatchesSelector||a.oMatchesSelector||a.msMatchesSelector))&&ce(function(e){d.disconnectedMatch=c.call(e,"*"),c.call(e,"[s!='']:x"),s.push("!=",F)}),v=v.length&&new RegExp(v.join("|")),s=s.length&&new RegExp(s.join("|")),t=K.test(a.compareDocumentPosition),y=t||K.test(a.contains)?function(e,t){var n=9===e.nodeType?e.documentElement:e,r=t&&t.parentNode;return e===r||!(!r||1!==r.nodeType||!(n.contains?n.contains(r):e.compareDocumentPosition&&16&e.compareDocumentPosition(r)))}:function(e,t){if(t)while(t=t.parentNode)if(t===e)return!0;return!1},D=t?function(e,t){if(e===t)return l=!0,0;var n=!e.compareDocumentPosition-!t.compareDocumentPosition;return n||(1&(n=(e.ownerDocument||e)==(t.ownerDocument||t)?e.compareDocumentPosition(t):1)||!d.sortDetached&&t.compareDocumentPosition(e)===n?e==C||e.ownerDocument==p&&y(p,e)?-1:t==C||t.ownerDocument==p&&y(p,t)?1:u?P(u,e)-P(u,t):0:4&n?-1:1)}:function(e,t){if(e===t)return l=!0,0;var n,r=0,i=e.parentNode,o=t.parentNode,a=[e],s=[t];if(!i||!o)return e==C?-1:t==C?1:i?-1:o?1:u?P(u,e)-P(u,t):0;if(i===o)return pe(e,t);n=e;while(n=n.parentNode)a.unshift(n);n=t;while(n=n.parentNode)s.unshift(n);while(a[r]===s[r])r++;return r?pe(a[r],s[r]):a[r]==p?-1:s[r]==p?1:0}),C},se.matches=function(e,t){return se(e,null,null,t)},se.matchesSelector=function(e,t){if(T(e),d.matchesSelector&&E&&!N[t+" "]&&(!s||!s.test(t))&&(!v||!v.test(t)))try{var n=c.call(e,t);if(n||d.disconnectedMatch||e.document&&11!==e.document.nodeType)return n}catch(e){N(t,!0)}return 0<se(t,C,null,[e]).length},se.contains=function(e,t){return(e.ownerDocument||e)!=C&&T(e),y(e,t)},se.attr=function(e,t){(e.ownerDocument||e)!=C&&T(e);var n=b.attrHandle[t.toLowerCase()],r=n&&j.call(b.attrHandle,t.toLowerCase())?n(e,t,!E):void 0;return void 0!==r?r:d.attributes||!E?e.getAttribute(t):(r=e.getAttributeNode(t))&&r.specified?r.value:null},se.escape=function(e){return(e+"").replace(re,ie)},se.error=function(e){throw new Error("Syntax error, unrecognized expression: "+e)},se.uniqueSort=function(e){var t,n=[],r=0,i=0;if(l=!d.detectDuplicates,u=!d.sortStable&&e.slice(0),e.sort(D),l){while(t=e[i++])t===e[i]&&(r=n.push(i));while(r--)e.splice(n[r],1)}return u=null,e},o=se.getText=function(e){var t,n="",r=0,i=e.nodeType;if(i){if(1===i||9===i||11===i){if("string"==typeof e.textContent)return e.textContent;for(e=e.firstChild;e;e=e.nextSibling)n+=o(e)}else if(3===i||4===i)return e.nodeValue}else while(t=e[r++])n+=o(t);return n},(b=se.selectors={cacheLength:50,createPseudo:le,match:G,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(e){return e[1]=e[1].replace(te,ne),e[3]=(e[3]||e[4]||e[5]||"").replace(te,ne),"~="===e[2]&&(e[3]=" "+e[3]+" "),e.slice(0,4)},CHILD:function(e){return e[1]=e[1].toLowerCase(),"nth"===e[1].slice(0,3)?(e[3]||se.error(e[0]),e[4]=+(e[4]?e[5]+(e[6]||1):2*("even"===e[3]||"odd"===e[3])),e[5]=+(e[7]+e[8]||"odd"===e[3])):e[3]&&se.error(e[0]),e},PSEUDO:function(e){var t,n=!e[6]&&e[2];return G.CHILD.test(e[0])?null:(e[3]?e[2]=e[4]||e[5]||"":n&&X.test(n)&&(t=h(n,!0))&&(t=n.indexOf(")",n.length-t)-n.length)&&(e[0]=e[0].slice(0,t),e[2]=n.slice(0,t)),e.slice(0,3))}},filter:{TAG:function(e){var t=e.replace(te,ne).toLowerCase();return"*"===e?function(){return!0}:function(e){return e.nodeName&&e.nodeName.toLowerCase()===t}},CLASS:function(e){var t=m[e+" "];return t||(t=new RegExp("(^|"+M+")"+e+"("+M+"|$)"))&&m(e,function(e){return t.test("string"==typeof e.className&&e.className||"undefined"!=typeof e.getAttribute&&e.getAttribute("class")||"")})},ATTR:function(n,r,i){return function(e){var t=se.attr(e,n);return null==t?"!="===r:!r||(t+="","="===r?t===i:"!="===r?t!==i:"^="===r?i&&0===t.indexOf(i):"*="===r?i&&-1<t.indexOf(i):"$="===r?i&&t.slice(-i.length)===i:"~="===r?-1<(" "+t.replace(B," ")+" ").indexOf(i):"|="===r&&(t===i||t.slice(0,i.length+1)===i+"-"))}},CHILD:function(h,e,t,g,v){var y="nth"!==h.slice(0,3),m="last"!==h.slice(-4),x="of-type"===e;return 1===g&&0===v?function(e){return!!e.parentNode}:function(e,t,n){var r,i,o,a,s,u,l=y!==m?"nextSibling":"previousSibling",c=e.parentNode,f=x&&e.nodeName.toLowerCase(),p=!n&&!x,d=!1;if(c){if(y){while(l){a=e;while(a=a[l])if(x?a.nodeName.toLowerCase()===f:1===a.nodeType)return!1;u=l="only"===h&&!u&&"nextSibling"}return!0}if(u=[m?c.firstChild:c.lastChild],m&&p){d=(s=(r=(i=(o=(a=c)[S]||(a[S]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]||[])[0]===k&&r[1])&&r[2],a=s&&c.childNodes[s];while(a=++s&&a&&a[l]||(d=s=0)||u.pop())if(1===a.nodeType&&++d&&a===e){i[h]=[k,s,d];break}}else if(p&&(d=s=(r=(i=(o=(a=e)[S]||(a[S]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]||[])[0]===k&&r[1]),!1===d)while(a=++s&&a&&a[l]||(d=s=0)||u.pop())if((x?a.nodeName.toLowerCase()===f:1===a.nodeType)&&++d&&(p&&((i=(o=a[S]||(a[S]={}))[a.uniqueID]||(o[a.uniqueID]={}))[h]=[k,d]),a===e))break;return(d-=v)===g||d%g==0&&0<=d/g}}},PSEUDO:function(e,o){var t,a=b.pseudos[e]||b.setFilters[e.toLowerCase()]||se.error("unsupported pseudo: "+e);return a[S]?a(o):1<a.length?(t=[e,e,"",o],b.setFilters.hasOwnProperty(e.toLowerCase())?le(function(e,t){var n,r=a(e,o),i=r.length;while(i--)e[n=P(e,r[i])]=!(t[n]=r[i])}):function(e){return a(e,0,t)}):a}},pseudos:{not:le(function(e){var r=[],i=[],s=f(e.replace($,"$1"));return s[S]?le(function(e,t,n,r){var i,o=s(e,null,r,[]),a=e.length;while(a--)(i=o[a])&&(e[a]=!(t[a]=i))}):function(e,t,n){return r[0]=e,s(r,null,n,i),r[0]=null,!i.pop()}}),has:le(function(t){return function(e){return 0<se(t,e).length}}),contains:le(function(t){return t=t.replace(te,ne),function(e){return-1<(e.textContent||o(e)).indexOf(t)}}),lang:le(function(n){return V.test(n||"")||se.error("unsupported lang: "+n),n=n.replace(te,ne).toLowerCase(),function(e){var t;do{if(t=E?e.lang:e.getAttribute("xml:lang")||e.getAttribute("lang"))return(t=t.toLowerCase())===n||0===t.indexOf(n+"-")}while((e=e.parentNode)&&1===e.nodeType);return!1}}),target:function(e){var t=n.location&&n.location.hash;return t&&t.slice(1)===e.id},root:function(e){return e===a},focus:function(e){return e===C.activeElement&&(!C.hasFocus||C.hasFocus())&&!!(e.type||e.href||~e.tabIndex)},enabled:ge(!1),disabled:ge(!0),checked:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&!!e.checked||"option"===t&&!!e.selected},selected:function(e){return e.parentNode&&e.parentNode.selectedIndex,!0===e.selected},empty:function(e){for(e=e.firstChild;e;e=e.nextSibling)if(e.nodeType<6)return!1;return!0},parent:function(e){return!b.pseudos.empty(e)},header:function(e){return J.test(e.nodeName)},input:function(e){return Q.test(e.nodeName)},button:function(e){var t=e.nodeName.toLowerCase();return"input"===t&&"button"===e.type||"button"===t},text:function(e){var t;return"input"===e.nodeName.toLowerCase()&&"text"===e.type&&(null==(t=e.getAttribute("type"))||"text"===t.toLowerCase())},first:ve(function(){return[0]}),last:ve(function(e,t){return[t-1]}),eq:ve(function(e,t,n){return[n<0?n+t:n]}),even:ve(function(e,t){for(var n=0;n<t;n+=2)e.push(n);return e}),odd:ve(function(e,t){for(var n=1;n<t;n+=2)e.push(n);return e}),lt:ve(function(e,t,n){for(var r=n<0?n+t:t<n?t:n;0<=--r;)e.push(r);return e}),gt:ve(function(e,t,n){for(var r=n<0?n+t:n;++r<t;)e.push(r);return e})}}).pseudos.nth=b.pseudos.eq,{radio:!0,checkbox:!0,file:!0,password:!0,image:!0})b.pseudos[e]=de(e);for(e in{submit:!0,reset:!0})b.pseudos[e]=he(e);function me(){}function xe(e){for(var t=0,n=e.length,r="";t<n;t++)r+=e[t].value;return r}function be(s,e,t){var u=e.dir,l=e.next,c=l||u,f=t&&"parentNode"===c,p=r++;return e.first?function(e,t,n){while(e=e[u])if(1===e.nodeType||f)return s(e,t,n);return!1}:function(e,t,n){var r,i,o,a=[k,p];if(n){while(e=e[u])if((1===e.nodeType||f)&&s(e,t,n))return!0}else while(e=e[u])if(1===e.nodeType||f)if(i=(o=e[S]||(e[S]={}))[e.uniqueID]||(o[e.uniqueID]={}),l&&l===e.nodeName.toLowerCase())e=e[u]||e;else{if((r=i[c])&&r[0]===k&&r[1]===p)return a[2]=r[2];if((i[c]=a)[2]=s(e,t,n))return!0}return!1}}function we(i){return 1<i.length?function(e,t,n){var r=i.length;while(r--)if(!i[r](e,t,n))return!1;return!0}:i[0]}function Te(e,t,n,r,i){for(var o,a=[],s=0,u=e.length,l=null!=t;s<u;s++)(o=e[s])&&(n&&!n(o,r,i)||(a.push(o),l&&t.push(s)));return a}function Ce(d,h,g,v,y,e){return v&&!v[S]&&(v=Ce(v)),y&&!y[S]&&(y=Ce(y,e)),le(function(e,t,n,r){var i,o,a,s=[],u=[],l=t.length,c=e||function(e,t,n){for(var r=0,i=t.length;r<i;r++)se(e,t[r],n);return n}(h||"*",n.nodeType?[n]:n,[]),f=!d||!e&&h?c:Te(c,s,d,n,r),p=g?y||(e?d:l||v)?[]:t:f;if(g&&g(f,p,n,r),v){i=Te(p,u),v(i,[],n,r),o=i.length;while(o--)(a=i[o])&&(p[u[o]]=!(f[u[o]]=a))}if(e){if(y||d){if(y){i=[],o=p.length;while(o--)(a=p[o])&&i.push(f[o]=a);y(null,p=[],i,r)}o=p.length;while(o--)(a=p[o])&&-1<(i=y?P(e,a):s[o])&&(e[i]=!(t[i]=a))}}else p=Te(p===t?p.splice(l,p.length):p),y?y(null,t,p,r):H.apply(t,p)})}function Ee(e){for(var i,t,n,r=e.length,o=b.relative[e[0].type],a=o||b.relative[" "],s=o?1:0,u=be(function(e){return e===i},a,!0),l=be(function(e){return-1<P(i,e)},a,!0),c=[function(e,t,n){var r=!o&&(n||t!==w)||((i=t).nodeType?u(e,t,n):l(e,t,n));return i=null,r}];s<r;s++)if(t=b.relative[e[s].type])c=[be(we(c),t)];else{if((t=b.filter[e[s].type].apply(null,e[s].matches))[S]){for(n=++s;n<r;n++)if(b.relative[e[n].type])break;return Ce(1<s&&we(c),1<s&&xe(e.slice(0,s-1).concat({value:" "===e[s-2].type?"*":""})).replace($,"$1"),t,s<n&&Ee(e.slice(s,n)),n<r&&Ee(e=e.slice(n)),n<r&&xe(e))}c.push(t)}return we(c)}return me.prototype=b.filters=b.pseudos,b.setFilters=new me,h=se.tokenize=function(e,t){var n,r,i,o,a,s,u,l=x[e+" "];if(l)return t?0:l.slice(0);a=e,s=[],u=b.preFilter;while(a){for(o in n&&!(r=_.exec(a))||(r&&(a=a.slice(r[0].length)||a),s.push(i=[])),n=!1,(r=z.exec(a))&&(n=r.shift(),i.push({value:n,type:r[0].replace($," ")}),a=a.slice(n.length)),b.filter)!(r=G[o].exec(a))||u[o]&&!(r=u[o](r))||(n=r.shift(),i.push({value:n,type:o,matches:r}),a=a.slice(n.length));if(!n)break}return t?a.length:a?se.error(e):x(e,s).slice(0)},f=se.compile=function(e,t){var n,v,y,m,x,r,i=[],o=[],a=A[e+" "];if(!a){t||(t=h(e)),n=t.length;while(n--)(a=Ee(t[n]))[S]?i.push(a):o.push(a);(a=A(e,(v=o,m=0<(y=i).length,x=0<v.length,r=function(e,t,n,r,i){var o,a,s,u=0,l="0",c=e&&[],f=[],p=w,d=e||x&&b.find.TAG("*",i),h=k+=null==p?1:Math.random()||.1,g=d.length;for(i&&(w=t==C||t||i);l!==g&&null!=(o=d[l]);l++){if(x&&o){a=0,t||o.ownerDocument==C||(T(o),n=!E);while(s=v[a++])if(s(o,t||C,n)){r.push(o);break}i&&(k=h)}m&&((o=!s&&o)&&u--,e&&c.push(o))}if(u+=l,m&&l!==u){a=0;while(s=y[a++])s(c,f,t,n);if(e){if(0<u)while(l--)c[l]||f[l]||(f[l]=q.call(r));f=Te(f)}H.apply(r,f),i&&!e&&0<f.length&&1<u+y.length&&se.uniqueSort(r)}return i&&(k=h,w=p),c},m?le(r):r))).selector=e}return a},g=se.select=function(e,t,n,r){var i,o,a,s,u,l="function"==typeof e&&e,c=!r&&h(e=l.selector||e);if(n=n||[],1===c.length){if(2<(o=c[0]=c[0].slice(0)).length&&"ID"===(a=o[0]).type&&9===t.nodeType&&E&&b.relative[o[1].type]){if(!(t=(b.find.ID(a.matches[0].replace(te,ne),t)||[])[0]))return n;l&&(t=t.parentNode),e=e.slice(o.shift().value.length)}i=G.needsContext.test(e)?0:o.length;while(i--){if(a=o[i],b.relative[s=a.type])break;if((u=b.find[s])&&(r=u(a.matches[0].replace(te,ne),ee.test(o[0].type)&&ye(t.parentNode)||t))){if(o.splice(i,1),!(e=r.length&&xe(o)))return H.apply(n,r),n;break}}}return(l||f(e,c))(r,t,!E,n,!t||ee.test(e)&&ye(t.parentNode)||t),n},d.sortStable=S.split("").sort(D).join("")===S,d.detectDuplicates=!!l,T(),d.sortDetached=ce(function(e){return 1&e.compareDocumentPosition(C.createElement("fieldset"))}),ce(function(e){return e.innerHTML="<a href='#'></a>","#"===e.firstChild.getAttribute("href")})||fe("type|href|height|width",function(e,t,n){if(!n)return e.getAttribute(t,"type"===t.toLowerCase()?1:2)}),d.attributes&&ce(function(e){return e.innerHTML="<input/>",e.firstChild.setAttribute("value",""),""===e.firstChild.getAttribute("value")})||fe("value",function(e,t,n){if(!n&&"input"===e.nodeName.toLowerCase())return e.defaultValue}),ce(function(e){return null==e.getAttribute("disabled")})||fe(R,function(e,t,n){var r;if(!n)return!0===e[t]?t.toLowerCase():(r=e.getAttributeNode(t))&&r.specified?r.value:null}),se}(C);S.find=d,S.expr=d.selectors,S.expr[":"]=S.expr.pseudos,S.uniqueSort=S.unique=d.uniqueSort,S.text=d.getText,S.isXMLDoc=d.isXML,S.contains=d.contains,S.escapeSelector=d.escape;var h=function(e,t,n){var r=[],i=void 0!==n;while((e=e[t])&&9!==e.nodeType)if(1===e.nodeType){if(i&&S(e).is(n))break;r.push(e)}return r},T=function(e,t){for(var n=[];e;e=e.nextSibling)1===e.nodeType&&e!==t&&n.push(e);return n},k=S.expr.match.needsContext;function A(e,t){return e.nodeName&&e.nodeName.toLowerCase()===t.toLowerCase()}var N=/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;function D(e,n,r){return m(n)?S.grep(e,function(e,t){return!!n.call(e,t,e)!==r}):n.nodeType?S.grep(e,function(e){return e===n!==r}):"string"!=typeof n?S.grep(e,function(e){return-1<i.call(n,e)!==r}):S.filter(n,e,r)}S.filter=function(e,t,n){var r=t[0];return n&&(e=":not("+e+")"),1===t.length&&1===r.nodeType?S.find.matchesSelector(r,e)?[r]:[]:S.find.matches(e,S.grep(t,function(e){return 1===e.nodeType}))},S.fn.extend({find:function(e){var t,n,r=this.length,i=this;if("string"!=typeof e)return this.pushStack(S(e).filter(function(){for(t=0;t<r;t++)if(S.contains(i[t],this))return!0}));for(n=this.pushStack([]),t=0;t<r;t++)S.find(e,i[t],n);return 1<r?S.uniqueSort(n):n},filter:function(e){return this.pushStack(D(this,e||[],!1))},not:function(e){return this.pushStack(D(this,e||[],!0))},is:function(e){return!!D(this,"string"==typeof e&&k.test(e)?S(e):e||[],!1).length}});var j,q=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/;(S.fn.init=function(e,t,n){var r,i;if(!e)return this;if(n=n||j,"string"==typeof e){if(!(r="<"===e[0]&&">"===e[e.length-1]&&3<=e.length?[null,e,null]:q.exec(e))||!r[1]&&t)return!t||t.jquery?(t||n).find(e):this.constructor(t).find(e);if(r[1]){if(t=t instanceof S?t[0]:t,S.merge(this,S.parseHTML(r[1],t&&t.nodeType?t.ownerDocument||t:E,!0)),N.test(r[1])&&S.isPlainObject(t))for(r in t)m(this[r])?this[r](t[r]):this.attr(r,t[r]);return this}return(i=E.getElementById(r[2]))&&(this[0]=i,this.length=1),this}return e.nodeType?(this[0]=e,this.length=1,this):m(e)?void 0!==n.ready?n.ready(e):e(S):S.makeArray(e,this)}).prototype=S.fn,j=S(E);var L=/^(?:parents|prev(?:Until|All))/,H={children:!0,contents:!0,next:!0,prev:!0};function O(e,t){while((e=e[t])&&1!==e.nodeType);return e}S.fn.extend({has:function(e){var t=S(e,this),n=t.length;return this.filter(function(){for(var e=0;e<n;e++)if(S.contains(this,t[e]))return!0})},closest:function(e,t){var n,r=0,i=this.length,o=[],a="string"!=typeof e&&S(e);if(!k.test(e))for(;r<i;r++)for(n=this[r];n&&n!==t;n=n.parentNode)if(n.nodeType<11&&(a?-1<a.index(n):1===n.nodeType&&S.find.matchesSelector(n,e))){o.push(n);break}return this.pushStack(1<o.length?S.uniqueSort(o):o)},index:function(e){return e?"string"==typeof e?i.call(S(e),this[0]):i.call(this,e.jquery?e[0]:e):this[0]&&this[0].parentNode?this.first().prevAll().length:-1},add:function(e,t){return this.pushStack(S.uniqueSort(S.merge(this.get(),S(e,t))))},addBack:function(e){return this.add(null==e?this.prevObject:this.prevObject.filter(e))}}),S.each({parent:function(e){var t=e.parentNode;return t&&11!==t.nodeType?t:null},parents:function(e){return h(e,"parentNode")},parentsUntil:function(e,t,n){return h(e,"parentNode",n)},next:function(e){return O(e,"nextSibling")},prev:function(e){return O(e,"previousSibling")},nextAll:function(e){return h(e,"nextSibling")},prevAll:function(e){return h(e,"previousSibling")},nextUntil:function(e,t,n){return h(e,"nextSibling",n)},prevUntil:function(e,t,n){return h(e,"previousSibling",n)},siblings:function(e){return T((e.parentNode||{}).firstChild,e)},children:function(e){return T(e.firstChild)},contents:function(e){return null!=e.contentDocument&&r(e.contentDocument)?e.contentDocument:(A(e,"template")&&(e=e.content||e),S.merge([],e.childNodes))}},function(r,i){S.fn[r]=function(e,t){var n=S.map(this,i,e);return"Until"!==r.slice(-5)&&(t=e),t&&"string"==typeof t&&(n=S.filter(t,n)),1<this.length&&(H[r]||S.uniqueSort(n),L.test(r)&&n.reverse()),this.pushStack(n)}});var P=/[^\x20\t\r\n\f]+/g;function R(e){return e}function M(e){throw e}function I(e,t,n,r){var i;try{e&&m(i=e.promise)?i.call(e).done(t).fail(n):e&&m(i=e.then)?i.call(e,t,n):t.apply(void 0,[e].slice(r))}catch(e){n.apply(void 0,[e])}}S.Callbacks=function(r){var e,n;r="string"==typeof r?(e=r,n={},S.each(e.match(P)||[],function(e,t){n[t]=!0}),n):S.extend({},r);var i,t,o,a,s=[],u=[],l=-1,c=function(){for(a=a||r.once,o=i=!0;u.length;l=-1){t=u.shift();while(++l<s.length)!1===s[l].apply(t[0],t[1])&&r.stopOnFalse&&(l=s.length,t=!1)}r.memory||(t=!1),i=!1,a&&(s=t?[]:"")},f={add:function(){return s&&(t&&!i&&(l=s.length-1,u.push(t)),function n(e){S.each(e,function(e,t){m(t)?r.unique&&f.has(t)||s.push(t):t&&t.length&&"string"!==w(t)&&n(t)})}(arguments),t&&!i&&c()),this},remove:function(){return S.each(arguments,function(e,t){var n;while(-1<(n=S.inArray(t,s,n)))s.splice(n,1),n<=l&&l--}),this},has:function(e){return e?-1<S.inArray(e,s):0<s.length},empty:function(){return s&&(s=[]),this},disable:function(){return a=u=[],s=t="",this},disabled:function(){return!s},lock:function(){return a=u=[],t||i||(s=t=""),this},locked:function(){return!!a},fireWith:function(e,t){return a||(t=[e,(t=t||[]).slice?t.slice():t],u.push(t),i||c()),this},fire:function(){return f.fireWith(this,arguments),this},fired:function(){return!!o}};return f},S.extend({Deferred:function(e){var o=[["notify","progress",S.Callbacks("memory"),S.Callbacks("memory"),2],["resolve","done",S.Callbacks("once memory"),S.Callbacks("once memory"),0,"resolved"],["reject","fail",S.Callbacks("once memory"),S.Callbacks("once memory"),1,"rejected"]],i="pending",a={state:function(){return i},always:function(){return s.done(arguments).fail(arguments),this},"catch":function(e){return a.then(null,e)},pipe:function(){var i=arguments;return S.Deferred(function(r){S.each(o,function(e,t){var n=m(i[t[4]])&&i[t[4]];s[t[1]](function(){var e=n&&n.apply(this,arguments);e&&m(e.promise)?e.promise().progress(r.notify).done(r.resolve).fail(r.reject):r[t[0]+"With"](this,n?[e]:arguments)})}),i=null}).promise()},then:function(t,n,r){var u=0;function l(i,o,a,s){return function(){var n=this,r=arguments,e=function(){var e,t;if(!(i<u)){if((e=a.apply(n,r))===o.promise())throw new TypeError("Thenable self-resolution");t=e&&("object"==typeof e||"function"==typeof e)&&e.then,m(t)?s?t.call(e,l(u,o,R,s),l(u,o,M,s)):(u++,t.call(e,l(u,o,R,s),l(u,o,M,s),l(u,o,R,o.notifyWith))):(a!==R&&(n=void 0,r=[e]),(s||o.resolveWith)(n,r))}},t=s?e:function(){try{e()}catch(e){S.Deferred.exceptionHook&&S.Deferred.exceptionHook(e,t.stackTrace),u<=i+1&&(a!==M&&(n=void 0,r=[e]),o.rejectWith(n,r))}};i?t():(S.Deferred.getStackHook&&(t.stackTrace=S.Deferred.getStackHook()),C.setTimeout(t))}}return S.Deferred(function(e){o[0][3].add(l(0,e,m(r)?r:R,e.notifyWith)),o[1][3].add(l(0,e,m(t)?t:R)),o[2][3].add(l(0,e,m(n)?n:M))}).promise()},promise:function(e){return null!=e?S.extend(e,a):a}},s={};return S.each(o,function(e,t){var n=t[2],r=t[5];a[t[1]]=n.add,r&&n.add(function(){i=r},o[3-e][2].disable,o[3-e][3].disable,o[0][2].lock,o[0][3].lock),n.add(t[3].fire),s[t[0]]=function(){return s[t[0]+"With"](this===s?void 0:this,arguments),this},s[t[0]+"With"]=n.fireWith}),a.promise(s),e&&e.call(s,s),s},when:function(e){var n=arguments.length,t=n,r=Array(t),i=s.call(arguments),o=S.Deferred(),a=function(t){return function(e){r[t]=this,i[t]=1<arguments.length?s.call(arguments):e,--n||o.resolveWith(r,i)}};if(n<=1&&(I(e,o.done(a(t)).resolve,o.reject,!n),"pending"===o.state()||m(i[t]&&i[t].then)))return o.then();while(t--)I(i[t],a(t),o.reject);return o.promise()}});var W=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;S.Deferred.exceptionHook=function(e,t){C.console&&C.console.warn&&e&&W.test(e.name)&&C.console.warn("jQuery.Deferred exception: "+e.message,e.stack,t)},S.readyException=function(e){C.setTimeout(function(){throw e})};var F=S.Deferred();function B(){E.removeEventListener("DOMContentLoaded",B),C.removeEventListener("load",B),S.ready()}S.fn.ready=function(e){return F.then(e)["catch"](function(e){S.readyException(e)}),this},S.extend({isReady:!1,readyWait:1,ready:function(e){(!0===e?--S.readyWait:S.isReady)||(S.isReady=!0)!==e&&0<--S.readyWait||F.resolveWith(E,[S])}}),S.ready.then=F.then,"complete"===E.readyState||"loading"!==E.readyState&&!E.documentElement.doScroll?C.setTimeout(S.ready):(E.addEventListener("DOMContentLoaded",B),C.addEventListener("load",B));var $=function(e,t,n,r,i,o,a){var s=0,u=e.length,l=null==n;if("object"===w(n))for(s in i=!0,n)$(e,t,s,n[s],!0,o,a);else if(void 0!==r&&(i=!0,m(r)||(a=!0),l&&(a?(t.call(e,r),t=null):(l=t,t=function(e,t,n){return l.call(S(e),n)})),t))for(;s<u;s++)t(e[s],n,a?r:r.call(e[s],s,t(e[s],n)));return i?e:l?t.call(e):u?t(e[0],n):o},_=/^-ms-/,z=/-([a-z])/g;function U(e,t){return t.toUpperCase()}function X(e){return e.replace(_,"ms-").replace(z,U)}var V=function(e){return 1===e.nodeType||9===e.nodeType||!+e.nodeType};function G(){this.expando=S.expando+G.uid++}G.uid=1,G.prototype={cache:function(e){var t=e[this.expando];return t||(t={},V(e)&&(e.nodeType?e[this.expando]=t:Object.defineProperty(e,this.expando,{value:t,configurable:!0}))),t},set:function(e,t,n){var r,i=this.cache(e);if("string"==typeof t)i[X(t)]=n;else for(r in t)i[X(r)]=t[r];return i},get:function(e,t){return void 0===t?this.cache(e):e[this.expando]&&e[this.expando][X(t)]},access:function(e,t,n){return void 0===t||t&&"string"==typeof t&&void 0===n?this.get(e,t):(this.set(e,t,n),void 0!==n?n:t)},remove:function(e,t){var n,r=e[this.expando];if(void 0!==r){if(void 0!==t){n=(t=Array.isArray(t)?t.map(X):(t=X(t))in r?[t]:t.match(P)||[]).length;while(n--)delete r[t[n]]}(void 0===t||S.isEmptyObject(r))&&(e.nodeType?e[this.expando]=void 0:delete e[this.expando])}},hasData:function(e){var t=e[this.expando];return void 0!==t&&!S.isEmptyObject(t)}};var Y=new G,Q=new G,J=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,K=/[A-Z]/g;function Z(e,t,n){var r,i;if(void 0===n&&1===e.nodeType)if(r="data-"+t.replace(K,"-$&").toLowerCase(),"string"==typeof(n=e.getAttribute(r))){try{n="true"===(i=n)||"false"!==i&&("null"===i?null:i===+i+""?+i:J.test(i)?JSON.parse(i):i)}catch(e){}Q.set(e,t,n)}else n=void 0;return n}S.extend({hasData:function(e){return Q.hasData(e)||Y.hasData(e)},data:function(e,t,n){return Q.access(e,t,n)},removeData:function(e,t){Q.remove(e,t)},_data:function(e,t,n){return Y.access(e,t,n)},_removeData:function(e,t){Y.remove(e,t)}}),S.fn.extend({data:function(n,e){var t,r,i,o=this[0],a=o&&o.attributes;if(void 0===n){if(this.length&&(i=Q.get(o),1===o.nodeType&&!Y.get(o,"hasDataAttrs"))){t=a.length;while(t--)a[t]&&0===(r=a[t].name).indexOf("data-")&&(r=X(r.slice(5)),Z(o,r,i[r]));Y.set(o,"hasDataAttrs",!0)}return i}return"object"==typeof n?this.each(function(){Q.set(this,n)}):$(this,function(e){var t;if(o&&void 0===e)return void 0!==(t=Q.get(o,n))?t:void 0!==(t=Z(o,n))?t:void 0;this.each(function(){Q.set(this,n,e)})},null,e,1<arguments.length,null,!0)},removeData:function(e){return this.each(function(){Q.remove(this,e)})}}),S.extend({queue:function(e,t,n){var r;if(e)return t=(t||"fx")+"queue",r=Y.get(e,t),n&&(!r||Array.isArray(n)?r=Y.access(e,t,S.makeArray(n)):r.push(n)),r||[]},dequeue:function(e,t){t=t||"fx";var n=S.queue(e,t),r=n.length,i=n.shift(),o=S._queueHooks(e,t);"inprogress"===i&&(i=n.shift(),r--),i&&("fx"===t&&n.unshift("inprogress"),delete o.stop,i.call(e,function(){S.dequeue(e,t)},o)),!r&&o&&o.empty.fire()},_queueHooks:function(e,t){var n=t+"queueHooks";return Y.get(e,n)||Y.access(e,n,{empty:S.Callbacks("once memory").add(function(){Y.remove(e,[t+"queue",n])})})}}),S.fn.extend({queue:function(t,n){var e=2;return"string"!=typeof t&&(n=t,t="fx",e--),arguments.length<e?S.queue(this[0],t):void 0===n?this:this.each(function(){var e=S.queue(this,t,n);S._queueHooks(this,t),"fx"===t&&"inprogress"!==e[0]&&S.dequeue(this,t)})},dequeue:function(e){return this.each(function(){S.dequeue(this,e)})},clearQueue:function(e){return this.queue(e||"fx",[])},promise:function(e,t){var n,r=1,i=S.Deferred(),o=this,a=this.length,s=function(){--r||i.resolveWith(o,[o])};"string"!=typeof e&&(t=e,e=void 0),e=e||"fx";while(a--)(n=Y.get(o[a],e+"queueHooks"))&&n.empty&&(r++,n.empty.add(s));return s(),i.promise(t)}});var ee=/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source,te=new RegExp("^(?:([+-])=|)("+ee+")([a-z%]*)$","i"),ne=["Top","Right","Bottom","Left"],re=E.documentElement,ie=function(e){return S.contains(e.ownerDocument,e)},oe={composed:!0};re.getRootNode&&(ie=function(e){return S.contains(e.ownerDocument,e)||e.getRootNode(oe)===e.ownerDocument});var ae=function(e,t){return"none"===(e=t||e).style.display||""===e.style.display&&ie(e)&&"none"===S.css(e,"display")};function se(e,t,n,r){var i,o,a=20,s=r?function(){return r.cur()}:function(){return S.css(e,t,"")},u=s(),l=n&&n[3]||(S.cssNumber[t]?"":"px"),c=e.nodeType&&(S.cssNumber[t]||"px"!==l&&+u)&&te.exec(S.css(e,t));if(c&&c[3]!==l){u/=2,l=l||c[3],c=+u||1;while(a--)S.style(e,t,c+l),(1-o)*(1-(o=s()/u||.5))<=0&&(a=0),c/=o;c*=2,S.style(e,t,c+l),n=n||[]}return n&&(c=+c||+u||0,i=n[1]?c+(n[1]+1)*n[2]:+n[2],r&&(r.unit=l,r.start=c,r.end=i)),i}var ue={};function le(e,t){for(var n,r,i,o,a,s,u,l=[],c=0,f=e.length;c<f;c++)(r=e[c]).style&&(n=r.style.display,t?("none"===n&&(l[c]=Y.get(r,"display")||null,l[c]||(r.style.display="")),""===r.style.display&&ae(r)&&(l[c]=(u=a=o=void 0,a=(i=r).ownerDocument,s=i.nodeName,(u=ue[s])||(o=a.body.appendChild(a.createElement(s)),u=S.css(o,"display"),o.parentNode.removeChild(o),"none"===u&&(u="block"),ue[s]=u)))):"none"!==n&&(l[c]="none",Y.set(r,"display",n)));for(c=0;c<f;c++)null!=l[c]&&(e[c].style.display=l[c]);return e}S.fn.extend({show:function(){return le(this,!0)},hide:function(){return le(this)},toggle:function(e){return"boolean"==typeof e?e?this.show():this.hide():this.each(function(){ae(this)?S(this).show():S(this).hide()})}});var ce,fe,pe=/^(?:checkbox|radio)$/i,de=/<([a-z][^\/\0>\x20\t\r\n\f]*)/i,he=/^$|^module$|\/(?:java|ecma)script/i;ce=E.createDocumentFragment().appendChild(E.createElement("div")),(fe=E.createElement("input")).setAttribute("type","radio"),fe.setAttribute("checked","checked"),fe.setAttribute("name","t"),ce.appendChild(fe),y.checkClone=ce.cloneNode(!0).cloneNode(!0).lastChild.checked,ce.innerHTML="<textarea>x</textarea>",y.noCloneChecked=!!ce.cloneNode(!0).lastChild.defaultValue,ce.innerHTML="<option></option>",y.option=!!ce.lastChild;var ge={thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};function ve(e,t){var n;return n="undefined"!=typeof e.getElementsByTagName?e.getElementsByTagName(t||"*"):"undefined"!=typeof e.querySelectorAll?e.querySelectorAll(t||"*"):[],void 0===t||t&&A(e,t)?S.merge([e],n):n}function ye(e,t){for(var n=0,r=e.length;n<r;n++)Y.set(e[n],"globalEval",!t||Y.get(t[n],"globalEval"))}ge.tbody=ge.tfoot=ge.colgroup=ge.caption=ge.thead,ge.th=ge.td,y.option||(ge.optgroup=ge.option=[1,"<select multiple='multiple'>","</select>"]);var me=/<|&#?\w+;/;function xe(e,t,n,r,i){for(var o,a,s,u,l,c,f=t.createDocumentFragment(),p=[],d=0,h=e.length;d<h;d++)if((o=e[d])||0===o)if("object"===w(o))S.merge(p,o.nodeType?[o]:o);else if(me.test(o)){a=a||f.appendChild(t.createElement("div")),s=(de.exec(o)||["",""])[1].toLowerCase(),u=ge[s]||ge._default,a.innerHTML=u[1]+S.htmlPrefilter(o)+u[2],c=u[0];while(c--)a=a.lastChild;S.merge(p,a.childNodes),(a=f.firstChild).textContent=""}else p.push(t.createTextNode(o));f.textContent="",d=0;while(o=p[d++])if(r&&-1<S.inArray(o,r))i&&i.push(o);else if(l=ie(o),a=ve(f.appendChild(o),"script"),l&&ye(a),n){c=0;while(o=a[c++])he.test(o.type||"")&&n.push(o)}return f}var be=/^key/,we=/^(?:mouse|pointer|contextmenu|drag|drop)|click/,Te=/^([^.]*)(?:\.(.+)|)/;function Ce(){return!0}function Ee(){return!1}function Se(e,t){return e===function(){try{return E.activeElement}catch(e){}}()==("focus"===t)}function ke(e,t,n,r,i,o){var a,s;if("object"==typeof t){for(s in"string"!=typeof n&&(r=r||n,n=void 0),t)ke(e,s,n,r,t[s],o);return e}if(null==r&&null==i?(i=n,r=n=void 0):null==i&&("string"==typeof n?(i=r,r=void 0):(i=r,r=n,n=void 0)),!1===i)i=Ee;else if(!i)return e;return 1===o&&(a=i,(i=function(e){return S().off(e),a.apply(this,arguments)}).guid=a.guid||(a.guid=S.guid++)),e.each(function(){S.event.add(this,t,i,r,n)})}function Ae(e,i,o){o?(Y.set(e,i,!1),S.event.add(e,i,{namespace:!1,handler:function(e){var t,n,r=Y.get(this,i);if(1&e.isTrigger&&this[i]){if(r.length)(S.event.special[i]||{}).delegateType&&e.stopPropagation();else if(r=s.call(arguments),Y.set(this,i,r),t=o(this,i),this[i](),r!==(n=Y.get(this,i))||t?Y.set(this,i,!1):n={},r!==n)return e.stopImmediatePropagation(),e.preventDefault(),n.value}else r.length&&(Y.set(this,i,{value:S.event.trigger(S.extend(r[0],S.Event.prototype),r.slice(1),this)}),e.stopImmediatePropagation())}})):void 0===Y.get(e,i)&&S.event.add(e,i,Ce)}S.event={global:{},add:function(t,e,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Y.get(t);if(V(t)){n.handler&&(n=(o=n).handler,i=o.selector),i&&S.find.matchesSelector(re,i),n.guid||(n.guid=S.guid++),(u=v.events)||(u=v.events=Object.create(null)),(a=v.handle)||(a=v.handle=function(e){return"undefined"!=typeof S&&S.event.triggered!==e.type?S.event.dispatch.apply(t,arguments):void 0}),l=(e=(e||"").match(P)||[""]).length;while(l--)d=g=(s=Te.exec(e[l])||[])[1],h=(s[2]||"").split(".").sort(),d&&(f=S.event.special[d]||{},d=(i?f.delegateType:f.bindType)||d,f=S.event.special[d]||{},c=S.extend({type:d,origType:g,data:r,handler:n,guid:n.guid,selector:i,needsContext:i&&S.expr.match.needsContext.test(i),namespace:h.join(".")},o),(p=u[d])||((p=u[d]=[]).delegateCount=0,f.setup&&!1!==f.setup.call(t,r,h,a)||t.addEventListener&&t.addEventListener(d,a)),f.add&&(f.add.call(t,c),c.handler.guid||(c.handler.guid=n.guid)),i?p.splice(p.delegateCount++,0,c):p.push(c),S.event.global[d]=!0)}},remove:function(e,t,n,r,i){var o,a,s,u,l,c,f,p,d,h,g,v=Y.hasData(e)&&Y.get(e);if(v&&(u=v.events)){l=(t=(t||"").match(P)||[""]).length;while(l--)if(d=g=(s=Te.exec(t[l])||[])[1],h=(s[2]||"").split(".").sort(),d){f=S.event.special[d]||{},p=u[d=(r?f.delegateType:f.bindType)||d]||[],s=s[2]&&new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"),a=o=p.length;while(o--)c=p[o],!i&&g!==c.origType||n&&n.guid!==c.guid||s&&!s.test(c.namespace)||r&&r!==c.selector&&("**"!==r||!c.selector)||(p.splice(o,1),c.selector&&p.delegateCount--,f.remove&&f.remove.call(e,c));a&&!p.length&&(f.teardown&&!1!==f.teardown.call(e,h,v.handle)||S.removeEvent(e,d,v.handle),delete u[d])}else for(d in u)S.event.remove(e,d+t[l],n,r,!0);S.isEmptyObject(u)&&Y.remove(e,"handle events")}},dispatch:function(e){var t,n,r,i,o,a,s=new Array(arguments.length),u=S.event.fix(e),l=(Y.get(this,"events")||Object.create(null))[u.type]||[],c=S.event.special[u.type]||{};for(s[0]=u,t=1;t<arguments.length;t++)s[t]=arguments[t];if(u.delegateTarget=this,!c.preDispatch||!1!==c.preDispatch.call(this,u)){a=S.event.handlers.call(this,u,l),t=0;while((i=a[t++])&&!u.isPropagationStopped()){u.currentTarget=i.elem,n=0;while((o=i.handlers[n++])&&!u.isImmediatePropagationStopped())u.rnamespace&&!1!==o.namespace&&!u.rnamespace.test(o.namespace)||(u.handleObj=o,u.data=o.data,void 0!==(r=((S.event.special[o.origType]||{}).handle||o.handler).apply(i.elem,s))&&!1===(u.result=r)&&(u.preventDefault(),u.stopPropagation()))}return c.postDispatch&&c.postDispatch.call(this,u),u.result}},handlers:function(e,t){var n,r,i,o,a,s=[],u=t.delegateCount,l=e.target;if(u&&l.nodeType&&!("click"===e.type&&1<=e.button))for(;l!==this;l=l.parentNode||this)if(1===l.nodeType&&("click"!==e.type||!0!==l.disabled)){for(o=[],a={},n=0;n<u;n++)void 0===a[i=(r=t[n]).selector+" "]&&(a[i]=r.needsContext?-1<S(i,this).index(l):S.find(i,this,null,[l]).length),a[i]&&o.push(r);o.length&&s.push({elem:l,handlers:o})}return l=this,u<t.length&&s.push({elem:l,handlers:t.slice(u)}),s},addProp:function(t,e){Object.defineProperty(S.Event.prototype,t,{enumerable:!0,configurable:!0,get:m(e)?function(){if(this.originalEvent)return e(this.originalEvent)}:function(){if(this.originalEvent)return this.originalEvent[t]},set:function(e){Object.defineProperty(this,t,{enumerable:!0,configurable:!0,writable:!0,value:e})}})},fix:function(e){return e[S.expando]?e:new S.Event(e)},special:{load:{noBubble:!0},click:{setup:function(e){var t=this||e;return pe.test(t.type)&&t.click&&A(t,"input")&&Ae(t,"click",Ce),!1},trigger:function(e){var t=this||e;return pe.test(t.type)&&t.click&&A(t,"input")&&Ae(t,"click"),!0},_default:function(e){var t=e.target;return pe.test(t.type)&&t.click&&A(t,"input")&&Y.get(t,"click")||A(t,"a")}},beforeunload:{postDispatch:function(e){void 0!==e.result&&e.originalEvent&&(e.originalEvent.returnValue=e.result)}}}},S.removeEvent=function(e,t,n){e.removeEventListener&&e.removeEventListener(t,n)},S.Event=function(e,t){if(!(this instanceof S.Event))return new S.Event(e,t);e&&e.type?(this.originalEvent=e,this.type=e.type,this.isDefaultPrevented=e.defaultPrevented||void 0===e.defaultPrevented&&!1===e.returnValue?Ce:Ee,this.target=e.target&&3===e.target.nodeType?e.target.parentNode:e.target,this.currentTarget=e.currentTarget,this.relatedTarget=e.relatedTarget):this.type=e,t&&S.extend(this,t),this.timeStamp=e&&e.timeStamp||Date.now(),this[S.expando]=!0},S.Event.prototype={constructor:S.Event,isDefaultPrevented:Ee,isPropagationStopped:Ee,isImmediatePropagationStopped:Ee,isSimulated:!1,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=Ce,e&&!this.isSimulated&&e.preventDefault()},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=Ce,e&&!this.isSimulated&&e.stopPropagation()},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=Ce,e&&!this.isSimulated&&e.stopImmediatePropagation(),this.stopPropagation()}},S.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,"char":!0,code:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:function(e){var t=e.button;return null==e.which&&be.test(e.type)?null!=e.charCode?e.charCode:e.keyCode:!e.which&&void 0!==t&&we.test(e.type)?1&t?1:2&t?3:4&t?2:0:e.which}},S.event.addProp),S.each({focus:"focusin",blur:"focusout"},function(e,t){S.event.special[e]={setup:function(){return Ae(this,e,Se),!1},trigger:function(){return Ae(this,e),!0},delegateType:t}}),S.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(e,i){S.event.special[e]={delegateType:i,bindType:i,handle:function(e){var t,n=e.relatedTarget,r=e.handleObj;return n&&(n===this||S.contains(this,n))||(e.type=r.origType,t=r.handler.apply(this,arguments),e.type=i),t}}}),S.fn.extend({on:function(e,t,n,r){return ke(this,e,t,n,r)},one:function(e,t,n,r){return ke(this,e,t,n,r,1)},off:function(e,t,n){var r,i;if(e&&e.preventDefault&&e.handleObj)return r=e.handleObj,S(e.delegateTarget).off(r.namespace?r.origType+"."+r.namespace:r.origType,r.selector,r.handler),this;if("object"==typeof e){for(i in e)this.off(i,t,e[i]);return this}return!1!==t&&"function"!=typeof t||(n=t,t=void 0),!1===n&&(n=Ee),this.each(function(){S.event.remove(this,e,n,t)})}});var Ne=/<script|<style|<link/i,De=/checked\s*(?:[^=]|=\s*.checked.)/i,je=/^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;function qe(e,t){return A(e,"table")&&A(11!==t.nodeType?t:t.firstChild,"tr")&&S(e).children("tbody")[0]||e}function Le(e){return e.type=(null!==e.getAttribute("type"))+"/"+e.type,e}function He(e){return"true/"===(e.type||"").slice(0,5)?e.type=e.type.slice(5):e.removeAttribute("type"),e}function Oe(e,t){var n,r,i,o,a,s;if(1===t.nodeType){if(Y.hasData(e)&&(s=Y.get(e).events))for(i in Y.remove(t,"handle events"),s)for(n=0,r=s[i].length;n<r;n++)S.event.add(t,i,s[i][n]);Q.hasData(e)&&(o=Q.access(e),a=S.extend({},o),Q.set(t,a))}}function Pe(n,r,i,o){r=g(r);var e,t,a,s,u,l,c=0,f=n.length,p=f-1,d=r[0],h=m(d);if(h||1<f&&"string"==typeof d&&!y.checkClone&&De.test(d))return n.each(function(e){var t=n.eq(e);h&&(r[0]=d.call(this,e,t.html())),Pe(t,r,i,o)});if(f&&(t=(e=xe(r,n[0].ownerDocument,!1,n,o)).firstChild,1===e.childNodes.length&&(e=t),t||o)){for(s=(a=S.map(ve(e,"script"),Le)).length;c<f;c++)u=e,c!==p&&(u=S.clone(u,!0,!0),s&&S.merge(a,ve(u,"script"))),i.call(n[c],u,c);if(s)for(l=a[a.length-1].ownerDocument,S.map(a,He),c=0;c<s;c++)u=a[c],he.test(u.type||"")&&!Y.access(u,"globalEval")&&S.contains(l,u)&&(u.src&&"module"!==(u.type||"").toLowerCase()?S._evalUrl&&!u.noModule&&S._evalUrl(u.src,{nonce:u.nonce||u.getAttribute("nonce")},l):b(u.textContent.replace(je,""),u,l))}return n}function Re(e,t,n){for(var r,i=t?S.filter(t,e):e,o=0;null!=(r=i[o]);o++)n||1!==r.nodeType||S.cleanData(ve(r)),r.parentNode&&(n&&ie(r)&&ye(ve(r,"script")),r.parentNode.removeChild(r));return e}S.extend({htmlPrefilter:function(e){return e},clone:function(e,t,n){var r,i,o,a,s,u,l,c=e.cloneNode(!0),f=ie(e);if(!(y.noCloneChecked||1!==e.nodeType&&11!==e.nodeType||S.isXMLDoc(e)))for(a=ve(c),r=0,i=(o=ve(e)).length;r<i;r++)s=o[r],u=a[r],void 0,"input"===(l=u.nodeName.toLowerCase())&&pe.test(s.type)?u.checked=s.checked:"input"!==l&&"textarea"!==l||(u.defaultValue=s.defaultValue);if(t)if(n)for(o=o||ve(e),a=a||ve(c),r=0,i=o.length;r<i;r++)Oe(o[r],a[r]);else Oe(e,c);return 0<(a=ve(c,"script")).length&&ye(a,!f&&ve(e,"script")),c},cleanData:function(e){for(var t,n,r,i=S.event.special,o=0;void 0!==(n=e[o]);o++)if(V(n)){if(t=n[Y.expando]){if(t.events)for(r in t.events)i[r]?S.event.remove(n,r):S.removeEvent(n,r,t.handle);n[Y.expando]=void 0}n[Q.expando]&&(n[Q.expando]=void 0)}}}),S.fn.extend({detach:function(e){return Re(this,e,!0)},remove:function(e){return Re(this,e)},text:function(e){return $(this,function(e){return void 0===e?S.text(this):this.empty().each(function(){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||(this.textContent=e)})},null,e,arguments.length)},append:function(){return Pe(this,arguments,function(e){1!==this.nodeType&&11!==this.nodeType&&9!==this.nodeType||qe(this,e).appendChild(e)})},prepend:function(){return Pe(this,arguments,function(e){if(1===this.nodeType||11===this.nodeType||9===this.nodeType){var t=qe(this,e);t.insertBefore(e,t.firstChild)}})},before:function(){return Pe(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this)})},after:function(){return Pe(this,arguments,function(e){this.parentNode&&this.parentNode.insertBefore(e,this.nextSibling)})},empty:function(){for(var e,t=0;null!=(e=this[t]);t++)1===e.nodeType&&(S.cleanData(ve(e,!1)),e.textContent="");return this},clone:function(e,t){return e=null!=e&&e,t=null==t?e:t,this.map(function(){return S.clone(this,e,t)})},html:function(e){return $(this,function(e){var t=this[0]||{},n=0,r=this.length;if(void 0===e&&1===t.nodeType)return t.innerHTML;if("string"==typeof e&&!Ne.test(e)&&!ge[(de.exec(e)||["",""])[1].toLowerCase()]){e=S.htmlPrefilter(e);try{for(;n<r;n++)1===(t=this[n]||{}).nodeType&&(S.cleanData(ve(t,!1)),t.innerHTML=e);t=0}catch(e){}}t&&this.empty().append(e)},null,e,arguments.length)},replaceWith:function(){var n=[];return Pe(this,arguments,function(e){var t=this.parentNode;S.inArray(this,n)<0&&(S.cleanData(ve(this)),t&&t.replaceChild(e,this))},n)}}),S.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(e,a){S.fn[e]=function(e){for(var t,n=[],r=S(e),i=r.length-1,o=0;o<=i;o++)t=o===i?this:this.clone(!0),S(r[o])[a](t),u.apply(n,t.get());return this.pushStack(n)}});var Me=new RegExp("^("+ee+")(?!px)[a-z%]+$","i"),Ie=function(e){var t=e.ownerDocument.defaultView;return t&&t.opener||(t=C),t.getComputedStyle(e)},We=function(e,t,n){var r,i,o={};for(i in t)o[i]=e.style[i],e.style[i]=t[i];for(i in r=n.call(e),t)e.style[i]=o[i];return r},Fe=new RegExp(ne.join("|"),"i");function Be(e,t,n){var r,i,o,a,s=e.style;return(n=n||Ie(e))&&(""!==(a=n.getPropertyValue(t)||n[t])||ie(e)||(a=S.style(e,t)),!y.pixelBoxStyles()&&Me.test(a)&&Fe.test(t)&&(r=s.width,i=s.minWidth,o=s.maxWidth,s.minWidth=s.maxWidth=s.width=a,a=n.width,s.width=r,s.minWidth=i,s.maxWidth=o)),void 0!==a?a+"":a}function $e(e,t){return{get:function(){if(!e())return(this.get=t).apply(this,arguments);delete this.get}}}!function(){function e(){if(l){u.style.cssText="position:absolute;left:-11111px;width:60px;margin-top:1px;padding:0;border:0",l.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;margin:auto;border:1px;padding:1px;width:60%;top:1%",re.appendChild(u).appendChild(l);var e=C.getComputedStyle(l);n="1%"!==e.top,s=12===t(e.marginLeft),l.style.right="60%",o=36===t(e.right),r=36===t(e.width),l.style.position="absolute",i=12===t(l.offsetWidth/3),re.removeChild(u),l=null}}function t(e){return Math.round(parseFloat(e))}var n,r,i,o,a,s,u=E.createElement("div"),l=E.createElement("div");l.style&&(l.style.backgroundClip="content-box",l.cloneNode(!0).style.backgroundClip="",y.clearCloneStyle="content-box"===l.style.backgroundClip,S.extend(y,{boxSizingReliable:function(){return e(),r},pixelBoxStyles:function(){return e(),o},pixelPosition:function(){return e(),n},reliableMarginLeft:function(){return e(),s},scrollboxSize:function(){return e(),i},reliableTrDimensions:function(){var e,t,n,r;return null==a&&(e=E.createElement("table"),t=E.createElement("tr"),n=E.createElement("div"),e.style.cssText="position:absolute;left:-11111px",t.style.height="1px",n.style.height="9px",re.appendChild(e).appendChild(t).appendChild(n),r=C.getComputedStyle(t),a=3<parseInt(r.height),re.removeChild(e)),a}}))}();var _e=["Webkit","Moz","ms"],ze=E.createElement("div").style,Ue={};function Xe(e){var t=S.cssProps[e]||Ue[e];return t||(e in ze?e:Ue[e]=function(e){var t=e[0].toUpperCase()+e.slice(1),n=_e.length;while(n--)if((e=_e[n]+t)in ze)return e}(e)||e)}var Ve=/^(none|table(?!-c[ea]).+)/,Ge=/^--/,Ye={position:"absolute",visibility:"hidden",display:"block"},Qe={letterSpacing:"0",fontWeight:"400"};function Je(e,t,n){var r=te.exec(t);return r?Math.max(0,r[2]-(n||0))+(r[3]||"px"):t}function Ke(e,t,n,r,i,o){var a="width"===t?1:0,s=0,u=0;if(n===(r?"border":"content"))return 0;for(;a<4;a+=2)"margin"===n&&(u+=S.css(e,n+ne[a],!0,i)),r?("content"===n&&(u-=S.css(e,"padding"+ne[a],!0,i)),"margin"!==n&&(u-=S.css(e,"border"+ne[a]+"Width",!0,i))):(u+=S.css(e,"padding"+ne[a],!0,i),"padding"!==n?u+=S.css(e,"border"+ne[a]+"Width",!0,i):s+=S.css(e,"border"+ne[a]+"Width",!0,i));return!r&&0<=o&&(u+=Math.max(0,Math.ceil(e["offset"+t[0].toUpperCase()+t.slice(1)]-o-u-s-.5))||0),u}function Ze(e,t,n){var r=Ie(e),i=(!y.boxSizingReliable()||n)&&"border-box"===S.css(e,"boxSizing",!1,r),o=i,a=Be(e,t,r),s="offset"+t[0].toUpperCase()+t.slice(1);if(Me.test(a)){if(!n)return a;a="auto"}return(!y.boxSizingReliable()&&i||!y.reliableTrDimensions()&&A(e,"tr")||"auto"===a||!parseFloat(a)&&"inline"===S.css(e,"display",!1,r))&&e.getClientRects().length&&(i="border-box"===S.css(e,"boxSizing",!1,r),(o=s in e)&&(a=e[s])),(a=parseFloat(a)||0)+Ke(e,t,n||(i?"border":"content"),o,r,a)+"px"}function et(e,t,n,r,i){return new et.prototype.init(e,t,n,r,i)}S.extend({cssHooks:{opacity:{get:function(e,t){if(t){var n=Be(e,"opacity");return""===n?"1":n}}}},cssNumber:{animationIterationCount:!0,columnCount:!0,fillOpacity:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,gridArea:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnStart:!0,gridRow:!0,gridRowEnd:!0,gridRowStart:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,widows:!0,zIndex:!0,zoom:!0},cssProps:{},style:function(e,t,n,r){if(e&&3!==e.nodeType&&8!==e.nodeType&&e.style){var i,o,a,s=X(t),u=Ge.test(t),l=e.style;if(u||(t=Xe(s)),a=S.cssHooks[t]||S.cssHooks[s],void 0===n)return a&&"get"in a&&void 0!==(i=a.get(e,!1,r))?i:l[t];"string"===(o=typeof n)&&(i=te.exec(n))&&i[1]&&(n=se(e,t,i),o="number"),null!=n&&n==n&&("number"!==o||u||(n+=i&&i[3]||(S.cssNumber[s]?"":"px")),y.clearCloneStyle||""!==n||0!==t.indexOf("background")||(l[t]="inherit"),a&&"set"in a&&void 0===(n=a.set(e,n,r))||(u?l.setProperty(t,n):l[t]=n))}},css:function(e,t,n,r){var i,o,a,s=X(t);return Ge.test(t)||(t=Xe(s)),(a=S.cssHooks[t]||S.cssHooks[s])&&"get"in a&&(i=a.get(e,!0,n)),void 0===i&&(i=Be(e,t,r)),"normal"===i&&t in Qe&&(i=Qe[t]),""===n||n?(o=parseFloat(i),!0===n||isFinite(o)?o||0:i):i}}),S.each(["height","width"],function(e,u){S.cssHooks[u]={get:function(e,t,n){if(t)return!Ve.test(S.css(e,"display"))||e.getClientRects().length&&e.getBoundingClientRect().width?Ze(e,u,n):We(e,Ye,function(){return Ze(e,u,n)})},set:function(e,t,n){var r,i=Ie(e),o=!y.scrollboxSize()&&"absolute"===i.position,a=(o||n)&&"border-box"===S.css(e,"boxSizing",!1,i),s=n?Ke(e,u,n,a,i):0;return a&&o&&(s-=Math.ceil(e["offset"+u[0].toUpperCase()+u.slice(1)]-parseFloat(i[u])-Ke(e,u,"border",!1,i)-.5)),s&&(r=te.exec(t))&&"px"!==(r[3]||"px")&&(e.style[u]=t,t=S.css(e,u)),Je(0,t,s)}}}),S.cssHooks.marginLeft=$e(y.reliableMarginLeft,function(e,t){if(t)return(parseFloat(Be(e,"marginLeft"))||e.getBoundingClientRect().left-We(e,{marginLeft:0},function(){return e.getBoundingClientRect().left}))+"px"}),S.each({margin:"",padding:"",border:"Width"},function(i,o){S.cssHooks[i+o]={expand:function(e){for(var t=0,n={},r="string"==typeof e?e.split(" "):[e];t<4;t++)n[i+ne[t]+o]=r[t]||r[t-2]||r[0];return n}},"margin"!==i&&(S.cssHooks[i+o].set=Je)}),S.fn.extend({css:function(e,t){return $(this,function(e,t,n){var r,i,o={},a=0;if(Array.isArray(t)){for(r=Ie(e),i=t.length;a<i;a++)o[t[a]]=S.css(e,t[a],!1,r);return o}return void 0!==n?S.style(e,t,n):S.css(e,t)},e,t,1<arguments.length)}}),((S.Tween=et).prototype={constructor:et,init:function(e,t,n,r,i,o){this.elem=e,this.prop=n,this.easing=i||S.easing._default,this.options=t,this.start=this.now=this.cur(),this.end=r,this.unit=o||(S.cssNumber[n]?"":"px")},cur:function(){var e=et.propHooks[this.prop];return e&&e.get?e.get(this):et.propHooks._default.get(this)},run:function(e){var t,n=et.propHooks[this.prop];return this.options.duration?this.pos=t=S.easing[this.easing](e,this.options.duration*e,0,1,this.options.duration):this.pos=t=e,this.now=(this.end-this.start)*t+this.start,this.options.step&&this.options.step.call(this.elem,this.now,this),n&&n.set?n.set(this):et.propHooks._default.set(this),this}}).init.prototype=et.prototype,(et.propHooks={_default:{get:function(e){var t;return 1!==e.elem.nodeType||null!=e.elem[e.prop]&&null==e.elem.style[e.prop]?e.elem[e.prop]:(t=S.css(e.elem,e.prop,""))&&"auto"!==t?t:0},set:function(e){S.fx.step[e.prop]?S.fx.step[e.prop](e):1!==e.elem.nodeType||!S.cssHooks[e.prop]&&null==e.elem.style[Xe(e.prop)]?e.elem[e.prop]=e.now:S.style(e.elem,e.prop,e.now+e.unit)}}}).scrollTop=et.propHooks.scrollLeft={set:function(e){e.elem.nodeType&&e.elem.parentNode&&(e.elem[e.prop]=e.now)}},S.easing={linear:function(e){return e},swing:function(e){return.5-Math.cos(e*Math.PI)/2},_default:"swing"},S.fx=et.prototype.init,S.fx.step={};var tt,nt,rt,it,ot=/^(?:toggle|show|hide)$/,at=/queueHooks$/;function st(){nt&&(!1===E.hidden&&C.requestAnimationFrame?C.requestAnimationFrame(st):C.setTimeout(st,S.fx.interval),S.fx.tick())}function ut(){return C.setTimeout(function(){tt=void 0}),tt=Date.now()}function lt(e,t){var n,r=0,i={height:e};for(t=t?1:0;r<4;r+=2-t)i["margin"+(n=ne[r])]=i["padding"+n]=e;return t&&(i.opacity=i.width=e),i}function ct(e,t,n){for(var r,i=(ft.tweeners[t]||[]).concat(ft.tweeners["*"]),o=0,a=i.length;o<a;o++)if(r=i[o].call(n,t,e))return r}function ft(o,e,t){var n,a,r=0,i=ft.prefilters.length,s=S.Deferred().always(function(){delete u.elem}),u=function(){if(a)return!1;for(var e=tt||ut(),t=Math.max(0,l.startTime+l.duration-e),n=1-(t/l.duration||0),r=0,i=l.tweens.length;r<i;r++)l.tweens[r].run(n);return s.notifyWith(o,[l,n,t]),n<1&&i?t:(i||s.notifyWith(o,[l,1,0]),s.resolveWith(o,[l]),!1)},l=s.promise({elem:o,props:S.extend({},e),opts:S.extend(!0,{specialEasing:{},easing:S.easing._default},t),originalProperties:e,originalOptions:t,startTime:tt||ut(),duration:t.duration,tweens:[],createTween:function(e,t){var n=S.Tween(o,l.opts,e,t,l.opts.specialEasing[e]||l.opts.easing);return l.tweens.push(n),n},stop:function(e){var t=0,n=e?l.tweens.length:0;if(a)return this;for(a=!0;t<n;t++)l.tweens[t].run(1);return e?(s.notifyWith(o,[l,1,0]),s.resolveWith(o,[l,e])):s.rejectWith(o,[l,e]),this}}),c=l.props;for(!function(e,t){var n,r,i,o,a;for(n in e)if(i=t[r=X(n)],o=e[n],Array.isArray(o)&&(i=o[1],o=e[n]=o[0]),n!==r&&(e[r]=o,delete e[n]),(a=S.cssHooks[r])&&"expand"in a)for(n in o=a.expand(o),delete e[r],o)n in e||(e[n]=o[n],t[n]=i);else t[r]=i}(c,l.opts.specialEasing);r<i;r++)if(n=ft.prefilters[r].call(l,o,c,l.opts))return m(n.stop)&&(S._queueHooks(l.elem,l.opts.queue).stop=n.stop.bind(n)),n;return S.map(c,ct,l),m(l.opts.start)&&l.opts.start.call(o,l),l.progress(l.opts.progress).done(l.opts.done,l.opts.complete).fail(l.opts.fail).always(l.opts.always),S.fx.timer(S.extend(u,{elem:o,anim:l,queue:l.opts.queue})),l}S.Animation=S.extend(ft,{tweeners:{"*":[function(e,t){var n=this.createTween(e,t);return se(n.elem,e,te.exec(t),n),n}]},tweener:function(e,t){m(e)?(t=e,e=["*"]):e=e.match(P);for(var n,r=0,i=e.length;r<i;r++)n=e[r],ft.tweeners[n]=ft.tweeners[n]||[],ft.tweeners[n].unshift(t)},prefilters:[function(e,t,n){var r,i,o,a,s,u,l,c,f="width"in t||"height"in t,p=this,d={},h=e.style,g=e.nodeType&&ae(e),v=Y.get(e,"fxshow");for(r in n.queue||(null==(a=S._queueHooks(e,"fx")).unqueued&&(a.unqueued=0,s=a.empty.fire,a.empty.fire=function(){a.unqueued||s()}),a.unqueued++,p.always(function(){p.always(function(){a.unqueued--,S.queue(e,"fx").length||a.empty.fire()})})),t)if(i=t[r],ot.test(i)){if(delete t[r],o=o||"toggle"===i,i===(g?"hide":"show")){if("show"!==i||!v||void 0===v[r])continue;g=!0}d[r]=v&&v[r]||S.style(e,r)}if((u=!S.isEmptyObject(t))||!S.isEmptyObject(d))for(r in f&&1===e.nodeType&&(n.overflow=[h.overflow,h.overflowX,h.overflowY],null==(l=v&&v.display)&&(l=Y.get(e,"display")),"none"===(c=S.css(e,"display"))&&(l?c=l:(le([e],!0),l=e.style.display||l,c=S.css(e,"display"),le([e]))),("inline"===c||"inline-block"===c&&null!=l)&&"none"===S.css(e,"float")&&(u||(p.done(function(){h.display=l}),null==l&&(c=h.display,l="none"===c?"":c)),h.display="inline-block")),n.overflow&&(h.overflow="hidden",p.always(function(){h.overflow=n.overflow[0],h.overflowX=n.overflow[1],h.overflowY=n.overflow[2]})),u=!1,d)u||(v?"hidden"in v&&(g=v.hidden):v=Y.access(e,"fxshow",{display:l}),o&&(v.hidden=!g),g&&le([e],!0),p.done(function(){for(r in g||le([e]),Y.remove(e,"fxshow"),d)S.style(e,r,d[r])})),u=ct(g?v[r]:0,r,p),r in v||(v[r]=u.start,g&&(u.end=u.start,u.start=0))}],prefilter:function(e,t){t?ft.prefilters.unshift(e):ft.prefilters.push(e)}}),S.speed=function(e,t,n){var r=e&&"object"==typeof e?S.extend({},e):{complete:n||!n&&t||m(e)&&e,duration:e,easing:n&&t||t&&!m(t)&&t};return S.fx.off?r.duration=0:"number"!=typeof r.duration&&(r.duration in S.fx.speeds?r.duration=S.fx.speeds[r.duration]:r.duration=S.fx.speeds._default),null!=r.queue&&!0!==r.queue||(r.queue="fx"),r.old=r.complete,r.complete=function(){m(r.old)&&r.old.call(this),r.queue&&S.dequeue(this,r.queue)},r},S.fn.extend({fadeTo:function(e,t,n,r){return this.filter(ae).css("opacity",0).show().end().animate({opacity:t},e,n,r)},animate:function(t,e,n,r){var i=S.isEmptyObject(t),o=S.speed(e,n,r),a=function(){var e=ft(this,S.extend({},t),o);(i||Y.get(this,"finish"))&&e.stop(!0)};return a.finish=a,i||!1===o.queue?this.each(a):this.queue(o.queue,a)},stop:function(i,e,o){var a=function(e){var t=e.stop;delete e.stop,t(o)};return"string"!=typeof i&&(o=e,e=i,i=void 0),e&&this.queue(i||"fx",[]),this.each(function(){var e=!0,t=null!=i&&i+"queueHooks",n=S.timers,r=Y.get(this);if(t)r[t]&&r[t].stop&&a(r[t]);else for(t in r)r[t]&&r[t].stop&&at.test(t)&&a(r[t]);for(t=n.length;t--;)n[t].elem!==this||null!=i&&n[t].queue!==i||(n[t].anim.stop(o),e=!1,n.splice(t,1));!e&&o||S.dequeue(this,i)})},finish:function(a){return!1!==a&&(a=a||"fx"),this.each(function(){var e,t=Y.get(this),n=t[a+"queue"],r=t[a+"queueHooks"],i=S.timers,o=n?n.length:0;for(t.finish=!0,S.queue(this,a,[]),r&&r.stop&&r.stop.call(this,!0),e=i.length;e--;)i[e].elem===this&&i[e].queue===a&&(i[e].anim.stop(!0),i.splice(e,1));for(e=0;e<o;e++)n[e]&&n[e].finish&&n[e].finish.call(this);delete t.finish})}}),S.each(["toggle","show","hide"],function(e,r){var i=S.fn[r];S.fn[r]=function(e,t,n){return null==e||"boolean"==typeof e?i.apply(this,arguments):this.animate(lt(r,!0),e,t,n)}}),S.each({slideDown:lt("show"),slideUp:lt("hide"),slideToggle:lt("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(e,r){S.fn[e]=function(e,t,n){return this.animate(r,e,t,n)}}),S.timers=[],S.fx.tick=function(){var e,t=0,n=S.timers;for(tt=Date.now();t<n.length;t++)(e=n[t])()||n[t]!==e||n.splice(t--,1);n.length||S.fx.stop(),tt=void 0},S.fx.timer=function(e){S.timers.push(e),S.fx.start()},S.fx.interval=13,S.fx.start=function(){nt||(nt=!0,st())},S.fx.stop=function(){nt=null},S.fx.speeds={slow:600,fast:200,_default:400},S.fn.delay=function(r,e){return r=S.fx&&S.fx.speeds[r]||r,e=e||"fx",this.queue(e,function(e,t){var n=C.setTimeout(e,r);t.stop=function(){C.clearTimeout(n)}})},rt=E.createElement("input"),it=E.createElement("select").appendChild(E.createElement("option")),rt.type="checkbox",y.checkOn=""!==rt.value,y.optSelected=it.selected,(rt=E.createElement("input")).value="t",rt.type="radio",y.radioValue="t"===rt.value;var pt,dt=S.expr.attrHandle;S.fn.extend({attr:function(e,t){return $(this,S.attr,e,t,1<arguments.length)},removeAttr:function(e){return this.each(function(){S.removeAttr(this,e)})}}),S.extend({attr:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return"undefined"==typeof e.getAttribute?S.prop(e,t,n):(1===o&&S.isXMLDoc(e)||(i=S.attrHooks[t.toLowerCase()]||(S.expr.match.bool.test(t)?pt:void 0)),void 0!==n?null===n?void S.removeAttr(e,t):i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:(e.setAttribute(t,n+""),n):i&&"get"in i&&null!==(r=i.get(e,t))?r:null==(r=S.find.attr(e,t))?void 0:r)},attrHooks:{type:{set:function(e,t){if(!y.radioValue&&"radio"===t&&A(e,"input")){var n=e.value;return e.setAttribute("type",t),n&&(e.value=n),t}}}},removeAttr:function(e,t){var n,r=0,i=t&&t.match(P);if(i&&1===e.nodeType)while(n=i[r++])e.removeAttribute(n)}}),pt={set:function(e,t,n){return!1===t?S.removeAttr(e,n):e.setAttribute(n,n),n}},S.each(S.expr.match.bool.source.match(/\w+/g),function(e,t){var a=dt[t]||S.find.attr;dt[t]=function(e,t,n){var r,i,o=t.toLowerCase();return n||(i=dt[o],dt[o]=r,r=null!=a(e,t,n)?o:null,dt[o]=i),r}});var ht=/^(?:input|select|textarea|button)$/i,gt=/^(?:a|area)$/i;function vt(e){return(e.match(P)||[]).join(" ")}function yt(e){return e.getAttribute&&e.getAttribute("class")||""}function mt(e){return Array.isArray(e)?e:"string"==typeof e&&e.match(P)||[]}S.fn.extend({prop:function(e,t){return $(this,S.prop,e,t,1<arguments.length)},removeProp:function(e){return this.each(function(){delete this[S.propFix[e]||e]})}}),S.extend({prop:function(e,t,n){var r,i,o=e.nodeType;if(3!==o&&8!==o&&2!==o)return 1===o&&S.isXMLDoc(e)||(t=S.propFix[t]||t,i=S.propHooks[t]),void 0!==n?i&&"set"in i&&void 0!==(r=i.set(e,n,t))?r:e[t]=n:i&&"get"in i&&null!==(r=i.get(e,t))?r:e[t]},propHooks:{tabIndex:{get:function(e){var t=S.find.attr(e,"tabindex");return t?parseInt(t,10):ht.test(e.nodeName)||gt.test(e.nodeName)&&e.href?0:-1}}},propFix:{"for":"htmlFor","class":"className"}}),y.optSelected||(S.propHooks.selected={get:function(e){var t=e.parentNode;return t&&t.parentNode&&t.parentNode.selectedIndex,null},set:function(e){var t=e.parentNode;t&&(t.selectedIndex,t.parentNode&&t.parentNode.selectedIndex)}}),S.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){S.propFix[this.toLowerCase()]=this}),S.fn.extend({addClass:function(t){var e,n,r,i,o,a,s,u=0;if(m(t))return this.each(function(e){S(this).addClass(t.call(this,e,yt(this)))});if((e=mt(t)).length)while(n=this[u++])if(i=yt(n),r=1===n.nodeType&&" "+vt(i)+" "){a=0;while(o=e[a++])r.indexOf(" "+o+" ")<0&&(r+=o+" ");i!==(s=vt(r))&&n.setAttribute("class",s)}return this},removeClass:function(t){var e,n,r,i,o,a,s,u=0;if(m(t))return this.each(function(e){S(this).removeClass(t.call(this,e,yt(this)))});if(!arguments.length)return this.attr("class","");if((e=mt(t)).length)while(n=this[u++])if(i=yt(n),r=1===n.nodeType&&" "+vt(i)+" "){a=0;while(o=e[a++])while(-1<r.indexOf(" "+o+" "))r=r.replace(" "+o+" "," ");i!==(s=vt(r))&&n.setAttribute("class",s)}return this},toggleClass:function(i,t){var o=typeof i,a="string"===o||Array.isArray(i);return"boolean"==typeof t&&a?t?this.addClass(i):this.removeClass(i):m(i)?this.each(function(e){S(this).toggleClass(i.call(this,e,yt(this),t),t)}):this.each(function(){var e,t,n,r;if(a){t=0,n=S(this),r=mt(i);while(e=r[t++])n.hasClass(e)?n.removeClass(e):n.addClass(e)}else void 0!==i&&"boolean"!==o||((e=yt(this))&&Y.set(this,"__className__",e),this.setAttribute&&this.setAttribute("class",e||!1===i?"":Y.get(this,"__className__")||""))})},hasClass:function(e){var t,n,r=0;t=" "+e+" ";while(n=this[r++])if(1===n.nodeType&&-1<(" "+vt(yt(n))+" ").indexOf(t))return!0;return!1}});var xt=/\r/g;S.fn.extend({val:function(n){var r,e,i,t=this[0];return arguments.length?(i=m(n),this.each(function(e){var t;1===this.nodeType&&(null==(t=i?n.call(this,e,S(this).val()):n)?t="":"number"==typeof t?t+="":Array.isArray(t)&&(t=S.map(t,function(e){return null==e?"":e+""})),(r=S.valHooks[this.type]||S.valHooks[this.nodeName.toLowerCase()])&&"set"in r&&void 0!==r.set(this,t,"value")||(this.value=t))})):t?(r=S.valHooks[t.type]||S.valHooks[t.nodeName.toLowerCase()])&&"get"in r&&void 0!==(e=r.get(t,"value"))?e:"string"==typeof(e=t.value)?e.replace(xt,""):null==e?"":e:void 0}}),S.extend({valHooks:{option:{get:function(e){var t=S.find.attr(e,"value");return null!=t?t:vt(S.text(e))}},select:{get:function(e){var t,n,r,i=e.options,o=e.selectedIndex,a="select-one"===e.type,s=a?null:[],u=a?o+1:i.length;for(r=o<0?u:a?o:0;r<u;r++)if(((n=i[r]).selected||r===o)&&!n.disabled&&(!n.parentNode.disabled||!A(n.parentNode,"optgroup"))){if(t=S(n).val(),a)return t;s.push(t)}return s},set:function(e,t){var n,r,i=e.options,o=S.makeArray(t),a=i.length;while(a--)((r=i[a]).selected=-1<S.inArray(S.valHooks.option.get(r),o))&&(n=!0);return n||(e.selectedIndex=-1),o}}}}),S.each(["radio","checkbox"],function(){S.valHooks[this]={set:function(e,t){if(Array.isArray(t))return e.checked=-1<S.inArray(S(e).val(),t)}},y.checkOn||(S.valHooks[this].get=function(e){return null===e.getAttribute("value")?"on":e.value})}),y.focusin="onfocusin"in C;var bt=/^(?:focusinfocus|focusoutblur)$/,wt=function(e){e.stopPropagation()};S.extend(S.event,{trigger:function(e,t,n,r){var i,o,a,s,u,l,c,f,p=[n||E],d=v.call(e,"type")?e.type:e,h=v.call(e,"namespace")?e.namespace.split("."):[];if(o=f=a=n=n||E,3!==n.nodeType&&8!==n.nodeType&&!bt.test(d+S.event.triggered)&&(-1<d.indexOf(".")&&(d=(h=d.split(".")).shift(),h.sort()),u=d.indexOf(":")<0&&"on"+d,(e=e[S.expando]?e:new S.Event(d,"object"==typeof e&&e)).isTrigger=r?2:3,e.namespace=h.join("."),e.rnamespace=e.namespace?new RegExp("(^|\\.)"+h.join("\\.(?:.*\\.|)")+"(\\.|$)"):null,e.result=void 0,e.target||(e.target=n),t=null==t?[e]:S.makeArray(t,[e]),c=S.event.special[d]||{},r||!c.trigger||!1!==c.trigger.apply(n,t))){if(!r&&!c.noBubble&&!x(n)){for(s=c.delegateType||d,bt.test(s+d)||(o=o.parentNode);o;o=o.parentNode)p.push(o),a=o;a===(n.ownerDocument||E)&&p.push(a.defaultView||a.parentWindow||C)}i=0;while((o=p[i++])&&!e.isPropagationStopped())f=o,e.type=1<i?s:c.bindType||d,(l=(Y.get(o,"events")||Object.create(null))[e.type]&&Y.get(o,"handle"))&&l.apply(o,t),(l=u&&o[u])&&l.apply&&V(o)&&(e.result=l.apply(o,t),!1===e.result&&e.preventDefault());return e.type=d,r||e.isDefaultPrevented()||c._default&&!1!==c._default.apply(p.pop(),t)||!V(n)||u&&m(n[d])&&!x(n)&&((a=n[u])&&(n[u]=null),S.event.triggered=d,e.isPropagationStopped()&&f.addEventListener(d,wt),n[d](),e.isPropagationStopped()&&f.removeEventListener(d,wt),S.event.triggered=void 0,a&&(n[u]=a)),e.result}},simulate:function(e,t,n){var r=S.extend(new S.Event,n,{type:e,isSimulated:!0});S.event.trigger(r,null,t)}}),S.fn.extend({trigger:function(e,t){return this.each(function(){S.event.trigger(e,t,this)})},triggerHandler:function(e,t){var n=this[0];if(n)return S.event.trigger(e,t,n,!0)}}),y.focusin||S.each({focus:"focusin",blur:"focusout"},function(n,r){var i=function(e){S.event.simulate(r,e.target,S.event.fix(e))};S.event.special[r]={setup:function(){var e=this.ownerDocument||this.document||this,t=Y.access(e,r);t||e.addEventListener(n,i,!0),Y.access(e,r,(t||0)+1)},teardown:function(){var e=this.ownerDocument||this.document||this,t=Y.access(e,r)-1;t?Y.access(e,r,t):(e.removeEventListener(n,i,!0),Y.remove(e,r))}}});var Tt=C.location,Ct={guid:Date.now()},Et=/\?/;S.parseXML=function(e){var t;if(!e||"string"!=typeof e)return null;try{t=(new C.DOMParser).parseFromString(e,"text/xml")}catch(e){t=void 0}return t&&!t.getElementsByTagName("parsererror").length||S.error("Invalid XML: "+e),t};var St=/\[\]$/,kt=/\r?\n/g,At=/^(?:submit|button|image|reset|file)$/i,Nt=/^(?:input|select|textarea|keygen)/i;function Dt(n,e,r,i){var t;if(Array.isArray(e))S.each(e,function(e,t){r||St.test(n)?i(n,t):Dt(n+"["+("object"==typeof t&&null!=t?e:"")+"]",t,r,i)});else if(r||"object"!==w(e))i(n,e);else for(t in e)Dt(n+"["+t+"]",e[t],r,i)}S.param=function(e,t){var n,r=[],i=function(e,t){var n=m(t)?t():t;r[r.length]=encodeURIComponent(e)+"="+encodeURIComponent(null==n?"":n)};if(null==e)return"";if(Array.isArray(e)||e.jquery&&!S.isPlainObject(e))S.each(e,function(){i(this.name,this.value)});else for(n in e)Dt(n,e[n],t,i);return r.join("&")},S.fn.extend({serialize:function(){return S.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var e=S.prop(this,"elements");return e?S.makeArray(e):this}).filter(function(){var e=this.type;return this.name&&!S(this).is(":disabled")&&Nt.test(this.nodeName)&&!At.test(e)&&(this.checked||!pe.test(e))}).map(function(e,t){var n=S(this).val();return null==n?null:Array.isArray(n)?S.map(n,function(e){return{name:t.name,value:e.replace(kt,"\r\n")}}):{name:t.name,value:n.replace(kt,"\r\n")}}).get()}});var jt=/%20/g,qt=/#.*$/,Lt=/([?&])_=[^&]*/,Ht=/^(.*?):[ \t]*([^\r\n]*)$/gm,Ot=/^(?:GET|HEAD)$/,Pt=/^\/\//,Rt={},Mt={},It="*/".concat("*"),Wt=E.createElement("a");function Ft(o){return function(e,t){"string"!=typeof e&&(t=e,e="*");var n,r=0,i=e.toLowerCase().match(P)||[];if(m(t))while(n=i[r++])"+"===n[0]?(n=n.slice(1)||"*",(o[n]=o[n]||[]).unshift(t)):(o[n]=o[n]||[]).push(t)}}function Bt(t,i,o,a){var s={},u=t===Mt;function l(e){var r;return s[e]=!0,S.each(t[e]||[],function(e,t){var n=t(i,o,a);return"string"!=typeof n||u||s[n]?u?!(r=n):void 0:(i.dataTypes.unshift(n),l(n),!1)}),r}return l(i.dataTypes[0])||!s["*"]&&l("*")}function $t(e,t){var n,r,i=S.ajaxSettings.flatOptions||{};for(n in t)void 0!==t[n]&&((i[n]?e:r||(r={}))[n]=t[n]);return r&&S.extend(!0,e,r),e}Wt.href=Tt.href,S.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:Tt.href,type:"GET",isLocal:/^(?:about|app|app-storage|.+-extension|file|res|widget):$/.test(Tt.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":It,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":S.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(e,t){return t?$t($t(e,S.ajaxSettings),t):$t(S.ajaxSettings,e)},ajaxPrefilter:Ft(Rt),ajaxTransport:Ft(Mt),ajax:function(e,t){"object"==typeof e&&(t=e,e=void 0),t=t||{};var c,f,p,n,d,r,h,g,i,o,v=S.ajaxSetup({},t),y=v.context||v,m=v.context&&(y.nodeType||y.jquery)?S(y):S.event,x=S.Deferred(),b=S.Callbacks("once memory"),w=v.statusCode||{},a={},s={},u="canceled",T={readyState:0,getResponseHeader:function(e){var t;if(h){if(!n){n={};while(t=Ht.exec(p))n[t[1].toLowerCase()+" "]=(n[t[1].toLowerCase()+" "]||[]).concat(t[2])}t=n[e.toLowerCase()+" "]}return null==t?null:t.join(", ")},getAllResponseHeaders:function(){return h?p:null},setRequestHeader:function(e,t){return null==h&&(e=s[e.toLowerCase()]=s[e.toLowerCase()]||e,a[e]=t),this},overrideMimeType:function(e){return null==h&&(v.mimeType=e),this},statusCode:function(e){var t;if(e)if(h)T.always(e[T.status]);else for(t in e)w[t]=[w[t],e[t]];return this},abort:function(e){var t=e||u;return c&&c.abort(t),l(0,t),this}};if(x.promise(T),v.url=((e||v.url||Tt.href)+"").replace(Pt,Tt.protocol+"//"),v.type=t.method||t.type||v.method||v.type,v.dataTypes=(v.dataType||"*").toLowerCase().match(P)||[""],null==v.crossDomain){r=E.createElement("a");try{r.href=v.url,r.href=r.href,v.crossDomain=Wt.protocol+"//"+Wt.host!=r.protocol+"//"+r.host}catch(e){v.crossDomain=!0}}if(v.data&&v.processData&&"string"!=typeof v.data&&(v.data=S.param(v.data,v.traditional)),Bt(Rt,v,t,T),h)return T;for(i in(g=S.event&&v.global)&&0==S.active++&&S.event.trigger("ajaxStart"),v.type=v.type.toUpperCase(),v.hasContent=!Ot.test(v.type),f=v.url.replace(qt,""),v.hasContent?v.data&&v.processData&&0===(v.contentType||"").indexOf("application/x-www-form-urlencoded")&&(v.data=v.data.replace(jt,"+")):(o=v.url.slice(f.length),v.data&&(v.processData||"string"==typeof v.data)&&(f+=(Et.test(f)?"&":"?")+v.data,delete v.data),!1===v.cache&&(f=f.replace(Lt,"$1"),o=(Et.test(f)?"&":"?")+"_="+Ct.guid+++o),v.url=f+o),v.ifModified&&(S.lastModified[f]&&T.setRequestHeader("If-Modified-Since",S.lastModified[f]),S.etag[f]&&T.setRequestHeader("If-None-Match",S.etag[f])),(v.data&&v.hasContent&&!1!==v.contentType||t.contentType)&&T.setRequestHeader("Content-Type",v.contentType),T.setRequestHeader("Accept",v.dataTypes[0]&&v.accepts[v.dataTypes[0]]?v.accepts[v.dataTypes[0]]+("*"!==v.dataTypes[0]?", "+It+"; q=0.01":""):v.accepts["*"]),v.headers)T.setRequestHeader(i,v.headers[i]);if(v.beforeSend&&(!1===v.beforeSend.call(y,T,v)||h))return T.abort();if(u="abort",b.add(v.complete),T.done(v.success),T.fail(v.error),c=Bt(Mt,v,t,T)){if(T.readyState=1,g&&m.trigger("ajaxSend",[T,v]),h)return T;v.async&&0<v.timeout&&(d=C.setTimeout(function(){T.abort("timeout")},v.timeout));try{h=!1,c.send(a,l)}catch(e){if(h)throw e;l(-1,e)}}else l(-1,"No Transport");function l(e,t,n,r){var i,o,a,s,u,l=t;h||(h=!0,d&&C.clearTimeout(d),c=void 0,p=r||"",T.readyState=0<e?4:0,i=200<=e&&e<300||304===e,n&&(s=function(e,t,n){var r,i,o,a,s=e.contents,u=e.dataTypes;while("*"===u[0])u.shift(),void 0===r&&(r=e.mimeType||t.getResponseHeader("Content-Type"));if(r)for(i in s)if(s[i]&&s[i].test(r)){u.unshift(i);break}if(u[0]in n)o=u[0];else{for(i in n){if(!u[0]||e.converters[i+" "+u[0]]){o=i;break}a||(a=i)}o=o||a}if(o)return o!==u[0]&&u.unshift(o),n[o]}(v,T,n)),!i&&-1<S.inArray("script",v.dataTypes)&&(v.converters["text script"]=function(){}),s=function(e,t,n,r){var i,o,a,s,u,l={},c=e.dataTypes.slice();if(c[1])for(a in e.converters)l[a.toLowerCase()]=e.converters[a];o=c.shift();while(o)if(e.responseFields[o]&&(n[e.responseFields[o]]=t),!u&&r&&e.dataFilter&&(t=e.dataFilter(t,e.dataType)),u=o,o=c.shift())if("*"===o)o=u;else if("*"!==u&&u!==o){if(!(a=l[u+" "+o]||l["* "+o]))for(i in l)if((s=i.split(" "))[1]===o&&(a=l[u+" "+s[0]]||l["* "+s[0]])){!0===a?a=l[i]:!0!==l[i]&&(o=s[0],c.unshift(s[1]));break}if(!0!==a)if(a&&e["throws"])t=a(t);else try{t=a(t)}catch(e){return{state:"parsererror",error:a?e:"No conversion from "+u+" to "+o}}}return{state:"success",data:t}}(v,s,T,i),i?(v.ifModified&&((u=T.getResponseHeader("Last-Modified"))&&(S.lastModified[f]=u),(u=T.getResponseHeader("etag"))&&(S.etag[f]=u)),204===e||"HEAD"===v.type?l="nocontent":304===e?l="notmodified":(l=s.state,o=s.data,i=!(a=s.error))):(a=l,!e&&l||(l="error",e<0&&(e=0))),T.status=e,T.statusText=(t||l)+"",i?x.resolveWith(y,[o,l,T]):x.rejectWith(y,[T,l,a]),T.statusCode(w),w=void 0,g&&m.trigger(i?"ajaxSuccess":"ajaxError",[T,v,i?o:a]),b.fireWith(y,[T,l]),g&&(m.trigger("ajaxComplete",[T,v]),--S.active||S.event.trigger("ajaxStop")))}return T},getJSON:function(e,t,n){return S.get(e,t,n,"json")},getScript:function(e,t){return S.get(e,void 0,t,"script")}}),S.each(["get","post"],function(e,i){S[i]=function(e,t,n,r){return m(t)&&(r=r||n,n=t,t=void 0),S.ajax(S.extend({url:e,type:i,dataType:r,data:t,success:n},S.isPlainObject(e)&&e))}}),S.ajaxPrefilter(function(e){var t;for(t in e.headers)"content-type"===t.toLowerCase()&&(e.contentType=e.headers[t]||"")}),S._evalUrl=function(e,t,n){return S.ajax({url:e,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,converters:{"text script":function(){}},dataFilter:function(e){S.globalEval(e,t,n)}})},S.fn.extend({wrapAll:function(e){var t;return this[0]&&(m(e)&&(e=e.call(this[0])),t=S(e,this[0].ownerDocument).eq(0).clone(!0),this[0].parentNode&&t.insertBefore(this[0]),t.map(function(){var e=this;while(e.firstElementChild)e=e.firstElementChild;return e}).append(this)),this},wrapInner:function(n){return m(n)?this.each(function(e){S(this).wrapInner(n.call(this,e))}):this.each(function(){var e=S(this),t=e.contents();t.length?t.wrapAll(n):e.append(n)})},wrap:function(t){var n=m(t);return this.each(function(e){S(this).wrapAll(n?t.call(this,e):t)})},unwrap:function(e){return this.parent(e).not("body").each(function(){S(this).replaceWith(this.childNodes)}),this}}),S.expr.pseudos.hidden=function(e){return!S.expr.pseudos.visible(e)},S.expr.pseudos.visible=function(e){return!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)},S.ajaxSettings.xhr=function(){try{return new C.XMLHttpRequest}catch(e){}};var _t={0:200,1223:204},zt=S.ajaxSettings.xhr();y.cors=!!zt&&"withCredentials"in zt,y.ajax=zt=!!zt,S.ajaxTransport(function(i){var o,a;if(y.cors||zt&&!i.crossDomain)return{send:function(e,t){var n,r=i.xhr();if(r.open(i.type,i.url,i.async,i.username,i.password),i.xhrFields)for(n in i.xhrFields)r[n]=i.xhrFields[n];for(n in i.mimeType&&r.overrideMimeType&&r.overrideMimeType(i.mimeType),i.crossDomain||e["X-Requested-With"]||(e["X-Requested-With"]="XMLHttpRequest"),e)r.setRequestHeader(n,e[n]);o=function(e){return function(){o&&(o=a=r.onload=r.onerror=r.onabort=r.ontimeout=r.onreadystatechange=null,"abort"===e?r.abort():"error"===e?"number"!=typeof r.status?t(0,"error"):t(r.status,r.statusText):t(_t[r.status]||r.status,r.statusText,"text"!==(r.responseType||"text")||"string"!=typeof r.responseText?{binary:r.response}:{text:r.responseText},r.getAllResponseHeaders()))}},r.onload=o(),a=r.onerror=r.ontimeout=o("error"),void 0!==r.onabort?r.onabort=a:r.onreadystatechange=function(){4===r.readyState&&C.setTimeout(function(){o&&a()})},o=o("abort");try{r.send(i.hasContent&&i.data||null)}catch(e){if(o)throw e}},abort:function(){o&&o()}}}),S.ajaxPrefilter(function(e){e.crossDomain&&(e.contents.script=!1)}),S.ajaxSetup({accepts:{script:"text/javascript, application/javascript, application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(e){return S.globalEval(e),e}}}),S.ajaxPrefilter("script",function(e){void 0===e.cache&&(e.cache=!1),e.crossDomain&&(e.type="GET")}),S.ajaxTransport("script",function(n){var r,i;if(n.crossDomain||n.scriptAttrs)return{send:function(e,t){r=S("<script>").attr(n.scriptAttrs||{}).prop({charset:n.scriptCharset,src:n.url}).on("load error",i=function(e){r.remove(),i=null,e&&t("error"===e.type?404:200,e.type)}),E.head.appendChild(r[0])},abort:function(){i&&i()}}});var Ut,Xt=[],Vt=/(=)\?(?=&|$)|\?\?/;S.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var e=Xt.pop()||S.expando+"_"+Ct.guid++;return this[e]=!0,e}}),S.ajaxPrefilter("json jsonp",function(e,t,n){var r,i,o,a=!1!==e.jsonp&&(Vt.test(e.url)?"url":"string"==typeof e.data&&0===(e.contentType||"").indexOf("application/x-www-form-urlencoded")&&Vt.test(e.data)&&"data");if(a||"jsonp"===e.dataTypes[0])return r=e.jsonpCallback=m(e.jsonpCallback)?e.jsonpCallback():e.jsonpCallback,a?e[a]=e[a].replace(Vt,"$1"+r):!1!==e.jsonp&&(e.url+=(Et.test(e.url)?"&":"?")+e.jsonp+"="+r),e.converters["script json"]=function(){return o||S.error(r+" was not called"),o[0]},e.dataTypes[0]="json",i=C[r],C[r]=function(){o=arguments},n.always(function(){void 0===i?S(C).removeProp(r):C[r]=i,e[r]&&(e.jsonpCallback=t.jsonpCallback,Xt.push(r)),o&&m(i)&&i(o[0]),o=i=void 0}),"script"}),y.createHTMLDocument=((Ut=E.implementation.createHTMLDocument("").body).innerHTML="<form></form><form></form>",2===Ut.childNodes.length),S.parseHTML=function(e,t,n){return"string"!=typeof e?[]:("boolean"==typeof t&&(n=t,t=!1),t||(y.createHTMLDocument?((r=(t=E.implementation.createHTMLDocument("")).createElement("base")).href=E.location.href,t.head.appendChild(r)):t=E),o=!n&&[],(i=N.exec(e))?[t.createElement(i[1])]:(i=xe([e],t,o),o&&o.length&&S(o).remove(),S.merge([],i.childNodes)));var r,i,o},S.fn.load=function(e,t,n){var r,i,o,a=this,s=e.indexOf(" ");return-1<s&&(r=vt(e.slice(s)),e=e.slice(0,s)),m(t)?(n=t,t=void 0):t&&"object"==typeof t&&(i="POST"),0<a.length&&S.ajax({url:e,type:i||"GET",dataType:"html",data:t}).done(function(e){o=arguments,a.html(r?S("<div>").append(S.parseHTML(e)).find(r):e)}).always(n&&function(e,t){a.each(function(){n.apply(this,o||[e.responseText,t,e])})}),this},S.expr.pseudos.animated=function(t){return S.grep(S.timers,function(e){return t===e.elem}).length},S.offset={setOffset:function(e,t,n){var r,i,o,a,s,u,l=S.css(e,"position"),c=S(e),f={};"static"===l&&(e.style.position="relative"),s=c.offset(),o=S.css(e,"top"),u=S.css(e,"left"),("absolute"===l||"fixed"===l)&&-1<(o+u).indexOf("auto")?(a=(r=c.position()).top,i=r.left):(a=parseFloat(o)||0,i=parseFloat(u)||0),m(t)&&(t=t.call(e,n,S.extend({},s))),null!=t.top&&(f.top=t.top-s.top+a),null!=t.left&&(f.left=t.left-s.left+i),"using"in t?t.using.call(e,f):("number"==typeof f.top&&(f.top+="px"),"number"==typeof f.left&&(f.left+="px"),c.css(f))}},S.fn.extend({offset:function(t){if(arguments.length)return void 0===t?this:this.each(function(e){S.offset.setOffset(this,t,e)});var e,n,r=this[0];return r?r.getClientRects().length?(e=r.getBoundingClientRect(),n=r.ownerDocument.defaultView,{top:e.top+n.pageYOffset,left:e.left+n.pageXOffset}):{top:0,left:0}:void 0},position:function(){if(this[0]){var e,t,n,r=this[0],i={top:0,left:0};if("fixed"===S.css(r,"position"))t=r.getBoundingClientRect();else{t=this.offset(),n=r.ownerDocument,e=r.offsetParent||n.documentElement;while(e&&(e===n.body||e===n.documentElement)&&"static"===S.css(e,"position"))e=e.parentNode;e&&e!==r&&1===e.nodeType&&((i=S(e).offset()).top+=S.css(e,"borderTopWidth",!0),i.left+=S.css(e,"borderLeftWidth",!0))}return{top:t.top-i.top-S.css(r,"marginTop",!0),left:t.left-i.left-S.css(r,"marginLeft",!0)}}},offsetParent:function(){return this.map(function(){var e=this.offsetParent;while(e&&"static"===S.css(e,"position"))e=e.offsetParent;return e||re})}}),S.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(t,i){var o="pageYOffset"===i;S.fn[t]=function(e){return $(this,function(e,t,n){var r;if(x(e)?r=e:9===e.nodeType&&(r=e.defaultView),void 0===n)return r?r[i]:e[t];r?r.scrollTo(o?r.pageXOffset:n,o?n:r.pageYOffset):e[t]=n},t,e,arguments.length)}}),S.each(["top","left"],function(e,n){S.cssHooks[n]=$e(y.pixelPosition,function(e,t){if(t)return t=Be(e,n),Me.test(t)?S(e).position()[n]+"px":t})}),S.each({Height:"height",Width:"width"},function(a,s){S.each({padding:"inner"+a,content:s,"":"outer"+a},function(r,o){S.fn[o]=function(e,t){var n=arguments.length&&(r||"boolean"!=typeof e),i=r||(!0===e||!0===t?"margin":"border");return $(this,function(e,t,n){var r;return x(e)?0===o.indexOf("outer")?e["inner"+a]:e.document.documentElement["client"+a]:9===e.nodeType?(r=e.documentElement,Math.max(e.body["scroll"+a],r["scroll"+a],e.body["offset"+a],r["offset"+a],r["client"+a])):void 0===n?S.css(e,t,i):S.style(e,t,n,i)},s,n?e:void 0,n)}})}),S.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(e,t){S.fn[t]=function(e){return this.on(t,e)}}),S.fn.extend({bind:function(e,t,n){return this.on(e,null,t,n)},unbind:function(e,t){return this.off(e,null,t)},delegate:function(e,t,n,r){return this.on(t,e,n,r)},undelegate:function(e,t,n){return 1===arguments.length?this.off(e,"**"):this.off(t,e||"**",n)},hover:function(e,t){return this.mouseenter(e).mouseleave(t||e)}}),S.each("blur focus focusin focusout resize scroll click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup contextmenu".split(" "),function(e,n){S.fn[n]=function(e,t){return 0<arguments.length?this.on(n,null,e,t):this.trigger(n)}});var Gt=/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;S.proxy=function(e,t){var n,r,i;if("string"==typeof t&&(n=e[t],t=e,e=n),m(e))return r=s.call(arguments,2),(i=function(){return e.apply(t||this,r.concat(s.call(arguments)))}).guid=e.guid=e.guid||S.guid++,i},S.holdReady=function(e){e?S.readyWait++:S.ready(!0)},S.isArray=Array.isArray,S.parseJSON=JSON.parse,S.nodeName=A,S.isFunction=m,S.isWindow=x,S.camelCase=X,S.type=w,S.now=Date.now,S.isNumeric=function(e){var t=S.type(e);return("number"===t||"string"===t)&&!isNaN(e-parseFloat(e))},S.trim=function(e){return null==e?"":(e+"").replace(Gt,"")},"function"==typeof define&&define.amd&&define("jquery",[],function(){return S});var Yt=C.jQuery,Qt=C.$;return S.noConflict=function(e){return C.$===S&&(C.$=Qt),e&&C.jQuery===S&&(C.jQuery=Yt),S},"undefined"==typeof e&&(C.jQuery=C.$=S),S});
// class to convert the standard JSON representation of a gatenlp
// document into something we need here and methods to access the data.
var gatenlpDocRep = class {
    constructor(jsonstring) {
            this.sep = "║"
            this.sname2types = new Map();
            this.snameid2ann = new Map();
            this.snametype2ids = new Map();
            let bdoc = JSON.parse(jsonstring);
            this.text = bdoc["text"];
            this.features = bdoc["features"];
            if (this.text == null) {
                this.text = "[No proper GATENLP document to show]";
                return;
            }
            let annsets = bdoc["annotation_sets"];
            if (annsets == null) {
                return;
            }
            for (let setname in annsets) {
                // console.log("Processing setname: " + setname)
                let annset = annsets[setname];
                let types4annset = new Set();
                let anns4set = annset["annotations"];
                for (let [idx, element] of anns4set.entries()) {
                    // console.log("adding ann: " + idx + " / " + element)
                    let annid = element["id"].toString();
                    let anntype = element["type"];
                    types4annset.add(anntype);
                    // let snametype = setname + DocRep.sep + anntype;
                    let snametype = setname + this.sep + anntype;
                    // console.log("Created key " + snametype)
                    let ids4type = this.snametype2ids.get(snametype);
                    if (ids4type == null) {
                        //console.log("Adding " + [annid])
                        this.snametype2ids.set(snametype, [annid]);
                        // console.log("keys now " + Array.from(this.snametype2ids.keys()))
                    } else {
                        ids4type.push(annid);
                        // console.log("snametype2ids for " + snametype + " is now " + ids4type)
                    }
                    let snameid = setname + this.sep + annid
                    let ann4snameid = this.snameid2ann.get(snameid);
                    if (ann4snameid == null) {
                        this.snameid2ann.set(snameid, element);
                    } else {
                        // how to handle this odd error?
                    }
                }
                this.sname2types.set(setname, Array.from(types4annset).sort());
            }
        } // constructor

    setnames() {
        return Array.from(this.sname2types.keys()).sort();
    }

    types4setname(setname) {
        // return a sorted list of annotation types for a set name
        return Array.from(this.sname2types.get(setname)); // already sorted!
    }

    annids4snametype(setname, anntype) {
        // return a list of annotation ids for a setname and annotation type
        return this.snametype2ids.get(setname + this.sep + anntype);
    }

    ann4setnameannid(setname, annid) {
        // return the annotation object (map) for a set/id
        return this.snameid2ann.get(setname + this.sep + annid)
    }

    anns4settype(setname, type) {
        //console.log("Getting anns for " + setname + " " + type)
        let annids = this.annids4snametype(setname, type);
        let anns = [];
        for (let annid of annids) {
            anns[anns.length] = this.ann4setnameannid(setname, annid);
        }
        //console.log("Found " + annids + " returning " + anns);
        return anns;
    }

};

function docview_annchosen(rep, ev, setname, anntype) {
        let checked = $(ev.target).prop("checked");
        // this gives us the setname, type and checkbox status of what has been clicked, but for now
        // we always get the complete list of selected types here:
        let seltypes = [];
        let inputs = $(rep.id_chooser).find("input");
        inputs.each(function(index) {
            let inputel = $(inputs.get(index));
            if (inputel.prop("checked")) {
                // seltypes.push(([inputel.attr("data-setname"), inputel.attr("data-anntype")]));
                seltypes[seltypes.length] = [inputel.attr("data-setname"), inputel.attr("data-anntype")]
            }
        });
        rep.chosen = seltypes;
        rep.buildAnns4Offset();
        rep.buildContent();
    }

function docview_annsel(obj, ev, anns) {
        if (anns.size > 1) {
            // if there are several annotation, show the popup
            $(obj.id_popup).empty();
            for (let info of anns.values()) {
                let fields = info.split("║")
                let setname = fields[0]
                let annid = fields[2]                
                let ann = obj.docrep.ann4setnameannid(setname, annid);
                // console.log("Looking up setname="+setname+",annid="+annid+" gave: "+ann)
                let feats = ann.features;
                let idpopup = obj.id_popup;
                $("<div class='" + obj.class_selection + "'>" + ann.type + ": id=" + annid + " offsets=" + ann.start + ".." + ann.end + " (" + (ann.end-ann.start) + ")" + "</div>").on("click", function(x) {
                    docview_showAnn(obj, ann);
                    $(idpopup).hide();
                }).appendTo(obj.id_popup);
            }
            $(obj.id_popup).show();            
        } else if (anns.size == 1) {
            // if there is just one annotation, show features immediately, without the popup
            let a = anns.values().next()["value"]
            let fields = a.split("║")            
            let ann = obj.docrep.ann4setnameannid(fields[0], fields[2]);
            docview_showAnn(obj, ann);
        } else {
            console.error("EMPTY ANNS???");
        }
    }

function docview_showFeatures(obj, features) {
        let tbl = $("<table>").attr("class", obj.idprefix+"featuretable");
        for (let fname in features) {
            let fval = JSON.stringify(features[fname]);
            tbl.append("<tr><td class='" + obj.class_fname + "'>" + fname + "</td><td class='" + obj.class_fvalue + "'>" + fval + "</td></tr>");
        }
        $(obj.id_details).append(tbl);
    }

function docview_showAnn(obj, ann) {
        $(obj.id_details).empty();
        $(obj.id_details).append("<div class='" + obj.id_hdr + "'>Annotation: " + ann.type + ", id:" + ann.id + " offsets:" + ann.start + ".." + ann.end + " (" + (ann.end-ann.start) + ")</div>");
        docview_showFeatures(obj, ann.features);
    }

function docview_showDocFeatures(obj, features) {
        $(obj.id_details).empty();
        $(obj.id_details).append("<div class='" + obj.id_hdr + "'>Document features:</div>");
        docview_showFeatures(obj, features);
    }



// class to build the HTML for viewing the converted document
var gatenlpDocView = class {
    constructor(docrep, idprefix="GATENLPID-", config=undefined) {
        // idprefix: the prefix to add to all ids and classes
        this.sep = "║"
        this.docrep = docrep;
        this.idprefix = idprefix;
        this.id_text = "#" + idprefix + "text";
        this.id_chooser = "#" + idprefix + "chooser";
        this.id_details = "#" + idprefix + "details";
        this.id_popup = "#" + idprefix + "popup";
        this.id_hdr = "#" + idprefix + "hdr";
        this.id_dochdr = "#" + idprefix + "dochdr";
        this.class_selection = idprefix + "selection";
        this.class_fname = idprefix + "fname";
        this.class_fvalue = idprefix + "fvalue";
        this.class_label = idprefix + "label";
        this.class_input = idprefix + "input";
        this.chosen = [];
        this.anns4offset = undefined;
        // create default config here
        this.config = config;
        this.palettex = [
            // modified from R lib pals: alphabet2
            "#AA6DAA", "#3283FE", "#85660D", "#782AB6", "#565656", "#1C8356", "#16FF32", "#F7E1A0", "#E2E2E2", "#1CBE4F", "#C4451C", "#DEA0FD",
            "#FE00FA", "#325A9B", "#FEAF16", "#F8A19F", "#90AD1C", "#F6222E", "#1CFFCE", "#2ED9FF", "#B10DA1", "#C075A6", "#FC1CBF", "#B00068",
            "#FBE426", "#FA0087",
            // modified from R lib pals: polychrome
            "#5A5156", "#E4E1E3", "#F6222E", "#FE00FA", "#16FF32", "#3283FE", "#FEAF16", "#B00068", "#1CFFCE", "#90AD1C",
            "#2ED9FF", "#DEA0FD", "#AA0DFE", "#F8A19F", "#325A9B", "#C4451C", "#1C8356", "#85660D", "#B10DA1", "#FBE426",
            "#1CBE4F", "#FA0087", "#FC1CBF", "#F7E1A0", "#C075A6", "#782AB6", "#AAF400", "#BDCDFF", "#822E1C", "#B5EFB5",
            "#7ED7D1", "#1C7F93", "#D85FF7", "#683B79", "#66B0FF", "#3B00FB"
        ]

        function hex2rgba(hx) {
            return [
                parseInt(hx.substring(1, 3), 16),
                parseInt(hx.substring(3, 5), 16),
                parseInt(hx.substring(5, 7), 16),
                1.0
            ];
        };
        this.palette = this.palettex.map(hex2rgba)
        this.type2colour = new Map();
    }

    style4color(col) {
        return "background-color: rgba(" + col.join(",") + ");"
    }

    color4types(atypes) {
        // atypes is a list of set┼type┼annid strings
        let r = 0;
        let g = 0;
        let b = 0;
        let a = 0;
        for (let info of atypes.values()) {
            let fields = info.split(this.sep)
            let typ = fields[0] + this.sep + fields[1];
            let col = this.type2colour.get(typ);
            // console.log("Looked up color for "+typ+" got "+col)
            r += col[0];
            g += col[1];
            b += col[2];
            a += col[3];
        }
        r = Math.floor(r / atypes.size);
        g = Math.floor(g / atypes.size);
        b = Math.floor(b / atypes.size);
        a = a / atypes.size;
        // console.log("Final colors for len "+atypes.size+" r="+r+" g="+g)
        return [r, g, b, 1.0];
    }

    init() {
        let divcontent = $(this.id_text);
        $(divcontent).empty();
        let text = this.docrep.text;
        let thehtml = $.parseHTML(this.htmlEntities(text));
        $(divcontent).append(thehtml);

        // First of all, create the annotation chooser
        // create a form which contains:
        // for each annotation set create an a tag. followed by a div that contains all the checkbox fields
        let divchooser = $(this.id_chooser);
        $(divchooser).empty();
        let formchooser = $("<form>");
        for (let setname of this.docrep.setnames()) {
            let setname2show = setname;
            // TODO: add number of annotations in the set in parentheses
            if (setname == "") {
                setname2show = "[Default Set]"
            }
            // TODO: make what we show here configurable?
            $(formchooser).append($(document.createElement('div')).attr("class", this.id_hdr).append(setname2show))
            let div4set = document.createElement("div")
            // $(div4set).attr("id", setname);
            $(div4set).attr("style", "margin-bottom: 10px;");
            let colidx = 0
            for (let anntype of this.docrep.types4setname(setname)) {
                //console.log("Addingsss type " + anntype)
                let col = this.palette[colidx];
                this.type2colour.set(setname + this.sep + anntype, col);
                colidx = (colidx + 1) % this.palette.length;
                let lbl = $("<label>").attr({ "style": this.style4color(col), "class": this.class_label });
                let object = this
                let annhandler = function(ev) { docview_annchosen(object, ev, setname, anntype) }
                let inp = $('<input type="checkbox">').attr({ "type": "checkbox", "class": this.class_input, "data-anntype": anntype, "data-setname": setname}).on("click", annhandler)

                $(lbl).append(inp);
                $(lbl).append(anntype);
                // append the number of annotations in this set 
                let n = this.docrep.annids4snametype(setname, anntype).length;
                $(lbl).append(" (" + n + ")");
                $(div4set).append(lbl)
                $(div4set).append($("<br>"))
                $(divchooser).append(formchooser)
            }
            $(formchooser).append(div4set)
        }

        let obj = this;
        let feats = this.docrep["features"];
        docview_showDocFeatures(obj, feats);
        $(this.id_dochdr).text("Document:").on("click", function(ev) { docview_showDocFeatures(obj, feats) });

        this.buildAnns4Offset()
        this.buildContent()
    }

        set2list(theset) {
            let arr = new Array()
            for (var el of theset.values()) {
               arr[arr.length] = el
            }
            return arr
        }

        setsequal(set1, set2) {
            if (set1.size !== set2.size) return false;
            for (var el of set1) if (!set2.has(el)) return false;
            return true;
        }

    buildAnns4Offset() {
        // console.log("Running buildAnns4Offset")
        //this.anns4offset = new Array(this.docrep.text.length + 1);
        this.anns4offset = new Array()

        // for all the set/type combinations that have been selected ... 
        for (let [sname, atype] of this.chosen) {
            //console.log("sname/type: " + sname + "/" + atype);
            // get the list of annotations that match the given Setname and annotation type
            let anns = this.docrep.anns4settype(sname, atype);
            for (let ann of anns) {
                // console.log("processing ann: " + ann + " start=" + ann.start + " end=" + ann.end + " type=" + ann.type)
                // store the annotation setname/typename/annid for each offset of each annotation
                // to indicate the end of the annotation also store an empty list for the offset after the annotation 
                // unless we already have something there

                // trick for zero length annotations: show them as length one annotations for now
                var endoff = ann.end
                if (ann.start == ann.end) endoff = endoff+1
                for (let i = ann.start; i <= endoff; i++) { // iterate until one beyond the end of the ann
                    let have = this.anns4offset[i]
                    if (have == undefined) {                    
                      have = { "offset": i, "anns": new Set()}
                      this.anns4offset[i] = have
                    }
                    if (i < endoff) {
                        // append a new set/type tuple to the list of set/types at this offset
                        let tmp = this.anns4offset[i]["anns"];
                        let toadd = sname + this.sep + atype + this.sep + ann.id
                        // console.log("Trying to add "+toadd+" to "+this.set2list(tmp))
                        tmp = tmp.add(toadd); 
                        //console.log("is now "+this.set2list(tmp))
                        //console.log("entry for offset "+i+" is now " + this.set2list(this.anns4offset[i]["anns"]));
                    }
                }
            }
        }
        console.log("initial anns4Offset:")
        console.log(this.anns4offset)
        // now all offsets have a list of set/type and set/annid tuples
        // compress the list to only contain anything but undefined where it changes 
        let last = this.anns4offset[0]
        for (let i = 1; i < this.anns4offset.length; i++) {
            let cur = this.anns4offset[i]
            if (last == undefined && cur == undefined) {
                // console.log("Offset "+i+" both undefined")
                // nothing to do
            } else if (last == undefined && cur != undefined) {
                // we have a new list of annotations, keep it: nothing to do
                //console.log("Offset "+i+" last undefined, this one not")
            } else if (last != undefined && cur == undefined) {
                // we switch from some list of annotations to the empty list: 
                // add an empty entry
                //console.log("Offset "+i+" last one not undefined, this undefined, inserting empty list")
                this.anns4offset[i] = { "anns": new Set(), "offset": i}
            } else {
                // both offsets have annotations, but do the differ? we need to compare the types and annids
                // For now we do this by comparing the stringified representations
                let s1 = last["anns"]
                let s2 = cur["anns"]
                // console.log("Offset "+i+" Cur: "+this.set2list(s2)+" last: "+this.set2list(s1))
                if (this.setsequal(s1,s2)) {
                   // console.log("Detected equal")
                   this.anns4offset[i] = undefined
                }
            } 
            last = cur
        }
        // for debugging: deep copy the anns4offset data structure so we can later show in the debugger

        // console.log("compressed anns4Offset:")
        // console.log(this.anns4offset)

    }

    buildContent() {
        //console.log("Running buildContent");
        // got through all the offsets and check where the annotations change
        // start with the set of annotations in the first offset (empty if undefined) as lastset, calculate color for set
        // go through all subsequent offsets
        // when we find an entry where the annotations change:
        // * get the annotation setname/types 
        // * from the list of setname/types, determine a colour and store it
        // * generate the span from last to here 
        // after the end, generate the last span
        let spans = []
        let last = this.anns4offset[0];
        if (last == undefined) {
            last = { "anns": new Set(), "offset": 0 };
        }
        for (let i = 1; i < this.anns4offset.length; i++) {
            let info = this.anns4offset[i];
            if (info != undefined) {
                let txt = this.docrep.text.substring(last["offset"], info["offset"]);
                console.log("Got text: "+txt) 
                let span = undefined;
                if (last["anns"].size != 0) {
                    let col = this.color4types(last.anns);
                    let sty = this.style4color(col);
                    span = $('<span>').attr("style", sty);
                    let object = this;
                    let anns = last.anns;
                    let annhandler = function(ev) { docview_annsel(object, ev, anns) }
                    span.on("click", annhandler);
                    // console.log("Adding styled text for "+col+"/"+sty+" : "+txt)                    
                } else {
                    // console.log("Adding non-styled text "+txt)
                    span = $('<span>');
                }
                span.append($.parseHTML(this.htmlEntities(txt)));
                spans.push(span);
                last = info;
            }
        }
        let txt = this.docrep.text.substring(last["offset"], this.docrep.text.length);
        let span = undefined;
        // TODO: if we are already at the end, nothing needs to be done (prevent empty span from being added)
        if (last["anns"].length != 0) {
            let col = this.color4types(last.anns);
            let sty = this.style4color(col);
            // span = $('<span>').attr("style", sty).attr("data-anns", last.anns.join(","));
            span = $('<span>').attr("style", sty)
            let object = this;
            let anns = last.anns;
            let annhandler = function(ev) { docview_annsel(object, ev, anns) }
            span.on("click", annhandler);
            // console.log("Adding styled text for "+col+" : "+txt)
        } else {
            // console.log("Adding non-styled text "+txt)
            span = $('<span>');
        }
        span.append($.parseHTML(this.htmlEntities(txt)));
        spans.push(span);
        // TODO: end
        // Replace the content
        let divcontent = $(this.id_text);
        $(divcontent).empty();
        $(divcontent).append(spans);
    }

    htmlEntities(str) {
        return str.replaceAll('&', '&amp;').replaceAll('<', '&lt;').replaceAll('>', '&gt;').replaceAll('"', '&quot;').replaceAll("\n", '<br>');
    }
};
// console.log("Classes defined, defining gatenlp_run");
function gatenlp_run(prefix) {
    bdocjson = document.getElementById(prefix+"data").innerHTML;
    new gatenlpDocView(new gatenlpDocRep(bdocjson), prefix).init();
}
// console.log("Function defined");
</script>



<div><style>#TVNEQJRABJ-wrapper { color: black !important; }</style>
<div id="TVNEQJRABJ-wrapper">

<div>
<style>
#TVNEQJRABJ-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.TVNEQJRABJ-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.TVNEQJRABJ-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.TVNEQJRABJ-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.TVNEQJRABJ-label {
    margin-bottom: -15px;
    display: block;
}

.TVNEQJRABJ-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#TVNEQJRABJ-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.TVNEQJRABJ-selection {
    margin-bottom: 5px;
}

.TVNEQJRABJ-featuretable {
    margin-top: 10px;
}

.TVNEQJRABJ-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.TVNEQJRABJ-fvalue {
    text-align: left !important;
}
</style>
  <div id="TVNEQJRABJ-content">
        <div id="TVNEQJRABJ-popup" style="display: none;">
        </div>
        <div class="TVNEQJRABJ-row" id="TVNEQJRABJ-row1" style="max-height: 20em; min-height:5em;">
            <div id="TVNEQJRABJ-text-wrapper" class="TVNEQJRABJ-col" style="width:70%;">
                <div class="TVNEQJRABJ-hdr" id="TVNEQJRABJ-dochdr"></div>
                <div id="TVNEQJRABJ-text">
                </div>
            </div>
            <div id="TVNEQJRABJ-chooser" class="TVNEQJRABJ-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="TVNEQJRABJ-row" id="TVNEQJRABJ-row2" style="max-height: 14em; min-height: 3em;">
            <div id="TVNEQJRABJ-details" class="TVNEQJRABJ-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>

    <script type="application/json" id="TVNEQJRABJ-data">
    {"annotation_sets": {}, "text": "This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like \ud83d\ude3d (a kissing cat),\n\ud83d\udc69\u200d\ud83c\udfeb (a woman teacher), \ud83e\uddec (DNA), \n\ud83e\uddd7 (a person climbing), \n\ud83d\udca9 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul \ud55c\uae00 or \nsimplified Hanzi \u6c49\u5b57 or Farsi \u0641\u0627\u0631\u0633\u06cc which goes from right to left. \n\n\n", "features": {}, "offset_type": "j", "name": ""}
    </script>
    <script type="text/javascript">
        gatenlp_run("TVNEQJRABJ-");
    </script>
  </div>

</div></div>


This shows the document in a layout that has three areas: the document text in the upper left,
the list of annotation set and type names in the upper right and document or annotation features
at the bottom. In the example above only the text is shown because there are no document features or 
annotations. 

## Document features

Lets add some document features:


```python
doc.features["loaded-from"] = "https://gatenlp.github.io/python-gatenlp/testdocument1.txt"
doc.features["purpose"] = "test document for gatenlp"
doc.features["someotherfeature"] = 22
doc.features["andanother"] = {"what": "a dict", "alist": [1,2,3,4,5]}
```

Document features map feature names to feature values and behave a lot like a Python dictionary. Feature names
should always be strings, feature values can be anything, but a document can only be stored or exchanged with Java GATE if feature values are restricted to whatever can be serialized with JSON: dictionaries, lists, numbers, strings and booleans. 

Now that we have create document features the document is shown like this:


```python
doc
```




<div><style>#RDNLELEITJ-wrapper { color: black !important; }</style>
<div id="RDNLELEITJ-wrapper">

<div>
<style>
#RDNLELEITJ-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.RDNLELEITJ-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.RDNLELEITJ-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.RDNLELEITJ-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.RDNLELEITJ-label {
    margin-bottom: -15px;
    display: block;
}

.RDNLELEITJ-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#RDNLELEITJ-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.RDNLELEITJ-selection {
    margin-bottom: 5px;
}

.RDNLELEITJ-featuretable {
    margin-top: 10px;
}

.RDNLELEITJ-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.RDNLELEITJ-fvalue {
    text-align: left !important;
}
</style>
  <div id="RDNLELEITJ-content">
        <div id="RDNLELEITJ-popup" style="display: none;">
        </div>
        <div class="RDNLELEITJ-row" id="RDNLELEITJ-row1" style="max-height: 20em; min-height:5em;">
            <div id="RDNLELEITJ-text-wrapper" class="RDNLELEITJ-col" style="width:70%;">
                <div class="RDNLELEITJ-hdr" id="RDNLELEITJ-dochdr"></div>
                <div id="RDNLELEITJ-text">
                </div>
            </div>
            <div id="RDNLELEITJ-chooser" class="RDNLELEITJ-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="RDNLELEITJ-row" id="RDNLELEITJ-row2" style="max-height: 14em; min-height: 3em;">
            <div id="RDNLELEITJ-details" class="RDNLELEITJ-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>

    <script type="application/json" id="RDNLELEITJ-data">
    {"annotation_sets": {}, "text": "This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like \ud83d\ude3d (a kissing cat),\n\ud83d\udc69\u200d\ud83c\udfeb (a woman teacher), \ud83e\uddec (DNA), \n\ud83e\uddd7 (a person climbing), \n\ud83d\udca9 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul \ud55c\uae00 or \nsimplified Hanzi \u6c49\u5b57 or Farsi \u0641\u0627\u0631\u0633\u06cc which goes from right to left. \n\n\n", "features": {"loaded-from": "https://gatenlp.github.io/python-gatenlp/testdocument1.txt", "purpose": "test document for gatenlp", "someotherfeature": 22, "andanother": {"what": "a dict", "alist": [1, 2, 3, 4, 5]}}, "offset_type": "j", "name": ""}
    </script>
    <script type="text/javascript">
        gatenlp_run("RDNLELEITJ-");
    </script>
  </div>

</div></div>




```python
# to retrieve a feature value we can do:
doc.features["purpose"]
```




    'test document for gatenlp'




```python
# If a feature does not exist, None is returned or a default value if specified:
print(doc.features.get("doesntexist"))
print(doc.features.get("doesntexist", "MV!"))

```

    None
    MV!


## Annotations

Lets add some annotations too. Annotations are items of information for some range of characters within the document. They can be used to represent information about things like tokens, entities, sentences, paragraphs, or 
anything that corresponds to some contiguous range of offsets in the document.

Annotations consist of the following parts:
* The "start" and "end" offset to identify the text the annotation refers to
* A "type" which is an arbitrary name that identifies what kind of thing the annotation describes, e.g. "Token"
* Features: these work in the same way as for the whole document: an arbitrary set of feature name / feature value
  pairs which provide more information, e.g. for a Token the features could include the lemma, the part of speech,
  the stem, the number, etc. 

Annotations can be organized in "annotation sets". Each annotation set has a name and a set of annotations. There can be as many sets as needed. 

Annotation can overlap arbitrarily and there can be as many as needed. 

Let us manually add a few annotations to the document:


```python
# create and get an annotation set with the name "Set1"
annset = doc.annset("Set1")
```

Add an annotation to the set which refers to the first word in the document "This". The range of characters
for this word starts at offset 0 and the length of the annotation is 4, so the "start" offset is 0 and the "end" offset is 0+4=4. Note that the end offset always points to the offset *after* the last character of the range.


```python
annset.add(0,4,"Word",{"what": "our first annotation"})
```




    Annotation(0,4,Word,features=Features({'what': 'our first annotation'}),id=0)




```python
# Add more
annset.add(5,7,"Word",{"what": "our second annotation"})
annset.add(0,24,"Sentence",{"what": "our first sentence annotation"})
```




    Annotation(0,24,Sentence,features=Features({'what': 'our first sentence annotation'}),id=2)



If we visualize the document now, the newly created set "Set" is shown in the right part of
the display. It shows the different annotation types that exist in the set, and how many annotations
for each type are in the set. If you click the check box, the annotation ranges are shown in the 
text with the colour associated with the annotation type. You can then click on a range / annotation in the
text and the features of the annotation are shown in the lower part. 
To show the features for a different annotation click on the coloured range for the annotation in the text.
To show the document features, click on "Document".

If you have selected more than one type, a range can have more than one overlapping annotations. 
This is shown by mixing the colours. If you click at such a location, a dialog appears which lets you
select for which of the overlapping annotations you want to display the features. 


```python
doc
```




<div><style>#LWVSUGDYPR-wrapper { color: black !important; }</style>
<div id="LWVSUGDYPR-wrapper">

<div>
<style>
#LWVSUGDYPR-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.LWVSUGDYPR-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.LWVSUGDYPR-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.LWVSUGDYPR-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.LWVSUGDYPR-label {
    margin-bottom: -15px;
    display: block;
}

.LWVSUGDYPR-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#LWVSUGDYPR-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.LWVSUGDYPR-selection {
    margin-bottom: 5px;
}

.LWVSUGDYPR-featuretable {
    margin-top: 10px;
}

.LWVSUGDYPR-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.LWVSUGDYPR-fvalue {
    text-align: left !important;
}
</style>
  <div id="LWVSUGDYPR-content">
        <div id="LWVSUGDYPR-popup" style="display: none;">
        </div>
        <div class="LWVSUGDYPR-row" id="LWVSUGDYPR-row1" style="max-height: 20em; min-height:5em;">
            <div id="LWVSUGDYPR-text-wrapper" class="LWVSUGDYPR-col" style="width:70%;">
                <div class="LWVSUGDYPR-hdr" id="LWVSUGDYPR-dochdr"></div>
                <div id="LWVSUGDYPR-text">
                </div>
            </div>
            <div id="LWVSUGDYPR-chooser" class="LWVSUGDYPR-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="LWVSUGDYPR-row" id="LWVSUGDYPR-row2" style="max-height: 14em; min-height: 3em;">
            <div id="LWVSUGDYPR-details" class="LWVSUGDYPR-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>

    <script type="application/json" id="LWVSUGDYPR-data">
    {"annotation_sets": {"Set1": {"name": "detached-from:Set1", "annotations": [{"type": "Word", "start": 0, "end": 4, "id": 0, "features": {"what": "our first annotation"}}, {"type": "Word", "start": 5, "end": 7, "id": 1, "features": {"what": "our second annotation"}}, {"type": "Sentence", "start": 0, "end": 24, "id": 2, "features": {"what": "our first sentence annotation"}}], "next_annid": 3}}, "text": "This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like \ud83d\ude3d (a kissing cat),\n\ud83d\udc69\u200d\ud83c\udfeb (a woman teacher), \ud83e\uddec (DNA), \n\ud83e\uddd7 (a person climbing), \n\ud83d\udca9 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul \ud55c\uae00 or \nsimplified Hanzi \u6c49\u5b57 or Farsi \u0641\u0627\u0631\u0633\u06cc which goes from right to left. \n\n\n", "features": {"loaded-from": "https://gatenlp.github.io/python-gatenlp/testdocument1.txt", "purpose": "test document for gatenlp", "someotherfeature": 22, "andanother": {"what": "a dict", "alist": [1, 2, 3, 4, 5]}}, "offset_type": "j", "name": ""}
    </script>
    <script type="text/javascript">
        gatenlp_run("LWVSUGDYPR-");
    </script>
  </div>

</div></div>



# Loading a larger document

Lets load a larger document, and from an HTML file: the Wikipedia page for "Natural Language processing":




```python
doc2 = Document.load("https://en.m.wikipedia.org/wiki/Natural_language_processing", fmt="html", parser="html.parser")
doc2
```




<div><style>#WALXCKLHJN-wrapper { color: black !important; }</style>
<div id="WALXCKLHJN-wrapper">

<div>
<style>
#WALXCKLHJN-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.WALXCKLHJN-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.WALXCKLHJN-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.WALXCKLHJN-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.WALXCKLHJN-label {
    margin-bottom: -15px;
    display: block;
}

.WALXCKLHJN-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#WALXCKLHJN-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.WALXCKLHJN-selection {
    margin-bottom: 5px;
}

.WALXCKLHJN-featuretable {
    margin-top: 10px;
}

.WALXCKLHJN-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.WALXCKLHJN-fvalue {
    text-align: left !important;
}
</style>
  <div id="WALXCKLHJN-content">
        <div id="WALXCKLHJN-popup" style="display: none;">
        </div>
        <div class="WALXCKLHJN-row" id="WALXCKLHJN-row1" style="max-height: 20em; min-height:5em;">
            <div id="WALXCKLHJN-text-wrapper" class="WALXCKLHJN-col" style="width:70%;">
                <div class="WALXCKLHJN-hdr" id="WALXCKLHJN-dochdr"></div>
                <div id="WALXCKLHJN-text">
                </div>
            </div>
            <div id="WALXCKLHJN-chooser" class="WALXCKLHJN-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="WALXCKLHJN-row" id="WALXCKLHJN-row2" style="max-height: 14em; min-height: 3em;">
            <div id="WALXCKLHJN-details" class="WALXCKLHJN-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>

    <script type="application/json" id="WALXCKLHJN-data">
    {"annotation_sets": {"Original markups": {"name": "detached-from:Original markups", "annotations": [{"type": "[document]", "start": 0, "end": 36792, "id": 0, "features": {}}, {"type": "html", "start": 1, "end": 36792, "id": 1, "features": {"class": "client-nojs", "lang": "en", "dir": "ltr"}}, {"type": "head", "start": 1, "end": 41, "id": 2, "features": {}}, {"type": "meta", "start": 1, "end": 1, "id": 3, "features": {"charset": "UTF-8"}}, {"type": "title", "start": 1, "end": 40, "id": 4, "features": {}}, {"type": "link", "start": 41, "end": 41, "id": 5, "features": {"rel": "stylesheet", "href": "/w/load.php?lang=en&modules=ext.cite.styles%7Cext.math.styles%7Cext.wikimediaBadges%7Cmediawiki.hlist%7Cmediawiki.ui.button%2Cicon%7Cmobile.init.styles%7Cskins.minerva.base.styles%7Cskins.minerva.content.styles%7Cskins.minerva.content.styles.images%7Cskins.minerva.icons.wikimedia%7Cskins.minerva.mainMenu.icons%2Cstyles&only=styles&skin=minerva"}}, {"type": "meta", "start": 41, "end": 41, "id": 6, "features": {"name": "generator", "content": "MediaWiki 1.36.0-wmf.16"}}, {"type": "meta", "start": 41, "end": 41, "id": 7, "features": {"name": "referrer", "content": "origin"}}, {"type": "meta", "start": 41, "end": 41, "id": 8, "features": {"name": "referrer", "content": "origin-when-crossorigin"}}, {"type": "meta", "start": 41, "end": 41, "id": 9, "features": {"name": "referrer", "content": "origin-when-cross-origin"}}, {"type": "meta", "start": 41, "end": 41, "id": 10, "features": {"name": "theme-color", "content": "#eaecf0"}}, {"type": "meta", "start": 41, "end": 41, "id": 11, "features": {"property": "og:image", "content": "https://upload.wikimedia.org/wikipedia/commons/8/8b/Automated_online_assistant.png"}}, {"type": "meta", "start": 41, "end": 41, "id": 12, "features": {"name": "viewport", "content": "width=device-width, initial-scale=1.0, user-scalable=yes, minimum-scale=0.25, maximum-scale=5.0"}}, {"type": "link", "start": 41, "end": 41, "id": 13, "features": {"rel": "preconnect", "href": "//upload.wikimedia.org"}}, {"type": "link", "start": 41, "end": 41, "id": 14, "features": {"rel": "manifest", "href": "/w/api.php?action=webapp-manifest"}}, {"type": "link", "start": 41, "end": 41, "id": 15, "features": {"rel": "alternate", "type": "application/x-wiki", "title": "Edit this page", "href": "/w/index.php?title=Natural_language_processing&action=edit"}}, {"type": "link", "start": 41, "end": 41, "id": 16, "features": {"rel": "edit", "title": "Edit this page", "href": "/w/index.php?title=Natural_language_processing&action=edit"}}, {"type": "link", "start": 41, "end": 41, "id": 17, "features": {"rel": "apple-touch-icon", "href": "/static/apple-touch/wikipedia.png"}}, {"type": "link", "start": 41, "end": 41, "id": 18, "features": {"rel": "shortcut icon", "href": "/static/favicon/wikipedia.ico"}}, {"type": "link", "start": 41, "end": 41, "id": 19, "features": {"rel": "search", "type": "application/opensearchdescription+xml", "href": "/w/opensearch_desc.php", "title": "Wikipedia (en)"}}, {"type": "link", "start": 41, "end": 41, "id": 20, "features": {"rel": "EditURI", "type": "application/rsd+xml", "href": "//en.wikipedia.org/w/api.php?action=rsd"}}, {"type": "link", "start": 41, "end": 41, "id": 21, "features": {"rel": "license", "href": "//creativecommons.org/licenses/by-sa/3.0/"}}, {"type": "link", "start": 41, "end": 41, "id": 22, "features": {"rel": "canonical", "href": "https://en.wikipedia.org/wiki/Natural_language_processing"}}, {"type": "link", "start": 41, "end": 41, "id": 23, "features": {"rel": "dns-prefetch", "href": "//login.wikimedia.org"}}, {"type": "link", "start": 41, "end": 41, "id": 24, "features": {"rel": "dns-prefetch", "href": "//meta.wikimedia.org"}}, {"type": "body", "start": 41, "end": 36792, "id": 25, "features": {"class": "mediawiki ltr sitedir-ltr mw-hide-empty-elt ns-0 ns-subject mw-editable page-Natural_language_processing rootpage-Natural_language_processing stable issues-group-B skin-minerva action-view skin--responsive"}}, {"type": "div", "start": 41, "end": 36792, "id": 26, "features": {"id": "mw-mf-viewport"}}, {"type": "div", "start": 41, "end": 36792, "id": 27, "features": {"id": "mw-mf-page-center"}}, {"type": "a", "start": 41, "end": 41, "id": 28, "features": {"class": "mw-mf-page-center__mask", "href": "#"}}, {"type": "header", "start": 41, "end": 133, "id": 29, "features": {"class": "header-container header-chrome"}}, {"type": "form", "start": 41, "end": 133, "id": 30, "features": {"class": "header", "action": "/w/index.php", "method": "get"}}, {"type": "nav", "start": 41, "end": 126, "id": 31, "features": {"class": "navigation-drawer toggle-list view-border-box"}}, {"type": "input", "start": 41, "end": 41, "id": 32, "features": {"type": "checkbox", "id": "main-menu-input", "class": "toggle-list__checkbox", "role": "button", "aria-labelledby": "mw-mf-main-menu-button"}}, {"type": "label", "start": 41, "end": 55, "id": 33, "features": {"for": "main-menu-input", "id": "mw-mf-main-menu-button", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-menu-base20 mw-ui-icon-flush-left toggle-list__toggle", "title": "Open main menu", "data-event-name": "ui.mainmenu"}}, {"type": "div", "start": 56, "end": 126, "id": 34, "features": {"id": "mw-mf-page-left", "class": "menu toggle-list__list view-border-box"}}, {"type": "ul", "start": 56, "end": 75, "id": 35, "features": {"id": "p-navigation"}}, {"type": "li", "start": 56, "end": 61, "id": 36, "features": {"class": ""}}, {"type": "a", "start": 56, "end": 60, "id": 37, "features": {"href": "/wiki/Main_Page", "class": "mw-ui-icon mw-ui-icon-before mw-ui-icon-minerva-home", "data-event-name": "menu.home"}}, {"type": "span", "start": 56, "end": 60, "id": 38, "features": {}}, {"type": "li", "start": 61, "end": 68, "id": 39, "features": {"class": ""}}, {"type": "a", "start": 61, "end": 67, "id": 40, "features": {"href": "/wiki/Special:Random#/random", "class": "mw-ui-icon mw-ui-icon-before mw-ui-icon-minerva-die ", "data-event-name": "menu.random"}}, {"type": "span", "start": 61, "end": 67, "id": 41, "features": {}}, {"type": "li", "start": 68, "end": 75, "id": 42, "features": {"class": "jsonly"}}, {"type": "a", "start": 68, "end": 74, "id": 43, "features": {"href": "/wiki/Special:Nearby", "class": "mw-ui-icon mw-ui-icon-before mw-ui-icon-minerva-mapPin nearby", "data-event-name": "menu.nearby"}}, {"type": "span", "start": 68, "end": 74, "id": 44, "features": {}}, {"type": "ul", "start": 75, "end": 82, "id": 45, "features": {"id": "p-personal"}}, {"type": "li", "start": 75, "end": 82, "id": 46, "features": {"class": ""}}, {"type": "a", "start": 75, "end": 81, "id": 47, "features": {"href": "/w/index.php?title=Special:UserLogin&returnto=Natural+language+processing", "class": "menu__item--login mw-ui-icon mw-ui-icon-before mw-ui-icon-minerva-logIn ", "data-event-name": "menu.login"}}, {"type": "span", "start": 75, "end": 81, "id": 48, "features": {}}, {"type": "ul", "start": 82, "end": 91, "id": 49, "features": {"id": "pt-preferences"}}, {"type": "li", "start": 82, "end": 91, "id": 50, "features": {"class": "jsonly"}}, {"type": "a", "start": 82, "end": 90, "id": 51, "features": {"href": "/w/index.php?title=Special:MobileOptions&returnto=Natural+language+processing", "class": "menu__item--settings mw-ui-icon mw-ui-icon-before mw-ui-icon-minerva-settings ", "data-event-name": "menu.settings"}}, {"type": "span", "start": 82, "end": 90, "id": 52, "features": {}}, {"type": "ul", "start": 91, "end": 98, "id": 53, "features": {"id": "p-donation"}}, {"type": "li", "start": 91, "end": 98, "id": 54, "features": {"class": ""}}, {"type": "a", "start": 91, "end": 97, "id": 55, "features": {"href": "https://donate.wikimedia.org/wiki/Special:FundraiserRedirector?utm_source=donate&utm_medium=sidebar&utm_campaign=C13_en.wikipedia.org&uselang=en&utm_key=minerva", "class": "mw-ui-icon mw-ui-icon-before mw-ui-icon-minerva-heart ", "data-event-name": "menu.donate"}}, {"type": "span", "start": 91, "end": 97, "id": 56, "features": {}}, {"type": "ul", "start": 98, "end": 126, "id": 57, "features": {"class": "hlist"}}, {"type": "li", "start": 98, "end": 114, "id": 58, "features": {"class": ""}}, {"type": "a", "start": 98, "end": 113, "id": 59, "features": {"href": "/wiki/Wikipedia:About", "class": "", "data-event-name": ""}}, {"type": "span", "start": 98, "end": 113, "id": 60, "features": {}}, {"type": "li", "start": 114, "end": 126, "id": 61, "features": {"class": ""}}, {"type": "a", "start": 114, "end": 125, "id": 62, "features": {"href": "/wiki/Wikipedia:General_disclaimer", "class": "", "data-event-name": ""}}, {"type": "span", "start": 114, "end": 125, "id": 63, "features": {}}, {"type": "label", "start": 126, "end": 126, "id": 64, "features": {"class": "main-menu-mask", "for": "main-menu-input"}}, {"type": "div", "start": 126, "end": 126, "id": 65, "features": {"class": "branding-box"}}, {"type": "a", "start": 126, "end": 126, "id": 66, "features": {"href": "/wiki/Main_Page"}}, {"type": "span", "start": 126, "end": 126, "id": 67, "features": {}}, {"type": "img", "start": 126, "end": 126, "id": 68, "features": {"src": "/static/images/mobile/copyright/wikipedia-wordmark-en.svg", "width": "119", "height": "18"}}, {"type": "div", "start": 126, "end": 126, "id": 69, "features": {"class": "search-box"}}, {"type": "input", "start": 126, "end": 126, "id": 70, "features": {"class": "search mw-ui-background-icon-search skin-minerva-search-trigger", "type": "search", "name": "search", "id": "searchInput", "autocomplete": "off", "placeholder": "Search Wikipedia", "aria-label": "Search Wikipedia", "value": ""}}, {"type": "nav", "start": 126, "end": 133, "id": 71, "features": {"class": "minerva-user-navigation", "aria-label": "User navigation"}}, {"type": "div", "start": 126, "end": 133, "id": 72, "features": {}}, {"type": "button", "start": 126, "end": 132, "id": 73, "features": {"id": "searchIcon", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-search-base20 skin-minerva-search-trigger", "type": "submit"}}, {"type": "main", "start": 133, "end": 36226, "id": 74, "features": {"id": "content", "class": "mw-body"}}, {"type": "div", "start": 133, "end": 133, "id": 75, "features": {"class": "banner-container"}}, {"type": "div", "start": 133, "end": 133, "id": 76, "features": {"id": "siteNotice"}}, {"type": "div", "start": 133, "end": 181, "id": 77, "features": {"class": "pre-content heading-holder"}}, {"type": "div", "start": 133, "end": 161, "id": 78, "features": {"class": "page-heading"}}, {"type": "h1", "start": 133, "end": 161, "id": 79, "features": {"id": "section_0"}}, {"type": "div", "start": 161, "end": 161, "id": 80, "features": {"class": "tagline"}}, {"type": "nav", "start": 161, "end": 181, "id": 81, "features": {"class": "page-actions-menu"}}, {"type": "ul", "start": 161, "end": 181, "id": 82, "features": {"id": "page-actions", "class": "page-actions-menu__list"}}, {"type": "li", "start": 161, "end": 170, "id": 83, "features": {"id": "language-selector", "class": "page-actions-menu__list-item"}}, {"type": "a", "start": 161, "end": 169, "id": 84, "features": {"id": "", "href": "/wiki/Special:MobileLanguages/Natural_language_processing", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-language-base20 mw-ui-icon-with-label-desktop language-selector", "data-mw": "interface", "data-event-name": "menu.languages", "role": "button", "title": "Language"}}, {"type": "li", "start": 170, "end": 176, "id": 85, "features": {"id": "page-actions-watch", "class": "page-actions-menu__list-item"}}, {"type": "a", "start": 170, "end": 175, "id": 86, "features": {"id": "ca-watch", "href": "/w/index.php?title=Special:UserLogin&returnto=Natural+language+processing", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-star-base20 mw-ui-icon-with-label-desktop watch-this-article mw-watchlink menu__item--page-actions-watch", "data-mw": "interface", "data-event-name": "menu.watch", "role": "button", "title": "Watch"}}, {"type": "li", "start": 176, "end": 181, "id": 87, "features": {"id": "page-actions-edit", "class": "page-actions-menu__list-item"}}, {"type": "a", "start": 176, "end": 180, "id": 88, "features": {"id": "ca-edit", "href": "/w/index.php?title=Natural_language_processing&action=edit&section=0", "class": "edit-page menu__item--page-actions-edit mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 mw-ui-icon-with-label-desktop", "data-mw": "interface", "data-event-name": "menu.edit", "role": "button", "title": "Edit the lead section of this page"}}, {"type": "div", "start": 181, "end": 181, "id": 89, "features": {"class": "minerva__subtitle"}}, {"type": "div", "start": 181, "end": 36226, "id": 90, "features": {"id": "bodyContent", "class": "content"}}, {"type": "div", "start": 181, "end": 36121, "id": 91, "features": {"id": "mw-content-text", "lang": "en", "dir": "ltr", "class": "mw-content-ltr"}}, {"type": "div", "start": 181, "end": 36121, "id": 92, "features": {"class": "mw-parser-output"}}, {"type": "section", "start": 181, "end": 1346, "id": 93, "features": {"class": "mf-section-0", "id": "mf-section-0"}}, {"type": "p", "start": 181, "end": 463, "id": 94, "features": {}}, {"type": "b", "start": 181, "end": 208, "id": 95, "features": {}}, {"type": "b", "start": 210, "end": 213, "id": 96, "features": {}}, {"type": "a", "start": 232, "end": 243, "id": 97, "features": {"href": "/wiki/Linguistics", "title": "Linguistics"}}, {"type": "a", "start": 245, "end": 261, "id": 98, "features": {"href": "/wiki/Computer_science", "title": "Computer science"}}, {"type": "a", "start": 267, "end": 290, "id": 99, "features": {"href": "/wiki/Artificial_intelligence", "title": "Artificial intelligence"}}, {"type": "a", "start": 440, "end": 456, "id": 100, "features": {"href": "/wiki/Natural_language", "title": "Natural language"}}, {"type": "div", "start": 463, "end": 625, "id": 101, "features": {"class": "thumb tright"}}, {"type": "div", "start": 463, "end": 625, "id": 102, "features": {"class": "thumbinner", "style": "width:202px;"}}, {"type": "a", "start": 463, "end": 463, "id": 103, "features": {"href": "/wiki/File:Automated_online_assistant.png", "class": "image"}}, {"type": "img", "start": 463, "end": 463, "id": 104, "features": {"alt": "", "src": "//upload.wikimedia.org/wikipedia/commons/thumb/8/8b/Automated_online_assistant.png/200px-Automated_online_assistant.png", "decoding": "async", "width": "200", "height": "251", "class": "thumbimage", "data-file-width": "400", "data-file-height": "501"}}, {"type": "div", "start": 465, "end": 625, "id": 105, "features": {"class": "thumbcaption"}}, {"type": "div", "start": 465, "end": 465, "id": 106, "features": {"class": "magnify"}}, {"type": "a", "start": 465, "end": 465, "id": 107, "features": {"href": "/wiki/File:Automated_online_assistant.png", "class": "internal", "title": "Enlarge"}}, {"type": "a", "start": 468, "end": 494, "id": 108, "features": {"href": "/wiki/Automated_online_assistant", "class": "mw-redirect", "title": "Automated online assistant"}}, {"type": "a", "start": 505, "end": 521, "id": 109, "features": {"href": "/wiki/Customer_service", "title": "Customer service"}}, {"type": "sup", "start": 621, "end": 624, "id": 110, "features": {"id": "cite_ref-Kongthon_1-0", "class": "reference"}}, {"type": "a", "start": 621, "end": 624, "id": 111, "features": {"href": "#cite_note-Kongthon-1"}}, {"type": "p", "start": 625, "end": 771, "id": 112, "features": {}}, {"type": "a", "start": 686, "end": 704, "id": 113, "features": {"href": "/wiki/Speech_recognition", "title": "Speech recognition"}}, {"type": "a", "start": 706, "end": 736, "id": 114, "features": {"href": "/wiki/Natural_language_understanding", "class": "mw-redirect", "title": "Natural language understanding"}}, {"type": "a", "start": 742, "end": 769, "id": 115, "features": {"href": "/wiki/Natural-language_generation", "title": "Natural-language generation"}}, {"type": "div", "start": 771, "end": 1346, "id": 116, "features": {"id": "toc", "class": "toc", "role": "navigation", "aria-labelledby": "mw-toc-heading"}}, {"type": "input", "start": 771, "end": 771, "id": 117, "features": {"type": "checkbox", "role": "button", "id": "toctogglecheckbox", "class": "toctogglecheckbox", "style": "display:none"}}, {"type": "div", "start": 771, "end": 780, "id": 118, "features": {"class": "toctitle", "lang": "en", "dir": "ltr"}}, {"type": "h2", "start": 771, "end": 780, "id": 119, "features": {"id": "mw-toc-heading"}}, {"type": "span", "start": 780, "end": 780, "id": 120, "features": {"class": "toctogglespan"}}, {"type": "label", "start": 780, "end": 780, "id": 121, "features": {"class": "toctogglelabel", "for": "toctogglecheckbox"}}, {"type": "ul", "start": 780, "end": 1346, "id": 122, "features": {}}, {"type": "li", "start": 780, "end": 890, "id": 123, "features": {"class": "toclevel-1 tocsection-1"}}, {"type": "a", "start": 780, "end": 789, "id": 124, "features": {"href": "#History"}}, {"type": "span", "start": 780, "end": 781, "id": 125, "features": {"class": "tocnumber"}}, {"type": "span", "start": 782, "end": 789, "id": 126, "features": {"class": "toctext"}}, {"type": "ul", "start": 790, "end": 890, "id": 127, "features": {}}, {"type": "li", "start": 790, "end": 829, "id": 128, "features": {"class": "toclevel-2 tocsection-2"}}, {"type": "a", "start": 790, "end": 828, "id": 129, "features": {"href": "#Symbolic_NLP_(1950s_-_early_1990s)"}}, {"type": "span", "start": 790, "end": 793, "id": 130, "features": {"class": "tocnumber"}}, {"type": "span", "start": 794, "end": 828, "id": 131, "features": {"class": "toctext"}}, {"type": "li", "start": 829, "end": 865, "id": 132, "features": {"class": "toclevel-2 tocsection-3"}}, {"type": "a", "start": 829, "end": 864, "id": 133, "features": {"href": "#Statistical_NLP_(1990s_-_2010s)"}}, {"type": "span", "start": 829, "end": 832, "id": 134, "features": {"class": "tocnumber"}}, {"type": "span", "start": 833, "end": 864, "id": 135, "features": {"class": "toctext"}}, {"type": "li", "start": 865, "end": 890, "id": 136, "features": {"class": "toclevel-2 tocsection-4"}}, {"type": "a", "start": 865, "end": 889, "id": 137, "features": {"href": "#Neural_NLP_(present)"}}, {"type": "span", "start": 865, "end": 868, "id": 138, "features": {"class": "tocnumber"}}, {"type": "span", "start": 869, "end": 889, "id": 139, "features": {"class": "toctext"}}, {"type": "li", "start": 890, "end": 980, "id": 140, "features": {"class": "toclevel-1 tocsection-5"}}, {"type": "a", "start": 890, "end": 935, "id": 141, "features": {"href": "#Methods:_Rules,_statistics,_neural_networks"}}, {"type": "span", "start": 890, "end": 891, "id": 142, "features": {"class": "tocnumber"}}, {"type": "span", "start": 892, "end": 935, "id": 143, "features": {"class": "toctext"}}, {"type": "ul", "start": 936, "end": 980, "id": 144, "features": {}}, {"type": "li", "start": 936, "end": 960, "id": 145, "features": {"class": "toclevel-2 tocsection-6"}}, {"type": "a", "start": 936, "end": 959, "id": 146, "features": {"href": "#Statistical_methods"}}, {"type": "span", "start": 936, "end": 939, "id": 147, "features": {"class": "tocnumber"}}, {"type": "span", "start": 940, "end": 959, "id": 148, "features": {"class": "toctext"}}, {"type": "li", "start": 960, "end": 980, "id": 149, "features": {"class": "toclevel-2 tocsection-7"}}, {"type": "a", "start": 960, "end": 979, "id": 150, "features": {"href": "#Neural_networks"}}, {"type": "span", "start": 960, "end": 963, "id": 151, "features": {"class": "tocnumber"}}, {"type": "span", "start": 964, "end": 979, "id": 152, "features": {"class": "toctext"}}, {"type": "li", "start": 980, "end": 1284, "id": 153, "features": {"class": "toclevel-1 tocsection-8"}}, {"type": "a", "start": 980, "end": 998, "id": 154, "features": {"href": "#Common_NLP_Tasks"}}, {"type": "span", "start": 980, "end": 981, "id": 155, "features": {"class": "tocnumber"}}, {"type": "span", "start": 982, "end": 998, "id": 156, "features": {"class": "toctext"}}, {"type": "ul", "start": 999, "end": 1284, "id": 157, "features": {}}, {"type": "li", "start": 999, "end": 1030, "id": 158, "features": {"class": "toclevel-2 tocsection-9"}}, {"type": "a", "start": 999, "end": 1029, "id": 159, "features": {"href": "#Text_and_speech_processing"}}, {"type": "span", "start": 999, "end": 1002, "id": 160, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1003, "end": 1029, "id": 161, "features": {"class": "toctext"}}, {"type": "li", "start": 1030, "end": 1057, "id": 162, "features": {"class": "toclevel-2 tocsection-10"}}, {"type": "a", "start": 1030, "end": 1056, "id": 163, "features": {"href": "#Morphological_analysis"}}, {"type": "span", "start": 1030, "end": 1033, "id": 164, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1034, "end": 1056, "id": 165, "features": {"class": "toctext"}}, {"type": "li", "start": 1057, "end": 1080, "id": 166, "features": {"class": "toclevel-2 tocsection-11"}}, {"type": "a", "start": 1057, "end": 1079, "id": 167, "features": {"href": "#Syntactic_analysis"}}, {"type": "span", "start": 1057, "end": 1060, "id": 168, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1061, "end": 1079, "id": 169, "features": {"class": "toctext"}}, {"type": "li", "start": 1080, "end": 1135, "id": 170, "features": {"class": "toclevel-2 tocsection-12"}}, {"type": "a", "start": 1080, "end": 1134, "id": 171, "features": {"href": "#Lexical_semantics_(of_individual_words_in_context)"}}, {"type": "span", "start": 1080, "end": 1083, "id": 172, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1084, "end": 1134, "id": 173, "features": {"class": "toctext"}}, {"type": "li", "start": 1135, "end": 1196, "id": 174, "features": {"class": "toclevel-2 tocsection-13"}}, {"type": "a", "start": 1135, "end": 1195, "id": 175, "features": {"href": "#Relational_semantics_(semantics_of_individual_sentences)"}}, {"type": "span", "start": 1135, "end": 1138, "id": 176, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1139, "end": 1195, "id": 177, "features": {"class": "toctext"}}, {"type": "li", "start": 1196, "end": 1250, "id": 178, "features": {"class": "toclevel-2 tocsection-14"}}, {"type": "a", "start": 1196, "end": 1249, "id": 179, "features": {"href": "#Discourse_(semantics_beyond_individual_sentences)"}}, {"type": "span", "start": 1196, "end": 1199, "id": 180, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1200, "end": 1249, "id": 181, "features": {"class": "toctext"}}, {"type": "li", "start": 1250, "end": 1284, "id": 182, "features": {"class": "toclevel-2 tocsection-15"}}, {"type": "a", "start": 1250, "end": 1283, "id": 183, "features": {"href": "#Higher-level_NLP_applications"}}, {"type": "span", "start": 1250, "end": 1253, "id": 184, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1254, "end": 1283, "id": 185, "features": {"class": "toctext"}}, {"type": "li", "start": 1284, "end": 1304, "id": 186, "features": {"class": "toclevel-1 tocsection-16"}}, {"type": "a", "start": 1284, "end": 1303, "id": 187, "features": {"href": "#Cognition_and_NLP"}}, {"type": "span", "start": 1284, "end": 1285, "id": 188, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1286, "end": 1303, "id": 189, "features": {"class": "toctext"}}, {"type": "li", "start": 1304, "end": 1315, "id": 190, "features": {"class": "toclevel-1 tocsection-17"}}, {"type": "a", "start": 1304, "end": 1314, "id": 191, "features": {"href": "#See_also"}}, {"type": "span", "start": 1304, "end": 1305, "id": 192, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1306, "end": 1314, "id": 193, "features": {"class": "toctext"}}, {"type": "li", "start": 1315, "end": 1328, "id": 194, "features": {"class": "toclevel-1 tocsection-18"}}, {"type": "a", "start": 1315, "end": 1327, "id": 195, "features": {"href": "#References"}}, {"type": "span", "start": 1315, "end": 1316, "id": 196, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1317, "end": 1327, "id": 197, "features": {"class": "toctext"}}, {"type": "li", "start": 1328, "end": 1346, "id": 198, "features": {"class": "toclevel-1 tocsection-19"}}, {"type": "a", "start": 1328, "end": 1345, "id": 199, "features": {"href": "#Further_reading"}}, {"type": "span", "start": 1328, "end": 1329, "id": 200, "features": {"class": "tocnumber"}}, {"type": "span", "start": 1330, "end": 1345, "id": 201, "features": {"class": "toctext"}}, {"type": "h2", "start": 1346, "end": 1358, "id": 202, "features": {"class": "section-heading", "onclick": "javascript:mfTempOpenSection(1)"}}, {"type": "div", "start": 1346, "end": 1346, "id": 203, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left"}}, {"type": "span", "start": 1346, "end": 1353, "id": 204, "features": {"class": "mw-headline", "id": "History"}}, {"type": "span", "start": 1353, "end": 1357, "id": 205, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 1353, "end": 1357, "id": 206, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=1", "title": "Edit section: History", "data-section": "1", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "section", "start": 1358, "end": 7152, "id": 207, "features": {"class": "mf-section-1 collapsible-block", "id": "mf-section-1"}}, {"type": "div", "start": 1358, "end": 1418, "id": 208, "features": {"role": "note", "class": "hatnote navigation-not-searchable"}}, {"type": "a", "start": 1379, "end": 1417, "id": 209, "features": {"href": "/wiki/History_of_natural_language_processing", "title": "History of natural language processing"}}, {"type": "p", "start": 1418, "end": 1822, "id": 210, "features": {}}, {"type": "a", "start": 1491, "end": 1502, "id": 211, "features": {"href": "/wiki/Alan_Turing", "title": "Alan Turing"}}, {"type": "a", "start": 1532, "end": 1568, "id": 212, "features": {"href": "/wiki/Computing_Machinery_and_Intelligence", "title": "Computing Machinery and Intelligence"}}, {"type": "a", "start": 1608, "end": 1619, "id": 213, "features": {"href": "/wiki/Turing_test", "title": "Turing test"}}, {"type": "h3", "start": 1822, "end": 1861, "id": 214, "features": {"class": "in-block"}}, {"type": "span", "start": 1822, "end": 1822, "id": 215, "features": {"id": "Symbolic_NLP_.281950s_-_early_1990s.29"}}, {"type": "span", "start": 1822, "end": 1856, "id": 216, "features": {"class": "mw-headline", "id": "Symbolic_NLP_(1950s_-_early_1990s)"}}, {"type": "span", "start": 1856, "end": 1860, "id": 217, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 1856, "end": 1860, "id": 218, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=2", "title": "Edit section: Symbolic NLP (1950s - early 1990s)", "data-section": "2", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "p", "start": 1861, "end": 2178, "id": 219, "features": {}}, {"type": "a", "start": 1911, "end": 1922, "id": 220, "features": {"href": "/wiki/John_Searle", "title": "John Searle"}}, {"type": "a", "start": 1925, "end": 1937, "id": 221, "features": {"href": "/wiki/Chinese_room", "title": "Chinese room"}}, {"type": "ul", "start": 2178, "end": 4525, "id": 222, "features": {}}, {"type": "li", "start": 2178, "end": 2779, "id": 223, "features": {}}, {"type": "b", "start": 2178, "end": 2183, "id": 224, "features": {}}, {"type": "a", "start": 2189, "end": 2210, "id": 225, "features": {"href": "/wiki/Georgetown-IBM_experiment", "class": "mw-redirect", "title": "Georgetown-IBM experiment"}}, {"type": "a", "start": 2234, "end": 2255, "id": 226, "features": {"href": "/wiki/Automatic_translation", "class": "mw-redirect", "title": "Automatic translation"}}, {"type": "sup", "start": 2406, "end": 2409, "id": 227, "features": {"id": "cite_ref-2", "class": "reference"}}, {"type": "a", "start": 2406, "end": 2409, "id": 228, "features": {"href": "#cite_note-2"}}, {"type": "a", "start": 2465, "end": 2477, "id": 229, "features": {"href": "/wiki/ALPAC", "title": "ALPAC"}}, {"type": "a", "start": 2723, "end": 2754, "id": 230, "features": {"href": "/wiki/Statistical_machine_translation", "title": "Statistical machine translation"}}, {"type": "li", "start": 2779, "end": 3389, "id": 231, "features": {}}, {"type": "b", "start": 2779, "end": 2784, "id": 232, "features": {}}, {"type": "a", "start": 2874, "end": 2880, "id": 233, "features": {"href": "/wiki/SHRDLU", "title": "SHRDLU"}}, {"type": "a", "start": 2931, "end": 2944, "id": 234, "features": {"href": "/wiki/Blocks_world", "title": "Blocks world"}}, {"type": "a", "start": 2980, "end": 2985, "id": 235, "features": {"href": "/wiki/ELIZA", "title": "ELIZA"}}, {"type": "a", "start": 3005, "end": 3029, "id": 236, "features": {"href": "/wiki/Rogerian_psychotherapy", "class": "mw-redirect", "title": "Rogerian psychotherapy"}}, {"type": "a", "start": 3042, "end": 3059, "id": 237, "features": {"href": "/wiki/Joseph_Weizenbaum", "title": "Joseph Weizenbaum"}}, {"type": "li", "start": 3389, "end": 3811, "id": 238, "features": {}}, {"type": "b", "start": 3389, "end": 3394, "id": 239, "features": {}}, {"type": "a", "start": 3458, "end": 3468, "id": 240, "features": {"href": "/wiki/Ontology_(information_science)", "title": "Ontology (information science)"}}, {"type": "a", "start": 3771, "end": 3782, "id": 241, "features": {"href": "/wiki/Chatterbots", "class": "mw-redirect", "title": "Chatterbots"}}, {"type": "a", "start": 3803, "end": 3808, "id": 242, "features": {"href": "/wiki/PARRY", "title": "PARRY"}}, {"type": "li", "start": 3811, "end": 4525, "id": 243, "features": {}}, {"type": "b", "start": 3811, "end": 3816, "id": 244, "features": {}}, {"type": "a", "start": 3979, "end": 3983, "id": 245, "features": {"href": "/wiki/Head-driven_phrase_structure_grammar", "title": "Head-driven phrase structure grammar"}}, {"type": "a", "start": 4025, "end": 4043, "id": 246, "features": {"href": "/wiki/Generative_grammar", "title": "Generative grammar"}}, {"type": "sup", "start": 4084, "end": 4087, "id": 247, "features": {"id": "cite_ref-3", "class": "reference"}}, {"type": "a", "start": 4084, "end": 4087, "id": 248, "features": {"href": "#cite_note-3"}}, {"type": "a", "start": 4107, "end": 4121, "id": 249, "features": {"href": "/wiki/Lesk_algorithm", "title": "Lesk algorithm"}}, {"type": "sup", "start": 4164, "end": 4167, "id": 250, "features": {"id": "cite_ref-4", "class": "reference"}}, {"type": "a", "start": 4164, "end": 4167, "id": 251, "features": {"href": "#cite_note-4"}}, {"type": "a", "start": 4233, "end": 4260, "id": 252, "features": {"href": "/wiki/Rhetorical_structure_theory", "title": "Rhetorical structure theory"}}, {"type": "a", "start": 4345, "end": 4351, "id": 253, "features": {"href": "/wiki/Racter", "title": "Racter"}}, {"type": "a", "start": 4356, "end": 4367, "id": 254, "features": {"href": "/wiki/Jabberwacky", "title": "Jabberwacky"}}, {"type": "sup", "start": 4521, "end": 4524, "id": 255, "features": {"id": "cite_ref-5", "class": "reference"}}, {"type": "a", "start": 4521, "end": 4524, "id": 256, "features": {"href": "#cite_note-5"}}, {"type": "h3", "start": 4525, "end": 4561, "id": 257, "features": {"class": "in-block"}}, {"type": "span", "start": 4525, "end": 4525, "id": 258, "features": {"id": "Statistical_NLP_.281990s_-_2010s.29"}}, {"type": "span", "start": 4525, "end": 4556, "id": 259, "features": {"class": "mw-headline", "id": "Statistical_NLP_(1990s_-_2010s)"}}, {"type": "span", "start": 4556, "end": 4560, "id": 260, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 4556, "end": 4560, "id": 261, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=3", "title": "Edit section: Statistical NLP (1990s - 2010s)", "data-section": "3", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "p", "start": 4561, "end": 5182, "id": 262, "features": {}}, {"type": "a", "start": 4786, "end": 4802, "id": 263, "features": {"href": "/wiki/Machine_learning", "title": "Machine learning"}}, {"type": "a", "start": 4909, "end": 4920, "id": 264, "features": {"href": "/wiki/Moore%27s_law", "title": "Moore's law"}}, {"type": "a", "start": 4968, "end": 4977, "id": 265, "features": {"href": "/wiki/Noam_Chomsky", "title": "Noam Chomsky"}}, {"type": "a", "start": 5008, "end": 5032, "id": 266, "features": {"href": "/wiki/Transformational_grammar", "title": "Transformational grammar"}}, {"type": "a", "start": 5091, "end": 5109, "id": 267, "features": {"href": "/wiki/Corpus_linguistics", "title": "Corpus linguistics"}}, {"type": "sup", "start": 5178, "end": 5181, "id": 268, "features": {"id": "cite_ref-6", "class": "reference"}}, {"type": "a", "start": 5178, "end": 5181, "id": 269, "features": {"href": "#cite_note-6"}}, {"type": "ul", "start": 5182, "end": 6774, "id": 270, "features": {}}, {"type": "li", "start": 5182, "end": 5976, "id": 271, "features": {}}, {"type": "b", "start": 5182, "end": 5187, "id": 272, "features": {}}, {"type": "a", "start": 5280, "end": 5299, "id": 273, "features": {"href": "/wiki/Machine_translation", "title": "Machine translation"}}, {"type": "a", "start": 5409, "end": 5424, "id": 274, "features": {"href": "/wiki/Text_corpus", "title": "Text corpus"}}, {"type": "a", "start": 5455, "end": 5475, "id": 275, "features": {"href": "/wiki/Parliament_of_Canada", "title": "Parliament of Canada"}}, {"type": "a", "start": 5484, "end": 5498, "id": 276, "features": {"href": "/wiki/European_Union", "title": "European Union"}}, {"type": "li", "start": 5976, "end": 6774, "id": 277, "features": {}}, {"type": "b", "start": 5976, "end": 5981, "id": 278, "features": {}}, {"type": "a", "start": 6149, "end": 6161, "id": 279, "features": {"href": "/wiki/Unsupervised_learning", "title": "Unsupervised learning"}}, {"type": "a", "start": 6166, "end": 6190, "id": 280, "features": {"href": "/wiki/Semi-supervised_learning", "title": "Semi-supervised learning"}}, {"type": "a", "start": 6408, "end": 6427, "id": 281, "features": {"href": "/wiki/Supervised_learning", "title": "Supervised learning"}}, {"type": "a", "start": 6636, "end": 6650, "id": 282, "features": {"href": "/wiki/World_Wide_Web", "title": "World Wide Web"}}, {"type": "a", "start": 6741, "end": 6756, "id": 283, "features": {"href": "/wiki/Time_complexity", "title": "Time complexity"}}, {"type": "h3", "start": 6774, "end": 6799, "id": 284, "features": {"class": "in-block"}}, {"type": "span", "start": 6774, "end": 6774, "id": 285, "features": {"id": "Neural_NLP_.28present.29"}}, {"type": "span", "start": 6774, "end": 6794, "id": 286, "features": {"class": "mw-headline", "id": "Neural_NLP_(present)"}}, {"type": "span", "start": 6794, "end": 6798, "id": 287, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 6794, "end": 6798, "id": 288, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=4", "title": "Edit section: Neural NLP (present)", "data-section": "4", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "p", "start": 6799, "end": 7152, "id": 289, "features": {}}, {"type": "a", "start": 6813, "end": 6836, "id": 290, "features": {"href": "/wiki/Representation_learning", "class": "mw-redirect", "title": "Representation learning"}}, {"type": "a", "start": 6841, "end": 6860, "id": 291, "features": {"href": "/wiki/Deep_learning", "title": "Deep learning"}}, {"type": "sup", "start": 7005, "end": 7008, "id": 292, "features": {"id": "cite_ref-goldberg:nnlp17_7-0", "class": "reference"}}, {"type": "a", "start": 7005, "end": 7008, "id": 293, "features": {"href": "#cite_note-goldberg:nnlp17-7"}}, {"type": "sup", "start": 7008, "end": 7011, "id": 294, "features": {"id": "cite_ref-goodfellow:book16_8-0", "class": "reference"}}, {"type": "a", "start": 7008, "end": 7011, "id": 295, "features": {"href": "#cite_note-goodfellow:book16-8"}}, {"type": "sup", "start": 7114, "end": 7117, "id": 296, "features": {"id": "cite_ref-jozefowicz:lm16_9-0", "class": "reference"}}, {"type": "a", "start": 7114, "end": 7117, "id": 297, "features": {"href": "#cite_note-jozefowicz:lm16-9"}}, {"type": "sup", "start": 7126, "end": 7130, "id": 298, "features": {"id": "cite_ref-choe:emnlp16_10-0", "class": "reference"}}, {"type": "a", "start": 7126, "end": 7130, "id": 299, "features": {"href": "#cite_note-choe:emnlp16-10"}}, {"type": "sup", "start": 7130, "end": 7134, "id": 300, "features": {"id": "cite_ref-vinyals:nips15_11-0", "class": "reference"}}, {"type": "a", "start": 7130, "end": 7134, "id": 301, "features": {"href": "#cite_note-vinyals:nips15-11"}}, {"type": "h2", "start": 7152, "end": 7200, "id": 302, "features": {"class": "section-heading", "onclick": "javascript:mfTempOpenSection(2)"}}, {"type": "div", "start": 7152, "end": 7152, "id": 303, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left"}}, {"type": "span", "start": 7152, "end": 7152, "id": 304, "features": {"id": "Methods:_Rules.2C_statistics.2C_neural_networks"}}, {"type": "span", "start": 7152, "end": 7195, "id": 305, "features": {"class": "mw-headline", "id": "Methods:_Rules,_statistics,_neural_networks"}}, {"type": "span", "start": 7195, "end": 7195, "id": 306, "features": {"class": "anchor", "id": "Statistical_natural_language_processing_(SNLP)"}}, {"type": "span", "start": 7195, "end": 7199, "id": 307, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 7195, "end": 7199, "id": 308, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=5", "title": "Edit section: Methods: Rules, statistics, neural networks", "data-section": "5", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "section", "start": 7200, "end": 12638, "id": 309, "features": {"class": "mf-section-2 collapsible-block", "id": "mf-section-2"}}, {"type": "p", "start": 7200, "end": 7440, "id": 310, "features": {}}, {"type": "sup", "start": 7361, "end": 7365, "id": 311, "features": {"id": "cite_ref-winograd:shrdlu71_12-0", "class": "reference"}}, {"type": "a", "start": 7361, "end": 7365, "id": 312, "features": {"href": "#cite_note-winograd:shrdlu71-12"}}, {"type": "sup", "start": 7365, "end": 7369, "id": 313, "features": {"id": "cite_ref-schank77_13-0", "class": "reference"}}, {"type": "a", "start": 7365, "end": 7369, "id": 314, "features": {"href": "#cite_note-schank77-13"}}, {"type": "a", "start": 7430, "end": 7438, "id": 315, "features": {"href": "/wiki/Stemming", "title": "Stemming"}}, {"type": "p", "start": 7440, "end": 7545, "id": 316, "features": {}}, {"type": "a", "start": 7469, "end": 7485, "id": 317, "features": {"href": "/wiki/Machine_learning", "title": "Machine learning"}}, {"type": "ul", "start": 7545, "end": 8881, "id": 318, "features": {}}, {"type": "li", "start": 7545, "end": 7747, "id": 319, "features": {}}, {"type": "li", "start": 7747, "end": 8238, "id": 320, "features": {}}, {"type": "li", "start": 8238, "end": 8881, "id": 321, "features": {}}, {"type": "p", "start": 8881, "end": 8989, "id": 322, "features": {}}, {"type": "ul", "start": 8989, "end": 9365, "id": 323, "features": {}}, {"type": "li", "start": 8989, "end": 9187, "id": 324, "features": {}}, {"type": "a", "start": 9170, "end": 9178, "id": 325, "features": {"href": "/wiki/Apertium", "title": "Apertium"}}, {"type": "li", "start": 9187, "end": 9246, "id": 326, "features": {}}, {"type": "a", "start": 9229, "end": 9241, "id": 327, "features": {"href": "/wiki/Tokenization_(lexical_analysis)", "class": "mw-redirect", "title": "Tokenization (lexical analysis)"}}, {"type": "li", "start": 9246, "end": 9365, "id": 328, "features": {}}, {"type": "a", "start": 9321, "end": 9341, "id": 329, "features": {"href": "/wiki/Knowledge_extraction", "title": "Knowledge extraction"}}, {"type": "h3", "start": 9365, "end": 9389, "id": 330, "features": {"class": "in-block"}}, {"type": "span", "start": 9365, "end": 9384, "id": 331, "features": {"class": "mw-headline", "id": "Statistical_methods"}}, {"type": "span", "start": 9384, "end": 9388, "id": 332, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 9384, "end": 9388, "id": 333, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=6", "title": "Edit section: Statistical methods", "data-section": "6", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "p", "start": 9389, "end": 9833, "id": 334, "features": {}}, {"type": "sup", "start": 9433, "end": 9437, "id": 335, "features": {"id": "cite_ref-johnson:eacl:ilcl09_14-0", "class": "reference"}}, {"type": "a", "start": 9433, "end": 9437, "id": 336, "features": {"href": "#cite_note-johnson:eacl:ilcl09-14"}}, {"type": "sup", "start": 9437, "end": 9441, "id": 337, "features": {"id": "cite_ref-resnik:langlog11_15-0", "class": "reference"}}, {"type": "a", "start": 9437, "end": 9441, "id": 338, "features": {"href": "#cite_note-resnik:langlog11-15"}}, {"type": "a", "start": 9611, "end": 9632, "id": 339, "features": {"href": "/wiki/Statistical_inference", "title": "Statistical inference"}}, {"type": "i", "start": 9697, "end": 9704, "id": 340, "features": {}}, {"type": "a", "start": 9697, "end": 9704, "id": 341, "features": {"href": "/wiki/Text_corpus", "title": "Text corpus"}}, {"type": "i", "start": 9725, "end": 9731, "id": 342, "features": {}}, {"type": "p", "start": 9833, "end": 10440, "id": 343, "features": {}}, {"type": "a", "start": 10087, "end": 10105, "id": 344, "features": {"href": "/wiki/Statistical_models", "class": "mw-redirect", "title": "Statistical models"}}, {"type": "a", "start": 10124, "end": 10137, "id": 345, "features": {"href": "/wiki/Probabilistic", "class": "mw-redirect", "title": "Probabilistic"}}, {"type": "a", "start": 10167, "end": 10178, "id": 346, "features": {"href": "/wiki/Real-valued", "class": "mw-redirect", "title": "Real-valued"}}, {"type": "p", "start": 10440, "end": 11257, "id": 347, "features": {}}, {"type": "a", "start": 10503, "end": 10517, "id": 348, "features": {"href": "/wiki/Decision_tree", "title": "Decision tree"}}, {"type": "a", "start": 10608, "end": 10630, "id": 349, "features": {"href": "/wiki/Part_of_speech_tagging", "class": "mw-redirect", "title": "Part of speech tagging"}}, {"type": "a", "start": 10653, "end": 10673, "id": 350, "features": {"href": "/wiki/Hidden_Markov_models", "class": "mw-redirect", "title": "Hidden Markov models"}}, {"type": "a", "start": 10748, "end": 10766, "id": 351, "features": {"href": "/wiki/Statistical_models", "class": "mw-redirect", "title": "Statistical models"}}, {"type": "a", "start": 10785, "end": 10798, "id": 352, "features": {"href": "/wiki/Probabilistic", "class": "mw-redirect", "title": "Probabilistic"}}, {"type": "a", "start": 10828, "end": 10839, "id": 353, "features": {"href": "/wiki/Real-valued", "class": "mw-redirect", "title": "Real-valued"}}, {"type": "a", "start": 10894, "end": 10915, "id": 354, "features": {"href": "/wiki/Cache_language_model", "title": "Cache language model"}}, {"type": "a", "start": 10932, "end": 10950, "id": 355, "features": {"href": "/wiki/Speech_recognition", "title": "Speech recognition"}}, {"type": "p", "start": 11257, "end": 11482, "id": 356, "features": {}}, {"type": "h3", "start": 11482, "end": 11502, "id": 357, "features": {"class": "in-block"}}, {"type": "span", "start": 11482, "end": 11497, "id": 358, "features": {"class": "mw-headline", "id": "Neural_networks"}}, {"type": "span", "start": 11497, "end": 11501, "id": 359, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 11497, "end": 11501, "id": 360, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=7", "title": "Edit section: Neural networks", "data-section": "7", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "div", "start": 11502, "end": 11549, "id": 361, "features": {"role": "note", "class": "hatnote navigation-not-searchable"}}, {"type": "a", "start": 11523, "end": 11548, "id": 362, "features": {"href": "/wiki/Artificial_neural_network", "title": "Artificial neural network"}}, {"type": "p", "start": 11549, "end": 12638, "id": 363, "features": {}}, {"type": "sup", "start": 11663, "end": 11667, "id": 364, "features": {"id": "cite_ref-16", "class": "reference"}}, {"type": "a", "start": 11663, "end": 11667, "id": 365, "features": {"href": "#cite_note-16"}}, {"type": "a", "start": 11740, "end": 11755, "id": 366, "features": {"href": "/wiki/Neural_network", "title": "Neural network"}}, {"type": "a", "start": 11816, "end": 11831, "id": 367, "features": {"href": "/wiki/Word_embedding", "title": "Word embedding"}}, {"type": "i", "start": 12330, "end": 12356, "id": 368, "features": {}}, {"type": "a", "start": 12330, "end": 12356, "id": 369, "features": {"href": "/wiki/Neural_machine_translation", "title": "Neural machine translation"}}, {"type": "a", "start": 12457, "end": 12477, "id": 370, "features": {"href": "/wiki/Seq2seq", "title": "Seq2seq"}}, {"type": "a", "start": 12599, "end": 12630, "id": 371, "features": {"href": "/wiki/Statistical_machine_translation", "title": "Statistical machine translation"}}, {"type": "h2", "start": 12638, "end": 12659, "id": 372, "features": {"class": "section-heading", "onclick": "javascript:mfTempOpenSection(3)"}}, {"type": "div", "start": 12638, "end": 12638, "id": 373, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left"}}, {"type": "span", "start": 12638, "end": 12654, "id": 374, "features": {"class": "mw-headline", "id": "Common_NLP_Tasks"}}, {"type": "span", "start": 12654, "end": 12658, "id": 375, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 12654, "end": 12658, "id": 376, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=8", "title": "Edit section: Common NLP Tasks", "data-section": "8", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "section", "start": 12659, "end": 25447, "id": 377, "features": {"class": "mf-section-3 collapsible-block", "id": "mf-section-3"}}, {"type": "p", "start": 12659, "end": 12909, "id": 378, "features": {}}, {"type": "p", "start": 12909, "end": 13065, "id": 379, "features": {}}, {"type": "h3", "start": 13065, "end": 13096, "id": 380, "features": {"class": "in-block"}}, {"type": "span", "start": 13065, "end": 13091, "id": 381, "features": {"class": "mw-headline", "id": "Text_and_speech_processing"}}, {"type": "span", "start": 13091, "end": 13095, "id": 382, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 13091, "end": 13095, "id": 383, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=9", "title": "Edit section: Text and speech processing", "data-section": "9", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "dl", "start": 13096, "end": 13207, "id": 384, "features": {}}, {"type": "dt", "start": 13096, "end": 13131, "id": 385, "features": {}}, {"type": "a", "start": 13096, "end": 13125, "id": 386, "features": {"href": "/wiki/Optical_character_recognition", "title": "Optical character recognition"}}, {"type": "dd", "start": 13132, "end": 13207, "id": 387, "features": {}}, {"type": "dl", "start": 13207, "end": 14245, "id": 388, "features": {}}, {"type": "dt", "start": 13207, "end": 13225, "id": 389, "features": {}}, {"type": "a", "start": 13207, "end": 13225, "id": 390, "features": {"href": "/wiki/Speech_recognition", "title": "Speech recognition"}}, {"type": "dd", "start": 13226, "end": 14086, "id": 391, "features": {}}, {"type": "a", "start": 13354, "end": 13368, "id": 392, "features": {"href": "/wiki/Text_to_speech", "class": "mw-redirect", "title": "Text to speech"}}, {"type": "a", "start": 13437, "end": 13448, "id": 393, "features": {"href": "/wiki/AI-complete", "title": "AI-complete"}}, {"type": "a", "start": 13467, "end": 13481, "id": 394, "features": {"href": "/wiki/Natural_speech", "class": "mw-redirect", "title": "Natural speech"}}, {"type": "a", "start": 13545, "end": 13564, "id": 395, "features": {"href": "/wiki/Speech_segmentation", "title": "Speech segmentation"}}, {"type": "a", "start": 13734, "end": 13748, "id": 396, "features": {"href": "/wiki/Coarticulation", "title": "Coarticulation"}}, {"type": "a", "start": 13775, "end": 13788, "id": 397, "features": {"href": "/wiki/Analog_signal", "title": "Analog signal"}}, {"type": "dt", "start": 14087, "end": 14106, "id": 398, "features": {}}, {"type": "a", "start": 14087, "end": 14106, "id": 399, "features": {"href": "/wiki/Speech_segmentation", "title": "Speech segmentation"}}, {"type": "dd", "start": 14107, "end": 14245, "id": 400, "features": {}}, {"type": "a", "start": 14196, "end": 14214, "id": 401, "features": {"href": "/wiki/Speech_recognition", "title": "Speech recognition"}}, {"type": "dl", "start": 14245, "end": 14393, "id": 402, "features": {}}, {"type": "dt", "start": 14245, "end": 14259, "id": 403, "features": {}}, {"type": "a", "start": 14245, "end": 14259, "id": 404, "features": {"href": "/wiki/Text-to-speech", "class": "mw-redirect", "title": "Text-to-speech"}}, {"type": "dd", "start": 14260, "end": 14393, "id": 405, "features": {}}, {"type": "sup", "start": 14389, "end": 14393, "id": 406, "features": {"id": "cite_ref-17", "class": "reference"}}, {"type": "a", "start": 14389, "end": 14393, "id": 407, "features": {"href": "#cite_note-17"}}, {"type": "dl", "start": 14393, "end": 14927, "id": 408, "features": {}}, {"type": "dt", "start": 14393, "end": 14425, "id": 409, "features": {}}, {"type": "a", "start": 14393, "end": 14410, "id": 410, "features": {"href": "/wiki/Word_segmentation", "class": "mw-redirect", "title": "Word segmentation"}}, {"type": "a", "start": 14412, "end": 14424, "id": 411, "features": {"href": "/wiki/Tokenization_(lexical_analysis)", "class": "mw-redirect", "title": "Tokenization (lexical analysis)"}}, {"type": "dd", "start": 14426, "end": 14927, "id": 412, "features": {}}, {"type": "a", "start": 14503, "end": 14510, "id": 413, "features": {"href": "/wiki/English_language", "title": "English language"}}, {"type": "a", "start": 14618, "end": 14625, "id": 414, "features": {"href": "/wiki/Chinese_language", "title": "Chinese language"}}, {"type": "a", "start": 14627, "end": 14635, "id": 415, "features": {"href": "/wiki/Japanese_language", "title": "Japanese language"}}, {"type": "a", "start": 14640, "end": 14644, "id": 416, "features": {"href": "/wiki/Thai_language", "title": "Thai language"}}, {"type": "a", "start": 14782, "end": 14792, "id": 417, "features": {"href": "/wiki/Vocabulary", "title": "Vocabulary"}}, {"type": "a", "start": 14797, "end": 14807, "id": 418, "features": {"href": "/wiki/Morphology_(linguistics)", "title": "Morphology (linguistics)"}}, {"type": "a", "start": 14884, "end": 14896, "id": 419, "features": {"href": "/wiki/Bag_of_words", "class": "mw-redirect", "title": "Bag of words"}}, {"type": "h3", "start": 14928, "end": 14955, "id": 420, "features": {"class": "in-block"}}, {"type": "span", "start": 14928, "end": 14950, "id": 421, "features": {"class": "mw-headline", "id": "Morphological_analysis"}}, {"type": "span", "start": 14950, "end": 14954, "id": 422, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 14950, "end": 14954, "id": 423, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=10", "title": "Edit section: Morphological analysis", "data-section": "10", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "dl", "start": 14955, "end": 16525, "id": 424, "features": {}}, {"type": "dt", "start": 14955, "end": 14968, "id": 425, "features": {}}, {"type": "a", "start": 14955, "end": 14968, "id": 426, "features": {"href": "/wiki/Lemmatisation", "title": "Lemmatisation"}}, {"type": "dd", "start": 14969, "end": 15096, "id": 427, "features": {}}, {"type": "dt", "start": 15097, "end": 15123, "id": 428, "features": {}}, {"type": "a", "start": 15097, "end": 15123, "id": 429, "features": {"href": "/wiki/Morphology_(linguistics)", "title": "Morphology (linguistics)"}}, {"type": "dd", "start": 15124, "end": 15776, "id": 430, "features": {}}, {"type": "a", "start": 15155, "end": 15164, "id": 431, "features": {"href": "/wiki/Morpheme", "title": "Morpheme"}}, {"type": "a", "start": 15275, "end": 15285, "id": 432, "features": {"href": "/wiki/Morphology_(linguistics)", "title": "Morphology (linguistics)"}}, {"type": "i", "start": 15287, "end": 15291, "id": 433, "features": {}}, {"type": "a", "start": 15351, "end": 15358, "id": 434, "features": {"href": "/wiki/English_language", "title": "English language"}}, {"type": "a", "start": 15400, "end": 15423, "id": 435, "features": {"href": "/wiki/Inflectional_morphology", "class": "mw-redirect", "title": "Inflectional morphology"}}, {"type": "i", "start": 15531, "end": 15535, "id": 436, "features": {}}, {"type": "a", "start": 15609, "end": 15616, "id": 437, "features": {"href": "/wiki/Turkish_language", "title": "Turkish language"}}, {"type": "a", "start": 15620, "end": 15626, "id": 438, "features": {"href": "/wiki/Meitei_language", "title": "Meitei language"}}, {"type": "sup", "start": 15627, "end": 15631, "id": 439, "features": {"id": "cite_ref-18", "class": "reference"}}, {"type": "a", "start": 15627, "end": 15631, "id": 440, "features": {"href": "#cite_note-18"}}, {"type": "a", "start": 15641, "end": 15653, "id": 441, "features": {"href": "/wiki/Agglutination", "title": "Agglutination"}}, {"type": "dt", "start": 15777, "end": 15799, "id": 442, "features": {}}, {"type": "a", "start": 15777, "end": 15799, "id": 443, "features": {"href": "/wiki/Part-of-speech_tagging", "title": "Part-of-speech tagging"}}, {"type": "dd", "start": 15800, "end": 16525, "id": 444, "features": {}}, {"type": "a", "start": 15832, "end": 15846, "id": 445, "features": {"href": "/wiki/Part_of_speech", "title": "Part of speech"}}, {"type": "a", "start": 15926, "end": 15941, "id": 446, "features": {"href": "/wiki/Parts_of_speech", "class": "mw-redirect", "title": "Parts of speech"}}, {"type": "a", "start": 15972, "end": 15976, "id": 447, "features": {"href": "/wiki/Noun", "title": "Noun"}}, {"type": "a", "start": 16006, "end": 16010, "id": 448, "features": {"href": "/wiki/Verb", "title": "Verb"}}, {"type": "a", "start": 16048, "end": 16052, "id": 449, "features": {"href": "/wiki/Noun", "title": "Noun"}}, {"type": "a", "start": 16054, "end": 16058, "id": 450, "features": {"href": "/wiki/Verb", "title": "Verb"}}, {"type": "a", "start": 16062, "end": 16071, "id": 451, "features": {"href": "/wiki/Adjective", "title": "Adjective"}}, {"type": "sup", "start": 16190, "end": 16210, "id": 452, "features": {"class": "noprint Inline-Template", "style": "white-space:nowrap;"}}, {"type": "i", "start": 16191, "end": 16209, "id": 453, "features": {}}, {"type": "a", "start": 16191, "end": 16198, "id": 454, "features": {"href": "/wiki/Wikipedia:Accuracy_dispute#Disputed_statement", "title": "Wikipedia:Accuracy dispute"}}, {"type": "span", "start": 16191, "end": 16198, "id": 455, "features": {"title": "The material near this tag is possibly inaccurate or nonfactual. (June 2018)"}}, {"type": "span", "start": 16199, "end": 16209, "id": 456, "features": {"class": "metadata"}}, {"type": "a", "start": 16202, "end": 16209, "id": 457, "features": {"href": "/wiki/Talk:Natural_language_processing#Dubious", "title": "Talk:Natural language processing"}}, {"type": "a", "start": 16233, "end": 16256, "id": 458, "features": {"href": "/wiki/Inflectional_morphology", "class": "mw-redirect", "title": "Inflectional morphology"}}, {"type": "a", "start": 16266, "end": 16273, "id": 459, "features": {"href": "/wiki/English_language", "title": "English language"}}, {"type": "a", "start": 16317, "end": 16324, "id": 460, "features": {"href": "/wiki/Chinese_language", "title": "Chinese language"}}, {"type": "a", "start": 16368, "end": 16382, "id": 461, "features": {"href": "/wiki/Tonal_language", "class": "mw-redirect", "title": "Tonal language"}}, {"type": "dl", "start": 16525, "end": 16698, "id": 462, "features": {}}, {"type": "dt", "start": 16525, "end": 16533, "id": 463, "features": {}}, {"type": "a", "start": 16525, "end": 16533, "id": 464, "features": {"href": "/wiki/Stemming", "title": "Stemming"}}, {"type": "dd", "start": 16534, "end": 16698, "id": 465, "features": {}}, {"type": "i", "start": 16618, "end": 16622, "id": 466, "features": {}}, {"type": "h3", "start": 16699, "end": 16722, "id": 467, "features": {"class": "in-block"}}, {"type": "span", "start": 16699, "end": 16717, "id": 468, "features": {"class": "mw-headline", "id": "Syntactic_analysis"}}, {"type": "span", "start": 16717, "end": 16721, "id": 469, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 16717, "end": 16721, "id": 470, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=11", "title": "Edit section: Syntactic analysis", "data-section": "11", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "dl", "start": 16722, "end": 17777, "id": 471, "features": {}}, {"type": "dt", "start": 16722, "end": 16743, "id": 472, "features": {}}, {"type": "a", "start": 16722, "end": 16739, "id": 473, "features": {"href": "/wiki/Grammar_induction", "title": "Grammar induction"}}, {"type": "sup", "start": 16739, "end": 16743, "id": 474, "features": {"id": "cite_ref-19", "class": "reference"}}, {"type": "a", "start": 16739, "end": 16743, "id": 475, "features": {"href": "#cite_note-19"}}, {"type": "dd", "start": 16744, "end": 16805, "id": 476, "features": {}}, {"type": "a", "start": 16755, "end": 16769, "id": 477, "features": {"href": "/wiki/Formal_grammar", "title": "Formal grammar"}}, {"type": "dt", "start": 16806, "end": 16874, "id": 478, "features": {}}, {"type": "a", "start": 16806, "end": 16823, "id": 479, "features": {"href": "/wiki/Sentence_breaking", "class": "mw-redirect", "title": "Sentence breaking"}}, {"type": "a", "start": 16840, "end": 16872, "id": 480, "features": {"href": "/wiki/Sentence_boundary_disambiguation", "title": "Sentence boundary disambiguation"}}, {"type": "dd", "start": 16875, "end": 17085, "id": 481, "features": {}}, {"type": "a", "start": 16968, "end": 16975, "id": 482, "features": {"href": "/wiki/Full_stop", "title": "Full stop"}}, {"type": "a", "start": 16985, "end": 17002, "id": 483, "features": {"href": "/wiki/Punctuation_mark", "class": "mw-redirect", "title": "Punctuation mark"}}, {"type": "i", "start": 17056, "end": 17060, "id": 484, "features": {}}, {"type": "a", "start": 17070, "end": 17083, "id": 485, "features": {"href": "/wiki/Abbreviation", "title": "Abbreviation"}}, {"type": "dt", "start": 17086, "end": 17093, "id": 486, "features": {}}, {"type": "a", "start": 17086, "end": 17093, "id": 487, "features": {"href": "/wiki/Parsing", "title": "Parsing"}}, {"type": "dd", "start": 17094, "end": 17777, "id": 488, "features": {}}, {"type": "a", "start": 17108, "end": 17118, "id": 489, "features": {"href": "/wiki/Parse_tree", "title": "Parse tree"}}, {"type": "a", "start": 17167, "end": 17174, "id": 490, "features": {"href": "/wiki/Grammar", "title": "Grammar"}}, {"type": "a", "start": 17179, "end": 17196, "id": 491, "features": {"href": "/wiki/Natural_language", "title": "Natural language"}}, {"type": "a", "start": 17200, "end": 17209, "id": 492, "features": {"href": "/wiki/Ambiguous", "class": "mw-redirect", "title": "Ambiguous"}}, {"type": "i", "start": 17454, "end": 17472, "id": 493, "features": {}}, {"type": "i", "start": 17477, "end": 17497, "id": 494, "features": {}}, {"type": "a", "start": 17705, "end": 17739, "id": 495, "features": {"href": "/wiki/Probabilistic_context-free_grammar", "title": "Probabilistic context-free grammar"}}, {"type": "i", "start": 17757, "end": 17775, "id": 496, "features": {}}, {"type": "a", "start": 17757, "end": 17775, "id": 497, "features": {"href": "/wiki/Stochastic_grammar", "title": "Stochastic grammar"}}, {"type": "h3", "start": 17778, "end": 17833, "id": 498, "features": {"class": "in-block"}}, {"type": "span", "start": 17778, "end": 17778, "id": 499, "features": {"id": "Lexical_semantics_.28of_individual_words_in_context.29"}}, {"type": "span", "start": 17778, "end": 17828, "id": 500, "features": {"class": "mw-headline", "id": "Lexical_semantics_(of_individual_words_in_context)"}}, {"type": "span", "start": 17828, "end": 17832, "id": 501, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 17828, "end": 17832, "id": 502, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=12", "title": "Edit section: Lexical semantics (of individual words in context)", "data-section": "12", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "dl", "start": 17833, "end": 18935, "id": 503, "features": {}}, {"type": "dt", "start": 17833, "end": 17850, "id": 504, "features": {}}, {"type": "a", "start": 17833, "end": 17850, "id": 505, "features": {"href": "/wiki/Lexical_semantics", "title": "Lexical semantics"}}, {"type": "dd", "start": 17851, "end": 17916, "id": 506, "features": {}}, {"type": "dt", "start": 17917, "end": 17941, "id": 507, "features": {}}, {"type": "a", "start": 17917, "end": 17941, "id": 508, "features": {"href": "/wiki/Distributional_semantics", "title": "Distributional semantics"}}, {"type": "dd", "start": 17942, "end": 17994, "id": 509, "features": {}}, {"type": "dt", "start": 17995, "end": 18025, "id": 510, "features": {}}, {"type": "a", "start": 17995, "end": 18019, "id": 511, "features": {"href": "/wiki/Named_entity_recognition", "class": "mw-redirect", "title": "Named entity recognition"}}, {"type": "dd", "start": 18026, "end": 18935, "id": 512, "features": {}}, {"type": "a", "start": 18218, "end": 18232, "id": 513, "features": {"href": "/wiki/Capitalization", "title": "Capitalization"}}, {"type": "a", "start": 18635, "end": 18642, "id": 514, "features": {"href": "/wiki/Chinese_language", "title": "Chinese language"}}, {"type": "a", "start": 18646, "end": 18652, "id": 515, "features": {"href": "/wiki/Arabic_language", "class": "mw-redirect", "title": "Arabic language"}}, {"type": "a", "start": 18795, "end": 18801, "id": 516, "features": {"href": "/wiki/German_language", "title": "German language"}}, {"type": "a", "start": 18818, "end": 18823, "id": 517, "features": {"href": "/wiki/Noun", "title": "Noun"}}, {"type": "a", "start": 18867, "end": 18873, "id": 518, "features": {"href": "/wiki/French_language", "title": "French language"}}, {"type": "a", "start": 18878, "end": 18885, "id": 519, "features": {"href": "/wiki/Spanish_language", "title": "Spanish language"}}, {"type": "a", "start": 18924, "end": 18934, "id": 520, "features": {"href": "/wiki/Adjective", "title": "Adjective"}}, {"type": "dl", "start": 18935, "end": 19230, "id": 521, "features": {}}, {"type": "dt", "start": 18935, "end": 18994, "id": 522, "features": {}}, {"type": "a", "start": 18935, "end": 18953, "id": 523, "features": {"href": "/wiki/Sentiment_analysis", "title": "Sentiment analysis"}}, {"type": "a", "start": 18964, "end": 18993, "id": 524, "features": {"href": "/wiki/Multimodal_sentiment_analysis", "title": "Multimodal sentiment analysis"}}, {"type": "dd", "start": 18995, "end": 19230, "id": 525, "features": {}}, {"type": "dl", "start": 19230, "end": 19632, "id": 526, "features": {}}, {"type": "dt", "start": 19230, "end": 19230, "id": 527, "features": {}}, {"type": "dl", "start": 19230, "end": 19252, "id": 528, "features": {}}, {"type": "dt", "start": 19230, "end": 19252, "id": 529, "features": {}}, {"type": "a", "start": 19230, "end": 19252, "id": 530, "features": {"href": "/wiki/Terminology_extraction", "title": "Terminology extraction"}}, {"type": "dd", "start": 19252, "end": 19350, "id": 531, "features": {}}, {"type": "dt", "start": 19351, "end": 19376, "id": 532, "features": {}}, {"type": "a", "start": 19351, "end": 19376, "id": 533, "features": {"href": "/wiki/Word_sense_disambiguation", "class": "mw-redirect", "title": "Word sense disambiguation"}}, {"type": "dd", "start": 19377, "end": 19632, "id": 534, "features": {}}, {"type": "a", "start": 19407, "end": 19414, "id": 535, "features": {"href": "/wiki/Meaning_(linguistics)", "class": "mw-redirect", "title": "Meaning (linguistics)"}}, {"type": "a", "start": 19624, "end": 19631, "id": 536, "features": {"href": "/wiki/WordNet", "title": "WordNet"}}, {"type": "h3", "start": 19633, "end": 19694, "id": 537, "features": {"class": "in-block"}}, {"type": "span", "start": 19633, "end": 19633, "id": 538, "features": {"id": "Relational_semantics_.28semantics_of_individual_sentences.29"}}, {"type": "span", "start": 19633, "end": 19689, "id": 539, "features": {"class": "mw-headline", "id": "Relational_semantics_(semantics_of_individual_sentences)"}}, {"type": "span", "start": 19689, "end": 19693, "id": 540, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 19689, "end": 19693, "id": 541, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=13", "title": "Edit section: Relational semantics (semantics of individual sentences)", "data-section": "13", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "dl", "start": 19694, "end": 20570, "id": 542, "features": {}}, {"type": "dt", "start": 19694, "end": 19717, "id": 543, "features": {}}, {"type": "a", "start": 19694, "end": 19717, "id": 544, "features": {"href": "/wiki/Relationship_extraction", "title": "Relationship extraction"}}, {"type": "dd", "start": 19718, "end": 19819, "id": 545, "features": {}}, {"type": "dt", "start": 19820, "end": 19836, "id": 546, "features": {}}, {"type": "a", "start": 19820, "end": 19836, "id": 547, "features": {"href": "/wiki/Semantic_parsing", "title": "Semantic parsing"}}, {"type": "dd", "start": 19837, "end": 20338, "id": 548, "features": {}}, {"type": "a", "start": 19961, "end": 19972, "id": 549, "features": {"href": "/wiki/Abstract_Meaning_Representation", "title": "Abstract Meaning Representation"}}, {"type": "a", "start": 20026, "end": 20037, "id": 550, "features": {"href": "/wiki/Discourse_representation_theory", "title": "Discourse representation theory"}}, {"type": "dt", "start": 20339, "end": 20412, "id": 551, "features": {}}, {"type": "a", "start": 20339, "end": 20362, "id": 552, "features": {"href": "/wiki/Semantic_role_labeling", "title": "Semantic role labeling"}}, {"type": "dd", "start": 20413, "end": 20570, "id": 553, "features": {}}, {"type": "a", "start": 20498, "end": 20504, "id": 554, "features": {"href": "/wiki/Frame_semantics_(linguistics)", "title": "Frame semantics (linguistics)"}}, {"type": "a", "start": 20554, "end": 20568, "id": 555, "features": {"href": "/wiki/Semantic_roles", "class": "mw-redirect", "title": "Semantic roles"}}, {"type": "dl", "start": 20570, "end": 20571, "id": 556, "features": {}}, {"type": "dt", "start": 20570, "end": 20570, "id": 557, "features": {}}, {"type": "dt", "start": 20571, "end": 20571, "id": 558, "features": {}}, {"type": "h3", "start": 20571, "end": 20625, "id": 559, "features": {"class": "in-block"}}, {"type": "span", "start": 20571, "end": 20571, "id": 560, "features": {"id": "Discourse_.28semantics_beyond_individual_sentences.29"}}, {"type": "span", "start": 20571, "end": 20620, "id": 561, "features": {"class": "mw-headline", "id": "Discourse_(semantics_beyond_individual_sentences)"}}, {"type": "span", "start": 20620, "end": 20624, "id": 562, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 20620, "end": 20624, "id": 563, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=14", "title": "Edit section: Discourse (semantics beyond individual sentences)", "data-section": "14", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "dl", "start": 20625, "end": 21811, "id": 564, "features": {}}, {"type": "dt", "start": 20625, "end": 20647, "id": 565, "features": {}}, {"type": "a", "start": 20625, "end": 20647, "id": 566, "features": {"href": "/wiki/Coreference", "title": "Coreference"}}, {"type": "dd", "start": 20648, "end": 21386, "id": 567, "features": {}}, {"type": "a", "start": 20765, "end": 20784, "id": 568, "features": {"href": "/wiki/Anaphora_resolution", "class": "mw-redirect", "title": "Anaphora resolution"}}, {"type": "a", "start": 20868, "end": 20876, "id": 569, "features": {"href": "/wiki/Pronoun", "title": "Pronoun"}}, {"type": "a", "start": 21041, "end": 21062, "id": 570, "features": {"href": "/wiki/Referring_expression", "title": "Referring expression"}}, {"type": "dt", "start": 21387, "end": 21405, "id": 571, "features": {}}, {"type": "a", "start": 21387, "end": 21405, "id": 572, "features": {"href": "/wiki/Discourse_analysis", "title": "Discourse analysis"}}, {"type": "dd", "start": 21406, "end": 21811, "id": 573, "features": {}}, {"type": "a", "start": 21504, "end": 21513, "id": 574, "features": {"href": "/wiki/Discourse", "title": "Discourse"}}, {"type": "a", "start": 21711, "end": 21722, "id": 575, "features": {"href": "/wiki/Speech_act", "title": "Speech act"}}, {"type": "dl", "start": 21811, "end": 22401, "id": 576, "features": {}}, {"type": "dt", "start": 21811, "end": 21843, "id": 577, "features": {}}, {"type": "dd", "start": 21844, "end": 22401, "id": 578, "features": {}}, {"type": "a", "start": 21929, "end": 21935, "id": 579, "features": {"href": "/wiki/Frame_semantics_(linguistics)", "title": "Frame semantics (linguistics)"}}, {"type": "a", "start": 22382, "end": 22400, "id": 580, "features": {"href": "/wiki/Pro-drop_language", "title": "Pro-drop language"}}, {"type": "dl", "start": 22401, "end": 22586, "id": 581, "features": {}}, {"type": "dt", "start": 22401, "end": 22431, "id": 582, "features": {}}, {"type": "a", "start": 22401, "end": 22431, "id": 583, "features": {"href": "/wiki/Textual_entailment", "title": "Textual entailment"}}, {"type": "dd", "start": 22432, "end": 22586, "id": 584, "features": {}}, {"type": "sup", "start": 22582, "end": 22586, "id": 585, "features": {"id": "cite_ref-rte:11_20-0", "class": "reference"}}, {"type": "a", "start": 22582, "end": 22586, "id": 586, "features": {"href": "#cite_note-rte:11-20"}}, {"type": "dl", "start": 22586, "end": 22745, "id": 587, "features": {}}, {"type": "dt", "start": 22586, "end": 22620, "id": 588, "features": {}}, {"type": "a", "start": 22586, "end": 22604, "id": 589, "features": {"href": "/wiki/Topic_segmentation", "class": "mw-redirect", "title": "Topic segmentation"}}, {"type": "dd", "start": 22621, "end": 22745, "id": 590, "features": {}}, {"type": "h3", "start": 22746, "end": 22780, "id": 591, "features": {"class": "in-block"}}, {"type": "span", "start": 22746, "end": 22775, "id": 592, "features": {"class": "mw-headline", "id": "Higher-level_NLP_applications"}}, {"type": "span", "start": 22775, "end": 22779, "id": 593, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 22775, "end": 22779, "id": 594, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=15", "title": "Edit section: Higher-level NLP applications", "data-section": "15", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "dl", "start": 22780, "end": 25446, "id": 595, "features": {}}, {"type": "dt", "start": 22780, "end": 22824, "id": 596, "features": {}}, {"type": "a", "start": 22780, "end": 22803, "id": 597, "features": {"href": "/wiki/Automatic_summarization", "title": "Automatic summarization"}}, {"type": "dd", "start": 22825, "end": 23008, "id": 598, "features": {}}, {"type": "dt", "start": 23009, "end": 23024, "id": 599, "features": {}}, {"type": "dd", "start": 23025, "end": 23734, "id": 600, "features": {}}, {"type": "i", "start": 23240, "end": 23281, "id": 601, "features": {}}, {"type": "sup", "start": 23283, "end": 23287, "id": 602, "features": {"id": "cite_ref-21", "class": "reference"}}, {"type": "a", "start": 23283, "end": 23287, "id": 603, "features": {"href": "#cite_note-21"}}, {"type": "i", "start": 23356, "end": 23366, "id": 604, "features": {}}, {"type": "a", "start": 23356, "end": 23366, "id": 605, "features": {"href": "/wiki/1_the_Road", "title": "1 the Road"}}, {"type": "a", "start": 23496, "end": 23511, "id": 606, "features": {"href": "/wiki/Language_model", "title": "Language model"}}, {"type": "i", "start": 23590, "end": 23611, "id": 607, "features": {}}, {"type": "sup", "start": 23629, "end": 23633, "id": 608, "features": {"id": "cite_ref-22", "class": "reference"}}, {"type": "a", "start": 23629, "end": 23633, "id": 609, "features": {"href": "#cite_note-22"}}, {"type": "i", "start": 23641, "end": 23647, "id": 610, "features": {}}, {"type": "i", "start": 23652, "end": 23662, "id": 611, "features": {}}, {"type": "dt", "start": 23735, "end": 23754, "id": 612, "features": {}}, {"type": "a", "start": 23735, "end": 23754, "id": 613, "features": {"href": "/wiki/Dialogue_system", "title": "Dialogue system"}}, {"type": "dd", "start": 23755, "end": 23806, "id": 614, "features": {}}, {"type": "dt", "start": 23807, "end": 23826, "id": 615, "features": {}}, {"type": "a", "start": 23807, "end": 23826, "id": 616, "features": {"href": "/wiki/Machine_translation", "title": "Machine translation"}}, {"type": "dd", "start": 23827, "end": 24159, "id": 617, "features": {}}, {"type": "a", "start": 23997, "end": 24008, "id": 618, "features": {"href": "/wiki/AI-complete", "title": "AI-complete"}}, {"type": "dt", "start": 24160, "end": 24194, "id": 619, "features": {}}, {"type": "a", "start": 24160, "end": 24187, "id": 620, "features": {"href": "/wiki/Natural_language_generation", "class": "mw-redirect", "title": "Natural language generation"}}, {"type": "dd", "start": 24195, "end": 24288, "id": 621, "features": {}}, {"type": "dt", "start": 24289, "end": 24325, "id": 622, "features": {}}, {"type": "a", "start": 24289, "end": 24319, "id": 623, "features": {"href": "/wiki/Natural_language_understanding", "class": "mw-redirect", "title": "Natural language understanding"}}, {"type": "dd", "start": 24326, "end": 25122, "id": 624, "features": {}}, {"type": "a", "start": 24390, "end": 24407, "id": 625, "features": {"href": "/wiki/First-order_logic", "title": "First-order logic"}}, {"type": "a", "start": 24439, "end": 24447, "id": 626, "features": {"href": "/wiki/Computer", "title": "Computer"}}, {"type": "a", "start": 24944, "end": 24967, "id": 627, "features": {"href": "/wiki/Closed-world_assumption", "title": "Closed-world assumption"}}, {"type": "a", "start": 24978, "end": 24999, "id": 628, "features": {"href": "/wiki/Open-world_assumption", "title": "Open-world assumption"}}, {"type": "sup", "start": 25118, "end": 25122, "id": 629, "features": {"id": "cite_ref-23", "class": "reference"}}, {"type": "a", "start": 25118, "end": 25122, "id": 630, "features": {"href": "#cite_note-23"}}, {"type": "dt", "start": 25123, "end": 25141, "id": 631, "features": {}}, {"type": "a", "start": 25123, "end": 25141, "id": 632, "features": {"href": "/wiki/Question_answering", "title": "Question answering"}}, {"type": "dd", "start": 25142, "end": 25446, "id": 633, "features": {}}, {"type": "sup", "start": 25442, "end": 25446, "id": 634, "features": {"id": "cite_ref-24", "class": "reference"}}, {"type": "a", "start": 25442, "end": 25446, "id": 635, "features": {"href": "#cite_note-24"}}, {"type": "h2", "start": 25447, "end": 25469, "id": 636, "features": {"class": "section-heading", "onclick": "javascript:mfTempOpenSection(4)"}}, {"type": "div", "start": 25447, "end": 25447, "id": 637, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left"}}, {"type": "span", "start": 25447, "end": 25464, "id": 638, "features": {"class": "mw-headline", "id": "Cognition_and_NLP"}}, {"type": "span", "start": 25464, "end": 25468, "id": 639, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 25464, "end": 25468, "id": 640, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=16", "title": "Edit section: Cognition and NLP", "data-section": "16", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "section", "start": 25469, "end": 28151, "id": 641, "features": {"class": "mf-section-4 collapsible-block", "id": "mf-section-4"}}, {"type": "p", "start": 25469, "end": 26039, "id": 642, "features": {}}, {"type": "a", "start": 25469, "end": 25478, "id": 643, "features": {"href": "/wiki/Cognition", "title": "Cognition"}}, {"type": "sup", "start": 25605, "end": 25609, "id": 644, "features": {"id": "cite_ref-25", "class": "reference"}}, {"type": "a", "start": 25605, "end": 25609, "id": 645, "features": {"href": "#cite_note-25"}}, {"type": "a", "start": 25610, "end": 25627, "id": 646, "features": {"href": "/wiki/Cognitive_science", "title": "Cognitive science"}}, {"type": "sup", "start": 25701, "end": 25705, "id": 647, "features": {"id": "cite_ref-26", "class": "reference"}}, {"type": "a", "start": 25701, "end": 25705, "id": 648, "features": {"href": "#cite_note-26"}}, {"type": "a", "start": 25706, "end": 25727, "id": 649, "features": {"href": "/wiki/Cognitive_linguistics", "title": "Cognitive linguistics"}}, {"type": "sup", "start": 25845, "end": 25849, "id": 650, "features": {"id": "cite_ref-27", "class": "reference"}}, {"type": "a", "start": 25845, "end": 25849, "id": 651, "features": {"href": "#cite_note-27"}}, {"type": "a", "start": 25850, "end": 25863, "id": 652, "features": {"href": "/wiki/George_Lakoff", "title": "George Lakoff"}}, {"type": "a", "start": 25966, "end": 25983, "id": 653, "features": {"href": "/wiki/Cognitive_science", "title": "Cognitive science"}}, {"type": "a", "start": 26012, "end": 26033, "id": 654, "features": {"href": "/wiki/Cognitive_linguistics", "title": "Cognitive linguistics"}}, {"type": "sup", "start": 26034, "end": 26038, "id": 655, "features": {"id": "cite_ref-28", "class": "reference"}}, {"type": "a", "start": 26034, "end": 26038, "id": 656, "features": {"href": "#cite_note-28"}}, {"type": "p", "start": 26039, "end": 26284, "id": 657, "features": {}}, {"type": "a", "start": 26131, "end": 26150, "id": 658, "features": {"href": "/wiki/Conceptual_metaphor", "title": "Conceptual metaphor"}}, {"type": "sup", "start": 26279, "end": 26283, "id": 659, "features": {"id": "cite_ref-29", "class": "reference"}}, {"type": "a", "start": 26279, "end": 26283, "id": 660, "features": {"href": "#cite_note-29"}}, {"type": "p", "start": 26284, "end": 27080, "id": 661, "features": {}}, {"type": "i", "start": 26352, "end": 26357, "id": 662, "features": {}}, {"type": "a", "start": 26374, "end": 26385, "id": 663, "features": {"href": "/wiki/Comparative", "title": "Comparative"}}, {"type": "i", "start": 26393, "end": 26414, "id": 664, "features": {}}, {"type": "i", "start": 26499, "end": 26504, "id": 665, "features": {}}, {"type": "i", "start": 26547, "end": 26565, "id": 666, "features": {}}, {"type": "a", "start": 26638, "end": 26650, "id": 667, "features": {"href": "/wiki/Stative_verb", "title": "Stative verb"}}, {"type": "i", "start": 26658, "end": 26681, "id": 668, "features": {}}, {"type": "i", "start": 26733, "end": 26738, "id": 669, "features": {}}, {"type": "i", "start": 26762, "end": 26774, "id": 670, "features": {}}, {"type": "a", "start": 26885, "end": 26904, "id": 671, "features": {"href": "/wiki/Conceptual_metaphor", "title": "Conceptual metaphor"}}, {"type": "i", "start": 26947, "end": 26968, "id": 672, "features": {}}, {"type": "p", "start": 27080, "end": 27493, "id": 673, "features": {}}, {"type": "a", "start": 27159, "end": 27193, "id": 674, "features": {"href": "/wiki/Probabilistic_context-free_grammar", "title": "Probabilistic context-free grammar"}}, {"type": "span", "start": 27473, "end": 27490, "id": 675, "features": {"class": "citation patent"}}, {"type": "a", "start": 27473, "end": 27490, "id": 676, "features": {"rel": "nofollow", "class": "external text", "href": "https://worldwide.espacenet.com/textdoc?DB=EPODOC&IDX=US9269353"}}, {"type": "span", "start": 27490, "end": 27491, "id": 677, "features": {"class": "Z3988", "title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Apatent&rft.number=9269353&rft.cc=US&rft.title="}}, {"type": "span", "start": 27490, "end": 27491, "id": 678, "features": {"style": "display: none;"}}, {"type": "dl", "start": 27493, "end": 27798, "id": 679, "features": {}}, {"type": "dd", "start": 27493, "end": 27798, "id": 680, "features": {}}, {"type": "span", "start": 27493, "end": 27798, "id": 681, "features": {"class": "mwe-math-element"}}, {"type": "span", "start": 27493, "end": 27797, "id": 682, "features": {"class": "mwe-math-mathml-inline mwe-math-mathml-a11y", "style": "display: none;"}}, {"type": "math", "start": 27493, "end": 27797, "id": 683, "features": {"xmlns": "http://www.w3.org/1998/Math/MathML", "alttext": "{\\displaystyle {RMM(token_{N})}={PMM(token_{N})}\\times {\\frac {1}{2d}}\\left(\\sum _{i=-d}^{d}{((PMM(token_{N-1})}\\times {PF(token_{N},token_{N-1}))_{i}}\\right)}"}}, {"type": "semantics", "start": 27493, "end": 27797, "id": 684, "features": {}}, {"type": "mrow", "start": 27493, "end": 27637, "id": 685, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mstyle", "start": 27493, "end": 27637, "id": 686, "features": {"displaystyle": "true", "scriptlevel": "0"}}, {"type": "mrow", "start": 27493, "end": 27515, "id": 687, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 27493, "end": 27494, "id": 688, "features": {}}, {"type": "mi", "start": 27495, "end": 27496, "id": 689, "features": {}}, {"type": "mi", "start": 27497, "end": 27498, "id": 690, "features": {}}, {"type": "mo", "start": 27499, "end": 27500, "id": 691, "features": {"stretchy": "false"}}, {"type": "mi", "start": 27501, "end": 27502, "id": 692, "features": {}}, {"type": "mi", "start": 27503, "end": 27504, "id": 693, "features": {}}, {"type": "mi", "start": 27505, "end": 27506, "id": 694, "features": {}}, {"type": "mi", "start": 27507, "end": 27508, "id": 695, "features": {}}, {"type": "msub", "start": 27509, "end": 27513, "id": 696, "features": {}}, {"type": "mi", "start": 27509, "end": 27510, "id": 697, "features": {}}, {"type": "mrow", "start": 27511, "end": 27513, "id": 698, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 27511, "end": 27512, "id": 699, "features": {}}, {"type": "mo", "start": 27513, "end": 27514, "id": 700, "features": {"stretchy": "false"}}, {"type": "mo", "start": 27515, "end": 27516, "id": 701, "features": {}}, {"type": "mrow", "start": 27517, "end": 27539, "id": 702, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 27517, "end": 27518, "id": 703, "features": {}}, {"type": "mi", "start": 27519, "end": 27520, "id": 704, "features": {}}, {"type": "mi", "start": 27521, "end": 27522, "id": 705, "features": {}}, {"type": "mo", "start": 27523, "end": 27524, "id": 706, "features": {"stretchy": "false"}}, {"type": "mi", "start": 27525, "end": 27526, "id": 707, "features": {}}, {"type": "mi", "start": 27527, "end": 27528, "id": 708, "features": {}}, {"type": "mi", "start": 27529, "end": 27530, "id": 709, "features": {}}, {"type": "mi", "start": 27531, "end": 27532, "id": 710, "features": {}}, {"type": "msub", "start": 27533, "end": 27537, "id": 711, "features": {}}, {"type": "mi", "start": 27533, "end": 27534, "id": 712, "features": {}}, {"type": "mrow", "start": 27535, "end": 27537, "id": 713, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 27535, "end": 27536, "id": 714, "features": {}}, {"type": "mo", "start": 27537, "end": 27538, "id": 715, "features": {"stretchy": "false"}}, {"type": "mo", "start": 27539, "end": 27540, "id": 716, "features": {}}, {"type": "mrow", "start": 27541, "end": 27547, "id": 717, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mfrac", "start": 27541, "end": 27547, "id": 718, "features": {}}, {"type": "mn", "start": 27541, "end": 27542, "id": 719, "features": {}}, {"type": "mrow", "start": 27543, "end": 27547, "id": 720, "features": {}}, {"type": "mn", "start": 27543, "end": 27544, "id": 721, "features": {}}, {"type": "mi", "start": 27545, "end": 27546, "id": 722, "features": {}}, {"type": "mrow", "start": 27547, "end": 27637, "id": 723, "features": {}}, {"type": "mo", "start": 27547, "end": 27548, "id": 724, "features": {}}, {"type": "mrow", "start": 27549, "end": 27635, "id": 725, "features": {}}, {"type": "munderover", "start": 27549, "end": 27561, "id": 726, "features": {}}, {"type": "mo", "start": 27549, "end": 27550, "id": 727, "features": {}}, {"type": "mrow", "start": 27551, "end": 27559, "id": 728, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 27551, "end": 27552, "id": 729, "features": {}}, {"type": "mo", "start": 27553, "end": 27554, "id": 730, "features": {}}, {"type": "mo", "start": 27555, "end": 27556, "id": 731, "features": {}}, {"type": "mi", "start": 27557, "end": 27558, "id": 732, "features": {}}, {"type": "mrow", "start": 27559, "end": 27561, "id": 733, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 27559, "end": 27560, "id": 734, "features": {}}, {"type": "mrow", "start": 27561, "end": 27591, "id": 735, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mo", "start": 27561, "end": 27562, "id": 736, "features": {"stretchy": "false"}}, {"type": "mo", "start": 27563, "end": 27564, "id": 737, "features": {"stretchy": "false"}}, {"type": "mi", "start": 27565, "end": 27566, "id": 738, "features": {}}, {"type": "mi", "start": 27567, "end": 27568, "id": 739, "features": {}}, {"type": "mi", "start": 27569, "end": 27570, "id": 740, "features": {}}, {"type": "mo", "start": 27571, "end": 27572, "id": 741, "features": {"stretchy": "false"}}, {"type": "mi", "start": 27573, "end": 27574, "id": 742, "features": {}}, {"type": "mi", "start": 27575, "end": 27576, "id": 743, "features": {}}, {"type": "mi", "start": 27577, "end": 27578, "id": 744, "features": {}}, {"type": "mi", "start": 27579, "end": 27580, "id": 745, "features": {}}, {"type": "msub", "start": 27581, "end": 27589, "id": 746, "features": {}}, {"type": "mi", "start": 27581, "end": 27582, "id": 747, "features": {}}, {"type": "mrow", "start": 27583, "end": 27589, "id": 748, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 27583, "end": 27584, "id": 749, "features": {}}, {"type": "mo", "start": 27585, "end": 27586, "id": 750, "features": {}}, {"type": "mn", "start": 27587, "end": 27588, "id": 751, "features": {}}, {"type": "mo", "start": 27589, "end": 27590, "id": 752, "features": {"stretchy": "false"}}, {"type": "mo", "start": 27591, "end": 27592, "id": 753, "features": {}}, {"type": "mrow", "start": 27593, "end": 27635, "id": 754, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 27593, "end": 27594, "id": 755, "features": {}}, {"type": "mi", "start": 27595, "end": 27596, "id": 756, "features": {}}, {"type": "mo", "start": 27597, "end": 27598, "id": 757, "features": {"stretchy": "false"}}, {"type": "mi", "start": 27599, "end": 27600, "id": 758, "features": {}}, {"type": "mi", "start": 27601, "end": 27602, "id": 759, "features": {}}, {"type": "mi", "start": 27603, "end": 27604, "id": 760, "features": {}}, {"type": "mi", "start": 27605, "end": 27606, "id": 761, "features": {}}, {"type": "msub", "start": 27607, "end": 27611, "id": 762, "features": {}}, {"type": "mi", "start": 27607, "end": 27608, "id": 763, "features": {}}, {"type": "mrow", "start": 27609, "end": 27611, "id": 764, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 27609, "end": 27610, "id": 765, "features": {}}, {"type": "mo", "start": 27611, "end": 27612, "id": 766, "features": {}}, {"type": "mi", "start": 27613, "end": 27614, "id": 767, "features": {}}, {"type": "mi", "start": 27615, "end": 27616, "id": 768, "features": {}}, {"type": "mi", "start": 27617, "end": 27618, "id": 769, "features": {}}, {"type": "mi", "start": 27619, "end": 27620, "id": 770, "features": {}}, {"type": "msub", "start": 27621, "end": 27629, "id": 771, "features": {}}, {"type": "mi", "start": 27621, "end": 27622, "id": 772, "features": {}}, {"type": "mrow", "start": 27623, "end": 27629, "id": 773, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 27623, "end": 27624, "id": 774, "features": {}}, {"type": "mo", "start": 27625, "end": 27626, "id": 775, "features": {}}, {"type": "mn", "start": 27627, "end": 27628, "id": 776, "features": {}}, {"type": "mo", "start": 27629, "end": 27630, "id": 777, "features": {"stretchy": "false"}}, {"type": "msub", "start": 27631, "end": 27635, "id": 778, "features": {}}, {"type": "mo", "start": 27631, "end": 27632, "id": 779, "features": {"stretchy": "false"}}, {"type": "mrow", "start": 27633, "end": 27635, "id": 780, "features": {"class": "MJX-TeXAtom-ORD"}}, {"type": "mi", "start": 27633, "end": 27634, "id": 781, "features": {}}, {"type": "mo", "start": 27635, "end": 27636, "id": 782, "features": {}}, {"type": "annotation", "start": 27637, "end": 27796, "id": 783, "features": {"encoding": "application/x-tex"}}, {"type": "noscript", "start": 27797, "end": 27797, "id": 784, "features": {}}, {"type": "img", "start": 27797, "end": 27797, "id": 785, "features": {"src": "https://wikimedia.org/api/rest_v1/media/math/render/svg/145bdbd62e463df3e65c94db2e17224ecbcb2c40", "class": "mwe-math-fallback-image-inline", "aria-hidden": "true", "style": "vertical-align: -3.171ex; width:96.554ex; height:7.509ex;", "alt": "{\\displaystyle {RMM(token_{N})}={PMM(token_{N})}\\times {\\frac {1}{2d}}\\left(\\sum _{i=-d}^{d}{((PMM(token_{N-1})}\\times {PF(token_{N},token_{N-1}))_{i}}\\right)}"}}, {"type": "span", "start": 27797, "end": 27798, "id": 786, "features": {"class": "lazy-image-placeholder", "style": "width: 96.554ex;height: 7.509ex;vertical-align: -3.171ex;", "data-src": "https://wikimedia.org/api/rest_v1/media/math/render/svg/145bdbd62e463df3e65c94db2e17224ecbcb2c40", "data-alt": "{\\displaystyle {RMM(token_{N})}={PMM(token_{N})}\\times {\\frac {1}{2d}}\\left(\\sum _{i=-d}^{d}{((PMM(token_{N-1})}\\times {PF(token_{N},token_{N-1}))_{i}}\\right)}", "data-class": "mwe-math-fallback-image-inline"}}, {"type": "p", "start": 27799, "end": 28151, "id": 787, "features": {}}, {"type": "i", "start": 27799, "end": 27805, "id": 788, "features": {}}, {"type": "br", "start": 27806, "end": 27806, "id": 789, "features": {}}, {"type": "b", "start": 27811, "end": 27814, "id": 790, "features": {}}, {"type": "br", "start": 27851, "end": 27851, "id": 791, "features": {}}, {"type": "b", "start": 27856, "end": 27861, "id": 792, "features": {}}, {"type": "br", "start": 27910, "end": 27910, "id": 793, "features": {}}, {"type": "b", "start": 27915, "end": 27916, "id": 794, "features": {}}, {"type": "br", "start": 27957, "end": 27957, "id": 795, "features": {}}, {"type": "b", "start": 27962, "end": 27965, "id": 796, "features": {}}, {"type": "br", "start": 28021, "end": 28021, "id": 797, "features": {}}, {"type": "b", "start": 28026, "end": 28027, "id": 798, "features": {}}, {"type": "b", "start": 28080, "end": 28083, "id": 799, "features": {}}, {"type": "br", "start": 28091, "end": 28091, "id": 800, "features": {}}, {"type": "b", "start": 28096, "end": 28098, "id": 801, "features": {}}, {"type": "h2", "start": 28151, "end": 28164, "id": 802, "features": {"class": "section-heading", "onclick": "javascript:mfTempOpenSection(5)"}}, {"type": "div", "start": 28151, "end": 28151, "id": 803, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left"}}, {"type": "span", "start": 28151, "end": 28159, "id": 804, "features": {"class": "mw-headline", "id": "See_also"}}, {"type": "span", "start": 28159, "end": 28163, "id": 805, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 28159, "end": 28163, "id": 806, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=17", "title": "Edit section: See also", "data-section": "17", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "section", "start": 28164, "end": 28919, "id": 807, "features": {"class": "mf-section-5 collapsible-block", "id": "mf-section-5"}}, {"type": "div", "start": 28164, "end": 28919, "id": 808, "features": {"class": "div-col columns column-width", "style": "-moz-column-width: 22em; -webkit-column-width: 22em; column-width: 22em;"}}, {"type": "ul", "start": 28164, "end": 28919, "id": 809, "features": {}}, {"type": "li", "start": 28164, "end": 28175, "id": 810, "features": {}}, {"type": "i", "start": 28164, "end": 28174, "id": 811, "features": {}}, {"type": "a", "start": 28164, "end": 28174, "id": 812, "features": {"href": "/wiki/1_the_Road", "title": "1 the Road"}}, {"type": "li", "start": 28175, "end": 28199, "id": 813, "features": {}}, {"type": "a", "start": 28175, "end": 28198, "id": 814, "features": {"href": "/wiki/Automated_essay_scoring", "title": "Automated essay scoring"}}, {"type": "li", "start": 28199, "end": 28222, "id": 815, "features": {}}, {"type": "a", "start": 28199, "end": 28221, "id": 816, "features": {"href": "/wiki/Biomedical_text_mining", "title": "Biomedical text mining"}}, {"type": "li", "start": 28222, "end": 28247, "id": 817, "features": {}}, {"type": "a", "start": 28222, "end": 28246, "id": 818, "features": {"href": "/wiki/Compound_term_processing", "class": "mw-redirect", "title": "Compound term processing"}}, {"type": "li", "start": 28247, "end": 28273, "id": 819, "features": {}}, {"type": "a", "start": 28247, "end": 28272, "id": 820, "features": {"href": "/wiki/Computational_linguistics", "title": "Computational linguistics"}}, {"type": "li", "start": 28273, "end": 28301, "id": 821, "features": {}}, {"type": "a", "start": 28273, "end": 28300, "id": 822, "features": {"href": "/wiki/Computer-assisted_reviewing", "title": "Computer-assisted reviewing"}}, {"type": "li", "start": 28301, "end": 28329, "id": 823, "features": {}}, {"type": "a", "start": 28301, "end": 28328, "id": 824, "features": {"href": "/wiki/Controlled_natural_language", "title": "Controlled natural language"}}, {"type": "li", "start": 28329, "end": 28343, "id": 825, "features": {}}, {"type": "a", "start": 28329, "end": 28342, "id": 826, "features": {"href": "/wiki/Deep_learning", "title": "Deep learning"}}, {"type": "li", "start": 28343, "end": 28370, "id": 827, "features": {}}, {"type": "a", "start": 28343, "end": 28369, "id": 828, "features": {"href": "/wiki/Deep_linguistic_processing", "title": "Deep linguistic processing"}}, {"type": "li", "start": 28370, "end": 28395, "id": 829, "features": {}}, {"type": "a", "start": 28370, "end": 28394, "id": 830, "features": {"href": "/wiki/Distributional_semantics", "title": "Distributional semantics"}}, {"type": "li", "start": 28395, "end": 28424, "id": 831, "features": {}}, {"type": "a", "start": 28395, "end": 28423, "id": 832, "features": {"href": "/wiki/Foreign_language_reading_aid", "class": "mw-redirect", "title": "Foreign language reading aid"}}, {"type": "li", "start": 28424, "end": 28453, "id": 833, "features": {}}, {"type": "a", "start": 28424, "end": 28452, "id": 834, "features": {"href": "/wiki/Foreign_language_writing_aid", "title": "Foreign language writing aid"}}, {"type": "li", "start": 28453, "end": 28476, "id": 835, "features": {}}, {"type": "a", "start": 28453, "end": 28475, "id": 836, "features": {"href": "/wiki/Information_extraction", "title": "Information extraction"}}, {"type": "li", "start": 28476, "end": 28498, "id": 837, "features": {}}, {"type": "a", "start": 28476, "end": 28497, "id": 838, "features": {"href": "/wiki/Information_retrieval", "title": "Information retrieval"}}, {"type": "li", "start": 28498, "end": 28538, "id": 839, "features": {}}, {"type": "a", "start": 28498, "end": 28537, "id": 840, "features": {"href": "/wiki/Language_and_Communication_Technologies", "title": "Language and Communication Technologies"}}, {"type": "li", "start": 28538, "end": 28558, "id": 841, "features": {}}, {"type": "a", "start": 28538, "end": 28557, "id": 842, "features": {"href": "/wiki/Language_technology", "title": "Language technology"}}, {"type": "li", "start": 28558, "end": 28583, "id": 843, "features": {}}, {"type": "a", "start": 28558, "end": 28582, "id": 844, "features": {"href": "/wiki/Latent_semantic_indexing", "class": "mw-redirect", "title": "Latent semantic indexing"}}, {"type": "li", "start": 28583, "end": 28614, "id": 845, "features": {}}, {"type": "a", "start": 28583, "end": 28613, "id": 846, "features": {"href": "/wiki/Native-language_identification", "title": "Native-language identification"}}, {"type": "li", "start": 28614, "end": 28643, "id": 847, "features": {}}, {"type": "a", "start": 28614, "end": 28642, "id": 848, "features": {"href": "/wiki/Natural_language_programming", "class": "mw-redirect", "title": "Natural language programming"}}, {"type": "li", "start": 28643, "end": 28667, "id": 849, "features": {}}, {"type": "a", "start": 28643, "end": 28666, "id": 850, "features": {"href": "/wiki/Natural_language_user_interface", "class": "mw-redirect", "title": "Natural language user interface"}}, {"type": "li", "start": 28667, "end": 28706, "id": 851, "features": {}}, {"type": "a", "start": 28667, "end": 28705, "id": 852, "features": {"href": "/wiki/Outline_of_natural_language_processing", "title": "Outline of natural language processing"}}, {"type": "li", "start": 28706, "end": 28722, "id": 853, "features": {}}, {"type": "a", "start": 28706, "end": 28721, "id": 854, "features": {"href": "/wiki/Query_expansion", "title": "Query expansion"}}, {"type": "li", "start": 28722, "end": 28742, "id": 855, "features": {}}, {"type": "a", "start": 28722, "end": 28741, "id": 856, "features": {"href": "/wiki/Query_understanding", "title": "Query understanding"}}, {"type": "li", "start": 28742, "end": 28768, "id": 857, "features": {}}, {"type": "a", "start": 28742, "end": 28767, "id": 858, "features": {"href": "/wiki/Reification_(linguistics)", "title": "Reification (linguistics)"}}, {"type": "li", "start": 28768, "end": 28786, "id": 859, "features": {}}, {"type": "a", "start": 28768, "end": 28785, "id": 860, "features": {"href": "/wiki/Speech_processing", "title": "Speech processing"}}, {"type": "li", "start": 28786, "end": 28809, "id": 861, "features": {}}, {"type": "a", "start": 28786, "end": 28808, "id": 862, "features": {"href": "/wiki/Spoken_dialogue_system", "class": "mw-redirect", "title": "Spoken dialogue system"}}, {"type": "li", "start": 28809, "end": 28823, "id": 863, "features": {}}, {"type": "a", "start": 28809, "end": 28822, "id": 864, "features": {"href": "/wiki/Text-proofing", "class": "mw-redirect", "title": "Text-proofing"}}, {"type": "li", "start": 28823, "end": 28843, "id": 865, "features": {}}, {"type": "a", "start": 28823, "end": 28842, "id": 866, "features": {"href": "/wiki/Text_simplification", "title": "Text simplification"}}, {"type": "li", "start": 28843, "end": 28880, "id": 867, "features": {}}, {"type": "a", "start": 28843, "end": 28879, "id": 868, "features": {"href": "/wiki/Transformer_(machine_learning_model)", "title": "Transformer (machine learning model)"}}, {"type": "li", "start": 28880, "end": 28891, "id": 869, "features": {}}, {"type": "a", "start": 28880, "end": 28890, "id": 870, "features": {"href": "/wiki/Truecasing", "title": "Truecasing"}}, {"type": "li", "start": 28891, "end": 28910, "id": 871, "features": {}}, {"type": "a", "start": 28891, "end": 28909, "id": 872, "features": {"href": "/wiki/Question_answering", "title": "Question answering"}}, {"type": "li", "start": 28910, "end": 28919, "id": 873, "features": {}}, {"type": "a", "start": 28910, "end": 28918, "id": 874, "features": {"href": "/wiki/Word2vec", "title": "Word2vec"}}, {"type": "h2", "start": 28919, "end": 28934, "id": 875, "features": {"class": "section-heading", "onclick": "javascript:mfTempOpenSection(6)"}}, {"type": "div", "start": 28919, "end": 28919, "id": 876, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left"}}, {"type": "span", "start": 28919, "end": 28929, "id": 877, "features": {"class": "mw-headline", "id": "References"}}, {"type": "span", "start": 28929, "end": 28933, "id": 878, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 28929, "end": 28933, "id": 879, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=18", "title": "Edit section: References", "data-section": "18", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "section", "start": 28934, "end": 34686, "id": 880, "features": {"class": "mf-section-6 collapsible-block", "id": "mf-section-6"}}, {"type": "div", "start": 28934, "end": 34686, "id": 881, "features": {"class": "reflist columns references-column-width", "style": "-moz-column-width: 30em; -webkit-column-width: 30em; column-width: 30em; list-style-type: decimal;"}}, {"type": "ol", "start": 28934, "end": 34686, "id": 882, "features": {"class": "references"}}, {"type": "li", "start": 28934, "end": 29251, "id": 883, "features": {"id": "cite_note-Kongthon-1"}}, {"type": "span", "start": 28934, "end": 28935, "id": 884, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 28934, "end": 28935, "id": 885, "features": {}}, {"type": "a", "start": 28934, "end": 28935, "id": 886, "features": {"href": "#cite_ref-Kongthon_1-0"}}, {"type": "span", "start": 28936, "end": 29250, "id": 887, "features": {"class": "reference-text"}}, {"type": "cite", "start": 28936, "end": 29250, "id": 888, "features": {"id": "CITEREFKongthonSangkeettrakarnKongyoungHaruechaiyasak2009", "class": "citation conference cs1"}}, {"type": "i", "start": 29052, "end": 29121, "id": 889, "features": {}}, {"type": "a", "start": 29222, "end": 29225, "id": 890, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 29226, "end": 29249, "id": 891, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1145%2F1643823.1643908"}}, {"type": "span", "start": 29250, "end": 29250, "id": 892, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=conference&rft.btitle=Implementing+an+online+help+desk+system+based+on+conversational+agent&rft.place=France&rft.pub=ACM&rft.date=2009-10-27%2F2009-10-30&rft_id=info%3Adoi%2F10.1145%2F1643823.1643908&rft.aulast=Kongthon&rft.aufirst=Alisa&rft.au=Sangkeettrakarn%2C+Chatchawal&rft.au=Kongyoung%2C+Sarawoot&rft.au=Haruechaiyasak%2C+Choochart&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "li", "start": 29251, "end": 29355, "id": 893, "features": {"id": "cite_note-2"}}, {"type": "span", "start": 29251, "end": 29252, "id": 894, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 29251, "end": 29252, "id": 895, "features": {}}, {"type": "a", "start": 29251, "end": 29252, "id": 896, "features": {"href": "#cite_ref-2"}}, {"type": "span", "start": 29253, "end": 29354, "id": 897, "features": {"class": "reference-text"}}, {"type": "cite", "start": 29253, "end": 29331, "id": 898, "features": {"id": "CITEREFHutchins,_J.2005", "class": "citation web cs1"}}, {"type": "a", "start": 29274, "end": 29324, "id": 899, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.hutchinsweb.me.uk/Nutshell-2005.pdf"}}, {"type": "span", "start": 29325, "end": 29330, "id": 900, "features": {"class": "cs1-format"}}, {"type": "span", "start": 29331, "end": 29331, "id": 901, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=unknown&rft.btitle=The+history+of+machine+translation+in+a+nutshell&rft.date=2005&rft.au=Hutchins%2C+J.&rft_id=http%3A%2F%2Fwww.hutchinsweb.me.uk%2FNutshell-2005.pdf&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 29331, "end": 29331, "id": 902, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "sup", "start": 29331, "end": 29354, "id": 903, "features": {"class": "noprint Inline-Template", "style": "white-space:nowrap;"}}, {"type": "i", "start": 29332, "end": 29353, "id": 904, "features": {}}, {"type": "a", "start": 29332, "end": 29353, "id": 905, "features": {"href": "/wiki/Wikipedia:Verifiability#Self-published_sources", "title": "Wikipedia:Verifiability"}}, {"type": "span", "start": 29332, "end": 29353, "id": 906, "features": {"title": "This reference citation appears to be to a self-published source. (December 2013)"}}, {"type": "li", "start": 29355, "end": 29541, "id": 907, "features": {"id": "cite_note-3"}}, {"type": "span", "start": 29355, "end": 29356, "id": 908, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 29355, "end": 29356, "id": 909, "features": {}}, {"type": "a", "start": 29355, "end": 29356, "id": 910, "features": {"href": "#cite_ref-3"}}, {"type": "span", "start": 29357, "end": 29540, "id": 911, "features": {"class": "reference-text"}}, {"type": "cite", "start": 29357, "end": 29540, "id": 912, "features": {"id": "CITEREFKoskenniemi1983", "class": "citation cs2"}}, {"type": "a", "start": 29357, "end": 29375, "id": 913, "features": {"href": "/wiki/Kimmo_Koskenniemi", "title": "Kimmo Koskenniemi"}}, {"type": "a", "start": 29384, "end": 29475, "id": 914, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.ling.helsinki.fi/~koskenni/doc/Two-LevelMorphology.pdf"}}, {"type": "i", "start": 29384, "end": 29475, "id": 915, "features": {}}, {"type": "span", "start": 29476, "end": 29481, "id": 916, "features": {"class": "cs1-format"}}, {"type": "a", "start": 29518, "end": 29540, "id": 917, "features": {"href": "/wiki/University_of_Helsinki", "title": "University of Helsinki"}}, {"type": "span", "start": 29540, "end": 29540, "id": 918, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Two-level+morphology%3A+A+general+computational+model+of+word-form+recognition+and+production&rft.pub=Department+of+General+Linguistics%2C+University+of+Helsinki&rft.date=1983&rft.aulast=Koskenniemi&rft.aufirst=Kimmo&rft_id=http%3A%2F%2Fwww.ling.helsinki.fi%2F~koskenni%2Fdoc%2FTwo-LevelMorphology.pdf&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 29540, "end": 29540, "id": 919, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 29541, "end": 29690, "id": 920, "features": {"id": "cite_note-4"}}, {"type": "span", "start": 29541, "end": 29542, "id": 921, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 29541, "end": 29542, "id": 922, "features": {}}, {"type": "a", "start": 29541, "end": 29542, "id": 923, "features": {"href": "#cite_ref-4"}}, {"type": "span", "start": 29543, "end": 29689, "id": 924, "features": {"class": "reference-text"}}, {"type": "a", "start": 29589, "end": 29664, "id": 925, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.ijcai.org/Proceedings/81-1/Papers/071.pdf"}}, {"type": "i", "start": 29669, "end": 29674, "id": 926, "features": {}}, {"type": "li", "start": 29690, "end": 29907, "id": 927, "features": {"id": "cite_note-5"}}, {"type": "span", "start": 29690, "end": 29691, "id": 928, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 29690, "end": 29691, "id": 929, "features": {}}, {"type": "a", "start": 29690, "end": 29691, "id": 930, "features": {"href": "#cite_ref-5"}}, {"type": "span", "start": 29692, "end": 29906, "id": 931, "features": {"class": "reference-text"}}, {"type": "cite", "start": 29692, "end": 29906, "id": 932, "features": {"id": "CITEREFGuidaMauri1986", "class": "citation journal cs1"}}, {"type": "i", "start": 29802, "end": 29825, "id": 933, "features": {}}, {"type": "b", "start": 29827, "end": 29829, "id": 934, "features": {}}, {"type": "a", "start": 29846, "end": 29849, "id": 935, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 29850, "end": 29873, "id": 936, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1109%2FPROC.1986.13580"}}, {"type": "a", "start": 29875, "end": 29879, "id": 937, "features": {"href": "/wiki/ISSN_(identifier)", "class": "mw-redirect", "title": "ISSN (identifier)"}}, {"type": "a", "start": 29880, "end": 29889, "id": 938, "features": {"rel": "nofollow", "class": "external text", "href": "//www.worldcat.org/issn/1558-2256"}}, {"type": "a", "start": 29891, "end": 29896, "id": 939, "features": {"href": "/wiki/S2CID_(identifier)", "class": "mw-redirect", "title": "S2CID (identifier)"}}, {"type": "a", "start": 29897, "end": 29905, "id": 940, "features": {"rel": "nofollow", "class": "external text", "href": "https://api.semanticscholar.org/CorpusID:30688575"}}, {"type": "span", "start": 29906, "end": 29906, "id": 941, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Proceedings+of+the+IEEE&rft.atitle=Evaluation+of+natural+language+processing+systems%3A+Issues+and+approaches&rft.volume=74&rft.issue=7&rft.pages=1026-1035&rft.date=1986-07&rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A30688575&rft.issn=1558-2256&rft_id=info%3Adoi%2F10.1109%2FPROC.1986.13580&rft.aulast=Guida&rft.aufirst=G.&rft.au=Mauri%2C+G.&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 29906, "end": 29906, "id": 942, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 29907, "end": 30756, "id": 943, "features": {"id": "cite_note-6"}}, {"type": "span", "start": 29907, "end": 29908, "id": 944, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 29907, "end": 29908, "id": 945, "features": {}}, {"type": "a", "start": 29907, "end": 29908, "id": 946, "features": {"href": "#cite_ref-6"}}, {"type": "span", "start": 29909, "end": 30755, "id": 947, "features": {"class": "reference-text"}}, {"type": "a", "start": 29964, "end": 29976, "id": 948, "features": {"href": "/wiki/Corner_case", "title": "Corner case"}}, {"type": "a", "start": 30042, "end": 30054, "id": 949, "features": {"href": "/wiki/Pathological_(mathematics)", "title": "Pathological (mathematics)"}}, {"type": "a", "start": 30106, "end": 30125, "id": 950, "features": {"href": "/wiki/Thought_experiment", "title": "Thought experiment"}}, {"type": "a", "start": 30238, "end": 30256, "id": 951, "features": {"href": "/wiki/Corpus_linguistics", "title": "Corpus linguistics"}}, {"type": "a", "start": 30288, "end": 30295, "id": 952, "features": {"href": "/wiki/Text_corpus", "title": "Text corpus"}}, {"type": "a", "start": 30489, "end": 30512, "id": 953, "features": {"href": "/wiki/Poverty_of_the_stimulus", "title": "Poverty of the stimulus"}}, {"type": "li", "start": 30756, "end": 30964, "id": 954, "features": {"id": "cite_note-goldberg:nnlp17-7"}}, {"type": "span", "start": 30756, "end": 30757, "id": 955, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 30756, "end": 30757, "id": 956, "features": {}}, {"type": "a", "start": 30756, "end": 30757, "id": 957, "features": {"href": "#cite_ref-goldberg:nnlp17_7-0"}}, {"type": "span", "start": 30758, "end": 30963, "id": 958, "features": {"class": "reference-text"}}, {"type": "cite", "start": 30758, "end": 30963, "id": 959, "features": {"id": "CITEREFGoldberg2016", "class": "citation journal cs1"}}, {"type": "i", "start": 30850, "end": 30893, "id": 960, "features": {}}, {"type": "b", "start": 30895, "end": 30897, "id": 961, "features": {}}, {"type": "a", "start": 30908, "end": 30913, "id": 962, "features": {"href": "/wiki/ArXiv_(identifier)", "class": "mw-redirect", "title": "ArXiv (identifier)"}}, {"type": "span", "start": 30914, "end": 30924, "id": 963, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 30914, "end": 30924, "id": 964, "features": {"rel": "nofollow", "class": "external text", "href": "//arxiv.org/abs/1807.10854"}}, {"type": "a", "start": 30926, "end": 30929, "id": 965, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 30930, "end": 30947, "id": 966, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1613%2Fjair.4992"}}, {"type": "a", "start": 30949, "end": 30954, "id": 967, "features": {"href": "/wiki/S2CID_(identifier)", "class": "mw-redirect", "title": "S2CID (identifier)"}}, {"type": "a", "start": 30955, "end": 30962, "id": 968, "features": {"rel": "nofollow", "class": "external text", "href": "https://api.semanticscholar.org/CorpusID:8273530"}}, {"type": "span", "start": 30963, "end": 30963, "id": 969, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Journal+of+Artificial+Intelligence+Research&rft.atitle=A+Primer+on+Neural+Network+Models+for+Natural+Language+Processing&rft.volume=57&rft.pages=345-420&rft.date=2016&rft_id=info%3Aarxiv%2F1807.10854&rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A8273530&rft_id=info%3Adoi%2F10.1613%2Fjair.4992&rft.aulast=Goldberg&rft.aufirst=Yoav&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 30963, "end": 30963, "id": 970, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 30964, "end": 31050, "id": 971, "features": {"id": "cite_note-goodfellow:book16-8"}}, {"type": "span", "start": 30964, "end": 30965, "id": 972, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 30964, "end": 30965, "id": 973, "features": {}}, {"type": "a", "start": 30964, "end": 30965, "id": 974, "features": {"href": "#cite_ref-goodfellow:book16_8-0"}}, {"type": "span", "start": 30966, "end": 31049, "id": 975, "features": {"class": "reference-text"}}, {"type": "cite", "start": 30966, "end": 31049, "id": 976, "features": {"id": "CITEREFGoodfellowBengioCourville2016", "class": "citation book cs1"}}, {"type": "a", "start": 31024, "end": 31037, "id": 977, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.deeplearningbook.org/"}}, {"type": "i", "start": 31024, "end": 31037, "id": 978, "features": {}}, {"type": "span", "start": 31049, "end": 31049, "id": 979, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Deep+Learning&rft.pub=MIT+Press&rft.date=2016&rft.aulast=Goodfellow&rft.aufirst=Ian&rft.au=Bengio%2C+Yoshua&rft.au=Courville%2C+Aaron&rft_id=http%3A%2F%2Fwww.deeplearningbook.org%2F&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 31049, "end": 31049, "id": 980, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 31050, "end": 31228, "id": 981, "features": {"id": "cite_note-jozefowicz:lm16-9"}}, {"type": "span", "start": 31050, "end": 31051, "id": 982, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 31050, "end": 31051, "id": 983, "features": {}}, {"type": "a", "start": 31050, "end": 31051, "id": 984, "features": {"href": "#cite_ref-jozefowicz:lm16_9-0"}}, {"type": "span", "start": 31052, "end": 31227, "id": 985, "features": {"class": "reference-text"}}, {"type": "cite", "start": 31052, "end": 31227, "id": 986, "features": {"id": "CITEREFJozefowiczVinyalsSchusterShazeer2016", "class": "citation book cs1"}}, {"type": "i", "start": 31138, "end": 31179, "id": 987, "features": {}}, {"type": "a", "start": 31181, "end": 31186, "id": 988, "features": {"href": "/wiki/ArXiv_(identifier)", "class": "mw-redirect", "title": "ArXiv (identifier)"}}, {"type": "span", "start": 31187, "end": 31197, "id": 989, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 31187, "end": 31197, "id": 990, "features": {"rel": "nofollow", "class": "external text", "href": "//arxiv.org/abs/1602.02410"}}, {"type": "a", "start": 31199, "end": 31206, "id": 991, "features": {"href": "/wiki/Bibcode_(identifier)", "class": "mw-redirect", "title": "Bibcode (identifier)"}}, {"type": "a", "start": 31207, "end": 31226, "id": 992, "features": {"rel": "nofollow", "class": "external text", "href": "https://ui.adsabs.harvard.edu/abs/2016arXiv160202410J"}}, {"type": "span", "start": 31227, "end": 31227, "id": 993, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Exploring+the+Limits+of+Language+Modeling&rft.date=2016&rft_id=info%3Aarxiv%2F1602.02410&rft_id=info%3Abibcode%2F2016arXiv160202410J&rft.aulast=Jozefowicz&rft.aufirst=Rafal&rft.au=Vinyals%2C+Oriol&rft.au=Schuster%2C+Mike&rft.au=Shazeer%2C+Noam&rft.au=Wu%2C+Yonghui&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 31227, "end": 31227, "id": 994, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 31228, "end": 31307, "id": 995, "features": {"id": "cite_note-choe:emnlp16-10"}}, {"type": "span", "start": 31228, "end": 31229, "id": 996, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 31228, "end": 31229, "id": 997, "features": {}}, {"type": "a", "start": 31228, "end": 31229, "id": 998, "features": {"href": "#cite_ref-choe:emnlp16_10-0"}}, {"type": "span", "start": 31230, "end": 31306, "id": 999, "features": {"class": "reference-text"}}, {"type": "cite", "start": 31230, "end": 31306, "id": 1000, "features": {"id": "CITEREFChoeCharniak", "class": "citation journal cs1"}}, {"type": "a", "start": 31263, "end": 31293, "id": 1001, "features": {"rel": "nofollow", "class": "external text", "href": "https://aclanthology.coli.uni-saarland.de/papers/D16-1257/d16-1257"}}, {"type": "i", "start": 31295, "end": 31305, "id": 1002, "features": {}}, {"type": "span", "start": 31306, "end": 31306, "id": 1003, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Emnlp+2016&rft.atitle=Parsing+as+Language+Modeling&rft.aulast=Choe&rft.aufirst=Do+Kook&rft.au=Charniak%2C+Eugene&rft_id=https%3A%2F%2Faclanthology.coli.uni-saarland.de%2Fpapers%2FD16-1257%2Fd16-1257&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 31306, "end": 31306, "id": 1004, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 31307, "end": 31436, "id": 1005, "features": {"id": "cite_note-vinyals:nips15-11"}}, {"type": "span", "start": 31307, "end": 31308, "id": 1006, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 31307, "end": 31308, "id": 1007, "features": {}}, {"type": "a", "start": 31307, "end": 31308, "id": 1008, "features": {"href": "#cite_ref-vinyals:nips15_11-0"}}, {"type": "span", "start": 31309, "end": 31435, "id": 1009, "features": {"class": "reference-text"}}, {"type": "cite", "start": 31309, "end": 31435, "id": 1010, "features": {"id": "CITEREFVinyalsKaiser2014", "class": "citation journal cs1"}}, {"type": "a", "start": 31341, "end": 31372, "id": 1011, "features": {"rel": "nofollow", "class": "external text", "href": "https://papers.nips.cc/paper/5635-grammar-as-a-foreign-language.pdf"}}, {"type": "span", "start": 31373, "end": 31378, "id": 1012, "features": {"class": "cs1-format"}}, {"type": "i", "start": 31380, "end": 31388, "id": 1013, "features": {}}, {"type": "a", "start": 31390, "end": 31395, "id": 1014, "features": {"href": "/wiki/ArXiv_(identifier)", "class": "mw-redirect", "title": "ArXiv (identifier)"}}, {"type": "span", "start": 31396, "end": 31405, "id": 1015, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 31396, "end": 31405, "id": 1016, "features": {"rel": "nofollow", "class": "external text", "href": "//arxiv.org/abs/1412.7449"}}, {"type": "a", "start": 31407, "end": 31414, "id": 1017, "features": {"href": "/wiki/Bibcode_(identifier)", "class": "mw-redirect", "title": "Bibcode (identifier)"}}, {"type": "a", "start": 31415, "end": 31434, "id": 1018, "features": {"rel": "nofollow", "class": "external text", "href": "https://ui.adsabs.harvard.edu/abs/2014arXiv1412.7449V"}}, {"type": "span", "start": 31435, "end": 31435, "id": 1019, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Nips2015&rft.atitle=Grammar+as+a+Foreign+Language&rft.date=2014&rft_id=info%3Aarxiv%2F1412.7449&rft_id=info%3Abibcode%2F2014arXiv1412.7449V&rft.aulast=Vinyals&rft.aufirst=Oriol&rft.au=Kaiser%2C+Lukasz&rft_id=https%3A%2F%2Fpapers.nips.cc%2Fpaper%2F5635-grammar-as-a-foreign-language.pdf&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 31435, "end": 31435, "id": 1020, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 31436, "end": 31569, "id": 1021, "features": {"id": "cite_note-winograd:shrdlu71-12"}}, {"type": "span", "start": 31436, "end": 31437, "id": 1022, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 31436, "end": 31437, "id": 1023, "features": {}}, {"type": "a", "start": 31436, "end": 31437, "id": 1024, "features": {"href": "#cite_ref-winograd:shrdlu71_12-0"}}, {"type": "span", "start": 31438, "end": 31568, "id": 1025, "features": {"class": "reference-text"}}, {"type": "cite", "start": 31438, "end": 31568, "id": 1026, "features": {"id": "CITEREFWinograd1971", "class": "citation thesis cs1"}}, {"type": "a", "start": 31462, "end": 31558, "id": 1027, "features": {"rel": "nofollow", "class": "external text", "href": "http://hci.stanford.edu/winograd/shrdlu/"}}, {"type": "i", "start": 31462, "end": 31558, "id": 1028, "features": {}}, {"type": "span", "start": 31568, "end": 31568, "id": 1029, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Adissertation&rft.title=Procedures+as+a+Representation+for+Data+in+a+Computer+Program+for+Understanding+Natural+Language&rft.date=1971&rft.aulast=Winograd&rft.aufirst=Terry&rft_id=http%3A%2F%2Fhci.stanford.edu%2Fwinograd%2Fshrdlu%2F&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 31568, "end": 31568, "id": 1030, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 31569, "end": 31744, "id": 1031, "features": {"id": "cite_note-schank77-13"}}, {"type": "span", "start": 31569, "end": 31570, "id": 1032, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 31569, "end": 31570, "id": 1033, "features": {}}, {"type": "a", "start": 31569, "end": 31570, "id": 1034, "features": {"href": "#cite_ref-schank77_13-0"}}, {"type": "span", "start": 31571, "end": 31743, "id": 1035, "features": {"class": "reference-text"}}, {"type": "cite", "start": 31571, "end": 31743, "id": 1036, "features": {"id": "CITEREFSchankAbelson1977", "class": "citation book cs1"}}, {"type": "i", "start": 31616, "end": 31700, "id": 1037, "features": {}}, {"type": "a", "start": 31722, "end": 31726, "id": 1038, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 31727, "end": 31742, "id": 1039, "features": {"href": "/wiki/Special:BookSources/0-470-99033-3", "title": "Special:BookSources/0-470-99033-3"}}, {"type": "bdi", "start": 31728, "end": 31742, "id": 1040, "features": {}}, {"type": "span", "start": 31743, "end": 31743, "id": 1041, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Scripts%2C+Plans%2C+Goals%2C+and+Understanding%3A+An+Inquiry+Into+Human+Knowledge+Structures&rft.place=Hillsdale&rft.pub=Erlbaum&rft.date=1977&rft.isbn=0-470-99033-3&rft.aulast=Schank&rft.aufirst=Roger+C.&rft.au=Abelson%2C+Robert+P.&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 31743, "end": 31743, "id": 1042, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 31744, "end": 31936, "id": 1043, "features": {"id": "cite_note-johnson:eacl:ilcl09-14"}}, {"type": "span", "start": 31744, "end": 31745, "id": 1044, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 31744, "end": 31745, "id": 1045, "features": {}}, {"type": "a", "start": 31744, "end": 31745, "id": 1046, "features": {"href": "#cite_ref-johnson:eacl:ilcl09_14-0"}}, {"type": "span", "start": 31746, "end": 31935, "id": 1047, "features": {"class": "reference-text"}}, {"type": "a", "start": 31746, "end": 31827, "id": 1048, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.aclweb.org/anthology/W09-0103"}}, {"type": "li", "start": 31936, "end": 32003, "id": 1049, "features": {"id": "cite_note-resnik:langlog11-15"}}, {"type": "span", "start": 31936, "end": 31937, "id": 1050, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 31936, "end": 31937, "id": 1051, "features": {}}, {"type": "a", "start": 31936, "end": 31937, "id": 1052, "features": {"href": "#cite_ref-resnik:langlog11_15-0"}}, {"type": "span", "start": 31938, "end": 32002, "id": 1053, "features": {"class": "reference-text"}}, {"type": "a", "start": 31938, "end": 31970, "id": 1054, "features": {"rel": "nofollow", "class": "external text", "href": "http://languagelog.ldc.upenn.edu/nll/?p=2946"}}, {"type": "li", "start": 32003, "end": 32413, "id": 1055, "features": {"id": "cite_note-16"}}, {"type": "span", "start": 32003, "end": 32004, "id": 1056, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 32003, "end": 32004, "id": 1057, "features": {}}, {"type": "a", "start": 32003, "end": 32004, "id": 1058, "features": {"href": "#cite_ref-16"}}, {"type": "span", "start": 32005, "end": 32412, "id": 1059, "features": {"class": "reference-text"}}, {"type": "cite", "start": 32005, "end": 32102, "id": 1060, "features": {"id": "CITEREFSocher", "class": "citation web cs1"}}, {"type": "a", "start": 32022, "end": 32063, "id": 1061, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.socher.org/index.php/Main/DeepLearningForNLP-ACL2012Tutorial"}}, {"type": "i", "start": 32065, "end": 32079, "id": 1062, "features": {}}, {"type": "span", "start": 32079, "end": 32101, "id": 1063, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 32091, "end": 32101, "id": 1064, "features": {"class": "nowrap"}}, {"type": "span", "start": 32102, "end": 32102, "id": 1065, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=www.socher.org&rft.atitle=Deep+Learning+For+NLP-ACL+2012+Tutorial&rft.aulast=Socher&rft.aufirst=Richard&rft_id=https%3A%2F%2Fwww.socher.org%2Findex.php%2FMain%2FDeepLearningForNLP-ACL2012Tutorial&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 32102, "end": 32102, "id": 1066, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 32413, "end": 32682, "id": 1067, "features": {"id": "cite_note-17"}}, {"type": "span", "start": 32413, "end": 32414, "id": 1068, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 32413, "end": 32414, "id": 1069, "features": {}}, {"type": "a", "start": 32413, "end": 32414, "id": 1070, "features": {"href": "#cite_ref-17"}}, {"type": "span", "start": 32415, "end": 32682, "id": 1071, "features": {"class": "reference-text"}}, {"type": "cite", "start": 32415, "end": 32682, "id": 1072, "features": {"id": "CITEREFYiTian2012", "class": "citation cs2"}}, {"type": "i", "start": 32516, "end": 32562, "id": 1073, "features": {}}, {"type": "a", "start": 32603, "end": 32612, "id": 1074, "features": {"href": "/wiki/CiteSeerX_(identifier)", "class": "mw-redirect", "title": "CiteSeerX (identifier)"}}, {"type": "span", "start": 32613, "end": 32627, "id": 1075, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 32613, "end": 32627, "id": 1076, "features": {"rel": "nofollow", "class": "external text", "href": "//citeseerx.ist.psu.edu/viewdoc/summary?doi=10.1.1.668.869"}}, {"type": "a", "start": 32629, "end": 32632, "id": 1077, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 32633, "end": 32660, "id": 1078, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1007%2F978-3-642-29364-1_2"}}, {"type": "a", "start": 32662, "end": 32666, "id": 1079, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 32667, "end": 32682, "id": 1080, "features": {"href": "/wiki/Special:BookSources/9783642293634", "title": "Special:BookSources/9783642293634"}}, {"type": "bdi", "start": 32668, "end": 32682, "id": 1081, "features": {}}, {"type": "span", "start": 32682, "end": 32682, "id": 1082, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Camera-Based+Document+Analysis+and+Recognition&rft.atitle=Assistive+Text+Reading+from+Complex+Background+for+Blind+Persons&rft.pages=15-28&rft.date=2012&rft_id=%2F%2Fciteseerx.ist.psu.edu%2Fviewdoc%2Fsummary%3Fdoi%3D10.1.1.668.869&rft_id=info%3Adoi%2F10.1007%2F978-3-642-29364-1_2&rft.isbn=9783642293634&rft.aulast=Yi&rft.aufirst=Chucai&rft.au=Tian%2C+Yingli&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 32682, "end": 32682, "id": 1083, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 32682, "end": 32956, "id": 1084, "features": {"id": "cite_note-18"}}, {"type": "span", "start": 32682, "end": 32683, "id": 1085, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 32682, "end": 32683, "id": 1086, "features": {}}, {"type": "a", "start": 32682, "end": 32683, "id": 1087, "features": {"href": "#cite_ref-18"}}, {"type": "span", "start": 32684, "end": 32955, "id": 1088, "features": {"class": "reference-text"}}, {"type": "cite", "start": 32684, "end": 32929, "id": 1089, "features": {"id": "CITEREFKishorjitVidyaNirmalSivaji2012", "class": "citation journal cs1"}}, {"type": "a", "start": 32746, "end": 32780, "id": 1090, "features": {"rel": "nofollow", "class": "external text", "href": "http://aclweb.org/anthology//W/W12/W12-5008.pdf"}}, {"type": "span", "start": 32781, "end": 32786, "id": 1091, "features": {"class": "cs1-format"}}, {"type": "i", "start": 32788, "end": 32884, "id": 1092, "features": {}}, {"type": "span", "start": 32929, "end": 32929, "id": 1093, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Proceedings+of+the+3rd+Workshop+on+South+and+Southeast+Asian+Natural+Language+Processing+%28SANLP%29&rft.atitle=Manipuri+Morpheme+Identification&rft.pages=95-108&rft.date=2012&rft.aulast=Kishorjit&rft.aufirst=N.&rft.au=Vidya%2C+Raj+RK.&rft.au=Nirmal%2C+Y.&rft.au=Sivaji%2C+B.&rft_id=http%3A%2F%2Faclweb.org%2Fanthology%2F%2FW%2FW12%2FW12-5008.pdf&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "span", "start": 32929, "end": 32955, "id": 1094, "features": {"class": "cs1-maint citation-comment"}}, {"type": "a", "start": 32950, "end": 32954, "id": 1095, "features": {"href": "/wiki/Category:CS1_maint:_location", "title": "Category:CS1 maint: location"}}, {"type": "link", "start": 32955, "end": 32955, "id": 1096, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 32956, "end": 33131, "id": 1097, "features": {"id": "cite_note-19"}}, {"type": "span", "start": 32956, "end": 32957, "id": 1098, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 32956, "end": 32957, "id": 1099, "features": {}}, {"type": "a", "start": 32956, "end": 32957, "id": 1100, "features": {"href": "#cite_ref-19"}}, {"type": "span", "start": 32958, "end": 33130, "id": 1101, "features": {"class": "reference-text"}}, {"type": "cite", "start": 32958, "end": 33130, "id": 1102, "features": {"id": "CITEREFKleinManning2002", "class": "citation journal cs1"}}, {"type": "a", "start": 33002, "end": 33072, "id": 1103, "features": {"rel": "nofollow", "class": "external text", "href": "http://papers.nips.cc/paper/1945-natural-language-grammar-induction-using-a-constituent-context-model.pdf"}}, {"type": "span", "start": 33073, "end": 33078, "id": 1104, "features": {"class": "cs1-format"}}, {"type": "i", "start": 33080, "end": 33129, "id": 1105, "features": {}}, {"type": "span", "start": 33130, "end": 33130, "id": 1106, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Advances+in+Neural+Information+Processing+Systems&rft.atitle=Natural+language+grammar+induction+using+a+constituent-context+model&rft.date=2002&rft.aulast=Klein&rft.aufirst=Dan&rft.au=Manning%2C+Christopher+D.&rft_id=http%3A%2F%2Fpapers.nips.cc%2Fpaper%2F1945-natural-language-grammar-induction-using-a-constituent-context-model.pdf&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 33130, "end": 33130, "id": 1107, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 33131, "end": 33221, "id": 1108, "features": {"id": "cite_note-rte:11-20"}}, {"type": "span", "start": 33131, "end": 33132, "id": 1109, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 33131, "end": 33132, "id": 1110, "features": {}}, {"type": "a", "start": 33131, "end": 33132, "id": 1111, "features": {"href": "#cite_ref-rte:11_20-0"}}, {"type": "span", "start": 33133, "end": 33220, "id": 1112, "features": {"class": "reference-text"}}, {"type": "a", "start": 33189, "end": 33220, "id": 1113, "features": {"rel": "nofollow", "class": "external free", "href": "https://tac.nist.gov//2011/RTE/"}}, {"type": "li", "start": 33221, "end": 33283, "id": 1114, "features": {"id": "cite_note-21"}}, {"type": "span", "start": 33221, "end": 33222, "id": 1115, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 33221, "end": 33222, "id": 1116, "features": {}}, {"type": "a", "start": 33221, "end": 33222, "id": 1117, "features": {"href": "#cite_ref-21"}}, {"type": "span", "start": 33223, "end": 33282, "id": 1118, "features": {"class": "reference-text"}}, {"type": "cite", "start": 33223, "end": 33282, "id": 1119, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 33223, "end": 33246, "id": 1120, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.ubu.com/historical/racter/index.html"}}, {"type": "i", "start": 33248, "end": 33259, "id": 1121, "features": {}}, {"type": "span", "start": 33259, "end": 33281, "id": 1122, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 33271, "end": 33281, "id": 1123, "features": {"class": "nowrap"}}, {"type": "span", "start": 33282, "end": 33282, "id": 1124, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=www.ubu.com&rft.atitle=U+B+U+W+E+B+%3A%3A+Racter&rft_id=http%3A%2F%2Fwww.ubu.com%2Fhistorical%2Fracter%2Findex.html&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 33282, "end": 33282, "id": 1125, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 33283, "end": 33386, "id": 1126, "features": {"id": "cite_note-22"}}, {"type": "span", "start": 33283, "end": 33284, "id": 1127, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 33283, "end": 33284, "id": 1128, "features": {}}, {"type": "a", "start": 33283, "end": 33284, "id": 1129, "features": {"href": "#cite_ref-22"}}, {"type": "span", "start": 33285, "end": 33385, "id": 1130, "features": {"class": "reference-text"}}, {"type": "cite", "start": 33285, "end": 33385, "id": 1131, "features": {"id": "CITEREFWriter2019", "class": "citation book cs1"}}, {"type": "i", "start": 33306, "end": 33327, "id": 1132, "features": {}}, {"type": "a", "start": 33329, "end": 33332, "id": 1133, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 33333, "end": 33358, "id": 1134, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1007%2F978-3-030-16800-1"}}, {"type": "a", "start": 33360, "end": 33364, "id": 1135, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 33365, "end": 33384, "id": 1136, "features": {"href": "/wiki/Special:BookSources/978-3-030-16799-8", "title": "Special:BookSources/978-3-030-16799-8"}}, {"type": "bdi", "start": 33366, "end": 33384, "id": 1137, "features": {}}, {"type": "span", "start": 33385, "end": 33385, "id": 1138, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Lithium-Ion+Batteries&rft.date=2019&rft_id=info%3Adoi%2F10.1007%2F978-3-030-16800-1&rft.isbn=978-3-030-16799-8&rft.aulast=Writer&rft.aufirst=Beta&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 33385, "end": 33385, "id": 1139, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 33386, "end": 33632, "id": 1140, "features": {"id": "cite_note-23"}}, {"type": "span", "start": 33386, "end": 33387, "id": 1141, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 33386, "end": 33387, "id": 1142, "features": {}}, {"type": "a", "start": 33386, "end": 33387, "id": 1143, "features": {"href": "#cite_ref-23"}}, {"type": "span", "start": 33388, "end": 33631, "id": 1144, "features": {"class": "reference-text"}}, {"type": "cite", "start": 33388, "end": 33631, "id": 1145, "features": {"id": "CITEREFDuanCruz2011", "class": "citation journal cs1"}}, {"type": "a", "start": 33427, "end": 33510, "id": 1146, "features": {"rel": "nofollow", "class": "external text", "href": "https://web.archive.org/web/20111009135952/http://www.ijimt.org/abstract/100-E00187.htm"}}, {"type": "i", "start": 33512, "end": 33574, "id": 1147, "features": {}}, {"type": "b", "start": 33576, "end": 33577, "id": 1148, "features": {}}, {"type": "a", "start": 33604, "end": 33616, "id": 1149, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.ijimt.org/abstract/100-E00187.htm"}}, {"type": "span", "start": 33631, "end": 33631, "id": 1150, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=International+Journal+of+Innovation%2C+Management+and+Technology&rft.atitle=Formalizing+Semantic+of+Natural+Language+through+Conceptualization+from+Existence&rft.volume=2&rft.issue=1&rft.pages=37-42&rft.date=2011&rft.aulast=Duan&rft.aufirst=Yucong&rft.au=Cruz%2C+Christophe&rft_id=http%3A%2F%2Fwww.ijimt.org%2Fabstract%2F100-E00187.htm&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 33631, "end": 33631, "id": 1151, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 33632, "end": 33835, "id": 1152, "features": {"id": "cite_note-24"}}, {"type": "span", "start": 33632, "end": 33633, "id": 1153, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 33632, "end": 33633, "id": 1154, "features": {}}, {"type": "a", "start": 33632, "end": 33633, "id": 1155, "features": {"href": "#cite_ref-24"}}, {"type": "span", "start": 33634, "end": 33834, "id": 1156, "features": {"class": "reference-text"}}, {"type": "cite", "start": 33634, "end": 33834, "id": 1157, "features": {"id": "CITEREFMittal2011", "class": "citation journal cs1"}}, {"type": "a", "start": 33649, "end": 33708, "id": 1158, "features": {"rel": "nofollow", "class": "external text", "href": "https://hal.archives-ouvertes.fr/hal-01104648/file/Mittal_VersatileQA_IJIIDS.pdf"}}, {"type": "span", "start": 33709, "end": 33714, "id": 1159, "features": {"class": "cs1-format"}}, {"type": "i", "start": 33716, "end": 33785, "id": 1160, "features": {}}, {"type": "b", "start": 33787, "end": 33788, "id": 1161, "features": {}}, {"type": "a", "start": 33803, "end": 33806, "id": 1162, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 33807, "end": 33833, "id": 1163, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1504%2FIJIIDS.2011.038968"}}, {"type": "span", "start": 33834, "end": 33834, "id": 1164, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=International+Journal+of+Intelligent+Information+and+Database+Systems&rft.atitle=Versatile+question+answering+systems%3A+seeing+in+synthesis&rft.volume=5&rft.issue=2&rft.pages=119-142&rft.date=2011&rft_id=info%3Adoi%2F10.1504%2FIJIIDS.2011.038968&rft.au=Mittal&rft_id=https%3A%2F%2Fhal.archives-ouvertes.fr%2Fhal-01104648%2Ffile%2FMittal_VersatileQA_IJIIDS.pdf&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 33834, "end": 33834, "id": 1165, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 33835, "end": 33924, "id": 1166, "features": {"id": "cite_note-25"}}, {"type": "span", "start": 33835, "end": 33836, "id": 1167, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 33835, "end": 33836, "id": 1168, "features": {}}, {"type": "a", "start": 33835, "end": 33836, "id": 1169, "features": {"href": "#cite_ref-25"}}, {"type": "span", "start": 33837, "end": 33923, "id": 1170, "features": {"class": "reference-text"}}, {"type": "cite", "start": 33837, "end": 33923, "id": 1171, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 33837, "end": 33848, "id": 1172, "features": {"rel": "nofollow", "class": "external text", "href": "https://www.lexico.com/definition/cognition"}}, {"type": "i", "start": 33850, "end": 33856, "id": 1173, "features": {}}, {"type": "a", "start": 33858, "end": 33881, "id": 1174, "features": {"href": "/wiki/Oxford_University_Press", "title": "Oxford University Press"}}, {"type": "a", "start": 33886, "end": 33900, "id": 1175, "features": {"href": "/wiki/Dictionary.com", "title": "Dictionary.com"}}, {"type": "span", "start": 33900, "end": 33922, "id": 1176, "features": {"class": "reference-accessdate"}}, {"type": "span", "start": 33912, "end": 33917, "id": 1177, "features": {"class": "nowrap"}}, {"type": "span", "start": 33923, "end": 33923, "id": 1178, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=Lexico&rft.atitle=Cognition&rft_id=https%3A%2F%2Fwww.lexico.com%2Fdefinition%2Fcognition&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 33923, "end": 33923, "id": 1179, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 33924, "end": 34193, "id": 1180, "features": {"id": "cite_note-26"}}, {"type": "span", "start": 33924, "end": 33925, "id": 1181, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 33924, "end": 33925, "id": 1182, "features": {}}, {"type": "a", "start": 33924, "end": 33925, "id": 1183, "features": {"href": "#cite_ref-26"}}, {"type": "span", "start": 33926, "end": 34192, "id": 1184, "features": {"class": "reference-text"}}, {"type": "cite", "start": 33926, "end": 34192, "id": 1185, "features": {"class": "citation web cs1"}}, {"type": "a", "start": 33926, "end": 33955, "id": 1186, "features": {"rel": "nofollow", "class": "external text", "href": "http://www.aft.org/newspubs/periodicals/ae/summer2002/willingham.cfm"}}, {"type": "i", "start": 33957, "end": 33988, "id": 1187, "features": {}}, {"type": "q", "start": 34005, "end": 34192, "id": 1188, "features": {}}, {"type": "span", "start": 34192, "end": 34192, "id": 1189, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=unknown&rft.jtitle=American+Federation+of+Teachers&rft.atitle=Ask+the+Cognitive+Scientist&rft.date=2014-08-08&rft_id=http%3A%2F%2Fwww.aft.org%2Fnewspubs%2Fperiodicals%2Fae%2Fsummer2002%2Fwillingham.cfm&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 34192, "end": 34192, "id": 1190, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 34193, "end": 34332, "id": 1191, "features": {"id": "cite_note-27"}}, {"type": "span", "start": 34193, "end": 34194, "id": 1192, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 34193, "end": 34194, "id": 1193, "features": {}}, {"type": "a", "start": 34193, "end": 34194, "id": 1194, "features": {"href": "#cite_ref-27"}}, {"type": "span", "start": 34195, "end": 34331, "id": 1195, "features": {"class": "reference-text"}}, {"type": "cite", "start": 34195, "end": 34331, "id": 1196, "features": {"id": "CITEREFRobinson2008", "class": "citation book cs1"}}, {"type": "i", "start": 34219, "end": 34284, "id": 1197, "features": {}}, {"type": "a", "start": 34306, "end": 34310, "id": 1198, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 34311, "end": 34330, "id": 1199, "features": {"href": "/wiki/Special:BookSources/978-0-805-85352-0", "title": "Special:BookSources/978-0-805-85352-0"}}, {"type": "bdi", "start": 34312, "end": 34330, "id": 1200, "features": {}}, {"type": "span", "start": 34331, "end": 34331, "id": 1201, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Handbook+of+Cognitive+Linguistics+and+Second+Language+Acquisition&rft.pages=3-8&rft.pub=Routledge&rft.date=2008&rft.isbn=978-0-805-85352-0&rft.aulast=Robinson&rft.aufirst=Peter&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 34331, "end": 34331, "id": 1202, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 34332, "end": 34552, "id": 1203, "features": {"id": "cite_note-28"}}, {"type": "span", "start": 34332, "end": 34333, "id": 1204, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 34332, "end": 34333, "id": 1205, "features": {}}, {"type": "a", "start": 34332, "end": 34333, "id": 1206, "features": {"href": "#cite_ref-28"}}, {"type": "span", "start": 34334, "end": 34551, "id": 1207, "features": {"class": "reference-text"}}, {"type": "cite", "start": 34334, "end": 34551, "id": 1208, "features": {"id": "CITEREFLakoff1999", "class": "citation book cs1"}}, {"type": "i", "start": 34357, "end": 34489, "id": 1209, "features": {}}, {"type": "a", "start": 34526, "end": 34530, "id": 1210, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 34531, "end": 34550, "id": 1211, "features": {"href": "/wiki/Special:BookSources/978-0-465-05674-3", "title": "Special:BookSources/978-0-465-05674-3"}}, {"type": "bdi", "start": 34532, "end": 34550, "id": 1212, "features": {}}, {"type": "span", "start": 34551, "end": 34551, "id": 1213, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=Philosophy+in+the+Flesh%3A+The+Embodied+Mind+and+Its+Challenge+to+Western+Philosophy%3B+Appendix%3A+The+Neural+Theory+of+Language+Paradigm&rft.pages=569-583&rft.pub=New+York+Basic+Books&rft.date=1999&rft.isbn=978-0-465-05674-3&rft.aulast=Lakoff&rft.aufirst=George&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 34551, "end": 34551, "id": 1214, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 34552, "end": 34686, "id": 1215, "features": {"id": "cite_note-29"}}, {"type": "span", "start": 34552, "end": 34553, "id": 1216, "features": {"class": "mw-cite-backlink"}}, {"type": "b", "start": 34552, "end": 34553, "id": 1217, "features": {}}, {"type": "a", "start": 34552, "end": 34553, "id": 1218, "features": {"href": "#cite_ref-29"}}, {"type": "span", "start": 34554, "end": 34685, "id": 1219, "features": {"class": "reference-text"}}, {"type": "cite", "start": 34554, "end": 34685, "id": 1220, "features": {"id": "CITEREFStrauss1999", "class": "citation book cs1"}}, {"type": "i", "start": 34579, "end": 34617, "id": 1221, "features": {}}, {"type": "a", "start": 34660, "end": 34664, "id": 1222, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 34665, "end": 34684, "id": 1223, "features": {"href": "/wiki/Special:BookSources/978-0-521-59541-4", "title": "Special:BookSources/978-0-521-59541-4"}}, {"type": "bdi", "start": 34666, "end": 34684, "id": 1224, "features": {}}, {"type": "span", "start": 34685, "end": 34685, "id": 1225, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&rft.genre=book&rft.btitle=A+Cognitive+Theory+of+Cultural+Meaning&rft.pages=156-164&rft.pub=Cambridge+University+Press&rft.date=1999&rft.isbn=978-0-521-59541-4&rft.aulast=Strauss&rft.aufirst=Claudia&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 34685, "end": 34685, "id": 1226, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "h2", "start": 34686, "end": 34706, "id": 1227, "features": {"class": "section-heading", "onclick": "javascript:mfTempOpenSection(7)"}}, {"type": "div", "start": 34686, "end": 34686, "id": 1228, "features": {"class": "mw-ui-icon mw-ui-icon-element indicator mw-ui-icon-small mw-ui-icon-flush-left"}}, {"type": "span", "start": 34686, "end": 34701, "id": 1229, "features": {"class": "mw-headline", "id": "Further_reading"}}, {"type": "span", "start": 34701, "end": 34705, "id": 1230, "features": {"class": "mw-editsection"}}, {"type": "a", "start": 34701, "end": 34705, "id": 1231, "features": {"href": "/w/index.php?title=Natural_language_processing&action=edit&section=19", "title": "Edit section: Further reading", "data-section": "19", "class": "mw-ui-icon mw-ui-icon-element mw-ui-icon-wikimedia-edit-base20 edit-page mw-ui-icon-flush-right"}}, {"type": "section", "start": 34706, "end": 36121, "id": 1232, "features": {"class": "mf-section-7 collapsible-block", "id": "mf-section-7"}}, {"type": "div", "start": 34706, "end": 36053, "id": 1233, "features": {"class": "refbegin reflist", "style": ""}}, {"type": "ul", "start": 34706, "end": 36053, "id": 1234, "features": {}}, {"type": "li", "start": 34706, "end": 34951, "id": 1235, "features": {}}, {"type": "cite", "start": 34706, "end": 34950, "id": 1236, "features": {"id": "CITEREFBates1995", "class": "citation journal cs1"}}, {"type": "a", "start": 34723, "end": 34765, "id": 1237, "features": {"rel": "nofollow", "class": "external text", "href": "//www.ncbi.nlm.nih.gov/pmc/articles/PMC40721"}}, {"type": "i", "start": 34767, "end": 34846, "id": 1238, "features": {}}, {"type": "b", "start": 34848, "end": 34850, "id": 1239, "features": {}}, {"type": "a", "start": 34868, "end": 34875, "id": 1240, "features": {"href": "/wiki/Bibcode_(identifier)", "class": "mw-redirect", "title": "Bibcode (identifier)"}}, {"type": "a", "start": 34876, "end": 34895, "id": 1241, "features": {"rel": "nofollow", "class": "external text", "href": "https://ui.adsabs.harvard.edu/abs/1995PNAS...92.9977B"}}, {"type": "a", "start": 34897, "end": 34900, "id": 1242, "features": {"href": "/wiki/Doi_(identifier)", "class": "mw-redirect", "title": "Doi (identifier)"}}, {"type": "a", "start": 34901, "end": 34924, "id": 1243, "features": {"rel": "nofollow", "class": "external text", "href": "https://doi.org/10.1073%2Fpnas.92.22.9977"}}, {"type": "a", "start": 34926, "end": 34929, "id": 1244, "features": {"href": "/wiki/PMC_(identifier)", "class": "mw-redirect", "title": "PMC (identifier)"}}, {"type": "span", "start": 34930, "end": 34935, "id": 1245, "features": {"class": "cs1-lock-free", "title": "Freely accessible"}}, {"type": "a", "start": 34930, "end": 34935, "id": 1246, "features": {"rel": "nofollow", "class": "external text", "href": "//www.ncbi.nlm.nih.gov/pmc/articles/PMC40721"}}, {"type": "a", "start": 34937, "end": 34941, "id": 1247, "features": {"href": "/wiki/PMID_(identifier)", "class": "mw-redirect", "title": "PMID (identifier)"}}, {"type": "a", "start": 34942, "end": 34949, "id": 1248, "features": {"rel": "nofollow", "class": "external text", "href": "//pubmed.ncbi.nlm.nih.gov/7479812"}}, {"type": "span", "start": 34950, "end": 34950, "id": 1249, "features": {"title": "ctx_ver=Z39.88-2004&rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&rft.genre=article&rft.jtitle=Proceedings+of+the+National+Academy+of+Sciences+of+the+United+States+of+America&rft.atitle=Models+of+natural+language+understanding&rft.volume=92&rft.issue=22&rft.pages=9977-9982&rft.date=1995&rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC40721&rft_id=info%3Apmid%2F7479812&rft_id=info%3Adoi%2F10.1073%2Fpnas.92.22.9977&rft_id=info%3Abibcode%2F1995PNAS...92.9977B&rft.aulast=Bates&rft.aufirst=M&rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC40721&rfr_id=info%3Asid%2Fen.wikipedia.org%3ANatural+language+processing", "class": "Z3988"}}, {"type": "link", "start": 34950, "end": 34950, "id": 1250, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "li", "start": 34951, "end": 35082, "id": 1251, "features": {}}, {"type": "i", "start": 35001, "end": 35040, "id": 1252, "features": {}}, {"type": "link", "start": 35058, "end": 35058, "id": 1253, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "a", "start": 35058, "end": 35062, "id": 1254, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 35063, "end": 35080, "id": 1255, "features": {"href": "/wiki/Special:BookSources/978-0-596-51649-9", "title": "Special:BookSources/978-0-596-51649-9"}}, {"type": "li", "start": 35082, "end": 35218, "id": 1256, "features": {}}, {"type": "i", "start": 35126, "end": 35156, "id": 1257, "features": {}}, {"type": "link", "start": 35194, "end": 35194, "id": 1258, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "a", "start": 35194, "end": 35198, "id": 1259, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 35199, "end": 35216, "id": 1260, "features": {"href": "/wiki/Special:BookSources/978-0-13-187321-6", "title": "Special:BookSources/978-0-13-187321-6"}}, {"type": "li", "start": 35218, "end": 35382, "id": 1261, "features": {}}, {"type": "i", "start": 35248, "end": 35337, "id": 1262, "features": {}}, {"type": "link", "start": 35361, "end": 35361, "id": 1263, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "a", "start": 35361, "end": 35365, "id": 1264, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 35366, "end": 35380, "id": 1265, "features": {"href": "/wiki/Special:BookSources/978-1848218482", "title": "Special:BookSources/978-1848218482"}}, {"type": "li", "start": 35382, "end": 35554, "id": 1266, "features": {}}, {"type": "i", "start": 35412, "end": 35509, "id": 1267, "features": {}}, {"type": "link", "start": 35533, "end": 35533, "id": 1268, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "a", "start": 35533, "end": 35537, "id": 1269, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 35538, "end": 35552, "id": 1270, "features": {"href": "/wiki/Special:BookSources/978-1848219212", "title": "Special:BookSources/978-1848219212"}}, {"type": "li", "start": 35554, "end": 35774, "id": 1271, "features": {}}, {"type": "i", "start": 35626, "end": 35663, "id": 1272, "features": {}}, {"type": "link", "start": 35693, "end": 35693, "id": 1273, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "a", "start": 35693, "end": 35697, "id": 1274, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 35698, "end": 35715, "id": 1275, "features": {"href": "/wiki/Special:BookSources/978-0-521-86571-5", "title": "Special:BookSources/978-0-521-86571-5"}}, {"type": "a", "start": 35717, "end": 35773, "id": 1276, "features": {"rel": "nofollow", "class": "external text", "href": "http://nlp.stanford.edu/IR-book/"}}, {"type": "li", "start": 35774, "end": 35920, "id": 1277, "features": {}}, {"type": "i", "start": 35825, "end": 35879, "id": 1278, "features": {}}, {"type": "link", "start": 35896, "end": 35896, "id": 1279, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "a", "start": 35896, "end": 35900, "id": 1280, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 35901, "end": 35918, "id": 1281, "features": {"href": "/wiki/Special:BookSources/978-0-262-13360-9", "title": "Special:BookSources/978-0-262-13360-9"}}, {"type": "li", "start": 35920, "end": 36053, "id": 1282, "features": {}}, {"type": "i", "start": 35974, "end": 36010, "id": 1283, "features": {}}, {"type": "link", "start": 36029, "end": 36029, "id": 1284, "features": {"rel": "mw-deduplicated-inline-style", "href": "mw-data:TemplateStyles:r982806391"}}, {"type": "a", "start": 36029, "end": 36033, "id": 1285, "features": {"href": "/wiki/ISBN_(identifier)", "class": "mw-redirect", "title": "ISBN (identifier)"}}, {"type": "a", "start": 36034, "end": 36051, "id": 1286, "features": {"href": "/wiki/Special:BookSources/978-0-387-19557-5", "title": "Special:BookSources/978-0-387-19557-5"}}, {"type": "table", "start": 36053, "end": 36121, "id": 1287, "features": {"role": "presentation", "class": "mbox-small plainlinks sistersitebox", "style": "background-color:#f9f9f9;border:1px solid #aaa;color:#000"}}, {"type": "tbody", "start": 36053, "end": 36121, "id": 1288, "features": {}}, {"type": "tr", "start": 36053, "end": 36121, "id": 1289, "features": {}}, {"type": "td", "start": 36053, "end": 36120, "id": 1290, "features": {"class": "mbox-text plainlist"}}, {"type": "i", "start": 36092, "end": 36119, "id": 1291, "features": {}}, {"type": "b", "start": 36092, "end": 36119, "id": 1292, "features": {}}, {"type": "a", "start": 36092, "end": 36119, "id": 1293, "features": {"href": "https://commons.wikimedia.org/wiki/Category:Natural_language_processing", "class": "extiw", "title": "commons:Category:Natural language processing"}}, {"type": "noscript", "start": 36121, "end": 36121, "id": 1294, "features": {}}, {"type": "img", "start": 36121, "end": 36121, "id": 1295, "features": {"src": "//en.wikipedia.org/wiki/Special:CentralAutoLogin/start?type=1x1&mobile=1", "alt": "", "title": "", "width": "1", "height": "1", "style": "border: none; position: absolute;"}}, {"type": "div", "start": 36121, "end": 36226, "id": 1296, "features": {"class": "printfooter"}}, {"type": "a", "start": 36138, "end": 36224, "id": 1297, "features": {"dir": "ltr", "href": "https://en.wikipedia.org/w/index.php?title=Natural_language_processing&oldid=990376335"}}, {"type": "div", "start": 36226, "end": 36226, "id": 1298, "features": {"class": "post-content", "id": "page-secondary-actions"}}, {"type": "footer", "start": 36226, "end": 36792, "id": 1299, "features": {"class": "mw-footer minerva-footer", "role": "contentinfo"}}, {"type": "div", "start": 36226, "end": 36268, "id": 1300, "features": {"class": "last-modified-bar"}}, {"type": "div", "start": 36226, "end": 36268, "id": 1301, "features": {"class": "post-content last-modified-bar__content"}}, {"type": "span", "start": 36226, "end": 36226, "id": 1302, "features": {"class": "last-modified-bar__icon mw-ui-icon mw-ui-icon-mw-ui-icon-small mw-ui-icon-wikimedia-history-base20 "}}, {"type": "a", "start": 36226, "end": 36268, "id": 1303, "features": {"class": "last-modified-bar__text modified-enhancement", "href": "/wiki/Special:History/Natural_language_processing", "data-user-name": "112.169.11.245", "data-user-gender": "unknown", "data-timestamp": "1606188335"}}, {"type": "span", "start": 36226, "end": 36267, "id": 1304, "features": {}}, {"type": "span", "start": 36268, "end": 36268, "id": 1305, "features": {"class": "mw-ui-icon mw-ui-icon-small mw-ui-icon-mf-expand-gray mf-mw-ui-icon-rotate-anti-clockwise indicator"}}, {"type": "div", "start": 36268, "end": 36792, "id": 1306, "features": {"class": "post-content footer-content"}}, {"type": "div", "start": 36268, "end": 36268, "id": 1307, "features": {"id": "mw-data-after-content"}}, {"type": "div", "start": 36268, "end": 36268, "id": 1308, "features": {"class": "read-more-container"}}, {"type": "h2", "start": 36268, "end": 36268, "id": 1309, "features": {}}, {"type": "img", "start": 36268, "end": 36268, "id": 1310, "features": {"src": "/static/images/mobile/copyright/wikipedia-wordmark-en.svg", "width": "119", "height": "18"}}, {"type": "div", "start": 36268, "end": 36332, "id": 1311, "features": {"class": "license"}}, {"type": "a", "start": 36295, "end": 36307, "id": 1312, "features": {"class": "external", "rel": "nofollow", "href": "https://creativecommons.org/licenses/by-sa/3.0/"}}, {"type": "ul", "start": 36332, "end": 36671, "id": 1313, "features": {"id": "footer-info", "class": "footer-info hlist hlist-separated"}}, {"type": "li", "start": 36332, "end": 36396, "id": 1314, "features": {"id": "footer-info-lastmod"}}, {"type": "span", "start": 36388, "end": 36394, "id": 1315, "features": {"class": "anonymous-show"}}, {"type": "li", "start": 36396, "end": 36671, "id": 1316, "features": {"id": "footer-info-copyright"}}, {"type": "a", "start": 36424, "end": 36471, "id": 1317, "features": {"rel": "license", "href": "//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License"}}, {"type": "a", "start": 36471, "end": 36471, "id": 1318, "features": {"rel": "license", "href": "//creativecommons.org/licenses/by-sa/3.0/", "style": "display:none;"}}, {"type": "a", "start": 36539, "end": 36551, "id": 1319, "features": {"href": "//foundation.wikimedia.org/wiki/Terms_of_Use"}}, {"type": "a", "start": 36556, "end": 36570, "id": 1320, "features": {"href": "//foundation.wikimedia.org/wiki/Privacy_policy"}}, {"type": "a", "start": 36616, "end": 36642, "id": 1321, "features": {"href": "//www.wikimediafoundation.org/"}}, {"type": "ul", "start": 36671, "end": 36792, "id": 1322, "features": {"id": "footer-places", "class": "footer-places hlist hlist-separated"}}, {"type": "li", "start": 36671, "end": 36686, "id": 1323, "features": {"id": "footer-places-privacy"}}, {"type": "a", "start": 36671, "end": 36685, "id": 1324, "features": {"href": "https://foundation.wikimedia.org/wiki/Privacy_policy", "class": "extiw", "title": "wmf:Privacy policy"}}, {"type": "li", "start": 36686, "end": 36702, "id": 1325, "features": {"id": "footer-places-about"}}, {"type": "a", "start": 36686, "end": 36701, "id": 1326, "features": {"href": "/wiki/Wikipedia:About", "title": "Wikipedia:About"}}, {"type": "li", "start": 36702, "end": 36714, "id": 1327, "features": {"id": "footer-places-disclaimer"}}, {"type": "a", "start": 36702, "end": 36713, "id": 1328, "features": {"href": "/wiki/Wikipedia:General_disclaimer", "title": "Wikipedia:General disclaimer"}}, {"type": "li", "start": 36714, "end": 36732, "id": 1329, "features": {"id": "footer-places-contact"}}, {"type": "a", "start": 36714, "end": 36731, "id": 1330, "features": {"href": "//en.wikipedia.org/wiki/Wikipedia:Contact_us"}}, {"type": "li", "start": 36732, "end": 36745, "id": 1331, "features": {"id": "footer-places-terms-use"}}, {"type": "a", "start": 36732, "end": 36744, "id": 1332, "features": {"href": "//m.wikimediafoundation.org/wiki/Terms_of_Use"}}, {"type": "li", "start": 36745, "end": 36753, "id": 1333, "features": {"id": "footer-places-desktop-toggle"}}, {"type": "a", "start": 36745, "end": 36752, "id": 1334, "features": {"id": "mw-mf-display-toggle", "href": "//en.wikipedia.org/w/index.php?title=Natural_language_processing&mobileaction=toggle_view_desktop"}}, {"type": "li", "start": 36753, "end": 36764, "id": 1335, "features": {"id": "footer-places-developers"}}, {"type": "a", "start": 36753, "end": 36763, "id": 1336, "features": {"href": "https://www.mediawiki.org/wiki/Special:MyLanguage/How_to_contribute"}}, {"type": "li", "start": 36764, "end": 36775, "id": 1337, "features": {"id": "footer-places-statslink"}}, {"type": "a", "start": 36764, "end": 36774, "id": 1338, "features": {"href": "https://stats.wikimedia.org/#/en.wikipedia.org"}}, {"type": "li", "start": 36775, "end": 36792, "id": 1339, "features": {"id": "footer-places-cookiestatement"}}, {"type": "a", "start": 36775, "end": 36791, "id": 1340, "features": {"href": "https://foundation.wikimedia.org/wiki/Cookie_statement"}}, {"type": "div", "start": 36792, "end": 36792, "id": 1341, "features": {"class": "mw-notification-area", "data-mw": "interface"}}], "next_annid": 1342}}, "text": "\nNatural language processing - Wikipedia\nOpen main menu\nHome\nRandom\nNearby\nLog in\nSettings\nDonate\nAbout Wikipedia\nDisclaimers\nSearch\nNatural language processing\nLanguage\nWatch\nEdit\nNatural language processing (NLP) is a subfield of linguistics, computer science, and artificial intelligence concerned with the interactions between computers and human language, in particular how to program computers to process and analyze large amounts of natural language data.\n \nAn automated online assistant providing customer service on a web page, an example of an application where natural language processing is a major component.[1]\nChallenges in natural language processing frequently involve speech recognition, natural language understanding, and natural-language generation.\nContents\n1 History\n1.1 Symbolic NLP (1950s - early 1990s)\n1.2 Statistical NLP (1990s - 2010s)\n1.3 Neural NLP (present)\n2 Methods: Rules, statistics, neural networks\n2.1 Statistical methods\n2.2 Neural networks\n3 Common NLP Tasks\n3.1 Text and speech processing\n3.2 Morphological analysis\n3.3 Syntactic analysis\n3.4 Lexical semantics (of individual words in context)\n3.5 Relational semantics (semantics of individual sentences)\n3.6 Discourse (semantics beyond individual sentences)\n3.7 Higher-level NLP applications\n4 Cognition and NLP\n5 See also\n6 References\n7 Further reading\nHistoryEdit\nFurther information: History of natural language processing\nNatural language processing has its roots in the 1950s. Already in 1950, Alan Turing published an article titled \"Computing Machinery and Intelligence\" which proposed what is now called the Turing test as a criterion of intelligence, a task that involves the automated interpretation and generation of natural language, but at the time not articulated as a problem separate from artificial intelligence.\nSymbolic NLP (1950s - early 1990s)Edit\nThe premise of symbolic NLP is well-summarized by John Searle's Chinese room experiment: Given a collection of rules (e.g., a Chinese phrasebook, with questions and matching answers), the computer emulates natural language understanding (or other NLP tasks) by applying those rules to the data it is confronted with.\n1950s: The Georgetown experiment in 1954 involved fully automatic translation of more than sixty Russian sentences into English. The authors claimed that within three or five years, machine translation would be a solved problem.[2]  However, real progress was much slower, and after the ALPAC report in 1966, which found that ten-year-long research had failed to fulfill the expectations, funding for machine translation was dramatically reduced.  Little further research in machine translation was conducted until the late 1980s when the first statistical machine translation systems were developed.\n1960s: Some notably successful natural language processing systems developed in the 1960s were SHRDLU, a natural language system working in restricted \"blocks worlds\" with restricted vocabularies, and ELIZA, a simulation of a Rogerian psychotherapist, written by Joseph Weizenbaum between 1964 and 1966.  Using almost no information about human thought or emotion, ELIZA sometimes provided a startlingly human-like interaction. When the \"patient\" exceeded the very small knowledge base, ELIZA might provide a generic response, for example, responding to \"My head hurts\" with \"Why do you say your head hurts?\".\n1970s: During the 1970s, many programmers began to write \"conceptual ontologies\", which structured real-world information into computer-understandable data.  Examples are MARGIE (Schank, 1975), SAM (Cullingford, 1978), PAM (Wilensky, 1978), TaleSpin (Meehan, 1976), QUALM (Lehnert, 1977), Politics (Carbonell, 1979), and Plot Units (Lehnert 1981).  During this time, the first many chatterbots were written (e.g., PARRY).\n1980s: The 1980s and early 1990s mark the hey-day of symbolic methods in NLP. Focus areas of the time included research on rule-based parsing (e.g., the development of HPSG as a computational operationalization of generative grammar), morphology (e.g., two-level morphology[3]), semantics (e.g., Lesk algorithm), reference (e.g., within Centering Theory[4]) and other areas of natural language understanding (e.g., in the Rhetorical Structure Theory). Other lines of research were continued, e.g., the development of chatterbots with Racter and Jabberwacky. An important development (that eventually led to the statistical turn in the 1990s) was the rising importance of quantitative evaluation in this period.[5]\nStatistical NLP (1990s - 2010s)Edit\nUp to the 1980s, most natural language processing systems were based on complex sets of hand-written rules.  Starting in the late 1980s, however, there was a revolution in natural language processing with the introduction of machine learning algorithms for language processing.  This was due to both the steady increase in computational power (see Moore's law) and the gradual lessening of the dominance of Chomskyan theories of linguistics (e.g. transformational grammar), whose theoretical underpinnings discouraged the sort of corpus linguistics that underlies the machine-learning approach to language processing.[6]\n1990s: Many of the notable early successes on statistical methods in NLP occurred in the field of machine translation, due especially to work at IBM Research.  These systems were able to take advantage of existing multilingual textual corpora that had been produced by the Parliament of Canada and the European Union as a result of laws calling for the translation of all governmental proceedings into all official languages of the corresponding systems of government.  However, most other systems depended on corpora specifically developed for the tasks implemented by these systems, which was (and often continues to be) a major limitation in the success of these systems. As a result, a great deal of research has gone into methods of more effectively learning from limited amounts of data.\n2000s: With the growth of the web, increasing amounts of raw (unannotated) language data has become available since the mid-1990s. Research has thus increasingly focused on unsupervised and semi-supervised learning algorithms.  Such algorithms can learn from data that has not been hand-annotated with the desired answers or using a combination of annotated and non-annotated data.  Generally, this task is much more difficult than supervised learning, and typically produces less accurate results for a given amount of input data.  However, there is an enormous amount of non-annotated data available (including, among other things, the entire content of the World Wide Web), which can often make up for the inferior results if the algorithm used has a low enough time complexity to be practical.\nNeural NLP (present)Edit\nIn the 2010s, representation learning and deep neural network-style machine learning methods became widespread in natural language processing, due in part to a flurry of results showing that such techniques[7][8] can achieve state-of-the-art results in many natural language tasks, for example in language modeling,[9] parsing,[10][11] and many others.\nMethods: Rules, statistics, neural networksEdit\nIn the early days, many language-processing systems were designed by symbolic methods, i.e., the hand-coding of a set of rules, coupled with a dictionary lookup:[12][13] such as by writing grammars or devising heuristic rules for stemming.\nMore recent systems based on machine-learning algorithms have many advantages over hand-produced rules: \nThe learning procedures used during machine learning automatically focus on the most common cases, whereas when writing rules by hand it is often not at all obvious where the effort should be directed.\nAutomatic learning procedures can make use of statistical inference algorithms to produce models that are robust to unfamiliar input (e.g. containing words or structures that have not been seen before) and to erroneous input (e.g. with misspelled words or words accidentally omitted). Generally, handling such input gracefully with handwritten rules, or, more generally, creating systems of handwritten rules that make soft decisions, is extremely difficult, error-prone and time-consuming.\nSystems based on automatically learning the rules can be made more accurate simply by supplying more input data. However, systems based on handwritten rules can only be made more accurate by increasing the complexity of the rules, which is a much more difficult task. In particular, there is a limit to the complexity of systems based on handwritten rules, beyond which the systems become more and more unmanageable. However, creating more data to input to machine-learning systems simply requires a corresponding increase in the number of man-hours worked, generally without significant increases in the complexity of the annotation process.\nDespite the popularity of machine learning in NLP research, symbolic methods are still (2020) commonly used\nwhen the amount of training data is insufficient to successfully apply machine learning methods, e.g., for the machine translation of low-resource languages such as provided by the Apertium system,\nfor preprocessing in NLP pipelines, e.g., tokenization, or\nfor postprocessing and transforming the output of NLP pipelines, e.g., for knowledge extraction from syntactic parses.\nStatistical methodsEdit\nSince the so-called \"statistical revolution\"[14][15] in the late 1980s and mid-1990s, much natural language processing research has relied heavily on machine learning. The machine-learning paradigm calls instead for using statistical inference to automatically learn such rules through the analysis of large corpora (the plural form of corpus, is a set of documents, possibly with human or computer annotations) of typical real-world examples.\nMany different classes of machine-learning algorithms have been applied to natural-language-processing tasks. These algorithms take as input a large set of \"features\" that are generated from the input data. Increasingly, however, research has focused on statistical models, which make soft, probabilistic decisions based on attaching real-valued weights to each input feature. Such models have the advantage that they can express the relative certainty of many different possible answers rather than only one, producing more reliable results when such a model is included as a component of a larger system.\nSome of the earliest-used machine learning algorithms, such as decision trees, produced systems of hard if-then rules similar to existing hand-written rules.  However, part-of-speech tagging introduced the use of hidden Markov models to natural language processing, and increasingly, research has focused on statistical models, which make soft, probabilistic decisions based on attaching real-valued weights to the features making up the input data. The cache language models upon which many speech recognition systems now rely are examples of such statistical models.  Such models are generally more robust when given unfamiliar input, especially input that contains errors (as is very common for real-world data), and produce more reliable results when integrated into a larger system comprising multiple subtasks.\nSince the neural turn, statistical methods in NLP research have been largely replaced by neural networks. However, they continue to be relevant for contexts in which statistical interpretability and transparency is required.\nNeural networksEdit\nFurther information: Artificial neural network\nA major drawback of statistical methods is that they require elaborate feature engineering. Since the early 2010s,[16] the field has thus largely abandoned statistical methods and shifted to neural networks for machine learning. Popular techniques include the use of word embeddings to capture semantic properties of words, and an increase in end-to-end learning of a higher-level task (e.g., question answering) instead of relying on a pipeline of separate intermediate tasks (e.g., part-of-speech tagging and dependency parsing). In some areas, this shift has entailed substantial changes in how NLP systems are designed, such that deep neural network-based approaches may be viewed as a new paradigm distinct from statistical natural language processing. For instance, the term neural machine translation (NMT) emphasizes the fact that deep learning-based approaches to machine translation directly learn sequence-to-sequence transformations, obviating the need for intermediate steps such as word alignment and language modeling that was used in statistical machine translation (SMT).\nCommon NLP TasksEdit\nThe following is a list of some of the most commonly researched tasks in natural language processing. Some of these tasks have direct real-world applications, while others more commonly serve as subtasks that are used to aid in solving larger tasks.\nThough natural language processing tasks are closely intertwined, they can be subdivided into categories for convenience. A coarse division is given below.\nText and speech processingEdit\nOptical character recognition (OCR)\nGiven an image representing printed text, determine the corresponding text.Speech recognition\nGiven a sound clip of a person or people speaking, determine the textual representation of the speech.  This is the opposite of text to speech and is one of the extremely difficult problems colloquially termed \"AI-complete\" (see above).  In natural speech there are hardly any pauses between successive words, and thus speech segmentation is a necessary subtask of speech recognition (see below). In most spoken languages, the sounds representing successive letters blend into each other in a process termed coarticulation, so the conversion of the analog signal to discrete characters can be a very difficult process. Also, given that words in the same language are spoken by people with different accents, the speech recognition software must be able to recognize the wide variety of input as being identical to each other in terms of its textual equivalent.\nSpeech segmentation\nGiven a sound clip of a person or people speaking, separate it into words.  A subtask of speech recognition and typically grouped with it.Text-to-speech\nGiven a text, transform those units and produce a spoken representation. Text-to-speech can be used to aid the visually impaired.[17]Word segmentation (Tokenization)\nSeparate a chunk of continuous text into separate words. For a language like English, this is fairly trivial, since words are usually separated by spaces. However, some written languages like Chinese, Japanese and Thai do not mark word boundaries in such a fashion, and in those languages text segmentation is a significant task requiring knowledge of the vocabulary and morphology of words in the language. Sometimes this process is also used in cases like bag of words (BOW) creation in data mining.\nMorphological analysisEdit\nLemmatization\nThe task of removing inflectional endings only and to return the base dictionary form of a word which is also known as a lemma.\nMorphological segmentation\nSeparate words into individual morphemes and identify the class of the morphemes. The difficulty of this task depends greatly on the complexity of the morphology (i.e., the structure of words) of the language being considered. English has fairly simple morphology, especially inflectional morphology, and thus it is often possible to ignore this task entirely and simply model all possible forms of a word (e.g., \"open, opens, opened, opening\") as separate words. In languages such as Turkish or Meitei,[18] a highly agglutinated Indian language, however, such an approach is not possible, as each dictionary entry has thousands of possible word forms.\nPart-of-speech tagging\nGiven a sentence, determine the part of speech (POS) for each word. Many words, especially common ones, can serve as multiple parts of speech. For example, \"book\" can be a noun (\"the book on the table\") or verb (\"to book a flight\"); \"set\" can be a noun, verb or adjective; and \"out\" can be any of at least five different parts of speech. Some languages have more such ambiguity than others.[dubious  \u2013 discuss] Languages with little inflectional morphology, such as English, are particularly prone to such ambiguity. Chinese is prone to such ambiguity because it is a tonal language during verbalization. Such inflection is not readily conveyed via the entities employed within the orthography to convey the intended meaning.Stemming\nThe process of reducing inflected (or sometimes derived) words to their root form. (e.g., \"close\" will be the root for \"closed\", \"closing\", \"close\", \"closer\" etc.).\nSyntactic analysisEdit\nGrammar induction[19]\nGenerate a formal grammar that describes a language's syntax.\nSentence breaking (also known as \"sentence boundary disambiguation\")\nGiven a chunk of text, find the sentence boundaries. Sentence boundaries are often marked by periods or other punctuation marks, but these same characters can serve other purposes (e.g., marking abbreviations).\nParsing\nDetermine the parse tree (grammatical analysis) of a given sentence. The grammar for natural languages is ambiguous and typical sentences have multiple possible analyses: perhaps surprisingly, for a typical sentence there may be thousands of potential parses (most of which will seem completely nonsensical to a human). There are two primary types of parsing: dependency parsing and constituency parsing. Dependency parsing focuses on the relationships between words in a sentence (marking things like primary objects and predicates), whereas constituency parsing focuses on building out the parse tree using a probabilistic context-free grammar (PCFG) (see also stochastic grammar).\nLexical semantics (of individual words in context)Edit\nLexical semantics\nWhat is the computational meaning of individual words in context?\nDistributional semantics\nHow can we learn semantic representations from data?\nNamed entity recognition (NER)\nGiven a stream of text, determine which items in the text map to proper names, such as people or places, and what the type of each such name is (e.g. person, location, organization). Although capitalization can aid in recognizing named entities in languages such as English, this information cannot aid in determining the type of named entity, and in any case, is often inaccurate or insufficient.  For example, the first letter of a sentence is also capitalized, and named entities often span several words, only some of which are capitalized.  Furthermore, many other languages in non-Western scripts (e.g. Chinese or Arabic) do not have any capitalization at all, and even languages with capitalization may not consistently use it to distinguish names. For example, German capitalizes all nouns, regardless of whether they are names, and French and Spanish do not capitalize names that serve as adjectives.Sentiment analysis (see also multimodal sentiment analysis)\nExtract subjective information usually from a set of documents, often using online reviews to determine \"polarity\" about specific objects. It is especially useful for identifying trends of public opinion in social media, for marketing.Terminology extractionThe goal of terminology extraction is to automatically extract relevant terms from a given corpus.\nWord sense disambiguation\nMany words have more than one meaning; we have to select the meaning which makes the most sense in context.  For this problem, we are typically given a list of words and associated word senses, e.g. from a dictionary or an online resource such as WordNet.\nRelational semantics (semantics of individual sentences)Edit\nRelationship extraction\nGiven a chunk of text, identify the relationships among named entities (e.g. who is married to whom).\nSemantic Parsing\nGiven a piece of text (typically a sentence), produce a formal representation of its semantics, either as a graph (e.g., in AMR parsing) or in accordance with a logical formalism (e.g., in DRT parsing). This challenge typically includes aspects of several more elementary NLP tasks from semantics (e.g., semantic role labelling, word sense disambiguation) and can be extended to include full-fledged discourse analysis (e.g., discourse analysis, coreference; see Natural Language Understanding below).\nSemantic Role Labelling (see also implicit semantic role labelling below)\nGiven a single sentence, identify and disambiguate semantic predicates (e.g., verbal frames), then identify and classify the frame elements (semantic roles).\nDiscourse (semantics beyond individual sentences)Edit\nCoreference resolution\nGiven a sentence or larger chunk of text, determine which words (\"mentions\") refer to the same objects (\"entities\"). Anaphora resolution is a specific example of this task, and is specifically concerned with matching up pronouns with the nouns or names to which they refer. The more general task of coreference resolution also includes identifying so-called \"bridging relationships\" involving referring expressions. For example, in a sentence such as \"He entered John's house through the front door\", \"the front door\" is a referring expression and the bridging relationship to be identified is the fact that the door being referred to is the front door of John's house (rather than of some other structure that might also be referred to).\nDiscourse analysis\nThis rubric includes several related tasks.  One task is discourse parsing, i.e., identifying the discourse structure of a connected text, i.e. the nature of the discourse relationships between sentences (e.g. elaboration, explanation, contrast).  Another possible task is recognizing and classifying the speech acts in a chunk of text (e.g. yes-no question, content question, statement, assertion, etc.).Implicit Semantic Role Labelling\nGiven a single sentence, identify and disambiguate semantic predicates (e.g., verbal frames) and their explicit semantic roles in the current sentence (see Semantic Role Labelling above). Then, identify semantic roles that are not explicitly realized in the current sentence, classify them into arguments that are explicitly realized elsewhere in the text and those that are not specified, and resolve the former against the local text. A closely related task is zero anaphora resolution, i.e., the extension of coreference resolution to pro-drop languages.Recognizing Textual entailment\nGiven two text fragments, determine if one being true entails the other, entails the other's negation, or allows the other to be either true or false.[20]Topic segmentation and recognition\nGiven a chunk of text, separate it into segments each of which is devoted to a topic, and identify the topic of the segment.\nHigher-level NLP applicationsEdit\nAutomatic summarization (text summarization)\nProduce a readable summary of a chunk of text.  Often used to provide summaries of the text of a known type, such as research papers, articles in the financial section of a newspaper.\nBook generation\nNot an NLP task proper but an extension of Natural Language Generation and other NLP tasks is the creation of full-fledged books. The first machine-generated book was created by a rule-based system in 1984 (Racter, The policeman's beard is half-constructed).[21] The first published work by a neural network was published in 2018, 1 the Road, marketed as a novel, contains sixty million words. Both these systems are basically elaborate but non-sensical (semantics-free) language models. The first machine-generated science book was published in 2019 (Beta Writer, Lithium-Ion Batteries, Springer, Cham).[22] Unlike Racter and 1 the Road, this is grounded on factual knowledge and based on text summarization.\nDialogue management\nComputer systems intended to converse with a human.\nMachine translation\nAutomatically translate text from one human language to another.  This is one of the most difficult problems, and is a member of a class of problems colloquially termed \"AI-complete\", i.e. requiring all of the different types of knowledge that humans possess (grammar, semantics, facts about the real world, etc.) to solve properly.\nNatural language generation (NLG):\nConvert information from computer databases or semantic intents into readable human language.\nNatural language understanding (NLU)\nConvert chunks of text into more formal representations such as first-order logic structures that are easier for computer programs to manipulate. Natural language understanding involves the identification of the intended semantic from the multiple possible semantics which can be derived from a natural language expression which usually takes the form of organized notations of natural language concepts. Introduction and creation of language metamodel and ontology are efficient however empirical solutions. An explicit formalization of natural language semantics without confusions with implicit assumptions such as closed-world assumption (CWA) vs. open-world assumption, or subjective Yes/No vs. objective True/False is expected for the construction of a basis of semantics formalization.[23]\nQuestion answering\nGiven a human-language question, determine its answer.  Typical questions have a specific right answer (such as \"What is the capital of Canada?\"), but sometimes open-ended questions are also considered (such as \"What is the meaning of life?\"). Recent works have looked at even more complex questions.[24]\nCognition and NLPEdit\nCognition refers to \"the mental action or process of acquiring knowledge and understanding through thought, experience, and the senses.\"[25] Cognitive science is the interdisciplinary, scientific study of the mind and its processes.[26] Cognitive linguistics is an interdisciplinary branch of linguistics, combining knowledge and research from both psychology and linguistics.[27] George Lakoff offers a methodology to build Natural language processing (NLP) algorithms through the perspective of Cognitive science, along with the findings of Cognitive linguistics:[28]\nThe first defining aspect of this cognitive task of NLP is the application of the theory of Conceptual metaphor, explained by Lakoff as \u201cthe understanding of one idea, in terms of another\u201d which provides an idea of the intent of the author.[29]\nFor example, consider some of the meanings, in English, of the word \u201cbig\u201d. When used as a Comparative, as in \u201cThat is a big tree,\u201d a likely inference of the intent of the author is that the author is using the word \u201cbig\u201d to imply a statement about the tree being \u201dphysically large\u201d in comparison to other trees or the authors experience.  When used as a Stative verb, as in \u201dTomorrow is a big day\u201d, a likely inference of the author\u2019s intent it that \u201dbig\u201d is being used to imply \u201dimportance\u201d.  These examples are not presented to be complete, but merely as indicators of the implication of the idea of Conceptual metaphor.  The intent behind other usages, like in \u201dShe is a big person\u201d will remain somewhat ambiguous to a person and a cognitive NLP algorithm alike without additional information.\nThis leads to the second defining aspect of this cognitive task of NLP, namely Probabilistic context-free grammar (PCFG) which enables cognitive NLP algorithms to assign relative measures of meaning  to a word, phrase, sentence or piece of text based on the information presented before and after the piece of text being analyzed. The mathematical equation for such algorithms is presented in US patent 9269353\u00a0:\nR\nM\nM\n(\nt\no\nk\ne\nn\nN\n)\n=\nP\nM\nM\n(\nt\no\nk\ne\nn\nN\n)\n\u00d7\n1\n2\nd\n(\n\u2211\ni\n=\n\u2212\nd\nd\n(\n(\nP\nM\nM\n(\nt\no\nk\ne\nn\nN\n\u2212\n1\n)\n\u00d7\nP\nF\n(\nt\no\nk\ne\nn\nN\n,\nt\no\nk\ne\nn\nN\n\u2212\n1\n)\n)\ni\n)\n{\\displaystyle {RMM(token_{N})}={PMM(token_{N})}\\times {\\frac {1}{2d}}\\left(\\sum _{i=-d}^{d}{((PMM(token_{N-1})}\\times {PF(token_{N},token_{N-1}))_{i}}\\right)}\n\u00a0\nWhere,\n\u00a0 \u2003 \u00a0RMM, is the Relative Measure of Meaning\n\u00a0 \u2003 \u00a0token, is any block of text, sentence, phrase or word\n\u00a0 \u2003 \u00a0N, is the number of tokens being analyzed\n\u00a0 \u2003 \u00a0PMM, is the Probable Measure of Meaning based on a corpora\n\u00a0 \u2003 \u00a0d, is the location of the token along the sequence of N-1 tokens\n\u00a0 \u2003 \u00a0PF, is the Probability Function specific to a language\nSee alsoEdit\n1 the Road\nAutomated essay scoring\nBiomedical text mining\nCompound term processing\nComputational linguistics\nComputer-assisted reviewing\nControlled natural language\nDeep learning\nDeep linguistic processing\nDistributional semantics\nForeign language reading aid\nForeign language writing aid\nInformation extraction\nInformation retrieval\nLanguage and Communication Technologies\nLanguage technology\nLatent semantic indexing\nNative-language identification\nNatural language programming\nNatural language search\nOutline of natural language processing\nQuery expansion\nQuery understanding\nReification (linguistics)\nSpeech processing\nSpoken dialogue system\nText-proofing\nText simplification\nTransformer (machine learning model)\nTruecasing\nQuestion answering\nWord2vec\nReferencesEdit\n^ Kongthon, Alisa; Sangkeettrakarn, Chatchawal; Kongyoung, Sarawoot; Haruechaiyasak, Choochart (October 27\u201330, 2009). Implementing an online help desk system based on conversational agent. MEDES '09: The International Conference on Management of Emergent Digital EcoSystems. France: ACM. doi:10.1145/1643823.1643908.\n^ Hutchins, J. (2005). \"The history of machine translation in a nutshell\" (PDF).[self-published source]\n^ Koskenniemi, Kimmo (1983), Two-level morphology: A general computational model of word-form recognition and production (PDF), Department of General Linguistics, University of Helsinki\n^ Joshi, A. K., & Weinstein, S. (1981, August). Control of Inference: Role of Some Aspects of Discourse Structure-Centering. In IJCAI (pp. 385-387).\n^ Guida, G.; Mauri, G. (July 1986). \"Evaluation of natural language processing systems: Issues and approaches\". Proceedings of the IEEE. 74 (7): 1026\u20131035. doi:10.1109/PROC.1986.13580. ISSN\u00a01558-2256. S2CID\u00a030688575.\n^ Chomskyan linguistics encourages the investigation of \"corner cases\" that stress the limits of its theoretical models (comparable to pathological phenomena in mathematics), typically created using thought experiments, rather than the systematic investigation of typical phenomena that occur in real-world data, as is the case in corpus linguistics.  The creation and use of such corpora of real-world data is a fundamental part of machine-learning algorithms for natural language processing.  In addition, theoretical underpinnings of Chomskyan linguistics such as the so-called \"poverty of the stimulus\" argument entail that general learning algorithms, as are typically used in machine learning, cannot be successful in language processing.  As a result, the Chomskyan paradigm discouraged the application of such models to language processing.\n^ Goldberg, Yoav (2016). \"A Primer on Neural Network Models for Natural Language Processing\". Journal of Artificial Intelligence Research. 57: 345\u2013420. arXiv:1807.10854. doi:10.1613/jair.4992. S2CID\u00a08273530.\n^ Goodfellow, Ian; Bengio, Yoshua; Courville, Aaron (2016). Deep Learning. MIT Press.\n^ Jozefowicz, Rafal; Vinyals, Oriol; Schuster, Mike; Shazeer, Noam; Wu, Yonghui (2016). Exploring the Limits of Language Modeling. arXiv:1602.02410. Bibcode:2016arXiv160202410J.\n^ Choe, Do Kook; Charniak, Eugene. \"Parsing as Language Modeling\". Emnlp 2016.\n^ Vinyals, Oriol;  et al. (2014). \"Grammar as a Foreign Language\" (PDF). Nips2015. arXiv:1412.7449. Bibcode:2014arXiv1412.7449V.\n^ Winograd, Terry (1971). Procedures as a Representation for Data in a Computer Program for Understanding Natural Language (Thesis).\n^ Schank, Roger C.; Abelson, Robert P. (1977). Scripts, Plans, Goals, and Understanding: An Inquiry Into Human Knowledge Structures. Hillsdale: Erlbaum. ISBN\u00a0\n0-470-99033-3\n.\n^ Mark Johnson. How the statistical revolution changes (computational) linguistics. Proceedings of the EACL 2009 Workshop on the Interaction between Linguistics and Computational Linguistics.\n^ Philip Resnik. Four revolutions. Language Log, February 5, 2011.\n^ Socher, Richard. \"Deep Learning For NLP-ACL 2012 Tutorial\". www.socher.org. Retrieved 2020-08-17. This was an early Deep Learning tutorial at the ACL 2012 and met with both interest and (at the time) skepticism by most participants. Until then, neural learning was basically rejected because of its lack of statistical interpretability. Until 2015, deep learning had evolved into the major framework of NLP.\n^ Yi, Chucai; Tian, Yingli (2012), \"Assistive Text Reading from Complex Background for Blind Persons\", Camera-Based Document Analysis and Recognition, Springer Berlin Heidelberg, pp.\u00a015\u201328, CiteSeerX\u00a010.1.1.668.869, doi:10.1007/978-3-642-29364-1_2, ISBN\u00a0\n9783642293634\n^ Kishorjit, N.; Vidya, Raj RK.; Nirmal, Y.; Sivaji, B. (2012). \"Manipuri Morpheme Identification\" (PDF). Proceedings of the 3rd Workshop on South and Southeast Asian Natural Language Processing (SANLP). COLING 2012, Mumbai, December 2012: 95\u2013108.CS1 maint: location (link)\n^ Klein, Dan; Manning, Christopher D. (2002). \"Natural language grammar induction using a constituent-context model\" (PDF). Advances in Neural Information Processing Systems.\n^ PASCAL Recognizing Textual Entailment Challenge (RTE-7) https://tac.nist.gov//2011/RTE/\n^ \"U B U W E B\u00a0:: Racter\". www.ubu.com. Retrieved 2020-08-17.\n^ Writer, Beta (2019). Lithium-Ion Batteries. doi:10.1007/978-3-030-16800-1. ISBN\u00a0\n978-3-030-16799-8\n.\n^ Duan, Yucong; Cruz, Christophe (2011). \"Formalizing Semantic of Natural Language through Conceptualization from Existence\". International Journal of Innovation, Management and Technology. 2 (1): 37\u201342. Archived from the original on 2011-10-09.\n^ Mittal (2011). \"Versatile question answering systems: seeing in synthesis\" (PDF). International Journal of Intelligent Information and Database Systems. 5 (2): 119\u2013142. doi:10.1504/IJIIDS.2011.038968.\n^ \"Cognition\". Lexico. Oxford University Press and Dictionary.com. Retrieved 6 May 2020.\n^ \"Ask the Cognitive Scientist\". American Federation of Teachers. 8 August 2014. Cognitive science is an interdisciplinary field of researchers from Linguistics, psychology, neuroscience, philosophy, computer science, and anthropology that seek to understand the mind.\n^ Robinson, Peter (2008). Handbook of Cognitive Linguistics and Second Language Acquisition. Routledge. pp.\u00a03\u20138. ISBN\u00a0\n978-0-805-85352-0\n.\n^ Lakoff, George (1999). Philosophy in the Flesh: The Embodied Mind and Its Challenge to Western Philosophy; Appendix: The Neural Theory of Language Paradigm. New York Basic Books. pp.\u00a0569\u2013583. ISBN\u00a0\n978-0-465-05674-3\n.\n^ Strauss, Claudia (1999). A Cognitive Theory of Cultural Meaning. Cambridge University Press. pp.\u00a0156\u2013164. ISBN\u00a0\n978-0-521-59541-4\n.\nFurther readingEdit\nBates, M (1995). \"Models of natural language understanding\". Proceedings of the National Academy of Sciences of the United States of America. 92 (22): 9977\u20139982. Bibcode:1995PNAS...92.9977B. doi:10.1073/pnas.92.22.9977. PMC\u00a040721. PMID\u00a07479812.\nSteven Bird, Ewan Klein, and Edward Loper (2009). Natural Language Processing with Python. O'Reilly Media. ISBN\u00a0978-0-596-51649-9.\nDaniel Jurafsky and James H. Martin (2008). Speech and Language Processing, 2nd edition. Pearson Prentice Hall. ISBN\u00a0978-0-13-187321-6.\nMohamed Zakaria Kurdi (2016). Natural Language Processing and Computational Linguistics: speech, morphology, and syntax, Volume 1. ISTE-Wiley. ISBN\u00a0978-1848218482.\nMohamed Zakaria Kurdi (2017). Natural Language Processing and Computational Linguistics: semantics, discourse, and applications, Volume 2. ISTE-Wiley. ISBN\u00a0978-1848219212.\nChristopher D. Manning, Prabhakar Raghavan, and Hinrich Sch\u00fctze (2008). Introduction to Information Retrieval. Cambridge University Press. ISBN\u00a0978-0-521-86571-5. Official html and pdf versions available without charge.\nChristopher D. Manning and Hinrich Sch\u00fctze (1999). Foundations of Statistical Natural Language Processing. The MIT Press. ISBN\u00a0978-0-262-13360-9.\nDavid M. W. Powers and Christopher C. R. Turk (1989). Machine Learning of Natural Language. Springer-Verlag. ISBN\u00a0978-0-387-19557-5.\nWikimedia Commons has media related to Natural language processing.\n\nRetrieved from \"https://en.wikipedia.org/w/index.php?title=Natural_language_processing&oldid=990376335\"\nLast edited on 24 November 2020, at 03:25\nContent is available under CC BY-SA 3.0 unless otherwise noted.\n This page was last edited on 24 November 2020, at 03:25\u00a0(UTC).\nText is available under the Creative Commons Attribution-ShareAlike License;\nadditional terms may apply.  By using this site, you agree to the Terms of Use and Privacy Policy. Wikipedia\u00ae is a registered trademark of the Wikimedia Foundation, Inc., a non-profit organization.\nPrivacy policy\nAbout Wikipedia\nDisclaimers\nContact Wikipedia\nTerms of Use\nDesktop\nDevelopers\nStatistics\nCookie statement\n", "features": {}, "offset_type": "j", "name": ""}
    </script>
    <script type="text/javascript">
        gatenlp_run("WALXCKLHJN-");
    </script>
  </div>

</div></div>



The markup present in the original HTML file is converted into annotations in the annotation set with the name "Original markups". For example all the HTML links are present as annotations of type "a" (there are 449 of those), the level 3 headings are present as annotations of type "h3" and so on. 



## Loading and saving using various document formats

GateNlp documents can be loaded from a number of different text representations. When you run
`Document.load(filepath)`, gatenlp tries to automatically determine the format of the document from the file 
extensions, but if that fails, it is possible to explicitly specify the format using the `fmt=` keyword argument 
which can take a memnonic or a mime type specification for the format. 

The following formats are known, the list shows first the memnonic, if one exists, then the mime type, and then 
the description of the format. All the following formats can be loaded and saved:  

* `text`, `text/plain`:  Plain text, extension `.txt`, 
  by default this is expected to be encoded in "UTF-8" but a different encoding
  can be specified using the `encoding=` keyword argument. 
* `text/plain+gzip`: Gzip compressed plain text, same as `text` but gzip compressed.
* `bdocjs`, `json`, `text/bdocjs`: BDOC Json Format, extension `.bdocjs`,  which can be exchanged with Java GATE via the 
  format BDOC plugin (https://gatenlp.github.io/gateplugin-Format_Bdoc/)
* `bdocjsgz`, `jsongz`, `text/bdocjs+gzip`: BDOC Json Format, GZip compressed, extension `.bdocjs.gz`
* `yaml`, `text/bdocym`: BDOC Yaml Format, extension `.bdocym`,  which can be exchanged with Java GATE 
   via the format BDOC plugin. This format allows for serialization of shared nested arrays/maps and exchange
   of these between Java GATE and Python GateNLP. 
* `yamlgz`, `text/bdocym+gzip`: BDOC Yaml Format, GZip compressed, extesion, `.bdocym.gz`
* `msgpack`, `application/msgpack`: BDOC Message Pack format, extension `.bdocmp`. Can be exchanged with Java
   GATE via the format BDOC plugin
   
The following formats can only be loaded:

* `html`, `text/html`: HTML files can be loaded and will be parsed to obtain the text and to create annotations
   that correspond to the HTML markup (these annotations are in annotation set "Original markups"). Note that
   not all HTML can be parsed without problems and this will NOT load the *rendered* form of the HTML page, i.e.
   anything created or influenced by JavaScript code on the page is not loaded. 
* `gatexml`: Java GATE XML format, extension `.xml` can be loaded, but Java-specific data is not supported.
   If e.g. features have Java lists or arrays or similar as a value, the load will fail unless the keyword 
   argument `ignore_unknown_types=True` is specified. 

The following formats can only be  saved:
* `html-ann-viewer`: This creates a HTML file which can be used to visualize the document. The following 
  keyword arguments can be used: `notebook=True` to create a div instead of a complete html document, 
  `offline=True` to include all Javascript code necessary for visualization in the document instead of loading
  it from the internet, `htmlid="somename"` to make all HTML, CSS and Javascript definitions for the generated
  HTML code unique, so that several different pieces of HTML code can be embedded in the same page. 
  
Documents can also be saved and loaded using Python pickle.

Documents can also be convert to and from a Python-only representation using the methods `doc.to_dict()` and `Document.from_dict(thedict)` which can be used to serialize or transfer the document in many other formats. 


```python
# Convert the document to a dictionary representation:
as_dict = doc.to_dict()
as_dict
```




    {'annotation_sets': {'Set1': {'name': 'Set1',
       'annotations': [{'type': 'Word',
         'start': 0,
         'end': 4,
         'id': 0,
         'features': {'what': 'our first annotation'}},
        {'type': 'Word',
         'start': 5,
         'end': 7,
         'id': 1,
         'features': {'what': 'our second annotation'}},
        {'type': 'Sentence',
         'start': 0,
         'end': 24,
         'id': 2,
         'features': {'what': 'our first sentence annotation'}}],
       'next_annid': 3}},
     'text': 'This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like 😽 (a kissing cat),\n👩\u200d🏫 (a woman teacher), \U0001f9ec (DNA), \n\U0001f9d7 (a person climbing), \n💩 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul 한글 or \nsimplified Hanzi 汉字 or Farsi فارسی which goes from right to left. \n\n\n',
     'features': {'loaded-from': 'https://gatenlp.github.io/python-gatenlp/testdocument1.txt',
      'purpose': 'test document for gatenlp',
      'someotherfeature': 22,
      'andanother': {'what': 'a dict', 'alist': [1, 2, 3, 4, 5]}},
     'offset_type': 'p',
     'name': ''}




```python
# create a copy by creating a new Document from the dictionary representation
doc_copy = Document.from_dict(as_dict)
doc_copy
```




<div><style>#MMPMKEIMTD-wrapper { color: black !important; }</style>
<div id="MMPMKEIMTD-wrapper">

<div>
<style>
#MMPMKEIMTD-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.MMPMKEIMTD-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.MMPMKEIMTD-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.MMPMKEIMTD-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.MMPMKEIMTD-label {
    margin-bottom: -15px;
    display: block;
}

.MMPMKEIMTD-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#MMPMKEIMTD-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.MMPMKEIMTD-selection {
    margin-bottom: 5px;
}

.MMPMKEIMTD-featuretable {
    margin-top: 10px;
}

.MMPMKEIMTD-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.MMPMKEIMTD-fvalue {
    text-align: left !important;
}
</style>
  <div id="MMPMKEIMTD-content">
        <div id="MMPMKEIMTD-popup" style="display: none;">
        </div>
        <div class="MMPMKEIMTD-row" id="MMPMKEIMTD-row1" style="max-height: 20em; min-height:5em;">
            <div id="MMPMKEIMTD-text-wrapper" class="MMPMKEIMTD-col" style="width:70%;">
                <div class="MMPMKEIMTD-hdr" id="MMPMKEIMTD-dochdr"></div>
                <div id="MMPMKEIMTD-text">
                </div>
            </div>
            <div id="MMPMKEIMTD-chooser" class="MMPMKEIMTD-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="MMPMKEIMTD-row" id="MMPMKEIMTD-row2" style="max-height: 14em; min-height: 3em;">
            <div id="MMPMKEIMTD-details" class="MMPMKEIMTD-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>

    <script type="application/json" id="MMPMKEIMTD-data">
    {"annotation_sets": {"Set1": {"name": "detached-from:Set1", "annotations": [{"type": "Word", "start": 0, "end": 4, "id": 0, "features": {"what": "our first annotation"}}, {"type": "Word", "start": 5, "end": 7, "id": 1, "features": {"what": "our second annotation"}}, {"type": "Sentence", "start": 0, "end": 24, "id": 2, "features": {"what": "our first sentence annotation"}}], "next_annid": 3}}, "text": "This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like \ud83d\ude3d (a kissing cat),\n\ud83d\udc69\u200d\ud83c\udfeb (a woman teacher), \ud83e\uddec (DNA), \n\ud83e\uddd7 (a person climbing), \n\ud83d\udca9 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul \ud55c\uae00 or \nsimplified Hanzi \u6c49\u5b57 or Farsi \u0641\u0627\u0631\u0633\u06cc which goes from right to left. \n\n\n", "features": {"loaded-from": "https://gatenlp.github.io/python-gatenlp/testdocument1.txt", "purpose": "test document for gatenlp", "someotherfeature": 22, "andanother": {"what": "a dict", "alist": [1, 2, 3, 4, 5]}}, "offset_type": "j", "name": ""}
    </script>
    <script type="text/javascript">
        gatenlp_run("MMPMKEIMTD-");
    </script>
  </div>

</div></div>




```python
# Save the document in bdocjs format
doc.save("tmpdoc.bdocjs") 

# show what the document looks like 
with open("tmpdoc.bdocjs", "rt") as infp:
    print(infp.read())
```

    {"annotation_sets": {"Set1": {"name": "Set1", "annotations": [{"type": "Word", "start": 0, "end": 4, "id": 0, "features": {"what": "our first annotation"}}, {"type": "Word", "start": 5, "end": 7, "id": 1, "features": {"what": "our second annotation"}}, {"type": "Sentence", "start": 0, "end": 24, "id": 2, "features": {"what": "our first sentence annotation"}}], "next_annid": 3}}, "text": "This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like \ud83d\ude3d (a kissing cat),\n\ud83d\udc69\u200d\ud83c\udfeb (a woman teacher), \ud83e\uddec (DNA), \n\ud83e\uddd7 (a person climbing), \n\ud83d\udca9 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul \ud55c\uae00 or \nsimplified Hanzi \u6c49\u5b57 or Farsi \u0641\u0627\u0631\u0633\u06cc which goes from right to left. \n\n\n", "features": {"loaded-from": "https://gatenlp.github.io/python-gatenlp/testdocument1.txt", "purpose": "test document for gatenlp", "someotherfeature": 22, "andanother": {"what": "a dict", "alist": [1, 2, 3, 4, 5]}}, "offset_type": "p", "name": ""}



```python
# load the document from the saved bdocjs format file
Document.load("tmpdoc.bdocjs")
```




<div><style>#KXOXWCTUEM-wrapper { color: black !important; }</style>
<div id="KXOXWCTUEM-wrapper">

<div>
<style>
#KXOXWCTUEM-content {
    width: 100%;
    height: 100%;
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
}

.KXOXWCTUEM-row {
    width: 100%;
    display: flex;
    flex-direction: row;
    flex-wrap: nowrap;
}

.KXOXWCTUEM-col {
    border: 1px solid grey;
    display: inline-block;
    min-width: 200px;
    padding: 5px;
    /* white-space: normal; */
    /* white-space: pre-wrap; */
    overflow-y: auto;
}

.KXOXWCTUEM-hdr {
    font-size: 1.2rem;
    font-weight: bold;
}

.KXOXWCTUEM-label {
    margin-bottom: -15px;
    display: block;
}

.KXOXWCTUEM-input {
    vertical-align: middle;
    position: relative;
    *overflow: hidden;
}

#KXOXWCTUEM-popup {
    display: none;
    color: black;
    position: absolute;
    margin-top: 10%;
    margin-left: 10%;
    background: #aaaaaa;
    width: 60%;
    height: 60%;
    z-index: 50;
    padding: 25px 25px 25px;
    border: 1px solid black;
    overflow: auto;
}

.KXOXWCTUEM-selection {
    margin-bottom: 5px;
}

.KXOXWCTUEM-featuretable {
    margin-top: 10px;
}

.KXOXWCTUEM-fname {
    text-align: left !important;
    font-weight: bold;
    margin-right: 10px;
}
.KXOXWCTUEM-fvalue {
    text-align: left !important;
}
</style>
  <div id="KXOXWCTUEM-content">
        <div id="KXOXWCTUEM-popup" style="display: none;">
        </div>
        <div class="KXOXWCTUEM-row" id="KXOXWCTUEM-row1" style="max-height: 20em; min-height:5em;">
            <div id="KXOXWCTUEM-text-wrapper" class="KXOXWCTUEM-col" style="width:70%;">
                <div class="KXOXWCTUEM-hdr" id="KXOXWCTUEM-dochdr"></div>
                <div id="KXOXWCTUEM-text">
                </div>
            </div>
            <div id="KXOXWCTUEM-chooser" class="KXOXWCTUEM-col" style="width:30%; border-left-width: 0px;"></div>
        </div>
        <div class="KXOXWCTUEM-row" id="KXOXWCTUEM-row2" style="max-height: 14em; min-height: 3em;">
            <div id="KXOXWCTUEM-details" class="KXOXWCTUEM-col" style="width:100%; border-top-width: 0px;">
            </div>
        </div>
    </div>

    <script type="application/json" id="KXOXWCTUEM-data">
    {"annotation_sets": {"Set1": {"name": "detached-from:Set1", "annotations": [{"type": "Word", "start": 0, "end": 4, "id": 0, "features": {"what": "our first annotation"}}, {"type": "Word", "start": 5, "end": 7, "id": 1, "features": {"what": "our second annotation"}}, {"type": "Sentence", "start": 0, "end": 24, "id": 2, "features": {"what": "our first sentence annotation"}}], "next_annid": 3}}, "text": "This is a test document.\n\nIt contains just a few sentences. \nHere is a sentence that mentions a few named entities like \nthe persons Barack Obama or Ursula von der Leyen, locations\nlike New York City, Vienna or Beijing or companies like \nGoogle, UniCredit or Huawei. \n\nHere we include a URL https://gatenlp.github.io/python-gatenlp/ \nand a fake email address john.doe@hiscoolserver.com as well \nas #some #cool #hastags and a bunch of emojis like \ud83d\ude3d (a kissing cat),\n\ud83d\udc69\u200d\ud83c\udfeb (a woman teacher), \ud83e\uddec (DNA), \n\ud83e\uddd7 (a person climbing), \n\ud83d\udca9 (a pile of poo). \n\nHere we test a few different scripts, e.g. Hangul \ud55c\uae00 or \nsimplified Hanzi \u6c49\u5b57 or Farsi \u0641\u0627\u0631\u0633\u06cc which goes from right to left. \n\n\n", "features": {"loaded-from": "https://gatenlp.github.io/python-gatenlp/testdocument1.txt", "purpose": "test document for gatenlp", "someotherfeature": 22, "andanother": {"what": "a dict", "alist": [1, 2, 3, 4, 5]}}, "offset_type": "j", "name": ""}
    </script>
    <script type="text/javascript">
        gatenlp_run("KXOXWCTUEM-");
    </script>
  </div>

</div></div>




```python
# clean up the document
import os
os.remove("tmpdoc.bdocjs")
```
