# Generated by Django 3.1.1 on 2020-09-22 11:00

import datetime
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
from django.utils.timezone import utc
import model_utils.fields
import nobinobi_child.models
import phonenumber_field.modelfields
import uuid


class Migration(migrations.Migration):

    replaces = [('nobinobi_child', '0001_initial'), ('nobinobi_child', '0002_auto_20190429_1204'), ('nobinobi_child', '0003_auto_20190429_1430'), ('nobinobi_child', '0004_auto_20190531_1027'), ('nobinobi_child', '0005_auto_20190604_1406'), ('nobinobi_child', '0006_auto_20190604_1519'), ('nobinobi_child', '0007_auto_20190605_1146'), ('nobinobi_child', '0008_language_unique'), ('nobinobi_child', '0009_auto_20190711_1413'), ('nobinobi_child', '0010_auto_20191016_1523'), ('nobinobi_child', '0011_auto_20191120_1134'), ('nobinobi_child', '0012_auto_20191127_1157'), ('nobinobi_child', '0013_add_pediatrician'), ('nobinobi_child', '0014_add_sibling_info'), ('nobinobi_child', '0015_add_nationality_child'), ('nobinobi_child', '0016_add_information_contact_for_child'), ('nobinobi_child', '0017_add_usage_homeopathy')]

    dependencies = [
        ('nobinobi_staff', '0006_staff_working_base'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AbsenceGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
            ],
            options={
                'verbose_name': 'Groupe d’absences',
                'verbose_name_plural': 'Groupes d’absences',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Address',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('street', models.CharField(max_length=100, verbose_name='Rue')),
                ('zip', models.PositiveIntegerField(verbose_name='Nip')),
                ('city', models.CharField(max_length=50, verbose_name='Ville')),
                ('country', models.CharField(default='Suisse', max_length=50, verbose_name='Pays')),
            ],
            options={
                'verbose_name': 'Adresse',
                'verbose_name_plural': 'Adresses',
                'ordering': ('country', 'zip', 'city', 'street'),
            },
        ),
        migrations.CreateModel(
            name='AgeGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
                ('slug', models.SlugField(verbose_name='Slug')),
                ('order', models.PositiveIntegerField(unique=True, verbose_name='Ordre')),
                ('end_date', models.DateField(default=django.utils.timezone.now, verbose_name='Date de fin')),
                ('from_date', models.DateField(default=django.utils.timezone.now, verbose_name='From date')),
            ],
            options={
                'verbose_name': "Groupe d'âge",
                'verbose_name_plural': "Groupes d'âge",
                'ordering': ('order', 'name'),
            },
        ),
        migrations.CreateModel(
            name='Allergy',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
            ],
            options={
                'verbose_name': 'Allergie',
                'verbose_name_plural': 'Allergies',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Child',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('status', model_utils.fields.StatusField(choices=[('in_progress', 'In progress'), ('archived', 'Archived'), ('future', 'Future')], default='in_progress', max_length=100, no_check_for_status=True, verbose_name='status')),
                ('status_changed', model_utils.fields.MonitorField(default=django.utils.timezone.now, monitor='status', verbose_name='status changed')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('first_name', models.CharField(max_length=100, verbose_name='Prénom')),
                ('last_name', models.CharField(max_length=100, verbose_name='Nom de famille')),
                ('usual_name', models.CharField(max_length=100, verbose_name='Usual name')),
                ('gender', model_utils.fields.StatusField(choices=[('boy', 'Boy'), ('girl', 'Girl'), ('other', 'Autre')], default='boy', max_length=100, no_check_for_status=True, null=True, verbose_name='Sexe')),
                ('slug', models.SlugField(verbose_name='Slug')),
                ('picture', models.ImageField(blank=True, null=True, upload_to=nobinobi_child.models.Child.upload_picture_child, verbose_name='Picture')),
                ('birth_date', models.DateField(blank=True, null=True, verbose_name='Birth date')),
                ('red_list', models.CharField(blank=True, max_length=255, null=True, verbose_name='Red list')),
                ('comment', models.CharField(blank=True, max_length=255, null=True, verbose_name='Commentaire')),
                ('renewal_date', models.DateField(blank=True, null=True, verbose_name='Renewal date')),
                ('date_next_classroom', models.DateField(blank=True, null=True, verbose_name='Date next classroom')),
                ('age_group', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_child.agegroup', verbose_name='Age group')),
                ('allergies', models.ManyToManyField(blank=True, related_name='allergies', to='nobinobi_child.Allergy', verbose_name='Allergies')),
            ],
            options={
                'verbose_name': 'Child',
                'verbose_name_plural': 'Children',
                'ordering': ('first_name', 'last_name', 'created'),
            },
        ),
        migrations.CreateModel(
            name='Classroom',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, unique=True, verbose_name='Nom')),
                ('slug', models.SlugField(unique=True, verbose_name='Slug')),
                ('order', models.PositiveIntegerField(unique=True, verbose_name='Ordre')),
                ('capacity', models.PositiveIntegerField(default=20, verbose_name='Capacité')),
                ('mode', model_utils.fields.StatusField(choices=[('creche', 'Creche'), ('kindergarten', 'Kindergarten')], default='creche', max_length=15, no_check_for_status=True, verbose_name='Mode')),
                ('allowed_login', models.ManyToManyField(related_name='classroom_login', to=settings.AUTH_USER_MODEL, verbose_name='Connexion autorisée')),
            ],
            options={
                'verbose_name': 'Salle de classe',
                'verbose_name_plural': 'Salles de classes',
                'ordering': ('order', 'name'),
            },
        ),
        migrations.CreateModel(
            name='FoodRestriction',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
            ],
            options={
                'verbose_name': 'Restriction alimentaire',
                'verbose_name_plural': 'Restrictions alimentaires',
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='Language',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, unique=True, verbose_name='Nom')),
            ],
            options={
                'verbose_name': 'Langue',
                'verbose_name_plural': 'Langues',
                'ordering': ('name', 'created'),
            },
        ),
        migrations.CreateModel(
            name='Period',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
                ('weekday', models.IntegerField(choices=[(1, 'Lundi'), (2, 'Mardi'), (3, 'Mercredi'), (4, 'Jeudi'), (5, 'Vendredi'), (6, 'Samedi'), (7, 'Dimanche')], verbose_name='Jour de la semaine')),
                ('order', models.PositiveIntegerField(verbose_name='Ordre')),
                ('end_time', models.TimeField(null=True, verbose_name='Heure de fin')),
                ('max_child', models.PositiveIntegerField(blank=True, null=True, verbose_name='Max enfant')),
                ('start_time', models.TimeField(null=True, verbose_name='Heure de début')),
                ('type', models.CharField(choices=[('morning', 'Morning'), ('afternoon', 'Afternoon'), ('day', 'Day')], default='morning', max_length=20, verbose_name='Type')),
            ],
            options={
                'verbose_name': 'Période',
                'verbose_name_plural': 'Périodes',
                'ordering': ('weekday', 'order', 'name'),
                'unique_together': {('weekday', 'order')},
            },
        ),
        migrations.CreateModel(
            name='Contact',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('first_name', models.CharField(max_length=100, verbose_name='Prénom')),
                ('last_name', models.CharField(max_length=100, verbose_name='Nom de famille')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='Courriel')),
                ('phone', phonenumber_field.modelfields.PhoneNumberField(max_length=128, region=None, verbose_name='Téléphone')),
                ('mobile_phone', phonenumber_field.modelfields.PhoneNumberField(blank=True, max_length=128, null=True, region=None, verbose_name='Téléphone portable')),
                ('professional_phone', phonenumber_field.modelfields.PhoneNumberField(blank=True, max_length=128, null=True, region=None, verbose_name='Téléphone professionnel')),
                ('organisation', models.CharField(blank=True, max_length=100, null=True, verbose_name='Organisation')),
                ('function', models.CharField(blank=True, max_length=100, null=True, verbose_name='Fonction')),
                ('address', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='nobinobi_child.address', verbose_name='Adresse')),
                ('authorized_pick_up_child', models.NullBooleanField(verbose_name='Contact authorized to pick up the child.')),
                ('to_contact_if_needed', models.NullBooleanField(verbose_name='To contact if needed.')),
                ('parental_authority', models.BooleanField(default=True, verbose_name='Parental authority')),
                ('reside_with_child', models.BooleanField(default=True, verbose_name='Reside with child')),
            ],
            options={
                'verbose_name': 'Contact',
                'verbose_name_plural': 'Contacts',
                'ordering': ('first_name', 'last_name'),
                'unique_together': {('first_name', 'last_name', 'phone')},
            },
        ),
        migrations.CreateModel(
            name='ChildToPeriod',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('child', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Child')),
                ('period', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.period', verbose_name='Period')),
                ('end_date', models.DateField(default=datetime.datetime(2019, 4, 29, 10, 3, 48, 7786, tzinfo=utc), verbose_name='Date de fin')),
                ('start_date', models.DateField(default=datetime.datetime(2019, 4, 29, 10, 3, 48, 7786, tzinfo=utc), verbose_name='Date de début')),
            ],
            options={
                'verbose_name': 'Enfant vers période',
                'verbose_name_plural': 'Enfants aux périodes',
                'ordering': ('start_date', 'end_date', 'child', 'period'),
            },
        ),
        migrations.CreateModel(
            name='ChildToContact',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('link_with_child', models.CharField(help_text='Type contact: Exemple Père, Mère etc...', max_length=50, verbose_name='Link with child')),
                ('order', models.PositiveIntegerField(verbose_name='Ordre')),
                ('child', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Child')),
                ('contact', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.contact', verbose_name='Contact')),
            ],
            options={
                'verbose_name': 'Enfant vers contact',
                'verbose_name_plural': 'Enfants aux contacts',
                'ordering': ('child', 'order'),
            },
        ),
        migrations.AddField(
            model_name='child',
            name='classroom',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='classroom', to='nobinobi_child.classroom', verbose_name='Classroom'),
        ),
        migrations.AddField(
            model_name='child',
            name='contacts',
            field=models.ManyToManyField(blank=True, related_name='contacts', through='nobinobi_child.ChildToContact', to='nobinobi_child.Contact', verbose_name='Contacts'),
        ),
        migrations.AddField(
            model_name='child',
            name='food_restrictions',
            field=models.ManyToManyField(blank=True, related_name='food_restrictions', to='nobinobi_child.FoodRestriction', verbose_name='Food restrictions'),
        ),
        migrations.AddField(
            model_name='child',
            name='languages',
            field=models.ManyToManyField(related_name='languages', to='nobinobi_child.Language', verbose_name='Languages'),
        ),
        migrations.AddField(
            model_name='child',
            name='next_classroom',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='next_classroom', to='nobinobi_child.classroom', verbose_name='Next classroom'),
        ),
        migrations.AddField(
            model_name='child',
            name='periods',
            field=models.ManyToManyField(blank=True, related_name='periods', through='nobinobi_child.ChildToPeriod', to='nobinobi_child.Period', verbose_name='Periods'),
        ),
        migrations.AddField(
            model_name='child',
            name='staff',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_staff.staff', verbose_name='Personnel'),
        ),
        migrations.CreateModel(
            name='AbsenceType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('name', models.CharField(max_length=50, verbose_name='Nom')),
                ('order', models.PositiveIntegerField(verbose_name='Ordre')),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='nobinobi_child.absencegroup', verbose_name='Groupe')),
            ],
            options={
                'verbose_name': "Type d'absence",
                'verbose_name_plural': 'Types d’absences',
                'ordering': ('order', 'group', 'name'),
            },
        ),
        migrations.AlterModelOptions(
            name='child',
            options={'ordering': ('first_name', 'last_name', 'created'), 'verbose_name': 'Enfant', 'verbose_name_plural': 'Enfants'},
        ),
        migrations.CreateModel(
            name='Absence',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('child', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Enfant')),
                ('type', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='nobinobi_child.absencetype', verbose_name='Type')),
                ('end_date', models.DateTimeField(default=datetime.datetime(2019, 4, 29, 10, 3, 33, 847499, tzinfo=utc), verbose_name='Date de fin')),
                ('start_date', models.DateTimeField(default=datetime.datetime(2019, 4, 29, 10, 3, 38, 919489, tzinfo=utc), verbose_name='Date de début')),
            ],
            options={
                'verbose_name': 'Absence',
                'verbose_name_plural': 'Absences',
                'ordering': ('start_date', 'end_date', 'child'),
            },
        ),
        migrations.AlterField(
            model_name='child',
            name='age_group',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='nobinobi_child.agegroup', verbose_name="Groupe d'âge"),
        ),
        migrations.AlterField(
            model_name='child',
            name='birth_date',
            field=models.DateField(blank=True, null=True, verbose_name='Date de naissance'),
        ),
        migrations.AlterField(
            model_name='child',
            name='classroom',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='classroom', to='nobinobi_child.classroom', verbose_name='Salle de classe'),
        ),
        migrations.AlterField(
            model_name='child',
            name='date_next_classroom',
            field=models.DateField(blank=True, null=True, verbose_name='Date prochaine salle de classe'),
        ),
        migrations.AlterField(
            model_name='child',
            name='food_restrictions',
            field=models.ManyToManyField(blank=True, related_name='food_restrictions', to='nobinobi_child.FoodRestriction', verbose_name='Restrictions alimentaires'),
        ),
        migrations.AlterField(
            model_name='child',
            name='languages',
            field=models.ManyToManyField(related_name='languages', to='nobinobi_child.Language', verbose_name='Langues'),
        ),
        migrations.AlterField(
            model_name='child',
            name='next_classroom',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='next_classroom', to='nobinobi_child.classroom', verbose_name='Prochaine salle de classe'),
        ),
        migrations.AlterField(
            model_name='child',
            name='periods',
            field=models.ManyToManyField(blank=True, related_name='periods', through='nobinobi_child.ChildToPeriod', to='nobinobi_child.Period', verbose_name='Périodes'),
        ),
        migrations.AlterField(
            model_name='child',
            name='picture',
            field=models.ImageField(blank=True, null=True, upload_to=nobinobi_child.models.Child.upload_picture_child, verbose_name='Photo'),
        ),
        migrations.AlterField(
            model_name='child',
            name='red_list',
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name='Liste rouge'),
        ),
        migrations.AlterField(
            model_name='child',
            name='renewal_date',
            field=models.DateField(blank=True, null=True, verbose_name='Date de renouvellement'),
        ),
        migrations.AlterField(
            model_name='child',
            name='usual_name',
            field=models.CharField(max_length=100, verbose_name='Nom usuel'),
        ),
        migrations.CreateModel(
            name='ChildSpecificNeed',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('problem', model_utils.fields.SplitField(no_excerpt_field=True, verbose_name='Problème')),
                ('ihp', models.BooleanField(default=True, verbose_name="Project d'accueil individualisé")),
                ('attachment', models.FileField(upload_to=nobinobi_child.models.ChildSpecificNeed.upload_attachment_child, verbose_name='Pièce jointe')),
                ('measure_take', model_utils.fields.SplitField(no_excerpt_field=True, verbose_name='Mesure à prendre')),
                ('_problem_excerpt', models.TextField(editable=False)),
                ('_measure_take_excerpt', models.TextField(editable=False)),
                ('child', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Enfant')),
            ],
            options={
                'verbose_name': 'Besoins spécifiques de l’enfant',
                'verbose_name_plural': 'Enfants à besoins spécifiques',
                'ordering': ('child',),
            },
        ),
        migrations.AlterField(
            model_name='childtocontact',
            name='child',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Enfant'),
        ),
        migrations.AlterField(
            model_name='childtocontact',
            name='link_with_child',
            field=models.CharField(help_text='Type contact: Exemple Père, Mère ...', max_length=50, verbose_name="Lien avec l'enfant"),
        ),
        migrations.AlterField(
            model_name='childtoperiod',
            name='child',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Enfant'),
        ),
        migrations.AlterField(
            model_name='childtoperiod',
            name='period',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.period', verbose_name='Période'),
        ),
        migrations.CreateModel(
            name='ClassroomDayOff',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('weekday', models.IntegerField(choices=[(1, 'Lundi'), (2, 'Mardi'), (3, 'Mercredi'), (4, 'Jeudi'), (5, 'Vendredi'), (6, 'Samedi'), (7, 'Dimanche')], verbose_name='Jour de la semaine')),
                ('classrooms', models.ManyToManyField(to='nobinobi_child.Classroom', verbose_name='Salle de classe')),
            ],
            options={
                'verbose_name': 'Jour de congé',
                'verbose_name_plural': 'Jours de congés',
                'ordering': ('weekday',),
            },
        ),
        migrations.CreateModel(
            name='LogChangeClassroom',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('date', models.DateField(verbose_name='Date')),
                ('child', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nobinobi_child.child', verbose_name='Enfant')),
                ('classroom', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='log_change_classroom', to='nobinobi_child.classroom', verbose_name='Salle de classe')),
                ('next_classroom', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='log_change_next_classroom', to='nobinobi_child.classroom', verbose_name='Prochaine salle de classe')),
            ],
            options={
                'verbose_name': 'Journal de changement de classe',
                'verbose_name_plural': 'Journaux de changement de classe',
                'ordering': ('date',),
                'unique_together': {('child', 'classroom')},
            },
        ),
        migrations.CreateModel(
            name='InformationOfTheDay',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('content', model_utils.fields.SplitField(no_excerpt_field=True, verbose_name='Contenu')),
                ('_content_excerpt', models.TextField(editable=False)),
                ('classrooms', models.ManyToManyField(related_name='classrooms', to='nobinobi_child.Classroom', verbose_name='Salle de classe')),
                ('end_date', models.DateTimeField(default=datetime.datetime(2019, 4, 29, 10, 3, 55, 319308, tzinfo=utc), verbose_name='Date de fin')),
                ('start_date', models.DateTimeField(default=datetime.datetime(2019, 4, 29, 10, 4, 0, 424127, tzinfo=utc), verbose_name='Date de début')),
                ('title', models.CharField(max_length=50, verbose_name='Titre')),
            ],
            options={
                'verbose_name': 'Information du jour',
                'verbose_name_plural': 'Informations du jour',
                'ordering': ('start_date', 'end_date'),
            },
        ),
        migrations.AlterField(
            model_name='child',
            name='usual_name',
            field=models.CharField(max_length=100, unique=True, verbose_name='Nom usuel'),
        ),
        migrations.AlterUniqueTogether(
            name='child',
            unique_together={('first_name', 'last_name', 'birth_date')},
        ),
        migrations.AlterModelOptions(
            name='childtocontact',
            options={'ordering': ('order', 'child'), 'verbose_name': 'Enfant vers contact', 'verbose_name_plural': 'Enfants aux contacts'},
        ),
        migrations.AddField(
            model_name='child',
            name='good_development',
            field=models.NullBooleanField(verbose_name='Good development'),
        ),
        migrations.AddField(
            model_name='child',
            name='health_insurance',
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name='Health Insurance'),
        ),
        migrations.AddField(
            model_name='child',
            name='healthy_child',
            field=models.NullBooleanField(verbose_name='Healthy child'),
        ),
        migrations.AddField(
            model_name='child',
            name='specific_problem',
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name='Specific problem'),
        ),
        migrations.AddField(
            model_name='child',
            name='usage_paracetamol',
            field=models.NullBooleanField(verbose_name='Usage paracetamol'),
        ),
        migrations.AddField(
            model_name='child',
            name='vaccination',
            field=models.NullBooleanField(verbose_name='Vaccination'),
        ),
        migrations.AddField(
            model_name='child',
            name='pediatrician',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, related_name='pediatrician', to='nobinobi_child.contact', verbose_name='Pediatrician'),
        ),
        migrations.AddField(
            model_name='child',
            name='pediatrician_contact',
            field=models.NullBooleanField(verbose_name='Pediatrician contact'),
        ),
        migrations.AddField(
            model_name='child',
            name='sibling_birth_date',
            field=models.DateField(blank=True, null=True, verbose_name='Sibling birth date'),
        ),
        migrations.AddField(
            model_name='child',
            name='sibling_institution',
            field=models.CharField(blank=True, max_length=100, null=True, verbose_name="Sibling's institution"),
        ),
        migrations.AddField(
            model_name='child',
            name='sibling_name',
            field=models.CharField(blank=True, max_length=50, null=True, verbose_name="Sibling's name and first name"),
        ),
        migrations.AddField(
            model_name='child',
            name='nationality',
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name='Child nationality'),
        ),
        migrations.AddField(
            model_name='child',
            name='usage_homeopathy',
            field=models.NullBooleanField(verbose_name='Usage homeopathy'),
        ),
    ]
