# Description

Библиотека для парсинга УБКИ с [официального сайта](https://www.ubki.ua/ru/).
Имеет классы для удобной работы как с сайтом, так и обработки и получение в подходящем ввиде данны из отчетов УБКИ.

### UbkiRequest
Класс для осуществленния авторизации на сайте и возможности получения отчетов УБКИ. Отчеты получаються ввиде класса UbkiReport.

### UbkiReport
Класс для хранения полученных входе запроса данных о персоне. Данный класс также предоставляет методы получения этих данных в сыром виде или же обработанных для использования в скоринговом анализе.

## Использование
Для получения данных нужно инициализировать класс UbkiRequest, который проведет при необходимости авторизацию для получения сессионого ключа для проведения запросов. Потом можно получить данные о пользователе. Для примера сначала проведем тестовое подключение в ходе которого будет получен UbkiReport, из которого можно уже извлечь необходимые данные, такие как сырые данные в виде xml или словарь с полезными для скоринг анализа признаками.

### Пример использования при подключение к тестовому серверу:
```python
>> connect = UbkiRequest("login", "password", is_test = True)
>> ubki = connect.get_person_credit_report()
>> ubki.get_report_xml() # Будет полученна строка xml-представления кредитного отчета о физическом лице
>> ubki.get_score_xml() # Будет полученна строка xml-представления кредитного балла
>> ubki.get_useful_ubki_fields()
{'median_day_credit': 1,
  ...
 'ubki_maxnowexp': None}
```

### Пример использования при подключение к оригинальному серверу:
```python
>> connect = UbkiRequest("login", "password", is_test = False)
>> data = \
    {
    'okpo':"2111118724", 'lname':"РИБАЧКА", 'fname':"АННА", 'mname':"ІГОРЕВНА", 'bdate':"1957-10-19", 
    "dtype":"1", 'dser':"ВВ", 'dnom':"142228", 
    'cval':"+380111111111", 'ctype':"3", 'email':"email@gmail.com",
    'reqidout':'00001'}
>> ubki = connect.get_person_credit_report()
>> ubki.get_report_xml() # Будет полученна строка xml-представления кредитного отчета о физическом лице
>> ubki.get_score_xml() # Будет полученна строка xml-представления кредитного балла
>> ubki.get_useful_ubki_fields()
{'median_day_credit': 423,
  ...
 'ubki_maxnowexp': 100}
```