import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivateCrossconnectConfig extends cdktf.TerraformMetaArguments {
    /**
    * The desired description for the private cross-connect
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/private_crossconnect#description PrivateCrossconnect#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/private_crossconnect#id PrivateCrossconnect#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The desired name for the private cross-connect
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/private_crossconnect#name PrivateCrossconnect#name}
    */
    readonly name: string;
    /**
    * connectable_datacenters block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/private_crossconnect#connectable_datacenters PrivateCrossconnect#connectable_datacenters}
    */
    readonly connectableDatacenters?: PrivateCrossconnectConnectableDatacenters[] | cdktf.IResolvable;
    /**
    * peers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/private_crossconnect#peers PrivateCrossconnect#peers}
    */
    readonly peers?: PrivateCrossconnectPeers[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/private_crossconnect#timeouts PrivateCrossconnect#timeouts}
    */
    readonly timeouts?: PrivateCrossconnectTimeouts;
}
export interface PrivateCrossconnectConnectableDatacenters {
}
export declare function privateCrossconnectConnectableDatacentersToTerraform(struct?: PrivateCrossconnectConnectableDatacenters | cdktf.IResolvable): any;
export declare class PrivateCrossconnectConnectableDatacentersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivateCrossconnectConnectableDatacenters | cdktf.IResolvable | undefined;
    set internalValue(value: PrivateCrossconnectConnectableDatacenters | cdktf.IResolvable | undefined);
    get id(): string;
    get location(): string;
    get name(): string;
}
export declare class PrivateCrossconnectConnectableDatacentersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PrivateCrossconnectConnectableDatacenters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivateCrossconnectConnectableDatacentersOutputReference;
}
export interface PrivateCrossconnectPeers {
}
export declare function privateCrossconnectPeersToTerraform(struct?: PrivateCrossconnectPeers | cdktf.IResolvable): any;
export declare class PrivateCrossconnectPeersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivateCrossconnectPeers | cdktf.IResolvable | undefined;
    set internalValue(value: PrivateCrossconnectPeers | cdktf.IResolvable | undefined);
    get datacenterId(): string;
    get datacenterName(): string;
    get lanId(): string;
    get lanName(): string;
    get location(): string;
}
export declare class PrivateCrossconnectPeersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PrivateCrossconnectPeers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivateCrossconnectPeersOutputReference;
}
export interface PrivateCrossconnectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/private_crossconnect#create PrivateCrossconnect#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/private_crossconnect#default PrivateCrossconnect#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/private_crossconnect#delete PrivateCrossconnect#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/private_crossconnect#update PrivateCrossconnect#update}
    */
    readonly update?: string;
}
export declare function privateCrossconnectTimeoutsToTerraform(struct?: PrivateCrossconnectTimeoutsOutputReference | PrivateCrossconnectTimeouts | cdktf.IResolvable): any;
export declare class PrivateCrossconnectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivateCrossconnectTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PrivateCrossconnectTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/private_crossconnect ionoscloud_private_crossconnect}
*/
export declare class PrivateCrossconnect extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_private_crossconnect";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/private_crossconnect ionoscloud_private_crossconnect} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivateCrossconnectConfig
    */
    constructor(scope: Construct, id: string, config: PrivateCrossconnectConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _connectableDatacenters;
    get connectableDatacenters(): PrivateCrossconnectConnectableDatacentersList;
    putConnectableDatacenters(value: PrivateCrossconnectConnectableDatacenters[] | cdktf.IResolvable): void;
    resetConnectableDatacenters(): void;
    get connectableDatacentersInput(): cdktf.IResolvable | PrivateCrossconnectConnectableDatacenters[] | undefined;
    private _peers;
    get peers(): PrivateCrossconnectPeersList;
    putPeers(value: PrivateCrossconnectPeers[] | cdktf.IResolvable): void;
    resetPeers(): void;
    get peersInput(): cdktf.IResolvable | PrivateCrossconnectPeers[] | undefined;
    private _timeouts;
    get timeouts(): PrivateCrossconnectTimeoutsOutputReference;
    putTimeouts(value: PrivateCrossconnectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PrivateCrossconnectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
