# VESIcal
A generalized python library for calculating and plotting various things related to mixed volatile (H2O-CO2) solubility in silicate melts.

[![Documentation Status](https://readthedocs.org/projects/vesical/badge/?version=latest)](https://vesical.readthedocs.io/en/latest/?badge=latest)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.4291043.svg)](https://doi.org/10.5281/zenodo.4291043)


## Installation

First, obtain Python3.x if you do not already have it installed. If you are new to python, we recommend installing it via anaconda3 (https://www.anaconda.com/products/individual). VESIcal can be installed with one line. Open a terminal and type the following:

```
pip install VESIcal
```

Check that the installation worked by entering the following lines into a terminal:

```
python
import VESIcal as v
```

If no output is returned, VESIcal has installed properly! You will very likely, however, see a warning telling you that no module named 'thermoengine' could be found. The installation you performed via pip attempts to install all dependencies (other libraries that VESIcal requires), but thermoengine is not available via pip and so must be manually installed.

Dependencies that should automatically be installed for you are:

   - pandas
   - numpy
   - matplotlib
   - cycler
   - abc
   - scipy
   - sys
   - sympy
   - copy

If any warnings related to these libraries appear, try installing them as you did VESIcal: with 'pip install [package]'.

thermoengine is the ENKI implementation of MELTS (MagmaSat), which is the backbone of the entire VESIcal library. VESIcal cannot be run without thermoengine at this time, however a VESIcal-lite that does not include MagmaSat is planned. To install thermoengine, please refer to the ENKI documentation here: https://gitlab.com/ENKI-portal/ThermoEngine.

## Documentation
Read all of our documentation, inlcuding quickstart guides here: https://vesical.readthedocs.io/en/latest/

Check our our YouTube channel for videos on how to use VESIcal here: https://www.youtube.com/channel/UCpvCCs5KMXzOxXWm0seF8Qw

## Contributing
Issues are tracked on [GitHub](https://github.com/kaylai/VESIcal/issues).

Patches may be submitted via a [Github pull request](https://github.com/kaylai/VESIcal/pulls). All changes should include tests (VESIcal uses python's unittest library) and pass [flake8](https://pypi.org/project/flake8/).
