# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/52_data.ipynb.

# %% auto 0
__all__ = ['NPArray', 'ndarray', 'Idx', 'Index', 'Series', 'DFrame', 'DataFrame', 'DataFrames', 'IndexLike', 'SeriesLike',
           'IterLike', 'GroupKey']

# %% ../nbs/52_data.ipynb 6
import inspect
from numbers import Number

# %% ../nbs/52_data.ipynb 8
import types
from typing import (
    Type, TypeAlias, Tuple,
    ClassVar, Any, Optional, Callable, Iterable, ForwardRef
)
from typing import TypeAlias, List, Union, Iterable, List

# %% ../nbs/52_data.ipynb 11
try:
    import numpy as np
    arr = np.ndarray
except ImportError:
    # Define a placeholder type if numpy is not installed
    arr = 'numpy.ndarray'

# %% ../nbs/52_data.ipynb 13
try:
    import pandas as pd
    index = pd.Index
    dframe = pd.DataFrame
    series = pd.Series
except ImportError:
    # Define a placeholder type if pandas is not installed
    index = 'pandas.Index'    
    dframe = 'pandas.DataFrame'
    series = 'pandas.Series'

# %% ../nbs/52_data.ipynb 15
#| export


# %% ../nbs/52_data.ipynb 17
from .nums import Numbers

# %% ../nbs/52_data.ipynb 20
NPArray: TypeAlias = arr
ndarray: TypeAlias = arr

# %% ../nbs/52_data.ipynb 22
Idx: TypeAlias = index
Index: TypeAlias = index
Series: TypeAlias = series
DFrame: TypeAlias = dframe
DataFrame: TypeAlias = dframe
DataFrames: TypeAlias = List[DataFrame]

# %% ../nbs/52_data.ipynb 24
IndexLike: TypeAlias = Union[Numbers, List['Boolish'], 'Index']
SeriesLike: TypeAlias = Union[list, 'Series', 'ndarray', 'Tensor', 'IndexLike']
IterLike: TypeAlias = Union[Iterable, 'SeriesLike', 'IndexLike']

# %% ../nbs/52_data.ipynb 25
GroupKey: TypeAlias = Union[str, int, float, tuple] # key for pandas groupby
