# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/libs/08_dtyp.ipynb.

# %% auto 0
__all__ = ['NPArray', 'ndarray', 'Idx', 'Index', 'Series', 'DFrame', 'DataFrame', 'DataFrames', 'IndexLike', 'SeriesLike',
           'IterLike', 'GroupKey']

# %% ../nbs/libs/08_dtyp.ipynb 4
from typing import TypeAlias, List, Union, Iterable, List

# %% ../nbs/libs/08_dtyp.ipynb 5
from .atyp import  Boolish, Numbers

# %% ../nbs/libs/08_dtyp.ipynb 7
try:
    import numpy as np
    arr = np.ndarray
except ImportError:
    # Define a placeholder type if numpy is not installed
    arr = 'numpy.ndarray'

# %% ../nbs/libs/08_dtyp.ipynb 8
NPArray: TypeAlias = arr
ndarray: TypeAlias = arr

# %% ../nbs/libs/08_dtyp.ipynb 10
try:
    import pandas as pd
    index = pd.Index
    dframe = pd.DataFrame
    series = pd.Series
except ImportError:
    # Define a placeholder type if pandas is not installed
    index = 'pandas.Index'    
    dframe = 'pandas.DataFrame'
    series = 'pandas.Series'

# %% ../nbs/libs/08_dtyp.ipynb 11
Idx: TypeAlias = index
Index: TypeAlias = index

Series: TypeAlias = series

DFrame: TypeAlias = dframe
DataFrame: TypeAlias = dframe

DataFrames: TypeAlias = List[DataFrame]

# %% ../nbs/libs/08_dtyp.ipynb 13
IndexLike: TypeAlias = Union[Numbers, List['Boolish'], 'Index']

SeriesLike: TypeAlias = Union[list, 'Series', 'ndarray', 'Tensor', 'IndexLike']

IterLike: TypeAlias = Union[Iterable, 'SeriesLike', 'IndexLike']

# %% ../nbs/libs/08_dtyp.ipynb 14
GroupKey: TypeAlias = Union[str, int, float, tuple] # key for pandas groupby
