# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AttestorArgs', 'Attestor']

@pulumi.input_type
class AttestorArgs:
    def __init__(__self__, *,
                 attestation_authority_note: pulumi.Input['AttestorAttestationAuthorityNoteArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Attestor resource.
        :param pulumi.Input['AttestorAttestationAuthorityNoteArgs'] attestation_authority_note: A Container Analysis ATTESTATION_AUTHORITY Note, created by the user.
               Structure is documented below.
        :param pulumi.Input[str] description: A descriptive comment. This field may be updated. The field may be
               displayed in chooser dialogs.
        :param pulumi.Input[str] name: The resource name.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "attestation_authority_note", attestation_authority_note)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="attestationAuthorityNote")
    def attestation_authority_note(self) -> pulumi.Input['AttestorAttestationAuthorityNoteArgs']:
        """
        A Container Analysis ATTESTATION_AUTHORITY Note, created by the user.
        Structure is documented below.
        """
        return pulumi.get(self, "attestation_authority_note")

    @attestation_authority_note.setter
    def attestation_authority_note(self, value: pulumi.Input['AttestorAttestationAuthorityNoteArgs']):
        pulumi.set(self, "attestation_authority_note", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive comment. This field may be updated. The field may be
        displayed in chooser dialogs.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _AttestorState:
    def __init__(__self__, *,
                 attestation_authority_note: Optional[pulumi.Input['AttestorAttestationAuthorityNoteArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Attestor resources.
        :param pulumi.Input['AttestorAttestationAuthorityNoteArgs'] attestation_authority_note: A Container Analysis ATTESTATION_AUTHORITY Note, created by the user.
               Structure is documented below.
        :param pulumi.Input[str] description: A descriptive comment. This field may be updated. The field may be
               displayed in chooser dialogs.
        :param pulumi.Input[str] name: The resource name.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        if attestation_authority_note is not None:
            pulumi.set(__self__, "attestation_authority_note", attestation_authority_note)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="attestationAuthorityNote")
    def attestation_authority_note(self) -> Optional[pulumi.Input['AttestorAttestationAuthorityNoteArgs']]:
        """
        A Container Analysis ATTESTATION_AUTHORITY Note, created by the user.
        Structure is documented below.
        """
        return pulumi.get(self, "attestation_authority_note")

    @attestation_authority_note.setter
    def attestation_authority_note(self, value: Optional[pulumi.Input['AttestorAttestationAuthorityNoteArgs']]):
        pulumi.set(self, "attestation_authority_note", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive comment. This field may be updated. The field may be
        displayed in chooser dialogs.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class Attestor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attestation_authority_note: Optional[pulumi.Input[pulumi.InputType['AttestorAttestationAuthorityNoteArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        An attestor that attests to container image artifacts.

        To get more information about Attestor, see:

        * [API documentation](https://cloud.google.com/binary-authorization/docs/reference/rest/)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/binary-authorization/)

        ## Example Usage
        ### Binary Authorization Attestor Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        note = gcp.containeranalysis.Note("note", attestation_authority=gcp.containeranalysis.NoteAttestationAuthorityArgs(
            hint=gcp.containeranalysis.NoteAttestationAuthorityHintArgs(
                human_readable_name="Attestor Note",
            ),
        ))
        attestor = gcp.binaryauthorization.Attestor("attestor", attestation_authority_note=gcp.binaryauthorization.AttestorAttestationAuthorityNoteArgs(
            note_reference=note.name,
            public_keys=[{
                "asciiArmoredPgpPublicKey": \"\"\"mQENBFtP0doBCADF+joTiXWKVuP8kJt3fgpBSjT9h8ezMfKA4aXZctYLx5wslWQl
        bB7Iu2ezkECNzoEeU7WxUe8a61pMCh9cisS9H5mB2K2uM4Jnf8tgFeXn3akJDVo0
        oR1IC+Dp9mXbRSK3MAvKkOwWlG99sx3uEdvmeBRHBOO+grchLx24EThXFOyP9Fk6
        V39j6xMjw4aggLD15B4V0v9JqBDdJiIYFzszZDL6pJwZrzcP0z8JO4rTZd+f64bD
        Mpj52j/pQfA8lZHOaAgb1OrthLdMrBAjoDjArV4Ek7vSbrcgYWcI6BhsQrFoxKdX
        83TZKai55ZCfCLIskwUIzA1NLVwyzCS+fSN/ABEBAAG0KCJUZXN0IEF0dGVzdG9y
        IiA8ZGFuYWhvZmZtYW5AZ29vZ2xlLmNvbT6JAU4EEwEIADgWIQRfWkqHt6hpTA1L
        uY060eeM4dc66AUCW0/R2gIbLwULCQgHAgYVCgkICwIEFgIDAQIeAQIXgAAKCRA6
        0eeM4dc66HdpCAC4ot3b0OyxPb0Ip+WT2U0PbpTBPJklesuwpIrM4Lh0N+1nVRLC
        51WSmVbM8BiAFhLbN9LpdHhds1kUrHF7+wWAjdR8sqAj9otc6HGRM/3qfa2qgh+U
        WTEk/3us/rYSi7T7TkMuutRMIa1IkR13uKiW56csEMnbOQpn9rDqwIr5R8nlZP5h
        MAU9vdm1DIv567meMqTaVZgR3w7bck2P49AO8lO5ERFpVkErtu/98y+rUy9d789l
        +OPuS1NGnxI1YKsNaWJF4uJVuvQuZ1twrhCbGNtVorO2U12+cEq+YtUxj7kmdOC1
        qoIRW6y0+UlAc+MbqfL0ziHDOAmcqz1GnROg
        =6Bvm
        \"\"\",
            }],
        ))
        ```
        ### Binary Authorization Attestor Kms

        ```python
        import pulumi
        import pulumi_gcp as gcp

        keyring = gcp.kms.KeyRing("keyring", location="global")
        crypto_key = gcp.kms.CryptoKey("crypto-key",
            key_ring=keyring.id,
            purpose="ASYMMETRIC_SIGN",
            version_template=gcp.kms.CryptoKeyVersionTemplateArgs(
                algorithm="RSA_SIGN_PKCS1_4096_SHA512",
            ))
        version = crypto_key.id.apply(lambda id: gcp.kms.get_kms_crypto_key_version(crypto_key=id))
        note = gcp.containeranalysis.Note("note", attestation_authority=gcp.containeranalysis.NoteAttestationAuthorityArgs(
            hint=gcp.containeranalysis.NoteAttestationAuthorityHintArgs(
                human_readable_name="Attestor Note",
            ),
        ))
        attestor = gcp.binaryauthorization.Attestor("attestor", attestation_authority_note=gcp.binaryauthorization.AttestorAttestationAuthorityNoteArgs(
            note_reference=note.name,
            public_keys=[{
                "id": version.id,
                "pkixPublicKey": {
                    "publicKeyPem": version.public_keys[0].pem,
                    "signatureAlgorithm": version.public_keys[0].algorithm,
                },
            }],
        ))
        ```

        ## Import

        Attestor can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:binaryauthorization/attestor:Attestor default projects/{{project}}/attestors/{{name}}
        ```

        ```sh
         $ pulumi import gcp:binaryauthorization/attestor:Attestor default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:binaryauthorization/attestor:Attestor default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AttestorAttestationAuthorityNoteArgs']] attestation_authority_note: A Container Analysis ATTESTATION_AUTHORITY Note, created by the user.
               Structure is documented below.
        :param pulumi.Input[str] description: A descriptive comment. This field may be updated. The field may be
               displayed in chooser dialogs.
        :param pulumi.Input[str] name: The resource name.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AttestorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        An attestor that attests to container image artifacts.

        To get more information about Attestor, see:

        * [API documentation](https://cloud.google.com/binary-authorization/docs/reference/rest/)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/binary-authorization/)

        ## Example Usage
        ### Binary Authorization Attestor Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        note = gcp.containeranalysis.Note("note", attestation_authority=gcp.containeranalysis.NoteAttestationAuthorityArgs(
            hint=gcp.containeranalysis.NoteAttestationAuthorityHintArgs(
                human_readable_name="Attestor Note",
            ),
        ))
        attestor = gcp.binaryauthorization.Attestor("attestor", attestation_authority_note=gcp.binaryauthorization.AttestorAttestationAuthorityNoteArgs(
            note_reference=note.name,
            public_keys=[{
                "asciiArmoredPgpPublicKey": \"\"\"mQENBFtP0doBCADF+joTiXWKVuP8kJt3fgpBSjT9h8ezMfKA4aXZctYLx5wslWQl
        bB7Iu2ezkECNzoEeU7WxUe8a61pMCh9cisS9H5mB2K2uM4Jnf8tgFeXn3akJDVo0
        oR1IC+Dp9mXbRSK3MAvKkOwWlG99sx3uEdvmeBRHBOO+grchLx24EThXFOyP9Fk6
        V39j6xMjw4aggLD15B4V0v9JqBDdJiIYFzszZDL6pJwZrzcP0z8JO4rTZd+f64bD
        Mpj52j/pQfA8lZHOaAgb1OrthLdMrBAjoDjArV4Ek7vSbrcgYWcI6BhsQrFoxKdX
        83TZKai55ZCfCLIskwUIzA1NLVwyzCS+fSN/ABEBAAG0KCJUZXN0IEF0dGVzdG9y
        IiA8ZGFuYWhvZmZtYW5AZ29vZ2xlLmNvbT6JAU4EEwEIADgWIQRfWkqHt6hpTA1L
        uY060eeM4dc66AUCW0/R2gIbLwULCQgHAgYVCgkICwIEFgIDAQIeAQIXgAAKCRA6
        0eeM4dc66HdpCAC4ot3b0OyxPb0Ip+WT2U0PbpTBPJklesuwpIrM4Lh0N+1nVRLC
        51WSmVbM8BiAFhLbN9LpdHhds1kUrHF7+wWAjdR8sqAj9otc6HGRM/3qfa2qgh+U
        WTEk/3us/rYSi7T7TkMuutRMIa1IkR13uKiW56csEMnbOQpn9rDqwIr5R8nlZP5h
        MAU9vdm1DIv567meMqTaVZgR3w7bck2P49AO8lO5ERFpVkErtu/98y+rUy9d789l
        +OPuS1NGnxI1YKsNaWJF4uJVuvQuZ1twrhCbGNtVorO2U12+cEq+YtUxj7kmdOC1
        qoIRW6y0+UlAc+MbqfL0ziHDOAmcqz1GnROg
        =6Bvm
        \"\"\",
            }],
        ))
        ```
        ### Binary Authorization Attestor Kms

        ```python
        import pulumi
        import pulumi_gcp as gcp

        keyring = gcp.kms.KeyRing("keyring", location="global")
        crypto_key = gcp.kms.CryptoKey("crypto-key",
            key_ring=keyring.id,
            purpose="ASYMMETRIC_SIGN",
            version_template=gcp.kms.CryptoKeyVersionTemplateArgs(
                algorithm="RSA_SIGN_PKCS1_4096_SHA512",
            ))
        version = crypto_key.id.apply(lambda id: gcp.kms.get_kms_crypto_key_version(crypto_key=id))
        note = gcp.containeranalysis.Note("note", attestation_authority=gcp.containeranalysis.NoteAttestationAuthorityArgs(
            hint=gcp.containeranalysis.NoteAttestationAuthorityHintArgs(
                human_readable_name="Attestor Note",
            ),
        ))
        attestor = gcp.binaryauthorization.Attestor("attestor", attestation_authority_note=gcp.binaryauthorization.AttestorAttestationAuthorityNoteArgs(
            note_reference=note.name,
            public_keys=[{
                "id": version.id,
                "pkixPublicKey": {
                    "publicKeyPem": version.public_keys[0].pem,
                    "signatureAlgorithm": version.public_keys[0].algorithm,
                },
            }],
        ))
        ```

        ## Import

        Attestor can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:binaryauthorization/attestor:Attestor default projects/{{project}}/attestors/{{name}}
        ```

        ```sh
         $ pulumi import gcp:binaryauthorization/attestor:Attestor default {{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:binaryauthorization/attestor:Attestor default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param AttestorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AttestorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attestation_authority_note: Optional[pulumi.Input[pulumi.InputType['AttestorAttestationAuthorityNoteArgs']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AttestorArgs.__new__(AttestorArgs)

            if attestation_authority_note is None and not opts.urn:
                raise TypeError("Missing required property 'attestation_authority_note'")
            __props__.__dict__["attestation_authority_note"] = attestation_authority_note
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
        super(Attestor, __self__).__init__(
            'gcp:binaryauthorization/attestor:Attestor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attestation_authority_note: Optional[pulumi.Input[pulumi.InputType['AttestorAttestationAuthorityNoteArgs']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None) -> 'Attestor':
        """
        Get an existing Attestor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AttestorAttestationAuthorityNoteArgs']] attestation_authority_note: A Container Analysis ATTESTATION_AUTHORITY Note, created by the user.
               Structure is documented below.
        :param pulumi.Input[str] description: A descriptive comment. This field may be updated. The field may be
               displayed in chooser dialogs.
        :param pulumi.Input[str] name: The resource name.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AttestorState.__new__(_AttestorState)

        __props__.__dict__["attestation_authority_note"] = attestation_authority_note
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        return Attestor(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="attestationAuthorityNote")
    def attestation_authority_note(self) -> pulumi.Output['outputs.AttestorAttestationAuthorityNote']:
        """
        A Container Analysis ATTESTATION_AUTHORITY Note, created by the user.
        Structure is documented below.
        """
        return pulumi.get(self, "attestation_authority_note")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A descriptive comment. This field may be updated. The field may be
        displayed in chooser dialogs.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

