# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'TriggerBuildArgs',
    'TriggerBuildArtifactsArgs',
    'TriggerBuildArtifactsObjectsArgs',
    'TriggerBuildArtifactsObjectsTimingArgs',
    'TriggerBuildOptionsArgs',
    'TriggerBuildOptionsVolumeArgs',
    'TriggerBuildSecretArgs',
    'TriggerBuildSourceArgs',
    'TriggerBuildSourceRepoSourceArgs',
    'TriggerBuildSourceStorageSourceArgs',
    'TriggerBuildStepArgs',
    'TriggerBuildStepVolumeArgs',
    'TriggerGithubArgs',
    'TriggerGithubPullRequestArgs',
    'TriggerGithubPushArgs',
    'TriggerPubsubConfigArgs',
    'TriggerTriggerTemplateArgs',
    'TriggerWebhookConfigArgs',
    'WorkerPoolNetworkConfigArgs',
    'WorkerPoolWorkerConfigArgs',
]

@pulumi.input_type
class TriggerBuildArgs:
    def __init__(__self__, *,
                 steps: pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepArgs']]],
                 artifacts: Optional[pulumi.Input['TriggerBuildArtifactsArgs']] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 logs_bucket: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input['TriggerBuildOptionsArgs']] = None,
                 queue_ttl: Optional[pulumi.Input[str]] = None,
                 secrets: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildSecretArgs']]]] = None,
                 source: Optional[pulumi.Input['TriggerBuildSourceArgs']] = None,
                 substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepArgs']]] steps: The operations to be performed on the workspace.
               Structure is documented below.
        :param pulumi.Input['TriggerBuildArtifactsArgs'] artifacts: Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] images: A list of images to be pushed upon the successful completion of all build steps.
               The images will be pushed using the builder service account's credentials.
               The digests of the pushed images will be stored in the Build resource's results field.
               If any of the images fail to be pushed, the build is marked FAILURE.
        :param pulumi.Input[str] logs_bucket: Google Cloud Storage bucket where logs should be written.
               Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        :param pulumi.Input['TriggerBuildOptionsArgs'] options: Special options for this build.
               Structure is documented below.
        :param pulumi.Input[str] queue_ttl: TTL in queue for this build. If provided and the build is enqueued longer than this value,
               the build will expire and the build status will be EXPIRED.
               The TTL starts ticking from createTime.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildSecretArgs']]] secrets: Secrets to decrypt using Cloud Key Management Service.
               Structure is documented below.
        :param pulumi.Input['TriggerBuildSourceArgs'] source: The location of the source files to build.
               One of `storageSource` or `repoSource` must be provided.
               Structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] substitutions: Substitutions to use in a triggered build. Should only be used with triggers.run
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Tags for annotation of a Build. These are not docker tags.
        :param pulumi.Input[str] timeout: Time limit for executing this build step. If not defined,
               the step has no
               time limit and will be allowed to continue to run until either it
               completes or the build itself times out.
        """
        pulumi.set(__self__, "steps", steps)
        if artifacts is not None:
            pulumi.set(__self__, "artifacts", artifacts)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if logs_bucket is not None:
            pulumi.set(__self__, "logs_bucket", logs_bucket)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if queue_ttl is not None:
            pulumi.set(__self__, "queue_ttl", queue_ttl)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepArgs']]]:
        """
        The operations to be performed on the workspace.
        Structure is documented below.
        """
        return pulumi.get(self, "steps")

    @steps.setter
    def steps(self, value: pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepArgs']]]):
        pulumi.set(self, "steps", value)

    @property
    @pulumi.getter
    def artifacts(self) -> Optional[pulumi.Input['TriggerBuildArtifactsArgs']]:
        """
        Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        Structure is documented below.
        """
        return pulumi.get(self, "artifacts")

    @artifacts.setter
    def artifacts(self, value: Optional[pulumi.Input['TriggerBuildArtifactsArgs']]):
        pulumi.set(self, "artifacts", value)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of images to be pushed upon the successful completion of all build steps.
        The images will be pushed using the builder service account's credentials.
        The digests of the pushed images will be stored in the Build resource's results field.
        If any of the images fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter(name="logsBucket")
    def logs_bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage bucket where logs should be written.
        Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        """
        return pulumi.get(self, "logs_bucket")

    @logs_bucket.setter
    def logs_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logs_bucket", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['TriggerBuildOptionsArgs']]:
        """
        Special options for this build.
        Structure is documented below.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['TriggerBuildOptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="queueTtl")
    def queue_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        TTL in queue for this build. If provided and the build is enqueued longer than this value,
        the build will expire and the build status will be EXPIRED.
        The TTL starts ticking from createTime.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "queue_ttl")

    @queue_ttl.setter
    def queue_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "queue_ttl", value)

    @property
    @pulumi.getter
    def secrets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildSecretArgs']]]]:
        """
        Secrets to decrypt using Cloud Key Management Service.
        Structure is documented below.
        """
        return pulumi.get(self, "secrets")

    @secrets.setter
    def secrets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildSecretArgs']]]]):
        pulumi.set(self, "secrets", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input['TriggerBuildSourceArgs']]:
        """
        The location of the source files to build.
        One of `storageSource` or `repoSource` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input['TriggerBuildSourceArgs']]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def substitutions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Substitutions to use in a triggered build. Should only be used with triggers.run
        """
        return pulumi.get(self, "substitutions")

    @substitutions.setter
    def substitutions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "substitutions", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Tags for annotation of a Build. These are not docker tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Time limit for executing this build step. If not defined,
        the step has no
        time limit and will be allowed to continue to run until either it
        completes or the build itself times out.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class TriggerBuildArtifactsArgs:
    def __init__(__self__, *,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 objects: Optional[pulumi.Input['TriggerBuildArtifactsObjectsArgs']] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] images: A list of images to be pushed upon the successful completion of all build steps.
               The images will be pushed using the builder service account's credentials.
               The digests of the pushed images will be stored in the Build resource's results field.
               If any of the images fail to be pushed, the build is marked FAILURE.
        :param pulumi.Input['TriggerBuildArtifactsObjectsArgs'] objects: A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.
               Files in the workspace matching specified paths globs will be uploaded to the
               Cloud Storage location using the builder service account's credentials.
               The location and generation of the uploaded objects will be stored in the Build resource's results field.
               If any objects fail to be pushed, the build is marked FAILURE.
               Structure is documented below.
        """
        if images is not None:
            pulumi.set(__self__, "images", images)
        if objects is not None:
            pulumi.set(__self__, "objects", objects)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of images to be pushed upon the successful completion of all build steps.
        The images will be pushed using the builder service account's credentials.
        The digests of the pushed images will be stored in the Build resource's results field.
        If any of the images fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter
    def objects(self) -> Optional[pulumi.Input['TriggerBuildArtifactsObjectsArgs']]:
        """
        A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps.
        Files in the workspace matching specified paths globs will be uploaded to the
        Cloud Storage location using the builder service account's credentials.
        The location and generation of the uploaded objects will be stored in the Build resource's results field.
        If any objects fail to be pushed, the build is marked FAILURE.
        Structure is documented below.
        """
        return pulumi.get(self, "objects")

    @objects.setter
    def objects(self, value: Optional[pulumi.Input['TriggerBuildArtifactsObjectsArgs']]):
        pulumi.set(self, "objects", value)


@pulumi.input_type
class TriggerBuildArtifactsObjectsArgs:
    def __init__(__self__, *,
                 location: Optional[pulumi.Input[str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timings: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsObjectsTimingArgs']]]] = None):
        """
        :param pulumi.Input[str] location: Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
               Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
               this location as a prefix.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: Path globs used to match files in the build's workspace.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsObjectsTimingArgs']]] timings: -
               Output only. Stores timing information for pushing all artifact objects.
               Structure is documented below.
        """
        if location is not None:
            pulumi.set(__self__, "location", location)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if timings is not None:
            pulumi.set(__self__, "timings", timings)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/".
        Files in the workspace matching any path pattern will be uploaded to Cloud Storage with
        this location as a prefix.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Path globs used to match files in the build's workspace.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)

    @property
    @pulumi.getter
    def timings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsObjectsTimingArgs']]]]:
        """
        -
        Output only. Stores timing information for pushing all artifact objects.
        Structure is documented below.
        """
        return pulumi.get(self, "timings")

    @timings.setter
    def timings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildArtifactsObjectsTimingArgs']]]]):
        pulumi.set(self, "timings", value)


@pulumi.input_type
class TriggerBuildArtifactsObjectsTimingArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] end_time: End of time span.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
               nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[str] start_time: Start of time span.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
               nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        End of time span.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
        nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Start of time span.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to
        nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class TriggerBuildOptionsArgs:
    def __init__(__self__, *,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 dynamic_substitutions: Optional[pulumi.Input[bool]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_streaming_option: Optional[pulumi.Input[str]] = None,
                 logging: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 requested_verify_option: Optional[pulumi.Input[str]] = None,
                 secret_envs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 source_provenance_hashes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 substitution_option: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildOptionsVolumeArgs']]]] = None,
                 worker_pool: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] disk_size_gb: Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
               some of the space will be used by the operating system and build utilities.
               Also note that this is the minimum disk size that will be allocated for the build --
               the build may run with a larger disk than requested. At present, the maximum disk size
               is 1000GB; builds that request more than the maximum are rejected with an error.
        :param pulumi.Input[bool] dynamic_substitutions: Option to specify whether or not to apply bash style string operations to the substitutions.
               NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] envs: A list of global environment variable definitions that will exist for all build steps
               in this build. If a variable is defined in both globally and in a build step,
               the variable will use the build step value.
               The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param pulumi.Input[str] log_streaming_option: Option to define build log streaming behavior to Google Cloud Storage.
               Possible values are `STREAM_DEFAULT`, `STREAM_ON`, and `STREAM_OFF`.
        :param pulumi.Input[str] logging: Option to specify the logging mode, which determines if and where build logs are stored.
               Possible values are `LOGGING_UNSPECIFIED`, `LEGACY`, `GCS_ONLY`, `STACKDRIVER_ONLY`, and `NONE`.
        :param pulumi.Input[str] machine_type: Compute Engine machine type on which to run the build.
               Possible values are `UNSPECIFIED`, `N1_HIGHCPU_8`, `N1_HIGHCPU_32`, `E2_HIGHCPU_8`, and `E2_HIGHCPU_32`.
        :param pulumi.Input[str] requested_verify_option: Requested verifiability options.
               Possible values are `NOT_VERIFIED` and `VERIFIED`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secret_envs: A list of global environment variables, which are encrypted using a Cloud Key Management
               Service crypto key. These values must be specified in the build's Secret. These variables
               will be available to all build steps in this build.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] source_provenance_hashes: Requested hash for SourceProvenance.
               Each value may be one of `NONE`, `SHA256`, and `MD5`.
        :param pulumi.Input[str] substitution_option: Option to specify behavior when there is an error in the substitution checks.
               NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
               in the build configuration file.
               Possible values are `MUST_MATCH` and `ALLOW_LOOSE`.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildOptionsVolumeArgs']]] volumes: Global list of volumes to mount for ALL build steps
               Each volume is created as an empty volume prior to starting the build process.
               Upon completion of the build, volumes and their contents are discarded. Global
               volume names and paths cannot conflict with the volumes defined a build step.
               Using a global volume in a build with only one step is not valid as it is indicative
               of a build request with an incorrect configuration.
               Structure is documented below.
        :param pulumi.Input[str] worker_pool: Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}
               This field is experimental.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if dynamic_substitutions is not None:
            pulumi.set(__self__, "dynamic_substitutions", dynamic_substitutions)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if log_streaming_option is not None:
            pulumi.set(__self__, "log_streaming_option", log_streaming_option)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if requested_verify_option is not None:
            pulumi.set(__self__, "requested_verify_option", requested_verify_option)
        if secret_envs is not None:
            pulumi.set(__self__, "secret_envs", secret_envs)
        if source_provenance_hashes is not None:
            pulumi.set(__self__, "source_provenance_hashes", source_provenance_hashes)
        if substitution_option is not None:
            pulumi.set(__self__, "substitution_option", substitution_option)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if worker_pool is not None:
            pulumi.set(__self__, "worker_pool", worker_pool)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Requested disk size for the VM that runs the build. Note that this is NOT "disk free";
        some of the space will be used by the operating system and build utilities.
        Also note that this is the minimum disk size that will be allocated for the build --
        the build may run with a larger disk than requested. At present, the maximum disk size
        is 1000GB; builds that request more than the maximum are rejected with an error.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="dynamicSubstitutions")
    def dynamic_substitutions(self) -> Optional[pulumi.Input[bool]]:
        """
        Option to specify whether or not to apply bash style string operations to the substitutions.
        NOTE this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        """
        return pulumi.get(self, "dynamic_substitutions")

    @dynamic_substitutions.setter
    def dynamic_substitutions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dynamic_substitutions", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of global environment variable definitions that will exist for all build steps
        in this build. If a variable is defined in both globally and in a build step,
        the variable will use the build step value.
        The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter(name="logStreamingOption")
    def log_streaming_option(self) -> Optional[pulumi.Input[str]]:
        """
        Option to define build log streaming behavior to Google Cloud Storage.
        Possible values are `STREAM_DEFAULT`, `STREAM_ON`, and `STREAM_OFF`.
        """
        return pulumi.get(self, "log_streaming_option")

    @log_streaming_option.setter
    def log_streaming_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_streaming_option", value)

    @property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input[str]]:
        """
        Option to specify the logging mode, which determines if and where build logs are stored.
        Possible values are `LOGGING_UNSPECIFIED`, `LEGACY`, `GCS_ONLY`, `STACKDRIVER_ONLY`, and `NONE`.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logging", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Compute Engine machine type on which to run the build.
        Possible values are `UNSPECIFIED`, `N1_HIGHCPU_8`, `N1_HIGHCPU_32`, `E2_HIGHCPU_8`, and `E2_HIGHCPU_32`.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="requestedVerifyOption")
    def requested_verify_option(self) -> Optional[pulumi.Input[str]]:
        """
        Requested verifiability options.
        Possible values are `NOT_VERIFIED` and `VERIFIED`.
        """
        return pulumi.get(self, "requested_verify_option")

    @requested_verify_option.setter
    def requested_verify_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "requested_verify_option", value)

    @property
    @pulumi.getter(name="secretEnvs")
    def secret_envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of global environment variables, which are encrypted using a Cloud Key Management
        Service crypto key. These values must be specified in the build's Secret. These variables
        will be available to all build steps in this build.
        """
        return pulumi.get(self, "secret_envs")

    @secret_envs.setter
    def secret_envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "secret_envs", value)

    @property
    @pulumi.getter(name="sourceProvenanceHashes")
    def source_provenance_hashes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Requested hash for SourceProvenance.
        Each value may be one of `NONE`, `SHA256`, and `MD5`.
        """
        return pulumi.get(self, "source_provenance_hashes")

    @source_provenance_hashes.setter
    def source_provenance_hashes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "source_provenance_hashes", value)

    @property
    @pulumi.getter(name="substitutionOption")
    def substitution_option(self) -> Optional[pulumi.Input[str]]:
        """
        Option to specify behavior when there is an error in the substitution checks.
        NOTE this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden
        in the build configuration file.
        Possible values are `MUST_MATCH` and `ALLOW_LOOSE`.
        """
        return pulumi.get(self, "substitution_option")

    @substitution_option.setter
    def substitution_option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "substitution_option", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildOptionsVolumeArgs']]]]:
        """
        Global list of volumes to mount for ALL build steps
        Each volume is created as an empty volume prior to starting the build process.
        Upon completion of the build, volumes and their contents are discarded. Global
        volume names and paths cannot conflict with the volumes defined a build step.
        Using a global volume in a build with only one step is not valid as it is indicative
        of a build request with an incorrect configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildOptionsVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> Optional[pulumi.Input[str]]:
        """
        Option to specify a WorkerPool for the build. Format projects/{project}/workerPools/{workerPool}
        This field is experimental.
        """
        return pulumi.get(self, "worker_pool")

    @worker_pool.setter
    def worker_pool(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "worker_pool", value)


@pulumi.input_type
class TriggerBuildOptionsVolumeArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for Docker volumes.
               Each named volume must be used by at least two build steps.
        :param pulumi.Input[str] path: Path at which to mount the volume.
               Paths must be absolute and cannot conflict with other volume paths on the same
               build step or with certain reserved volume paths.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path at which to mount the volume.
        Paths must be absolute and cannot conflict with other volume paths on the same
        build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class TriggerBuildSecretArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[str],
                 secret_env: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] kms_key_name: Cloud KMS key name to use to decrypt these envs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] secret_env: A list of global environment variables, which are encrypted using a Cloud Key Management
               Service crypto key. These values must be specified in the build's Secret. These variables
               will be available to all build steps in this build.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if secret_env is not None:
            pulumi.set(__self__, "secret_env", secret_env)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[str]:
        """
        Cloud KMS key name to use to decrypt these envs.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A list of global environment variables, which are encrypted using a Cloud Key Management
        Service crypto key. These values must be specified in the build's Secret. These variables
        will be available to all build steps in this build.
        """
        return pulumi.get(self, "secret_env")

    @secret_env.setter
    def secret_env(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "secret_env", value)


@pulumi.input_type
class TriggerBuildSourceArgs:
    def __init__(__self__, *,
                 repo_source: Optional[pulumi.Input['TriggerBuildSourceRepoSourceArgs']] = None,
                 storage_source: Optional[pulumi.Input['TriggerBuildSourceStorageSourceArgs']] = None):
        """
        :param pulumi.Input['TriggerBuildSourceRepoSourceArgs'] repo_source: Location of the source in a Google Cloud Source Repository.
               Structure is documented below.
        :param pulumi.Input['TriggerBuildSourceStorageSourceArgs'] storage_source: Location of the source in an archive file in Google Cloud Storage.
               Structure is documented below.
        """
        if repo_source is not None:
            pulumi.set(__self__, "repo_source", repo_source)
        if storage_source is not None:
            pulumi.set(__self__, "storage_source", storage_source)

    @property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> Optional[pulumi.Input['TriggerBuildSourceRepoSourceArgs']]:
        """
        Location of the source in a Google Cloud Source Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "repo_source")

    @repo_source.setter
    def repo_source(self, value: Optional[pulumi.Input['TriggerBuildSourceRepoSourceArgs']]):
        pulumi.set(self, "repo_source", value)

    @property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> Optional[pulumi.Input['TriggerBuildSourceStorageSourceArgs']]:
        """
        Location of the source in an archive file in Google Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_source")

    @storage_source.setter
    def storage_source(self, value: Optional[pulumi.Input['TriggerBuildSourceStorageSourceArgs']]):
        pulumi.set(self, "storage_source", value)


@pulumi.input_type
class TriggerBuildSourceRepoSourceArgs:
    def __init__(__self__, *,
                 repo_name: pulumi.Input[str],
                 branch_name: Optional[pulumi.Input[str]] = None,
                 commit_sha: Optional[pulumi.Input[str]] = None,
                 dir: Optional[pulumi.Input[str]] = None,
                 invert_regex: Optional[pulumi.Input[bool]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 substitutions: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tag_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] repo_name: Name of the Cloud Source Repository.
        :param pulumi.Input[str] branch_name: Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        :param pulumi.Input[str] commit_sha: Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        :param pulumi.Input[str] dir: Working directory to use when running this step's container.
               If this value is a relative path, it is relative to the build's working
               directory. If this value is absolute, it may be outside the build's working
               directory, in which case the contents of the path may not be persisted
               across build step executions, unless a `volume` for that path is specified.
               If the build specifies a `RepoSource` with `dir` and a step with a
               `dir`,
               which specifies an absolute path, the `RepoSource` `dir` is ignored
               for the step's execution.
        :param pulumi.Input[bool] invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param pulumi.Input[str] project_id: ID of the project that owns the Cloud Source Repository.
               If omitted, the project ID requesting the build is assumed.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] substitutions: Substitutions to use in a triggered build. Should only be used with triggers.run
        :param pulumi.Input[str] tag_name: Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        """
        pulumi.set(__self__, "repo_name", repo_name)
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> pulumi.Input[str]:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "repo_name", value)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[str]]:
        """
        Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[pulumi.Input[str]]:
        """
        Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        """
        return pulumi.get(self, "commit_sha")

    @commit_sha.setter
    def commit_sha(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_sha", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[str]]:
        """
        Working directory to use when running this step's container.
        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a `volume` for that path is specified.
        If the build specifies a `RepoSource` with `dir` and a step with a
        `dir`,
        which specifies an absolute path, the `RepoSource` `dir` is ignored
        for the step's execution.
        """
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[bool]]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_regex", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project that owns the Cloud Source Repository.
        If omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def substitutions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Substitutions to use in a triggered build. Should only be used with triggers.run
        """
        return pulumi.get(self, "substitutions")

    @substitutions.setter
    def substitutions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "substitutions", value)

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[str]]:
        """
        Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_name", value)


@pulumi.input_type
class TriggerBuildSourceStorageSourceArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 object: pulumi.Input[str],
                 generation: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Google Cloud Storage bucket containing the source.
        :param pulumi.Input[str] object: Google Cloud Storage object containing the source.
               This object must be a gzipped archive file (.tar.gz) containing source to build.
        :param pulumi.Input[str] generation: Google Cloud Storage generation for the object.
               If the generation is omitted, the latest generation will be used
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "object", object)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        Google Cloud Storage bucket containing the source.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        Google Cloud Storage object containing the source.
        This object must be a gzipped archive file (.tar.gz) containing source to build.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def generation(self) -> Optional[pulumi.Input[str]]:
        """
        Google Cloud Storage generation for the object.
        If the generation is omitted, the latest generation will be used
        """
        return pulumi.get(self, "generation")

    @generation.setter
    def generation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "generation", value)


@pulumi.input_type
class TriggerBuildStepArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dir: Optional[pulumi.Input[str]] = None,
                 entrypoint: Optional[pulumi.Input[str]] = None,
                 envs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 secret_envs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 timeout: Optional[pulumi.Input[str]] = None,
                 timing: Optional[pulumi.Input[str]] = None,
                 volumes: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepVolumeArgs']]]] = None,
                 wait_fors: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[str] name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for Docker volumes.
               Each named volume must be used by at least two build steps.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: A list of arguments that will be presented to the step when it is started.
               If the image used to run the step's container has an entrypoint, the args
               are used as arguments to that entrypoint. If the image does not define an
               entrypoint, the first element in args is used as the entrypoint, and the
               remainder will be used as arguments.
        :param pulumi.Input[str] dir: Working directory to use when running this step's container.
               If this value is a relative path, it is relative to the build's working
               directory. If this value is absolute, it may be outside the build's working
               directory, in which case the contents of the path may not be persisted
               across build step executions, unless a `volume` for that path is specified.
               If the build specifies a `RepoSource` with `dir` and a step with a
               `dir`,
               which specifies an absolute path, the `RepoSource` `dir` is ignored
               for the step's execution.
        :param pulumi.Input[str] entrypoint: Entrypoint to be used instead of the build step image's
               default entrypoint.
               If unset, the image's default entrypoint is used
        :param pulumi.Input[Sequence[pulumi.Input[str]]] envs: A list of global environment variable definitions that will exist for all build steps
               in this build. If a variable is defined in both globally and in a build step,
               the variable will use the build step value.
               The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param pulumi.Input[str] id: Unique identifier for this build step, used in `wait_for` to
               reference this build step as a dependency.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secret_envs: A list of global environment variables, which are encrypted using a Cloud Key Management
               Service crypto key. These values must be specified in the build's Secret. These variables
               will be available to all build steps in this build.
        :param pulumi.Input[str] timeout: Time limit for executing this build step. If not defined,
               the step has no
               time limit and will be allowed to continue to run until either it
               completes or the build itself times out.
        :param pulumi.Input[str] timing: -
               Output only. Stores timing information for pushing all artifact objects.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepVolumeArgs']]] volumes: Global list of volumes to mount for ALL build steps
               Each volume is created as an empty volume prior to starting the build process.
               Upon completion of the build, volumes and their contents are discarded. Global
               volume names and paths cannot conflict with the volumes defined a build step.
               Using a global volume in a build with only one step is not valid as it is indicative
               of a build request with an incorrect configuration.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wait_fors: The ID(s) of the step(s) that this build step depends on.
               This build step will not start until all the build steps in `wait_for`
               have completed successfully. If `wait_for` is empty, this build step
               will start when all previous build steps in the `Build.Steps` list
               have completed successfully.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if secret_envs is not None:
            pulumi.set(__self__, "secret_envs", secret_envs)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if timing is not None:
            pulumi.set(__self__, "timing", timing)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait_fors is not None:
            pulumi.set(__self__, "wait_fors", wait_fors)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of arguments that will be presented to the step when it is started.
        If the image used to run the step's container has an entrypoint, the args
        are used as arguments to that entrypoint. If the image does not define an
        entrypoint, the first element in args is used as the entrypoint, and the
        remainder will be used as arguments.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[str]]:
        """
        Working directory to use when running this step's container.
        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a `volume` for that path is specified.
        If the build specifies a `RepoSource` with `dir` and a step with a
        `dir`,
        which specifies an absolute path, the `RepoSource` `dir` is ignored
        for the step's execution.
        """
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[pulumi.Input[str]]:
        """
        Entrypoint to be used instead of the build step image's
        default entrypoint.
        If unset, the image's default entrypoint is used
        """
        return pulumi.get(self, "entrypoint")

    @entrypoint.setter
    def entrypoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entrypoint", value)

    @property
    @pulumi.getter
    def envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of global environment variable definitions that will exist for all build steps
        in this build. If a variable is defined in both globally and in a build step,
        the variable will use the build step value.
        The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "envs")

    @envs.setter
    def envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "envs", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique identifier for this build step, used in `wait_for` to
        reference this build step as a dependency.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="secretEnvs")
    def secret_envs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of global environment variables, which are encrypted using a Cloud Key Management
        Service crypto key. These values must be specified in the build's Secret. These variables
        will be available to all build steps in this build.
        """
        return pulumi.get(self, "secret_envs")

    @secret_envs.setter
    def secret_envs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "secret_envs", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[str]]:
        """
        Time limit for executing this build step. If not defined,
        the step has no
        time limit and will be allowed to continue to run until either it
        completes or the build itself times out.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter
    def timing(self) -> Optional[pulumi.Input[str]]:
        """
        -
        Output only. Stores timing information for pushing all artifact objects.
        Structure is documented below.
        """
        return pulumi.get(self, "timing")

    @timing.setter
    def timing(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timing", value)

    @property
    @pulumi.getter
    def volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepVolumeArgs']]]]:
        """
        Global list of volumes to mount for ALL build steps
        Each volume is created as an empty volume prior to starting the build process.
        Upon completion of the build, volumes and their contents are discarded. Global
        volume names and paths cannot conflict with the volumes defined a build step.
        Using a global volume in a build with only one step is not valid as it is indicative
        of a build request with an incorrect configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @volumes.setter
    def volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TriggerBuildStepVolumeArgs']]]]):
        pulumi.set(self, "volumes", value)

    @property
    @pulumi.getter(name="waitFors")
    def wait_fors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID(s) of the step(s) that this build step depends on.
        This build step will not start until all the build steps in `wait_for`
        have completed successfully. If `wait_for` is empty, this build step
        will start when all previous build steps in the `Build.Steps` list
        have completed successfully.
        """
        return pulumi.get(self, "wait_fors")

    @wait_fors.setter
    def wait_fors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "wait_fors", value)


@pulumi.input_type
class TriggerBuildStepVolumeArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 path: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for Docker volumes.
               Each named volume must be used by at least two build steps.
        :param pulumi.Input[str] path: Path at which to mount the volume.
               Paths must be absolute and cannot conflict with other volume paths on the same
               build step or with certain reserved volume paths.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Path at which to mount the volume.
        Paths must be absolute and cannot conflict with other volume paths on the same
        build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class TriggerGithubArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 pull_request: Optional[pulumi.Input['TriggerGithubPullRequestArgs']] = None,
                 push: Optional[pulumi.Input['TriggerGithubPushArgs']] = None):
        """
        :param pulumi.Input[str] name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for Docker volumes.
               Each named volume must be used by at least two build steps.
        :param pulumi.Input[str] owner: Owner of the repository. For example: The owner for
               https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        :param pulumi.Input['TriggerGithubPullRequestArgs'] pull_request: filter to match changes in pull requests.  Specify only one of pullRequest or push.
               Structure is documented below.
        :param pulumi.Input['TriggerGithubPushArgs'] push: filter to match changes in refs, like branches or tags.  Specify only one of pullRequest or push.
               Structure is documented below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for Docker volumes.
        Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Owner of the repository. For example: The owner for
        https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional[pulumi.Input['TriggerGithubPullRequestArgs']]:
        """
        filter to match changes in pull requests.  Specify only one of pullRequest or push.
        Structure is documented below.
        """
        return pulumi.get(self, "pull_request")

    @pull_request.setter
    def pull_request(self, value: Optional[pulumi.Input['TriggerGithubPullRequestArgs']]):
        pulumi.set(self, "pull_request", value)

    @property
    @pulumi.getter
    def push(self) -> Optional[pulumi.Input['TriggerGithubPushArgs']]:
        """
        filter to match changes in refs, like branches or tags.  Specify only one of pullRequest or push.
        Structure is documented below.
        """
        return pulumi.get(self, "push")

    @push.setter
    def push(self, value: Optional[pulumi.Input['TriggerGithubPushArgs']]):
        pulumi.set(self, "push", value)


@pulumi.input_type
class TriggerGithubPullRequestArgs:
    def __init__(__self__, *,
                 branch: pulumi.Input[str],
                 comment_control: Optional[pulumi.Input[str]] = None,
                 invert_regex: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] branch: Regex of branches to match.  Specify only one of branch or tag.
        :param pulumi.Input[str] comment_control: Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator.
               Possible values are `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, and `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        :param pulumi.Input[bool] invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        """
        pulumi.set(__self__, "branch", branch)
        if comment_control is not None:
            pulumi.set(__self__, "comment_control", comment_control)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)

    @property
    @pulumi.getter
    def branch(self) -> pulumi.Input[str]:
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: pulumi.Input[str]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator.
        Possible values are `COMMENTS_DISABLED`, `COMMENTS_ENABLED`, and `COMMENTS_ENABLED_FOR_EXTERNAL_CONTRIBUTORS_ONLY`.
        """
        return pulumi.get(self, "comment_control")

    @comment_control.setter
    def comment_control(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment_control", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[bool]]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_regex", value)


@pulumi.input_type
class TriggerGithubPushArgs:
    def __init__(__self__, *,
                 branch: Optional[pulumi.Input[str]] = None,
                 invert_regex: Optional[pulumi.Input[bool]] = None,
                 tag: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch: Regex of branches to match.  Specify only one of branch or tag.
        :param pulumi.Input[bool] invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param pulumi.Input[str] tag: Regex of tags to match.  Specify only one of branch or tag.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def branch(self) -> Optional[pulumi.Input[str]]:
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "branch")

    @branch.setter
    def branch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[bool]]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_regex", value)

    @property
    @pulumi.getter
    def tag(self) -> Optional[pulumi.Input[str]]:
        """
        Regex of tags to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "tag")

    @tag.setter
    def tag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag", value)


@pulumi.input_type
class TriggerPubsubConfigArgs:
    def __init__(__self__, *,
                 topic: pulumi.Input[str],
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subscription: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] topic: The name of the topic from which this subscription is receiving messages.
        :param pulumi.Input[str] service_account_email: Service account that will make the push request.
        :param pulumi.Input[str] state: -
               Potential issues with the underlying Pub/Sub subscription configuration.
               Only populated on get requests.
        :param pulumi.Input[str] subscription: -
               Output only. Name of the subscription.
        """
        pulumi.set(__self__, "topic", topic)
        if service_account_email is not None:
            pulumi.set(__self__, "service_account_email", service_account_email)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscription is not None:
            pulumi.set(__self__, "subscription", subscription)

    @property
    @pulumi.getter
    def topic(self) -> pulumi.Input[str]:
        """
        The name of the topic from which this subscription is receiving messages.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic", value)

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> Optional[pulumi.Input[str]]:
        """
        Service account that will make the push request.
        """
        return pulumi.get(self, "service_account_email")

    @service_account_email.setter
    def service_account_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account_email", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        -
        Potential issues with the underlying Pub/Sub subscription configuration.
        Only populated on get requests.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def subscription(self) -> Optional[pulumi.Input[str]]:
        """
        -
        Output only. Name of the subscription.
        """
        return pulumi.get(self, "subscription")

    @subscription.setter
    def subscription(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subscription", value)


@pulumi.input_type
class TriggerTriggerTemplateArgs:
    def __init__(__self__, *,
                 branch_name: Optional[pulumi.Input[str]] = None,
                 commit_sha: Optional[pulumi.Input[str]] = None,
                 dir: Optional[pulumi.Input[str]] = None,
                 invert_regex: Optional[pulumi.Input[bool]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 repo_name: Optional[pulumi.Input[str]] = None,
                 tag_name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] branch_name: Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        :param pulumi.Input[str] commit_sha: Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        :param pulumi.Input[str] dir: Working directory to use when running this step's container.
               If this value is a relative path, it is relative to the build's working
               directory. If this value is absolute, it may be outside the build's working
               directory, in which case the contents of the path may not be persisted
               across build step executions, unless a `volume` for that path is specified.
               If the build specifies a `RepoSource` with `dir` and a step with a
               `dir`,
               which specifies an absolute path, the `RepoSource` `dir` is ignored
               for the step's execution.
        :param pulumi.Input[bool] invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param pulumi.Input[str] project_id: ID of the project that owns the Cloud Source Repository.
               If omitted, the project ID requesting the build is assumed.
        :param pulumi.Input[str] repo_name: Name of the Cloud Source Repository.
        :param pulumi.Input[str] tag_name: Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[pulumi.Input[str]]:
        """
        Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch_name")

    @branch_name.setter
    def branch_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "branch_name", value)

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[pulumi.Input[str]]:
        """
        Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        """
        return pulumi.get(self, "commit_sha")

    @commit_sha.setter
    def commit_sha(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "commit_sha", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[str]]:
        """
        Working directory to use when running this step's container.
        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a `volume` for that path is specified.
        If the build specifies a `RepoSource` with `dir` and a step with a
        `dir`,
        which specifies an absolute path, the `RepoSource` `dir` is ignored
        for the step's execution.
        """
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[pulumi.Input[bool]]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @invert_regex.setter
    def invert_regex(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "invert_regex", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project that owns the Cloud Source Repository.
        If omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_name", value)

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[pulumi.Input[str]]:
        """
        Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag_name")

    @tag_name.setter
    def tag_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tag_name", value)


@pulumi.input_type
class TriggerWebhookConfigArgs:
    def __init__(__self__, *,
                 secret: pulumi.Input[str],
                 state: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] secret: Secrets to decrypt using Cloud Key Management Service.
               Structure is documented below.
        :param pulumi.Input[str] state: -
               Potential issues with the underlying Pub/Sub subscription configuration.
               Only populated on get requests.
        """
        pulumi.set(__self__, "secret", secret)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def secret(self) -> pulumi.Input[str]:
        """
        Secrets to decrypt using Cloud Key Management Service.
        Structure is documented below.
        """
        return pulumi.get(self, "secret")

    @secret.setter
    def secret(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        -
        Potential issues with the underlying Pub/Sub subscription configuration.
        Only populated on get requests.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class WorkerPoolNetworkConfigArgs:
    def __init__(__self__, *,
                 peered_network: pulumi.Input[str]):
        """
        :param pulumi.Input[str] peered_network: Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See (https://cloud.google.com/cloud-build/docs/custom-workers/set-up-custom-worker-pool-environment#understanding_the_network_configuration_options)
        """
        pulumi.set(__self__, "peered_network", peered_network)

    @property
    @pulumi.getter(name="peeredNetwork")
    def peered_network(self) -> pulumi.Input[str]:
        """
        Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See (https://cloud.google.com/cloud-build/docs/custom-workers/set-up-custom-worker-pool-environment#understanding_the_network_configuration_options)
        """
        return pulumi.get(self, "peered_network")

    @peered_network.setter
    def peered_network(self, value: pulumi.Input[str]):
        pulumi.set(self, "peered_network", value)


@pulumi.input_type
class WorkerPoolWorkerConfigArgs:
    def __init__(__self__, *,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 no_external_ip: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[int] disk_size_gb: Size of the disk attached to the worker, in GB. See (https://cloud.google.com/cloud-build/docs/custom-workers/worker-pool-config-file). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
        :param pulumi.Input[str] machine_type: Machine type of a worker, such as `n1-standard-1`. See (https://cloud.google.com/cloud-build/docs/custom-workers/worker-pool-config-file). If left blank, Cloud Build will use `n1-standard-1`.
        :param pulumi.Input[bool] no_external_ip: If true, workers are created without any public address, which prevents network egress to public IPs.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if no_external_ip is not None:
            pulumi.set(__self__, "no_external_ip", no_external_ip)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Size of the disk attached to the worker, in GB. See (https://cloud.google.com/cloud-build/docs/custom-workers/worker-pool-config-file). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Machine type of a worker, such as `n1-standard-1`. See (https://cloud.google.com/cloud-build/docs/custom-workers/worker-pool-config-file). If left blank, Cloud Build will use `n1-standard-1`.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="noExternalIp")
    def no_external_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, workers are created without any public address, which prevents network egress to public IPs.
        """
        return pulumi.get(self, "no_external_ip")

    @no_external_ip.setter
    def no_external_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_external_ip", value)


