import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * (experimental) Statement provider for service [elemental-activations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elementalactivations.html).
 *
 * @experimental
 */
export declare class ElementalActivations extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [elemental-activations](https://docs.aws.amazon.com/service-authorization/latest/reference/list_elementalactivations.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Download the Software files for AWS Elemental Appliances and Software Purchases.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toDownloadSoftware(): this;
    /**
     * (experimental) Generate Software Licenses for AWS Elemental Appliances and Software Purchases.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toGenerateLicenses(): this;
    /**
     * (experimental) Describe an activation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toGetActivation(): this;
    /**
     * (experimental) This action lists tags for an AWS Elemental Activations resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) This action adds a tag for an AWS Elemental Activations resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) This action removes a tag from an AWS Elemental Activations resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type activation to the statement.
     *
     * https://docs.aws.amazon.com/elemental-appliances-software/
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onActivation(resourceId: string, account?: string, region?: string, partition?: string): this;
}
