"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mechanicalturk = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
 *
 * @experimental
 */
class Mechanicalturk extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'mechanicalturk';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AcceptQualificationRequest",
                "ApproveAssignment",
                "AssociateQualificationWithWorker",
                "CreateAdditionalAssignmentsForHIT",
                "CreateHIT",
                "CreateHITType",
                "CreateHITWithHITType",
                "CreateQualificationType",
                "CreateWorkerBlock",
                "DeleteHIT",
                "DeleteQualificationType",
                "DeleteWorkerBlock",
                "DisassociateQualificationFromWorker",
                "NotifyWorkers",
                "RejectAssignment",
                "RejectQualificationRequest",
                "SendBonus",
                "SendTestEventNotification",
                "UpdateExpirationForHIT",
                "UpdateHITReviewStatus",
                "UpdateHITTypeOfHIT",
                "UpdateNotificationSettings",
                "UpdateQualificationType"
            ],
            "Read": [
                "GetAccountBalance",
                "GetAssignment",
                "GetFileUploadURL",
                "GetHIT",
                "GetQualificationScore",
                "GetQualificationType"
            ],
            "List": [
                "ListAssignmentsForHIT",
                "ListBonusPayments",
                "ListHITs",
                "ListHITsForQualificationType",
                "ListQualificationRequests",
                "ListQualificationTypes",
                "ListReviewPolicyResultsForHIT",
                "ListReviewableHITs",
                "ListWorkerBlocks",
                "ListWorkersWithQualificationType"
            ]
        };
    }
    /**
     * (experimental) The AcceptQualificationRequest operation grants a Worker's request for a Qualification.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AcceptQualificationRequestOperation.html
     *
     * @experimental
     */
    toAcceptQualificationRequest() {
        this.to('mechanicalturk:AcceptQualificationRequest');
        return this;
    }
    /**
     * (experimental) The ApproveAssignment operation approves the results of a completed assignment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveAssignmentOperation.html
     *
     * @experimental
     */
    toApproveAssignment() {
        this.to('mechanicalturk:ApproveAssignment');
        return this;
    }
    /**
     * (experimental) The AssociateQualificationWithWorker operation gives a Worker a Qualification.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AssociateQualificationWithWorkerOperation.html
     *
     * @experimental
     */
    toAssociateQualificationWithWorker() {
        this.to('mechanicalturk:AssociateQualificationWithWorker');
        return this;
    }
    /**
     * (experimental) The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateAdditionalAssignmentsForHITOperation.html
     *
     * @experimental
     */
    toCreateAdditionalAssignmentsForHIT() {
        this.to('mechanicalturk:CreateAdditionalAssignmentsForHIT');
        return this;
    }
    /**
     * (experimental) The CreateHIT operation creates a new HIT (Human Intelligence Task).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITOperation.html
     *
     * @experimental
     */
    toCreateHIT() {
        this.to('mechanicalturk:CreateHIT');
        return this;
    }
    /**
     * (experimental) The CreateHITType operation creates a new HIT type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITTypeOperation.html
     *
     * @experimental
     */
    toCreateHITType() {
        this.to('mechanicalturk:CreateHITType');
        return this;
    }
    /**
     * (experimental) The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITWithHITTypeOperation.html
     *
     * @experimental
     */
    toCreateHITWithHITType() {
        this.to('mechanicalturk:CreateHITWithHITType');
        return this;
    }
    /**
     * (experimental) The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateQualificationTypeOperation.html
     *
     * @experimental
     */
    toCreateQualificationType() {
        this.to('mechanicalturk:CreateQualificationType');
        return this;
    }
    /**
     * (experimental) The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateWorkerBlockOperation.html
     *
     * @experimental
     */
    toCreateWorkerBlock() {
        this.to('mechanicalturk:CreateWorkerBlock');
        return this;
    }
    /**
     * (experimental) The DeleteHIT operation disposes of a HIT that is no longer needed.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteHITOperation.html
     *
     * @experimental
     */
    toDeleteHIT() {
        this.to('mechanicalturk:DeleteHIT');
        return this;
    }
    /**
     * (experimental) The DeleteQualificationType disposes a Qualification type and disposes any HIT types that are associated with the Qualification type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteQualificationTypeOperation.html
     *
     * @experimental
     */
    toDeleteQualificationType() {
        this.to('mechanicalturk:DeleteQualificationType');
        return this;
    }
    /**
     * (experimental) The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteWorkerBlockOperation.html
     *
     * @experimental
     */
    toDeleteWorkerBlock() {
        this.to('mechanicalturk:DeleteWorkerBlock');
        return this;
    }
    /**
     * (experimental) The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DisassociateQualificationFromWorkerOperation.html
     *
     * @experimental
     */
    toDisassociateQualificationFromWorker() {
        this.to('mechanicalturk:DisassociateQualificationFromWorker');
        return this;
    }
    /**
     * (experimental) The GetAccountBalance operation retrieves the amount of money in your Amazon Mechanical Turk account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAccountBalanceOperation.html
     *
     * @experimental
     */
    toGetAccountBalance() {
        this.to('mechanicalturk:GetAccountBalance');
        return this;
    }
    /**
     * (experimental) The GetAssignment retrieves an assignment with an AssignmentStatus value of Submitted, Approved, or Rejected, using the assignment's ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAssignmentOperation.html
     *
     * @experimental
     */
    toGetAssignment() {
        this.to('mechanicalturk:GetAssignment');
        return this;
    }
    /**
     * (experimental) The GetFileUploadURL operation generates and returns a temporary URL.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetFileUploadURLOperation.html
     *
     * @experimental
     */
    toGetFileUploadURL() {
        this.to('mechanicalturk:GetFileUploadURL');
        return this;
    }
    /**
     * (experimental) The GetHIT operation retrieves the details of the specified HIT.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetHITOperation.html
     *
     * @experimental
     */
    toGetHIT() {
        this.to('mechanicalturk:GetHIT');
        return this;
    }
    /**
     * (experimental) The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationScoreOperation.html
     *
     * @experimental
     */
    toGetQualificationScore() {
        this.to('mechanicalturk:GetQualificationScore');
        return this;
    }
    /**
     * (experimental) The GetQualificationType operation retrieves information about a Qualification type using its ID.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html
     *
     * @experimental
     */
    toGetQualificationType() {
        this.to('mechanicalturk:GetQualificationType');
        return this;
    }
    /**
     * (experimental) The ListAssignmentsForHIT operation retrieves completed assignments for a HIT.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListAssignmentsForHITOperation.html
     *
     * @experimental
     */
    toListAssignmentsForHIT() {
        this.to('mechanicalturk:ListAssignmentsForHIT');
        return this;
    }
    /**
     * (experimental) The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListBonusPaymentsOperation.html
     *
     * @experimental
     */
    toListBonusPayments() {
        this.to('mechanicalturk:ListBonusPayments');
        return this;
    }
    /**
     * (experimental) The ListHITs operation returns all of a Requester's HITs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsOperation.html
     *
     * @experimental
     */
    toListHITs() {
        this.to('mechanicalturk:ListHITs');
        return this;
    }
    /**
     * (experimental) The ListHITsForQualificationType operation returns the HITs that use the given QualififcationType for a QualificationRequirement.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsForQualificationTypeOperation.html
     *
     * @experimental
     */
    toListHITsForQualificationType() {
        this.to('mechanicalturk:ListHITsForQualificationType');
        return this;
    }
    /**
     * (experimental) The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationRequestsOperation.html
     *
     * @experimental
     */
    toListQualificationRequests() {
        this.to('mechanicalturk:ListQualificationRequests');
        return this;
    }
    /**
     * (experimental) The ListQualificationTypes operation searches for Qualification types using the specified search query, and returns a list of Qualification types.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationTypesOperation.html
     *
     * @experimental
     */
    toListQualificationTypes() {
        this.to('mechanicalturk:ListQualificationTypes');
        return this;
    }
    /**
     * (experimental) The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies during a CreateHIT operation.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewPolicyResultsForHITOperation.html
     *
     * @experimental
     */
    toListReviewPolicyResultsForHIT() {
        this.to('mechanicalturk:ListReviewPolicyResultsForHIT');
        return this;
    }
    /**
     * (experimental) The ListReviewableHITs operation returns all of a Requester's HITs that have not been approved or rejected.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewableHITsOperation.html
     *
     * @experimental
     */
    toListReviewableHITs() {
        this.to('mechanicalturk:ListReviewableHITs');
        return this;
    }
    /**
     * (experimental) The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkerBlocksOperation.html
     *
     * @experimental
     */
    toListWorkerBlocks() {
        this.to('mechanicalturk:ListWorkerBlocks');
        return this;
    }
    /**
     * (experimental) The ListWorkersWithQualificationType operation returns all of the Workers with a given Qualification type.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkersWithQualificationTypeOperation.html
     *
     * @experimental
     */
    toListWorkersWithQualificationType() {
        this.to('mechanicalturk:ListWorkersWithQualificationType');
        return this;
    }
    /**
     * (experimental) The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_NotifyWorkersOperation.html
     *
     * @experimental
     */
    toNotifyWorkers() {
        this.to('mechanicalturk:NotifyWorkers');
        return this;
    }
    /**
     * (experimental) The RejectAssignment operation rejects the results of a completed assignment.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectAssignmentOperation.html
     *
     * @experimental
     */
    toRejectAssignment() {
        this.to('mechanicalturk:RejectAssignment');
        return this;
    }
    /**
     * (experimental) The RejectQualificationRequest operation rejects a user's request for a Qualification.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectQualificationRequestOperation.html
     *
     * @experimental
     */
    toRejectQualificationRequest() {
        this.to('mechanicalturk:RejectQualificationRequest');
        return this;
    }
    /**
     * (experimental) The SendBonus operation issues a payment of money from your account to a Worker.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendBonusOperation.html
     *
     * @experimental
     */
    toSendBonus() {
        this.to('mechanicalturk:SendBonus');
        return this;
    }
    /**
     * (experimental) The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendTestEventNotificationOperation.html
     *
     * @experimental
     */
    toSendTestEventNotification() {
        this.to('mechanicalturk:SendTestEventNotification');
        return this;
    }
    /**
     * (experimental) The UpdateExpirationForHIT operation allows you extend the expiration time of a HIT beyond is current expiration or expire a HIT immediately.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateExpirationForHITOperation.html
     *
     * @experimental
     */
    toUpdateExpirationForHIT() {
        this.to('mechanicalturk:UpdateExpirationForHIT');
        return this;
    }
    /**
     * (experimental) The UpdateHITReviewStatus operation toggles the status of a HIT.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITReviewStatusOperation.html
     *
     * @experimental
     */
    toUpdateHITReviewStatus() {
        this.to('mechanicalturk:UpdateHITReviewStatus');
        return this;
    }
    /**
     * (experimental) The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITTypeOfHITOperation.html
     *
     * @experimental
     */
    toUpdateHITTypeOfHIT() {
        this.to('mechanicalturk:UpdateHITTypeOfHIT');
        return this;
    }
    /**
     * (experimental) The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateNotificationSettingsOperation.html
     *
     * @experimental
     */
    toUpdateNotificationSettings() {
        this.to('mechanicalturk:UpdateNotificationSettings');
        return this;
    }
    /**
     * (experimental) The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateQualificationTypeOperation.html
     *
     * @experimental
     */
    toUpdateQualificationType() {
        this.to('mechanicalturk:UpdateQualificationType');
        return this;
    }
}
exports.Mechanicalturk = Mechanicalturk;
//# sourceMappingURL=data:application/json;base64,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