"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2messages = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [ec2messages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html).
 *
 * @experimental
 */
class Ec2messages extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [ec2messages](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmessagedeliveryservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'ec2messages';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Write": [
                "AcknowledgeMessage",
                "DeleteMessage",
                "FailMessage",
                "SendReply"
            ],
            "Read": [
                "GetEndpoint",
                "GetMessages"
            ]
        };
    }
    /**
     * (experimental) Acknowledges a message, ensuring it will not be delivered again.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toAcknowledgeMessage() {
        this.to('ec2messages:AcknowledgeMessage');
        return this;
    }
    /**
     * (experimental) Deletes a message.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toDeleteMessage() {
        this.to('ec2messages:DeleteMessage');
        return this;
    }
    /**
     * (experimental) Fails a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toFailMessage() {
        this.to('ec2messages:FailMessage');
        return this;
    }
    /**
     * (experimental) Routes traffic to the correct endpoint based on the given destination for the messages.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetEndpoint() {
        this.to('ec2messages:GetEndpoint');
        return this;
    }
    /**
     * (experimental) Delivers messages to clients/instances using long polling.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetMessages() {
        this.to('ec2messages:GetMessages');
        return this;
    }
    /**
     * (experimental) Sends replies from clients/instances to upstream service.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toSendReply() {
        this.to('ec2messages:SendReply');
        return this;
    }
}
exports.Ec2messages = Ec2messages;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWVzc2FnZWRlbGl2ZXJ5c2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm1lc3NhZ2VkZWxpdmVyeXNlcnZpY2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0Esc0NBQTRDOzs7Ozs7QUFPNUMsTUFBYSxXQUFZLFNBQVEsd0JBQWU7Ozs7Ozs7SUFROUMsWUFBYSxHQUFZO1FBQ3ZCLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQzs7Ozs7O1FBUk4sa0JBQWEsR0FBRyxhQUFhLENBQUM7Ozs7UUF1RTNCLG9CQUFlLEdBQW9CO1lBQzNDLE9BQU8sRUFBRTtnQkFDUCxvQkFBb0I7Z0JBQ3BCLGVBQWU7Z0JBQ2YsYUFBYTtnQkFDYixXQUFXO2FBQ1o7WUFDRCxNQUFNLEVBQUU7Z0JBQ04sYUFBYTtnQkFDYixhQUFhO2FBQ2Q7U0FDRixDQUFDO0lBekVGLENBQUM7Ozs7Ozs7O0lBT00sb0JBQW9CO1FBQ3pCLElBQUksQ0FBQyxFQUFFLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUMxQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7O0lBT00sZUFBZTtRQUNwQixJQUFJLENBQUMsRUFBRSxDQUFDLDJCQUEyQixDQUFDLENBQUM7UUFDckMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7OztJQU9NLGFBQWE7UUFDbEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyx5QkFBeUIsQ0FBQyxDQUFDO1FBQ25DLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQzs7Ozs7Ozs7SUFPTSxhQUFhO1FBQ2xCLElBQUksQ0FBQyxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQztRQUNuQyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7O0lBT00sYUFBYTtRQUNsQixJQUFJLENBQUMsRUFBRSxDQUFDLHlCQUF5QixDQUFDLENBQUM7UUFDbkMsT0FBTyxJQUFJLENBQUM7SUFDZCxDQUFDOzs7Ozs7OztJQU9NLFdBQVc7UUFDaEIsSUFBSSxDQUFDLEVBQUUsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO1FBQ2pDLE9BQU8sSUFBSSxDQUFDO0lBQ2QsQ0FBQztDQWNGO0FBcEZELGtDQW9GQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFjY2Vzc0xldmVsTGlzdCB9IGZyb20gXCIuLi9zaGFyZWQvYWNjZXNzLWxldmVsXCI7XG5pbXBvcnQgeyBQb2xpY3lTdGF0ZW1lbnQgfSBmcm9tIFwiLi4vc2hhcmVkXCI7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgRWMybWVzc2FnZXMgZXh0ZW5kcyBQb2xpY3lTdGF0ZW1lbnQge1xuICBwdWJsaWMgc2VydmljZVByZWZpeCA9ICdlYzJtZXNzYWdlcyc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBjb25zdHJ1Y3RvciAoc2lkPzogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2lkKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9BY2tub3dsZWRnZU1lc3NhZ2UoKSB7XG4gICAgdGhpcy50bygnZWMybWVzc2FnZXM6QWNrbm93bGVkZ2VNZXNzYWdlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9EZWxldGVNZXNzYWdlKCkge1xuICAgIHRoaXMudG8oJ2VjMm1lc3NhZ2VzOkRlbGV0ZU1lc3NhZ2UnKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0ZhaWxNZXNzYWdlKCkge1xuICAgIHRoaXMudG8oJ2VjMm1lc3NhZ2VzOkZhaWxNZXNzYWdlJyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyB0b0dldEVuZHBvaW50KCkge1xuICAgIHRoaXMudG8oJ2VjMm1lc3NhZ2VzOkdldEVuZHBvaW50Jyk7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgdG9HZXRNZXNzYWdlcygpIHtcbiAgICB0aGlzLnRvKCdlYzJtZXNzYWdlczpHZXRNZXNzYWdlcycpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHRvU2VuZFJlcGx5KCkge1xuICAgIHRoaXMudG8oJ2VjMm1lc3NhZ2VzOlNlbmRSZXBseScpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFjY2Vzc0xldmVsTGlzdDogQWNjZXNzTGV2ZWxMaXN0ID0ge1xuICAgIFwiV3JpdGVcIjogW1xuICAgICAgXCJBY2tub3dsZWRnZU1lc3NhZ2VcIixcbiAgICAgIFwiRGVsZXRlTWVzc2FnZVwiLFxuICAgICAgXCJGYWlsTWVzc2FnZVwiLFxuICAgICAgXCJTZW5kUmVwbHlcIlxuICAgIF0sXG4gICAgXCJSZWFkXCI6IFtcbiAgICAgIFwiR2V0RW5kcG9pbnRcIixcbiAgICAgIFwiR2V0TWVzc2FnZXNcIlxuICAgIF1cbiAgfTtcbn1cbiJdfQ==