"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Textract = void 0;
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [textract](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontextract.html).
 *
 * @experimental
 */
class Textract extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [textract](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazontextract.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'textract';
        /**
         * @experimental
         */
        this.accessLevelList = {
            "Read": [
                "AnalyzeDocument",
                "DetectDocumentText",
                "GetDocumentAnalysis",
                "GetDocumentTextDetection"
            ],
            "Write": [
                "StartDocumentAnalysis",
                "StartDocumentTextDetection"
            ]
        };
    }
    /**
     * (experimental) Detects instances of real-world document entities within an image provided as input.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_AnalyzeDocument.html
     *
     * @experimental
     */
    toAnalyzeDocument() {
        this.to('textract:AnalyzeDocument');
        return this;
    }
    /**
     * (experimental) Detects text in document images.
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_DetectDocumentText.html
     *
     * @experimental
     */
    toDetectDocumentText() {
        this.to('textract:DetectDocumentText');
        return this;
    }
    /**
     * (experimental) Returns information about a document analysis job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentAnalysis.html
     *
     * @experimental
     */
    toGetDocumentAnalysis() {
        this.to('textract:GetDocumentAnalysis');
        return this;
    }
    /**
     * (experimental) Returns information about a document text detection job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_GetDocumentTextDetection.html
     *
     * @experimental
     */
    toGetDocumentTextDetection() {
        this.to('textract:GetDocumentTextDetection');
        return this;
    }
    /**
     * (experimental) Starts an asynchronous job to detect instances of real-world document entities within an image or pdf provided as input.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentAnalysis.html
     *
     * @experimental
     */
    toStartDocumentAnalysis() {
        this.to('textract:StartDocumentAnalysis');
        return this;
    }
    /**
     * (experimental) Starts an asynchronous job to detect text in document images or pdfs.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - s3:GetObject
     *
     * https://docs.aws.amazon.com/textract/latest/dg/API_StartDocumentTextDetection.html
     *
     * @experimental
     */
    toStartDocumentTextDetection() {
        this.to('textract:StartDocumentTextDetection');
        return this;
    }
}
exports.Textract = Textract;
//# sourceMappingURL=data:application/json;base64,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