"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Operator = void 0;
/**
 * (experimental) Use condition operators in the `Condition` element to match the condition key and value in the policy against values in the request context.
 *
 * For more information about the `Condition` element, see [IAM JSON Policy Elements: Condition](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
 *
 * The condition operator that you can use in a policy depends on the condition key you choose. You can choose a global condition key or a service-specific condition key. To learn which condition operator you can use for a global condition key, see [AWS Global Condition Context Keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html). To learn which condition operator you can use for a service-specific condition key, see [Actions, Resources, and Condition Keys for AWS Services](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_actions-resources-contextkeys.html) and choose the service that you want to view.
 *
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html
 *
 * @experimental
 */
class Operator {
    constructor() {
        this.base = '';
        this.hasIfExists = false;
        this.hasForAllValues = false;
        this.hasForAnyValue = false;
    }
    setBase(base) {
        if (this.base.length) {
            throw new Error(`Operator already set: ${this.base}`);
        }
        this.base = base;
        return this;
    }
    /**
     * @experimental
     */
    toString() {
        let value = this.base;
        if (this.base.length == 0) {
            throw new Error('No operator set');
        }
        if (this.hasIfExists) {
            value += 'IfExists';
        }
        if (this.hasForAllValues) {
            value = `ForAllValues:${value}`;
        }
        if (this.hasForAnyValue) {
            value = `ForAnyValue:${value}`;
        }
        if (this.base == 'Null' && value != this.base) {
            throw new Error(`You cannot add modifiers to the "Null" operator: ${value}`);
        }
        return value;
    }
    /**
     * (experimental) You can add `IfExists` to the end of any condition operator name except the `Null` condition.
     *
     * For example, `StringLikeIfExists`. You do this to say "If the policy key is present in the context of the request, process the key as specified in the policy. If the key is not present, evaluate the condition element as true." Other condition elements in the statement can still result in a nonmatch, but not a missing key when checked with `...IfExists`.
     *
     * @experimental
     */
    ifExists() {
        this.hasIfExists = true;
        return this;
    }
    /**
     * (experimental) Tests whether the value of every member of the request set is a subset of the condition key set.
     *
     * The condition returns true if every key value in the request matches at least one value in the policy. It also returns true if there are no keys in the request, or if the key values resolve to a null data set, such as an empty string.
     *
     * @experimental
     */
    forAllValues() {
        this.hasForAllValues = true;
        return this;
    }
    /**
     * (experimental) Tests whether at least one member of the set of request values matches at least one member of the set of condition key values.
     *
     * The condition returns true if any one of the key values in the request matches any one of the condition values in the policy. For no matching key or a null dataset, the condition returns false.
     *
     * @experimental
     */
    forAnyValue() {
        this.hasForAnyValue = true;
        return this;
    }
    /**
     * (experimental) Exact match, case sensitive.
     *
     * @experimental
     */
    stringEquals() {
        return this.setBase('StringEquals');
    }
    /**
     * (experimental) Negated exact match, case sensitive.
     *
     * @experimental
     */
    stringNotEquals() {
        return this.setBase('StringNotEquals');
    }
    /**
     * (experimental) Exact match, ignore case.
     *
     * @experimental
     */
    stringEqualsIgnoreCase() {
        return this.setBase('StringEqualsIgnoreCase');
    }
    /**
     * (experimental) Exact exact match, ignore case.
     *
     * @experimental
     */
    stringNotEqualsIgnoreCase() {
        return this.setBase('StringNotEqualsIgnoreCase');
    }
    /**
     * (experimental) Case-sensitive match.
     *
     * The values can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`) anywhere in the string.
     *
     * @experimental
     */
    stringLike() {
        return this.setBase('StringLike');
    }
    /**
     * (experimental) Negated case-sensitive matching.
     *
     * The values can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`) anywhere in the string.
     *
     * @experimental
     */
    stringNotLike() {
        return this.setBase('StringNotLike');
    }
    /**
     * (experimental) Exact match.
     *
     * @experimental
     */
    numericEquals() {
        return this.setBase('NumericEquals');
    }
    /**
     * (experimental) Negated exact match.
     *
     * @experimental
     */
    numericNotEquals() {
        return this.setBase('NumericNotEquals');
    }
    /**
     * (experimental) Match numbers lower than value: `<`.
     *
     * @experimental
     */
    numericLessThan() {
        return this.setBase('NumericLessThan');
    }
    /**
     * (experimental) Match numbers lower or equal to value: `<=`.
     *
     * @experimental
     */
    numericLessThanEquals() {
        return this.setBase('NumericLessThanEquals');
    }
    /**
     * (experimental) Match numbers higher than value: `>`.
     *
     * @experimental
     */
    numericGreaterThan() {
        return this.setBase('NumericGreaterThan');
    }
    /**
     * (experimental) Match numbers higher or equal value: `>=`.
     *
     * @experimental
     */
    numericGreaterThanEquals() {
        return this.setBase('NumericGreaterThanEquals');
    }
    /**
     * (experimental) Match a specific date: `=`.
     *
     * @experimental
     */
    dateEquals() {
        return this.setBase('DateEquals');
    }
    /**
     * (experimental) Negated match for a specific date: `!=`.
     *
     * @experimental
     */
    dateNotEquals() {
        return this.setBase('DateNotEquals');
    }
    /**
     * (experimental) Match before a specific date and time: `<`.
     *
     * @experimental
     */
    dateLessThan() {
        return this.setBase('DateLessThan');
    }
    /**
     * (experimental) Match at or before a specific date and time: `<=`.
     *
     * @experimental
     */
    dateLessThanEquals() {
        return this.setBase('DateLessThanEquals');
    }
    /**
     * (experimental) Match after a specific a date and time: `>`.
     *
     * @experimental
     */
    dateGreaterThan() {
        return this.setBase('DateGreaterThan');
    }
    /**
     * (experimental) Match at or after a specific date and time: `>=`.
     *
     * @experimental
     */
    dateGreaterThanEquals() {
        return this.setBase('DateGreaterThanEquals');
    }
    /**
     * (experimental) Boolean match.
     *
     * @experimental
     */
    bool() {
        return this.setBase('Bool');
    }
    /**
     * (experimental) The BinaryEquals condition operator lets you construct Condition elements that test key values that are in binary format.
     *
     * It compares the value of the specified key byte for byte against a [base-64](https://en.wikipedia.org/wiki/Base64) encoded representation of the binary value in the policy.
     *
     * @experimental
     */
    binaryEquals() {
        return this.setBase('BinaryEquals');
    }
    /**
     * (experimental) Match an IP address or range: `=`.
     *
     * @experimental
     */
    ipAddress() {
        return this.setBase('IpAddress');
    }
    /**
     * (experimental) All IP addresses except the specified IP address or range `!=`.
     *
     * @experimental
     */
    notIpAddress() {
        return this.setBase('NotIpAddress');
    }
    /**
     * (experimental) Match of the ARN, case sensitive.
     *
     * Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`).
     *
     * `ArnEquals` and `ArnLike` behave identical.
     *
     * @experimental
     */
    arnEquals() {
        return this.setBase('ArnEquals');
    }
    /**
     * (experimental) Negated match of the ARN, case sensitive.
     *
     * Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`).
     *
     * `ArnNotEquals` and `ArnNotLike` behave identical.
     *
     * @experimental
     */
    arnNotEquals() {
        return this.setBase('ArnNotEquals');
    }
    /**
     * (experimental) Match of the ARN, case sensitive.
     *
     * Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`).
     *
     * @experimental
     */
    arnLike() {
        return this.setBase('ArnLike');
    }
    /**
     * (experimental) Negated match of the ARN, case sensitive.
     *
     * Each of the six colon-delimited components of the ARN is checked separately and each can include a multi-character match wildcard (`*`) or a single-character match wildcard (`?`).
     *
     * `ArnNotEquals` and `ArnNotLike` behave identical.
     *
     * @experimental
     */
    arnNotLike() {
        return this.setBase('ArnNotLike');
    }
    /**
     * (experimental) Check if a key is present at the time of authorization.
     *
     * In the policy statement, use either true (the key doesn't exist — it is null) or false (the key exists and its value is not null).
     *
     * @experimental
     */
    null() {
        return this.setBase('Null');
    }
}
exports.Operator = Operator;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3BlcmF0b3JzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsib3BlcmF0b3JzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7O0FBT0EsTUFBYSxRQUFRO0lBQXJCO1FBQ1UsU0FBSSxHQUFHLEVBQUUsQ0FBQztRQUNWLGdCQUFXLEdBQUcsS0FBSyxDQUFDO1FBQ3BCLG9CQUFlLEdBQUcsS0FBSyxDQUFDO1FBQ3hCLG1CQUFjLEdBQUcsS0FBSyxDQUFDO0lBdVFqQyxDQUFDO0lBclFTLE9BQU8sQ0FBQyxJQUFZO1FBQzFCLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUU7WUFDcEIsTUFBTSxJQUFJLEtBQUssQ0FBQyx5QkFBeUIsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDLENBQUM7U0FDdkQ7UUFDRCxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztRQUNqQixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7SUFFTSxRQUFRO1FBQ2IsSUFBSSxLQUFLLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQztRQUV0QixJQUFJLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxJQUFJLENBQUMsRUFBRTtZQUN6QixNQUFNLElBQUksS0FBSyxDQUFDLGlCQUFpQixDQUFDLENBQUM7U0FDcEM7UUFDRCxJQUFJLElBQUksQ0FBQyxXQUFXLEVBQUU7WUFDcEIsS0FBSyxJQUFJLFVBQVUsQ0FBQztTQUNyQjtRQUNELElBQUksSUFBSSxDQUFDLGVBQWUsRUFBRTtZQUN4QixLQUFLLEdBQUcsZ0JBQWdCLEtBQUssRUFBRSxDQUFDO1NBQ2pDO1FBQ0QsSUFBSSxJQUFJLENBQUMsY0FBYyxFQUFFO1lBQ3ZCLEtBQUssR0FBRyxlQUFlLEtBQUssRUFBRSxDQUFDO1NBQ2hDO1FBQ0QsSUFBSSxJQUFJLENBQUMsSUFBSSxJQUFJLE1BQU0sSUFBSSxLQUFLLElBQUksSUFBSSxDQUFDLElBQUksRUFBRTtZQUM3QyxNQUFNLElBQUksS0FBSyxDQUNiLG9EQUFvRCxLQUFLLEVBQUUsQ0FDNUQsQ0FBQztTQUNIO1FBQ0QsT0FBTyxLQUFLLENBQUM7SUFDZixDQUFDOzs7Ozs7OztJQUtNLFFBQVE7UUFDYixJQUFJLENBQUMsV0FBVyxHQUFHLElBQUksQ0FBQztRQUN4QixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7O0lBS00sWUFBWTtRQUNqQixJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQztRQUM1QixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7Ozs7O0lBS00sV0FBVztRQUNoQixJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQztRQUMzQixPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7Ozs7OztJQUtNLFlBQVk7UUFDakIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7Ozs7OztJQUtNLGVBQWU7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLGlCQUFpQixDQUFDLENBQUM7SUFDekMsQ0FBQzs7Ozs7O0lBS00sc0JBQXNCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDO0lBQ2hELENBQUM7Ozs7OztJQUtNLHlCQUF5QjtRQUM5QixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsMkJBQTJCLENBQUMsQ0FBQztJQUNuRCxDQUFDOzs7Ozs7OztJQU9NLFVBQVU7UUFDZixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDcEMsQ0FBQzs7Ozs7Ozs7SUFPTSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUN2QyxDQUFDOzs7Ozs7SUFLTSxhQUFhO1FBQ2xCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxlQUFlLENBQUMsQ0FBQztJQUN2QyxDQUFDOzs7Ozs7SUFLTSxnQkFBZ0I7UUFDckIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDMUMsQ0FBQzs7Ozs7O0lBS00sZUFBZTtRQUNwQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsaUJBQWlCLENBQUMsQ0FBQztJQUN6QyxDQUFDOzs7Ozs7SUFLTSxxQkFBcUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDL0MsQ0FBQzs7Ozs7O0lBS00sa0JBQWtCO1FBQ3ZCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBQzVDLENBQUM7Ozs7OztJQUtNLHdCQUF3QjtRQUM3QixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsMEJBQTBCLENBQUMsQ0FBQztJQUNsRCxDQUFDOzs7Ozs7SUFLTSxVQUFVO1FBQ2YsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQ3BDLENBQUM7Ozs7OztJQUtNLGFBQWE7UUFDbEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7Ozs7OztJQUtNLFlBQVk7UUFDakIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLGNBQWMsQ0FBQyxDQUFDO0lBQ3RDLENBQUM7Ozs7OztJQUtNLGtCQUFrQjtRQUN2QixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUM1QyxDQUFDOzs7Ozs7SUFLTSxlQUFlO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBQ3pDLENBQUM7Ozs7OztJQUtNLHFCQUFxQjtRQUMxQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMvQyxDQUFDOzs7Ozs7SUFLTSxJQUFJO1FBQ1QsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzlCLENBQUM7Ozs7Ozs7O0lBS00sWUFBWTtRQUNqQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDdEMsQ0FBQzs7Ozs7O0lBS00sU0FBUztRQUNkLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUNuQyxDQUFDOzs7Ozs7SUFLTSxZQUFZO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUN0QyxDQUFDOzs7Ozs7Ozs7O0lBU00sU0FBUztRQUNkLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUNuQyxDQUFDOzs7Ozs7Ozs7O0lBU00sWUFBWTtRQUNqQixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDLENBQUM7SUFDdEMsQ0FBQzs7Ozs7Ozs7SUFPTSxPQUFPO1FBQ1osT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxDQUFDO0lBQ2pDLENBQUM7Ozs7Ozs7Ozs7SUFTTSxVQUFVO1FBQ2YsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLFlBQVksQ0FBQyxDQUFDO0lBQ3BDLENBQUM7Ozs7Ozs7O0lBS00sSUFBSTtRQUNULE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUM5QixDQUFDO0NBQ0Y7QUEzUUQsNEJBMlFDIiwic291cmNlc0NvbnRlbnQiOlsiICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBPcGVyYXRvciB7XG4gIHByaXZhdGUgYmFzZSA9ICcnO1xuICBwcml2YXRlIGhhc0lmRXhpc3RzID0gZmFsc2U7XG4gIHByaXZhdGUgaGFzRm9yQWxsVmFsdWVzID0gZmFsc2U7XG4gIHByaXZhdGUgaGFzRm9yQW55VmFsdWUgPSBmYWxzZTtcblxuICBwcml2YXRlIHNldEJhc2UoYmFzZTogc3RyaW5nKSB7XG4gICAgaWYgKHRoaXMuYmFzZS5sZW5ndGgpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgT3BlcmF0b3IgYWxyZWFkeSBzZXQ6ICR7dGhpcy5iYXNlfWApO1xuICAgIH1cbiAgICB0aGlzLmJhc2UgPSBiYXNlO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgcHVibGljIHRvU3RyaW5nKCkge1xuICAgIGxldCB2YWx1ZSA9IHRoaXMuYmFzZTtcblxuICAgIGlmICh0aGlzLmJhc2UubGVuZ3RoID09IDApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignTm8gb3BlcmF0b3Igc2V0Jyk7XG4gICAgfVxuICAgIGlmICh0aGlzLmhhc0lmRXhpc3RzKSB7XG4gICAgICB2YWx1ZSArPSAnSWZFeGlzdHMnO1xuICAgIH1cbiAgICBpZiAodGhpcy5oYXNGb3JBbGxWYWx1ZXMpIHtcbiAgICAgIHZhbHVlID0gYEZvckFsbFZhbHVlczoke3ZhbHVlfWA7XG4gICAgfVxuICAgIGlmICh0aGlzLmhhc0ZvckFueVZhbHVlKSB7XG4gICAgICB2YWx1ZSA9IGBGb3JBbnlWYWx1ZToke3ZhbHVlfWA7XG4gICAgfVxuICAgIGlmICh0aGlzLmJhc2UgPT0gJ051bGwnICYmIHZhbHVlICE9IHRoaXMuYmFzZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgICBgWW91IGNhbm5vdCBhZGQgbW9kaWZpZXJzIHRvIHRoZSBcIk51bGxcIiBvcGVyYXRvcjogJHt2YWx1ZX1gXG4gICAgICApO1xuICAgIH1cbiAgICByZXR1cm4gdmFsdWU7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgaWZFeGlzdHMoKSB7XG4gICAgdGhpcy5oYXNJZkV4aXN0cyA9IHRydWU7XG4gICAgcmV0dXJuIHRoaXM7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBmb3JBbGxWYWx1ZXMoKSB7XG4gICAgdGhpcy5oYXNGb3JBbGxWYWx1ZXMgPSB0cnVlO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGZvckFueVZhbHVlKCkge1xuICAgIHRoaXMuaGFzRm9yQW55VmFsdWUgPSB0cnVlO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RyaW5nRXF1YWxzKCkge1xuICAgIHJldHVybiB0aGlzLnNldEJhc2UoJ1N0cmluZ0VxdWFscycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdHJpbmdOb3RFcXVhbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnU3RyaW5nTm90RXF1YWxzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdHJpbmdFcXVhbHNJZ25vcmVDYXNlKCkge1xuICAgIHJldHVybiB0aGlzLnNldEJhc2UoJ1N0cmluZ0VxdWFsc0lnbm9yZUNhc2UnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0cmluZ05vdEVxdWFsc0lnbm9yZUNhc2UoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnU3RyaW5nTm90RXF1YWxzSWdub3JlQ2FzZScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RyaW5nTGlrZSgpIHtcbiAgICByZXR1cm4gdGhpcy5zZXRCYXNlKCdTdHJpbmdMaWtlJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0cmluZ05vdExpa2UoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnU3RyaW5nTm90TGlrZScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBudW1lcmljRXF1YWxzKCkge1xuICAgIHJldHVybiB0aGlzLnNldEJhc2UoJ051bWVyaWNFcXVhbHMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBudW1lcmljTm90RXF1YWxzKCkge1xuICAgIHJldHVybiB0aGlzLnNldEJhc2UoJ051bWVyaWNOb3RFcXVhbHMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBudW1lcmljTGVzc1RoYW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnTnVtZXJpY0xlc3NUaGFuJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBudW1lcmljTGVzc1RoYW5FcXVhbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnTnVtZXJpY0xlc3NUaGFuRXF1YWxzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIG51bWVyaWNHcmVhdGVyVGhhbigpIHtcbiAgICByZXR1cm4gdGhpcy5zZXRCYXNlKCdOdW1lcmljR3JlYXRlclRoYW4nKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBudW1lcmljR3JlYXRlclRoYW5FcXVhbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnTnVtZXJpY0dyZWF0ZXJUaGFuRXF1YWxzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgZGF0ZUVxdWFscygpIHtcbiAgICByZXR1cm4gdGhpcy5zZXRCYXNlKCdEYXRlRXF1YWxzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGRhdGVOb3RFcXVhbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnRGF0ZU5vdEVxdWFscycpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBkYXRlTGVzc1RoYW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnRGF0ZUxlc3NUaGFuJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBkYXRlTGVzc1RoYW5FcXVhbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnRGF0ZUxlc3NUaGFuRXF1YWxzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBkYXRlR3JlYXRlclRoYW4oKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnRGF0ZUdyZWF0ZXJUaGFuJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGRhdGVHcmVhdGVyVGhhbkVxdWFscygpIHtcbiAgICByZXR1cm4gdGhpcy5zZXRCYXNlKCdEYXRlR3JlYXRlclRoYW5FcXVhbHMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGJvb2woKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnQm9vbCcpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBiaW5hcnlFcXVhbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnQmluYXJ5RXF1YWxzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGlwQWRkcmVzcygpIHtcbiAgICByZXR1cm4gdGhpcy5zZXRCYXNlKCdJcEFkZHJlc3MnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBub3RJcEFkZHJlc3MoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnTm90SXBBZGRyZXNzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhcm5FcXVhbHMoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnQXJuRXF1YWxzJyk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGFybk5vdEVxdWFscygpIHtcbiAgICByZXR1cm4gdGhpcy5zZXRCYXNlKCdBcm5Ob3RFcXVhbHMnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGFybkxpa2UoKSB7XG4gICAgcmV0dXJuIHRoaXMuc2V0QmFzZSgnQXJuTGlrZScpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhcm5Ob3RMaWtlKCkge1xuICAgIHJldHVybiB0aGlzLnNldEJhc2UoJ0Fybk5vdExpa2UnKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgbnVsbCgpIHtcbiAgICByZXR1cm4gdGhpcy5zZXRCYXNlKCdOdWxsJyk7XG4gIH1cbn1cbiJdfQ==