"""
    Svix API

    Welcome to the Svix API documentation!  Useful links: [Homepage](https://www.svix.com) | [Support email](mailto:support+docs@svix.com) | [Blog](https://www.svix.com/blog/) | [Slack Community](https://www.svix.com/slack/)  # Introduction  This is the reference documentation and schemas for the [Svix webhook service](https://www.svix.com) API. For tutorials and other documentation please refer to [the documentation](https://docs.svix.com).  ## Main concepts  In Svix you have four important entities you will be interacting with:  - `messages`: these are the webhooks being sent. They can have contents and a few other properties. - `application`: this is where `messages` are sent to. Usually you want to create one application for each of your users. - `endpoint`: endpoints are the URLs messages will be sent to. Each application can have multiple `endpoints` and each message sent to that application will be sent to all of them (unless they are not subscribed to the sent event type). - `event-type`: event types are identifiers denoting the type of the message being sent. Event types are primarily used to decide which events are sent to which endpoint.   ## Authentication  Get your authentication token (`AUTH_TOKEN`) from the [Svix dashboard](https://dashboard.svix.com) and use it as part of the `Authorization` header as such: `Authorization: Bearer ${AUTH_TOKEN}`.  <SecurityDefinitions />   ## Code samples  The code samples assume you already have the respective libraries installed and you know how to use them. For the latest information on how to do that, please refer to [the documentation](https://docs.svix.com/).   ## Cross-Origin Resource Sharing  This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with [W3C spec](https://www.w3.org/TR/cors/). And that allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.   # noqa: E501

    The version of the OpenAPI document: 1.4
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from svix.openapi_client.api_client import ApiClient, Endpoint as _Endpoint
from svix.openapi_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from svix.openapi_client.model.event_type_example_out import EventTypeExampleOut
from svix.openapi_client.model.event_type_in import EventTypeIn
from svix.openapi_client.model.event_type_out import EventTypeOut
from svix.openapi_client.model.event_type_schema_in import EventTypeSchemaIn
from svix.openapi_client.model.event_type_update import EventTypeUpdate
from svix.openapi_client.model.http_validation_error import HTTPValidationError
from svix.openapi_client.model.http_error_out import HttpErrorOut
from svix.openapi_client.model.list_response_event_type_out import ListResponseEventTypeOut


class EventTypeApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_event_type_api_v1_event_type_post(
            self,
            event_type_in,
            **kwargs
        ):
            """Create Event Type  # noqa: E501

            Create new or unarchive existing event type.  Unarchiving an event type will allow endpoints to filter on it and messages to be sent with it. Endpoints filtering on the event type before archival will continue to filter on it. This operation does not preserve the description and schemas.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_event_type_api_v1_event_type_post(event_type_in, async_req=True)
            >>> result = thread.get()

            Args:
                event_type_in (EventTypeIn):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EventTypeOut
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['event_type_in'] = \
                event_type_in
            return self.call_with_http_info(**kwargs)

        self.create_event_type_api_v1_event_type_post = _Endpoint(
            settings={
                'response_type': (EventTypeOut,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/event-type/',
                'operation_id': 'create_event_type_api_v1_event_type_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_type_in',
                ],
                'required': [
                    'event_type_in',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_type_in':
                        (EventTypeIn,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'event_type_in': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_event_type_api_v1_event_type_post
        )

        def __delete_event_type_api_v1_event_type_event_type_name_delete(
            self,
            event_type_name,
            **kwargs
        ):
            """Archive Event Type  # noqa: E501

            Archive an event type.  Endpoints already configured to filter on an event type will continue to do so after archival. However, new messages can not be sent with it and endpoints can not filter on it. An event type can be unarchived with the [create operation](#operation/create_event_type_api_v1_event_type__post).  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_event_type_api_v1_event_type_event_type_name_delete(event_type_name, async_req=True)
            >>> result = thread.get()

            Args:
                event_type_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['event_type_name'] = \
                event_type_name
            return self.call_with_http_info(**kwargs)

        self.delete_event_type_api_v1_event_type_event_type_name_delete = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/event-type/{event_type_name}/',
                'operation_id': 'delete_event_type_api_v1_event_type_event_type_name_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_type_name',
                ],
                'required': [
                    'event_type_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_type_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_type_name',): {
                        'max_length': 256,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_type_name':
                        (str,),
                },
                'attribute_map': {
                    'event_type_name': 'event_type_name',
                },
                'location_map': {
                    'event_type_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_event_type_api_v1_event_type_event_type_name_delete
        )

        def __generate_schema_example_api_v1_event_type_schema_generate_example_post(
            self,
            event_type_schema_in,
            **kwargs
        ):
            """Generate Schema Example  # noqa: E501

            Generates a fake example from the given JSONSchema  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.generate_schema_example_api_v1_event_type_schema_generate_example_post(event_type_schema_in, async_req=True)
            >>> result = thread.get()

            Args:
                event_type_schema_in (EventTypeSchemaIn):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EventTypeExampleOut
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['event_type_schema_in'] = \
                event_type_schema_in
            return self.call_with_http_info(**kwargs)

        self.generate_schema_example_api_v1_event_type_schema_generate_example_post = _Endpoint(
            settings={
                'response_type': (EventTypeExampleOut,),
                'auth': [],
                'endpoint_path': '/api/v1/event-type/schema/generate-example/',
                'operation_id': 'generate_schema_example_api_v1_event_type_schema_generate_example_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_type_schema_in',
                ],
                'required': [
                    'event_type_schema_in',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_type_schema_in':
                        (EventTypeSchemaIn,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'event_type_schema_in': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__generate_schema_example_api_v1_event_type_schema_generate_example_post
        )

        def __get_event_type_api_v1_event_type_event_type_name_get(
            self,
            event_type_name,
            **kwargs
        ):
            """Get Event Type  # noqa: E501

            Get an event type.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_event_type_api_v1_event_type_event_type_name_get(event_type_name, async_req=True)
            >>> result = thread.get()

            Args:
                event_type_name (str):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EventTypeOut
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['event_type_name'] = \
                event_type_name
            return self.call_with_http_info(**kwargs)

        self.get_event_type_api_v1_event_type_event_type_name_get = _Endpoint(
            settings={
                'response_type': (EventTypeOut,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/event-type/{event_type_name}/',
                'operation_id': 'get_event_type_api_v1_event_type_event_type_name_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_type_name',
                ],
                'required': [
                    'event_type_name',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_type_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_type_name',): {
                        'max_length': 256,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_type_name':
                        (str,),
                },
                'attribute_map': {
                    'event_type_name': 'event_type_name',
                },
                'location_map': {
                    'event_type_name': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_event_type_api_v1_event_type_event_type_name_get
        )

        def __list_event_types_api_v1_event_type_get(
            self,
            **kwargs
        ):
            """List Event Types  # noqa: E501

            Return the list of event types.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_event_types_api_v1_event_type_get(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                iterator (str): [optional]
                limit (int): [optional] if omitted the server will use the default value of 50
                with_content (bool): [optional] if omitted the server will use the default value of False
                include_archived (bool): [optional] if omitted the server will use the default value of False
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListResponseEventTypeOut
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.list_event_types_api_v1_event_type_get = _Endpoint(
            settings={
                'response_type': (ListResponseEventTypeOut,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/event-type/',
                'operation_id': 'list_event_types_api_v1_event_type_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'iterator',
                    'limit',
                    'with_content',
                    'include_archived',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'iterator',
                ]
            },
            root_map={
                'validations': {
                    ('iterator',): {
                        'max_length': 256,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'iterator':
                        (str,),
                    'limit':
                        (int,),
                    'with_content':
                        (bool,),
                    'include_archived':
                        (bool,),
                },
                'attribute_map': {
                    'iterator': 'iterator',
                    'limit': 'limit',
                    'with_content': 'with_content',
                    'include_archived': 'include_archived',
                },
                'location_map': {
                    'iterator': 'query',
                    'limit': 'query',
                    'with_content': 'query',
                    'include_archived': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__list_event_types_api_v1_event_type_get
        )

        def __update_event_type_api_v1_event_type_event_type_name_put(
            self,
            event_type_name,
            event_type_update,
            **kwargs
        ):
            """Update Event Type  # noqa: E501

            Update an event type.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_event_type_api_v1_event_type_event_type_name_put(event_type_name, event_type_update, async_req=True)
            >>> result = thread.get()

            Args:
                event_type_name (str):
                event_type_update (EventTypeUpdate):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (int/float/tuple): timeout setting for this request. If
                    one number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                EventTypeOut
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['event_type_name'] = \
                event_type_name
            kwargs['event_type_update'] = \
                event_type_update
            return self.call_with_http_info(**kwargs)

        self.update_event_type_api_v1_event_type_event_type_name_put = _Endpoint(
            settings={
                'response_type': (EventTypeOut,),
                'auth': [
                    'HTTPBearer'
                ],
                'endpoint_path': '/api/v1/event-type/{event_type_name}/',
                'operation_id': 'update_event_type_api_v1_event_type_event_type_name_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'event_type_name',
                    'event_type_update',
                ],
                'required': [
                    'event_type_name',
                    'event_type_update',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'event_type_name',
                ]
            },
            root_map={
                'validations': {
                    ('event_type_name',): {
                        'max_length': 256,
                        'regex': {
                            'pattern': r'^[a-zA-Z0-9\-_.]+$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'event_type_name':
                        (str,),
                    'event_type_update':
                        (EventTypeUpdate,),
                },
                'attribute_map': {
                    'event_type_name': 'event_type_name',
                },
                'location_map': {
                    'event_type_name': 'path',
                    'event_type_update': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__update_event_type_api_v1_event_type_event_type_name_put
        )
