import numpy as np
from ed_win.wind_farm_network import WindFarmNetwork, HeuristicDriver
import numpy.testing as npt

initial_layout = dict(x=np.array([0., 2000., 4000., 6000.,
                                  8000., 498.65600569, 2498.65600569, 4498.65600569,
                                  6498.65600569, 8498.65600569, 997.31201137, 2997.31201137,
                                  4997.31201137, 11336.25662483, 8997.31201137, 1495.96801706,
                                  3495.96801706, 5495.96801706, 10011.39514341, 11426.89538545,
                                  1994.62402275, 3994.62402275, 5994.62402275, 7994.62402275,
                                  10588.90471566]),
                      y=np.array([0., 0., 0., 0.,
                                  0., 2000., 2000., 2000.,
                                  2000., 2000., 4000., 4000.,
                                  4000., 6877.42528387, 4000., 6000.,
                                  6000., 6000., 3179.76530545, 5953.63051694,
                                  8000., 8000., 8000., 8000.,
                                  4734.32972738]))
settings = {'option': 3,
            'Inters_const': True,
            'max_it': 20000}
cables = np.array([[500, 3, 100000], [800, 5, 150000], [1000, 10, 250000]])
wfn = WindFarmNetwork(initial_layout=initial_layout,
                      driver=HeuristicDriver(**settings),
                      cables=cables)

T_ref = np.asarray([[1.00000000e+00, 2.00000000e+00, 2.00000000e+03, 1.00000000e+00,
                     3.00000000e+05],
                    [2.00000000e+00, 3.00000000e+00, 2.00000000e+03, 0.00000000e+00,
                     2.00000000e+05],
                    [3.00000000e+00, 4.00000000e+00, 2.00000000e+03, 0.00000000e+00,
                     2.00000000e+05],
                    [4.00000000e+00, 5.00000000e+00, 2.00000000e+03, 0.00000000e+00,
                     2.00000000e+05],
                    [1.00000000e+00, 6.00000000e+00, 2.06122726e+03, 2.00000000e+00,
                     5.15306815e+05],
                    [6.00000000e+00, 7.00000000e+00, 2.00000000e+03, 2.00000000e+00,
                     5.00000000e+05],
                    [7.00000000e+00, 8.00000000e+00, 2.00000000e+03, 2.00000000e+00,
                     5.00000000e+05],
                    [8.00000000e+00, 9.00000000e+00, 2.00000000e+03, 2.00000000e+00,
                     5.00000000e+05],
                    [9.00000000e+00, 1.00000000e+01, 2.00000000e+03, 2.00000000e+00,
                     5.00000000e+05],
                    [1.00000000e+01, 1.90000000e+01, 1.91839148e+03, 1.00000000e+00,
                     2.87758722e+05],
                    [1.90000000e+01, 1.50000000e+01, 1.30428124e+03, 0.00000000e+00,
                     1.30428124e+05],
                    [1.90000000e+01, 2.50000000e+01, 1.65836903e+03, 0.00000000e+00,
                     1.65836903e+05],
                    [2.50000000e+01, 2.00000000e+01, 1.47950085e+03, 0.00000000e+00,
                     1.47950085e+05],
                    [2.00000000e+01, 1.40000000e+01, 9.28230659e+02, 0.00000000e+00,
                     9.28230659e+04],
                    [1.00000000e+00, 1.10000000e+01, 4.12245452e+03, 2.00000000e+00,
                     1.03061363e+06],
                    [1.10000000e+01, 1.20000000e+01, 2.00000000e+03, 0.00000000e+00,
                     2.00000000e+05],
                    [1.20000000e+01, 1.30000000e+01, 2.00000000e+03, 0.00000000e+00,
                     2.00000000e+05],
                    [1.10000000e+01, 1.60000000e+01, 2.06122726e+03, 2.00000000e+00,
                     5.15306815e+05],
                    [1.60000000e+01, 1.70000000e+01, 2.00000000e+03, 0.00000000e+00,
                     2.00000000e+05],
                    [1.70000000e+01, 1.80000000e+01, 2.00000000e+03, 0.00000000e+00,
                     2.00000000e+05],
                    [1.60000000e+01, 2.10000000e+01, 2.06122726e+03, 1.00000000e+00,
                     3.09184089e+05],
                    [2.10000000e+01, 2.20000000e+01, 2.00000000e+03, 0.00000000e+00,
                     2.00000000e+05],
                    [2.20000000e+01, 2.30000000e+01, 2.00000000e+03, 0.00000000e+00,
                     2.00000000e+05],
                    [2.30000000e+01, 2.40000000e+01, 2.00000000e+03, 0.00000000e+00,
                     2.00000000e+05]])


def test_wind_farm_network():
    cost, state = wfn.design()
    assert 7495208.24825092 == cost
    npt.assert_allclose(wfn.T, T_ref)
