import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Kendra::DataSource`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export interface CfnDataSourceProps {
    /**
     * `AWS::Kendra::DataSource.IndexId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-indexid
     */
    readonly indexId: string;
    /**
     * `AWS::Kendra::DataSource.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-name
     */
    readonly name: string;
    /**
     * `AWS::Kendra::DataSource.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-type
     */
    readonly type: string;
    /**
     * `AWS::Kendra::DataSource.DataSourceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-datasourceconfiguration
     */
    readonly dataSourceConfiguration?: CfnDataSource.DataSourceConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Kendra::DataSource.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-description
     */
    readonly description?: string;
    /**
     * `AWS::Kendra::DataSource.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-rolearn
     */
    readonly roleArn?: string;
    /**
     * `AWS::Kendra::DataSource.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-schedule
     */
    readonly schedule?: string;
    /**
     * `AWS::Kendra::DataSource.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare class CfnDataSource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Kendra::DataSource";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataSource;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::Kendra::DataSource.IndexId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-indexid
     */
    indexId: string;
    /**
     * `AWS::Kendra::DataSource.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-name
     */
    name: string;
    /**
     * `AWS::Kendra::DataSource.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-type
     */
    type: string;
    /**
     * `AWS::Kendra::DataSource.DataSourceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-datasourceconfiguration
     */
    dataSourceConfiguration: CfnDataSource.DataSourceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Kendra::DataSource.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-description
     */
    description: string | undefined;
    /**
     * `AWS::Kendra::DataSource.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-rolearn
     */
    roleArn: string | undefined;
    /**
     * `AWS::Kendra::DataSource.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-schedule
     */
    schedule: string | undefined;
    /**
     * `AWS::Kendra::DataSource.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html#cfn-kendra-datasource-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Kendra::DataSource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDataSourceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-accesscontrollistconfiguration.html
     */
    interface AccessControlListConfigurationProperty {
        /**
         * `CfnDataSource.AccessControlListConfigurationProperty.KeyPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-accesscontrollistconfiguration.html#cfn-kendra-datasource-accesscontrollistconfiguration-keypath
         */
        readonly keyPath?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-aclconfiguration.html
     */
    interface AclConfigurationProperty {
        /**
         * `CfnDataSource.AclConfigurationProperty.AllowedGroupsColumnName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-aclconfiguration.html#cfn-kendra-datasource-aclconfiguration-allowedgroupscolumnname
         */
        readonly allowedGroupsColumnName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html
     */
    interface ColumnConfigurationProperty {
        /**
         * `CfnDataSource.ColumnConfigurationProperty.ChangeDetectingColumns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-changedetectingcolumns
         */
        readonly changeDetectingColumns: string[];
        /**
         * `CfnDataSource.ColumnConfigurationProperty.DocumentDataColumnName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-documentdatacolumnname
         */
        readonly documentDataColumnName: string;
        /**
         * `CfnDataSource.ColumnConfigurationProperty.DocumentIdColumnName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-documentidcolumnname
         */
        readonly documentIdColumnName: string;
        /**
         * `CfnDataSource.ColumnConfigurationProperty.DocumentTitleColumnName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-documenttitlecolumnname
         */
        readonly documentTitleColumnName?: string;
        /**
         * `CfnDataSource.ColumnConfigurationProperty.FieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-columnconfiguration.html#cfn-kendra-datasource-columnconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmentconfiguration.html
     */
    interface ConfluenceAttachmentConfigurationProperty {
        /**
         * `CfnDataSource.ConfluenceAttachmentConfigurationProperty.AttachmentFieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmentconfiguration.html#cfn-kendra-datasource-confluenceattachmentconfiguration-attachmentfieldmappings
         */
        readonly attachmentFieldMappings?: Array<CfnDataSource.ConfluenceAttachmentToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceAttachmentConfigurationProperty.CrawlAttachments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmentconfiguration.html#cfn-kendra-datasource-confluenceattachmentconfiguration-crawlattachments
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmenttoindexfieldmapping.html
     */
    interface ConfluenceAttachmentToIndexFieldMappingProperty {
        /**
         * `CfnDataSource.ConfluenceAttachmentToIndexFieldMappingProperty.DataSourceFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmenttoindexfieldmapping.html#cfn-kendra-datasource-confluenceattachmenttoindexfieldmapping-datasourcefieldname
         */
        readonly dataSourceFieldName: string;
        /**
         * `CfnDataSource.ConfluenceAttachmentToIndexFieldMappingProperty.DateFieldFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmenttoindexfieldmapping.html#cfn-kendra-datasource-confluenceattachmenttoindexfieldmapping-datefieldformat
         */
        readonly dateFieldFormat?: string;
        /**
         * `CfnDataSource.ConfluenceAttachmentToIndexFieldMappingProperty.IndexFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceattachmenttoindexfieldmapping.html#cfn-kendra-datasource-confluenceattachmenttoindexfieldmapping-indexfieldname
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogconfiguration.html
     */
    interface ConfluenceBlogConfigurationProperty {
        /**
         * `CfnDataSource.ConfluenceBlogConfigurationProperty.BlogFieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogconfiguration.html#cfn-kendra-datasource-confluenceblogconfiguration-blogfieldmappings
         */
        readonly blogFieldMappings?: Array<CfnDataSource.ConfluenceBlogToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogtoindexfieldmapping.html
     */
    interface ConfluenceBlogToIndexFieldMappingProperty {
        /**
         * `CfnDataSource.ConfluenceBlogToIndexFieldMappingProperty.DataSourceFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogtoindexfieldmapping.html#cfn-kendra-datasource-confluenceblogtoindexfieldmapping-datasourcefieldname
         */
        readonly dataSourceFieldName: string;
        /**
         * `CfnDataSource.ConfluenceBlogToIndexFieldMappingProperty.DateFieldFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogtoindexfieldmapping.html#cfn-kendra-datasource-confluenceblogtoindexfieldmapping-datefieldformat
         */
        readonly dateFieldFormat?: string;
        /**
         * `CfnDataSource.ConfluenceBlogToIndexFieldMappingProperty.IndexFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceblogtoindexfieldmapping.html#cfn-kendra-datasource-confluenceblogtoindexfieldmapping-indexfieldname
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html
     */
    interface ConfluenceConfigurationProperty {
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.AttachmentConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-attachmentconfiguration
         */
        readonly attachmentConfiguration?: CfnDataSource.ConfluenceAttachmentConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.BlogConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-blogconfiguration
         */
        readonly blogConfiguration?: CfnDataSource.ConfluenceBlogConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.ExclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-exclusionpatterns
         */
        readonly exclusionPatterns?: string[];
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.InclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-inclusionpatterns
         */
        readonly inclusionPatterns?: string[];
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.PageConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-pageconfiguration
         */
        readonly pageConfiguration?: CfnDataSource.ConfluencePageConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.SecretArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-secretarn
         */
        readonly secretArn: string;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.ServerUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-serverurl
         */
        readonly serverUrl: string;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.SpaceConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-spaceconfiguration
         */
        readonly spaceConfiguration?: CfnDataSource.ConfluenceSpaceConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.Version`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-version
         */
        readonly version: string;
        /**
         * `CfnDataSource.ConfluenceConfigurationProperty.VpcConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluenceconfiguration.html#cfn-kendra-datasource-confluenceconfiguration-vpcconfiguration
         */
        readonly vpcConfiguration?: CfnDataSource.DataSourceVpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepageconfiguration.html
     */
    interface ConfluencePageConfigurationProperty {
        /**
         * `CfnDataSource.ConfluencePageConfigurationProperty.PageFieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepageconfiguration.html#cfn-kendra-datasource-confluencepageconfiguration-pagefieldmappings
         */
        readonly pageFieldMappings?: Array<CfnDataSource.ConfluencePageToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagetoindexfieldmapping.html
     */
    interface ConfluencePageToIndexFieldMappingProperty {
        /**
         * `CfnDataSource.ConfluencePageToIndexFieldMappingProperty.DataSourceFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagetoindexfieldmapping.html#cfn-kendra-datasource-confluencepagetoindexfieldmapping-datasourcefieldname
         */
        readonly dataSourceFieldName: string;
        /**
         * `CfnDataSource.ConfluencePageToIndexFieldMappingProperty.DateFieldFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagetoindexfieldmapping.html#cfn-kendra-datasource-confluencepagetoindexfieldmapping-datefieldformat
         */
        readonly dateFieldFormat?: string;
        /**
         * `CfnDataSource.ConfluencePageToIndexFieldMappingProperty.IndexFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencepagetoindexfieldmapping.html#cfn-kendra-datasource-confluencepagetoindexfieldmapping-indexfieldname
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html
     */
    interface ConfluenceSpaceConfigurationProperty {
        /**
         * `CfnDataSource.ConfluenceSpaceConfigurationProperty.CrawlArchivedSpaces`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-crawlarchivedspaces
         */
        readonly crawlArchivedSpaces?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceSpaceConfigurationProperty.CrawlPersonalSpaces`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-crawlpersonalspaces
         */
        readonly crawlPersonalSpaces?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.ConfluenceSpaceConfigurationProperty.ExcludeSpaces`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-excludespaces
         */
        readonly excludeSpaces?: string[];
        /**
         * `CfnDataSource.ConfluenceSpaceConfigurationProperty.IncludeSpaces`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-includespaces
         */
        readonly includeSpaces?: string[];
        /**
         * `CfnDataSource.ConfluenceSpaceConfigurationProperty.SpaceFieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespaceconfiguration.html#cfn-kendra-datasource-confluencespaceconfiguration-spacefieldmappings
         */
        readonly spaceFieldMappings?: Array<CfnDataSource.ConfluenceSpaceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacetoindexfieldmapping.html
     */
    interface ConfluenceSpaceToIndexFieldMappingProperty {
        /**
         * `CfnDataSource.ConfluenceSpaceToIndexFieldMappingProperty.DataSourceFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacetoindexfieldmapping.html#cfn-kendra-datasource-confluencespacetoindexfieldmapping-datasourcefieldname
         */
        readonly dataSourceFieldName: string;
        /**
         * `CfnDataSource.ConfluenceSpaceToIndexFieldMappingProperty.DateFieldFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacetoindexfieldmapping.html#cfn-kendra-datasource-confluencespacetoindexfieldmapping-datefieldformat
         */
        readonly dateFieldFormat?: string;
        /**
         * `CfnDataSource.ConfluenceSpaceToIndexFieldMappingProperty.IndexFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-confluencespacetoindexfieldmapping.html#cfn-kendra-datasource-confluencespacetoindexfieldmapping-indexfieldname
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html
     */
    interface ConnectionConfigurationProperty {
        /**
         * `CfnDataSource.ConnectionConfigurationProperty.DatabaseHost`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-databasehost
         */
        readonly databaseHost: string;
        /**
         * `CfnDataSource.ConnectionConfigurationProperty.DatabaseName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-databasename
         */
        readonly databaseName: string;
        /**
         * `CfnDataSource.ConnectionConfigurationProperty.DatabasePort`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-databaseport
         */
        readonly databasePort: number;
        /**
         * `CfnDataSource.ConnectionConfigurationProperty.SecretArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-secretarn
         */
        readonly secretArn: string;
        /**
         * `CfnDataSource.ConnectionConfigurationProperty.TableName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-connectionconfiguration.html#cfn-kendra-datasource-connectionconfiguration-tablename
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html
     */
    interface DataSourceConfigurationProperty {
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.ConfluenceConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-confluenceconfiguration
         */
        readonly confluenceConfiguration?: CfnDataSource.ConfluenceConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.DatabaseConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-databaseconfiguration
         */
        readonly databaseConfiguration?: CfnDataSource.DatabaseConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.GoogleDriveConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-googledriveconfiguration
         */
        readonly googleDriveConfiguration?: CfnDataSource.GoogleDriveConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.OneDriveConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-onedriveconfiguration
         */
        readonly oneDriveConfiguration?: CfnDataSource.OneDriveConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.S3Configuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-s3configuration
         */
        readonly s3Configuration?: CfnDataSource.S3DataSourceConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.SalesforceConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-salesforceconfiguration
         */
        readonly salesforceConfiguration?: CfnDataSource.SalesforceConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.ServiceNowConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-servicenowconfiguration
         */
        readonly serviceNowConfiguration?: CfnDataSource.ServiceNowConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.SharePointConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-sharepointconfiguration
         */
        readonly sharePointConfiguration?: CfnDataSource.SharePointConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.WebCrawlerConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-webcrawlerconfiguration
         */
        readonly webCrawlerConfiguration?: CfnDataSource.WebCrawlerConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DataSourceConfigurationProperty.WorkDocsConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourceconfiguration.html#cfn-kendra-datasource-datasourceconfiguration-workdocsconfiguration
         */
        readonly workDocsConfiguration?: CfnDataSource.WorkDocsConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmapping.html
     */
    interface DataSourceToIndexFieldMappingProperty {
        /**
         * `CfnDataSource.DataSourceToIndexFieldMappingProperty.DataSourceFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmapping.html#cfn-kendra-datasource-datasourcetoindexfieldmapping-datasourcefieldname
         */
        readonly dataSourceFieldName: string;
        /**
         * `CfnDataSource.DataSourceToIndexFieldMappingProperty.DateFieldFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmapping.html#cfn-kendra-datasource-datasourcetoindexfieldmapping-datefieldformat
         */
        readonly dateFieldFormat?: string;
        /**
         * `CfnDataSource.DataSourceToIndexFieldMappingProperty.IndexFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcetoindexfieldmapping.html#cfn-kendra-datasource-datasourcetoindexfieldmapping-indexfieldname
         */
        readonly indexFieldName: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcevpcconfiguration.html
     */
    interface DataSourceVpcConfigurationProperty {
        /**
         * `CfnDataSource.DataSourceVpcConfigurationProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcevpcconfiguration.html#cfn-kendra-datasource-datasourcevpcconfiguration-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnDataSource.DataSourceVpcConfigurationProperty.SubnetIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-datasourcevpcconfiguration.html#cfn-kendra-datasource-datasourcevpcconfiguration-subnetids
         */
        readonly subnetIds: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html
     */
    interface DatabaseConfigurationProperty {
        /**
         * `CfnDataSource.DatabaseConfigurationProperty.AclConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-aclconfiguration
         */
        readonly aclConfiguration?: CfnDataSource.AclConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DatabaseConfigurationProperty.ColumnConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-columnconfiguration
         */
        readonly columnConfiguration: CfnDataSource.ColumnConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DatabaseConfigurationProperty.ConnectionConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-connectionconfiguration
         */
        readonly connectionConfiguration: CfnDataSource.ConnectionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DatabaseConfigurationProperty.DatabaseEngineType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-databaseenginetype
         */
        readonly databaseEngineType: string;
        /**
         * `CfnDataSource.DatabaseConfigurationProperty.SqlConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-sqlconfiguration
         */
        readonly sqlConfiguration?: CfnDataSource.SqlConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.DatabaseConfigurationProperty.VpcConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-databaseconfiguration.html#cfn-kendra-datasource-databaseconfiguration-vpcconfiguration
         */
        readonly vpcConfiguration?: CfnDataSource.DataSourceVpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-documentsmetadataconfiguration.html
     */
    interface DocumentsMetadataConfigurationProperty {
        /**
         * `CfnDataSource.DocumentsMetadataConfigurationProperty.S3Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-documentsmetadataconfiguration.html#cfn-kendra-datasource-documentsmetadataconfiguration-s3prefix
         */
        readonly s3Prefix?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html
     */
    interface GoogleDriveConfigurationProperty {
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.ExcludeMimeTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-excludemimetypes
         */
        readonly excludeMimeTypes?: string[];
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.ExcludeSharedDrives`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-excludeshareddrives
         */
        readonly excludeSharedDrives?: string[];
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.ExcludeUserAccounts`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-excludeuseraccounts
         */
        readonly excludeUserAccounts?: string[];
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.ExclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-exclusionpatterns
         */
        readonly exclusionPatterns?: string[];
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.FieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.InclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-inclusionpatterns
         */
        readonly inclusionPatterns?: string[];
        /**
         * `CfnDataSource.GoogleDriveConfigurationProperty.SecretArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-googledriveconfiguration.html#cfn-kendra-datasource-googledriveconfiguration-secretarn
         */
        readonly secretArn: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html
     */
    interface OneDriveConfigurationProperty {
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.DisableLocalGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-disablelocalgroups
         */
        readonly disableLocalGroups?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.ExclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-exclusionpatterns
         */
        readonly exclusionPatterns?: string[];
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.FieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.InclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-inclusionpatterns
         */
        readonly inclusionPatterns?: string[];
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.OneDriveUsers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-onedriveusers
         */
        readonly oneDriveUsers: CfnDataSource.OneDriveUsersProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.SecretArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-secretarn
         */
        readonly secretArn: string;
        /**
         * `CfnDataSource.OneDriveConfigurationProperty.TenantDomain`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveconfiguration.html#cfn-kendra-datasource-onedriveconfiguration-tenantdomain
         */
        readonly tenantDomain: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveusers.html
     */
    interface OneDriveUsersProperty {
        /**
         * `CfnDataSource.OneDriveUsersProperty.OneDriveUserList`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveusers.html#cfn-kendra-datasource-onedriveusers-onedriveuserlist
         */
        readonly oneDriveUserList?: string[];
        /**
         * `CfnDataSource.OneDriveUsersProperty.OneDriveUserS3Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-onedriveusers.html#cfn-kendra-datasource-onedriveusers-onedriveusers3path
         */
        readonly oneDriveUserS3Path?: CfnDataSource.S3PathProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-proxyconfiguration.html
     */
    interface ProxyConfigurationProperty {
        /**
         * `CfnDataSource.ProxyConfigurationProperty.Credentials`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-proxyconfiguration.html#cfn-kendra-datasource-proxyconfiguration-credentials
         */
        readonly credentials?: string;
        /**
         * `CfnDataSource.ProxyConfigurationProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-proxyconfiguration.html#cfn-kendra-datasource-proxyconfiguration-host
         */
        readonly host: string;
        /**
         * `CfnDataSource.ProxyConfigurationProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-proxyconfiguration.html#cfn-kendra-datasource-proxyconfiguration-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html
     */
    interface S3DataSourceConfigurationProperty {
        /**
         * `CfnDataSource.S3DataSourceConfigurationProperty.AccessControlListConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-accesscontrollistconfiguration
         */
        readonly accessControlListConfiguration?: CfnDataSource.AccessControlListConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.S3DataSourceConfigurationProperty.BucketName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-bucketname
         */
        readonly bucketName: string;
        /**
         * `CfnDataSource.S3DataSourceConfigurationProperty.DocumentsMetadataConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-documentsmetadataconfiguration
         */
        readonly documentsMetadataConfiguration?: CfnDataSource.DocumentsMetadataConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.S3DataSourceConfigurationProperty.ExclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-exclusionpatterns
         */
        readonly exclusionPatterns?: string[];
        /**
         * `CfnDataSource.S3DataSourceConfigurationProperty.InclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-inclusionpatterns
         */
        readonly inclusionPatterns?: string[];
        /**
         * `CfnDataSource.S3DataSourceConfigurationProperty.InclusionPrefixes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3datasourceconfiguration.html#cfn-kendra-datasource-s3datasourceconfiguration-inclusionprefixes
         */
        readonly inclusionPrefixes?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3path.html
     */
    interface S3PathProperty {
        /**
         * `CfnDataSource.S3PathProperty.Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3path.html#cfn-kendra-datasource-s3path-bucket
         */
        readonly bucket: string;
        /**
         * `CfnDataSource.S3PathProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-s3path.html#cfn-kendra-datasource-s3path-key
         */
        readonly key: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html
     */
    interface SalesforceChatterFeedConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceChatterFeedConfigurationProperty.DocumentDataFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html#cfn-kendra-datasource-salesforcechatterfeedconfiguration-documentdatafieldname
         */
        readonly documentDataFieldName: string;
        /**
         * `CfnDataSource.SalesforceChatterFeedConfigurationProperty.DocumentTitleFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html#cfn-kendra-datasource-salesforcechatterfeedconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.SalesforceChatterFeedConfigurationProperty.FieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html#cfn-kendra-datasource-salesforcechatterfeedconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceChatterFeedConfigurationProperty.IncludeFilterTypes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcechatterfeedconfiguration.html#cfn-kendra-datasource-salesforcechatterfeedconfiguration-includefiltertypes
         */
        readonly includeFilterTypes?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html
     */
    interface SalesforceConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.ChatterFeedConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-chatterfeedconfiguration
         */
        readonly chatterFeedConfiguration?: CfnDataSource.SalesforceChatterFeedConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.CrawlAttachments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-crawlattachments
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.ExcludeAttachmentFilePatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-excludeattachmentfilepatterns
         */
        readonly excludeAttachmentFilePatterns?: string[];
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.IncludeAttachmentFilePatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-includeattachmentfilepatterns
         */
        readonly includeAttachmentFilePatterns?: string[];
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.KnowledgeArticleConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-knowledgearticleconfiguration
         */
        readonly knowledgeArticleConfiguration?: CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.SecretArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-secretarn
         */
        readonly secretArn: string;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.ServerUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-serverurl
         */
        readonly serverUrl: string;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.StandardObjectAttachmentConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-standardobjectattachmentconfiguration
         */
        readonly standardObjectAttachmentConfiguration?: CfnDataSource.SalesforceStandardObjectAttachmentConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceConfigurationProperty.StandardObjectConfigurations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceconfiguration.html#cfn-kendra-datasource-salesforceconfiguration-standardobjectconfigurations
         */
        readonly standardObjectConfigurations?: Array<CfnDataSource.SalesforceStandardObjectConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html
     */
    interface SalesforceCustomKnowledgeArticleTypeConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty.DocumentDataFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration-documentdatafieldname
         */
        readonly documentDataFieldName: string;
        /**
         * `CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty.DocumentTitleFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty.FieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcecustomknowledgearticletypeconfiguration-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticleconfiguration.html
     */
    interface SalesforceKnowledgeArticleConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty.CustomKnowledgeArticleTypeConfigurations`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticleconfiguration.html#cfn-kendra-datasource-salesforceknowledgearticleconfiguration-customknowledgearticletypeconfigurations
         */
        readonly customKnowledgeArticleTypeConfigurations?: Array<CfnDataSource.SalesforceCustomKnowledgeArticleTypeConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty.IncludedStates`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticleconfiguration.html#cfn-kendra-datasource-salesforceknowledgearticleconfiguration-includedstates
         */
        readonly includedStates: string[];
        /**
         * `CfnDataSource.SalesforceKnowledgeArticleConfigurationProperty.StandardKnowledgeArticleTypeConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforceknowledgearticleconfiguration.html#cfn-kendra-datasource-salesforceknowledgearticleconfiguration-standardknowledgearticletypeconfiguration
         */
        readonly standardKnowledgeArticleTypeConfiguration?: CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration.html
     */
    interface SalesforceStandardKnowledgeArticleTypeConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty.DocumentDataFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration-documentdatafieldname
         */
        readonly documentDataFieldName: string;
        /**
         * `CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty.DocumentTitleFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.SalesforceStandardKnowledgeArticleTypeConfigurationProperty.FieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration.html#cfn-kendra-datasource-salesforcestandardknowledgearticletypeconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectattachmentconfiguration.html
     */
    interface SalesforceStandardObjectAttachmentConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceStandardObjectAttachmentConfigurationProperty.DocumentTitleFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectattachmentconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectattachmentconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.SalesforceStandardObjectAttachmentConfigurationProperty.FieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectattachmentconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectattachmentconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html
     */
    interface SalesforceStandardObjectConfigurationProperty {
        /**
         * `CfnDataSource.SalesforceStandardObjectConfigurationProperty.DocumentDataFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectconfiguration-documentdatafieldname
         */
        readonly documentDataFieldName: string;
        /**
         * `CfnDataSource.SalesforceStandardObjectConfigurationProperty.DocumentTitleFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.SalesforceStandardObjectConfigurationProperty.FieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSource.SalesforceStandardObjectConfigurationProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-salesforcestandardobjectconfiguration.html#cfn-kendra-datasource-salesforcestandardobjectconfiguration-name
         */
        readonly name: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html
     */
    interface ServiceNowConfigurationProperty {
        /**
         * `CfnDataSource.ServiceNowConfigurationProperty.AuthenticationType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-authenticationtype
         */
        readonly authenticationType?: string;
        /**
         * `CfnDataSource.ServiceNowConfigurationProperty.HostUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-hosturl
         */
        readonly hostUrl: string;
        /**
         * `CfnDataSource.ServiceNowConfigurationProperty.KnowledgeArticleConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-knowledgearticleconfiguration
         */
        readonly knowledgeArticleConfiguration?: CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowConfigurationProperty.SecretArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-secretarn
         */
        readonly secretArn: string;
        /**
         * `CfnDataSource.ServiceNowConfigurationProperty.ServiceCatalogConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-servicecatalogconfiguration
         */
        readonly serviceCatalogConfiguration?: CfnDataSource.ServiceNowServiceCatalogConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowConfigurationProperty.ServiceNowBuildVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowconfiguration.html#cfn-kendra-datasource-servicenowconfiguration-servicenowbuildversion
         */
        readonly serviceNowBuildVersion: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html
     */
    interface ServiceNowKnowledgeArticleConfigurationProperty {
        /**
         * `CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty.CrawlAttachments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-crawlattachments
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty.DocumentDataFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-documentdatafieldname
         */
        readonly documentDataFieldName: string;
        /**
         * `CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty.DocumentTitleFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty.ExcludeAttachmentFilePatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-excludeattachmentfilepatterns
         */
        readonly excludeAttachmentFilePatterns?: string[];
        /**
         * `CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty.FieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty.FilterQuery`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-filterquery
         */
        readonly filterQuery?: string;
        /**
         * `CfnDataSource.ServiceNowKnowledgeArticleConfigurationProperty.IncludeAttachmentFilePatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowknowledgearticleconfiguration.html#cfn-kendra-datasource-servicenowknowledgearticleconfiguration-includeattachmentfilepatterns
         */
        readonly includeAttachmentFilePatterns?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html
     */
    interface ServiceNowServiceCatalogConfigurationProperty {
        /**
         * `CfnDataSource.ServiceNowServiceCatalogConfigurationProperty.CrawlAttachments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-crawlattachments
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowServiceCatalogConfigurationProperty.DocumentDataFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-documentdatafieldname
         */
        readonly documentDataFieldName: string;
        /**
         * `CfnDataSource.ServiceNowServiceCatalogConfigurationProperty.DocumentTitleFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.ServiceNowServiceCatalogConfigurationProperty.ExcludeAttachmentFilePatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-excludeattachmentfilepatterns
         */
        readonly excludeAttachmentFilePatterns?: string[];
        /**
         * `CfnDataSource.ServiceNowServiceCatalogConfigurationProperty.FieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSource.ServiceNowServiceCatalogConfigurationProperty.IncludeAttachmentFilePatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-servicenowservicecatalogconfiguration.html#cfn-kendra-datasource-servicenowservicecatalogconfiguration-includeattachmentfilepatterns
         */
        readonly includeAttachmentFilePatterns?: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html
     */
    interface SharePointConfigurationProperty {
        /**
         * `CfnDataSource.SharePointConfigurationProperty.CrawlAttachments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-crawlattachments
         */
        readonly crawlAttachments?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.DisableLocalGroups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-disablelocalgroups
         */
        readonly disableLocalGroups?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.DocumentTitleFieldName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-documenttitlefieldname
         */
        readonly documentTitleFieldName?: string;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.ExclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-exclusionpatterns
         */
        readonly exclusionPatterns?: string[];
        /**
         * `CfnDataSource.SharePointConfigurationProperty.FieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.InclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-inclusionpatterns
         */
        readonly inclusionPatterns?: string[];
        /**
         * `CfnDataSource.SharePointConfigurationProperty.SecretArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-secretarn
         */
        readonly secretArn: string;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.SharePointVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-sharepointversion
         */
        readonly sharePointVersion: string;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.SslCertificateS3Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-sslcertificates3path
         */
        readonly sslCertificateS3Path?: CfnDataSource.S3PathProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.Urls`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-urls
         */
        readonly urls: string[];
        /**
         * `CfnDataSource.SharePointConfigurationProperty.UseChangeLog`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-usechangelog
         */
        readonly useChangeLog?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.SharePointConfigurationProperty.VpcConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sharepointconfiguration.html#cfn-kendra-datasource-sharepointconfiguration-vpcconfiguration
         */
        readonly vpcConfiguration?: CfnDataSource.DataSourceVpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sqlconfiguration.html
     */
    interface SqlConfigurationProperty {
        /**
         * `CfnDataSource.SqlConfigurationProperty.QueryIdentifiersEnclosingOption`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-sqlconfiguration.html#cfn-kendra-datasource-sqlconfiguration-queryidentifiersenclosingoption
         */
        readonly queryIdentifiersEnclosingOption?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerauthenticationconfiguration.html
     */
    interface WebCrawlerAuthenticationConfigurationProperty {
        /**
         * `CfnDataSource.WebCrawlerAuthenticationConfigurationProperty.BasicAuthentication`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerauthenticationconfiguration.html#cfn-kendra-datasource-webcrawlerauthenticationconfiguration-basicauthentication
         */
        readonly basicAuthentication?: Array<CfnDataSource.WebCrawlerBasicAuthenticationProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerbasicauthentication.html
     */
    interface WebCrawlerBasicAuthenticationProperty {
        /**
         * `CfnDataSource.WebCrawlerBasicAuthenticationProperty.Credentials`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerbasicauthentication.html#cfn-kendra-datasource-webcrawlerbasicauthentication-credentials
         */
        readonly credentials: string;
        /**
         * `CfnDataSource.WebCrawlerBasicAuthenticationProperty.Host`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerbasicauthentication.html#cfn-kendra-datasource-webcrawlerbasicauthentication-host
         */
        readonly host: string;
        /**
         * `CfnDataSource.WebCrawlerBasicAuthenticationProperty.Port`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerbasicauthentication.html#cfn-kendra-datasource-webcrawlerbasicauthentication-port
         */
        readonly port: number;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html
     */
    interface WebCrawlerConfigurationProperty {
        /**
         * `CfnDataSource.WebCrawlerConfigurationProperty.AuthenticationConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-authenticationconfiguration
         */
        readonly authenticationConfiguration?: CfnDataSource.WebCrawlerAuthenticationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.WebCrawlerConfigurationProperty.CrawlDepth`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-crawldepth
         */
        readonly crawlDepth?: number;
        /**
         * `CfnDataSource.WebCrawlerConfigurationProperty.MaxContentSizePerPageInMegaBytes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-maxcontentsizeperpageinmegabytes
         */
        readonly maxContentSizePerPageInMegaBytes?: number;
        /**
         * `CfnDataSource.WebCrawlerConfigurationProperty.MaxLinksPerPage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-maxlinksperpage
         */
        readonly maxLinksPerPage?: number;
        /**
         * `CfnDataSource.WebCrawlerConfigurationProperty.MaxUrlsPerMinuteCrawlRate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-maxurlsperminutecrawlrate
         */
        readonly maxUrlsPerMinuteCrawlRate?: number;
        /**
         * `CfnDataSource.WebCrawlerConfigurationProperty.ProxyConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-proxyconfiguration
         */
        readonly proxyConfiguration?: CfnDataSource.ProxyConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.WebCrawlerConfigurationProperty.UrlExclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-urlexclusionpatterns
         */
        readonly urlExclusionPatterns?: string[];
        /**
         * `CfnDataSource.WebCrawlerConfigurationProperty.UrlInclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-urlinclusionpatterns
         */
        readonly urlInclusionPatterns?: string[];
        /**
         * `CfnDataSource.WebCrawlerConfigurationProperty.Urls`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerconfiguration.html#cfn-kendra-datasource-webcrawlerconfiguration-urls
         */
        readonly urls: CfnDataSource.WebCrawlerUrlsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerseedurlconfiguration.html
     */
    interface WebCrawlerSeedUrlConfigurationProperty {
        /**
         * `CfnDataSource.WebCrawlerSeedUrlConfigurationProperty.SeedUrls`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerseedurlconfiguration.html#cfn-kendra-datasource-webcrawlerseedurlconfiguration-seedurls
         */
        readonly seedUrls: string[];
        /**
         * `CfnDataSource.WebCrawlerSeedUrlConfigurationProperty.WebCrawlerMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerseedurlconfiguration.html#cfn-kendra-datasource-webcrawlerseedurlconfiguration-webcrawlermode
         */
        readonly webCrawlerMode?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlersitemapsconfiguration.html
     */
    interface WebCrawlerSiteMapsConfigurationProperty {
        /**
         * `CfnDataSource.WebCrawlerSiteMapsConfigurationProperty.SiteMaps`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlersitemapsconfiguration.html#cfn-kendra-datasource-webcrawlersitemapsconfiguration-sitemaps
         */
        readonly siteMaps: string[];
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerurls.html
     */
    interface WebCrawlerUrlsProperty {
        /**
         * `CfnDataSource.WebCrawlerUrlsProperty.SeedUrlConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerurls.html#cfn-kendra-datasource-webcrawlerurls-seedurlconfiguration
         */
        readonly seedUrlConfiguration?: CfnDataSource.WebCrawlerSeedUrlConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDataSource.WebCrawlerUrlsProperty.SiteMapsConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-webcrawlerurls.html#cfn-kendra-datasource-webcrawlerurls-sitemapsconfiguration
         */
        readonly siteMapsConfiguration?: CfnDataSource.WebCrawlerSiteMapsConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::DataSource`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::DataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-datasource.html
 */
export declare namespace CfnDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html
     */
    interface WorkDocsConfigurationProperty {
        /**
         * `CfnDataSource.WorkDocsConfigurationProperty.CrawlComments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html#cfn-kendra-datasource-workdocsconfiguration-crawlcomments
         */
        readonly crawlComments?: boolean | cdk.IResolvable;
        /**
         * `CfnDataSource.WorkDocsConfigurationProperty.ExclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html#cfn-kendra-datasource-workdocsconfiguration-exclusionpatterns
         */
        readonly exclusionPatterns?: string[];
        /**
         * `CfnDataSource.WorkDocsConfigurationProperty.FieldMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html#cfn-kendra-datasource-workdocsconfiguration-fieldmappings
         */
        readonly fieldMappings?: Array<CfnDataSource.DataSourceToIndexFieldMappingProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDataSource.WorkDocsConfigurationProperty.InclusionPatterns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html#cfn-kendra-datasource-workdocsconfiguration-inclusionpatterns
         */
        readonly inclusionPatterns?: string[];
        /**
         * `CfnDataSource.WorkDocsConfigurationProperty.OrganizationId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html#cfn-kendra-datasource-workdocsconfiguration-organizationid
         */
        readonly organizationId: string;
        /**
         * `CfnDataSource.WorkDocsConfigurationProperty.UseChangeLog`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-datasource-workdocsconfiguration.html#cfn-kendra-datasource-workdocsconfiguration-usechangelog
         */
        readonly useChangeLog?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::Kendra::Faq`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html
 */
export interface CfnFaqProps {
    /**
     * `AWS::Kendra::Faq.IndexId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-indexid
     */
    readonly indexId: string;
    /**
     * `AWS::Kendra::Faq.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-name
     */
    readonly name: string;
    /**
     * `AWS::Kendra::Faq.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::Kendra::Faq.S3Path`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-s3path
     */
    readonly s3Path: CfnFaq.S3PathProperty | cdk.IResolvable;
    /**
     * `AWS::Kendra::Faq.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-description
     */
    readonly description?: string;
    /**
     * `AWS::Kendra::Faq.FileFormat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-fileformat
     */
    readonly fileFormat?: string;
    /**
     * `AWS::Kendra::Faq.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Kendra::Faq`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Faq
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html
 */
export declare class CfnFaq extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Kendra::Faq";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFaq;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::Kendra::Faq.IndexId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-indexid
     */
    indexId: string;
    /**
     * `AWS::Kendra::Faq.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-name
     */
    name: string;
    /**
     * `AWS::Kendra::Faq.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-rolearn
     */
    roleArn: string;
    /**
     * `AWS::Kendra::Faq.S3Path`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-s3path
     */
    s3Path: CfnFaq.S3PathProperty | cdk.IResolvable;
    /**
     * `AWS::Kendra::Faq.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-description
     */
    description: string | undefined;
    /**
     * `AWS::Kendra::Faq.FileFormat`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-fileformat
     */
    fileFormat: string | undefined;
    /**
     * `AWS::Kendra::Faq.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html#cfn-kendra-faq-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Kendra::Faq`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFaqProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Kendra::Faq`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Faq
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-faq.html
 */
export declare namespace CfnFaq {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-faq-s3path.html
     */
    interface S3PathProperty {
        /**
         * `CfnFaq.S3PathProperty.Bucket`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-faq-s3path.html#cfn-kendra-faq-s3path-bucket
         */
        readonly bucket: string;
        /**
         * `CfnFaq.S3PathProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-faq-s3path.html#cfn-kendra-faq-s3path-key
         */
        readonly key: string;
    }
}
/**
 * Properties for defining a `AWS::Kendra::Index`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export interface CfnIndexProps {
    /**
     * `AWS::Kendra::Index.Edition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-edition
     */
    readonly edition: string;
    /**
     * `AWS::Kendra::Index.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-name
     */
    readonly name: string;
    /**
     * `AWS::Kendra::Index.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::Kendra::Index.CapacityUnits`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-capacityunits
     */
    readonly capacityUnits?: CfnIndex.CapacityUnitsConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Kendra::Index.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-description
     */
    readonly description?: string;
    /**
     * `AWS::Kendra::Index.DocumentMetadataConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-documentmetadataconfigurations
     */
    readonly documentMetadataConfigurations?: Array<CfnIndex.DocumentMetadataConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Kendra::Index.ServerSideEncryptionConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-serversideencryptionconfiguration
     */
    readonly serverSideEncryptionConfiguration?: CfnIndex.ServerSideEncryptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Kendra::Index.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::Kendra::Index.UserContextPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usercontextpolicy
     */
    readonly userContextPolicy?: string;
    /**
     * `AWS::Kendra::Index.UserTokenConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usertokenconfigurations
     */
    readonly userTokenConfigurations?: Array<CfnIndex.UserTokenConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare class CfnIndex extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Kendra::Index";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnIndex;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::Kendra::Index.Edition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-edition
     */
    edition: string;
    /**
     * `AWS::Kendra::Index.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-name
     */
    name: string;
    /**
     * `AWS::Kendra::Index.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-rolearn
     */
    roleArn: string;
    /**
     * `AWS::Kendra::Index.CapacityUnits`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-capacityunits
     */
    capacityUnits: CfnIndex.CapacityUnitsConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Kendra::Index.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-description
     */
    description: string | undefined;
    /**
     * `AWS::Kendra::Index.DocumentMetadataConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-documentmetadataconfigurations
     */
    documentMetadataConfigurations: Array<CfnIndex.DocumentMetadataConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Kendra::Index.ServerSideEncryptionConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-serversideencryptionconfiguration
     */
    serverSideEncryptionConfiguration: CfnIndex.ServerSideEncryptionConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Kendra::Index.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Kendra::Index.UserContextPolicy`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usercontextpolicy
     */
    userContextPolicy: string | undefined;
    /**
     * `AWS::Kendra::Index.UserTokenConfigurations`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html#cfn-kendra-index-usertokenconfigurations
     */
    userTokenConfigurations: Array<CfnIndex.UserTokenConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Kendra::Index`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnIndexProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html
     */
    interface CapacityUnitsConfigurationProperty {
        /**
         * `CfnIndex.CapacityUnitsConfigurationProperty.QueryCapacityUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html#cfn-kendra-index-capacityunitsconfiguration-querycapacityunits
         */
        readonly queryCapacityUnits: number;
        /**
         * `CfnIndex.CapacityUnitsConfigurationProperty.StorageCapacityUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-capacityunitsconfiguration.html#cfn-kendra-index-capacityunitsconfiguration-storagecapacityunits
         */
        readonly storageCapacityUnits: number;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html
     */
    interface DocumentMetadataConfigurationProperty {
        /**
         * `CfnIndex.DocumentMetadataConfigurationProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-name
         */
        readonly name: string;
        /**
         * `CfnIndex.DocumentMetadataConfigurationProperty.Relevance`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-relevance
         */
        readonly relevance?: CfnIndex.RelevanceProperty | cdk.IResolvable;
        /**
         * `CfnIndex.DocumentMetadataConfigurationProperty.Search`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-search
         */
        readonly search?: CfnIndex.SearchProperty | cdk.IResolvable;
        /**
         * `CfnIndex.DocumentMetadataConfigurationProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-documentmetadataconfiguration.html#cfn-kendra-index-documentmetadataconfiguration-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html
     */
    interface JsonTokenTypeConfigurationProperty {
        /**
         * `CfnIndex.JsonTokenTypeConfigurationProperty.GroupAttributeField`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html#cfn-kendra-index-jsontokentypeconfiguration-groupattributefield
         */
        readonly groupAttributeField: string;
        /**
         * `CfnIndex.JsonTokenTypeConfigurationProperty.UserNameAttributeField`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jsontokentypeconfiguration.html#cfn-kendra-index-jsontokentypeconfiguration-usernameattributefield
         */
        readonly userNameAttributeField: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html
     */
    interface JwtTokenTypeConfigurationProperty {
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.ClaimRegex`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-claimregex
         */
        readonly claimRegex?: string;
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.GroupAttributeField`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-groupattributefield
         */
        readonly groupAttributeField?: string;
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.Issuer`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-issuer
         */
        readonly issuer?: string;
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.KeyLocation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-keylocation
         */
        readonly keyLocation: string;
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.SecretManagerArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-secretmanagerarn
         */
        readonly secretManagerArn?: string;
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.URL`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-url
         */
        readonly url?: string;
        /**
         * `CfnIndex.JwtTokenTypeConfigurationProperty.UserNameAttributeField`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-jwttokentypeconfiguration.html#cfn-kendra-index-jwttokentypeconfiguration-usernameattributefield
         */
        readonly userNameAttributeField?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html
     */
    interface RelevanceProperty {
        /**
         * `CfnIndex.RelevanceProperty.Duration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-duration
         */
        readonly duration?: string;
        /**
         * `CfnIndex.RelevanceProperty.Freshness`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-freshness
         */
        readonly freshness?: boolean | cdk.IResolvable;
        /**
         * `CfnIndex.RelevanceProperty.Importance`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-importance
         */
        readonly importance?: number;
        /**
         * `CfnIndex.RelevanceProperty.RankOrder`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-rankorder
         */
        readonly rankOrder?: string;
        /**
         * `CfnIndex.RelevanceProperty.ValueImportanceItems`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-relevance.html#cfn-kendra-index-relevance-valueimportanceitems
         */
        readonly valueImportanceItems?: Array<CfnIndex.ValueImportanceItemProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html
     */
    interface SearchProperty {
        /**
         * `CfnIndex.SearchProperty.Displayable`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-displayable
         */
        readonly displayable?: boolean | cdk.IResolvable;
        /**
         * `CfnIndex.SearchProperty.Facetable`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-facetable
         */
        readonly facetable?: boolean | cdk.IResolvable;
        /**
         * `CfnIndex.SearchProperty.Searchable`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-searchable
         */
        readonly searchable?: boolean | cdk.IResolvable;
        /**
         * `CfnIndex.SearchProperty.Sortable`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-search.html#cfn-kendra-index-search-sortable
         */
        readonly sortable?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-serversideencryptionconfiguration.html
     */
    interface ServerSideEncryptionConfigurationProperty {
        /**
         * `CfnIndex.ServerSideEncryptionConfigurationProperty.KmsKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-serversideencryptionconfiguration.html#cfn-kendra-index-serversideencryptionconfiguration-kmskeyid
         */
        readonly kmsKeyId?: string;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html
     */
    interface UserTokenConfigurationProperty {
        /**
         * `CfnIndex.UserTokenConfigurationProperty.JsonTokenTypeConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html#cfn-kendra-index-usertokenconfiguration-jsontokentypeconfiguration
         */
        readonly jsonTokenTypeConfiguration?: CfnIndex.JsonTokenTypeConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnIndex.UserTokenConfigurationProperty.JwtTokenTypeConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-usertokenconfiguration.html#cfn-kendra-index-usertokenconfiguration-jwttokentypeconfiguration
         */
        readonly jwtTokenTypeConfiguration?: CfnIndex.JwtTokenTypeConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Kendra::Index`.
 *
 * @external
 * @cloudformationResource AWS::Kendra::Index
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kendra-index.html
 */
export declare namespace CfnIndex {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html
     */
    interface ValueImportanceItemProperty {
        /**
         * `CfnIndex.ValueImportanceItemProperty.Key`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html#cfn-kendra-index-valueimportanceitem-key
         */
        readonly key?: string;
        /**
         * `CfnIndex.ValueImportanceItemProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kendra-index-valueimportanceitem.html#cfn-kendra-index-valueimportanceitem-value
         */
        readonly value?: number;
    }
}
