# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[str],
                 autogenerate_revision_name: Optional[pulumi.Input[bool]] = None,
                 metadata: Optional[pulumi.Input['ServiceMetadataArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input['ServiceTemplateArgs']] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input[bool] autogenerate_revision_name: If set to `true`, the revision name (template.metadata.name) will be omitted and
               autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
               is also set.
               (For legacy support, if `template.metadata.name` is unset in state while
               this field is set to false, the revision name will still autogenerate.)
        :param pulumi.Input['ServiceMetadataArgs'] metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.
               Structure is documented below.
        :param pulumi.Input[str] name: Volume's name.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['ServiceTemplateArgs'] template: template holds the latest specification for the Revision to
               be stamped out. The template references the container image, and may also
               include labels and annotations that should be attached to the Revision.
               To correlate a Revision, and/or to force a Revision to be created when the
               spec doesn't otherwise change, a nonce label may be provided in the
               template metadata. For more details, see:
               https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions
               Cloud Run does not currently support referencing a build that is
               responsible for materializing the container image from source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        if autogenerate_revision_name is not None:
            pulumi.set(__self__, "autogenerate_revision_name", autogenerate_revision_name)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if traffics is not None:
            pulumi.set(__self__, "traffics", traffics)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location of the cloud run instance. eg us-central1
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="autogenerateRevisionName")
    def autogenerate_revision_name(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the revision name (template.metadata.name) will be omitted and
        autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
        is also set.
        (For legacy support, if `template.metadata.name` is unset in state while
        this field is set to false, the revision name will still autogenerate.)
        """
        return pulumi.get(self, "autogenerate_revision_name")

    @autogenerate_revision_name.setter
    def autogenerate_revision_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autogenerate_revision_name", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['ServiceMetadataArgs']]:
        """
        Metadata associated with this Service, including name, namespace, labels,
        and annotations.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['ServiceMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['ServiceTemplateArgs']]:
        """
        template holds the latest specification for the Revision to
        be stamped out. The template references the container image, and may also
        include labels and annotations that should be attached to the Revision.
        To correlate a Revision, and/or to force a Revision to be created when the
        spec doesn't otherwise change, a nonce label may be provided in the
        template metadata. For more details, see:
        https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions
        Cloud Run does not currently support referencing a build that is
        responsible for materializing the container image from source.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['ServiceTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def traffics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]:
        """
        Traffic specifies how to distribute traffic over a collection of Knative Revisions
        and Configurations
        Structure is documented below.
        """
        return pulumi.get(self, "traffics")

    @traffics.setter
    def traffics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]):
        pulumi.set(self, "traffics", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 autogenerate_revision_name: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input['ServiceMetadataArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceStatusArgs']]]] = None,
                 template: Optional[pulumi.Input['ServiceTemplateArgs']] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input[bool] autogenerate_revision_name: If set to `true`, the revision name (template.metadata.name) will be omitted and
               autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
               is also set.
               (For legacy support, if `template.metadata.name` is unset in state while
               this field is set to false, the revision name will still autogenerate.)
        :param pulumi.Input[str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input['ServiceMetadataArgs'] metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.
               Structure is documented below.
        :param pulumi.Input[str] name: Volume's name.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceStatusArgs']]] statuses: The current status of the Service.
        :param pulumi.Input['ServiceTemplateArgs'] template: template holds the latest specification for the Revision to
               be stamped out. The template references the container image, and may also
               include labels and annotations that should be attached to the Revision.
               To correlate a Revision, and/or to force a Revision to be created when the
               spec doesn't otherwise change, a nonce label may be provided in the
               template metadata. For more details, see:
               https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions
               Cloud Run does not currently support referencing a build that is
               responsible for materializing the container image from source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations
               Structure is documented below.
        """
        if autogenerate_revision_name is not None:
            pulumi.set(__self__, "autogenerate_revision_name", autogenerate_revision_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if statuses is not None:
            pulumi.set(__self__, "statuses", statuses)
        if template is not None:
            pulumi.set(__self__, "template", template)
        if traffics is not None:
            pulumi.set(__self__, "traffics", traffics)

    @property
    @pulumi.getter(name="autogenerateRevisionName")
    def autogenerate_revision_name(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, the revision name (template.metadata.name) will be omitted and
        autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
        is also set.
        (For legacy support, if `template.metadata.name` is unset in state while
        this field is set to false, the revision name will still autogenerate.)
        """
        return pulumi.get(self, "autogenerate_revision_name")

    @autogenerate_revision_name.setter
    def autogenerate_revision_name(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autogenerate_revision_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the cloud run instance. eg us-central1
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['ServiceMetadataArgs']]:
        """
        Metadata associated with this Service, including name, namespace, labels,
        and annotations.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['ServiceMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceStatusArgs']]]]:
        """
        The current status of the Service.
        """
        return pulumi.get(self, "statuses")

    @statuses.setter
    def statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceStatusArgs']]]]):
        pulumi.set(self, "statuses", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input['ServiceTemplateArgs']]:
        """
        template holds the latest specification for the Revision to
        be stamped out. The template references the container image, and may also
        include labels and annotations that should be attached to the Revision.
        To correlate a Revision, and/or to force a Revision to be created when the
        spec doesn't otherwise change, a nonce label may be provided in the
        template metadata. For more details, see:
        https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions
        Cloud Run does not currently support referencing a build that is
        responsible for materializing the container image from source.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input['ServiceTemplateArgs']]):
        pulumi.set(self, "template", value)

    @property
    @pulumi.getter
    def traffics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]:
        """
        Traffic specifies how to distribute traffic over a collection of Knative Revisions
        and Configurations
        Structure is documented below.
        """
        return pulumi.get(self, "traffics")

    @traffics.setter
    def traffics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceTrafficArgs']]]]):
        pulumi.set(self, "traffics", value)


class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autogenerate_revision_name: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[pulumi.InputType['ServiceMetadataArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['ServiceTemplateArgs']]] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]]] = None,
                 __props__=None):
        """
        Service acts as a top-level container that manages a set of Routes and
        Configurations which implement a network service. Service exists to provide a
        singular abstraction which can be access controlled, reasoned about, and
        which encapsulates software lifecycle decisions such as rollout policy and
        team resource ownership. Service acts only as an orchestrator of the
        underlying Routes and Configurations (much as a kubernetes Deployment
        orchestrates ReplicaSets).

        The Service's controller will track the statuses of its owned Configuration
        and Route, reflecting their statuses and conditions as its own.

        See also:
        https://github.com/knative/serving/blob/master/docs/spec/overview.md#service

        To get more information about Service, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        > **Warning:** `google_cloudrun_service` creates a Managed Google Cloud Run Service. If you need to create
        a Cloud Run Service on Anthos(GKE/VMWare) then you will need to create it using the kubernetes alpha provider.
        Have a look at the Cloud Run Anthos example below.

        ## Example Usage
        ### Cloud Run Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
            ),
            traffics=[gcp.cloudrun.ServiceTrafficArgs(
                latest_revision=True,
                percent=100,
            )])
        ```
        ### Cloud Run Service Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            region="us-east1",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
            ),
            deletion_protection=True)
        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
                metadata=gcp.cloudrun.ServiceTemplateMetadataArgs(
                    annotations={
                        "autoscaling.knative.dev/maxScale": "1000",
                        "run.googleapis.com/cloudsql-instances": instance.connection_name,
                        "run.googleapis.com/client-name": "demo",
                    },
                ),
            ),
            autogenerate_revision_name=True)
        ```
        ### Cloud Run Service Noauth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
            ))
        noauth_iam_policy = gcp.organizations.get_iam_policy(bindings=[gcp.organizations.GetIAMPolicyBindingArgs(
            role="roles/run.invoker",
            members=["allUsers"],
        )])
        noauth_iam_policy = gcp.cloudrun.IamPolicy("noauthIamPolicy",
            location=default.location,
            project=default.project,
            service=default.name,
            policy_data=noauth_iam_policy.policy_data)
        ```
        ### Cloud Run Service Multiple Environment Variables

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                        envs=[
                            gcp.cloudrun.ServiceTemplateSpecContainerEnvArgs(
                                name="SOURCE",
                                value="remote",
                            ),
                            gcp.cloudrun.ServiceTemplateSpecContainerEnvArgs(
                                name="TARGET",
                                value="home",
                            ),
                        ],
                    )],
                ),
            ),
            metadata=gcp.cloudrun.ServiceMetadataArgs(
                annotations={
                    "generated-by": "magic-modules",
                },
            ),
            traffics=[gcp.cloudrun.ServiceTrafficArgs(
                percent=100,
                latest_revision=True,
            )],
            autogenerate_revision_name=True)
        ```
        ### Cloud Run Service Traffic Split

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                metadata=gcp.cloudrun.ServiceTemplateMetadataArgs(
                    name="cloudrun-srv-green",
                ),
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
            ),
            traffics=[
                gcp.cloudrun.ServiceTrafficArgs(
                    percent=25,
                    revision_name="cloudrun-srv-green",
                ),
                gcp.cloudrun.ServiceTrafficArgs(
                    percent=75,
                    revision_name="cloudrun-srv-blue",
                ),
            ])
        ```
        ### Cloud Run Service Secret Environment Variables

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data",
            opts=pulumi.ResourceOptions(provider=google_beta))
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[secret]))
        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="gcr.io/cloudrun/hello",
                        envs=[gcp.cloudrun.ServiceTemplateSpecContainerEnvArgs(
                            name="SECRET_ENV_VAR",
                            value_from=gcp.cloudrun.ServiceTemplateSpecContainerEnvValueFromArgs(
                                secret_key_ref=gcp.cloudrun.ServiceTemplateSpecContainerEnvValueFromSecretKeyRefArgs(
                                    name=secret.secret_id,
                                    key="1",
                                ),
                            ),
                        )],
                    )],
                ),
            ),
            metadata=gcp.cloudrun.ServiceMetadataArgs(
                annotations={
                    "generated-by": "magic-modules",
                    "run.googleapis.com/launch-stage": "BETA",
                },
            ),
            traffics=[gcp.cloudrun.ServiceTrafficArgs(
                percent=100,
                latest_revision=True,
            )],
            autogenerate_revision_name=True,
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[secret_version_data]))
        ```
        ### Cloud Run Service Secret Volumes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data",
            opts=pulumi.ResourceOptions(provider=google_beta))
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[secret]))
        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="gcr.io/cloudrun/hello",
                        volume_mounts=[gcp.cloudrun.ServiceTemplateSpecContainerVolumeMountArgs(
                            name="a-volume",
                            mount_path="/secrets",
                        )],
                    )],
                    volumes=[gcp.cloudrun.ServiceTemplateSpecVolumeArgs(
                        name="a-volume",
                        secret=gcp.cloudrun.ServiceTemplateSpecVolumeSecretArgs(
                            secret_name=secret.secret_id,
                            items=[gcp.cloudrun.ServiceTemplateSpecVolumeSecretItemArgs(
                                key="1",
                                path="my-secret",
                            )],
                        ),
                    )],
                ),
            ),
            metadata=gcp.cloudrun.ServiceMetadataArgs(
                annotations={
                    "generated-by": "magic-modules",
                    "run.googleapis.com/launch-stage": "BETA",
                },
            ),
            traffics=[gcp.cloudrun.ServiceTrafficArgs(
                percent=100,
                latest_revision=True,
            )],
            autogenerate_revision_name=True,
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[secret_version_data]))
        ```

        ## Import

        Service can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:cloudrun/service:Service default locations/{{location}}/namespaces/{{project}}/services/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrun/service:Service default {{location}}/{{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrun/service:Service default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] autogenerate_revision_name: If set to `true`, the revision name (template.metadata.name) will be omitted and
               autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
               is also set.
               (For legacy support, if `template.metadata.name` is unset in state while
               this field is set to false, the revision name will still autogenerate.)
        :param pulumi.Input[str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input[pulumi.InputType['ServiceMetadataArgs']] metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.
               Structure is documented below.
        :param pulumi.Input[str] name: Volume's name.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['ServiceTemplateArgs']] template: template holds the latest specification for the Revision to
               be stamped out. The template references the container image, and may also
               include labels and annotations that should be attached to the Revision.
               To correlate a Revision, and/or to force a Revision to be created when the
               spec doesn't otherwise change, a nonce label may be provided in the
               template metadata. For more details, see:
               https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions
               Cloud Run does not currently support referencing a build that is
               responsible for materializing the container image from source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Service acts as a top-level container that manages a set of Routes and
        Configurations which implement a network service. Service exists to provide a
        singular abstraction which can be access controlled, reasoned about, and
        which encapsulates software lifecycle decisions such as rollout policy and
        team resource ownership. Service acts only as an orchestrator of the
        underlying Routes and Configurations (much as a kubernetes Deployment
        orchestrates ReplicaSets).

        The Service's controller will track the statuses of its owned Configuration
        and Route, reflecting their statuses and conditions as its own.

        See also:
        https://github.com/knative/serving/blob/master/docs/spec/overview.md#service

        To get more information about Service, see:

        * [API documentation](https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/run/docs/)

        > **Warning:** `google_cloudrun_service` creates a Managed Google Cloud Run Service. If you need to create
        a Cloud Run Service on Anthos(GKE/VMWare) then you will need to create it using the kubernetes alpha provider.
        Have a look at the Cloud Run Anthos example below.

        ## Example Usage
        ### Cloud Run Service Basic

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
            ),
            traffics=[gcp.cloudrun.ServiceTrafficArgs(
                latest_revision=True,
                percent=100,
            )])
        ```
        ### Cloud Run Service Sql

        ```python
        import pulumi
        import pulumi_gcp as gcp

        instance = gcp.sql.DatabaseInstance("instance",
            region="us-east1",
            settings=gcp.sql.DatabaseInstanceSettingsArgs(
                tier="db-f1-micro",
            ),
            deletion_protection=True)
        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
                metadata=gcp.cloudrun.ServiceTemplateMetadataArgs(
                    annotations={
                        "autoscaling.knative.dev/maxScale": "1000",
                        "run.googleapis.com/cloudsql-instances": instance.connection_name,
                        "run.googleapis.com/client-name": "demo",
                    },
                ),
            ),
            autogenerate_revision_name=True)
        ```
        ### Cloud Run Service Noauth

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
            ))
        noauth_iam_policy = gcp.organizations.get_iam_policy(bindings=[gcp.organizations.GetIAMPolicyBindingArgs(
            role="roles/run.invoker",
            members=["allUsers"],
        )])
        noauth_iam_policy = gcp.cloudrun.IamPolicy("noauthIamPolicy",
            location=default.location,
            project=default.project,
            service=default.name,
            policy_data=noauth_iam_policy.policy_data)
        ```
        ### Cloud Run Service Multiple Environment Variables

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                        envs=[
                            gcp.cloudrun.ServiceTemplateSpecContainerEnvArgs(
                                name="SOURCE",
                                value="remote",
                            ),
                            gcp.cloudrun.ServiceTemplateSpecContainerEnvArgs(
                                name="TARGET",
                                value="home",
                            ),
                        ],
                    )],
                ),
            ),
            metadata=gcp.cloudrun.ServiceMetadataArgs(
                annotations={
                    "generated-by": "magic-modules",
                },
            ),
            traffics=[gcp.cloudrun.ServiceTrafficArgs(
                percent=100,
                latest_revision=True,
            )],
            autogenerate_revision_name=True)
        ```
        ### Cloud Run Service Traffic Split

        ```python
        import pulumi
        import pulumi_gcp as gcp

        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                metadata=gcp.cloudrun.ServiceTemplateMetadataArgs(
                    name="cloudrun-srv-green",
                ),
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="us-docker.pkg.dev/cloudrun/container/hello",
                    )],
                ),
            ),
            traffics=[
                gcp.cloudrun.ServiceTrafficArgs(
                    percent=25,
                    revision_name="cloudrun-srv-green",
                ),
                gcp.cloudrun.ServiceTrafficArgs(
                    percent=75,
                    revision_name="cloudrun-srv-blue",
                ),
            ])
        ```
        ### Cloud Run Service Secret Environment Variables

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data",
            opts=pulumi.ResourceOptions(provider=google_beta))
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[secret]))
        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="gcr.io/cloudrun/hello",
                        envs=[gcp.cloudrun.ServiceTemplateSpecContainerEnvArgs(
                            name="SECRET_ENV_VAR",
                            value_from=gcp.cloudrun.ServiceTemplateSpecContainerEnvValueFromArgs(
                                secret_key_ref=gcp.cloudrun.ServiceTemplateSpecContainerEnvValueFromSecretKeyRefArgs(
                                    name=secret.secret_id,
                                    key="1",
                                ),
                            ),
                        )],
                    )],
                ),
            ),
            metadata=gcp.cloudrun.ServiceMetadataArgs(
                annotations={
                    "generated-by": "magic-modules",
                    "run.googleapis.com/launch-stage": "BETA",
                },
            ),
            traffics=[gcp.cloudrun.ServiceTrafficArgs(
                percent=100,
                latest_revision=True,
            )],
            autogenerate_revision_name=True,
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[secret_version_data]))
        ```
        ### Cloud Run Service Secret Volumes

        ```python
        import pulumi
        import pulumi_gcp as gcp

        project = gcp.organizations.get_project()
        secret = gcp.secretmanager.Secret("secret",
            secret_id="secret",
            replication=gcp.secretmanager.SecretReplicationArgs(
                automatic=True,
            ),
            opts=pulumi.ResourceOptions(provider=google_beta))
        secret_version_data = gcp.secretmanager.SecretVersion("secret-version-data",
            secret=secret.name,
            secret_data="secret-data",
            opts=pulumi.ResourceOptions(provider=google_beta))
        secret_access = gcp.secretmanager.SecretIamMember("secret-access",
            secret_id=secret.id,
            role="roles/secretmanager.secretAccessor",
            member=f"serviceAccount:{project.number}-compute@developer.gserviceaccount.com",
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[secret]))
        default = gcp.cloudrun.Service("default",
            location="us-central1",
            template=gcp.cloudrun.ServiceTemplateArgs(
                spec=gcp.cloudrun.ServiceTemplateSpecArgs(
                    containers=[gcp.cloudrun.ServiceTemplateSpecContainerArgs(
                        image="gcr.io/cloudrun/hello",
                        volume_mounts=[gcp.cloudrun.ServiceTemplateSpecContainerVolumeMountArgs(
                            name="a-volume",
                            mount_path="/secrets",
                        )],
                    )],
                    volumes=[gcp.cloudrun.ServiceTemplateSpecVolumeArgs(
                        name="a-volume",
                        secret=gcp.cloudrun.ServiceTemplateSpecVolumeSecretArgs(
                            secret_name=secret.secret_id,
                            items=[gcp.cloudrun.ServiceTemplateSpecVolumeSecretItemArgs(
                                key="1",
                                path="my-secret",
                            )],
                        ),
                    )],
                ),
            ),
            metadata=gcp.cloudrun.ServiceMetadataArgs(
                annotations={
                    "generated-by": "magic-modules",
                    "run.googleapis.com/launch-stage": "BETA",
                },
            ),
            traffics=[gcp.cloudrun.ServiceTrafficArgs(
                percent=100,
                latest_revision=True,
            )],
            autogenerate_revision_name=True,
            opts=pulumi.ResourceOptions(provider=google_beta,
                depends_on=[secret_version_data]))
        ```

        ## Import

        Service can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:cloudrun/service:Service default locations/{{location}}/namespaces/{{project}}/services/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrun/service:Service default {{location}}/{{project}}/{{name}}
        ```

        ```sh
         $ pulumi import gcp:cloudrun/service:Service default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autogenerate_revision_name: Optional[pulumi.Input[bool]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[pulumi.InputType['ServiceMetadataArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[pulumi.InputType['ServiceTemplateArgs']]] = None,
                 traffics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["autogenerate_revision_name"] = autogenerate_revision_name
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["template"] = template
            __props__.__dict__["traffics"] = traffics
            __props__.__dict__["statuses"] = None
        super(Service, __self__).__init__(
            'gcp:cloudrun/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autogenerate_revision_name: Optional[pulumi.Input[bool]] = None,
            location: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[pulumi.InputType['ServiceMetadataArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            statuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceStatusArgs']]]]] = None,
            template: Optional[pulumi.Input[pulumi.InputType['ServiceTemplateArgs']]] = None,
            traffics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] autogenerate_revision_name: If set to `true`, the revision name (template.metadata.name) will be omitted and
               autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
               is also set.
               (For legacy support, if `template.metadata.name` is unset in state while
               this field is set to false, the revision name will still autogenerate.)
        :param pulumi.Input[str] location: The location of the cloud run instance. eg us-central1
        :param pulumi.Input[pulumi.InputType['ServiceMetadataArgs']] metadata: Metadata associated with this Service, including name, namespace, labels,
               and annotations.
               Structure is documented below.
        :param pulumi.Input[str] name: Volume's name.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceStatusArgs']]]] statuses: The current status of the Service.
        :param pulumi.Input[pulumi.InputType['ServiceTemplateArgs']] template: template holds the latest specification for the Revision to
               be stamped out. The template references the container image, and may also
               include labels and annotations that should be attached to the Revision.
               To correlate a Revision, and/or to force a Revision to be created when the
               spec doesn't otherwise change, a nonce label may be provided in the
               template metadata. For more details, see:
               https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions
               Cloud Run does not currently support referencing a build that is
               responsible for materializing the container image from source.
               Structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceTrafficArgs']]]] traffics: Traffic specifies how to distribute traffic over a collection of Knative Revisions
               and Configurations
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["autogenerate_revision_name"] = autogenerate_revision_name
        __props__.__dict__["location"] = location
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["statuses"] = statuses
        __props__.__dict__["template"] = template
        __props__.__dict__["traffics"] = traffics
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autogenerateRevisionName")
    def autogenerate_revision_name(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to `true`, the revision name (template.metadata.name) will be omitted and
        autogenerated by Cloud Run. This cannot be set to `true` while `template.metadata.name`
        is also set.
        (For legacy support, if `template.metadata.name` is unset in state while
        this field is set to false, the revision name will still autogenerate.)
        """
        return pulumi.get(self, "autogenerate_revision_name")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location of the cloud run instance. eg us-central1
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.ServiceMetadata']:
        """
        Metadata associated with this Service, including name, namespace, labels,
        and annotations.
        Structure is documented below.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def statuses(self) -> pulumi.Output[Sequence['outputs.ServiceStatus']]:
        """
        The current status of the Service.
        """
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def template(self) -> pulumi.Output[Optional['outputs.ServiceTemplate']]:
        """
        template holds the latest specification for the Revision to
        be stamped out. The template references the container image, and may also
        include labels and annotations that should be attached to the Revision.
        To correlate a Revision, and/or to force a Revision to be created when the
        spec doesn't otherwise change, a nonce label may be provided in the
        template metadata. For more details, see:
        https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions
        Cloud Run does not currently support referencing a build that is
        responsible for materializing the container image from source.
        Structure is documented below.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def traffics(self) -> pulumi.Output[Sequence['outputs.ServiceTraffic']]:
        """
        Traffic specifies how to distribute traffic over a collection of Knative Revisions
        and Configurations
        Structure is documented below.
        """
        return pulumi.get(self, "traffics")

