# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BucketObjectArgs', 'BucketObject']

@pulumi.input_type
class BucketObjectArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 cache_control: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_encoding: Optional[pulumi.Input[str]] = None,
                 content_language: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 detect_md5hash: Optional[pulumi.Input[str]] = None,
                 event_based_hold: Optional[pulumi.Input[bool]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 temporary_hold: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a BucketObject resource.
        :param pulumi.Input[str] bucket: The name of the containing bucket.
        :param pulumi.Input[str] cache_control: [Cache-Control](https://tools.ietf.org/html/rfc7234#section-5.2)
               directive to specify caching behavior of object data. If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
        :param pulumi.Input[str] content: Data as `string` to be uploaded. Must be defined if `source` is not. **Note**: The `content` field is marked as sensitive.
        :param pulumi.Input[str] content_disposition: [Content-Disposition](https://tools.ietf.org/html/rfc6266) of the object data.
        :param pulumi.Input[str] content_encoding: [Content-Encoding](https://tools.ietf.org/html/rfc7231#section-3.1.2.2) of the object data.
        :param pulumi.Input[str] content_language: [Content-Language](https://tools.ietf.org/html/rfc7231#section-3.1.3.2) of the object data.
        :param pulumi.Input[str] content_type: [Content-Type](https://tools.ietf.org/html/rfc7231#section-3.1.1.5) of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
        :param pulumi.Input[bool] event_based_hold: Whether an object is under event-based hold. Event-based hold is a way to retain objects until an event occurs, which is
               signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects
               will be subject to bucket-level retention (if any).
        :param pulumi.Input[str] kms_key_name: The resource name of the Cloud KMS key that will be used to [encrypt](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) the object.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: User-provided metadata, in key/value pairs.
        :param pulumi.Input[str] name: The name of the object. If you're interpolating the name of this object, see `output_name` instead.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: A path to the data you want to upload. Must be defined
               if `content` is not.
        :param pulumi.Input[str] storage_class: The [StorageClass](https://cloud.google.com/storage/docs/storage-classes) of the new bucket object.
               Supported values include: `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`. If not provided, this defaults to the bucket's default
               storage class or to a [standard](https://cloud.google.com/storage/docs/storage-classes#standard) class.
        :param pulumi.Input[bool] temporary_hold: Whether an object is under temporary hold. While this flag is set to true, the object is protected against deletion and
               overwrites.
        """
        pulumi.set(__self__, "bucket", bucket)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_language is not None:
            pulumi.set(__self__, "content_language", content_language)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if detect_md5hash is not None:
            pulumi.set(__self__, "detect_md5hash", detect_md5hash)
        if event_based_hold is not None:
            pulumi.set(__self__, "event_based_hold", event_based_hold)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if temporary_hold is not None:
            pulumi.set(__self__, "temporary_hold", temporary_hold)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The name of the containing bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[str]]:
        """
        [Cache-Control](https://tools.ietf.org/html/rfc7234#section-5.2)
        directive to specify caching behavior of object data. If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_control", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        Data as `string` to be uploaded. Must be defined if `source` is not. **Note**: The `content` field is marked as sensitive.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        [Content-Disposition](https://tools.ietf.org/html/rfc6266) of the object data.
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_disposition", value)

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[str]]:
        """
        [Content-Encoding](https://tools.ietf.org/html/rfc7231#section-3.1.2.2) of the object data.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_encoding", value)

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> Optional[pulumi.Input[str]]:
        """
        [Content-Language](https://tools.ietf.org/html/rfc7231#section-3.1.3.2) of the object data.
        """
        return pulumi.get(self, "content_language")

    @content_language.setter
    def content_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_language", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        [Content-Type](https://tools.ietf.org/html/rfc7231#section-3.1.1.5) of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter(name="detectMd5hash")
    def detect_md5hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "detect_md5hash")

    @detect_md5hash.setter
    def detect_md5hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "detect_md5hash", value)

    @property
    @pulumi.getter(name="eventBasedHold")
    def event_based_hold(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether an object is under event-based hold. Event-based hold is a way to retain objects until an event occurs, which is
        signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects
        will be subject to bucket-level retention (if any).
        """
        return pulumi.get(self, "event_based_hold")

    @event_based_hold.setter
    def event_based_hold(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "event_based_hold", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the Cloud KMS key that will be used to [encrypt](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) the object.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-provided metadata, in key/value pairs.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the object. If you're interpolating the name of this object, see `output_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]:
        """
        A path to the data you want to upload. Must be defined
        if `content` is not.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        The [StorageClass](https://cloud.google.com/storage/docs/storage-classes) of the new bucket object.
        Supported values include: `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`. If not provided, this defaults to the bucket's default
        storage class or to a [standard](https://cloud.google.com/storage/docs/storage-classes#standard) class.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter(name="temporaryHold")
    def temporary_hold(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether an object is under temporary hold. While this flag is set to true, the object is protected against deletion and
        overwrites.
        """
        return pulumi.get(self, "temporary_hold")

    @temporary_hold.setter
    def temporary_hold(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "temporary_hold", value)


@pulumi.input_type
class _BucketObjectState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 cache_control: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_encoding: Optional[pulumi.Input[str]] = None,
                 content_language: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 crc32c: Optional[pulumi.Input[str]] = None,
                 detect_md5hash: Optional[pulumi.Input[str]] = None,
                 event_based_hold: Optional[pulumi.Input[bool]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 md5hash: Optional[pulumi.Input[str]] = None,
                 media_link: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 output_name: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 temporary_hold: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering BucketObject resources.
        :param pulumi.Input[str] bucket: The name of the containing bucket.
        :param pulumi.Input[str] cache_control: [Cache-Control](https://tools.ietf.org/html/rfc7234#section-5.2)
               directive to specify caching behavior of object data. If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
        :param pulumi.Input[str] content: Data as `string` to be uploaded. Must be defined if `source` is not. **Note**: The `content` field is marked as sensitive.
        :param pulumi.Input[str] content_disposition: [Content-Disposition](https://tools.ietf.org/html/rfc6266) of the object data.
        :param pulumi.Input[str] content_encoding: [Content-Encoding](https://tools.ietf.org/html/rfc7231#section-3.1.2.2) of the object data.
        :param pulumi.Input[str] content_language: [Content-Language](https://tools.ietf.org/html/rfc7231#section-3.1.3.2) of the object data.
        :param pulumi.Input[str] content_type: [Content-Type](https://tools.ietf.org/html/rfc7231#section-3.1.1.5) of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
        :param pulumi.Input[str] crc32c: (Computed) Base 64 CRC32 hash of the uploaded data.
        :param pulumi.Input[bool] event_based_hold: Whether an object is under event-based hold. Event-based hold is a way to retain objects until an event occurs, which is
               signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects
               will be subject to bucket-level retention (if any).
        :param pulumi.Input[str] kms_key_name: The resource name of the Cloud KMS key that will be used to [encrypt](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) the object.
        :param pulumi.Input[str] md5hash: (Computed) Base 64 MD5 hash of the uploaded data.
        :param pulumi.Input[str] media_link: (Computed) A url reference to download this object.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: User-provided metadata, in key/value pairs.
        :param pulumi.Input[str] name: The name of the object. If you're interpolating the name of this object, see `output_name` instead.
        :param pulumi.Input[str] output_name: (Computed) The name of the object. Use this field in interpolations with `storage.ObjectACL` to recreate
               `storage.ObjectACL` resources when your `storage.BucketObject` is recreated.
        :param pulumi.Input[str] self_link: (Computed) A url reference to this object.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: A path to the data you want to upload. Must be defined
               if `content` is not.
        :param pulumi.Input[str] storage_class: The [StorageClass](https://cloud.google.com/storage/docs/storage-classes) of the new bucket object.
               Supported values include: `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`. If not provided, this defaults to the bucket's default
               storage class or to a [standard](https://cloud.google.com/storage/docs/storage-classes#standard) class.
        :param pulumi.Input[bool] temporary_hold: Whether an object is under temporary hold. While this flag is set to true, the object is protected against deletion and
               overwrites.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if cache_control is not None:
            pulumi.set(__self__, "cache_control", cache_control)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if content_disposition is not None:
            pulumi.set(__self__, "content_disposition", content_disposition)
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_language is not None:
            pulumi.set(__self__, "content_language", content_language)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if crc32c is not None:
            pulumi.set(__self__, "crc32c", crc32c)
        if detect_md5hash is not None:
            pulumi.set(__self__, "detect_md5hash", detect_md5hash)
        if event_based_hold is not None:
            pulumi.set(__self__, "event_based_hold", event_based_hold)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if md5hash is not None:
            pulumi.set(__self__, "md5hash", md5hash)
        if media_link is not None:
            pulumi.set(__self__, "media_link", media_link)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_name is not None:
            pulumi.set(__self__, "output_name", output_name)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)
        if temporary_hold is not None:
            pulumi.set(__self__, "temporary_hold", temporary_hold)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the containing bucket.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> Optional[pulumi.Input[str]]:
        """
        [Cache-Control](https://tools.ietf.org/html/rfc7234#section-5.2)
        directive to specify caching behavior of object data. If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
        """
        return pulumi.get(self, "cache_control")

    @cache_control.setter
    def cache_control(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cache_control", value)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        Data as `string` to be uploaded. Must be defined if `source` is not. **Note**: The `content` field is marked as sensitive.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        [Content-Disposition](https://tools.ietf.org/html/rfc6266) of the object data.
        """
        return pulumi.get(self, "content_disposition")

    @content_disposition.setter
    def content_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_disposition", value)

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[pulumi.Input[str]]:
        """
        [Content-Encoding](https://tools.ietf.org/html/rfc7231#section-3.1.2.2) of the object data.
        """
        return pulumi.get(self, "content_encoding")

    @content_encoding.setter
    def content_encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_encoding", value)

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> Optional[pulumi.Input[str]]:
        """
        [Content-Language](https://tools.ietf.org/html/rfc7231#section-3.1.3.2) of the object data.
        """
        return pulumi.get(self, "content_language")

    @content_language.setter
    def content_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_language", value)

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[str]]:
        """
        [Content-Type](https://tools.ietf.org/html/rfc7231#section-3.1.1.5) of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_type", value)

    @property
    @pulumi.getter
    def crc32c(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed) Base 64 CRC32 hash of the uploaded data.
        """
        return pulumi.get(self, "crc32c")

    @crc32c.setter
    def crc32c(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "crc32c", value)

    @property
    @pulumi.getter(name="detectMd5hash")
    def detect_md5hash(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "detect_md5hash")

    @detect_md5hash.setter
    def detect_md5hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "detect_md5hash", value)

    @property
    @pulumi.getter(name="eventBasedHold")
    def event_based_hold(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether an object is under event-based hold. Event-based hold is a way to retain objects until an event occurs, which is
        signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects
        will be subject to bucket-level retention (if any).
        """
        return pulumi.get(self, "event_based_hold")

    @event_based_hold.setter
    def event_based_hold(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "event_based_hold", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the Cloud KMS key that will be used to [encrypt](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) the object.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)

    @property
    @pulumi.getter
    def md5hash(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed) Base 64 MD5 hash of the uploaded data.
        """
        return pulumi.get(self, "md5hash")

    @md5hash.setter
    def md5hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "md5hash", value)

    @property
    @pulumi.getter(name="mediaLink")
    def media_link(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed) A url reference to download this object.
        """
        return pulumi.get(self, "media_link")

    @media_link.setter
    def media_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_link", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-provided metadata, in key/value pairs.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the object. If you're interpolating the name of this object, see `output_name` instead.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="outputName")
    def output_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed) The name of the object. Use this field in interpolations with `storage.ObjectACL` to recreate
        `storage.ObjectACL` resources when your `storage.BucketObject` is recreated.
        """
        return pulumi.get(self, "output_name")

    @output_name.setter
    def output_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output_name", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        (Computed) A url reference to this object.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]:
        """
        A path to the data you want to upload. Must be defined
        if `content` is not.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        The [StorageClass](https://cloud.google.com/storage/docs/storage-classes) of the new bucket object.
        Supported values include: `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`. If not provided, this defaults to the bucket's default
        storage class or to a [standard](https://cloud.google.com/storage/docs/storage-classes#standard) class.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)

    @property
    @pulumi.getter(name="temporaryHold")
    def temporary_hold(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether an object is under temporary hold. While this flag is set to true, the object is protected against deletion and
        overwrites.
        """
        return pulumi.get(self, "temporary_hold")

    @temporary_hold.setter
    def temporary_hold(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "temporary_hold", value)


class BucketObject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 cache_control: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_encoding: Optional[pulumi.Input[str]] = None,
                 content_language: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 detect_md5hash: Optional[pulumi.Input[str]] = None,
                 event_based_hold: Optional[pulumi.Input[bool]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 temporary_hold: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Creates a new object inside an existing bucket in Google cloud storage service (GCS).
        [ACLs](https://cloud.google.com/storage/docs/access-control/lists) can be applied using the `storage.ObjectACL` resource.
         For more information see
        [the official documentation](https://cloud.google.com/storage/docs/key-terms#objects)
        and
        [API](https://cloud.google.com/storage/docs/json_api/v1/objects).

        ## Example Usage

        Example creating a public object in an existing `image-store` bucket.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        picture = gcp.storage.BucketObject("picture",
            bucket="image-store",
            source=pulumi.FileAsset("/images/nature/garden-tiger-moth.jpg"))
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket: The name of the containing bucket.
        :param pulumi.Input[str] cache_control: [Cache-Control](https://tools.ietf.org/html/rfc7234#section-5.2)
               directive to specify caching behavior of object data. If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
        :param pulumi.Input[str] content: Data as `string` to be uploaded. Must be defined if `source` is not. **Note**: The `content` field is marked as sensitive.
        :param pulumi.Input[str] content_disposition: [Content-Disposition](https://tools.ietf.org/html/rfc6266) of the object data.
        :param pulumi.Input[str] content_encoding: [Content-Encoding](https://tools.ietf.org/html/rfc7231#section-3.1.2.2) of the object data.
        :param pulumi.Input[str] content_language: [Content-Language](https://tools.ietf.org/html/rfc7231#section-3.1.3.2) of the object data.
        :param pulumi.Input[str] content_type: [Content-Type](https://tools.ietf.org/html/rfc7231#section-3.1.1.5) of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
        :param pulumi.Input[bool] event_based_hold: Whether an object is under event-based hold. Event-based hold is a way to retain objects until an event occurs, which is
               signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects
               will be subject to bucket-level retention (if any).
        :param pulumi.Input[str] kms_key_name: The resource name of the Cloud KMS key that will be used to [encrypt](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) the object.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: User-provided metadata, in key/value pairs.
        :param pulumi.Input[str] name: The name of the object. If you're interpolating the name of this object, see `output_name` instead.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: A path to the data you want to upload. Must be defined
               if `content` is not.
        :param pulumi.Input[str] storage_class: The [StorageClass](https://cloud.google.com/storage/docs/storage-classes) of the new bucket object.
               Supported values include: `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`. If not provided, this defaults to the bucket's default
               storage class or to a [standard](https://cloud.google.com/storage/docs/storage-classes#standard) class.
        :param pulumi.Input[bool] temporary_hold: Whether an object is under temporary hold. While this flag is set to true, the object is protected against deletion and
               overwrites.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketObjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new object inside an existing bucket in Google cloud storage service (GCS).
        [ACLs](https://cloud.google.com/storage/docs/access-control/lists) can be applied using the `storage.ObjectACL` resource.
         For more information see
        [the official documentation](https://cloud.google.com/storage/docs/key-terms#objects)
        and
        [API](https://cloud.google.com/storage/docs/json_api/v1/objects).

        ## Example Usage

        Example creating a public object in an existing `image-store` bucket.

        ```python
        import pulumi
        import pulumi_gcp as gcp

        picture = gcp.storage.BucketObject("picture",
            bucket="image-store",
            source=pulumi.FileAsset("/images/nature/garden-tiger-moth.jpg"))
        ```

        ## Import

        This resource does not support import.

        :param str resource_name: The name of the resource.
        :param BucketObjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketObjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 cache_control: Optional[pulumi.Input[str]] = None,
                 content: Optional[pulumi.Input[str]] = None,
                 content_disposition: Optional[pulumi.Input[str]] = None,
                 content_encoding: Optional[pulumi.Input[str]] = None,
                 content_language: Optional[pulumi.Input[str]] = None,
                 content_type: Optional[pulumi.Input[str]] = None,
                 detect_md5hash: Optional[pulumi.Input[str]] = None,
                 event_based_hold: Optional[pulumi.Input[bool]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 temporary_hold: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketObjectArgs.__new__(BucketObjectArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["cache_control"] = cache_control
            __props__.__dict__["content"] = content
            __props__.__dict__["content_disposition"] = content_disposition
            __props__.__dict__["content_encoding"] = content_encoding
            __props__.__dict__["content_language"] = content_language
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["detect_md5hash"] = detect_md5hash
            __props__.__dict__["event_based_hold"] = event_based_hold
            __props__.__dict__["kms_key_name"] = kms_key_name
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["source"] = source
            __props__.__dict__["storage_class"] = storage_class
            __props__.__dict__["temporary_hold"] = temporary_hold
            __props__.__dict__["crc32c"] = None
            __props__.__dict__["md5hash"] = None
            __props__.__dict__["media_link"] = None
            __props__.__dict__["output_name"] = None
            __props__.__dict__["self_link"] = None
        super(BucketObject, __self__).__init__(
            'gcp:storage/bucketObject:BucketObject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            cache_control: Optional[pulumi.Input[str]] = None,
            content: Optional[pulumi.Input[str]] = None,
            content_disposition: Optional[pulumi.Input[str]] = None,
            content_encoding: Optional[pulumi.Input[str]] = None,
            content_language: Optional[pulumi.Input[str]] = None,
            content_type: Optional[pulumi.Input[str]] = None,
            crc32c: Optional[pulumi.Input[str]] = None,
            detect_md5hash: Optional[pulumi.Input[str]] = None,
            event_based_hold: Optional[pulumi.Input[bool]] = None,
            kms_key_name: Optional[pulumi.Input[str]] = None,
            md5hash: Optional[pulumi.Input[str]] = None,
            media_link: Optional[pulumi.Input[str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            output_name: Optional[pulumi.Input[str]] = None,
            self_link: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[Union[pulumi.Asset, pulumi.Archive]]] = None,
            storage_class: Optional[pulumi.Input[str]] = None,
            temporary_hold: Optional[pulumi.Input[bool]] = None) -> 'BucketObject':
        """
        Get an existing BucketObject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket: The name of the containing bucket.
        :param pulumi.Input[str] cache_control: [Cache-Control](https://tools.ietf.org/html/rfc7234#section-5.2)
               directive to specify caching behavior of object data. If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
        :param pulumi.Input[str] content: Data as `string` to be uploaded. Must be defined if `source` is not. **Note**: The `content` field is marked as sensitive.
        :param pulumi.Input[str] content_disposition: [Content-Disposition](https://tools.ietf.org/html/rfc6266) of the object data.
        :param pulumi.Input[str] content_encoding: [Content-Encoding](https://tools.ietf.org/html/rfc7231#section-3.1.2.2) of the object data.
        :param pulumi.Input[str] content_language: [Content-Language](https://tools.ietf.org/html/rfc7231#section-3.1.3.2) of the object data.
        :param pulumi.Input[str] content_type: [Content-Type](https://tools.ietf.org/html/rfc7231#section-3.1.1.5) of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
        :param pulumi.Input[str] crc32c: (Computed) Base 64 CRC32 hash of the uploaded data.
        :param pulumi.Input[bool] event_based_hold: Whether an object is under event-based hold. Event-based hold is a way to retain objects until an event occurs, which is
               signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects
               will be subject to bucket-level retention (if any).
        :param pulumi.Input[str] kms_key_name: The resource name of the Cloud KMS key that will be used to [encrypt](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) the object.
        :param pulumi.Input[str] md5hash: (Computed) Base 64 MD5 hash of the uploaded data.
        :param pulumi.Input[str] media_link: (Computed) A url reference to download this object.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: User-provided metadata, in key/value pairs.
        :param pulumi.Input[str] name: The name of the object. If you're interpolating the name of this object, see `output_name` instead.
        :param pulumi.Input[str] output_name: (Computed) The name of the object. Use this field in interpolations with `storage.ObjectACL` to recreate
               `storage.ObjectACL` resources when your `storage.BucketObject` is recreated.
        :param pulumi.Input[str] self_link: (Computed) A url reference to this object.
        :param pulumi.Input[Union[pulumi.Asset, pulumi.Archive]] source: A path to the data you want to upload. Must be defined
               if `content` is not.
        :param pulumi.Input[str] storage_class: The [StorageClass](https://cloud.google.com/storage/docs/storage-classes) of the new bucket object.
               Supported values include: `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`. If not provided, this defaults to the bucket's default
               storage class or to a [standard](https://cloud.google.com/storage/docs/storage-classes#standard) class.
        :param pulumi.Input[bool] temporary_hold: Whether an object is under temporary hold. While this flag is set to true, the object is protected against deletion and
               overwrites.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketObjectState.__new__(_BucketObjectState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["cache_control"] = cache_control
        __props__.__dict__["content"] = content
        __props__.__dict__["content_disposition"] = content_disposition
        __props__.__dict__["content_encoding"] = content_encoding
        __props__.__dict__["content_language"] = content_language
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["crc32c"] = crc32c
        __props__.__dict__["detect_md5hash"] = detect_md5hash
        __props__.__dict__["event_based_hold"] = event_based_hold
        __props__.__dict__["kms_key_name"] = kms_key_name
        __props__.__dict__["md5hash"] = md5hash
        __props__.__dict__["media_link"] = media_link
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["output_name"] = output_name
        __props__.__dict__["self_link"] = self_link
        __props__.__dict__["source"] = source
        __props__.__dict__["storage_class"] = storage_class
        __props__.__dict__["temporary_hold"] = temporary_hold
        return BucketObject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        The name of the containing bucket.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="cacheControl")
    def cache_control(self) -> pulumi.Output[Optional[str]]:
        """
        [Cache-Control](https://tools.ietf.org/html/rfc7234#section-5.2)
        directive to specify caching behavior of object data. If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
        """
        return pulumi.get(self, "cache_control")

    @property
    @pulumi.getter
    def content(self) -> pulumi.Output[Optional[str]]:
        """
        Data as `string` to be uploaded. Must be defined if `source` is not. **Note**: The `content` field is marked as sensitive.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="contentDisposition")
    def content_disposition(self) -> pulumi.Output[Optional[str]]:
        """
        [Content-Disposition](https://tools.ietf.org/html/rfc6266) of the object data.
        """
        return pulumi.get(self, "content_disposition")

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> pulumi.Output[Optional[str]]:
        """
        [Content-Encoding](https://tools.ietf.org/html/rfc7231#section-3.1.2.2) of the object data.
        """
        return pulumi.get(self, "content_encoding")

    @property
    @pulumi.getter(name="contentLanguage")
    def content_language(self) -> pulumi.Output[Optional[str]]:
        """
        [Content-Language](https://tools.ietf.org/html/rfc7231#section-3.1.3.2) of the object data.
        """
        return pulumi.get(self, "content_language")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[str]:
        """
        [Content-Type](https://tools.ietf.org/html/rfc7231#section-3.1.1.5) of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def crc32c(self) -> pulumi.Output[str]:
        """
        (Computed) Base 64 CRC32 hash of the uploaded data.
        """
        return pulumi.get(self, "crc32c")

    @property
    @pulumi.getter(name="detectMd5hash")
    def detect_md5hash(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "detect_md5hash")

    @property
    @pulumi.getter(name="eventBasedHold")
    def event_based_hold(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether an object is under event-based hold. Event-based hold is a way to retain objects until an event occurs, which is
        signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects
        will be subject to bucket-level retention (if any).
        """
        return pulumi.get(self, "event_based_hold")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Output[str]:
        """
        The resource name of the Cloud KMS key that will be used to [encrypt](https://cloud.google.com/storage/docs/encryption/using-customer-managed-keys) the object.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter
    def md5hash(self) -> pulumi.Output[str]:
        """
        (Computed) Base 64 MD5 hash of the uploaded data.
        """
        return pulumi.get(self, "md5hash")

    @property
    @pulumi.getter(name="mediaLink")
    def media_link(self) -> pulumi.Output[str]:
        """
        (Computed) A url reference to download this object.
        """
        return pulumi.get(self, "media_link")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        User-provided metadata, in key/value pairs.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the object. If you're interpolating the name of this object, see `output_name` instead.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputName")
    def output_name(self) -> pulumi.Output[str]:
        """
        (Computed) The name of the object. Use this field in interpolations with `storage.ObjectACL` to recreate
        `storage.ObjectACL` resources when your `storage.BucketObject` is recreated.
        """
        return pulumi.get(self, "output_name")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        (Computed) A url reference to this object.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[Union[pulumi.Asset, pulumi.Archive]]]:
        """
        A path to the data you want to upload. Must be defined
        if `content` is not.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Output[str]:
        """
        The [StorageClass](https://cloud.google.com/storage/docs/storage-classes) of the new bucket object.
        Supported values include: `MULTI_REGIONAL`, `REGIONAL`, `NEARLINE`, `COLDLINE`, `ARCHIVE`. If not provided, this defaults to the bucket's default
        storage class or to a [standard](https://cloud.google.com/storage/docs/storage-classes#standard) class.
        """
        return pulumi.get(self, "storage_class")

    @property
    @pulumi.getter(name="temporaryHold")
    def temporary_hold(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether an object is under temporary hold. While this flag is set to true, the object is protected against deletion and
        overwrites.
        """
        return pulumi.get(self, "temporary_hold")

