As we have discussed in earlier sections, agent services can execute arbitrary operations in a decentralized way.
There is a great deal of applications where the properties of agent services make them better suited than existing solutions,
especially in the context of DAOs and where complex operations are required to be executed in a decentralized and transparent way. Agent services remove the need of strong trust assumptions that traditional centralized off-chain services require.

Below you will find some ideas of what you can do with agent services:

## Internal DAO operations
* **Meta Yield Hunter**:
Use machine learning to track yield opportunities across chains and protocols. Autonomously move positions to optimize yield.

* **Asset Whitelisting**:
Dynamically evaluates assets based on diverse datasets to add and remove from whitelists.

* **Contribution Coordinator:**
Watch for contributions on GitHub, Twitter etc and adjust on-chain rewards & permissions accordingly.

## New services
* **Web3-native Recommender**:
Build the first co-owned and operated engines to track opportunities and make personalized recommendations to crypto users.

* **NFT Collector**:
Allow users to passively build exposure to quality baskets of NFTs.

* **Fund Manager:**
Overcome the legal and trust challenges of running a decentralized fund.

## Customizable app infrastructure
* **Oracles** (On-chain Data Reporter):
Build future-proof oracles that are totally customizable, without permission, and owned by you.

* **Keepers**:
Build robust keeper systems that you can extend to maintain any on-chain data, based on a rich set of criteria which you define.

* **Bridges** (Cross-chain Messenger):
Spin up your own bridges to sync any type of data across chains and infrastructure. Combine with your oracles and keepers to build rich new services.
