# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://docs.mailslurp.com/) - [Examples](https://github.com/mailslurp/examples) repository  # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Contact: contact@mailslurp.dev
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class WebhookBouncePayload(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'message_id': 'str',
        'webhook_id': 'str',
        'event_name': 'str',
        'webhook_name': 'str',
        'bounce_id': 'str',
        'sent_to_recipients': 'list[str]',
        'sender': 'str',
        'bounce_recipients': 'list[str]'
    }

    attribute_map = {
        'message_id': 'messageId',
        'webhook_id': 'webhookId',
        'event_name': 'eventName',
        'webhook_name': 'webhookName',
        'bounce_id': 'bounceId',
        'sent_to_recipients': 'sentToRecipients',
        'sender': 'sender',
        'bounce_recipients': 'bounceRecipients'
    }

    def __init__(self, message_id=None, webhook_id=None, event_name=None, webhook_name=None, bounce_id=None, sent_to_recipients=None, sender=None, bounce_recipients=None, local_vars_configuration=None):  # noqa: E501
        """WebhookBouncePayload - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._message_id = None
        self._webhook_id = None
        self._event_name = None
        self._webhook_name = None
        self._bounce_id = None
        self._sent_to_recipients = None
        self._sender = None
        self._bounce_recipients = None
        self.discriminator = None

        self.message_id = message_id
        self.webhook_id = webhook_id
        self.event_name = event_name
        if webhook_name is not None:
            self.webhook_name = webhook_name
        self.bounce_id = bounce_id
        if sent_to_recipients is not None:
            self.sent_to_recipients = sent_to_recipients
        self.sender = sender
        if bounce_recipients is not None:
            self.bounce_recipients = bounce_recipients

    @property
    def message_id(self):
        """Gets the message_id of this WebhookBouncePayload.  # noqa: E501

        Idempotent message ID. Store this ID locally or in a database to prevent message duplication.  # noqa: E501

        :return: The message_id of this WebhookBouncePayload.  # noqa: E501
        :rtype: str
        """
        return self._message_id

    @message_id.setter
    def message_id(self, message_id):
        """Sets the message_id of this WebhookBouncePayload.

        Idempotent message ID. Store this ID locally or in a database to prevent message duplication.  # noqa: E501

        :param message_id: The message_id of this WebhookBouncePayload.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and message_id is None:  # noqa: E501
            raise ValueError("Invalid value for `message_id`, must not be `None`")  # noqa: E501

        self._message_id = message_id

    @property
    def webhook_id(self):
        """Gets the webhook_id of this WebhookBouncePayload.  # noqa: E501

        ID of webhook entity being triggered  # noqa: E501

        :return: The webhook_id of this WebhookBouncePayload.  # noqa: E501
        :rtype: str
        """
        return self._webhook_id

    @webhook_id.setter
    def webhook_id(self, webhook_id):
        """Sets the webhook_id of this WebhookBouncePayload.

        ID of webhook entity being triggered  # noqa: E501

        :param webhook_id: The webhook_id of this WebhookBouncePayload.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and webhook_id is None:  # noqa: E501
            raise ValueError("Invalid value for `webhook_id`, must not be `None`")  # noqa: E501

        self._webhook_id = webhook_id

    @property
    def event_name(self):
        """Gets the event_name of this WebhookBouncePayload.  # noqa: E501

        Name of the event type webhook is being triggered for.  # noqa: E501

        :return: The event_name of this WebhookBouncePayload.  # noqa: E501
        :rtype: str
        """
        return self._event_name

    @event_name.setter
    def event_name(self, event_name):
        """Sets the event_name of this WebhookBouncePayload.

        Name of the event type webhook is being triggered for.  # noqa: E501

        :param event_name: The event_name of this WebhookBouncePayload.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and event_name is None:  # noqa: E501
            raise ValueError("Invalid value for `event_name`, must not be `None`")  # noqa: E501
        allowed_values = ["EMAIL_RECEIVED", "NEW_EMAIL", "NEW_CONTACT", "NEW_ATTACHMENT", "EMAIL_OPENED", "EMAIL_READ", "BOUNCE", "BOUNCE_RECIPIENT"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and event_name not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `event_name` ({0}), must be one of {1}"  # noqa: E501
                .format(event_name, allowed_values)
            )

        self._event_name = event_name

    @property
    def webhook_name(self):
        """Gets the webhook_name of this WebhookBouncePayload.  # noqa: E501

        Name of the webhook being triggered  # noqa: E501

        :return: The webhook_name of this WebhookBouncePayload.  # noqa: E501
        :rtype: str
        """
        return self._webhook_name

    @webhook_name.setter
    def webhook_name(self, webhook_name):
        """Sets the webhook_name of this WebhookBouncePayload.

        Name of the webhook being triggered  # noqa: E501

        :param webhook_name: The webhook_name of this WebhookBouncePayload.  # noqa: E501
        :type: str
        """

        self._webhook_name = webhook_name

    @property
    def bounce_id(self):
        """Gets the bounce_id of this WebhookBouncePayload.  # noqa: E501

        ID of the bounce email record. Use the ID with the bounce controller to view more information  # noqa: E501

        :return: The bounce_id of this WebhookBouncePayload.  # noqa: E501
        :rtype: str
        """
        return self._bounce_id

    @bounce_id.setter
    def bounce_id(self, bounce_id):
        """Sets the bounce_id of this WebhookBouncePayload.

        ID of the bounce email record. Use the ID with the bounce controller to view more information  # noqa: E501

        :param bounce_id: The bounce_id of this WebhookBouncePayload.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and bounce_id is None:  # noqa: E501
            raise ValueError("Invalid value for `bounce_id`, must not be `None`")  # noqa: E501

        self._bounce_id = bounce_id

    @property
    def sent_to_recipients(self):
        """Gets the sent_to_recipients of this WebhookBouncePayload.  # noqa: E501


        :return: The sent_to_recipients of this WebhookBouncePayload.  # noqa: E501
        :rtype: list[str]
        """
        return self._sent_to_recipients

    @sent_to_recipients.setter
    def sent_to_recipients(self, sent_to_recipients):
        """Sets the sent_to_recipients of this WebhookBouncePayload.


        :param sent_to_recipients: The sent_to_recipients of this WebhookBouncePayload.  # noqa: E501
        :type: list[str]
        """

        self._sent_to_recipients = sent_to_recipients

    @property
    def sender(self):
        """Gets the sender of this WebhookBouncePayload.  # noqa: E501


        :return: The sender of this WebhookBouncePayload.  # noqa: E501
        :rtype: str
        """
        return self._sender

    @sender.setter
    def sender(self, sender):
        """Sets the sender of this WebhookBouncePayload.


        :param sender: The sender of this WebhookBouncePayload.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and sender is None:  # noqa: E501
            raise ValueError("Invalid value for `sender`, must not be `None`")  # noqa: E501

        self._sender = sender

    @property
    def bounce_recipients(self):
        """Gets the bounce_recipients of this WebhookBouncePayload.  # noqa: E501

        Email addresses that resulted in a bounce or email being rejected. Please save these recipients and avoid emailing them in the future to maintain your reputation.  # noqa: E501

        :return: The bounce_recipients of this WebhookBouncePayload.  # noqa: E501
        :rtype: list[str]
        """
        return self._bounce_recipients

    @bounce_recipients.setter
    def bounce_recipients(self, bounce_recipients):
        """Sets the bounce_recipients of this WebhookBouncePayload.

        Email addresses that resulted in a bounce or email being rejected. Please save these recipients and avoid emailing them in the future to maintain your reputation.  # noqa: E501

        :param bounce_recipients: The bounce_recipients of this WebhookBouncePayload.  # noqa: E501
        :type: list[str]
        """

        self._bounce_recipients = bounce_recipients

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WebhookBouncePayload):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WebhookBouncePayload):
            return True

        return self.to_dict() != other.to_dict()
