"""Tests for the Bulb API with a light strip."""
from typing import AsyncGenerator

import pytest

from pywizlight import wizlight
from pywizlight.bulblibrary import BulbClass, BulbType, Features
from pywizlight.tests.fake_bulb import startup_bulb


@pytest.fixture()
async def unknown_bulb() -> AsyncGenerator[wizlight, None]:
    shutdown, port = await startup_bulb(
        module_name="1.8.0-MISSING-TYPEID-1", firmware_version="1.8.0"
    )
    bulb = wizlight(ip="127.0.0.1", port=port)
    yield bulb
    await bulb.async_close()
    shutdown()


@pytest.mark.asyncio
async def test_model_description_unknown_bulb(
    unknown_bulb: wizlight, caplog: pytest.LogCaptureFixture
) -> None:
    """Test fetching the model description for an unknown bulb."""
    bulb_type = await unknown_bulb.get_bulbtype()
    assert bulb_type == BulbType(
        features=Features(
            color=False, color_tmp=False, effect=True, brightness=True, dual_head=False
        ),
        name=None,
        kelvin_range=None,
        bulb_type=BulbClass.DW,
        fw_version="1.8.0",
        white_channels=1,
        white_to_color_ratio=20,
    )
    assert (
        "Unknown typeId: 1, please report what kind of bulb this is at https://github.com/sbidy/pywizlight/issues/new"
        in caplog.text
    )
