# -*- coding: utf-8 -*-
# Generated by Django 1.11.13 on 2018-06-07 02:42
from __future__ import unicode_literals

from django.db import migrations

# NOTE: The name of the constrait is generated by Django ORM.
UNIQUE_INDEX_NAME = 'rest_framework_reactive_item_observer_id_order_9b8adde6_uniq'


class Migration(migrations.Migration):

    dependencies = [('rest_framework_reactive', '0001_initial')]

    operations = [
        migrations.RunSQL(
            [
                # Drop old constraint.
                "ALTER TABLE rest_framework_reactive_item DROP CONSTRAINT {}".format(
                    UNIQUE_INDEX_NAME
                ),
                # Re-create the unique index.
                "CREATE UNIQUE INDEX {} ON rest_framework_reactive_item (observer_id, \"order\")".format(
                    UNIQUE_INDEX_NAME
                ),
                # Create new deferrable constraint.
                """ALTER TABLE rest_framework_reactive_item ADD CONSTRAINT
                {0} UNIQUE USING INDEX {0} DEFERRABLE INITIALLY IMMEDIATE""".format(
                    UNIQUE_INDEX_NAME
                ),
            ]
        )
    ]
