# Jovian: Learning Platform for Data Science & ML.

<img src="/docs/jovian_horizontal_logo.svg" width="480">

[![Documentation Status](https://readthedocs.org/projects/jovian-py/badge/?version=latest)](https://jovian.ai/docs/)
[![Python application](https://github.com/JovianML/jovian-py/workflows/Python%20application/badge.svg)](https://github.com/JovianML/jovian-py/actions?query=branch%3Amaster)
[![Code Coverage](https://codecov.io/gh/JovianML/jovian-py/branch/master/graph/badge.svg)](https://codecov.io/gh/JovianML/jovian-py)

[Jovian](https://www.jovian.ai?utm_source) is a platform for sharing and collaboraring on Jupyter notebooks and data science projects. `jovian-py` is an open-source Python package for uploading your data science code, Jupyter notebooks, ML models, hyperparameters, metrics etc. to your Jovian account.

- [Upload and share Jupyter Notebooks](https://jovian.ai/docs/user-guide/upload.html)
- [Reproduce Notebooks from Jovian](https://jovian.ai/docs/user-guide/reproduce.html)
- [Notebooks as version, view Diffs between versions](https://jovian.ai/docs/user-guide/version.html)
- [Attaching utility files and model outputs with the Notebook](https://jovian.ai/docs/user-guide/attach.html)
- [Tracking Datasets, Hyperparameters and Metrics](https://jovian.ai/docs/user-guide/track.html)
- [Comparing and Analyzing all the experiments](https://jovian.ai/docs/user-guide/compare.html)
- [Collaborate with teammates/colleagues](https://jovian.ai/docs/user-guide/collaborate.html)
- [Stay connected with your model training, live updates with Slack Notifications](https://jovian.ai/docs/user-guide/integrations.html)
- [Embed Jupyter Notebooks and Cell upload on Jovian](https://jovian.ai/docs/user-guide/embed.html)

## Installation

```
pip install jovian --upgrade
```

> **Caution**:
>
> If you get a `Permission denied` error, try installing with sudo permission (on Linux/Mac).
>
> ```
> sudo pip install jovian --upgrade
> ```
>
> Another alternative is to try installing with the `--user` flag, but you’ll need to ensure that the target directory is added to your system `PATH`.
>
> ```
> pip install jovian --upgrade --user
> ```

Visit [Docs](https://jovian.ai/docs/) for more.

## Contribution Guidelines

If you want to contribute to **jovian**(Python package), review the [**Contribution Page**](https://github.com/JovianML/jovian-py/blob/master/CONTRIBUTING.md).

<table>
    <tr>
        <th> </th>
        <th>Jovian(Python Package)</th>
        <th>Jovian(Webapp)</th>
    </tr>
    <tr>
        <td>Issues or Feature Request</td>
        <td align="center"> <a href="https://github.com/JovianML/jovian-py/issues" target="_blank">Forum</a> </td>
        <td align="center"> <a href="https://jovian.ai/forum/c/help/22" target="_blank">Forum</a> </td>
    </tr>
    <tr>
        <td>Repository and Website</td>
        <td align="center"> <a href="https://github.com/JovianML" target="_blank">Repo</a> </td>
        <td align="center"> <a href="https://www.jovian.ai/?utm_source=github" target="_blank">Website</a> </td>
    </tr>
    <tr>
        <td>Slack Discussions</td>
        <td align="center" colspan=2> <a href="https://bit.ly/jovian-users" rel="noopener noreferrer" target="_blank">Slack Invite</a> </td>
    </tr>
</table>

## Contact

Mail : hello@jovian.ai
<br/>
Forum: [Data Science Forum](https://jovian.ai/forum/)
<br/>
Twitter : [@JovianML](https://twitter.com/JovianML)
<br/>
YouTube: [YouTube Channel](https://www.youtube.com/jovianml)
<br/>
LinkedIn: [LinkedIn Page](https://www.linkedin.com/company/jovianml/)
