
#
# this file is generated by generate_type_stubs.py
#

from typing import List, Optional, Sequence, Tuple
from chia.types.blockchain_format.sized_bytes import bytes32

ReadableBuffer = Union[bytes, bytearray, memoryview]

def compute_merkle_set_root(items: Sequence[bytes]) -> bytes: ...

def run_generator(
    program: bytes, args: bytes, max_cost: int, flags: int
) -> Tuple[Optional[int], Optional[SpendBundleConditions]]: ...

COND_ARGS_NIL: int = ...
NO_UNKNOWN_CONDS: int = ...
STRICT_ARGS_COUNT: int = ...
MEMPOOL_MODE: int = ...

NO_NEG_DIV: int = ...
NO_UNKNOWN_OPS: int = ...

def run_chia_program(
    program: bytes, args: bytes, max_cost: int, flags: int
) -> Pair[int, LazyNode]: ...

class LazyNode:
    def pair() -> Optional[Tuple[LazyNode, LazyNode]]: ...
    def atom() -> bytes: ...

def serialized_length(program: bytes) -> int: ...
def tree_hash(program: ReadableBuffer) -> bytes32: ...
def get_puzzle_and_solution_for_coin(program: bytes, args: bytes, max_cost: int, find_parent: bytes32, find_amount: int, find_ph: bytes32) -> Tuple[bytes, bytes]: ...

class Spend:
    coin_id: bytes
    puzzle_hash: bytes
    height_relative: Optional[int]
    seconds_relative: int
    create_coin: List[Tuple[bytes, int, Optional[bytes]]]
    agg_sig_me: List[Tuple[bytes, bytes]]
    def __init__(
        self,
        coin_id: bytes,
        puzzle_hash: bytes,
        height_relative: Optional[int],
        seconds_relative: int,
        create_coin: Sequence[Tuple[bytes, int, Optional[bytes]]],
        agg_sig_me: Sequence[Tuple[bytes, bytes]]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> Spend: ...
    def __copy__(self) -> Spend: ...
    @staticmethod
    def from_bytes(bytes) -> Spend: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[Spend, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> Spend: ...

class SpendBundleConditions:
    spends: List[Spend]
    reserve_fee: int
    height_absolute: int
    seconds_absolute: int
    agg_sig_unsafe: List[Tuple[bytes, bytes]]
    cost: int
    def __init__(
        self,
        spends: Sequence[Spend],
        reserve_fee: int,
        height_absolute: int,
        seconds_absolute: int,
        agg_sig_unsafe: Sequence[Tuple[bytes, bytes]],
        cost: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> SpendBundleConditions: ...
    def __copy__(self) -> SpendBundleConditions: ...
    @staticmethod
    def from_bytes(bytes) -> SpendBundleConditions: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[SpendBundleConditions, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> SpendBundleConditions: ...

class Coin:
    parent_coin_info: bytes32
    puzzle_hash: bytes32
    amount: int
    def name(self) -> bytes32: ...
    def __init__(
        self,
        parent_coin_info: bytes,
        puzzle_hash: bytes,
        amount: int
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> Coin: ...
    def __copy__(self) -> Coin: ...
    @staticmethod
    def from_bytes(bytes) -> Coin: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[Coin, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> Coin: ...

class CoinState:
    coin: Coin
    spent_height: Optional[int]
    created_height: Optional[int]
    def __init__(
        self,
        coin: Coin,
        spent_height: Optional[int],
        created_height: Optional[int]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> CoinState: ...
    def __copy__(self) -> CoinState: ...
    @staticmethod
    def from_bytes(bytes) -> CoinState: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[CoinState, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> CoinState: ...

class RespondToPhUpdates:
    puzzle_hashes: List[bytes32]
    min_height: int
    coin_states: List[CoinState]
    def __init__(
        self,
        puzzle_hashes: Sequence[bytes32],
        min_height: int,
        coin_states: Sequence[CoinState]
    ) -> None: ...
    def __hash__(self) -> int: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __richcmp__(self) -> Any: ...
    def __deepcopy__(self) -> RespondToPhUpdates: ...
    def __copy__(self) -> RespondToPhUpdates: ...
    @staticmethod
    def from_bytes(bytes) -> RespondToPhUpdates: ...
    @staticmethod
    def parse_rust(ReadableBuffer) -> Tuple[RespondToPhUpdates, int]: ...
    def to_bytes(self) -> bytes: ...
    def __bytes__(self) -> bytes: ...
    def get_hash(self) -> bytes32: ...
    def to_json_dict(self) -> Dict[str, Any]: ...
    @staticmethod
    def from_json_dict(o: Dict[str, Any]) -> RespondToPhUpdates: ...
