#!/usr/bin/env python3
#
# GlobalChem - FDA List Four
#
# -------------------------

class FDAListFour(object):

    def __init__(self):

        self.name = 'fda_color_additive_list_four'

    @staticmethod
    def get_smiles():

        smiles = {
            'algae meal, dried': '[*:1].C(C1C(C(C(C(O1)OC2(C(C(C(O2)CO)O)O)CO)O)O)O)O.C(C1C(C(C(C(O1)O)O)O)O)O.C1C(C(C(C(O1)(CO)O)O)O)O.C1(C(C(C(C(C1OP(=O)([O-])[O-])OP(=O)([O-])[O-])OP(=O)([O-])[O-])OP(=O)([O-])[O-])OP(=O)([O-])[O-])OP(=O)([O-])[O-].[Ca+2].[Ca+2].[Ca+2].[Ca+2].[Ca+2].[Ca+2].CCOC1=CC2=C(C=C1)NC(C=C2C)(C)C',
            'annatto extract': 'CC(=CC=CC=C(C)C=CC=C(C)C=CC(=O)O)C=CC=C(C)C=CC(=O)O',
            'astaxanthin': 'CC1=C(C(CC(C1=O)O)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC2=C(C(=O)C(CC2(C)C)O)C)C)C',
            'astaxanthin dimethyldisuccinate': 'CC1=C(C(CC(C1=O)O)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC2=C(C(=O)C(CC2(C)C)O)C)C)C.COC(=O)CCC(=O)OC',
            'beet juice': 'CC1=C(SC=[N+]1CC2=CN=C(N=C2N)C)CCO.CC1=CC2=C(C=C1C)N(C3=NC(=O)NC(=O)C3=N2)CC(C(C(CO)O)O)O.C1=CC(=CN=C1)C(=O)N.CC(C)(CO)C(C(=O)NCCC(=O)O)O.CC1=NC=C(C(=C1O)CO)CO.C1=CC(=CC=C1C(=O)NC(CCC(=O)O)C(=O)O)NCC2=CN=C3C(=N2)C(=O)NC(=N3)N.CC1=CC2=C(C=C1C)N(C=N2)C3C(C(C(O3)CO)OP(=O)([O-])OC(C)CNC(=O)CCC4(C(C5C6(C(C(C(=N6)C(=C7C(C(C(=N7)C=C8C(C(C(=N8)C(=C4[N-]5)C)CCC(=O)N)(C)C)CCC(=O)N)(C)CC(=O)N)C)CCC(=O)N)(C)CC(=O)N)C)CC(=O)N)C)O.[C-]#N.[Co+3].CC1(CCC2(CCC3(C(=CCC4C3(CCC5C4(CCC(C5(C)COS(=O)(=O)O)O)C)C)C2C1)C)C(=O)O)C.CC1COC(C2C1C3C(C3(C)C)CCC2(C)O)O.CC1=C(C(CCC1)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC2=C(CCCC2(C)C)C)C)C.C1=CC=C2C(=C1)C=CC(=O)O2.C1=CC(=CC=C1C=CC(=O)OCC2C(C(C(C(O2)OC3=C(OC4=CC(=CC(=C4C3=O)O)O)C5=CC=C(C=C5)O)O)O)O)O.C1=CC(=CC=C1C2=C(C(=O)C3=C(C=C(C=C3O2)O)O)OC4C(C(C(C(O4)CO)O)O)O)O.COC1=CC(=C2C(=C1)OC(=C(C2=O)O)C3=CC=C(C=C3)O)O.COC1=CC(=C2C(=C1)OC(=C(C2=O)O)C3=CC(=C(C=C3)O)O)O.C1=CC(=CC=C1C2=C(C(=O)C3=C(C=C(C=C3O2)O)O)O)O.C1=CC=C(C=C1)O.CC1(C2CCC3(C(C2(CCC1OC4C(C(C(CO4)OC5C(C(C(CO5)O)O)O)OC6C(C(C(C(O6)CO)O)O)O)OC7C(C(C(C(O7)CO)O)O)OC8C(C(C(C(O8)CO)O)O)O)C)CCC91C3(CC(C2(C9CC(CC2)(C)C=O)CO1)O)C)C)C.C1C2C(CC(N2)(C(C1O)O)O)O.C1CC2(C(C(C(C1N2)O)O)O)O.C1C(C2C(C(C(C1(N2)O)O)O)O)O.C1CC2(C(C(C(C1N2)O)O)O)O.CC1=C(CN2CCCC2C1)C3=CC=C(C=C3)OC4C(C(C(C(O4)COC(=O)C=CC5=CC=C(C=C5)O)O)O)O.CC(C(C(=O)O)N)O.CC(C)C(C(=O)O)N.C(C(C(=O)O)N)SSCC(C(=O)O)N.CSCCC(C(=O)O)N.CCC(C)C(C(=O)O)N.CC(C)CC(C(=O)O)N.C(CCN)CC(C(=O)O)N.C1=CC=C(C=C1)CC(C(=O)O)N.C1=C(NC=N1)CC(C(=O)O)N.C(CC(C(=O)O)N)CN=C(N)N.C(CC(=O)O)C(C(=O)O)N.C1CC(NC1)C(=O)O.CC(C(=O)O)N.C1=CC(=CC=C1CC(C(=O)O)N)O.[Mn].[Mg].[K].[Na].[Fe].[Zn].[Cu].[B].[Se].O=[Si]=O',
            'beet powder': 'CC1=C(SC=[N+]1CC2=CN=C(N=C2N)C)CCO.CC1=CC2=C(C=C1C)N(C3=NC(=O)NC(=O)C3=N2)CC(C(C(CO)O)O)O.C1=CC(=CN=C1)C(=O)N.CC(C)(CO)C(C(=O)NCCC(=O)O)O.CC1=NC=C(C(=C1O)CO)CO.C1=CC(=CC=C1C(=O)NC(CCC(=O)O)C(=O)O)NCC2=CN=C3C(=N2)C(=O)NC(=N3)N.CC1=CC2=C(C=C1C)N(C=N2)C3C(C(C(O3)CO)OP(=O)([O-])OC(C)CNC(=O)CCC4(C(C5C6(C(C(C(=N6)C(=C7C(C(C(=N7)C=C8C(C(C(=N8)C(=C4[N-]5)C)CCC(=O)N)(C)C)CCC(=O)N)(C)CC(=O)N)C)CCC(=O)N)(C)CC(=O)N)C)CC(=O)N)C)O.[C-]#N.[Co+3].CC1(CCC2(CCC3(C(=CCC4C3(CCC5C4(CCC(C5(C)COS(=O)(=O)O)O)C)C)C2C1)C)C(=O)O)C.CC1COC(C2C1C3C(C3(C)C)CCC2(C)O)O.CC1=C(C(CCC1)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC2=C(CCCC2(C)C)C)C)C.C1=CC=C2C(=C1)C=CC(=O)O2.C1=CC(=CC=C1C=CC(=O)OCC2C(C(C(C(O2)OC3=C(OC4=CC(=CC(=C4C3=O)O)O)C5=CC=C(C=C5)O)O)O)O)O.C1=CC(=CC=C1C2=C(C(=O)C3=C(C=C(C=C3O2)O)O)OC4C(C(C(C(O4)CO)O)O)O)O.COC1=CC(=C2C(=C1)OC(=C(C2=O)O)C3=CC=C(C=C3)O)O.COC1=CC(=C2C(=C1)OC(=C(C2=O)O)C3=CC(=C(C=C3)O)O)O.C1=CC(=CC=C1C2=C(C(=O)C3=C(C=C(C=C3O2)O)O)O)O.C1=CC=C(C=C1)O.CC1(C2CCC3(C(C2(CCC1OC4C(C(C(CO4)OC5C(C(C(CO5)O)O)O)OC6C(C(C(C(O6)CO)O)O)O)OC7C(C(C(C(O7)CO)O)O)OC8C(C(C(C(O8)CO)O)O)O)C)CCC91C3(CC(C2(C9CC(CC2)(C)C=O)CO1)O)C)C)C.C1C2C(CC(N2)(C(C1O)O)O)O.C1CC2(C(C(C(C1N2)O)O)O)O.C1C(C2C(C(C(C1(N2)O)O)O)O)O.C1CC2(C(C(C(C1N2)O)O)O)O.CC1=C(CN2CCCC2C1)C3=CC=C(C=C3)OC4C(C(C(C(O4)COC(=O)C=CC5=CC=C(C=C5)O)O)O)O.CC(C(C(=O)O)N)O.CC(C)C(C(=O)O)N.C(C(C(=O)O)N)SSCC(C(=O)O)N.CSCCC(C(=O)O)N.CCC(C)C(C(=O)O)N.CC(C)CC(C(=O)O)N.C(CCN)CC(C(=O)O)N.C1=CC=C(C=C1)CC(C(=O)O)N.C1=C(NC=N1)CC(C(=O)O)N.C(CC(C(=O)O)N)CN=C(N)N.C(CC(=O)O)C(C(=O)O)N.C1CC(NC1)C(=O)O.CC(C(=O)O)N.C1=CC(=CC=C1CC(C(=O)O)N)O.[Mn].[Mg].[K].[Na].[Fe].[Zn].[Cu].[B].[Se].O=[Si]=O',
            "beta-apo-8'-carotenal": 'CC1=C(C(CCC1)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=O)C)C',
            'beta carotene': 'CC1=C(C(CCC1)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC2=C(CCCC2(C)C)C)C)C',
            'butterfly pea flower extract': 'C1=C(C=C(C(=C1O)[O-])O)C2=C(C=C3C(=CC(=O)C=C3O2)O)OC4C(C(C(C(O4)CO)O)O)O',
            'calcium carbonate': 'C(=O)([O-])[O-].[Ca+2]',
            'canthaxanthin': 'CC1=C(C(CCC1=O)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC2=C(C(=O)CCC2(C)C)C)C)C',
            'caramel': '*',
            'carmine': 'CC1=C2C(=CC(=C1C(=O)O)O)C(=O)C3=C(C2=O)C(=C(C(=C3O)O)C4C(C(C(C(O4)CO)O)O)O)O',
            'carrot oil': 'CC1=CCC2CC1C2(C)C.CC1(C2CCC(C2)C1=C)C.CC1(C2CCC(=C)C1C2)C.CC(C)C12CCC(=C)C1C2.CC(=CCCC(=C)C=C)C.CC1=CCC(=CC1)C(C)C.CC1=CCC(CC1)C(=C)C.CC1=CCC(CC1)C(=C)CCC=C(C)C.CC(=CCCC(=CCOC(=O)C)C)C.CC1=CCC2(CCC(C2(CC1)O)C(C)C)C.CC1=C(C(CCC1)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC2=C(CCCC2(C)C)C)C)C.CC1=C(C(CCC1)(C)C)C=CC(=CC=CC(=CCO)C)C.CC1=CC2=C(C=C1C)N(C3=NC(=O)NC(=O)C3=N2)CC(C(C(CO)O)O)O.C(C(C1C(=C(C(=O)O1)O)O)O)O.CC(C)CCCC(C)C1CCC2C1(CCCC2=CC=C3CC(CCC3=C)O)C.CC1=C(C2=C(CCC(O2)(C)CCCC(C)CCCC(C)CCCC(C)C)C(=C1O)C)C.CCC=CCC=CCC=CCCCCCCCC(=O)O',
            'cochineal extract': 'CC1=C2C(=CC(=C1C(=O)O)O)C(=O)C3=C(C2=O)C(=C(C(=C3O)O)C4C(C(C(C(O4)CO)O)O)O)O',
            'corn endosperm oil': 'CCC=CCC=CCC=CCCCCCCCC(=O)O.CCC=CCC=CCC=CCC=CCC=CCCCC(=O)O.CCC=CCC=CCC=CCC=CCC=CCC=CCCC(=O)O.CCCCCCCCC=CCCCCCCCCCCCC(=O)O.CCCCCCCCC=CCCCCCCCC(=O)O.CCCCCCCCC=CCCCCCCCCCCCC(=O)O.CCCCCCCCC=CCCCCCCCC(=O)O',
            'cottonseed flour': '*',
            'ferrous gluconate': 'C(C(C(C(C(C(=O)[O-])O)O)O)O)O.C(C(C(C(C(C(=O)[O-])O)O)O)O)O.O.O.[Fe+2]',
            'ferrous lactate': 'CC(C(=O)O)O.CC(C(=O)O)O.[Fe]',
            'fruit juice': '*',
            'grape color extract': 'C1=CC=C(C=C1)C2=[O+]C3=CC=CC=C3C=C2',
            'grape skin extract': 'CC1=CC(=C(C2=C1CC(C(O2)C3=CC(=C(C=C3)O)O)(C)O)C4C(C(OC5=CC(=CC(=C45)O)O)C6=CC(=C(C=C6)O)O)O)O',
            'haematococcus algae meal': '*',
            'synthetic iron oxide': 'O=[Fe]O[Fe]=O',
            'lycopene': 'CC(=CCCC(=CC=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC=C(C)CCC=C(C)C)C)C)C)C',
            'mica-based pearlescent pigment': '*',
            'paprika': 'CC1=C(C(CCC1)(C)C)C(=O)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC2=C(CC(CC2(C)C)O)C)C)C.CC1=C(C(CC(C1)O)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC(=O)C=C(C)CCC=C(C)C)C)C.CC1=C(C(CC(C1)O)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC(=O)C2C(=CCCC2(C)C)C)C)C.CC1=C(C(CC(C1)O)(C)C)C=CC(=CC=CC(=CC=CC=C(C)C=CC=C(C)C=CC(=O)C2(CC(CC2(C)C)O)C)C)C.CC(C)C=CCCCCC(=O)NCC1=CC(=C(C=C1)O)OC',
            'paracoccus pigment': '*',
            'phaffla yeast': '*',
            'riboflavin': 'CC1=CC2=C(C=C1C)N(C3=NC(=O)NC(=O)C3=N2)CC(C(C(CO)O)O)O',
            'saffron': 'CC(=CC=CC=C(C)C=CC=C(C)C(=O)O)C=CC=C(C)C(=O)O',
            'sodium copper chlorophyllin': 'CCC1=C(C2=CC3=NC(=CC4=NC(=C(C5=NC(=C(C5=C([O-])[O-])C)C=C1[N-]2)CC(=O)[O-])C(C4C)CCC(=O)[O-])C(=C3C=C)C)C.[Na+].[Na+].[Na+].[Cu+2]',
            'soy leghemoglobin': '*',
            'spirulina extract': '*',
            'tagetes': '*',
            'titanium dioxide': 'O=[Ti]=O',
            'turmeric': 'COC1=C(C=CC(=C1)C=CC(=O)CC(=O)C=CC2=CC(=C(C=C2)O)OC)O',
            'ultramarine blue': '[O-][Si]([O-])([O-])[O-].[O-][Si]([O-])([O-])[O-].[O-][Si]([O-])([O-])[O-].[O-][Si]([O-])([O-])[O-].[O-][Si]([O-])([O-])[O-].[O-][Si]([O-])([O-])[O-].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Al+3].[Al+3].[Al+3].[Al+3].[Al+3].[Al+3].[S-]S[S-]',
            'vegetable juice ': '*',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'algae meal, dried': '[#0:1].[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1(-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#6]-[#8])-[#8])-[#8])-[#8])-[#8].[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8])-[#8])-[#8])-[#8])-[#8].[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)(-[#6]-[#8])-[#8])-[#8])-[#8])-[#8].[#6]1(-[#6](-[#6](-[#6](-[#6](-[#6]-1-[#8]-[#15](=[#8])(-[#8-])-[#8-])-[#8]-[#15](=[#8])(-[#8-])-[#8-])-[#8]-[#15](=[#8])(-[#8-])-[#8-])-[#8]-[#15](=[#8])(-[#8-])-[#8-])-[#8]-[#15](=[#8])(-[#8-])-[#8-])-[#8]-[#15](=[#8])(-[#8-])-[#8-].[Ca+2].[Ca+2].[Ca+2].[Ca+2].[Ca+2].[Ca+2].[#6]-[#6]-[#8]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1)-[#7]-[#6](-[#6]=[#6]-2-[#6])(-[#6])-[#6]',
            'annatto extract': '[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6](=[#8])-[#8])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6](=[#8])-[#8]',
            'astaxanthin': '[#6]-[#6]1=[#6](-[#6](-[#6]-[#6](-[#6]-1=[#8])-[#8])(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]1=[#6](-[#6](=[#8])-[#6](-[#6]-[#6]-1(-[#6])-[#6])-[#8])-[#6])-[#6])-[#6]',
            'astaxanthin dimethyldisuccinate': '[#6]-[#6]1=[#6](-[#6](-[#6]-[#6](-[#6]-1=[#8])-[#8])(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]1=[#6](-[#6](=[#8])-[#6](-[#6]-[#6]-1(-[#6])-[#6])-[#8])-[#6])-[#6])-[#6].[#6]-[#8]-[#6](=[#8])-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]',
            'beet juice': '[#6]-[#6]1:[#6](:[#16]:[#6]:[#7+]:1-[#6]-[#6]1:[#6]:[#7]:[#6](:[#7]:[#6]:1-[#7])-[#6])-[#6]-[#6]-[#8].[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1-[#6]):[#7](:[#6]1:[#7]:[#6](=[#8]):[#7H]:[#6](=[#8]):[#6]-1:[#7]:2)-[#6]-[#6](-[#6](-[#6](-[#6]-[#8])-[#8])-[#8])-[#8].[#6]1:[#6]:[#6](:[#6]:[#7]:[#6]:1)-[#6](=[#8])-[#7].[#6]-[#6](-[#6])(-[#6]-[#8])-[#6](-[#6](=[#8])-[#7]-[#6]-[#6]-[#6](=[#8])-[#8])-[#8].[#6]-[#6]1:[#7]:[#6]:[#6](:[#6](:[#6]:1-[#8])-[#6]-[#8])-[#6]-[#8].[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6](=[#8])-[#7]-[#6](-[#6]-[#6]-[#6](=[#8])-[#8])-[#6](=[#8])-[#8])-[#7]-[#6]-[#6]1:[#6]:[#7]:[#6]2:[#6](:[#7]:1):[#6](=[#8]):[#7H]:[#6](:[#7]:2)-[#7].[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1-[#6]):[#7](:[#6]:[#7]:2)-[#6]1-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8]-[#15](=[#8])(-[#8-])-[#8]-[#6](-[#6])-[#6]-[#7]-[#6](=[#8])-[#6]-[#6]-[#6]1(-[#6](-[#6]2-[#6]3(-[#6](-[#6](-[#6](=[#7]-3)-[#6](=[#6]3-[#6](-[#6](-[#6](=[#7]-3)-[#6]=[#6]3-[#6](-[#6](-[#6](=[#7]-3)-[#6](=[#6]-1-[#7-]-2)-[#6])-[#6]-[#6]-[#6](=[#8])-[#7])(-[#6])-[#6])-[#6]-[#6]-[#6](=[#8])-[#7])(-[#6])-[#6]-[#6](=[#8])-[#7])-[#6])-[#6]-[#6]-[#6](=[#8])-[#7])(-[#6])-[#6]-[#6](=[#8])-[#7])-[#6])-[#6]-[#6](=[#8])-[#7])-[#6])-[#8].[#6-]#[#7].[Co+3].[#6]-[#6]1(-[#6]-[#6]-[#6]2(-[#6]-[#6]-[#6]3(-[#6](=[#6]-[#6]-[#6]4-[#6]-3(-[#6]-[#6]-[#6]3-[#6]-4(-[#6]-[#6]-[#6](-[#6]-3(-[#6])-[#6]-[#8]-[#16](=[#8])(=[#8])-[#8])-[#8])-[#6])-[#6])-[#6]-2-[#6]-1)-[#6])-[#6](=[#8])-[#8])-[#6].[#6]-[#6]1-[#6]-[#8]-[#6](-[#6]2-[#6]-1-[#6]1-[#6](-[#6]-1(-[#6])-[#6])-[#6]-[#6]-[#6]-2(-[#6])-[#8])-[#8].[#6]-[#6]1=[#6](-[#6](-[#6]-[#6]-[#6]-1)(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]1=[#6](-[#6]-[#6]-[#6]-[#6]-1(-[#6])-[#6])-[#6])-[#6])-[#6].[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:1):[#6]:[#6]:[#6](=[#8]):[#8]:2.[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]=[#6]-[#6](=[#8])-[#8]-[#6]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1:[#6](:[#8]:[#6]2:[#6]:[#6](:[#6]:[#6](:[#6]:2:[#6]:1=[#8])-[#8])-[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8])-[#8])-[#8])-[#8])-[#8].[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]1:[#6](:[#6](=[#8]):[#6]2:[#6](:[#6]:[#6](:[#6]:[#6]:2:[#8]:1)-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8].[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]2:[#6](:[#6]:1):[#8]:[#6](:[#6](:[#6]:2=[#8])-[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8])-[#8].[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]2:[#6](:[#6]:1):[#8]:[#6](:[#6](:[#6]:2=[#8])-[#8])-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8])-[#8].[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]1:[#6](:[#6](=[#8]):[#6]2:[#6](:[#6]:[#6](:[#6]:[#6]:2:[#8]:1)-[#8])-[#8])-[#8])-[#8].[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8].[#6]-[#6]1(-[#6]2-[#6]-[#6]-[#6]3(-[#6](-[#6]-2(-[#6]-[#6]-[#6]-1-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6]-[#8]-1)-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6]-[#8]-1)-[#8])-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#6])-[#6]-[#6]-[#6]12-[#6]-3(-[#6]-[#6](-[#6]3(-[#6]-1-[#6]-[#6](-[#6]-[#6]-3)(-[#6])-[#6]=[#8])-[#6]-[#8]-2)-[#8])-[#6])-[#6])-[#6].[#6]1-[#6]2-[#6](-[#6]-[#6](-[#7]-2)(-[#6](-[#6]-1-[#8])-[#8])-[#8])-[#8].[#6]1-[#6]-[#6]2(-[#6](-[#6](-[#6](-[#6]-1-[#7]-2)-[#8])-[#8])-[#8])-[#8].[#6]1-[#6](-[#6]2-[#6](-[#6](-[#6](-[#6]-1(-[#7]-2)-[#8])-[#8])-[#8])-[#8])-[#8].[#6]1-[#6]-[#6]2(-[#6](-[#6](-[#6](-[#6]-1-[#7]-2)-[#8])-[#8])-[#8])-[#8].[#6]-[#6]1=[#6](-[#6]-[#7]2-[#6]-[#6]-[#6]-[#6]-2-[#6]-1)-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8]-[#6](=[#8])-[#6]=[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8])-[#8])-[#8])-[#8].[#6]-[#6](-[#6](-[#6](=[#8])-[#8])-[#7])-[#8].[#6]-[#6](-[#6])-[#6](-[#6](=[#8])-[#8])-[#7].[#6](-[#6](-[#6](=[#8])-[#8])-[#7])-[#16]-[#16]-[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6]-[#16]-[#6]-[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6]-[#6]-[#6](-[#6])-[#6](-[#6](=[#8])-[#8])-[#7].[#6]-[#6](-[#6])-[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6](-[#6]-[#6]-[#7])-[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6]1:[#6](:[#7H]:[#6]:[#7]:1)-[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6](-[#6]-[#6](-[#6](=[#8])-[#8])-[#7])-[#6]-[#7]=[#6](-[#7])-[#7].[#6](-[#6]-[#6](=[#8])-[#8])-[#6](-[#6](=[#8])-[#8])-[#7].[#6]1-[#6]-[#6](-[#7]-[#6]-1)-[#6](=[#8])-[#8].[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]-[#6](-[#6](=[#8])-[#8])-[#7])-[#8].[Mn].[Mg].[K].[Na].[Fe].[Zn].[Cu].[#5].[Se].[#8]=[Si]=[#8]',
            'beet powder': '[#6]-[#6]1:[#6](:[#16]:[#6]:[#7+]:1-[#6]-[#6]1:[#6]:[#7]:[#6](:[#7]:[#6]:1-[#7])-[#6])-[#6]-[#6]-[#8].[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1-[#6]):[#7](:[#6]1:[#7]:[#6](=[#8]):[#7H]:[#6](=[#8]):[#6]-1:[#7]:2)-[#6]-[#6](-[#6](-[#6](-[#6]-[#8])-[#8])-[#8])-[#8].[#6]1:[#6]:[#6](:[#6]:[#7]:[#6]:1)-[#6](=[#8])-[#7].[#6]-[#6](-[#6])(-[#6]-[#8])-[#6](-[#6](=[#8])-[#7]-[#6]-[#6]-[#6](=[#8])-[#8])-[#8].[#6]-[#6]1:[#7]:[#6]:[#6](:[#6](:[#6]:1-[#8])-[#6]-[#8])-[#6]-[#8].[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6](=[#8])-[#7]-[#6](-[#6]-[#6]-[#6](=[#8])-[#8])-[#6](=[#8])-[#8])-[#7]-[#6]-[#6]1:[#6]:[#7]:[#6]2:[#6](:[#7]:1):[#6](=[#8]):[#7H]:[#6](:[#7]:2)-[#7].[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1-[#6]):[#7](:[#6]:[#7]:2)-[#6]1-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8]-[#15](=[#8])(-[#8-])-[#8]-[#6](-[#6])-[#6]-[#7]-[#6](=[#8])-[#6]-[#6]-[#6]1(-[#6](-[#6]2-[#6]3(-[#6](-[#6](-[#6](=[#7]-3)-[#6](=[#6]3-[#6](-[#6](-[#6](=[#7]-3)-[#6]=[#6]3-[#6](-[#6](-[#6](=[#7]-3)-[#6](=[#6]-1-[#7-]-2)-[#6])-[#6]-[#6]-[#6](=[#8])-[#7])(-[#6])-[#6])-[#6]-[#6]-[#6](=[#8])-[#7])(-[#6])-[#6]-[#6](=[#8])-[#7])-[#6])-[#6]-[#6]-[#6](=[#8])-[#7])(-[#6])-[#6]-[#6](=[#8])-[#7])-[#6])-[#6]-[#6](=[#8])-[#7])-[#6])-[#8].[#6-]#[#7].[Co+3].[#6]-[#6]1(-[#6]-[#6]-[#6]2(-[#6]-[#6]-[#6]3(-[#6](=[#6]-[#6]-[#6]4-[#6]-3(-[#6]-[#6]-[#6]3-[#6]-4(-[#6]-[#6]-[#6](-[#6]-3(-[#6])-[#6]-[#8]-[#16](=[#8])(=[#8])-[#8])-[#8])-[#6])-[#6])-[#6]-2-[#6]-1)-[#6])-[#6](=[#8])-[#8])-[#6].[#6]-[#6]1-[#6]-[#8]-[#6](-[#6]2-[#6]-1-[#6]1-[#6](-[#6]-1(-[#6])-[#6])-[#6]-[#6]-[#6]-2(-[#6])-[#8])-[#8].[#6]-[#6]1=[#6](-[#6](-[#6]-[#6]-[#6]-1)(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]1=[#6](-[#6]-[#6]-[#6]-[#6]-1(-[#6])-[#6])-[#6])-[#6])-[#6].[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:1):[#6]:[#6]:[#6](=[#8]):[#8]:2.[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]=[#6]-[#6](=[#8])-[#8]-[#6]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1:[#6](:[#8]:[#6]2:[#6]:[#6](:[#6]:[#6](:[#6]:2:[#6]:1=[#8])-[#8])-[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8])-[#8])-[#8])-[#8])-[#8].[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]1:[#6](:[#6](=[#8]):[#6]2:[#6](:[#6]:[#6](:[#6]:[#6]:2:[#8]:1)-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8].[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]2:[#6](:[#6]:1):[#8]:[#6](:[#6](:[#6]:2=[#8])-[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8])-[#8].[#6]-[#8]-[#6]1:[#6]:[#6](:[#6]2:[#6](:[#6]:1):[#8]:[#6](:[#6](:[#6]:2=[#8])-[#8])-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8])-[#8].[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]1:[#6](:[#6](=[#8]):[#6]2:[#6](:[#6]:[#6](:[#6]:[#6]:2:[#8]:1)-[#8])-[#8])-[#8])-[#8].[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8].[#6]-[#6]1(-[#6]2-[#6]-[#6]-[#6]3(-[#6](-[#6]-2(-[#6]-[#6]-[#6]-1-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6]-[#8]-1)-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6]-[#8]-1)-[#8])-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#6])-[#6]-[#6]-[#6]12-[#6]-3(-[#6]-[#6](-[#6]3(-[#6]-1-[#6]-[#6](-[#6]-[#6]-3)(-[#6])-[#6]=[#8])-[#6]-[#8]-2)-[#8])-[#6])-[#6])-[#6].[#6]1-[#6]2-[#6](-[#6]-[#6](-[#7]-2)(-[#6](-[#6]-1-[#8])-[#8])-[#8])-[#8].[#6]1-[#6]-[#6]2(-[#6](-[#6](-[#6](-[#6]-1-[#7]-2)-[#8])-[#8])-[#8])-[#8].[#6]1-[#6](-[#6]2-[#6](-[#6](-[#6](-[#6]-1(-[#7]-2)-[#8])-[#8])-[#8])-[#8])-[#8].[#6]1-[#6]-[#6]2(-[#6](-[#6](-[#6](-[#6]-1-[#7]-2)-[#8])-[#8])-[#8])-[#8].[#6]-[#6]1=[#6](-[#6]-[#7]2-[#6]-[#6]-[#6]-[#6]-2-[#6]-1)-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8]-[#6](=[#8])-[#6]=[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8])-[#8])-[#8])-[#8].[#6]-[#6](-[#6](-[#6](=[#8])-[#8])-[#7])-[#8].[#6]-[#6](-[#6])-[#6](-[#6](=[#8])-[#8])-[#7].[#6](-[#6](-[#6](=[#8])-[#8])-[#7])-[#16]-[#16]-[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6]-[#16]-[#6]-[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6]-[#6]-[#6](-[#6])-[#6](-[#6](=[#8])-[#8])-[#7].[#6]-[#6](-[#6])-[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6](-[#6]-[#6]-[#7])-[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6]1:[#6](:[#7H]:[#6]:[#7]:1)-[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6](-[#6]-[#6](-[#6](=[#8])-[#8])-[#7])-[#6]-[#7]=[#6](-[#7])-[#7].[#6](-[#6]-[#6](=[#8])-[#8])-[#6](-[#6](=[#8])-[#8])-[#7].[#6]1-[#6]-[#6](-[#7]-[#6]-1)-[#6](=[#8])-[#8].[#6]-[#6](-[#6](=[#8])-[#8])-[#7].[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6]-[#6](-[#6](=[#8])-[#8])-[#7])-[#8].[Mn].[Mg].[K].[Na].[Fe].[Zn].[Cu].[#5].[Se].[#8]=[Si]=[#8]',
            "beta-apo-8'-carotenal": '[#6]-[#6]1=[#6](-[#6](-[#6]-[#6]-[#6]-1)(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#8])-[#6])-[#6]',
            'beta carotene': '[#6]-[#6]1=[#6](-[#6](-[#6]-[#6]-[#6]-1)(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]1=[#6](-[#6]-[#6]-[#6]-[#6]-1(-[#6])-[#6])-[#6])-[#6])-[#6]',
            'butterfly pea flower extract': '[#6]1:[#6](:[#6]:[#6](:[#6](:[#6]:1-[#8])-[#8-])-[#8])-[#6]1:[#6](:[#6]:[#6]2:[#6](:[#6]:[#6](=[#8]):[#6]:[#6]-2:[#8]:1)-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8]',
            'calcium carbonate': '[#6](=[#8])(-[#8-])-[#8-].[Ca+2]',
            'canthaxanthin': '[#6]-[#6]1=[#6](-[#6](-[#6]-[#6]-[#6]-1=[#8])(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]1=[#6](-[#6](=[#8])-[#6]-[#6]-[#6]-1(-[#6])-[#6])-[#6])-[#6])-[#6]',
            'caramel': '[#0]',
            'carmine': '[#6]-[#6]1:[#6]2:[#6](:[#6]:[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8])-[#6](=[#8])-[#6]1:[#6](-[#6]-2=[#8]):[#6](:[#6](:[#6](:[#6]:1-[#8])-[#8])-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]',
            'carrot oil': '[#6]-[#6]1=[#6]-[#6]-[#6]2-[#6]-[#6]-1-[#6]-2(-[#6])-[#6].[#6]-[#6]1(-[#6]2-[#6]-[#6]-[#6](-[#6]-2)-[#6]-1=[#6])-[#6].[#6]-[#6]1(-[#6]2-[#6]-[#6]-[#6](=[#6])-[#6]-1-[#6]-2)-[#6].[#6]-[#6](-[#6])-[#6]12-[#6]-[#6]-[#6](=[#6])-[#6]-1-[#6]-2.[#6]-[#6](=[#6]-[#6]-[#6]-[#6](=[#6])-[#6]=[#6])-[#6].[#6]-[#6]1=[#6]-[#6]-[#6](=[#6]-[#6]-1)-[#6](-[#6])-[#6].[#6]-[#6]1=[#6]-[#6]-[#6](-[#6]-[#6]-1)-[#6](=[#6])-[#6].[#6]-[#6]1=[#6]-[#6]-[#6](-[#6]-[#6]-1)-[#6](=[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6].[#6]-[#6](=[#6]-[#6]-[#6]-[#6](=[#6]-[#6]-[#8]-[#6](=[#8])-[#6])-[#6])-[#6].[#6]-[#6]1=[#6]-[#6]-[#6]2(-[#6]-[#6]-[#6](-[#6]-2(-[#6]-[#6]-1)-[#8])-[#6](-[#6])-[#6])-[#6].[#6]-[#6]1=[#6](-[#6](-[#6]-[#6]-[#6]-1)(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]1=[#6](-[#6]-[#6]-[#6]-[#6]-1(-[#6])-[#6])-[#6])-[#6])-[#6].[#6]-[#6]1=[#6](-[#6](-[#6]-[#6]-[#6]-1)(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]-[#8])-[#6])-[#6].[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1-[#6]):[#7](:[#6]1:[#7]:[#6](=[#8]):[#7H]:[#6](=[#8]):[#6]-1:[#7]:2)-[#6]-[#6](-[#6](-[#6](-[#6]-[#8])-[#8])-[#8])-[#8].[#6](-[#6](-[#6]1-[#6](=[#6](-[#6](=[#8])-[#8]-1)-[#8])-[#8])-[#8])-[#8].[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]-[#6]2-[#6]-1(-[#6]-[#6]-[#6]-[#6]-2=[#6]-[#6]=[#6]1-[#6]-[#6](-[#6]-[#6]-[#6]-1=[#6])-[#8])-[#6].[#6]-[#6]1:[#6](:[#6]2:[#6](-[#6]-[#6]-[#6](-[#8]-2)(-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]):[#6](:[#6]:1-[#8])-[#6])-[#6].[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]',
            'cochineal extract': '[#6]-[#6]1:[#6]2:[#6](:[#6]:[#6](:[#6]:1-[#6](=[#8])-[#8])-[#8])-[#6](=[#8])-[#6]1:[#6](-[#6]-2=[#8]):[#6](:[#6](:[#6](:[#6]:1-[#8])-[#8])-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]',
            'corn endosperm oil': '[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8].[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]',
            'cottonseed flour': '[#0]',
            'ferrous gluconate': '[#6](-[#6](-[#6](-[#6](-[#6](-[#6](=[#8])-[#8-])-[#8])-[#8])-[#8])-[#8])-[#8].[#6](-[#6](-[#6](-[#6](-[#6](-[#6](=[#8])-[#8-])-[#8])-[#8])-[#8])-[#8])-[#8].[#8].[#8].[Fe+2]',
            'ferrous lactate': '[#6]-[#6](-[#6](=[#8])-[#8])-[#8].[#6]-[#6](-[#6](=[#8])-[#8])-[#8].[Fe]',
            'fruit juice': '[#0]',
            'grape color extract': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]1:[#8+]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#6]:[#6]:1',
            'grape skin extract': '[#6]-[#6]1:[#6]:[#6](:[#6](:[#6]2:[#6]:1-[#6]-[#6](-[#6](-[#8]-2)-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8])(-[#6])-[#8])-[#6]1-[#6](-[#6](-[#8]-[#6]2:[#6]:[#6](:[#6]:[#6](:[#6]:2-1)-[#8])-[#8])-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8])-[#8])-[#8]',
            'haematococcus algae meal': '[#0]',
            'synthetic iron oxide': '[#8]=[Fe]-[#8]-[Fe]=[#8]',
            'lycopene': '[#6]-[#6](=[#6]-[#6]-[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6])-[#6])-[#6])-[#6])-[#6]',
            'mica-based pearlescent pigment': '[#0]',
            'paprika': '[#6]-[#6]1=[#6](-[#6](-[#6]-[#6]-[#6]-1)(-[#6])-[#6])-[#6](=[#8])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]1=[#6](-[#6]-[#6](-[#6]-[#6]-1(-[#6])-[#6])-[#8])-[#6])-[#6])-[#6].[#6]-[#6]1=[#6](-[#6](-[#6]-[#6](-[#6]-1)-[#8])(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6](=[#8])-[#6]=[#6](-[#6])-[#6]-[#6]-[#6]=[#6](-[#6])-[#6])-[#6])-[#6].[#6]-[#6]1=[#6](-[#6](-[#6]-[#6](-[#6]-1)-[#8])(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6](=[#8])-[#6]1-[#6](=[#6]-[#6]-[#6]-[#6]-1(-[#6])-[#6])-[#6])-[#6])-[#6].[#6]-[#6]1=[#6](-[#6](-[#6]-[#6](-[#6]-1)-[#8])(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6](=[#8])-[#6]1(-[#6]-[#6](-[#6]-[#6]-1(-[#6])-[#6])-[#8])-[#6])-[#6])-[#6].[#6]-[#6](-[#6])-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#7]-[#6]-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-[#6]',
            'paracoccus pigment': '[#0]',
            'phaffla yeast': '[#0]',
            'riboflavin': '[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1-[#6]):[#7](:[#6]1:[#7]:[#6](=[#8]):[#7H]:[#6](=[#8]):[#6]-1:[#7]:2)-[#6]-[#6](-[#6](-[#6](-[#6]-[#8])-[#8])-[#8])-[#8]',
            'saffron': '[#6]-[#6](=[#6]-[#6]=[#6]-[#6]=[#6](-[#6])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6](=[#8])-[#8])-[#6]=[#6]-[#6]=[#6](-[#6])-[#6](=[#8])-[#8]',
            'sodium copper chlorophyllin': '[#6]-[#6]-[#6]1:[#6](:[#6]2=[#6]-[#6]3=[#7]-[#6](=[#6]-[#6]4=[#7]-[#6](=[#6](-[#6]5=[#7]-[#6](=[#6](-[#6]-5=[#6](-[#8-])-[#8-])-[#6])-[#6]=[#6]:1:[#7-]:2)-[#6]-[#6](=[#8])-[#8-])-[#6](-[#6]-4-[#6])-[#6]-[#6]-[#6](=[#8])-[#8-])-[#6](=[#6]-3-[#6]=[#6])-[#6])-[#6].[Na+].[Na+].[Na+].[Cu+2]',
            'soy leghemoglobin': '[#0]',
            'spirulina extract': '[#0]',
            'tagetes': '[#0]',
            'titanium dioxide': '[#8]=[Ti]=[#8]',
            'turmeric': '[#6]-[#8]-[#6]1:[#6](:[#6]:[#6]:[#6](:[#6]:1)-[#6]=[#6]-[#6](=[#8])-[#6]-[#6](=[#8])-[#6]=[#6]-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#8]-[#6])-[#8]',
            'ultramarine blue': '[#8-]-[Si](-[#8-])(-[#8-])-[#8-].[#8-]-[Si](-[#8-])(-[#8-])-[#8-].[#8-]-[Si](-[#8-])(-[#8-])-[#8-].[#8-]-[Si](-[#8-])(-[#8-])-[#8-].[#8-]-[Si](-[#8-])(-[#8-])-[#8-].[#8-]-[Si](-[#8-])(-[#8-])-[#8-].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Al+3].[Al+3].[Al+3].[Al+3].[Al+3].[Al+3].[#16-]-[#16]-[#16-]',
            'vegetable juice ': '[#0]',
        }

        return smarts