#!/usr/bin/env python3
#
# GlobalChem - FDA List Seven
#
# ---------------------------

class FDAListSeven(object):

    def __init__(self):

        self.name = 'fda_color_additive_list_seven'

    @staticmethod
    def get_smiles():

        smiles = {
            '1,4-bis[(2-hydroxyethyl)amino]-9,10-anthracenedione bis(2-propenoic)ester': 'O=C1C2=C(C=CC=C2)C(C3=C(NCCOC(C=C)=O)C=CC(NCCOC(C=C)=O)=C13)=O',
            '1,4-Bis[4-(2-methacryloxyethyl)phenylamino]-9,10-anthraquinone': 'O=C(C1=C2C=CC=C1)C3=C(NC4=CC=C(CCOC(C(C)=C)=O)C=C4)C=CC(NC5=CC=C(CCOC(C(C)=C)=O)C=C5)=C3C2=O',
            '1,4-Bis[(2-methylphenyl)amino]-9,10-anthracenedione': 'O=C1C2=C(C=CC=C2)C(C3=C(NC4=CC=CC=C4C)C=CC(NC5=CC=CC=C5C)=C13)=O',
            'carbazole violet': 'CCN1C2=CC=CC=C2C3=CC4=C(C=C31)OC5=C(C6=NC7=C(C=C8C(=C7)C9=CC=CC=C9N8CC)OC6=C(C5=N4)Cl)Cl',
            'chlorophyllin-copper complex': 'CCC1=C(C2=NC1=CC3=C(C(=C([O-])[O-])C(=N3)C(=C4C(C(C(=CC5=NC(=C2)C(=C5C)C=C)N4)C)CCC(=O)O)CC(=O)O)C)C.[Cu+2]',
            'chromium-cobalt-aluminum oxide': 'O.[Al].[Co].[Cr]',
            'chromium oxide greens': '[O-2].[O-2].[O-2].[Cr+3].[Cr+3]',
            'c.i. vat orange 1': 'C1=CC2=C(C=C1Br)C(=O)C3=CC=C4C5=C(C=C(C=C5)Br)C(=O)C6=C4C3=C2C=C6',
            '7,16-dichloro-6,15-dihydro-5,9,14,18-anthrazinetetrone': 'O=C(C1=C2C=C(Cl)C3=C1NC4=C(N3)C5=C(C(C6=C(C5=O)C=CC=C6)=O)C=C4Cl)C7=CC=CC=C7C2=O',
            '2-[[2,5-diethoxy-4-[(4-methylphenyl)thiol]phenyl]azo]-1,3,5- benzenetriol': '*',
            "16,23-dihydrodinaptho[2,3-a:2',3'-i]napth[2',3':6,7]indolo[2,3-c]carbazole-5,10,15,17,22,24-hexone": 'O=C(C(C1=NC2=C3C=C4C=C5)=C6C(NC7=C8C(CC(C9=O)=C7C(C%10=C9C=CC=C%10)=O)=O)=C8C1=C2C=CC3=CC4=CC5=O)C%11=C(C=CC=C%11)C6=O',
            "N,N'-(9,10-dihydro-9,10-dioxo-1,5-anthracenediyl) bis-benzamide": 'O=C(C1=C2C=CC=C1NC(C3=CC=CC=C3)=O)C4=CC=CC(NC(C5=CC=CC=C5)=O)=C4C2=O',
            "16,17-Dimethoxydinaptho[1,2,3-cd:3',2',1'-lm]perylene-5,10-dione": 'O=C1C2=C(C(C3=C1C=CC4=C53)=CC(OC)=C5C6=C(OC)C=C7C8=C6C4=CC=C8C(C9=C7C=CC=C9)=O)C=CC=C2',
            "4-[(2,4-dimethylphenyl)azo]-2,4-dihydro-5-methyl-2-phenyl-3H-pyrazol-3-one": 'O=C1N(C2=CC=CC=C2)N=C(C)C1N=NC3=CC=C(C)C=C3C',
            'disodium 1-amino-4-[[4-[(2-bromo-1-oxoallyl)amino]-2-sulphonatophenyl]amino]-9,10-dihydro-9,10-dioxoanthracene-2-sulphonate': 'O=S(C(C(N)=C1C2=O)=CC(NC3=CC=C(NC(C(Br)=C)=O)C=C3S(=O)([O-])=O)=C1C(C4=C2C=CC=C4)=O)([O-])=O.[Na+].[Na+]',
            'd&c black #4': '*',
            'd&c blue #6': 'C1=CC=C(C=C1)C2(C(=O)C3=CC=CC=C3N2)C4(C(=O)C5=CC=CC=C5N4)C6=CC=CC=C6',
            'd&c blue #9': 'C1=CC=C2C(=C1)C(=O)C3=CC(=C4C(=C3C2=O)NC5=C(C=C6C(=C5N4)C(=O)C7=CC=CC=C7C6=O)Cl)Cl',
            'd&c green #5': 'CC1=CC(=C(C=C1)NC2=C3C(=C(C=C2)NC4=C(C=C(C=C4)C)S(=O)(=O)[O-])C(=O)C5=CC=CC=C5C3=O)S(=O)(=O)[O-].[Na+].[Na+]',
            'd&c green #6': 'CC1=CC=C(C=C1)NC2=C3C(=C(C=C2)NC4=CC=C(C=C4)C)C(=O)C5=CC=CC=C5C3=O',
            'd&c red #17': 'C1=CC=C(C=C1)N=NC2=CC=C(C=C2)N=NC3=C(C=CC4=CC=CC=C43)O',
            'd&c violet #2': 'CC1=CC=C(C=C1)NC2=C3C(=C(C=C2)O)C(=O)C4=CC=CC=C4C3=O',
            'd&c yellow # 8': 'C1=CC=C(C(=C1)C2=C3C=CC(=O)C=C3OC4=C2C=CC(=C4)O)C(=O)O',
            'd&c yellow #10 ': 'C1=CC=C2C(=C1)C(=O)C(C2=O)C3=NC4=C(C=C(C=C4C=C3)S(=O)(=O)[O-])S(=O)(=O)[O-].[Na+].[Na+]',
            '6-ethoxy-2-(6-ethoxy-3-oxobenzo[b]thien-2-(3H)-ylidene)benzo[b]thiophen-3-(2H)-one': 'O=C1C2=CC=C(OCC)C=C2SC1=C3C(C4=CC=C(OCC)C=C4S3)=O',
            'fd&c blue #2': 'CCN(CC1=CC(=CC=C1)S(=O)(=O)[O-])C2=CC=C(C=C2)C(=C3C=CC(=[N+](CC)CC4=CC(=CC=C4)S(=O)(=O)O)C=C3)C5=CC=CC=C5S(=O)(=O)O.N',
            'fd&c blue #2 aluminum lake on alumina': 'C1=CC2=C(C=C1S(=O)(=O)O)C(=C(N2)C3=NC4=C(C3=O)C=C(C=C4)S(=O)(=O)O)O.[Al+3]',
            'iron oxides, synthetic': 'O=[Fe]O[Fe]=O',
            'ferric ammonium citrate': 'C(C(=O)[O-])C(CC(=O)[O-])(C(=O)[O-])O.N.[Fe+3]',
            'logwood extract': 'C1C2=CC(=C(C=C2C3C1(COC4=C3C=CC(=C4O)O)O)O)O',
            'mica-based pearlescent pigments': '*',
            '[phthalocyaninato(2-)] copper': 'C1=CC=C2C(=C1)C3=NC4=NC(=NC5=NC(=NC6=NC(=NC2=N3)C7=CC=CC=C76)C8=CC=CC=C85)C9=CC=CC=C94.[Cu]',
            'phthalocyanine green': 'C12=C(C(=C(C(=C1Cl)Cl)Cl)Cl)C3=NC4=NC(=NC5=NC(=NC6=C7C(=C([N-]6)N=C2[N-]3)C(=C(C(=C7Cl)Cl)Cl)Cl)C8=C5C(=C(C(=C8Cl)Cl)Cl)Cl)C9=C4C(=C(C(=C9Cl)Cl)Cl)Cl.[Cu+2]',
            'hydroxyethyl methacrylate dye': 'CC(=C)C(=O)OCCO',
            'pyrogallol': 'C1=CC(=C(C(=C1)O)O)O',
            'titanium dioxide': 'O=[Ti]=O',
            'vinyl alcohol': 'C=CO',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            '1,4-bis[(2-hydroxyethyl)amino]-9,10-anthracenedione bis(2-propenoic)ester': '[#8]=[#6]1-[#6]2:[#6](:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#6]2:[#6](-[#7]-[#6]-[#6]-[#8]-[#6](-[#6]=[#6])=[#8]):[#6]:[#6]:[#6](-[#7]-[#6]-[#6]-[#8]-[#6](-[#6]=[#6])=[#8]):[#6]:2-1)=[#8]',
            '1,4-bis[4-(2-methacryloxyethyl)phenylamino]-9,10-anthraquinone': '[#8]=[#6]1-[#6]2:[#6](:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#6]2:[#6]-1:[#6](-[#7]-[#6]1:[#6]:[#6]:[#6](-[#6]-[#6]-[#8]-[#6](-[#6](-[#6])=[#6])=[#8]):[#6]:[#6]:1):[#6]:[#6]:[#6]:2-[#7]-[#6]1:[#6]:[#6]:[#6](-[#6]-[#6]-[#8]-[#6](-[#6](-[#6])=[#6])=[#8]):[#6]:[#6]:1)=[#8]',
            '1,4-bis[(2-methylphenyl)amino]-9,10-anthracenedione': '[#8]=[#6]1-[#6]2:[#6](:[#6]:[#6]:[#6]:[#6]:2)-[#6](-[#6]2:[#6](-[#7]-[#6]3:[#6]:[#6]:[#6]:[#6]:[#6]:3-[#6]):[#6]:[#6]:[#6](-[#7]-[#6]3:[#6]:[#6]:[#6]:[#6]:[#6]:3-[#6]):[#6]:2-1)=[#8]',
            'carbazole violet': '[#6]-[#6]-[#7]1:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2:[#6]2:[#6]:[#6]3:[#6](:[#6]:[#6]:1:2)-[#8]-[#6]1:[#6](:[#6]2=[#7]-[#6]4:[#6](:[#6]:[#6]5:[#6](:[#6]:4):[#6]4:[#6]:[#6]:[#6]:[#6]:[#6]:4:[#7]:5-[#6]-[#6])-[#8]-[#6]:2:[#6](:[#6]:1=[#7]-3)-[#17])-[#17]',
            'chlorophyllin-copper complex': '[#6]-[#6]-[#6]1=[#6](-[#6]2=[#7]-[#6]-1=[#6]-[#6]1=[#6](-[#6](=[#6](-[#8-])-[#8-])-[#6](=[#7]-1)-[#6](=[#6]1-[#6](-[#6](-[#6](=[#6]-[#6]3=[#7]-[#6](=[#6]-2)-[#6](=[#6]-3-[#6])-[#6]=[#6])-[#7]-1)-[#6])-[#6]-[#6]-[#6](=[#8])-[#8])-[#6]-[#6](=[#8])-[#8])-[#6])-[#6].[Cu+2]',
            'chromium-cobalt-aluminum oxide': '[#8].[Al].[Co].[Cr]',
            'chromium oxide greens': '[#8-2].[#8-2].[#8-2].[Cr+3].[Cr+3]',
            'c.i. vat orange 1': '[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1-[#35])-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]3-[#6]4:[#6](:[#6]:[#6](:[#6]:[#6]:4)-[#35])-[#6](=[#8])-[#6]4:[#6]:3:[#6]:1:[#6]-2:[#6]:[#6]:4',
            '7,16-dichloro-6,15-dihydro-5,9,14,18-anthrazinetetrone': '[#8]=[#6]1:[#6]2:[#6](:[#6]:[#6](-[#17]):[#6]3:[#6]:2:[#7H]:[#6]2:[#6](:[#7H]:3):[#6]3:[#6](:[#6](:[#6]4:[#6](:[#6]:3=[#8]):[#6]:[#6]:[#6]:[#6]:4)=[#8]):[#6]:[#6]:2-[#17]):[#6](:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)=[#8]',
            '2-[[2,5-diethoxy-4-[(4-methylphenyl)thiol]phenyl]azo]-1,3,5- benzenetriol': '[#0]',
            "16,23-dihydrodinaptho[2,3-a:2',3'-i]napth[2',3':6,7]indolo[2,3-c]carbazole-5,10,15,17,22,24-hexone": '[#8]=[#6]1:[#6]2:[#6]3:[#7]:[#6]4:[#6]5:[#6]:[#6]6:[#6]:[#6]:[#6](:[#6]:[#6]:6:[#6]:[#6]:5:[#6]:[#6]:[#6]:4:[#6]:3:[#6]3:[#6](:[#6]:2:[#6](:[#6]2:[#6]:1:[#6]:[#6]:[#6]:[#6]:2)=[#8]):[#7H]:[#6]1:[#6]:3-[#6](-[#6]-[#6]2-[#6](=[#8])-[#6]3:[#6](-[#6](-[#6]=2-1)=[#8]):[#6]:[#6]:[#6]:[#6]:3)=[#8])=[#8]',
            "n,n'-(9,10-dihydro-9,10-dioxo-1,5-anthracenediyl) bis-benzamide": '[#8]=[#6]1-[#6]2:[#6](:[#6]:[#6]:[#6]:[#6]:2-[#7]-[#6](-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)=[#8])-[#6](-[#6]2:[#6]-1:[#6]:[#6]:[#6]:[#6]:2-[#7]-[#6](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)=[#8])=[#8]',
            "16,17-dimethoxydinaptho[1,2,3-cd:3',2',1'-lm]perylene-5,10-dione": '[#8]=[#6]1-[#6]2:[#6](-[#6]3:[#6]4:[#6]-1:[#6]:[#6]:[#6]1:[#6]:4:[#6](:[#6](:[#6]:3)-[#8]-[#6]):[#6]3:[#6](-[#8]-[#6]):[#6]:[#6]4:[#6]5:[#6]:3:[#6]:1:[#6]:[#6]:[#6]:5-[#6](-[#6]1:[#6]-4:[#6]:[#6]:[#6]:[#6]:1)=[#8]):[#6]:[#6]:[#6]:[#6]:2',
            '4-[(2,4-dimethylphenyl)azo]-2,4-dihydro-5-methyl-2-phenyl-3h-pyrazol-3-one': '[#8]=[#6]1-[#7](-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2)-[#7]=[#6](-[#6])-[#6]-1-[#7]=[#7]-[#6]1:[#6]:[#6]:[#6](-[#6]):[#6]:[#6]:1-[#6]',
            'disodium 1-amino-4-[[4-[(2-bromo-1-oxoallyl)amino]-2-sulphonatophenyl]amino]-9,10-dihydro-9,10-dioxoanthracene-2-sulphonate': '[#8]=[#16](-[#6]1:[#6](-[#7]):[#6]2-[#6](=[#8])-[#6]3:[#6](-[#6](-[#6]:2:[#6](:[#6]:1)-[#7]-[#6]1:[#6]:[#6]:[#6](-[#7]-[#6](-[#6](-[#35])=[#6])=[#8]):[#6]:[#6]:1-[#16](=[#8])(-[#8-])=[#8])=[#8]):[#6]:[#6]:[#6]:[#6]:3)(-[#8-])=[#8].[Na+].[Na+]',
            'd&c black #4': '[#0]',
            'd&c blue #6': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6]1(-[#6](=[#8])-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2-[#7]-1)-[#6]1(-[#6](=[#8])-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2-[#7]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1',
            'd&c blue #9': '[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:1):[#6](=[#8]):[#6]1:[#6]:[#6](:[#6]3:[#6](:[#6]:1:[#6]:2=[#8]):[#7H]:[#6]1:[#6](:[#6]:[#6]2:[#6](:[#6]:1:[#7H]:3):[#6](=[#8]):[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1:[#6]:2=[#8])-[#17])-[#17]',
            'd&c green #5': '[#6]-[#6]1:[#6]:[#6](:[#6](:[#6]:[#6]:1)-[#7]-[#6]1:[#6]2:[#6](:[#6](:[#6]:[#6]:1)-[#7]-[#6]1:[#6](:[#6]:[#6](:[#6]:[#6]:1)-[#6])-[#16](=[#8])(=[#8])-[#8-])-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-2=[#8])-[#16](=[#8])(=[#8])-[#8-].[Na+].[Na+]',
            'd&c green #6': '[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#7]-[#6]1:[#6]2:[#6](:[#6](:[#6]:[#6]:1)-[#7]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6])-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-2=[#8]',
            'd&c red #17': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#7]=[#7]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#7]=[#7]-[#6]1:[#6](:[#6]:[#6]:[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:1:2)-[#8]',
            'd&c violet #2': '[#6]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#7]-[#6]1:[#6]2:[#6](:[#6](:[#6]:[#6]:1)-[#8])-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6]-2=[#8]',
            'd&c yellow # 8': '[#6]1:[#6]:[#6]:[#6](:[#6](:[#6]:1)-[#6]1:[#6]2:[#6]:[#6]:[#6](=[#8]):[#6]:[#6]-2:[#8]:[#6]2:[#6]:1:[#6]:[#6]:[#6](:[#6]:2)-[#8])-[#6](=[#8])-[#8]',
            'd&c yellow #10 ': '[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:1)-[#6](=[#8])-[#6](-[#6]-2=[#8])-[#6]1:[#7]:[#6]2:[#6](:[#6]:[#6](:[#6]:[#6]:2:[#6]:[#6]:1)-[#16](=[#8])(=[#8])-[#8-])-[#16](=[#8])(=[#8])-[#8-].[Na+].[Na+]',
            '6-ethoxy-2-(6-ethoxy-3-oxobenzo[b]thien-2-(3h)-ylidene)benzo[b]thiophen-3-(2h)-one': '[#8]=[#6]1-[#6]2:[#6]:[#6]:[#6](-[#8]-[#6]-[#6]):[#6]:[#6]:2-[#16]-[#6]-1=[#6]1-[#6](-[#6]2:[#6]:[#6]:[#6](-[#8]-[#6]-[#6]):[#6]:[#6]:2-[#16]-1)=[#8]',
            'fd&c blue #2': '[#6]-[#6]-[#7](-[#6]-[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1)-[#16](=[#8])(=[#8])-[#8-])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](=[#6]1-[#6]=[#6]-[#6](=[#7+](-[#6]-[#6])-[#6]-[#6]2:[#6]:[#6](:[#6]:[#6]:[#6]:2)-[#16](=[#8])(=[#8])-[#8])-[#6]=[#6]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#16](=[#8])(=[#8])-[#8].[#7]',
            'fd&c blue #2 aluminum lake on alumina': '[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1-[#16](=[#8])(=[#8])-[#8]):[#6](:[#6](:[#7H]:2)-[#6]1=[#7]-[#6]2:[#6](-[#6]-1=[#8]):[#6]:[#6](:[#6]:[#6]:2)-[#16](=[#8])(=[#8])-[#8])-[#8].[Al+3]',
            'iron oxides, synthetic': '[#8]=[Fe]-[#8]-[Fe]=[#8]',
            'ferric ammonium citrate': '[#6](-[#6](=[#8])-[#8-])-[#6](-[#6]-[#6](=[#8])-[#8-])(-[#6](=[#8])-[#8-])-[#8].[#7].[Fe+3]',
            'logwood extract': '[#6]1-[#6]2:[#6]:[#6](:[#6](:[#6]:[#6]:2-[#6]2-[#6]-1(-[#6]-[#8]-[#6]1:[#6]-2:[#6]:[#6]:[#6](:[#6]:1-[#8])-[#8])-[#8])-[#8])-[#8]',
            'mica-based pearlescent pigments': '[#0]',
            '[phthalocyaninato(2-)] copper': '[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:1)-[#6]1=[#7]-[#6]3=[#7]-[#6](=[#7]-[#6]4=[#7]-[#6](=[#7]-[#6]5=[#7]-[#6](=[#7]-[#6]-2=[#7]-1)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-5)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-4)-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-3.[Cu]',
            'phthalocyanine green': '[#6]12:[#6](:[#6](:[#6](:[#6](:[#6]:1-[#17])-[#17])-[#17])-[#17]):[#6]1:[#7]:[#6]3:[#7]:[#6](:[#7]:[#6]4:[#7]:[#6](:[#7]:[#6]5:[#6]6:[#6](:[#6](:[#7-]:5):[#7]:[#6]:2:[#7-]:1):[#6](:[#6](:[#6](:[#6]:6-[#17])-[#17])-[#17])-[#17])-[#6]1:[#6]-4:[#6](:[#6](:[#6](:[#6]:1-[#17])-[#17])-[#17])-[#17])-[#6]1:[#6]-3:[#6](:[#6](:[#6](:[#6]:1-[#17])-[#17])-[#17])-[#17].[Cu+2]',
            'hydroxyethyl methacrylate dye': '[#6]-[#6](=[#6])-[#6](=[#8])-[#8]-[#6]-[#6]-[#8]',
            'pyrogallol': '[#6]1:[#6]:[#6](:[#6](:[#6](:[#6]:1)-[#8])-[#8])-[#8]',
            'titanium dioxide': '[#8]=[Ti]=[#8]',
            'vinyl alcohol': '[#6]=[#6]-[#8]',
        }

        return smarts