"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("@aws-cdk/aws-events");
const core_1 = require("@aws-cdk/core");
/**
 * Use an Event Bridge event bus as a Lambda destination.
 *
 * If no event bus is specified, the default event bus is used.
 *
 * @stability stable
 */
class EventBridgeDestination {
    /**
     * @default - use the default event bus
     * @stability stable
     */
    constructor(eventBus) {
        this.eventBus = eventBus;
    }
    /**
     * Returns a destination configuration.
     *
     * @stability stable
     */
    bind(_scope, fn, _options) {
        if (this.eventBus) {
            this.eventBus.grantPutEventsTo(fn);
            return {
                destination: this.eventBus.eventBusArn,
            };
        }
        const existingDefaultEventBus = _scope.node.tryFindChild('DefaultEventBus');
        let eventBus = existingDefaultEventBus || events.EventBus.fromEventBusArn(_scope, 'DefaultEventBus', core_1.Stack.of(fn).formatArn({
            service: 'events',
            resource: 'event-bus',
            resourceName: 'default',
        }));
        eventBus.grantPutEventsTo(fn);
        return {
            destination: eventBus.eventBusArn,
        };
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
_a = JSII_RTTI_SYMBOL_1;
EventBridgeDestination[_a] = { fqn: "@aws-cdk/aws-lambda-destinations.EventBridgeDestination", version: "1.140.0" };
//# sourceMappingURL=data:application/json;base64,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