# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables

__all__ = [
    'AppProfileSingleClusterRoutingArgs',
    'ConnectionCloudSqlArgs',
    'ConnectionCloudSqlCredentialArgs',
    'DataTransferConfigSensitiveParamsArgs',
    'DatasetAccessArgs',
    'DatasetAccessViewArgs',
    'DatasetDefaultEncryptionConfigurationArgs',
    'DatasetIamBindingConditionArgs',
    'DatasetIamMemberConditionArgs',
    'IamBindingConditionArgs',
    'IamMemberConditionArgs',
    'JobCopyArgs',
    'JobCopyDestinationEncryptionConfigurationArgs',
    'JobCopyDestinationTableArgs',
    'JobCopySourceTableArgs',
    'JobExtractArgs',
    'JobExtractSourceModelArgs',
    'JobExtractSourceTableArgs',
    'JobLoadArgs',
    'JobLoadDestinationEncryptionConfigurationArgs',
    'JobLoadDestinationTableArgs',
    'JobLoadTimePartitioningArgs',
    'JobQueryArgs',
    'JobQueryDefaultDatasetArgs',
    'JobQueryDestinationEncryptionConfigurationArgs',
    'JobQueryDestinationTableArgs',
    'JobQueryScriptOptionsArgs',
    'JobQueryUserDefinedFunctionResourceArgs',
    'TableEncryptionConfigurationArgs',
    'TableExternalDataConfigurationArgs',
    'TableExternalDataConfigurationCsvOptionsArgs',
    'TableExternalDataConfigurationGoogleSheetsOptionsArgs',
    'TableExternalDataConfigurationHivePartitioningOptionsArgs',
    'TableRangePartitioningArgs',
    'TableRangePartitioningRangeArgs',
    'TableTimePartitioningArgs',
    'TableViewArgs',
]

@pulumi.input_type
class AppProfileSingleClusterRoutingArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 allow_transactional_writes: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] cluster_id: The cluster to which read/write requests should be routed.
        :param pulumi.Input[bool] allow_transactional_writes: If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.
               It is unsafe to send these requests to the same table/row/column in multiple clusters.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if allow_transactional_writes is not None:
            pulumi.set(__self__, "allow_transactional_writes", allow_transactional_writes)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The cluster to which read/write requests should be routed.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="allowTransactionalWrites")
    def allow_transactional_writes(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, CheckAndMutateRow and ReadModifyWriteRow requests are allowed by this app profile.
        It is unsafe to send these requests to the same table/row/column in multiple clusters.
        """
        return pulumi.get(self, "allow_transactional_writes")

    @allow_transactional_writes.setter
    def allow_transactional_writes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_transactional_writes", value)


@pulumi.input_type
class ConnectionCloudSqlArgs:
    def __init__(__self__, *,
                 credential: pulumi.Input['ConnectionCloudSqlCredentialArgs'],
                 database: pulumi.Input[str],
                 instance_id: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input['ConnectionCloudSqlCredentialArgs'] credential: Cloud SQL properties.
               Structure is documented below.
        :param pulumi.Input[str] database: Database name.
        :param pulumi.Input[str] instance_id: Cloud SQL instance ID in the form project:location:instance.
        :param pulumi.Input[str] type: Type of the Cloud SQL database.
               Possible values are `DATABASE_TYPE_UNSPECIFIED`, `POSTGRES`, and `MYSQL`.
        """
        pulumi.set(__self__, "credential", credential)
        pulumi.set(__self__, "database", database)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Input['ConnectionCloudSqlCredentialArgs']:
        """
        Cloud SQL properties.
        Structure is documented below.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: pulumi.Input['ConnectionCloudSqlCredentialArgs']):
        pulumi.set(self, "credential", value)

    @property
    @pulumi.getter
    def database(self) -> pulumi.Input[str]:
        """
        Database name.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: pulumi.Input[str]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Cloud SQL instance ID in the form project:location:instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Type of the Cloud SQL database.
        Possible values are `DATABASE_TYPE_UNSPECIFIED`, `POSTGRES`, and `MYSQL`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class ConnectionCloudSqlCredentialArgs:
    def __init__(__self__, *,
                 password: pulumi.Input[str],
                 username: pulumi.Input[str]):
        """
        :param pulumi.Input[str] password: Password for database.
               **Note**: This property is sensitive and will not be displayed in the plan.
        :param pulumi.Input[str] username: Username for database.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Password for database.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[str]:
        """
        Username for database.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[str]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class DataTransferConfigSensitiveParamsArgs:
    def __init__(__self__, *,
                 secret_access_key: pulumi.Input[str]):
        """
        :param pulumi.Input[str] secret_access_key: The Secret Access Key of the AWS account transferring data from.
               **Note**: This property is sensitive and will not be displayed in the plan.
        """
        pulumi.set(__self__, "secret_access_key", secret_access_key)

    @property
    @pulumi.getter(name="secretAccessKey")
    def secret_access_key(self) -> pulumi.Input[str]:
        """
        The Secret Access Key of the AWS account transferring data from.
        **Note**: This property is sensitive and will not be displayed in the plan.
        """
        return pulumi.get(self, "secret_access_key")

    @secret_access_key.setter
    def secret_access_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "secret_access_key", value)


@pulumi.input_type
class DatasetAccessArgs:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[str]] = None,
                 group_by_email: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 special_group: Optional[pulumi.Input[str]] = None,
                 user_by_email: Optional[pulumi.Input[str]] = None,
                 view: Optional[pulumi.Input['DatasetAccessViewArgs']] = None):
        """
        :param pulumi.Input[str] domain: A domain to grant access to. Any users signed in with the
               domain specified will be granted the specified access
        :param pulumi.Input[str] group_by_email: An email address of a Google Group to grant access to.
        :param pulumi.Input[str] role: Describes the rights granted to the user specified by the other
               member of the access object. Primitive, Predefined and custom
               roles are supported. Predefined roles that have equivalent
               primitive roles are swapped by the API to their Primitive
               counterparts. See
               [official docs](https://cloud.google.com/bigquery/docs/access-control).
        :param pulumi.Input[str] special_group: A special group to grant access to. Possible values include:
        :param pulumi.Input[str] user_by_email: An email address of a user to grant access to. For example:
               fred@example.com
        :param pulumi.Input['DatasetAccessViewArgs'] view: A view from a different dataset to grant access to. Queries
               executed against that view will have read access to tables in
               this dataset. The role field is not required when this field is
               set. If that view is updated by any user, access to the view
               needs to be granted again via an update operation.
               Structure is documented below.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if group_by_email is not None:
            pulumi.set(__self__, "group_by_email", group_by_email)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if special_group is not None:
            pulumi.set(__self__, "special_group", special_group)
        if user_by_email is not None:
            pulumi.set(__self__, "user_by_email", user_by_email)
        if view is not None:
            pulumi.set(__self__, "view", view)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        A domain to grant access to. Any users signed in with the
        domain specified will be granted the specified access
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="groupByEmail")
    def group_by_email(self) -> Optional[pulumi.Input[str]]:
        """
        An email address of a Google Group to grant access to.
        """
        return pulumi.get(self, "group_by_email")

    @group_by_email.setter
    def group_by_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_by_email", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the rights granted to the user specified by the other
        member of the access object. Primitive, Predefined and custom
        roles are supported. Predefined roles that have equivalent
        primitive roles are swapped by the API to their Primitive
        counterparts. See
        [official docs](https://cloud.google.com/bigquery/docs/access-control).
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter(name="specialGroup")
    def special_group(self) -> Optional[pulumi.Input[str]]:
        """
        A special group to grant access to. Possible values include:
        """
        return pulumi.get(self, "special_group")

    @special_group.setter
    def special_group(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "special_group", value)

    @property
    @pulumi.getter(name="userByEmail")
    def user_by_email(self) -> Optional[pulumi.Input[str]]:
        """
        An email address of a user to grant access to. For example:
        fred@example.com
        """
        return pulumi.get(self, "user_by_email")

    @user_by_email.setter
    def user_by_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_by_email", value)

    @property
    @pulumi.getter
    def view(self) -> Optional[pulumi.Input['DatasetAccessViewArgs']]:
        """
        A view from a different dataset to grant access to. Queries
        executed against that view will have read access to tables in
        this dataset. The role field is not required when this field is
        set. If that view is updated by any user, access to the view
        needs to be granted again via an update operation.
        Structure is documented below.
        """
        return pulumi.get(self, "view")

    @view.setter
    def view(self, value: Optional[pulumi.Input['DatasetAccessViewArgs']]):
        pulumi.set(self, "view", value)


@pulumi.input_type
class DatasetAccessViewArgs:
    def __init__(__self__, *,
                 dataset_id: pulumi.Input[str],
                 project_id: pulumi.Input[str],
                 table_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] dataset_id: The ID of the dataset containing this table.
        :param pulumi.Input[str] project_id: The ID of the project containing this table.
        :param pulumi.Input[str] table_id: The ID of the table. The ID must contain only letters (a-z,
               A-Z), numbers (0-9), or underscores (_). The maximum length
               is 1,024 characters.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Input[str]:
        """
        The ID of the dataset containing this table.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of the project containing this table.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Input[str]:
        """
        The ID of the table. The ID must contain only letters (a-z,
        A-Z), numbers (0-9), or underscores (_). The maximum length
        is 1,024 characters.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_id", value)


@pulumi.input_type
class DatasetDefaultEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination
               BigQuery table. The BigQuery Service Account associated with your project requires
               access to this encryption key.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[str]:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination
        BigQuery table. The BigQuery Service Account associated with your project requires
        access to this encryption key.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class DatasetIamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class DatasetIamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class IamBindingConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] title: A title for the expression, i.e. a short string describing its purpose.
        :param pulumi.Input[str] description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class IamMemberConditionArgs:
    def __init__(__self__, *,
                 expression: pulumi.Input[str],
                 title: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] title: A title for the expression, i.e. a short string describing its purpose.
        :param pulumi.Input[str] description: An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        A title for the expression, i.e. a short string describing its purpose.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class JobCopyArgs:
    def __init__(__self__, *,
                 source_tables: pulumi.Input[List[pulumi.Input['JobCopySourceTableArgs']]],
                 create_disposition: Optional[pulumi.Input[str]] = None,
                 destination_encryption_configuration: Optional[pulumi.Input['JobCopyDestinationEncryptionConfigurationArgs']] = None,
                 destination_table: Optional[pulumi.Input['JobCopyDestinationTableArgs']] = None,
                 write_disposition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[List[pulumi.Input['JobCopySourceTableArgs']]] source_tables: Source tables to copy.
               Structure is documented below.
        :param pulumi.Input[str] create_disposition: Specifies whether the job is allowed to create new tables. The following values are supported:
               CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
               CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
               Creation, truncation and append actions occur as one atomic update upon job completion
               Default value is `CREATE_IF_NEEDED`.
               Possible values are `CREATE_IF_NEEDED` and `CREATE_NEVER`.
        :param pulumi.Input['JobCopyDestinationEncryptionConfigurationArgs'] destination_encryption_configuration: Custom encryption configuration (e.g., Cloud KMS keys)
               Structure is documented below.
        :param pulumi.Input['JobCopyDestinationTableArgs'] destination_table: The destination table.
               Structure is documented below.
        :param pulumi.Input[str] write_disposition: Specifies the action that occurs if the destination table already exists. The following values are supported:
               WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
               WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
               WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
               Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
               Creation, truncation and append actions occur as one atomic update upon job completion.
               Default value is `WRITE_EMPTY`.
               Possible values are `WRITE_TRUNCATE`, `WRITE_APPEND`, and `WRITE_EMPTY`.
        """
        pulumi.set(__self__, "source_tables", source_tables)
        if create_disposition is not None:
            pulumi.set(__self__, "create_disposition", create_disposition)
        if destination_encryption_configuration is not None:
            pulumi.set(__self__, "destination_encryption_configuration", destination_encryption_configuration)
        if destination_table is not None:
            pulumi.set(__self__, "destination_table", destination_table)
        if write_disposition is not None:
            pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="sourceTables")
    def source_tables(self) -> pulumi.Input[List[pulumi.Input['JobCopySourceTableArgs']]]:
        """
        Source tables to copy.
        Structure is documented below.
        """
        return pulumi.get(self, "source_tables")

    @source_tables.setter
    def source_tables(self, value: pulumi.Input[List[pulumi.Input['JobCopySourceTableArgs']]]):
        pulumi.set(self, "source_tables", value)

    @property
    @pulumi.getter(name="createDisposition")
    def create_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the job is allowed to create new tables. The following values are supported:
        CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
        CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
        Creation, truncation and append actions occur as one atomic update upon job completion
        Default value is `CREATE_IF_NEEDED`.
        Possible values are `CREATE_IF_NEEDED` and `CREATE_NEVER`.
        """
        return pulumi.get(self, "create_disposition")

    @create_disposition.setter
    def create_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_disposition", value)

    @property
    @pulumi.getter(name="destinationEncryptionConfiguration")
    def destination_encryption_configuration(self) -> Optional[pulumi.Input['JobCopyDestinationEncryptionConfigurationArgs']]:
        """
        Custom encryption configuration (e.g., Cloud KMS keys)
        Structure is documented below.
        """
        return pulumi.get(self, "destination_encryption_configuration")

    @destination_encryption_configuration.setter
    def destination_encryption_configuration(self, value: Optional[pulumi.Input['JobCopyDestinationEncryptionConfigurationArgs']]):
        pulumi.set(self, "destination_encryption_configuration", value)

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> Optional[pulumi.Input['JobCopyDestinationTableArgs']]:
        """
        The destination table.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_table")

    @destination_table.setter
    def destination_table(self, value: Optional[pulumi.Input['JobCopyDestinationTableArgs']]):
        pulumi.set(self, "destination_table", value)

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the action that occurs if the destination table already exists. The following values are supported:
        WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
        WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
        WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
        Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
        Creation, truncation and append actions occur as one atomic update upon job completion.
        Default value is `WRITE_EMPTY`.
        Possible values are `WRITE_TRUNCATE`, `WRITE_APPEND`, and `WRITE_EMPTY`.
        """
        return pulumi.get(self, "write_disposition")

    @write_disposition.setter
    def write_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "write_disposition", value)


@pulumi.input_type
class JobCopyDestinationEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
               The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[str]:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
        The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class JobCopyDestinationTableArgs:
    def __init__(__self__, *,
                 table_id: pulumi.Input[str],
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] table_id: The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
               or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        :param pulumi.Input[str] dataset_id: The ID of the dataset containing this model.
        :param pulumi.Input[str] project_id: The ID of the project containing this model.
        """
        pulumi.set(__self__, "table_id", table_id)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Input[str]:
        """
        The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
        or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_id", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dataset containing this model.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project containing this model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class JobCopySourceTableArgs:
    def __init__(__self__, *,
                 table_id: pulumi.Input[str],
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] table_id: The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
               or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        :param pulumi.Input[str] dataset_id: The ID of the dataset containing this model.
        :param pulumi.Input[str] project_id: The ID of the project containing this model.
        """
        pulumi.set(__self__, "table_id", table_id)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Input[str]:
        """
        The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
        or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_id", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dataset containing this model.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project containing this model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class JobExtractArgs:
    def __init__(__self__, *,
                 destination_uris: pulumi.Input[List[pulumi.Input[str]]],
                 compression: Optional[pulumi.Input[str]] = None,
                 destination_format: Optional[pulumi.Input[str]] = None,
                 field_delimiter: Optional[pulumi.Input[str]] = None,
                 print_header: Optional[pulumi.Input[bool]] = None,
                 source_model: Optional[pulumi.Input['JobExtractSourceModelArgs']] = None,
                 source_table: Optional[pulumi.Input['JobExtractSourceTableArgs']] = None,
                 use_avro_logical_types: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[List[pulumi.Input[str]]] destination_uris: A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.
        :param pulumi.Input[str] compression: The compression type to use for exported files. Possible values include GZIP, DEFLATE, SNAPPY, and NONE.
               The default value is NONE. DEFLATE and SNAPPY are only supported for Avro.
        :param pulumi.Input[str] destination_format: The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON and AVRO for tables and SAVED_MODEL for models.
               The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV.
               The default value for models is SAVED_MODEL.
        :param pulumi.Input[str] field_delimiter: When extracting data in CSV format, this defines the delimiter to use between fields in the exported data.
               Default is ','
        :param pulumi.Input[bool] print_header: Whether to print out a header row in the results. Default is true.
        :param pulumi.Input['JobExtractSourceModelArgs'] source_model: A reference to the model being exported.
               Structure is documented below.
        :param pulumi.Input['JobExtractSourceTableArgs'] source_table: A reference to the table being exported.
               Structure is documented below.
        :param pulumi.Input[bool] use_avro_logical_types: Whether to use logical types when extracting to AVRO format.
        """
        pulumi.set(__self__, "destination_uris", destination_uris)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if destination_format is not None:
            pulumi.set(__self__, "destination_format", destination_format)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if print_header is not None:
            pulumi.set(__self__, "print_header", print_header)
        if source_model is not None:
            pulumi.set(__self__, "source_model", source_model)
        if source_table is not None:
            pulumi.set(__self__, "source_table", source_table)
        if use_avro_logical_types is not None:
            pulumi.set(__self__, "use_avro_logical_types", use_avro_logical_types)

    @property
    @pulumi.getter(name="destinationUris")
    def destination_uris(self) -> pulumi.Input[List[pulumi.Input[str]]]:
        """
        A list of fully-qualified Google Cloud Storage URIs where the extracted table should be written.
        """
        return pulumi.get(self, "destination_uris")

    @destination_uris.setter
    def destination_uris(self, value: pulumi.Input[List[pulumi.Input[str]]]):
        pulumi.set(self, "destination_uris", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[str]]:
        """
        The compression type to use for exported files. Possible values include GZIP, DEFLATE, SNAPPY, and NONE.
        The default value is NONE. DEFLATE and SNAPPY are only supported for Avro.
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="destinationFormat")
    def destination_format(self) -> Optional[pulumi.Input[str]]:
        """
        The exported file format. Possible values include CSV, NEWLINE_DELIMITED_JSON and AVRO for tables and SAVED_MODEL for models.
        The default value for tables is CSV. Tables with nested or repeated fields cannot be exported as CSV.
        The default value for models is SAVED_MODEL.
        """
        return pulumi.get(self, "destination_format")

    @destination_format.setter
    def destination_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_format", value)

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        When extracting data in CSV format, this defines the delimiter to use between fields in the exported data.
        Default is ','
        """
        return pulumi.get(self, "field_delimiter")

    @field_delimiter.setter
    def field_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_delimiter", value)

    @property
    @pulumi.getter(name="printHeader")
    def print_header(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to print out a header row in the results. Default is true.
        """
        return pulumi.get(self, "print_header")

    @print_header.setter
    def print_header(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "print_header", value)

    @property
    @pulumi.getter(name="sourceModel")
    def source_model(self) -> Optional[pulumi.Input['JobExtractSourceModelArgs']]:
        """
        A reference to the model being exported.
        Structure is documented below.
        """
        return pulumi.get(self, "source_model")

    @source_model.setter
    def source_model(self, value: Optional[pulumi.Input['JobExtractSourceModelArgs']]):
        pulumi.set(self, "source_model", value)

    @property
    @pulumi.getter(name="sourceTable")
    def source_table(self) -> Optional[pulumi.Input['JobExtractSourceTableArgs']]:
        """
        A reference to the table being exported.
        Structure is documented below.
        """
        return pulumi.get(self, "source_table")

    @source_table.setter
    def source_table(self, value: Optional[pulumi.Input['JobExtractSourceTableArgs']]):
        pulumi.set(self, "source_table", value)

    @property
    @pulumi.getter(name="useAvroLogicalTypes")
    def use_avro_logical_types(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use logical types when extracting to AVRO format.
        """
        return pulumi.get(self, "use_avro_logical_types")

    @use_avro_logical_types.setter
    def use_avro_logical_types(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_avro_logical_types", value)


@pulumi.input_type
class JobExtractSourceModelArgs:
    def __init__(__self__, *,
                 dataset_id: pulumi.Input[str],
                 model_id: pulumi.Input[str],
                 project_id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] dataset_id: The ID of the dataset containing this model.
        :param pulumi.Input[str] model_id: The ID of the model.
        :param pulumi.Input[str] project_id: The ID of the project containing this model.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "model_id", model_id)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Input[str]:
        """
        The ID of the dataset containing this model.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> pulumi.Input[str]:
        """
        The ID of the model.
        """
        return pulumi.get(self, "model_id")

    @model_id.setter
    def model_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "model_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Input[str]:
        """
        The ID of the project containing this model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class JobExtractSourceTableArgs:
    def __init__(__self__, *,
                 table_id: pulumi.Input[str],
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] table_id: The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
               or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        :param pulumi.Input[str] dataset_id: The ID of the dataset containing this model.
        :param pulumi.Input[str] project_id: The ID of the project containing this model.
        """
        pulumi.set(__self__, "table_id", table_id)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Input[str]:
        """
        The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
        or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_id", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dataset containing this model.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project containing this model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class JobLoadArgs:
    def __init__(__self__, *,
                 destination_table: pulumi.Input['JobLoadDestinationTableArgs'],
                 source_uris: pulumi.Input[List[pulumi.Input[str]]],
                 allow_jagged_rows: Optional[pulumi.Input[bool]] = None,
                 allow_quoted_newlines: Optional[pulumi.Input[bool]] = None,
                 autodetect: Optional[pulumi.Input[bool]] = None,
                 create_disposition: Optional[pulumi.Input[str]] = None,
                 destination_encryption_configuration: Optional[pulumi.Input['JobLoadDestinationEncryptionConfigurationArgs']] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 field_delimiter: Optional[pulumi.Input[str]] = None,
                 ignore_unknown_values: Optional[pulumi.Input[bool]] = None,
                 max_bad_records: Optional[pulumi.Input[float]] = None,
                 null_marker: Optional[pulumi.Input[str]] = None,
                 projection_fields: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 quote: Optional[pulumi.Input[str]] = None,
                 schema_update_options: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 skip_leading_rows: Optional[pulumi.Input[float]] = None,
                 source_format: Optional[pulumi.Input[str]] = None,
                 time_partitioning: Optional[pulumi.Input['JobLoadTimePartitioningArgs']] = None,
                 write_disposition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input['JobLoadDestinationTableArgs'] destination_table: The destination table.
               Structure is documented below.
        :param pulumi.Input[List[pulumi.Input[str]]] source_uris: The fully-qualified URIs that point to your data in Google Cloud.
               For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character
               and it must come after the 'bucket' name. Size limits related to load jobs apply
               to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be
               specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table.
               For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
        :param pulumi.Input[bool] allow_jagged_rows: Accept rows that are missing trailing optional columns. The missing values are treated as nulls.
               If false, records with missing trailing columns are treated as bad records, and if there are too many bad records,
               an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
        :param pulumi.Input[bool] allow_quoted_newlines: Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file.
               The default value is false.
        :param pulumi.Input[bool] autodetect: Indicates if we should automatically infer the options and schema for CSV and JSON sources.
        :param pulumi.Input[str] create_disposition: Specifies whether the job is allowed to create new tables. The following values are supported:
               CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
               CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
               Creation, truncation and append actions occur as one atomic update upon job completion
               Default value is `CREATE_IF_NEEDED`.
               Possible values are `CREATE_IF_NEEDED` and `CREATE_NEVER`.
        :param pulumi.Input['JobLoadDestinationEncryptionConfigurationArgs'] destination_encryption_configuration: Custom encryption configuration (e.g., Cloud KMS keys)
               Structure is documented below.
        :param pulumi.Input[str] encoding: The character encoding of the data. The supported values are UTF-8 or ISO-8859-1.
               The default value is UTF-8. BigQuery decodes the data after the raw, binary data
               has been split using the values of the quote and fieldDelimiter properties.
        :param pulumi.Input[str] field_delimiter: When extracting data in CSV format, this defines the delimiter to use between fields in the exported data.
               Default is ','
        :param pulumi.Input[bool] ignore_unknown_values: Indicates if BigQuery should allow extra values that are not represented in the table schema.
               If true, the extra values are ignored. If false, records with extra columns are treated as bad records,
               and if there are too many bad records, an invalid error is returned in the job result.
               The default value is false. The sourceFormat property determines what BigQuery treats as an extra value:
               CSV: Trailing columns
               JSON: Named values that don't match any column names
        :param pulumi.Input[float] max_bad_records: The maximum number of bad records that BigQuery can ignore when running the job. If the number of bad records exceeds this value,
               an invalid error is returned in the job result. The default value is 0, which requires that all records are valid.
        :param pulumi.Input[str] null_marker: Specifies a string that represents a null value in a CSV file. The default value is the empty string. If you set this
               property to a custom value, BigQuery throws an error if an
               empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as
               an empty value.
        :param pulumi.Input[List[pulumi.Input[str]]] projection_fields: If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup.
               Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties.
               If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
        :param pulumi.Input[str] quote: The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding,
               and then uses the first byte of the encoded string to split the data in its raw, binary state.
               The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string.
               If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        :param pulumi.Input[List[pulumi.Input[str]]] schema_update_options: Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or
               supplied in the job configuration. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
               when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators.
               For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified:
               ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
               ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        :param pulumi.Input[float] skip_leading_rows: The number of rows at the top of a CSV file that BigQuery will skip when loading the data.
               The default value is 0. This property is useful if you have header rows in the file that should be skipped.
               When autodetect is on, the behavior is the following:
               skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected,
               the row is read as data. Otherwise data is read starting from the second row.
               skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row.
               skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected,
               row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        :param pulumi.Input[str] source_format: The format of the data files. For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP".
               For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET".
               For orc, specify "ORC". The default value is CSV.
        :param pulumi.Input['JobLoadTimePartitioningArgs'] time_partitioning: Time-based partitioning specification for the destination table.
               Structure is documented below.
        :param pulumi.Input[str] write_disposition: Specifies the action that occurs if the destination table already exists. The following values are supported:
               WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
               WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
               WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
               Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
               Creation, truncation and append actions occur as one atomic update upon job completion.
               Default value is `WRITE_EMPTY`.
               Possible values are `WRITE_TRUNCATE`, `WRITE_APPEND`, and `WRITE_EMPTY`.
        """
        pulumi.set(__self__, "destination_table", destination_table)
        pulumi.set(__self__, "source_uris", source_uris)
        if allow_jagged_rows is not None:
            pulumi.set(__self__, "allow_jagged_rows", allow_jagged_rows)
        if allow_quoted_newlines is not None:
            pulumi.set(__self__, "allow_quoted_newlines", allow_quoted_newlines)
        if autodetect is not None:
            pulumi.set(__self__, "autodetect", autodetect)
        if create_disposition is not None:
            pulumi.set(__self__, "create_disposition", create_disposition)
        if destination_encryption_configuration is not None:
            pulumi.set(__self__, "destination_encryption_configuration", destination_encryption_configuration)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if ignore_unknown_values is not None:
            pulumi.set(__self__, "ignore_unknown_values", ignore_unknown_values)
        if max_bad_records is not None:
            pulumi.set(__self__, "max_bad_records", max_bad_records)
        if null_marker is not None:
            pulumi.set(__self__, "null_marker", null_marker)
        if projection_fields is not None:
            pulumi.set(__self__, "projection_fields", projection_fields)
        if quote is not None:
            pulumi.set(__self__, "quote", quote)
        if schema_update_options is not None:
            pulumi.set(__self__, "schema_update_options", schema_update_options)
        if skip_leading_rows is not None:
            pulumi.set(__self__, "skip_leading_rows", skip_leading_rows)
        if source_format is not None:
            pulumi.set(__self__, "source_format", source_format)
        if time_partitioning is not None:
            pulumi.set(__self__, "time_partitioning", time_partitioning)
        if write_disposition is not None:
            pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> pulumi.Input['JobLoadDestinationTableArgs']:
        """
        The destination table.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_table")

    @destination_table.setter
    def destination_table(self, value: pulumi.Input['JobLoadDestinationTableArgs']):
        pulumi.set(self, "destination_table", value)

    @property
    @pulumi.getter(name="sourceUris")
    def source_uris(self) -> pulumi.Input[List[pulumi.Input[str]]]:
        """
        The fully-qualified URIs that point to your data in Google Cloud.
        For Google Cloud Storage URIs: Each URI can contain one '*' wildcard character
        and it must come after the 'bucket' name. Size limits related to load jobs apply
        to external data sources. For Google Cloud Bigtable URIs: Exactly one URI can be
        specified and it has be a fully specified and valid HTTPS URL for a Google Cloud Bigtable table.
        For Google Cloud Datastore backups: Exactly one URI can be specified. Also, the '*' wildcard character is not allowed.
        """
        return pulumi.get(self, "source_uris")

    @source_uris.setter
    def source_uris(self, value: pulumi.Input[List[pulumi.Input[str]]]):
        pulumi.set(self, "source_uris", value)

    @property
    @pulumi.getter(name="allowJaggedRows")
    def allow_jagged_rows(self) -> Optional[pulumi.Input[bool]]:
        """
        Accept rows that are missing trailing optional columns. The missing values are treated as nulls.
        If false, records with missing trailing columns are treated as bad records, and if there are too many bad records,
        an invalid error is returned in the job result. The default value is false. Only applicable to CSV, ignored for other formats.
        """
        return pulumi.get(self, "allow_jagged_rows")

    @allow_jagged_rows.setter
    def allow_jagged_rows(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_jagged_rows", value)

    @property
    @pulumi.getter(name="allowQuotedNewlines")
    def allow_quoted_newlines(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if BigQuery should allow quoted data sections that contain newline characters in a CSV file.
        The default value is false.
        """
        return pulumi.get(self, "allow_quoted_newlines")

    @allow_quoted_newlines.setter
    def allow_quoted_newlines(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_quoted_newlines", value)

    @property
    @pulumi.getter
    def autodetect(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if we should automatically infer the options and schema for CSV and JSON sources.
        """
        return pulumi.get(self, "autodetect")

    @autodetect.setter
    def autodetect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autodetect", value)

    @property
    @pulumi.getter(name="createDisposition")
    def create_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the job is allowed to create new tables. The following values are supported:
        CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
        CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
        Creation, truncation and append actions occur as one atomic update upon job completion
        Default value is `CREATE_IF_NEEDED`.
        Possible values are `CREATE_IF_NEEDED` and `CREATE_NEVER`.
        """
        return pulumi.get(self, "create_disposition")

    @create_disposition.setter
    def create_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_disposition", value)

    @property
    @pulumi.getter(name="destinationEncryptionConfiguration")
    def destination_encryption_configuration(self) -> Optional[pulumi.Input['JobLoadDestinationEncryptionConfigurationArgs']]:
        """
        Custom encryption configuration (e.g., Cloud KMS keys)
        Structure is documented below.
        """
        return pulumi.get(self, "destination_encryption_configuration")

    @destination_encryption_configuration.setter
    def destination_encryption_configuration(self, value: Optional[pulumi.Input['JobLoadDestinationEncryptionConfigurationArgs']]):
        pulumi.set(self, "destination_encryption_configuration", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        The character encoding of the data. The supported values are UTF-8 or ISO-8859-1.
        The default value is UTF-8. BigQuery decodes the data after the raw, binary data
        has been split using the values of the quote and fieldDelimiter properties.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        When extracting data in CSV format, this defines the delimiter to use between fields in the exported data.
        Default is ','
        """
        return pulumi.get(self, "field_delimiter")

    @field_delimiter.setter
    def field_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_delimiter", value)

    @property
    @pulumi.getter(name="ignoreUnknownValues")
    def ignore_unknown_values(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if BigQuery should allow extra values that are not represented in the table schema.
        If true, the extra values are ignored. If false, records with extra columns are treated as bad records,
        and if there are too many bad records, an invalid error is returned in the job result.
        The default value is false. The sourceFormat property determines what BigQuery treats as an extra value:
        CSV: Trailing columns
        JSON: Named values that don't match any column names
        """
        return pulumi.get(self, "ignore_unknown_values")

    @ignore_unknown_values.setter
    def ignore_unknown_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_unknown_values", value)

    @property
    @pulumi.getter(name="maxBadRecords")
    def max_bad_records(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum number of bad records that BigQuery can ignore when running the job. If the number of bad records exceeds this value,
        an invalid error is returned in the job result. The default value is 0, which requires that all records are valid.
        """
        return pulumi.get(self, "max_bad_records")

    @max_bad_records.setter
    def max_bad_records(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_bad_records", value)

    @property
    @pulumi.getter(name="nullMarker")
    def null_marker(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a string that represents a null value in a CSV file. The default value is the empty string. If you set this
        property to a custom value, BigQuery throws an error if an
        empty string is present for all data types except for STRING and BYTE. For STRING and BYTE columns, BigQuery interprets the empty string as
        an empty value.
        """
        return pulumi.get(self, "null_marker")

    @null_marker.setter
    def null_marker(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "null_marker", value)

    @property
    @pulumi.getter(name="projectionFields")
    def projection_fields(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        If sourceFormat is set to "DATASTORE_BACKUP", indicates which entity properties to load into BigQuery from a Cloud Datastore backup.
        Property names are case sensitive and must be top-level properties. If no properties are specified, BigQuery loads all properties.
        If any named property isn't found in the Cloud Datastore backup, an invalid error is returned in the job result.
        """
        return pulumi.get(self, "projection_fields")

    @projection_fields.setter
    def projection_fields(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "projection_fields", value)

    @property
    @pulumi.getter
    def quote(self) -> Optional[pulumi.Input[str]]:
        """
        The value that is used to quote data sections in a CSV file. BigQuery converts the string to ISO-8859-1 encoding,
        and then uses the first byte of the encoded string to split the data in its raw, binary state.
        The default value is a double-quote ('"'). If your data does not contain quoted sections, set the property value to an empty string.
        If your data contains quoted newline characters, you must also set the allowQuotedNewlines property to true.
        """
        return pulumi.get(self, "quote")

    @quote.setter
    def quote(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "quote", value)

    @property
    @pulumi.getter(name="schemaUpdateOptions")
    def schema_update_options(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or
        supplied in the job configuration. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
        when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators.
        For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified:
        ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
        ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        """
        return pulumi.get(self, "schema_update_options")

    @schema_update_options.setter
    def schema_update_options(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "schema_update_options", value)

    @property
    @pulumi.getter(name="skipLeadingRows")
    def skip_leading_rows(self) -> Optional[pulumi.Input[float]]:
        """
        The number of rows at the top of a CSV file that BigQuery will skip when loading the data.
        The default value is 0. This property is useful if you have header rows in the file that should be skipped.
        When autodetect is on, the behavior is the following:
        skipLeadingRows unspecified - Autodetect tries to detect headers in the first row. If they are not detected,
        the row is read as data. Otherwise data is read starting from the second row.
        skipLeadingRows is 0 - Instructs autodetect that there are no headers and data should be read starting from the first row.
        skipLeadingRows = N > 0 - Autodetect skips N-1 rows and tries to detect headers in row N. If headers are not detected,
        row N is just skipped. Otherwise row N is used to extract column names for the detected schema.
        """
        return pulumi.get(self, "skip_leading_rows")

    @skip_leading_rows.setter
    def skip_leading_rows(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "skip_leading_rows", value)

    @property
    @pulumi.getter(name="sourceFormat")
    def source_format(self) -> Optional[pulumi.Input[str]]:
        """
        The format of the data files. For CSV files, specify "CSV". For datastore backups, specify "DATASTORE_BACKUP".
        For newline-delimited JSON, specify "NEWLINE_DELIMITED_JSON". For Avro, specify "AVRO". For parquet, specify "PARQUET".
        For orc, specify "ORC". The default value is CSV.
        """
        return pulumi.get(self, "source_format")

    @source_format.setter
    def source_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_format", value)

    @property
    @pulumi.getter(name="timePartitioning")
    def time_partitioning(self) -> Optional[pulumi.Input['JobLoadTimePartitioningArgs']]:
        """
        Time-based partitioning specification for the destination table.
        Structure is documented below.
        """
        return pulumi.get(self, "time_partitioning")

    @time_partitioning.setter
    def time_partitioning(self, value: Optional[pulumi.Input['JobLoadTimePartitioningArgs']]):
        pulumi.set(self, "time_partitioning", value)

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the action that occurs if the destination table already exists. The following values are supported:
        WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
        WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
        WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
        Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
        Creation, truncation and append actions occur as one atomic update upon job completion.
        Default value is `WRITE_EMPTY`.
        Possible values are `WRITE_TRUNCATE`, `WRITE_APPEND`, and `WRITE_EMPTY`.
        """
        return pulumi.get(self, "write_disposition")

    @write_disposition.setter
    def write_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "write_disposition", value)


@pulumi.input_type
class JobLoadDestinationEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
               The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[str]:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
        The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class JobLoadDestinationTableArgs:
    def __init__(__self__, *,
                 table_id: pulumi.Input[str],
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] table_id: The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
               or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        :param pulumi.Input[str] dataset_id: The ID of the dataset containing this model.
        :param pulumi.Input[str] project_id: The ID of the project containing this model.
        """
        pulumi.set(__self__, "table_id", table_id)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Input[str]:
        """
        The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
        or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_id", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dataset containing this model.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project containing this model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class JobLoadTimePartitioningArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 expiration_ms: Optional[pulumi.Input[str]] = None,
                 field: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] type: The only type supported is DAY, which will generate one partition per day. Providing an empty string used to cause an error,
               but in OnePlatform the field will be treated as unset.
        :param pulumi.Input[str] expiration_ms: Number of milliseconds for which to keep the storage for a partition. A wrapper is used here because 0 is an invalid value.
        :param pulumi.Input[str] field: If not set, the table is partitioned by pseudo column '_PARTITIONTIME'; if set, the table is partitioned by this field.
               The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
               A wrapper is used here because an empty string is an invalid value.
        """
        pulumi.set(__self__, "type", type)
        if expiration_ms is not None:
            pulumi.set(__self__, "expiration_ms", expiration_ms)
        if field is not None:
            pulumi.set(__self__, "field", field)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The only type supported is DAY, which will generate one partition per day. Providing an empty string used to cause an error,
        but in OnePlatform the field will be treated as unset.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="expirationMs")
    def expiration_ms(self) -> Optional[pulumi.Input[str]]:
        """
        Number of milliseconds for which to keep the storage for a partition. A wrapper is used here because 0 is an invalid value.
        """
        return pulumi.get(self, "expiration_ms")

    @expiration_ms.setter
    def expiration_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_ms", value)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        If not set, the table is partitioned by pseudo column '_PARTITIONTIME'; if set, the table is partitioned by this field.
        The field must be a top-level TIMESTAMP or DATE field. Its mode must be NULLABLE or REQUIRED.
        A wrapper is used here because an empty string is an invalid value.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)


@pulumi.input_type
class JobQueryArgs:
    def __init__(__self__, *,
                 query: pulumi.Input[str],
                 allow_large_results: Optional[pulumi.Input[bool]] = None,
                 create_disposition: Optional[pulumi.Input[str]] = None,
                 default_dataset: Optional[pulumi.Input['JobQueryDefaultDatasetArgs']] = None,
                 destination_encryption_configuration: Optional[pulumi.Input['JobQueryDestinationEncryptionConfigurationArgs']] = None,
                 destination_table: Optional[pulumi.Input['JobQueryDestinationTableArgs']] = None,
                 flatten_results: Optional[pulumi.Input[bool]] = None,
                 maximum_billing_tier: Optional[pulumi.Input[float]] = None,
                 maximum_bytes_billed: Optional[pulumi.Input[str]] = None,
                 parameter_mode: Optional[pulumi.Input[str]] = None,
                 priority: Optional[pulumi.Input[str]] = None,
                 schema_update_options: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 script_options: Optional[pulumi.Input['JobQueryScriptOptionsArgs']] = None,
                 use_legacy_sql: Optional[pulumi.Input[bool]] = None,
                 use_query_cache: Optional[pulumi.Input[bool]] = None,
                 user_defined_function_resources: Optional[pulumi.Input[List[pulumi.Input['JobQueryUserDefinedFunctionResourceArgs']]]] = None,
                 write_disposition: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] query: Configures a query job.
               Structure is documented below.
        :param pulumi.Input[bool] allow_large_results: If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance.
               Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed.
               However, you must still set destinationTable when result size exceeds the allowed maximum response size.
        :param pulumi.Input[str] create_disposition: Specifies whether the job is allowed to create new tables. The following values are supported:
               CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
               CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
               Creation, truncation and append actions occur as one atomic update upon job completion
               Default value is `CREATE_IF_NEEDED`.
               Possible values are `CREATE_IF_NEEDED` and `CREATE_NEVER`.
        :param pulumi.Input['JobQueryDefaultDatasetArgs'] default_dataset: Specifies the default dataset to use for unqualified table names in the query. Note that this does not alter behavior of unqualified dataset names.
               Structure is documented below.
        :param pulumi.Input['JobQueryDestinationEncryptionConfigurationArgs'] destination_encryption_configuration: Custom encryption configuration (e.g., Cloud KMS keys)
               Structure is documented below.
        :param pulumi.Input['JobQueryDestinationTableArgs'] destination_table: The destination table.
               Structure is documented below.
        :param pulumi.Input[bool] flatten_results: If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results.
               allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
        :param pulumi.Input[float] maximum_billing_tier: Limits the billing tier for this job. Queries that have resource usage beyond this tier will fail (without incurring a charge).
               If unspecified, this will be set to your project default.
        :param pulumi.Input[str] maximum_bytes_billed: Limits the bytes billed for this job. Queries that will have bytes billed beyond this limit will fail (without incurring a charge).
               If unspecified, this will be set to your project default.
        :param pulumi.Input[str] parameter_mode: Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
        :param pulumi.Input[str] priority: Specifies a priority for the query.
               Default value is `INTERACTIVE`.
               Possible values are `INTERACTIVE` and `BATCH`.
        :param pulumi.Input[List[pulumi.Input[str]]] schema_update_options: Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or
               supplied in the job configuration. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
               when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators.
               For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified:
               ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
               ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        :param pulumi.Input['JobQueryScriptOptionsArgs'] script_options: Options controlling the execution of scripts.
               Structure is documented below.
        :param pulumi.Input[bool] use_legacy_sql: Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is true.
               If set to false, the query will use BigQuery's standard SQL.
        :param pulumi.Input[bool] use_query_cache: Whether to look for the result in the query cache. The query cache is a best-effort cache that will be flushed whenever
               tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified.
               The default value is true.
        :param pulumi.Input[List[pulumi.Input['JobQueryUserDefinedFunctionResourceArgs']]] user_defined_function_resources: Describes user-defined function resources used in the query.
               Structure is documented below.
        :param pulumi.Input[str] write_disposition: Specifies the action that occurs if the destination table already exists. The following values are supported:
               WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
               WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
               WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
               Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
               Creation, truncation and append actions occur as one atomic update upon job completion.
               Default value is `WRITE_EMPTY`.
               Possible values are `WRITE_TRUNCATE`, `WRITE_APPEND`, and `WRITE_EMPTY`.
        """
        pulumi.set(__self__, "query", query)
        if allow_large_results is not None:
            pulumi.set(__self__, "allow_large_results", allow_large_results)
        if create_disposition is not None:
            pulumi.set(__self__, "create_disposition", create_disposition)
        if default_dataset is not None:
            pulumi.set(__self__, "default_dataset", default_dataset)
        if destination_encryption_configuration is not None:
            pulumi.set(__self__, "destination_encryption_configuration", destination_encryption_configuration)
        if destination_table is not None:
            pulumi.set(__self__, "destination_table", destination_table)
        if flatten_results is not None:
            pulumi.set(__self__, "flatten_results", flatten_results)
        if maximum_billing_tier is not None:
            pulumi.set(__self__, "maximum_billing_tier", maximum_billing_tier)
        if maximum_bytes_billed is not None:
            pulumi.set(__self__, "maximum_bytes_billed", maximum_bytes_billed)
        if parameter_mode is not None:
            pulumi.set(__self__, "parameter_mode", parameter_mode)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if schema_update_options is not None:
            pulumi.set(__self__, "schema_update_options", schema_update_options)
        if script_options is not None:
            pulumi.set(__self__, "script_options", script_options)
        if use_legacy_sql is not None:
            pulumi.set(__self__, "use_legacy_sql", use_legacy_sql)
        if use_query_cache is not None:
            pulumi.set(__self__, "use_query_cache", use_query_cache)
        if user_defined_function_resources is not None:
            pulumi.set(__self__, "user_defined_function_resources", user_defined_function_resources)
        if write_disposition is not None:
            pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        Configures a query job.
        Structure is documented below.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="allowLargeResults")
    def allow_large_results(self) -> Optional[pulumi.Input[bool]]:
        """
        If true and query uses legacy SQL dialect, allows the query to produce arbitrarily large result tables at a slight cost in performance.
        Requires destinationTable to be set. For standard SQL queries, this flag is ignored and large results are always allowed.
        However, you must still set destinationTable when result size exceeds the allowed maximum response size.
        """
        return pulumi.get(self, "allow_large_results")

    @allow_large_results.setter
    def allow_large_results(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_large_results", value)

    @property
    @pulumi.getter(name="createDisposition")
    def create_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether the job is allowed to create new tables. The following values are supported:
        CREATE_IF_NEEDED: If the table does not exist, BigQuery creates the table.
        CREATE_NEVER: The table must already exist. If it does not, a 'notFound' error is returned in the job result.
        Creation, truncation and append actions occur as one atomic update upon job completion
        Default value is `CREATE_IF_NEEDED`.
        Possible values are `CREATE_IF_NEEDED` and `CREATE_NEVER`.
        """
        return pulumi.get(self, "create_disposition")

    @create_disposition.setter
    def create_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_disposition", value)

    @property
    @pulumi.getter(name="defaultDataset")
    def default_dataset(self) -> Optional[pulumi.Input['JobQueryDefaultDatasetArgs']]:
        """
        Specifies the default dataset to use for unqualified table names in the query. Note that this does not alter behavior of unqualified dataset names.
        Structure is documented below.
        """
        return pulumi.get(self, "default_dataset")

    @default_dataset.setter
    def default_dataset(self, value: Optional[pulumi.Input['JobQueryDefaultDatasetArgs']]):
        pulumi.set(self, "default_dataset", value)

    @property
    @pulumi.getter(name="destinationEncryptionConfiguration")
    def destination_encryption_configuration(self) -> Optional[pulumi.Input['JobQueryDestinationEncryptionConfigurationArgs']]:
        """
        Custom encryption configuration (e.g., Cloud KMS keys)
        Structure is documented below.
        """
        return pulumi.get(self, "destination_encryption_configuration")

    @destination_encryption_configuration.setter
    def destination_encryption_configuration(self, value: Optional[pulumi.Input['JobQueryDestinationEncryptionConfigurationArgs']]):
        pulumi.set(self, "destination_encryption_configuration", value)

    @property
    @pulumi.getter(name="destinationTable")
    def destination_table(self) -> Optional[pulumi.Input['JobQueryDestinationTableArgs']]:
        """
        The destination table.
        Structure is documented below.
        """
        return pulumi.get(self, "destination_table")

    @destination_table.setter
    def destination_table(self, value: Optional[pulumi.Input['JobQueryDestinationTableArgs']]):
        pulumi.set(self, "destination_table", value)

    @property
    @pulumi.getter(name="flattenResults")
    def flatten_results(self) -> Optional[pulumi.Input[bool]]:
        """
        If true and query uses legacy SQL dialect, flattens all nested and repeated fields in the query results.
        allowLargeResults must be true if this is set to false. For standard SQL queries, this flag is ignored and results are never flattened.
        """
        return pulumi.get(self, "flatten_results")

    @flatten_results.setter
    def flatten_results(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "flatten_results", value)

    @property
    @pulumi.getter(name="maximumBillingTier")
    def maximum_billing_tier(self) -> Optional[pulumi.Input[float]]:
        """
        Limits the billing tier for this job. Queries that have resource usage beyond this tier will fail (without incurring a charge).
        If unspecified, this will be set to your project default.
        """
        return pulumi.get(self, "maximum_billing_tier")

    @maximum_billing_tier.setter
    def maximum_billing_tier(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "maximum_billing_tier", value)

    @property
    @pulumi.getter(name="maximumBytesBilled")
    def maximum_bytes_billed(self) -> Optional[pulumi.Input[str]]:
        """
        Limits the bytes billed for this job. Queries that will have bytes billed beyond this limit will fail (without incurring a charge).
        If unspecified, this will be set to your project default.
        """
        return pulumi.get(self, "maximum_bytes_billed")

    @maximum_bytes_billed.setter
    def maximum_bytes_billed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maximum_bytes_billed", value)

    @property
    @pulumi.getter(name="parameterMode")
    def parameter_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Standard SQL only. Set to POSITIONAL to use positional (?) query parameters or to NAMED to use named (@myparam) query parameters in this query.
        """
        return pulumi.get(self, "parameter_mode")

    @parameter_mode.setter
    def parameter_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parameter_mode", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a priority for the query.
        Default value is `INTERACTIVE`.
        Possible values are `INTERACTIVE` and `BATCH`.
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "priority", value)

    @property
    @pulumi.getter(name="schemaUpdateOptions")
    def schema_update_options(self) -> Optional[pulumi.Input[List[pulumi.Input[str]]]]:
        """
        Allows the schema of the destination table to be updated as a side effect of the load job if a schema is autodetected or
        supplied in the job configuration. Schema update options are supported in two cases: when writeDisposition is WRITE_APPEND;
        when writeDisposition is WRITE_TRUNCATE and the destination table is a partition of a table, specified by partition decorators.
        For normal tables, WRITE_TRUNCATE will always overwrite the schema. One or more of the following values are specified:
        ALLOW_FIELD_ADDITION: allow adding a nullable field to the schema.
        ALLOW_FIELD_RELAXATION: allow relaxing a required field in the original schema to nullable.
        """
        return pulumi.get(self, "schema_update_options")

    @schema_update_options.setter
    def schema_update_options(self, value: Optional[pulumi.Input[List[pulumi.Input[str]]]]):
        pulumi.set(self, "schema_update_options", value)

    @property
    @pulumi.getter(name="scriptOptions")
    def script_options(self) -> Optional[pulumi.Input['JobQueryScriptOptionsArgs']]:
        """
        Options controlling the execution of scripts.
        Structure is documented below.
        """
        return pulumi.get(self, "script_options")

    @script_options.setter
    def script_options(self, value: Optional[pulumi.Input['JobQueryScriptOptionsArgs']]):
        pulumi.set(self, "script_options", value)

    @property
    @pulumi.getter(name="useLegacySql")
    def use_legacy_sql(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use BigQuery's legacy SQL dialect for this query. The default value is true.
        If set to false, the query will use BigQuery's standard SQL.
        """
        return pulumi.get(self, "use_legacy_sql")

    @use_legacy_sql.setter
    def use_legacy_sql(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_legacy_sql", value)

    @property
    @pulumi.getter(name="useQueryCache")
    def use_query_cache(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to look for the result in the query cache. The query cache is a best-effort cache that will be flushed whenever
        tables in the query are modified. Moreover, the query cache is only available when a query does not have a destination table specified.
        The default value is true.
        """
        return pulumi.get(self, "use_query_cache")

    @use_query_cache.setter
    def use_query_cache(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_query_cache", value)

    @property
    @pulumi.getter(name="userDefinedFunctionResources")
    def user_defined_function_resources(self) -> Optional[pulumi.Input[List[pulumi.Input['JobQueryUserDefinedFunctionResourceArgs']]]]:
        """
        Describes user-defined function resources used in the query.
        Structure is documented below.
        """
        return pulumi.get(self, "user_defined_function_resources")

    @user_defined_function_resources.setter
    def user_defined_function_resources(self, value: Optional[pulumi.Input[List[pulumi.Input['JobQueryUserDefinedFunctionResourceArgs']]]]):
        pulumi.set(self, "user_defined_function_resources", value)

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the action that occurs if the destination table already exists. The following values are supported:
        WRITE_TRUNCATE: If the table already exists, BigQuery overwrites the table data and uses the schema from the query result.
        WRITE_APPEND: If the table already exists, BigQuery appends the data to the table.
        WRITE_EMPTY: If the table already exists and contains data, a 'duplicate' error is returned in the job result.
        Each action is atomic and only occurs if BigQuery is able to complete the job successfully.
        Creation, truncation and append actions occur as one atomic update upon job completion.
        Default value is `WRITE_EMPTY`.
        Possible values are `WRITE_TRUNCATE`, `WRITE_APPEND`, and `WRITE_EMPTY`.
        """
        return pulumi.get(self, "write_disposition")

    @write_disposition.setter
    def write_disposition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "write_disposition", value)


@pulumi.input_type
class JobQueryDefaultDatasetArgs:
    def __init__(__self__, *,
                 dataset_id: pulumi.Input[str],
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] dataset_id: The ID of the dataset containing this model.
        :param pulumi.Input[str] project_id: The ID of the project containing this model.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Input[str]:
        """
        The ID of the dataset containing this model.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project containing this model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class JobQueryDestinationEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kms_key_name: Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
               The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[str]:
        """
        Describes the Cloud KMS encryption key that will be used to protect destination BigQuery table.
        The BigQuery Service Account associated with your project requires access to this encryption key.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class JobQueryDestinationTableArgs:
    def __init__(__self__, *,
                 table_id: pulumi.Input[str],
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] table_id: The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
               or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        :param pulumi.Input[str] dataset_id: The ID of the dataset containing this model.
        :param pulumi.Input[str] project_id: The ID of the project containing this model.
        """
        pulumi.set(__self__, "table_id", table_id)
        if dataset_id is not None:
            pulumi.set(__self__, "dataset_id", dataset_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> pulumi.Input[str]:
        """
        The table. Can be specified `{{table_id}}` if `project_id` and `dataset_id` are also set,
        or of the form `projects/{{project}}/datasets/{{dataset_id}}/tables/{{table_id}}` if not.
        """
        return pulumi.get(self, "table_id")

    @table_id.setter
    def table_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "table_id", value)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the dataset containing this model.
        """
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project containing this model.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)


@pulumi.input_type
class JobQueryScriptOptionsArgs:
    def __init__(__self__, *,
                 key_result_statement: Optional[pulumi.Input[str]] = None,
                 statement_byte_budget: Optional[pulumi.Input[str]] = None,
                 statement_timeout_ms: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key_result_statement: Determines which statement in the script represents the "key result",
               used to populate the schema and query results of the script job.
               Possible values are `LAST` and `FIRST_SELECT`.
        :param pulumi.Input[str] statement_byte_budget: Limit on the number of bytes billed per statement. Exceeding this budget results in an error.
        :param pulumi.Input[str] statement_timeout_ms: Timeout period for each statement in a script.
        """
        if key_result_statement is not None:
            pulumi.set(__self__, "key_result_statement", key_result_statement)
        if statement_byte_budget is not None:
            pulumi.set(__self__, "statement_byte_budget", statement_byte_budget)
        if statement_timeout_ms is not None:
            pulumi.set(__self__, "statement_timeout_ms", statement_timeout_ms)

    @property
    @pulumi.getter(name="keyResultStatement")
    def key_result_statement(self) -> Optional[pulumi.Input[str]]:
        """
        Determines which statement in the script represents the "key result",
        used to populate the schema and query results of the script job.
        Possible values are `LAST` and `FIRST_SELECT`.
        """
        return pulumi.get(self, "key_result_statement")

    @key_result_statement.setter
    def key_result_statement(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_result_statement", value)

    @property
    @pulumi.getter(name="statementByteBudget")
    def statement_byte_budget(self) -> Optional[pulumi.Input[str]]:
        """
        Limit on the number of bytes billed per statement. Exceeding this budget results in an error.
        """
        return pulumi.get(self, "statement_byte_budget")

    @statement_byte_budget.setter
    def statement_byte_budget(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statement_byte_budget", value)

    @property
    @pulumi.getter(name="statementTimeoutMs")
    def statement_timeout_ms(self) -> Optional[pulumi.Input[str]]:
        """
        Timeout period for each statement in a script.
        """
        return pulumi.get(self, "statement_timeout_ms")

    @statement_timeout_ms.setter
    def statement_timeout_ms(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statement_timeout_ms", value)


@pulumi.input_type
class JobQueryUserDefinedFunctionResourceArgs:
    def __init__(__self__, *,
                 inline_code: Optional[pulumi.Input[str]] = None,
                 resource_uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] inline_code: An inline resource that contains code for a user-defined function (UDF).
               Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
        :param pulumi.Input[str] resource_uri: A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
        """
        if inline_code is not None:
            pulumi.set(__self__, "inline_code", inline_code)
        if resource_uri is not None:
            pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="inlineCode")
    def inline_code(self) -> Optional[pulumi.Input[str]]:
        """
        An inline resource that contains code for a user-defined function (UDF).
        Providing a inline code resource is equivalent to providing a URI for a file containing the same code.
        """
        return pulumi.get(self, "inline_code")

    @inline_code.setter
    def inline_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "inline_code", value)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Optional[pulumi.Input[str]]:
        """
        A code resource to load from a Google Cloud Storage URI (gs://bucket/path).
        """
        return pulumi.get(self, "resource_uri")

    @resource_uri.setter
    def resource_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_uri", value)


@pulumi.input_type
class TableEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 kms_key_name: pulumi.Input[str]):
        """
        :param pulumi.Input[str] kms_key_name: The self link or full name of a key which should be used to
               encrypt this table.  Note that the default bigquery service account will need to have
               encrypt/decrypt permissions on this key - you may want to see the
               `bigquery.getDefaultServiceAccount` datasource and the
               `kms.CryptoKeyIAMBinding` resource.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Input[str]:
        """
        The self link or full name of a key which should be used to
        encrypt this table.  Note that the default bigquery service account will need to have
        encrypt/decrypt permissions on this key - you may want to see the
        `bigquery.getDefaultServiceAccount` datasource and the
        `kms.CryptoKeyIAMBinding` resource.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class TableExternalDataConfigurationArgs:
    def __init__(__self__, *,
                 autodetect: pulumi.Input[bool],
                 source_format: pulumi.Input[str],
                 source_uris: pulumi.Input[List[pulumi.Input[str]]],
                 compression: Optional[pulumi.Input[str]] = None,
                 csv_options: Optional[pulumi.Input['TableExternalDataConfigurationCsvOptionsArgs']] = None,
                 google_sheets_options: Optional[pulumi.Input['TableExternalDataConfigurationGoogleSheetsOptionsArgs']] = None,
                 hive_partitioning_options: Optional[pulumi.Input['TableExternalDataConfigurationHivePartitioningOptionsArgs']] = None,
                 ignore_unknown_values: Optional[pulumi.Input[bool]] = None,
                 max_bad_records: Optional[pulumi.Input[float]] = None,
                 schema: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[bool] autodetect: - Let BigQuery try to autodetect the schema
               and format of the table.
        :param pulumi.Input[str] source_format: The data format. Supported values are:
               "CSV", "GOOGLE_SHEETS", "NEWLINE_DELIMITED_JSON", "AVRO", "PARQUET",
               and "DATSTORE_BACKUP". To use "GOOGLE_SHEETS"
               the `scopes` must include
               "https://www.googleapis.com/auth/drive.readonly".
        :param pulumi.Input[List[pulumi.Input[str]]] source_uris: A list of the fully-qualified URIs that point to
               your data in Google Cloud.
        :param pulumi.Input[str] compression: The compression type of the data source.
               Valid values are "NONE" or "GZIP".
        :param pulumi.Input['TableExternalDataConfigurationCsvOptionsArgs'] csv_options: Additional properties to set if
               `source_format` is set to "CSV". Structure is documented below.
        :param pulumi.Input['TableExternalDataConfigurationGoogleSheetsOptionsArgs'] google_sheets_options: Additional options if
               `source_format` is set to "GOOGLE_SHEETS". Structure is
               documented below.
        :param pulumi.Input['TableExternalDataConfigurationHivePartitioningOptionsArgs'] hive_partitioning_options: When set, configures hive partitioning
               support. Not all storage formats support hive partitioning -- requesting hive
               partitioning on an unsupported format will lead to an error, as will providing
               an invalid specification.
        :param pulumi.Input[bool] ignore_unknown_values: Indicates if BigQuery should
               allow extra values that are not represented in the table schema.
               If true, the extra values are ignored. If false, records with
               extra columns are treated as bad records, and if there are too
               many bad records, an invalid error is returned in the job result.
               The default value is false.
        :param pulumi.Input[float] max_bad_records: The maximum number of bad records that
               BigQuery can ignore when reading data.
        :param pulumi.Input[str] schema: A JSON schema for the external table. Schema is required
               for CSV and JSON formats if autodetect is not on. Schema is disallowed
               for Google Cloud Bigtable, Cloud Datastore backups, Avro, ORC and Parquet formats.
               ~>**NOTE:** Because this field expects a JSON string, any changes to the
               string will create a diff, even if the JSON itself hasn't changed.
               Furthermore drift for this field cannot not be detected because BigQuery
               only uses this schema to compute the effective schema for the table, therefore
               any changes on the configured value will force the table to be recreated.
               This schema is effectively only applied when creating a table from an external
               datasource, after creation the computed schema will be stored in
               `google_bigquery_table.schema`
        """
        pulumi.set(__self__, "autodetect", autodetect)
        pulumi.set(__self__, "source_format", source_format)
        pulumi.set(__self__, "source_uris", source_uris)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if csv_options is not None:
            pulumi.set(__self__, "csv_options", csv_options)
        if google_sheets_options is not None:
            pulumi.set(__self__, "google_sheets_options", google_sheets_options)
        if hive_partitioning_options is not None:
            pulumi.set(__self__, "hive_partitioning_options", hive_partitioning_options)
        if ignore_unknown_values is not None:
            pulumi.set(__self__, "ignore_unknown_values", ignore_unknown_values)
        if max_bad_records is not None:
            pulumi.set(__self__, "max_bad_records", max_bad_records)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)

    @property
    @pulumi.getter
    def autodetect(self) -> pulumi.Input[bool]:
        """
        - Let BigQuery try to autodetect the schema
        and format of the table.
        """
        return pulumi.get(self, "autodetect")

    @autodetect.setter
    def autodetect(self, value: pulumi.Input[bool]):
        pulumi.set(self, "autodetect", value)

    @property
    @pulumi.getter(name="sourceFormat")
    def source_format(self) -> pulumi.Input[str]:
        """
        The data format. Supported values are:
        "CSV", "GOOGLE_SHEETS", "NEWLINE_DELIMITED_JSON", "AVRO", "PARQUET",
        and "DATSTORE_BACKUP". To use "GOOGLE_SHEETS"
        the `scopes` must include
        "https://www.googleapis.com/auth/drive.readonly".
        """
        return pulumi.get(self, "source_format")

    @source_format.setter
    def source_format(self, value: pulumi.Input[str]):
        pulumi.set(self, "source_format", value)

    @property
    @pulumi.getter(name="sourceUris")
    def source_uris(self) -> pulumi.Input[List[pulumi.Input[str]]]:
        """
        A list of the fully-qualified URIs that point to
        your data in Google Cloud.
        """
        return pulumi.get(self, "source_uris")

    @source_uris.setter
    def source_uris(self, value: pulumi.Input[List[pulumi.Input[str]]]):
        pulumi.set(self, "source_uris", value)

    @property
    @pulumi.getter
    def compression(self) -> Optional[pulumi.Input[str]]:
        """
        The compression type of the data source.
        Valid values are "NONE" or "GZIP".
        """
        return pulumi.get(self, "compression")

    @compression.setter
    def compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compression", value)

    @property
    @pulumi.getter(name="csvOptions")
    def csv_options(self) -> Optional[pulumi.Input['TableExternalDataConfigurationCsvOptionsArgs']]:
        """
        Additional properties to set if
        `source_format` is set to "CSV". Structure is documented below.
        """
        return pulumi.get(self, "csv_options")

    @csv_options.setter
    def csv_options(self, value: Optional[pulumi.Input['TableExternalDataConfigurationCsvOptionsArgs']]):
        pulumi.set(self, "csv_options", value)

    @property
    @pulumi.getter(name="googleSheetsOptions")
    def google_sheets_options(self) -> Optional[pulumi.Input['TableExternalDataConfigurationGoogleSheetsOptionsArgs']]:
        """
        Additional options if
        `source_format` is set to "GOOGLE_SHEETS". Structure is
        documented below.
        """
        return pulumi.get(self, "google_sheets_options")

    @google_sheets_options.setter
    def google_sheets_options(self, value: Optional[pulumi.Input['TableExternalDataConfigurationGoogleSheetsOptionsArgs']]):
        pulumi.set(self, "google_sheets_options", value)

    @property
    @pulumi.getter(name="hivePartitioningOptions")
    def hive_partitioning_options(self) -> Optional[pulumi.Input['TableExternalDataConfigurationHivePartitioningOptionsArgs']]:
        """
        When set, configures hive partitioning
        support. Not all storage formats support hive partitioning -- requesting hive
        partitioning on an unsupported format will lead to an error, as will providing
        an invalid specification.
        """
        return pulumi.get(self, "hive_partitioning_options")

    @hive_partitioning_options.setter
    def hive_partitioning_options(self, value: Optional[pulumi.Input['TableExternalDataConfigurationHivePartitioningOptionsArgs']]):
        pulumi.set(self, "hive_partitioning_options", value)

    @property
    @pulumi.getter(name="ignoreUnknownValues")
    def ignore_unknown_values(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if BigQuery should
        allow extra values that are not represented in the table schema.
        If true, the extra values are ignored. If false, records with
        extra columns are treated as bad records, and if there are too
        many bad records, an invalid error is returned in the job result.
        The default value is false.
        """
        return pulumi.get(self, "ignore_unknown_values")

    @ignore_unknown_values.setter
    def ignore_unknown_values(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_unknown_values", value)

    @property
    @pulumi.getter(name="maxBadRecords")
    def max_bad_records(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum number of bad records that
        BigQuery can ignore when reading data.
        """
        return pulumi.get(self, "max_bad_records")

    @max_bad_records.setter
    def max_bad_records(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_bad_records", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON schema for the external table. Schema is required
        for CSV and JSON formats if autodetect is not on. Schema is disallowed
        for Google Cloud Bigtable, Cloud Datastore backups, Avro, ORC and Parquet formats.
        ~>**NOTE:** Because this field expects a JSON string, any changes to the
        string will create a diff, even if the JSON itself hasn't changed.
        Furthermore drift for this field cannot not be detected because BigQuery
        only uses this schema to compute the effective schema for the table, therefore
        any changes on the configured value will force the table to be recreated.
        This schema is effectively only applied when creating a table from an external
        datasource, after creation the computed schema will be stored in
        `google_bigquery_table.schema`
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)


@pulumi.input_type
class TableExternalDataConfigurationCsvOptionsArgs:
    def __init__(__self__, *,
                 quote: pulumi.Input[str],
                 allow_jagged_rows: Optional[pulumi.Input[bool]] = None,
                 allow_quoted_newlines: Optional[pulumi.Input[bool]] = None,
                 encoding: Optional[pulumi.Input[str]] = None,
                 field_delimiter: Optional[pulumi.Input[str]] = None,
                 skip_leading_rows: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] quote: The value that is used to quote data sections in a
               CSV file. If your data does not contain quoted sections, set the
               property value to an empty string. If your data contains quoted newline
               characters, you must also set the `allow_quoted_newlines` property to true.
               The API-side default is `"`, specified in the provider escaped as `\"`. Due to
               limitations with default values, this value is required to be
               explicitly set.
        :param pulumi.Input[bool] allow_jagged_rows: Indicates if BigQuery should accept rows
               that are missing trailing optional columns.
        :param pulumi.Input[bool] allow_quoted_newlines: Indicates if BigQuery should allow
               quoted data sections that contain newline characters in a CSV file.
               The default value is false.
        :param pulumi.Input[str] encoding: The character encoding of the data. The supported
               values are UTF-8 or ISO-8859-1.
        :param pulumi.Input[str] field_delimiter: The separator for fields in a CSV file.
        :param pulumi.Input[float] skip_leading_rows: The number of rows at the top of the sheet
               that BigQuery will skip when reading the data. At least one of `range` or
               `skip_leading_rows` must be set.
        """
        pulumi.set(__self__, "quote", quote)
        if allow_jagged_rows is not None:
            pulumi.set(__self__, "allow_jagged_rows", allow_jagged_rows)
        if allow_quoted_newlines is not None:
            pulumi.set(__self__, "allow_quoted_newlines", allow_quoted_newlines)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if field_delimiter is not None:
            pulumi.set(__self__, "field_delimiter", field_delimiter)
        if skip_leading_rows is not None:
            pulumi.set(__self__, "skip_leading_rows", skip_leading_rows)

    @property
    @pulumi.getter
    def quote(self) -> pulumi.Input[str]:
        """
        The value that is used to quote data sections in a
        CSV file. If your data does not contain quoted sections, set the
        property value to an empty string. If your data contains quoted newline
        characters, you must also set the `allow_quoted_newlines` property to true.
        The API-side default is `"`, specified in the provider escaped as `\"`. Due to
        limitations with default values, this value is required to be
        explicitly set.
        """
        return pulumi.get(self, "quote")

    @quote.setter
    def quote(self, value: pulumi.Input[str]):
        pulumi.set(self, "quote", value)

    @property
    @pulumi.getter(name="allowJaggedRows")
    def allow_jagged_rows(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if BigQuery should accept rows
        that are missing trailing optional columns.
        """
        return pulumi.get(self, "allow_jagged_rows")

    @allow_jagged_rows.setter
    def allow_jagged_rows(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_jagged_rows", value)

    @property
    @pulumi.getter(name="allowQuotedNewlines")
    def allow_quoted_newlines(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if BigQuery should allow
        quoted data sections that contain newline characters in a CSV file.
        The default value is false.
        """
        return pulumi.get(self, "allow_quoted_newlines")

    @allow_quoted_newlines.setter
    def allow_quoted_newlines(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_quoted_newlines", value)

    @property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[str]]:
        """
        The character encoding of the data. The supported
        values are UTF-8 or ISO-8859-1.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encoding", value)

    @property
    @pulumi.getter(name="fieldDelimiter")
    def field_delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        The separator for fields in a CSV file.
        """
        return pulumi.get(self, "field_delimiter")

    @field_delimiter.setter
    def field_delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_delimiter", value)

    @property
    @pulumi.getter(name="skipLeadingRows")
    def skip_leading_rows(self) -> Optional[pulumi.Input[float]]:
        """
        The number of rows at the top of the sheet
        that BigQuery will skip when reading the data. At least one of `range` or
        `skip_leading_rows` must be set.
        """
        return pulumi.get(self, "skip_leading_rows")

    @skip_leading_rows.setter
    def skip_leading_rows(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "skip_leading_rows", value)


@pulumi.input_type
class TableExternalDataConfigurationGoogleSheetsOptionsArgs:
    def __init__(__self__, *,
                 range: Optional[pulumi.Input[str]] = None,
                 skip_leading_rows: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[str] range: Information required to partition based on ranges.
               Structure is documented below.
        :param pulumi.Input[float] skip_leading_rows: The number of rows at the top of the sheet
               that BigQuery will skip when reading the data. At least one of `range` or
               `skip_leading_rows` must be set.
        """
        if range is not None:
            pulumi.set(__self__, "range", range)
        if skip_leading_rows is not None:
            pulumi.set(__self__, "skip_leading_rows", skip_leading_rows)

    @property
    @pulumi.getter
    def range(self) -> Optional[pulumi.Input[str]]:
        """
        Information required to partition based on ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "range", value)

    @property
    @pulumi.getter(name="skipLeadingRows")
    def skip_leading_rows(self) -> Optional[pulumi.Input[float]]:
        """
        The number of rows at the top of the sheet
        that BigQuery will skip when reading the data. At least one of `range` or
        `skip_leading_rows` must be set.
        """
        return pulumi.get(self, "skip_leading_rows")

    @skip_leading_rows.setter
    def skip_leading_rows(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "skip_leading_rows", value)


@pulumi.input_type
class TableExternalDataConfigurationHivePartitioningOptionsArgs:
    def __init__(__self__, *,
                 mode: Optional[pulumi.Input[str]] = None,
                 source_uri_prefix: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] mode: When set, what mode of hive partitioning to use when
               reading data. The following modes are supported.
               * AUTO: automatically infer partition key name(s) and type(s).
               * STRINGS: automatically infer partition key name(s). All types are
               Not all storage formats support hive partitioning. Requesting hive
               partitioning on an unsupported format will lead to an error.
               Currently supported formats are: JSON, CSV, ORC, Avro and Parquet.
               * CUSTOM: when set to `CUSTOM`, you must encode the partition key schema within the `source_uri_prefix` by setting `source_uri_prefix` to `gs://bucket/path_to_table/{key1:TYPE1}/{key2:TYPE2}/{key3:TYPE3}`.
        :param pulumi.Input[str] source_uri_prefix: When hive partition detection is requested,
               a common for all source uris must be required. The prefix must end immediately
               before the partition key encoding begins. For example, consider files following
               this data layout. `gs://bucket/path_to_table/dt=2019-06-01/country=USA/id=7/file.avro`
               `gs://bucket/path_to_table/dt=2019-05-31/country=CA/id=3/file.avro` When hive
               partitioning is requested with either AUTO or STRINGS detection, the common prefix
               can be either of `gs://bucket/path_to_table` or `gs://bucket/path_to_table/`.
               Note that when `mode` is set to `CUSTOM`, you must encode the partition key schema within the `source_uri_prefix` by setting `source_uri_prefix` to `gs://bucket/path_to_table/{key1:TYPE1}/{key2:TYPE2}/{key3:TYPE3}`.
        """
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if source_uri_prefix is not None:
            pulumi.set(__self__, "source_uri_prefix", source_uri_prefix)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        When set, what mode of hive partitioning to use when
        reading data. The following modes are supported.
        * AUTO: automatically infer partition key name(s) and type(s).
        * STRINGS: automatically infer partition key name(s). All types are
        Not all storage formats support hive partitioning. Requesting hive
        partitioning on an unsupported format will lead to an error.
        Currently supported formats are: JSON, CSV, ORC, Avro and Parquet.
        * CUSTOM: when set to `CUSTOM`, you must encode the partition key schema within the `source_uri_prefix` by setting `source_uri_prefix` to `gs://bucket/path_to_table/{key1:TYPE1}/{key2:TYPE2}/{key3:TYPE3}`.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="sourceUriPrefix")
    def source_uri_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        When hive partition detection is requested,
        a common for all source uris must be required. The prefix must end immediately
        before the partition key encoding begins. For example, consider files following
        this data layout. `gs://bucket/path_to_table/dt=2019-06-01/country=USA/id=7/file.avro`
        `gs://bucket/path_to_table/dt=2019-05-31/country=CA/id=3/file.avro` When hive
        partitioning is requested with either AUTO or STRINGS detection, the common prefix
        can be either of `gs://bucket/path_to_table` or `gs://bucket/path_to_table/`.
        Note that when `mode` is set to `CUSTOM`, you must encode the partition key schema within the `source_uri_prefix` by setting `source_uri_prefix` to `gs://bucket/path_to_table/{key1:TYPE1}/{key2:TYPE2}/{key3:TYPE3}`.
        """
        return pulumi.get(self, "source_uri_prefix")

    @source_uri_prefix.setter
    def source_uri_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_uri_prefix", value)


@pulumi.input_type
class TableRangePartitioningArgs:
    def __init__(__self__, *,
                 field: pulumi.Input[str],
                 range: pulumi.Input['TableRangePartitioningRangeArgs']):
        """
        :param pulumi.Input[str] field: The field used to determine how to create a range-based
               partition.
        :param pulumi.Input['TableRangePartitioningRangeArgs'] range: Information required to partition based on ranges.
               Structure is documented below.
        """
        pulumi.set(__self__, "field", field)
        pulumi.set(__self__, "range", range)

    @property
    @pulumi.getter
    def field(self) -> pulumi.Input[str]:
        """
        The field used to determine how to create a range-based
        partition.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: pulumi.Input[str]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def range(self) -> pulumi.Input['TableRangePartitioningRangeArgs']:
        """
        Information required to partition based on ranges.
        Structure is documented below.
        """
        return pulumi.get(self, "range")

    @range.setter
    def range(self, value: pulumi.Input['TableRangePartitioningRangeArgs']):
        pulumi.set(self, "range", value)


@pulumi.input_type
class TableRangePartitioningRangeArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[float],
                 interval: pulumi.Input[float],
                 start: pulumi.Input[float]):
        """
        :param pulumi.Input[float] end: End of the range partitioning, exclusive.
        :param pulumi.Input[float] interval: The width of each range within the partition.
        :param pulumi.Input[float] start: Start of the range partitioning, inclusive.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> pulumi.Input[float]:
        """
        End of the range partitioning, exclusive.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[float]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Input[float]:
        """
        The width of each range within the partition.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[float]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[float]:
        """
        Start of the range partitioning, inclusive.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[float]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class TableTimePartitioningArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 expiration_ms: Optional[pulumi.Input[float]] = None,
                 field: Optional[pulumi.Input[str]] = None,
                 require_partition_filter: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] type: The only type supported is DAY, which will generate
               one partition per day based on data loading time.
        :param pulumi.Input[float] expiration_ms: Number of milliseconds for which to keep the
               storage for a partition.
        :param pulumi.Input[str] field: The field used to determine how to create a range-based
               partition.
        :param pulumi.Input[bool] require_partition_filter: If set to true, queries over this table
               require a partition filter that can be used for partition elimination to be
               specified.
        """
        pulumi.set(__self__, "type", type)
        if expiration_ms is not None:
            pulumi.set(__self__, "expiration_ms", expiration_ms)
        if field is not None:
            pulumi.set(__self__, "field", field)
        if require_partition_filter is not None:
            pulumi.set(__self__, "require_partition_filter", require_partition_filter)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The only type supported is DAY, which will generate
        one partition per day based on data loading time.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="expirationMs")
    def expiration_ms(self) -> Optional[pulumi.Input[float]]:
        """
        Number of milliseconds for which to keep the
        storage for a partition.
        """
        return pulumi.get(self, "expiration_ms")

    @expiration_ms.setter
    def expiration_ms(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "expiration_ms", value)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        The field used to determine how to create a range-based
        partition.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter(name="requirePartitionFilter")
    def require_partition_filter(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, queries over this table
        require a partition filter that can be used for partition elimination to be
        specified.
        """
        return pulumi.get(self, "require_partition_filter")

    @require_partition_filter.setter
    def require_partition_filter(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_partition_filter", value)


@pulumi.input_type
class TableViewArgs:
    def __init__(__self__, *,
                 query: pulumi.Input[str],
                 use_legacy_sql: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] query: A query that BigQuery executes when the view is referenced.
        :param pulumi.Input[bool] use_legacy_sql: Specifies whether to use BigQuery's legacy SQL for this view.
               The default value is true. If set to false, the view will use BigQuery's standard SQL.
        """
        pulumi.set(__self__, "query", query)
        if use_legacy_sql is not None:
            pulumi.set(__self__, "use_legacy_sql", use_legacy_sql)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        A query that BigQuery executes when the view is referenced.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="useLegacySql")
    def use_legacy_sql(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to use BigQuery's legacy SQL for this view.
        The default value is true. If set to false, the view will use BigQuery's standard SQL.
        """
        return pulumi.get(self, "use_legacy_sql")

    @use_legacy_sql.setter
    def use_legacy_sql(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_legacy_sql", value)


