# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables

__all__ = [
    'GCPolicyMaxAge',
    'GCPolicyMaxVersion',
    'InstanceCluster',
    'InstanceIamBindingCondition',
    'InstanceIamMemberCondition',
    'TableColumnFamily',
]

@pulumi.output_type
class GCPolicyMaxAge(dict):
    def __init__(__self__, *,
                 days: float):
        """
        :param float days: Number of days before applying GC policy.
        """
        pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> float:
        """
        Number of days before applying GC policy.
        """
        return pulumi.get(self, "days")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GCPolicyMaxVersion(dict):
    def __init__(__self__, *,
                 number: float):
        """
        :param float number: Number of version before applying the GC policy.
        """
        pulumi.set(__self__, "number", number)

    @property
    @pulumi.getter
    def number(self) -> float:
        """
        Number of version before applying the GC policy.
        """
        return pulumi.get(self, "number")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class InstanceCluster(dict):
    def __init__(__self__, *,
                 cluster_id: str,
                 zone: str,
                 num_nodes: Optional[float] = None,
                 storage_type: Optional[str] = None):
        """
        :param str cluster_id: The ID of the Cloud Bigtable cluster.
        :param str zone: The zone to create the Cloud Bigtable cluster in. Each
               cluster must have a different zone in the same region. Zones that support
               Bigtable instances are noted on the [Cloud Bigtable locations page](https://cloud.google.com/bigtable/docs/locations).
        :param float num_nodes: The number of nodes in your Cloud Bigtable cluster.
               Required, with a minimum of `1` for a `PRODUCTION` instance. Must be left unset
               for a `DEVELOPMENT` instance.
        :param str storage_type: The storage type to use. One of `"SSD"` or
               `"HDD"`. Defaults to `"SSD"`.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "zone", zone)
        if num_nodes is not None:
            pulumi.set(__self__, "num_nodes", num_nodes)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The ID of the Cloud Bigtable cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The zone to create the Cloud Bigtable cluster in. Each
        cluster must have a different zone in the same region. Zones that support
        Bigtable instances are noted on the [Cloud Bigtable locations page](https://cloud.google.com/bigtable/docs/locations).
        """
        return pulumi.get(self, "zone")

    @property
    @pulumi.getter(name="numNodes")
    def num_nodes(self) -> Optional[float]:
        """
        The number of nodes in your Cloud Bigtable cluster.
        Required, with a minimum of `1` for a `PRODUCTION` instance. Must be left unset
        for a `DEVELOPMENT` instance.
        """
        return pulumi.get(self, "num_nodes")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[str]:
        """
        The storage type to use. One of `"SSD"` or
        `"HDD"`. Defaults to `"SSD"`.
        """
        return pulumi.get(self, "storage_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class InstanceIamBindingCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class InstanceIamMemberCondition(dict):
    def __init__(__self__, *,
                 expression: str,
                 title: str,
                 description: Optional[str] = None):
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "title", title)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def expression(self) -> str:
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def title(self) -> str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TableColumnFamily(dict):
    def __init__(__self__, *,
                 family: str):
        """
        :param str family: The name of the column family.
        """
        pulumi.set(__self__, "family", family)

    @property
    @pulumi.getter
    def family(self) -> str:
        """
        The name of the column family.
        """
        return pulumi.get(self, "family")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


