# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs

__all__ = [
    'TriggerBuild',
    'TriggerBuildSecret',
    'TriggerBuildSource',
    'TriggerBuildSourceRepoSource',
    'TriggerBuildSourceStorageSource',
    'TriggerBuildStep',
    'TriggerBuildStepVolume',
    'TriggerGithub',
    'TriggerGithubPullRequest',
    'TriggerGithubPush',
    'TriggerTriggerTemplate',
]

@pulumi.output_type
class TriggerBuild(dict):
    def __init__(__self__, *,
                 steps: List['outputs.TriggerBuildStep'],
                 images: Optional[List[str]] = None,
                 logs_bucket: Optional[str] = None,
                 queue_ttl: Optional[str] = None,
                 secrets: Optional[List['outputs.TriggerBuildSecret']] = None,
                 source: Optional['outputs.TriggerBuildSource'] = None,
                 substitutions: Optional[Mapping[str, str]] = None,
                 tags: Optional[List[str]] = None,
                 timeout: Optional[str] = None):
        """
        :param List['TriggerBuildStepArgs'] steps: The operations to be performed on the workspace.
               Structure is documented below.
        :param List[str] images: A list of images to be pushed upon the successful completion of all build steps.
               The images are pushed using the builder service account's credentials.
               The digests of the pushed images will be stored in the Build resource's results field.
               If any of the images fail to be pushed, the build status is marked FAILURE.
        :param str logs_bucket: Google Cloud Storage bucket where logs should be written.
               Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        :param str queue_ttl: TTL in queue for this build. If provided and the build is enqueued longer than this value,
               the build will expire and the build status will be EXPIRED.
               The TTL starts ticking from createTime.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param List['TriggerBuildSecretArgs'] secrets: Secrets to decrypt using Cloud Key Management Service.
               Structure is documented below.
        :param 'TriggerBuildSourceArgs' source: The location of the source files to build.
               One of `storageSource` or `repoSource` must be provided.
               Structure is documented below.
        :param Mapping[str, str] substitutions: Substitutions to use in a triggered build. Should only be used with triggers.run
        :param List[str] tags: Tags for annotation of a Build. These are not docker tags.
        :param str timeout: Time limit for executing this build step. If not defined,
               the step has no
               time limit and will be allowed to continue to run until either it
               completes or the build itself times out.
        """
        pulumi.set(__self__, "steps", steps)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if logs_bucket is not None:
            pulumi.set(__self__, "logs_bucket", logs_bucket)
        if queue_ttl is not None:
            pulumi.set(__self__, "queue_ttl", queue_ttl)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def steps(self) -> List['outputs.TriggerBuildStep']:
        """
        The operations to be performed on the workspace.
        Structure is documented below.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def images(self) -> Optional[List[str]]:
        """
        A list of images to be pushed upon the successful completion of all build steps.
        The images are pushed using the builder service account's credentials.
        The digests of the pushed images will be stored in the Build resource's results field.
        If any of the images fail to be pushed, the build status is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="logsBucket")
    def logs_bucket(self) -> Optional[str]:
        """
        Google Cloud Storage bucket where logs should be written.
        Logs file names will be of the format ${logsBucket}/log-${build_id}.txt.
        """
        return pulumi.get(self, "logs_bucket")

    @property
    @pulumi.getter(name="queueTtl")
    def queue_ttl(self) -> Optional[str]:
        """
        TTL in queue for this build. If provided and the build is enqueued longer than this value,
        the build will expire and the build status will be EXPIRED.
        The TTL starts ticking from createTime.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "queue_ttl")

    @property
    @pulumi.getter
    def secrets(self) -> Optional[List['outputs.TriggerBuildSecret']]:
        """
        Secrets to decrypt using Cloud Key Management Service.
        Structure is documented below.
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter
    def source(self) -> Optional['outputs.TriggerBuildSource']:
        """
        The location of the source files to build.
        One of `storageSource` or `repoSource` must be provided.
        Structure is documented below.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def substitutions(self) -> Optional[Mapping[str, str]]:
        """
        Substitutions to use in a triggered build. Should only be used with triggers.run
        """
        return pulumi.get(self, "substitutions")

    @property
    @pulumi.getter
    def tags(self) -> Optional[List[str]]:
        """
        Tags for annotation of a Build. These are not docker tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Time limit for executing this build step. If not defined,
        the step has no
        time limit and will be allowed to continue to run until either it
        completes or the build itself times out.
        """
        return pulumi.get(self, "timeout")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerBuildSecret(dict):
    def __init__(__self__, *,
                 kms_key_name: str,
                 secret_env: Optional[Mapping[str, str]] = None):
        """
        :param str kms_key_name: Cloud KMS key name to use to decrypt these envs.
        :param Mapping[str, str] secret_env: A list of environment variables which are encrypted using
               a Cloud Key
               Management Service crypto key. These values must be specified in
               the build's `Secret`.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        if secret_env is not None:
            pulumi.set(__self__, "secret_env", secret_env)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Cloud KMS key name to use to decrypt these envs.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Optional[Mapping[str, str]]:
        """
        A list of environment variables which are encrypted using
        a Cloud Key
        Management Service crypto key. These values must be specified in
        the build's `Secret`.
        """
        return pulumi.get(self, "secret_env")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerBuildSource(dict):
    def __init__(__self__, *,
                 repo_source: Optional['outputs.TriggerBuildSourceRepoSource'] = None,
                 storage_source: Optional['outputs.TriggerBuildSourceStorageSource'] = None):
        """
        :param 'TriggerBuildSourceRepoSourceArgs' repo_source: Location of the source in a Google Cloud Source Repository.
               Structure is documented below.
        :param 'TriggerBuildSourceStorageSourceArgs' storage_source: Location of the source in an archive file in Google Cloud Storage.
               Structure is documented below.
        """
        if repo_source is not None:
            pulumi.set(__self__, "repo_source", repo_source)
        if storage_source is not None:
            pulumi.set(__self__, "storage_source", storage_source)

    @property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> Optional['outputs.TriggerBuildSourceRepoSource']:
        """
        Location of the source in a Google Cloud Source Repository.
        Structure is documented below.
        """
        return pulumi.get(self, "repo_source")

    @property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> Optional['outputs.TriggerBuildSourceStorageSource']:
        """
        Location of the source in an archive file in Google Cloud Storage.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_source")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerBuildSourceRepoSource(dict):
    def __init__(__self__, *,
                 repo_name: str,
                 branch_name: Optional[str] = None,
                 commit_sha: Optional[str] = None,
                 dir: Optional[str] = None,
                 invert_regex: Optional[bool] = None,
                 project_id: Optional[str] = None,
                 substitutions: Optional[Mapping[str, str]] = None,
                 tag_name: Optional[str] = None):
        """
        :param str repo_name: Name of the Cloud Source Repository.
        :param str branch_name: Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        :param str commit_sha: Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        :param str dir: Working directory to use when running this step's container.
               If this value is a relative path, it is relative to the build's working
               directory. If this value is absolute, it may be outside the build's working
               directory, in which case the contents of the path may not be persisted
               across build step executions, unless a `volume` for that path is specified.
               If the build specifies a `RepoSource` with `dir` and a step with a
               `dir`,
               which specifies an absolute path, the `RepoSource` `dir` is ignored
               for the step's execution.
        :param bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param str project_id: ID of the project that owns the Cloud Source Repository.
               If omitted, the project ID requesting the build is assumed.
        :param Mapping[str, str] substitutions: Substitutions to use in a triggered build. Should only be used with triggers.run
        :param str tag_name: Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        """
        pulumi.set(__self__, "repo_name", repo_name)
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if substitutions is not None:
            pulumi.set(__self__, "substitutions", substitutions)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> str:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[str]:
        """
        Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[str]:
        """
        Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        """
        return pulumi.get(self, "commit_sha")

    @property
    @pulumi.getter
    def dir(self) -> Optional[str]:
        """
        Working directory to use when running this step's container.
        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a `volume` for that path is specified.
        If the build specifies a `RepoSource` with `dir` and a step with a
        `dir`,
        which specifies an absolute path, the `RepoSource` `dir` is ignored
        for the step's execution.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[bool]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        ID of the project that owns the Cloud Source Repository.
        If omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def substitutions(self) -> Optional[Mapping[str, str]]:
        """
        Substitutions to use in a triggered build. Should only be used with triggers.run
        """
        return pulumi.get(self, "substitutions")

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[str]:
        """
        Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerBuildSourceStorageSource(dict):
    def __init__(__self__, *,
                 bucket: str,
                 object: str,
                 generation: Optional[str] = None):
        """
        :param str bucket: Google Cloud Storage bucket containing the source.
        :param str object: Google Cloud Storage object containing the source.
               This object must be a gzipped archive file (.tar.gz) containing source to build.
        :param str generation: Google Cloud Storage generation for the object.
               If the generation is omitted, the latest generation will be used
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "object", object)
        if generation is not None:
            pulumi.set(__self__, "generation", generation)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Google Cloud Storage bucket containing the source.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Google Cloud Storage object containing the source.
        This object must be a gzipped archive file (.tar.gz) containing source to build.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def generation(self) -> Optional[str]:
        """
        Google Cloud Storage generation for the object.
        If the generation is omitted, the latest generation will be used
        """
        return pulumi.get(self, "generation")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerBuildStep(dict):
    def __init__(__self__, *,
                 name: str,
                 args: Optional[List[str]] = None,
                 dir: Optional[str] = None,
                 entrypoint: Optional[str] = None,
                 envs: Optional[List[str]] = None,
                 id: Optional[str] = None,
                 secret_envs: Optional[List[str]] = None,
                 timeout: Optional[str] = None,
                 timing: Optional[str] = None,
                 volumes: Optional[List['outputs.TriggerBuildStepVolume']] = None,
                 wait_fors: Optional[List[str]] = None):
        """
        :param str name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for
               Docker volumes. Each named volume must be used by at least two build steps.
        :param List[str] args: A list of arguments that will be presented to the step when it is started.
               If the image used to run the step's container has an entrypoint, the args
               are used as arguments to that entrypoint. If the image does not define an
               entrypoint, the first element in args is used as the entrypoint, and the
               remainder will be used as arguments.
        :param str dir: Working directory to use when running this step's container.
               If this value is a relative path, it is relative to the build's working
               directory. If this value is absolute, it may be outside the build's working
               directory, in which case the contents of the path may not be persisted
               across build step executions, unless a `volume` for that path is specified.
               If the build specifies a `RepoSource` with `dir` and a step with a
               `dir`,
               which specifies an absolute path, the `RepoSource` `dir` is ignored
               for the step's execution.
        :param str entrypoint: Entrypoint to be used instead of the build step image's
               default entrypoint.
               If unset, the image's default entrypoint is used
        :param List[str] envs: A list of environment variable definitions to be used when
               running a step.
               The elements are of the form "KEY=VALUE" for the environment variable
               "KEY" being given the value "VALUE".
        :param str id: Unique identifier for this build step, used in `wait_for` to
               reference this build step as a dependency.
        :param List[str] secret_envs: A list of environment variables which are encrypted using
               a Cloud Key
               Management Service crypto key. These values must be specified in
               the build's `Secret`.
        :param str timeout: Time limit for executing this build step. If not defined,
               the step has no
               time limit and will be allowed to continue to run until either it
               completes or the build itself times out.
        :param str timing: Output only. Stores timing information for executing this
               build step.
        :param List['TriggerBuildStepVolumeArgs'] volumes: List of volumes to mount into the build step.
               Each volume is created as an empty volume prior to execution of the
               build step. Upon completion of the build, volumes and their contents
               are discarded.
               Using a named volume in only one step is not valid as it is
               indicative of a build request with an incorrect configuration.
               Structure is documented below.
        :param List[str] wait_fors: The ID(s) of the step(s) that this build step depends on.
               This build step will not start until all the build steps in `wait_for`
               have completed successfully. If `wait_for` is empty, this build step
               will start when all previous build steps in the `Build.Steps` list
               have completed successfully.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if entrypoint is not None:
            pulumi.set(__self__, "entrypoint", entrypoint)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if secret_envs is not None:
            pulumi.set(__self__, "secret_envs", secret_envs)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if timing is not None:
            pulumi.set(__self__, "timing", timing)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)
        if wait_fors is not None:
            pulumi.set(__self__, "wait_fors", wait_fors)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for
        Docker volumes. Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def args(self) -> Optional[List[str]]:
        """
        A list of arguments that will be presented to the step when it is started.
        If the image used to run the step's container has an entrypoint, the args
        are used as arguments to that entrypoint. If the image does not define an
        entrypoint, the first element in args is used as the entrypoint, and the
        remainder will be used as arguments.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def dir(self) -> Optional[str]:
        """
        Working directory to use when running this step's container.
        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a `volume` for that path is specified.
        If the build specifies a `RepoSource` with `dir` and a step with a
        `dir`,
        which specifies an absolute path, the `RepoSource` `dir` is ignored
        for the step's execution.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter
    def entrypoint(self) -> Optional[str]:
        """
        Entrypoint to be used instead of the build step image's
        default entrypoint.
        If unset, the image's default entrypoint is used
        """
        return pulumi.get(self, "entrypoint")

    @property
    @pulumi.getter
    def envs(self) -> Optional[List[str]]:
        """
        A list of environment variable definitions to be used when
        running a step.
        The elements are of the form "KEY=VALUE" for the environment variable
        "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for this build step, used in `wait_for` to
        reference this build step as a dependency.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="secretEnvs")
    def secret_envs(self) -> Optional[List[str]]:
        """
        A list of environment variables which are encrypted using
        a Cloud Key
        Management Service crypto key. These values must be specified in
        the build's `Secret`.
        """
        return pulumi.get(self, "secret_envs")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[str]:
        """
        Time limit for executing this build step. If not defined,
        the step has no
        time limit and will be allowed to continue to run until either it
        completes or the build itself times out.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def timing(self) -> Optional[str]:
        """
        Output only. Stores timing information for executing this
        build step.
        """
        return pulumi.get(self, "timing")

    @property
    @pulumi.getter
    def volumes(self) -> Optional[List['outputs.TriggerBuildStepVolume']]:
        """
        List of volumes to mount into the build step.
        Each volume is created as an empty volume prior to execution of the
        build step. Upon completion of the build, volumes and their contents
        are discarded.
        Using a named volume in only one step is not valid as it is
        indicative of a build request with an incorrect configuration.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="waitFors")
    def wait_fors(self) -> Optional[List[str]]:
        """
        The ID(s) of the step(s) that this build step depends on.
        This build step will not start until all the build steps in `wait_for`
        have completed successfully. If `wait_for` is empty, this build step
        will start when all previous build steps in the `Build.Steps` list
        have completed successfully.
        """
        return pulumi.get(self, "wait_fors")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerBuildStepVolume(dict):
    def __init__(__self__, *,
                 name: str,
                 path: str):
        """
        :param str name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for
               Docker volumes. Each named volume must be used by at least two build steps.
        :param str path: Path at which to mount the volume.
               Paths must be absolute and cannot conflict with other volume paths on
               the same build step or with certain reserved volume paths.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for
        Docker volumes. Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path at which to mount the volume.
        Paths must be absolute and cannot conflict with other volume paths on
        the same build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerGithub(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 owner: Optional[str] = None,
                 pull_request: Optional['outputs.TriggerGithubPullRequest'] = None,
                 push: Optional['outputs.TriggerGithubPush'] = None):
        """
        :param str name: Name of the volume to mount.
               Volume names must be unique per build step and must be valid names for
               Docker volumes. Each named volume must be used by at least two build steps.
        :param str owner: Owner of the repository. For example: The owner for
               https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        :param 'TriggerGithubPullRequestArgs' pull_request: filter to match changes in pull requests.  Specify only one of pullRequest or push.
               Structure is documented below.
        :param 'TriggerGithubPushArgs' push: filter to match changes in refs, like branches or tags.  Specify only one of pullRequest or push.
               Structure is documented below.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if pull_request is not None:
            pulumi.set(__self__, "pull_request", pull_request)
        if push is not None:
            pulumi.set(__self__, "push", push)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of the volume to mount.
        Volume names must be unique per build step and must be valid names for
        Docker volumes. Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> Optional[str]:
        """
        Owner of the repository. For example: The owner for
        https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> Optional['outputs.TriggerGithubPullRequest']:
        """
        filter to match changes in pull requests.  Specify only one of pullRequest or push.
        Structure is documented below.
        """
        return pulumi.get(self, "pull_request")

    @property
    @pulumi.getter
    def push(self) -> Optional['outputs.TriggerGithubPush']:
        """
        filter to match changes in refs, like branches or tags.  Specify only one of pullRequest or push.
        Structure is documented below.
        """
        return pulumi.get(self, "push")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerGithubPullRequest(dict):
    def __init__(__self__, *,
                 branch: str,
                 comment_control: Optional[str] = None,
                 invert_regex: Optional[bool] = None):
        """
        :param str branch: Regex of branches to match.  Specify only one of branch or tag.
        :param str comment_control: Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator.
               Possible values are `COMMENTS_DISABLED` and `COMMENTS_ENABLED`.
        :param bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        """
        pulumi.set(__self__, "branch", branch)
        if comment_control is not None:
            pulumi.set(__self__, "comment_control", comment_control)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)

    @property
    @pulumi.getter
    def branch(self) -> str:
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> Optional[str]:
        """
        Whether to block builds on a "/gcbrun" comment from a repository owner or collaborator.
        Possible values are `COMMENTS_DISABLED` and `COMMENTS_ENABLED`.
        """
        return pulumi.get(self, "comment_control")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[bool]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerGithubPush(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 invert_regex: Optional[bool] = None,
                 tag: Optional[str] = None):
        """
        :param str branch: Regex of branches to match.  Specify only one of branch or tag.
        :param bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param str tag: Regex of tags to match.  Specify only one of branch or tag.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        Regex of branches to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[bool]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        Regex of tags to match.  Specify only one of branch or tag.
        """
        return pulumi.get(self, "tag")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TriggerTriggerTemplate(dict):
    def __init__(__self__, *,
                 branch_name: Optional[str] = None,
                 commit_sha: Optional[str] = None,
                 dir: Optional[str] = None,
                 invert_regex: Optional[bool] = None,
                 project_id: Optional[str] = None,
                 repo_name: Optional[str] = None,
                 tag_name: Optional[str] = None):
        """
        :param str branch_name: Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        :param str commit_sha: Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        :param str dir: Working directory to use when running this step's container.
               If this value is a relative path, it is relative to the build's working
               directory. If this value is absolute, it may be outside the build's working
               directory, in which case the contents of the path may not be persisted
               across build step executions, unless a `volume` for that path is specified.
               If the build specifies a `RepoSource` with `dir` and a step with a
               `dir`,
               which specifies an absolute path, the `RepoSource` `dir` is ignored
               for the step's execution.
        :param bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param str project_id: ID of the project that owns the Cloud Source Repository.
               If omitted, the project ID requesting the build is assumed.
        :param str repo_name: Name of the Cloud Source Repository.
        :param str tag_name: Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
               The syntax of the regular expressions accepted is the syntax accepted by RE2 and
               described at https://github.com/google/re2/wiki/Syntax
        """
        if branch_name is not None:
            pulumi.set(__self__, "branch_name", branch_name)
        if commit_sha is not None:
            pulumi.set(__self__, "commit_sha", commit_sha)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if invert_regex is not None:
            pulumi.set(__self__, "invert_regex", invert_regex)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)
        if tag_name is not None:
            pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> Optional[str]:
        """
        Regex matching branches to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> Optional[str]:
        """
        Explicit commit SHA to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        """
        return pulumi.get(self, "commit_sha")

    @property
    @pulumi.getter
    def dir(self) -> Optional[str]:
        """
        Working directory to use when running this step's container.
        If this value is a relative path, it is relative to the build's working
        directory. If this value is absolute, it may be outside the build's working
        directory, in which case the contents of the path may not be persisted
        across build step executions, unless a `volume` for that path is specified.
        If the build specifies a `RepoSource` with `dir` and a step with a
        `dir`,
        which specifies an absolute path, the `RepoSource` `dir` is ignored
        for the step's execution.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> Optional[bool]:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        ID of the project that owns the Cloud Source Repository.
        If omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[str]:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> Optional[str]:
        """
        Regex matching tags to build. Exactly one a of branch name, tag, or commit SHA must be provided.
        The syntax of the regular expressions accepted is the syntax accepted by RE2 and
        described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


