# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables

__all__ = [
    'QueueAppEngineRoutingOverrideArgs',
    'QueueRateLimitsArgs',
    'QueueRetryConfigArgs',
]

@pulumi.input_type
class QueueAppEngineRoutingOverrideArgs:
    def __init__(__self__, *,
                 host: Optional[pulumi.Input[str]] = None,
                 instance: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] host: -
               The host that the task is sent to.
        :param pulumi.Input[str] instance: App instance.
               By default, the task is sent to an instance which is available when the task is attempted.
        :param pulumi.Input[str] service: App service.
               By default, the task is sent to the service which is the default service when the task is attempted.
        :param pulumi.Input[str] version: App version.
               By default, the task is sent to the version which is the default version when the task is attempted.
        """
        if host is not None:
            pulumi.set(__self__, "host", host)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[str]]:
        """
        -
        The host that the task is sent to.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[str]]:
        """
        App instance.
        By default, the task is sent to an instance which is available when the task is attempted.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        App service.
        By default, the task is sent to the service which is the default service when the task is attempted.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        App version.
        By default, the task is sent to the version which is the default version when the task is attempted.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class QueueRateLimitsArgs:
    def __init__(__self__, *,
                 max_burst_size: Optional[pulumi.Input[float]] = None,
                 max_concurrent_dispatches: Optional[pulumi.Input[float]] = None,
                 max_dispatches_per_second: Optional[pulumi.Input[float]] = None):
        """
        :param pulumi.Input[float] max_burst_size: -
               The max burst size.
               Max burst size limits how fast tasks in queue are processed when many tasks are
               in the queue and the rate is high. This field allows the queue to have a high
               rate so processing starts shortly after a task is enqueued, but still limits
               resource usage when many tasks are enqueued in a short period of time.
        :param pulumi.Input[float] max_concurrent_dispatches: The maximum number of concurrent tasks that Cloud Tasks allows to
               be dispatched for this queue. After this threshold has been
               reached, Cloud Tasks stops dispatching tasks until the number of
               concurrent requests decreases.
        :param pulumi.Input[float] max_dispatches_per_second: The maximum rate at which tasks are dispatched from this queue.
               If unspecified when the queue is created, Cloud Tasks will pick the default.
        """
        if max_burst_size is not None:
            pulumi.set(__self__, "max_burst_size", max_burst_size)
        if max_concurrent_dispatches is not None:
            pulumi.set(__self__, "max_concurrent_dispatches", max_concurrent_dispatches)
        if max_dispatches_per_second is not None:
            pulumi.set(__self__, "max_dispatches_per_second", max_dispatches_per_second)

    @property
    @pulumi.getter(name="maxBurstSize")
    def max_burst_size(self) -> Optional[pulumi.Input[float]]:
        """
        -
        The max burst size.
        Max burst size limits how fast tasks in queue are processed when many tasks are
        in the queue and the rate is high. This field allows the queue to have a high
        rate so processing starts shortly after a task is enqueued, but still limits
        resource usage when many tasks are enqueued in a short period of time.
        """
        return pulumi.get(self, "max_burst_size")

    @max_burst_size.setter
    def max_burst_size(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_burst_size", value)

    @property
    @pulumi.getter(name="maxConcurrentDispatches")
    def max_concurrent_dispatches(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum number of concurrent tasks that Cloud Tasks allows to
        be dispatched for this queue. After this threshold has been
        reached, Cloud Tasks stops dispatching tasks until the number of
        concurrent requests decreases.
        """
        return pulumi.get(self, "max_concurrent_dispatches")

    @max_concurrent_dispatches.setter
    def max_concurrent_dispatches(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_concurrent_dispatches", value)

    @property
    @pulumi.getter(name="maxDispatchesPerSecond")
    def max_dispatches_per_second(self) -> Optional[pulumi.Input[float]]:
        """
        The maximum rate at which tasks are dispatched from this queue.
        If unspecified when the queue is created, Cloud Tasks will pick the default.
        """
        return pulumi.get(self, "max_dispatches_per_second")

    @max_dispatches_per_second.setter
    def max_dispatches_per_second(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_dispatches_per_second", value)


@pulumi.input_type
class QueueRetryConfigArgs:
    def __init__(__self__, *,
                 max_attempts: Optional[pulumi.Input[float]] = None,
                 max_backoff: Optional[pulumi.Input[str]] = None,
                 max_doublings: Optional[pulumi.Input[float]] = None,
                 max_retry_duration: Optional[pulumi.Input[str]] = None,
                 min_backoff: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[float] max_attempts: Number of attempts per task.
               Cloud Tasks will attempt the task maxAttempts times (that is, if
               the first attempt fails, then there will be maxAttempts - 1
               retries). Must be >= -1.
               If unspecified when the queue is created, Cloud Tasks will pick
               the default.
               -1 indicates unlimited attempts.
        :param pulumi.Input[str] max_backoff: A task will be scheduled for retry between minBackoff and
               maxBackoff duration after it fails, if the queue's RetryConfig
               specifies that the task should be retried.
        :param pulumi.Input[float] max_doublings: The time between retries will double maxDoublings times.
               A task's retry interval starts at minBackoff, then doubles maxDoublings times,
               then increases linearly, and finally retries retries at intervals of maxBackoff
               up to maxAttempts times.
        :param pulumi.Input[str] max_retry_duration: If positive, maxRetryDuration specifies the time limit for
               retrying a failed task, measured from when the task was first
               attempted. Once maxRetryDuration time has passed and the task has
               been attempted maxAttempts times, no further attempts will be
               made and the task will be deleted.
               If zero, then the task age is unlimited.
        :param pulumi.Input[str] min_backoff: A task will be scheduled for retry between minBackoff and
               maxBackoff duration after it fails, if the queue's RetryConfig
               specifies that the task should be retried.
        """
        if max_attempts is not None:
            pulumi.set(__self__, "max_attempts", max_attempts)
        if max_backoff is not None:
            pulumi.set(__self__, "max_backoff", max_backoff)
        if max_doublings is not None:
            pulumi.set(__self__, "max_doublings", max_doublings)
        if max_retry_duration is not None:
            pulumi.set(__self__, "max_retry_duration", max_retry_duration)
        if min_backoff is not None:
            pulumi.set(__self__, "min_backoff", min_backoff)

    @property
    @pulumi.getter(name="maxAttempts")
    def max_attempts(self) -> Optional[pulumi.Input[float]]:
        """
        Number of attempts per task.
        Cloud Tasks will attempt the task maxAttempts times (that is, if
        the first attempt fails, then there will be maxAttempts - 1
        retries). Must be >= -1.
        If unspecified when the queue is created, Cloud Tasks will pick
        the default.
        -1 indicates unlimited attempts.
        """
        return pulumi.get(self, "max_attempts")

    @max_attempts.setter
    def max_attempts(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_attempts", value)

    @property
    @pulumi.getter(name="maxBackoff")
    def max_backoff(self) -> Optional[pulumi.Input[str]]:
        """
        A task will be scheduled for retry between minBackoff and
        maxBackoff duration after it fails, if the queue's RetryConfig
        specifies that the task should be retried.
        """
        return pulumi.get(self, "max_backoff")

    @max_backoff.setter
    def max_backoff(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_backoff", value)

    @property
    @pulumi.getter(name="maxDoublings")
    def max_doublings(self) -> Optional[pulumi.Input[float]]:
        """
        The time between retries will double maxDoublings times.
        A task's retry interval starts at minBackoff, then doubles maxDoublings times,
        then increases linearly, and finally retries retries at intervals of maxBackoff
        up to maxAttempts times.
        """
        return pulumi.get(self, "max_doublings")

    @max_doublings.setter
    def max_doublings(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "max_doublings", value)

    @property
    @pulumi.getter(name="maxRetryDuration")
    def max_retry_duration(self) -> Optional[pulumi.Input[str]]:
        """
        If positive, maxRetryDuration specifies the time limit for
        retrying a failed task, measured from when the task was first
        attempted. Once maxRetryDuration time has passed and the task has
        been attempted maxAttempts times, no further attempts will be
        made and the task will be deleted.
        If zero, then the task age is unlimited.
        """
        return pulumi.get(self, "max_retry_duration")

    @max_retry_duration.setter
    def max_retry_duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_retry_duration", value)

    @property
    @pulumi.getter(name="minBackoff")
    def min_backoff(self) -> Optional[pulumi.Input[str]]:
        """
        A task will be scheduled for retry between minBackoff and
        maxBackoff duration after it fails, if the queue's RetryConfig
        specifies that the task should be retried.
        """
        return pulumi.get(self, "min_backoff")

    @min_backoff.setter
    def min_backoff(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "min_backoff", value)


