# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['OrganizationSecurityPolicyRule']


class OrganizationSecurityPolicyRule(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direction: Optional[pulumi.Input[str]] = None,
                 enable_logging: Optional[pulumi.Input[bool]] = None,
                 match: Optional[pulumi.Input[pulumi.InputType['OrganizationSecurityPolicyRuleMatchArgs']]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 preview: Optional[pulumi.Input[bool]] = None,
                 priority: Optional[pulumi.Input[float]] = None,
                 target_resources: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 target_service_accounts: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Create a OrganizationSecurityPolicyRule resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The Action to perform when the client connection triggers the rule. Can currently be either
               "allow", "deny" or "goto_next".
        :param pulumi.Input[str] description: A description of the rule.
        :param pulumi.Input[str] direction: The direction in which this rule applies. If unspecified an INGRESS rule is created.
               Possible values are `INGRESS` and `EGRESS`.
        :param pulumi.Input[bool] enable_logging: Denotes whether to enable logging for a particular rule.
               If logging is enabled, logs will be exported to the
               configured export destination in Stackdriver.
        :param pulumi.Input[pulumi.InputType['OrganizationSecurityPolicyRuleMatchArgs']] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[str] policy_id: The ID of the OrganizationSecurityPolicy this rule applies to.
        :param pulumi.Input[bool] preview: If set to true, the specified action is not enforced.
        :param pulumi.Input[float] priority: An integer indicating the priority of a rule in the list. The priority must be a value
               between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the
               highest priority and 2147483647 is the lowest prority.
        :param pulumi.Input[List[pulumi.Input[str]]] target_resources: A list of network resource URLs to which this rule applies.
               This field allows you to control which network's VMs get
               this rule. If this field is left blank, all VMs
               within the organization will receive the rule.
        :param pulumi.Input[List[pulumi.Input[str]]] target_service_accounts: A list of service accounts indicating the sets of
               instances that are applied with this rule.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if action is None:
                raise TypeError("Missing required property 'action'")
            __props__['action'] = action
            __props__['description'] = description
            __props__['direction'] = direction
            __props__['enable_logging'] = enable_logging
            if match is None:
                raise TypeError("Missing required property 'match'")
            __props__['match'] = match
            if policy_id is None:
                raise TypeError("Missing required property 'policy_id'")
            __props__['policy_id'] = policy_id
            __props__['preview'] = preview
            if priority is None:
                raise TypeError("Missing required property 'priority'")
            __props__['priority'] = priority
            __props__['target_resources'] = target_resources
            __props__['target_service_accounts'] = target_service_accounts
        super(OrganizationSecurityPolicyRule, __self__).__init__(
            'gcp:compute/organizationSecurityPolicyRule:OrganizationSecurityPolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            direction: Optional[pulumi.Input[str]] = None,
            enable_logging: Optional[pulumi.Input[bool]] = None,
            match: Optional[pulumi.Input[pulumi.InputType['OrganizationSecurityPolicyRuleMatchArgs']]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            preview: Optional[pulumi.Input[bool]] = None,
            priority: Optional[pulumi.Input[float]] = None,
            target_resources: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None,
            target_service_accounts: Optional[pulumi.Input[List[pulumi.Input[str]]]] = None) -> 'OrganizationSecurityPolicyRule':
        """
        Get an existing OrganizationSecurityPolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The Action to perform when the client connection triggers the rule. Can currently be either
               "allow", "deny" or "goto_next".
        :param pulumi.Input[str] description: A description of the rule.
        :param pulumi.Input[str] direction: The direction in which this rule applies. If unspecified an INGRESS rule is created.
               Possible values are `INGRESS` and `EGRESS`.
        :param pulumi.Input[bool] enable_logging: Denotes whether to enable logging for a particular rule.
               If logging is enabled, logs will be exported to the
               configured export destination in Stackdriver.
        :param pulumi.Input[pulumi.InputType['OrganizationSecurityPolicyRuleMatchArgs']] match: A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
               Structure is documented below.
        :param pulumi.Input[str] policy_id: The ID of the OrganizationSecurityPolicy this rule applies to.
        :param pulumi.Input[bool] preview: If set to true, the specified action is not enforced.
        :param pulumi.Input[float] priority: An integer indicating the priority of a rule in the list. The priority must be a value
               between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the
               highest priority and 2147483647 is the lowest prority.
        :param pulumi.Input[List[pulumi.Input[str]]] target_resources: A list of network resource URLs to which this rule applies.
               This field allows you to control which network's VMs get
               this rule. If this field is left blank, all VMs
               within the organization will receive the rule.
        :param pulumi.Input[List[pulumi.Input[str]]] target_service_accounts: A list of service accounts indicating the sets of
               instances that are applied with this rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["action"] = action
        __props__["description"] = description
        __props__["direction"] = direction
        __props__["enable_logging"] = enable_logging
        __props__["match"] = match
        __props__["policy_id"] = policy_id
        __props__["preview"] = preview
        __props__["priority"] = priority
        __props__["target_resources"] = target_resources
        __props__["target_service_accounts"] = target_service_accounts
        return OrganizationSecurityPolicyRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        The Action to perform when the client connection triggers the rule. Can currently be either
        "allow", "deny" or "goto_next".
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[Optional[str]]:
        """
        The direction in which this rule applies. If unspecified an INGRESS rule is created.
        Possible values are `INGRESS` and `EGRESS`.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="enableLogging")
    def enable_logging(self) -> pulumi.Output[Optional[bool]]:
        """
        Denotes whether to enable logging for a particular rule.
        If logging is enabled, logs will be exported to the
        configured export destination in Stackdriver.
        """
        return pulumi.get(self, "enable_logging")

    @property
    @pulumi.getter
    def match(self) -> pulumi.Output['outputs.OrganizationSecurityPolicyRuleMatch']:
        """
        A match condition that incoming traffic is evaluated against. If it evaluates to true, the corresponding 'action' is enforced.
        Structure is documented below.
        """
        return pulumi.get(self, "match")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        The ID of the OrganizationSecurityPolicy this rule applies to.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def preview(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to true, the specified action is not enforced.
        """
        return pulumi.get(self, "preview")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[float]:
        """
        An integer indicating the priority of a rule in the list. The priority must be a value
        between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the
        highest priority and 2147483647 is the lowest prority.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter(name="targetResources")
    def target_resources(self) -> pulumi.Output[Optional[List[str]]]:
        """
        A list of network resource URLs to which this rule applies.
        This field allows you to control which network's VMs get
        this rule. If this field is left blank, all VMs
        within the organization will receive the rule.
        """
        return pulumi.get(self, "target_resources")

    @property
    @pulumi.getter(name="targetServiceAccounts")
    def target_service_accounts(self) -> pulumi.Output[Optional[List[str]]]:
        """
        A list of service accounts indicating the sets of
        instances that are applied with this rule.
        """
        return pulumi.get(self, "target_service_accounts")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

