# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['AutoscalingPolicy']


class AutoscalingPolicy(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 basic_algorithm: Optional[pulumi.Input[pulumi.InputType['AutoscalingPolicyBasicAlgorithmArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 secondary_worker_config: Optional[pulumi.Input[pulumi.InputType['AutoscalingPolicySecondaryWorkerConfigArgs']]] = None,
                 worker_config: Optional[pulumi.Input[pulumi.InputType['AutoscalingPolicyWorkerConfigArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Describes an autoscaling policy for Dataproc cluster autoscaler.

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AutoscalingPolicyBasicAlgorithmArgs']] basic_algorithm: Basic algorithm for autoscaling.
               Structure is documented below.
        :param pulumi.Input[str] location: The  location where the autoscaling poicy should reside.
               The default value is `global`.
        :param pulumi.Input[str] policy_id: The policy id. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
               and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
               3 and 50 characters.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['AutoscalingPolicySecondaryWorkerConfigArgs']] secondary_worker_config: Describes how the autoscaler will operate for secondary workers.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['AutoscalingPolicyWorkerConfigArgs']] worker_config: Describes how the autoscaler will operate for primary workers.
               Structure is documented below.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['basic_algorithm'] = basic_algorithm
            __props__['location'] = location
            if policy_id is None:
                raise TypeError("Missing required property 'policy_id'")
            __props__['policy_id'] = policy_id
            __props__['project'] = project
            __props__['secondary_worker_config'] = secondary_worker_config
            __props__['worker_config'] = worker_config
            __props__['name'] = None
        super(AutoscalingPolicy, __self__).__init__(
            'gcp:dataproc/autoscalingPolicy:AutoscalingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            basic_algorithm: Optional[pulumi.Input[pulumi.InputType['AutoscalingPolicyBasicAlgorithmArgs']]] = None,
            location: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            secondary_worker_config: Optional[pulumi.Input[pulumi.InputType['AutoscalingPolicySecondaryWorkerConfigArgs']]] = None,
            worker_config: Optional[pulumi.Input[pulumi.InputType['AutoscalingPolicyWorkerConfigArgs']]] = None) -> 'AutoscalingPolicy':
        """
        Get an existing AutoscalingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AutoscalingPolicyBasicAlgorithmArgs']] basic_algorithm: Basic algorithm for autoscaling.
               Structure is documented below.
        :param pulumi.Input[str] location: The  location where the autoscaling poicy should reside.
               The default value is `global`.
        :param pulumi.Input[str] name: The "resource name" of the autoscaling policy.
        :param pulumi.Input[str] policy_id: The policy id. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
               and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
               3 and 50 characters.
        :param pulumi.Input[str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[pulumi.InputType['AutoscalingPolicySecondaryWorkerConfigArgs']] secondary_worker_config: Describes how the autoscaler will operate for secondary workers.
               Structure is documented below.
        :param pulumi.Input[pulumi.InputType['AutoscalingPolicyWorkerConfigArgs']] worker_config: Describes how the autoscaler will operate for primary workers.
               Structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["basic_algorithm"] = basic_algorithm
        __props__["location"] = location
        __props__["name"] = name
        __props__["policy_id"] = policy_id
        __props__["project"] = project
        __props__["secondary_worker_config"] = secondary_worker_config
        __props__["worker_config"] = worker_config
        return AutoscalingPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="basicAlgorithm")
    def basic_algorithm(self) -> pulumi.Output[Optional['outputs.AutoscalingPolicyBasicAlgorithm']]:
        """
        Basic algorithm for autoscaling.
        Structure is documented below.
        """
        return pulumi.get(self, "basic_algorithm")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional[str]]:
        """
        The  location where the autoscaling poicy should reside.
        The default value is `global`.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The "resource name" of the autoscaling policy.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        The policy id. The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
        and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between
        3 and 50 characters.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="secondaryWorkerConfig")
    def secondary_worker_config(self) -> pulumi.Output[Optional['outputs.AutoscalingPolicySecondaryWorkerConfig']]:
        """
        Describes how the autoscaler will operate for secondary workers.
        Structure is documented below.
        """
        return pulumi.get(self, "secondary_worker_config")

    @property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> pulumi.Output[Optional['outputs.AutoscalingPolicyWorkerConfig']]:
        """
        Describes how the autoscaler will operate for primary workers.
        Structure is documented below.
        """
        return pulumi.get(self, "worker_config")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

