# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Dict, List, Mapping, Optional, Tuple, Union
from .. import _utilities, _tables
from . import outputs

__all__ = [
    'DatabaseInstanceIpAddress',
    'DatabaseInstanceReplicaConfiguration',
    'DatabaseInstanceServerCaCert',
    'DatabaseInstanceSettings',
    'DatabaseInstanceSettingsBackupConfiguration',
    'DatabaseInstanceSettingsDatabaseFlag',
    'DatabaseInstanceSettingsIpConfiguration',
    'DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork',
    'DatabaseInstanceSettingsLocationPreference',
    'DatabaseInstanceSettingsMaintenanceWindow',
    'GetCaCertsCertResult',
    'GetDatabaseInstanceIpAddressResult',
    'GetDatabaseInstanceReplicaConfigurationResult',
    'GetDatabaseInstanceServerCaCertResult',
    'GetDatabaseInstanceSettingResult',
    'GetDatabaseInstanceSettingBackupConfigurationResult',
    'GetDatabaseInstanceSettingDatabaseFlagResult',
    'GetDatabaseInstanceSettingIpConfigurationResult',
    'GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult',
    'GetDatabaseInstanceSettingLocationPreferenceResult',
    'GetDatabaseInstanceSettingMaintenanceWindowResult',
]

@pulumi.output_type
class DatabaseInstanceIpAddress(dict):
    def __init__(__self__, *,
                 ip_address: Optional[str] = None,
                 time_to_retire: Optional[str] = None,
                 type: Optional[str] = None):
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if time_to_retire is not None:
            pulumi.set(__self__, "time_to_retire", time_to_retire)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> Optional[str]:
        return pulumi.get(self, "time_to_retire")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseInstanceReplicaConfiguration(dict):
    def __init__(__self__, *,
                 ca_certificate: Optional[str] = None,
                 client_certificate: Optional[str] = None,
                 client_key: Optional[str] = None,
                 connect_retry_interval: Optional[float] = None,
                 dump_file_path: Optional[str] = None,
                 failover_target: Optional[bool] = None,
                 master_heartbeat_period: Optional[float] = None,
                 password: Optional[str] = None,
                 ssl_cipher: Optional[str] = None,
                 username: Optional[str] = None,
                 verify_server_certificate: Optional[bool] = None):
        """
        :param str ca_certificate: PEM representation of the trusted CA's x509
               certificate.
        :param str client_certificate: PEM representation of the slave's x509
               certificate.
        :param str client_key: PEM representation of the slave's private key. The
               corresponding public key in encoded in the `client_certificate`.
        :param float connect_retry_interval: The number of seconds
               between connect retries.
        :param str dump_file_path: Path to a SQL file in GCS from which slave
               instances are created. Format is `gs://bucket/filename`.
        :param bool failover_target: Specifies if the replica is the failover target.
               If the field is set to true the replica will be designated as a failover replica.
               If the master instance fails, the replica instance will be promoted as
               the new master instance.
        :param float master_heartbeat_period: Time in ms between replication
               heartbeats.
        :param str password: Password for the replication connection.
        :param str username: Username for replication connection.
        :param bool verify_server_certificate: True if the master's common name
               value is checked during the SSL handshake.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if connect_retry_interval is not None:
            pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        if dump_file_path is not None:
            pulumi.set(__self__, "dump_file_path", dump_file_path)
        if failover_target is not None:
            pulumi.set(__self__, "failover_target", failover_target)
        if master_heartbeat_period is not None:
            pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssl_cipher is not None:
            pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_server_certificate is not None:
            pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[str]:
        """
        PEM representation of the trusted CA's x509
        certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[str]:
        """
        PEM representation of the slave's x509
        certificate.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        """
        PEM representation of the slave's private key. The
        corresponding public key in encoded in the `client_certificate`.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> Optional[float]:
        """
        The number of seconds
        between connect retries.
        """
        return pulumi.get(self, "connect_retry_interval")

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> Optional[str]:
        """
        Path to a SQL file in GCS from which slave
        instances are created. Format is `gs://bucket/filename`.
        """
        return pulumi.get(self, "dump_file_path")

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> Optional[bool]:
        """
        Specifies if the replica is the failover target.
        If the field is set to true the replica will be designated as a failover replica.
        If the master instance fails, the replica instance will be promoted as
        the new master instance.
        """
        return pulumi.get(self, "failover_target")

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> Optional[float]:
        """
        Time in ms between replication
        heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> Optional[str]:
        return pulumi.get(self, "ssl_cipher")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> Optional[bool]:
        """
        True if the master's common name
        value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseInstanceServerCaCert(dict):
    def __init__(__self__, *,
                 cert: Optional[str] = None,
                 common_name: Optional[str] = None,
                 create_time: Optional[str] = None,
                 expiration_time: Optional[str] = None,
                 sha1_fingerprint: Optional[str] = None):
        """
        :param str expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if sha1_fingerprint is not None:
            pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> Optional[str]:
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[str]:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[str]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> Optional[str]:
        return pulumi.get(self, "sha1_fingerprint")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseInstanceSettings(dict):
    def __init__(__self__, *,
                 tier: str,
                 activation_policy: Optional[str] = None,
                 authorized_gae_applications: Optional[List[str]] = None,
                 availability_type: Optional[str] = None,
                 backup_configuration: Optional['outputs.DatabaseInstanceSettingsBackupConfiguration'] = None,
                 crash_safe_replication: Optional[bool] = None,
                 database_flags: Optional[List['outputs.DatabaseInstanceSettingsDatabaseFlag']] = None,
                 disk_autoresize: Optional[bool] = None,
                 disk_size: Optional[float] = None,
                 disk_type: Optional[str] = None,
                 ip_configuration: Optional['outputs.DatabaseInstanceSettingsIpConfiguration'] = None,
                 location_preference: Optional['outputs.DatabaseInstanceSettingsLocationPreference'] = None,
                 maintenance_window: Optional['outputs.DatabaseInstanceSettingsMaintenanceWindow'] = None,
                 pricing_plan: Optional[str] = None,
                 replication_type: Optional[str] = None,
                 user_labels: Optional[Mapping[str, str]] = None,
                 version: Optional[float] = None):
        """
        :param str tier: The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
               for more details and supported versions. Postgres supports only shared-core machine types such as `db-f1-micro`,
               and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        :param str activation_policy: This specifies when the instance should be
               active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        :param List[str] authorized_gae_applications: This property is only applicable to First Generation instances.
               First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
               for information on how to upgrade to Second Generation instances.
               A list of Google App Engine (GAE) project names that are allowed to access this instance.
        :param str availability_type: The availability type of the Cloud SQL
               instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For MySQL
               instances, ensure that `settings.backup_configuration.enabled` and
               `settings.backup_configuration.binary_log_enabled` are both set to `true`.
        :param bool crash_safe_replication: This property is only applicable to First Generation instances.
               First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
               for information on how to upgrade to Second Generation instances.
               Specific to read instances, indicates
               when crash-safe replication flags are enabled.
        :param bool disk_autoresize: Configuration to increase storage size automatically.  Note that future `pulumi apply` calls will attempt to resize the disk to the value specified in `disk_size` - if this is set, do not set `disk_size`.
        :param float disk_size: The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased.
        :param str disk_type: The type of data disk: PD_SSD or PD_HDD.
        :param str pricing_plan: Pricing plan for this instance, can only be `PER_USE`.
        :param str replication_type: This property is only applicable to First Generation instances.
               First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
               for information on how to upgrade to Second Generation instances.
               Replication type for this instance, can be one of `ASYNCHRONOUS` or `SYNCHRONOUS`.
        :param Mapping[str, str] user_labels: A set of key/value user label pairs to assign to the instance.
        """
        pulumi.set(__self__, "tier", tier)
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if authorized_gae_applications is not None:
            pulumi.set(__self__, "authorized_gae_applications", authorized_gae_applications)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if crash_safe_replication is not None:
            pulumi.set(__self__, "crash_safe_replication", crash_safe_replication)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if disk_autoresize is not None:
            pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if location_preference is not None:
            pulumi.set(__self__, "location_preference", location_preference)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if pricing_plan is not None:
            pulumi.set(__self__, "pricing_plan", pricing_plan)
        if replication_type is not None:
            pulumi.set(__self__, "replication_type", replication_type)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
        for more details and supported versions. Postgres supports only shared-core machine types such as `db-f1-micro`,
        and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[str]:
        """
        This specifies when the instance should be
        active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        """
        return pulumi.get(self, "activation_policy")

    @property
    @pulumi.getter(name="authorizedGaeApplications")
    def authorized_gae_applications(self) -> Optional[List[str]]:
        """
        This property is only applicable to First Generation instances.
        First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        for information on how to upgrade to Second Generation instances.
        A list of Google App Engine (GAE) project names that are allowed to access this instance.
        """
        return pulumi.get(self, "authorized_gae_applications")

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[str]:
        """
        The availability type of the Cloud SQL
        instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For MySQL
        instances, ensure that `settings.backup_configuration.enabled` and
        `settings.backup_configuration.binary_log_enabled` are both set to `true`.
        """
        return pulumi.get(self, "availability_type")

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional['outputs.DatabaseInstanceSettingsBackupConfiguration']:
        return pulumi.get(self, "backup_configuration")

    @property
    @pulumi.getter(name="crashSafeReplication")
    def crash_safe_replication(self) -> Optional[bool]:
        """
        This property is only applicable to First Generation instances.
        First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        for information on how to upgrade to Second Generation instances.
        Specific to read instances, indicates
        when crash-safe replication flags are enabled.
        """
        return pulumi.get(self, "crash_safe_replication")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[List['outputs.DatabaseInstanceSettingsDatabaseFlag']]:
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> Optional[bool]:
        """
        Configuration to increase storage size automatically.  Note that future `pulumi apply` calls will attempt to resize the disk to the value specified in `disk_size` - if this is set, do not set `disk_size`.
        """
        return pulumi.get(self, "disk_autoresize")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[float]:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        The type of data disk: PD_SSD or PD_HDD.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional['outputs.DatabaseInstanceSettingsIpConfiguration']:
        return pulumi.get(self, "ip_configuration")

    @property
    @pulumi.getter(name="locationPreference")
    def location_preference(self) -> Optional['outputs.DatabaseInstanceSettingsLocationPreference']:
        return pulumi.get(self, "location_preference")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional['outputs.DatabaseInstanceSettingsMaintenanceWindow']:
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional[str]:
        """
        Pricing plan for this instance, can only be `PER_USE`.
        """
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> Optional[str]:
        """
        This property is only applicable to First Generation instances.
        First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        for information on how to upgrade to Second Generation instances.
        Replication type for this instance, can be one of `ASYNCHRONOUS` or `SYNCHRONOUS`.
        """
        return pulumi.get(self, "replication_type")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[Mapping[str, str]]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter
    def version(self) -> Optional[float]:
        return pulumi.get(self, "version")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseInstanceSettingsBackupConfiguration(dict):
    def __init__(__self__, *,
                 binary_log_enabled: Optional[bool] = None,
                 enabled: Optional[bool] = None,
                 location: Optional[str] = None,
                 point_in_time_recovery_enabled: Optional[bool] = None,
                 start_time: Optional[str] = None):
        """
        :param bool binary_log_enabled: True if binary logging is enabled. If
               `settings.backup_configuration.enabled` is false, this must be as well.
               Cannot be used with Postgres.
        :param bool enabled: True if backup configuration is enabled.
        :param bool point_in_time_recovery_enabled: True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation.
        :param str start_time: `HH:MM` format time indicating when backup
               configuration starts.
        """
        if binary_log_enabled is not None:
            pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if point_in_time_recovery_enabled is not None:
            pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> Optional[bool]:
        """
        True if binary logging is enabled. If
        `settings.backup_configuration.enabled` is false, this must be as well.
        Cannot be used with Postgres.
        """
        return pulumi.get(self, "binary_log_enabled")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[bool]:
        """
        True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        `HH:MM` format time indicating when backup
        configuration starts.
        """
        return pulumi.get(self, "start_time")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseInstanceSettingsDatabaseFlag(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: A name for this whitelist entry.
        :param str value: A CIDR notation IPv4 or IPv6 address that is allowed to
               access this instance. Must be set even if other two attributes are not for
               the whitelist to become active.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseInstanceSettingsIpConfiguration(dict):
    def __init__(__self__, *,
                 authorized_networks: Optional[List['outputs.DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork']] = None,
                 ipv4_enabled: Optional[bool] = None,
                 private_network: Optional[str] = None,
                 require_ssl: Optional[bool] = None):
        """
        :param bool ipv4_enabled: Whether this Cloud SQL instance should be assigned
               a public IPV4 address. Either `ipv4_enabled` must be enabled or a
               `private_network` must be configured.
        :param str private_network: The VPC network from which the Cloud SQL
               instance is accessible for private IP. For example, projects/myProject/global/networks/default.
               Specifying a network enables private IP.
               Either `ipv4_enabled` must be enabled or a `private_network` must be configured.
               This setting can be updated, but it cannot be removed after it is set.
        :param bool require_ssl: True if mysqld should default to `REQUIRE X509`
               for users connecting over IP.
        """
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if require_ssl is not None:
            pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[List['outputs.DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork']]:
        return pulumi.get(self, "authorized_networks")

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[bool]:
        """
        Whether this Cloud SQL instance should be assigned
        a public IPV4 address. Either `ipv4_enabled` must be enabled or a
        `private_network` must be configured.
        """
        return pulumi.get(self, "ipv4_enabled")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[str]:
        """
        The VPC network from which the Cloud SQL
        instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        Specifying a network enables private IP.
        Either `ipv4_enabled` must be enabled or a `private_network` must be configured.
        This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> Optional[bool]:
        """
        True if mysqld should default to `REQUIRE X509`
        for users connecting over IP.
        """
        return pulumi.get(self, "require_ssl")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork(dict):
    def __init__(__self__, *,
                 value: str,
                 expiration_time: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str value: A CIDR notation IPv4 or IPv6 address that is allowed to
               access this instance. Must be set even if other two attributes are not for
               the whitelist to become active.
        :param str expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        :param str name: A name for this whitelist entry.
        """
        pulumi.set(__self__, "value", value)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[str]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseInstanceSettingsLocationPreference(dict):
    def __init__(__self__, *,
                 follow_gae_application: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param str follow_gae_application: A GAE application whose zone to remain
               in. Must be in the same region as this instance.
        :param str zone: The preferred compute engine
               [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        if follow_gae_application is not None:
            pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> Optional[str]:
        """
        A GAE application whose zone to remain
        in. Must be in the same region as this instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        The preferred compute engine
        [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        return pulumi.get(self, "zone")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DatabaseInstanceSettingsMaintenanceWindow(dict):
    def __init__(__self__, *,
                 day: Optional[float] = None,
                 hour: Optional[float] = None,
                 update_track: Optional[str] = None):
        """
        :param float day: Day of week (`1-7`), starting on Monday
        :param float hour: Hour of day (`0-23`), ignored if `day` not set
        :param str update_track: Receive updates earlier (`canary`) or later
               (`stable`)
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if update_track is not None:
            pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> Optional[float]:
        """
        Day of week (`1-7`), starting on Monday
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> Optional[float]:
        """
        Hour of day (`0-23`), ignored if `day` not set
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> Optional[str]:
        """
        Receive updates earlier (`canary`) or later
        (`stable`)
        """
        return pulumi.get(self, "update_track")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GetCaCertsCertResult(dict):
    def __init__(__self__, *,
                 cert: str,
                 common_name: str,
                 create_time: str,
                 expiration_time: str,
                 sha1_fingerprint: str):
        """
        :param str cert: The CA certificate used to connect to the SQL instance via SSL.
        :param str common_name: The CN valid for the CA cert.
        :param str create_time: Creation time of the CA cert.
        :param str expiration_time: Expiration time of the CA cert.
        :param str sha1_fingerprint: SHA1 fingerprint of the CA cert.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> str:
        """
        The CA certificate used to connect to the SQL instance via SSL.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        """
        The CN valid for the CA cert.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Creation time of the CA cert.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        Expiration time of the CA cert.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> str:
        """
        SHA1 fingerprint of the CA cert.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetDatabaseInstanceIpAddressResult(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 time_to_retire: str,
                 type: str):
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "time_to_retire", time_to_retire)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> str:
        return pulumi.get(self, "time_to_retire")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseInstanceReplicaConfigurationResult(dict):
    def __init__(__self__, *,
                 ca_certificate: str,
                 client_certificate: str,
                 client_key: str,
                 connect_retry_interval: float,
                 dump_file_path: str,
                 failover_target: bool,
                 master_heartbeat_period: float,
                 password: str,
                 ssl_cipher: str,
                 username: str,
                 verify_server_certificate: bool):
        """
        :param str ca_certificate: PEM representation of the trusted CA's x509 certificate.
        :param str client_certificate: PEM representation of the slave's x509 certificate.
        :param str client_key: PEM representation of the slave's private key.
        :param float connect_retry_interval: The number of seconds between connect retries.
        :param str dump_file_path: Path to a SQL file in GCS from which slave instances are created.
        :param bool failover_target: Specifies if the replica is the failover target.
        :param float master_heartbeat_period: Time in ms between replication heartbeats.
        :param str password: Password for the replication connection.
        :param str username: Username for replication connection.
        :param bool verify_server_certificate: True if the master's common name value is checked during the SSL handshake.
        """
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        pulumi.set(__self__, "dump_file_path", dump_file_path)
        pulumi.set(__self__, "failover_target", failover_target)
        pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        """
        PEM representation of the trusted CA's x509 certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        """
        PEM representation of the slave's x509 certificate.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        PEM representation of the slave's private key.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> float:
        """
        The number of seconds between connect retries.
        """
        return pulumi.get(self, "connect_retry_interval")

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> str:
        """
        Path to a SQL file in GCS from which slave instances are created.
        """
        return pulumi.get(self, "dump_file_path")

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> bool:
        """
        Specifies if the replica is the failover target.
        """
        return pulumi.get(self, "failover_target")

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> float:
        """
        Time in ms between replication heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> str:
        return pulumi.get(self, "ssl_cipher")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> bool:
        """
        True if the master's common name value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")


@pulumi.output_type
class GetDatabaseInstanceServerCaCertResult(dict):
    def __init__(__self__, *,
                 cert: str,
                 common_name: str,
                 create_time: str,
                 expiration_time: str,
                 sha1_fingerprint: str):
        """
        :param str expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> str:
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> str:
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetDatabaseInstanceSettingResult(dict):
    def __init__(__self__, *,
                 activation_policy: str,
                 authorized_gae_applications: List[str],
                 availability_type: str,
                 backup_configurations: List['outputs.GetDatabaseInstanceSettingBackupConfigurationResult'],
                 crash_safe_replication: bool,
                 database_flags: List['outputs.GetDatabaseInstanceSettingDatabaseFlagResult'],
                 disk_autoresize: bool,
                 disk_size: float,
                 disk_type: str,
                 ip_configurations: List['outputs.GetDatabaseInstanceSettingIpConfigurationResult'],
                 location_preferences: List['outputs.GetDatabaseInstanceSettingLocationPreferenceResult'],
                 maintenance_windows: List['outputs.GetDatabaseInstanceSettingMaintenanceWindowResult'],
                 pricing_plan: str,
                 replication_type: str,
                 tier: str,
                 user_labels: Mapping[str, str],
                 version: float):
        """
        :param str activation_policy: This specifies when the instance should be
               active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        :param List[str] authorized_gae_applications: (Deprecated) This property is only applicable to First Generation instances.
               First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
               for information on how to upgrade to Second Generation instances.
               A list of Google App Engine (GAE) project names that are allowed to access this instance.
        :param str availability_type: The availability type of the Cloud SQL
               instance, high availability (`REGIONAL`) or single zone (`ZONAL`).
        :param bool crash_safe_replication: (Deprecated) This property is only applicable to First Generation instances.
               First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        :param bool disk_autoresize: Configuration to increase storage size automatically.
        :param float disk_size: The size of data disk, in GB.
        :param str disk_type: The type of data disk.
        :param str pricing_plan: Pricing plan for this instance.
        :param str replication_type: This property is only applicable to First Generation instances.
               First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        :param str tier: The machine type to use.
        :param Mapping[str, str] user_labels: A set of key/value user label pairs to assign to the instance.
        """
        pulumi.set(__self__, "activation_policy", activation_policy)
        pulumi.set(__self__, "authorized_gae_applications", authorized_gae_applications)
        pulumi.set(__self__, "availability_type", availability_type)
        pulumi.set(__self__, "backup_configurations", backup_configurations)
        pulumi.set(__self__, "crash_safe_replication", crash_safe_replication)
        pulumi.set(__self__, "database_flags", database_flags)
        pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "location_preferences", location_preferences)
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        pulumi.set(__self__, "pricing_plan", pricing_plan)
        pulumi.set(__self__, "replication_type", replication_type)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "user_labels", user_labels)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> str:
        """
        This specifies when the instance should be
        active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        """
        return pulumi.get(self, "activation_policy")

    @property
    @pulumi.getter(name="authorizedGaeApplications")
    def authorized_gae_applications(self) -> List[str]:
        """
        (Deprecated) This property is only applicable to First Generation instances.
        First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        for information on how to upgrade to Second Generation instances.
        A list of Google App Engine (GAE) project names that are allowed to access this instance.
        """
        return pulumi.get(self, "authorized_gae_applications")

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> str:
        """
        The availability type of the Cloud SQL
        instance, high availability (`REGIONAL`) or single zone (`ZONAL`).
        """
        return pulumi.get(self, "availability_type")

    @property
    @pulumi.getter(name="backupConfigurations")
    def backup_configurations(self) -> List['outputs.GetDatabaseInstanceSettingBackupConfigurationResult']:
        return pulumi.get(self, "backup_configurations")

    @property
    @pulumi.getter(name="crashSafeReplication")
    def crash_safe_replication(self) -> bool:
        """
        (Deprecated) This property is only applicable to First Generation instances.
        First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        """
        return pulumi.get(self, "crash_safe_replication")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> List['outputs.GetDatabaseInstanceSettingDatabaseFlagResult']:
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> bool:
        """
        Configuration to increase storage size automatically.
        """
        return pulumi.get(self, "disk_autoresize")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> float:
        """
        The size of data disk, in GB.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        The type of data disk.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> List['outputs.GetDatabaseInstanceSettingIpConfigurationResult']:
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter(name="locationPreferences")
    def location_preferences(self) -> List['outputs.GetDatabaseInstanceSettingLocationPreferenceResult']:
        return pulumi.get(self, "location_preferences")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> List['outputs.GetDatabaseInstanceSettingMaintenanceWindowResult']:
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> str:
        """
        Pricing plan for this instance.
        """
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> str:
        """
        This property is only applicable to First Generation instances.
        First Generation instances are now deprecated, see [here](https://cloud.google.com/sql/docs/mysql/upgrade-2nd-gen)
        """
        return pulumi.get(self, "replication_type")

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The machine type to use.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, str]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter
    def version(self) -> float:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDatabaseInstanceSettingBackupConfigurationResult(dict):
    def __init__(__self__, *,
                 binary_log_enabled: bool,
                 enabled: bool,
                 location: str,
                 point_in_time_recovery_enabled: bool,
                 start_time: str):
        """
        :param bool binary_log_enabled: True if binary logging is enabled.
        :param bool enabled: True if backup configuration is enabled.
        :param str start_time: `HH:MM` format time indicating when backup configuration starts.
        """
        pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> bool:
        """
        True if binary logging is enabled.
        """
        return pulumi.get(self, "binary_log_enabled")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> bool:
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        `HH:MM` format time indicating when backup configuration starts.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class GetDatabaseInstanceSettingDatabaseFlagResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the instance.
        :param str value: A CIDR notation IPv4 or IPv6 address that is allowed to access this instance.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to access this instance.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationResult(dict):
    def __init__(__self__, *,
                 authorized_networks: List['outputs.GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult'],
                 ipv4_enabled: bool,
                 private_network: str,
                 require_ssl: bool):
        """
        :param bool ipv4_enabled: Whether this Cloud SQL instance should be assigned a public IPV4 address.
        :param str private_network: The VPC network from which the Cloud SQL instance is accessible for private IP.
        :param bool require_ssl: True if mysqld default to `REQUIRE X509` for users connecting over IP.
        """
        pulumi.set(__self__, "authorized_networks", authorized_networks)
        pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        pulumi.set(__self__, "private_network", private_network)
        pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> List['outputs.GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult']:
        return pulumi.get(self, "authorized_networks")

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> bool:
        """
        Whether this Cloud SQL instance should be assigned a public IPV4 address.
        """
        return pulumi.get(self, "ipv4_enabled")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> str:
        """
        The VPC network from which the Cloud SQL instance is accessible for private IP.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> bool:
        """
        True if mysqld default to `REQUIRE X509` for users connecting over IP.
        """
        return pulumi.get(self, "require_ssl")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult(dict):
    def __init__(__self__, *,
                 expiration_time: str,
                 name: str,
                 value: str):
        """
        :param str expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        :param str name: The name of the instance.
        :param str value: A CIDR notation IPv4 or IPv6 address that is allowed to access this instance.
        """
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to access this instance.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstanceSettingLocationPreferenceResult(dict):
    def __init__(__self__, *,
                 follow_gae_application: str,
                 zone: str):
        """
        :param str follow_gae_application: A GAE application whose zone to remain in.
        :param str zone: The preferred compute engine.
        """
        pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> str:
        """
        A GAE application whose zone to remain in.
        """
        return pulumi.get(self, "follow_gae_application")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The preferred compute engine.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDatabaseInstanceSettingMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: float,
                 hour: float,
                 update_track: str):
        """
        :param float day: Day of week (`1-7`), starting on Monday.
        :param float hour: Hour of day (`0-23`), ignored if `day` not set.
        :param str update_track: Receive updates earlier (`canary`) or later (`stable`).
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> float:
        """
        Day of week (`1-7`), starting on Monday.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> float:
        """
        Hour of day (`0-23`), ignored if `day` not set.
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> str:
        """
        Receive updates earlier (`canary`) or later (`stable`).
        """
        return pulumi.get(self, "update_track")


