"""
Tools for rhythm construction.
"""
from . import helpers
from ._version import __version__, __version_info__
from .commands import (
    BeamCommand,
    BeamGroupsCommand,
    CacheStateCommand,
    Command,
    FeatherBeamCommand,
    ForceNoteCommand,
    ForceRestCommand,
    GraceContainerCommand,
    InvisibleMusicCommand,
    RewriteMeterCommand,
    RewriteSustainedCommand,
    SplitMeasuresCommand,
    TieCommand,
    TremoloContainerCommand,
    UnbeamCommand,
    WrittenDurationCommand,
    after_grace_container,
    beam,
    beam_groups,
    before_grace_container,
    cache_state,
    denominator,
    duration_bracket,
    extract_trivial,
    feather_beam,
    force_augmentation,
    force_diminution,
    force_fraction,
    force_note,
    force_repeat_tie,
    force_rest,
    invisible_music,
    on_beat_grace_container,
    reduce_multiplier,
    repeat_tie,
    rewrite_dots,
    rewrite_meter,
    rewrite_rest_filled,
    rewrite_sustained,
    split_measures,
    tie,
    tremolo_container,
    trivialize,
    unbeam,
    untie,
    written_duration,
)
from .makers import (
    AccelerandoRhythmMaker,
    EvenDivisionRhythmMaker,
    IncisedRhythmMaker,
    MultipliedDurationRhythmMaker,
    NoteRhythmMaker,
    RhythmMaker,
    TaleaRhythmMaker,
    TupletRhythmMaker,
    accelerando,
    even_division,
    incised,
    multiplied_duration,
    note,
    talea,
    tuplet,
)
from .specifiers import Incise, Interpolation, Spelling, Talea, interpolate
from .stack import Assignment, Bind, Match, Stack, assign, bind, stack

__all__ = [
    "__version__",
    "__version_info__",
    "helpers",
    # commands:
    "BeamCommand",
    "BeamGroupsCommand",
    "CacheStateCommand",
    "Command",
    "FeatherBeamCommand",
    "ForceNoteCommand",
    "ForceRestCommand",
    "GraceContainerCommand",
    "InvisibleMusicCommand",
    "RewriteMeterCommand",
    "RewriteSustainedCommand",
    "SplitMeasuresCommand",
    "TieCommand",
    "TremoloContainerCommand",
    "UnbeamCommand",
    "WrittenDurationCommand",
    "after_grace_container",
    "beam",
    "beam_groups",
    "before_grace_container",
    "cache_state",
    "denominator",
    "duration_bracket",
    "extract_trivial",
    "feather_beam",
    "force_augmentation",
    "force_diminution",
    "force_fraction",
    "force_note",
    "force_repeat_tie",
    "force_rest",
    "invisible_music",
    "on_beat_grace_container",
    "reduce_multiplier",
    "repeat_tie",
    "rewrite_dots",
    "rewrite_meter",
    "rewrite_rest_filled",
    "rewrite_sustained",
    "split_measures",
    "tie",
    "tremolo_container",
    "trivialize",
    "unbeam",
    "untie",
    "written_duration",
    # makers:
    "AccelerandoRhythmMaker",
    "EvenDivisionRhythmMaker",
    "IncisedRhythmMaker",
    "MultipliedDurationRhythmMaker",
    "NoteRhythmMaker",
    "RhythmMaker",
    "TaleaRhythmMaker",
    "TupletRhythmMaker",
    "accelerando",
    "even_division",
    "incised",
    "multiplied_duration",
    "note",
    "talea",
    "tuplet",
    # specifiers:
    "Incise",
    "Interpolation",
    "Spelling",
    "Talea",
    "interpolate",
    # stack:
    "Assignment",
    "Bind",
    "Match",
    "Stack",
    "assign",
    "bind",
    "stack",
]
